//
// C++ Interface: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef REGEXPSTATEBUILDER_H
#define REGEXPSTATEBUILDER_H

#include <regexpstate.h>

#line 17 "regexpstatebuilder.h"
class RegExpStatePointer
{
  public:
    RegExpStatePtr regExpStatePtr;
    RegExpStatePointer(RegExpStatePtr r) : regExpStatePtr(r) {}
    operator RegExpStatePtr() const { return regExpStatePtr; }
    RegExpStatePtr::element_type * operator->() const { return regExpStatePtr.operator->(); }
};

/**
build a RegExpState starting from language definitions

@author Lorenzo Bettini
*/
// doublecpp: forward declarations, DO NOT MODIFY
class DelimitedLangElem; // file: delimitedlangelem.h
class LangElem; // file: langelem.h
class LangElems; // file: langelems.h
class RegExpStatePointer; // file: regexpstatebuilder.h
class StateLangElem; // file: statelangelem.h
class StateStartLangElem; // file: statestartlangelem.h
class StringListLangElem; // file: stringlistlangelem.h
// doublecpp: end, DO NOT MODIFY

#line 30 "regexpstatebuilder.h"
class RegExpStateBuilder
{
  protected:
    // the following will be processed by doublecpp
// doublecpp: method branches, DO NOT MODIFY
#line 35 "regexpstatebuilder.h"
virtual void build(StateLangElem * elem, RegExpStatePointer state);
#line 36 "regexpstatebuilder.h"
virtual void build(StringListLangElem * elem, RegExpStatePointer state);
#line 37 "regexpstatebuilder.h"
virtual void build(DelimitedLangElem * elem, RegExpStatePointer state);
#line 38 "regexpstatebuilder.h"
virtual void build(StateStartLangElem * elem, RegExpStatePointer state);
#line 39 "regexpstatebuilder.h"
virtual void build(LangElem * elem, RegExpStatePointer state);
#line 40 "regexpstatebuilder.h"
virtual void build(LangElems * elems, RegExpStatePointer state);
public:
void _forward_build(DelimitedLangElem * elem, RegExpStatePointer state)
{
  build(elem, state);
};

void _forward_build(LangElem * elem, RegExpStatePointer state)
{
  build(elem, state);
};

void _forward_build(LangElems * elems, RegExpStatePointer state)
{
  build(elems, state);
};

void _forward_build(StateLangElem * elem, RegExpStatePointer state)
{
  build(elem, state);
};

void _forward_build(StateStartLangElem * elem, RegExpStatePointer state)
{
  build(elem, state);
};

void _forward_build(StringListLangElem * elem, RegExpStatePointer state)
{
  build(elem, state);
};

protected:
virtual void build_DB(LangElem * elem, RegExpStatePointer state);
virtual void build_DB(LangElems * elems, RegExpStatePointer state);
#line 40 "regexpstatebuilder.h"
// doublecpp: end, DO NOT MODIFY


  public:
    RegExpStateBuilder();

    virtual ~RegExpStateBuilder();

    RegExpStatePtr build(LangElems *elems);
};

#endif
