/*
** Copyright (C) 1999, 2000, 2002 Lorenzo Bettini <bettini@gnu.org>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/

// factory for HTML generators using CSS

#ifndef CSSGENERATORFACTORY_H
#define CSSGENERATORFACTORY_H

#include "htmlgeneratorfactory.h"

class CssGeneratorFactory : public HtmlGeneratorFactory
{
 protected:
  virtual TextGenerator *createBoldDecorator(TextGenerator *);
  virtual TextGenerator *createItalicDecorator(TextGenerator *);
  virtual TextGenerator *createUnderlineDecorator(TextGenerator *);
  virtual TextGenerator *createColorDecorator(TextGenerator *, const string &color);

  virtual TextGenerator *createGenerator(TextGenerator *final_dec, const string &key);

 public:
  CssGeneratorFactory(bool line_number, const string &t, const string &input,
                       const string &header, const string &foot, const string &css) :
    HtmlGeneratorFactory (line_number, t, input, header, foot, css) {}
};

#endif // CSSGENERATORFACTORY_H
