/* 
   This file is public domain.

   The data is a matter of public record, and comes from
   http://www.dp-praha.cz
 */


DROP TABLE sqltutor.zastavky CASCADE;
DROP TABLE sqltutor.linky    CASCADE;

CREATE TABLE sqltutor.zastavky (
        id       INTEGER PRIMARY KEY,
        zastavka VARCHAR(30)
);

CREATE TABLE sqltutor.linky (
        linka       INTEGER,
        smer        INTEGER CHECK (smer IN (1, 2)),
        poradi      INTEGER,
        zastavka_id INTEGER REFERENCES sqltutor.zastavky(id) NOT NULL,
        PRIMARY KEY (linka, smer, poradi)
);

BEGIN;

INSERT INTO sqltutor.zastavky VALUES (1, 'Albertov');
INSERT INTO sqltutor.zastavky VALUES (2, 'Anděl');
INSERT INTO sqltutor.zastavky VALUES (3, 'Arbesovo náměstí');
INSERT INTO sqltutor.zastavky VALUES (4, 'Balabenka');
INSERT INTO sqltutor.zastavky VALUES (5, 'Baterie');
INSERT INTO sqltutor.zastavky VALUES (6, 'Belárie');
INSERT INTO sqltutor.zastavky VALUES (7, 'Bertramka');
INSERT INTO sqltutor.zastavky VALUES (8, 'Bílá Hora');
INSERT INTO sqltutor.zastavky VALUES (9, 'Bílá labuť');
INSERT INTO sqltutor.zastavky VALUES (10, 'Biskupcova');
INSERT INTO sqltutor.zastavky VALUES (11, 'Blatiny');
INSERT INTO sqltutor.zastavky VALUES (12, 'Bořislavka');
INSERT INTO sqltutor.zastavky VALUES (13, 'Botanická zahrada');
INSERT INTO sqltutor.zastavky VALUES (14, 'Braunova');
INSERT INTO sqltutor.zastavky VALUES (15, 'Břevnovský klášter');
INSERT INTO sqltutor.zastavky VALUES (16, 'Březiněveská');
INSERT INTO sqltutor.zastavky VALUES (17, 'Bruselská');
INSERT INTO sqltutor.zastavky VALUES (18, 'Brusnice');
INSERT INTO sqltutor.zastavky VALUES (19, 'Bulovka');
INSERT INTO sqltutor.zastavky VALUES (20, 'Čechova čtvrť');
INSERT INTO sqltutor.zastavky VALUES (21, 'Čechovo náměstí');
INSERT INTO sqltutor.zastavky VALUES (22, 'Čechův most');
INSERT INTO sqltutor.zastavky VALUES (23, 'Černokostelecká');
INSERT INTO sqltutor.zastavky VALUES (24, 'Černý kůň');
INSERT INTO sqltutor.zastavky VALUES (25, 'Červený Vrch');
INSERT INTO sqltutor.zastavky VALUES (26, 'Chaplinovo náměstí');
INSERT INTO sqltutor.zastavky VALUES (27, 'Chmelnice');
INSERT INTO sqltutor.zastavky VALUES (28, 'Chodovská');
INSERT INTO sqltutor.zastavky VALUES (29, 'Chotkovy sady');
INSERT INTO sqltutor.zastavky VALUES (30, 'ČSAD Smíchov');
INSERT INTO sqltutor.zastavky VALUES (31, 'Dejvická');
INSERT INTO sqltutor.zastavky VALUES (32, 'Dělnická');
INSERT INTO sqltutor.zastavky VALUES (33, 'Depo Hostivař');
INSERT INTO sqltutor.zastavky VALUES (34, 'Divadlo Na Fidlovačce');
INSERT INTO sqltutor.zastavky VALUES (35, 'Divadlo Pod Palmovkou');
INSERT INTO sqltutor.zastavky VALUES (36, 'Divoká Šárka');
INSERT INTO sqltutor.zastavky VALUES (37, 'Dlouhá třída');
INSERT INTO sqltutor.zastavky VALUES (38, 'Drinopol');
INSERT INTO sqltutor.zastavky VALUES (39, 'Dvorce');
INSERT INTO sqltutor.zastavky VALUES (40, 'Flora');
INSERT INTO sqltutor.zastavky VALUES (41, 'Florenc');
INSERT INTO sqltutor.zastavky VALUES (42, 'Geologická');
INSERT INTO sqltutor.zastavky VALUES (43, 'Hadovka');
INSERT INTO sqltutor.zastavky VALUES (44, 'Hellichova');
INSERT INTO sqltutor.zastavky VALUES (45, 'Hercovka');
INSERT INTO sqltutor.zastavky VALUES (46, 'Hlavní nádraží');
INSERT INTO sqltutor.zastavky VALUES (47, 'Hloubětín');
INSERT INTO sqltutor.zastavky VALUES (48, 'Hlubočepy');
INSERT INTO sqltutor.zastavky VALUES (49, 'Hlušičkova');
INSERT INTO sqltutor.zastavky VALUES (50, 'Horky');
INSERT INTO sqltutor.zastavky VALUES (51, 'Horoměřická');
INSERT INTO sqltutor.zastavky VALUES (52, 'Hostivařská');
INSERT INTO sqltutor.zastavky VALUES (53, 'Hotel Golf');
INSERT INTO sqltutor.zastavky VALUES (54, 'Hradčanská');
INSERT INTO sqltutor.zastavky VALUES (55, 'Husinecká');
INSERT INTO sqltutor.zastavky VALUES (56, 'Invalidovna');
INSERT INTO sqltutor.zastavky VALUES (57, 'I. P. Pavlova');
INSERT INTO sqltutor.zastavky VALUES (58, 'Italská');
INSERT INTO sqltutor.zastavky VALUES (59, 'Jana Masaryka');
INSERT INTO sqltutor.zastavky VALUES (60, 'Jindřišská');
INSERT INTO sqltutor.zastavky VALUES (61, 'Jiráskovo náměstí');
INSERT INTO sqltutor.zastavky VALUES (62, 'Jiřího z Poděbrad');
INSERT INTO sqltutor.zastavky VALUES (63, 'Kamenická');
INSERT INTO sqltutor.zastavky VALUES (64, 'Karlínské náměstí');
INSERT INTO sqltutor.zastavky VALUES (65, 'Karlovo náměstí');
INSERT INTO sqltutor.zastavky VALUES (66, 'Karlovy lázně');
INSERT INTO sqltutor.zastavky VALUES (67, 'Kavalírka');
INSERT INTO sqltutor.zastavky VALUES (68, 'K Barrandovu');
INSERT INTO sqltutor.zastavky VALUES (69, 'Kbelská');
INSERT INTO sqltutor.zastavky VALUES (70, 'Ke Stírce');
INSERT INTO sqltutor.zastavky VALUES (71, 'Klamovka');
INSERT INTO sqltutor.zastavky VALUES (72, 'Kněžská luka');
INSERT INTO sqltutor.zastavky VALUES (73, 'Kobylisy');
INSERT INTO sqltutor.zastavky VALUES (74, 'Koh-i-noor');
INSERT INTO sqltutor.zastavky VALUES (75, 'Kolbenova');
INSERT INTO sqltutor.zastavky VALUES (76, 'Kotlářka');
INSERT INTO sqltutor.zastavky VALUES (77, 'Královský letohrádek');
INSERT INTO sqltutor.zastavky VALUES (78, 'Krejcárek');
INSERT INTO sqltutor.zastavky VALUES (79, 'Krematorium Motol');
INSERT INTO sqltutor.zastavky VALUES (80, 'Krematorium Strašnice');
INSERT INTO sqltutor.zastavky VALUES (81, 'Křižíkova');
INSERT INTO sqltutor.zastavky VALUES (82, 'Křížová');
INSERT INTO sqltutor.zastavky VALUES (83, 'Krymská');
INSERT INTO sqltutor.zastavky VALUES (84, 'Kubánské náměstí');
INSERT INTO sqltutor.zastavky VALUES (85, 'Kublov');
INSERT INTO sqltutor.zastavky VALUES (86, 'Kyselova');
INSERT INTO sqltutor.zastavky VALUES (87, 'Ládví');
INSERT INTO sqltutor.zastavky VALUES (88, 'Laurová');
INSERT INTO sqltutor.zastavky VALUES (89, 'Lazarská');
INSERT INTO sqltutor.zastavky VALUES (90, 'Lehovec');
INSERT INTO sqltutor.zastavky VALUES (91, 'Letenské náměstí');
INSERT INTO sqltutor.zastavky VALUES (92, 'Levského');
INSERT INTO sqltutor.zastavky VALUES (93, 'Libeňský most');
INSERT INTO sqltutor.zastavky VALUES (94, 'Líbeznická');
INSERT INTO sqltutor.zastavky VALUES (95, 'Lihovar');
INSERT INTO sqltutor.zastavky VALUES (96, 'Lipanská');
INSERT INTO sqltutor.zastavky VALUES (97, 'Lotyšská');
INSERT INTO sqltutor.zastavky VALUES (98, 'Malešická továrna');
INSERT INTO sqltutor.zastavky VALUES (99, 'Malostranská');
INSERT INTO sqltutor.zastavky VALUES (100, 'Malostranské náměstí');
INSERT INTO sqltutor.zastavky VALUES (101, 'Malovanka');
INSERT INTO sqltutor.zastavky VALUES (102, 'Malý Břevnov');
INSERT INTO sqltutor.zastavky VALUES (103, 'Maniny');
INSERT INTO sqltutor.zastavky VALUES (104, 'Marjánka');
INSERT INTO sqltutor.zastavky VALUES (105, 'Masarykovo nádraží');
INSERT INTO sqltutor.zastavky VALUES (106, 'Mezi Hřbitovy');
INSERT INTO sqltutor.zastavky VALUES (107, 'Michelská');
INSERT INTO sqltutor.zastavky VALUES (108, 'Modřanská rokle');
INSERT INTO sqltutor.zastavky VALUES (109, 'Modřanská škola');
INSERT INTO sqltutor.zastavky VALUES (110, 'Moráň');
INSERT INTO sqltutor.zastavky VALUES (111, 'Motol');
INSERT INTO sqltutor.zastavky VALUES (112, 'Muzeum');
INSERT INTO sqltutor.zastavky VALUES (113, 'Myslíkova');
INSERT INTO sqltutor.zastavky VALUES (114, 'Nábřeží Kapitána Jaroše');
INSERT INTO sqltutor.zastavky VALUES (115, 'Nad Džbánem');
INSERT INTO sqltutor.zastavky VALUES (116, 'Nademlejnská');
INSERT INTO sqltutor.zastavky VALUES (117, 'Nad Primaskou');
INSERT INTO sqltutor.zastavky VALUES (118, 'Nádraží Braník');
INSERT INTO sqltutor.zastavky VALUES (119, 'Nádraží Holešovice');
INSERT INTO sqltutor.zastavky VALUES (120, 'Nádraží Hostivař');
INSERT INTO sqltutor.zastavky VALUES (121, 'Nádraží Libeň');
INSERT INTO sqltutor.zastavky VALUES (122, 'Nádraží Modřany');
INSERT INTO sqltutor.zastavky VALUES (123, 'Nádraží Strašnice');
INSERT INTO sqltutor.zastavky VALUES (124, 'Nádraží Veleslavín');
INSERT INTO sqltutor.zastavky VALUES (125, 'Nádraží Vršovice');
INSERT INTO sqltutor.zastavky VALUES (126, 'Nádraží Vysočany');
INSERT INTO sqltutor.zastavky VALUES (127, 'Nad Trojou');
INSERT INTO sqltutor.zastavky VALUES (128, 'Na Groši');
INSERT INTO sqltutor.zastavky VALUES (129, 'Na Homoli');
INSERT INTO sqltutor.zastavky VALUES (130, 'Na Hroudě');
INSERT INTO sqltutor.zastavky VALUES (131, 'Nákladové nádraží Žižkov');
INSERT INTO sqltutor.zastavky VALUES (132, 'Na Knížecí');
INSERT INTO sqltutor.zastavky VALUES (133, 'Náměstí Bratří Synků');
INSERT INTO sqltutor.zastavky VALUES (134, 'Náměstí Míru');
INSERT INTO sqltutor.zastavky VALUES (135, 'Náměstí Republiky');
INSERT INTO sqltutor.zastavky VALUES (136, 'Na Padesátém');
INSERT INTO sqltutor.zastavky VALUES (137, 'Národní divadlo');
INSERT INTO sqltutor.zastavky VALUES (138, 'Národní třída');
INSERT INTO sqltutor.zastavky VALUES (139, 'Na Veselí');
INSERT INTO sqltutor.zastavky VALUES (140, 'Nové Strašnice');
INSERT INTO sqltutor.zastavky VALUES (141, 'Nový Hloubětín');
INSERT INTO sqltutor.zastavky VALUES (142, 'Nuselská radnice');
INSERT INTO sqltutor.zastavky VALUES (143, 'Nuselské schody');
INSERT INTO sqltutor.zastavky VALUES (144, 'Obchodní dům Petřiny');
INSERT INTO sqltutor.zastavky VALUES (145, 'Oblouková');
INSERT INTO sqltutor.zastavky VALUES (146, 'Ocelářská');
INSERT INTO sqltutor.zastavky VALUES (147, 'Ohrada');
INSERT INTO sqltutor.zastavky VALUES (148, 'Okrouhlická');
INSERT INTO sqltutor.zastavky VALUES (149, 'Olšanská');
INSERT INTO sqltutor.zastavky VALUES (150, 'Olšanské hřbitovy');
INSERT INTO sqltutor.zastavky VALUES (151, 'Olšanské náměstí');
INSERT INTO sqltutor.zastavky VALUES (152, 'Ořechovka');
INSERT INTO sqltutor.zastavky VALUES (153, 'Orionka');
INSERT INTO sqltutor.zastavky VALUES (154, 'Ortenovo náměstí');
INSERT INTO sqltutor.zastavky VALUES (155, 'Ostrčilovo náměstí');
INSERT INTO sqltutor.zastavky VALUES (156, 'Otakarova');
INSERT INTO sqltutor.zastavky VALUES (157, 'Palackého náměstí');
INSERT INTO sqltutor.zastavky VALUES (158, 'Palmovka');
INSERT INTO sqltutor.zastavky VALUES (159, 'Palouček');
INSERT INTO sqltutor.zastavky VALUES (160, 'Perunova');
INSERT INTO sqltutor.zastavky VALUES (161, 'Petřiny');
INSERT INTO sqltutor.zastavky VALUES (162, 'Plynárna Michle');
INSERT INTO sqltutor.zastavky VALUES (163, 'Plzeňka');
INSERT INTO sqltutor.zastavky VALUES (164, 'Pobřežní cesta');
INSERT INTO sqltutor.zastavky VALUES (165, 'Podbaba');
INSERT INTO sqltutor.zastavky VALUES (166, 'Pod Jezerkou');
INSERT INTO sqltutor.zastavky VALUES (167, 'Pod Karlovem');
INSERT INTO sqltutor.zastavky VALUES (168, 'Podkovářská');
INSERT INTO sqltutor.zastavky VALUES (169, 'Podolská vodárna');
INSERT INTO sqltutor.zastavky VALUES (170, 'Pohořelec');
INSERT INTO sqltutor.zastavky VALUES (171, 'Poliklinika Barrandov');
INSERT INTO sqltutor.zastavky VALUES (172, 'Poliklinika Modřany');
INSERT INTO sqltutor.zastavky VALUES (173, 'Poliklinika Vysočany');
INSERT INTO sqltutor.zastavky VALUES (174, 'Poštovka');
INSERT INTO sqltutor.zastavky VALUES (175, 'Poštovská');
INSERT INTO sqltutor.zastavky VALUES (176, 'Prašný most');
INSERT INTO sqltutor.zastavky VALUES (177, 'Právnická fakulta');
INSERT INTO sqltutor.zastavky VALUES (178, 'Pražská tržnice');
INSERT INTO sqltutor.zastavky VALUES (179, 'Pražského povstání');
INSERT INTO sqltutor.zastavky VALUES (180, 'Pražský hrad');
INSERT INTO sqltutor.zastavky VALUES (181, 'Přístaviště');
INSERT INTO sqltutor.zastavky VALUES (182, 'Průběžná');
INSERT INTO sqltutor.zastavky VALUES (183, 'Radhošťská');
INSERT INTO sqltutor.zastavky VALUES (184, 'Radlická');
INSERT INTO sqltutor.zastavky VALUES (185, 'Radošovická');
INSERT INTO sqltutor.zastavky VALUES (186, 'Říčanova');
INSERT INTO sqltutor.zastavky VALUES (187, 'Ruská');
INSERT INTO sqltutor.zastavky VALUES (188, 'Sazka arena');
INSERT INTO sqltutor.zastavky VALUES (189, 'Sibeliova');
INSERT INTO sqltutor.zastavky VALUES (190, 'Sídliště Barrandov');
INSERT INTO sqltutor.zastavky VALUES (191, 'Sídliště Červený Vrch');
INSERT INTO sqltutor.zastavky VALUES (192, 'Sídliště Ďáblice');
INSERT INTO sqltutor.zastavky VALUES (193, 'Sídliště Hloubětín');
INSERT INTO sqltutor.zastavky VALUES (194, 'Sídliště Modřany');
INSERT INTO sqltutor.zastavky VALUES (195, 'Sídliště Řepy');
INSERT INTO sqltutor.zastavky VALUES (196, 'Sídliště Zahradní Město');
INSERT INTO sqltutor.zastavky VALUES (197, 'Škola Radlice');
INSERT INTO sqltutor.zastavky VALUES (198, 'Slánská');
INSERT INTO sqltutor.zastavky VALUES (199, 'Slavia');
INSERT INTO sqltutor.zastavky VALUES (200, 'Smíchovské nádraží');
INSERT INTO sqltutor.zastavky VALUES (201, 'Solidarita');
INSERT INTO sqltutor.zastavky VALUES (202, 'Sparta');
INSERT INTO sqltutor.zastavky VALUES (203, 'Špitálská');
INSERT INTO sqltutor.zastavky VALUES (204, 'Spojovací');
INSERT INTO sqltutor.zastavky VALUES (205, 'Spořilov');
INSERT INTO sqltutor.zastavky VALUES (206, 'Staroměstská');
INSERT INTO sqltutor.zastavky VALUES (207, 'Starý Hloubětín');
INSERT INTO sqltutor.zastavky VALUES (208, 'Stejskalova');
INSERT INTO sqltutor.zastavky VALUES (209, 'Štěpánská');
INSERT INTO sqltutor.zastavky VALUES (210, 'Štěpničná');
INSERT INTO sqltutor.zastavky VALUES (211, 'Strašnická');
INSERT INTO sqltutor.zastavky VALUES (212, 'Strážní');
INSERT INTO sqltutor.zastavky VALUES (213, 'Střelničná');
INSERT INTO sqltutor.zastavky VALUES (214, 'Strossmayerovo náměstí');
INSERT INTO sqltutor.zastavky VALUES (215, 'Šumavská');
INSERT INTO sqltutor.zastavky VALUES (216, 'Švandovo divadlo');
INSERT INTO sqltutor.zastavky VALUES (217, 'Svatoplukova');
INSERT INTO sqltutor.zastavky VALUES (218, 'Teplárna Michle');
INSERT INTO sqltutor.zastavky VALUES (219, 'Těšnov');
INSERT INTO sqltutor.zastavky VALUES (220, 'Thákurova');
INSERT INTO sqltutor.zastavky VALUES (221, 'Třebenická');
INSERT INTO sqltutor.zastavky VALUES (222, 'Trojská');
INSERT INTO sqltutor.zastavky VALUES (223, 'Tusarova');
INSERT INTO sqltutor.zastavky VALUES (224, 'U Elektry');
INSERT INTO sqltutor.zastavky VALUES (225, 'Újezd');
INSERT INTO sqltutor.zastavky VALUES (226, 'U Kaštanu');
INSERT INTO sqltutor.zastavky VALUES (227, 'U Kříže');
INSERT INTO sqltutor.zastavky VALUES (228, 'U Libušského potoka');
INSERT INTO sqltutor.zastavky VALUES (229, 'U Průhonu');
INSERT INTO sqltutor.zastavky VALUES (230, 'Urxova');
INSERT INTO sqltutor.zastavky VALUES (231, 'Ústřední dílny DP');
INSERT INTO sqltutor.zastavky VALUES (232, 'U Svobodárny');
INSERT INTO sqltutor.zastavky VALUES (233, 'U Zvonu');
INSERT INTO sqltutor.zastavky VALUES (234, 'Václavské náměstí');
INSERT INTO sqltutor.zastavky VALUES (235, 'Vápenka');
INSERT INTO sqltutor.zastavky VALUES (236, 'Veletržní');
INSERT INTO sqltutor.zastavky VALUES (237, 'Větrník');
INSERT INTO sqltutor.zastavky VALUES (238, 'Vinice');
INSERT INTO sqltutor.zastavky VALUES (239, 'Vinohradská tržnice');
INSERT INTO sqltutor.zastavky VALUES (240, 'Vinohradská vodárna');
INSERT INTO sqltutor.zastavky VALUES (241, 'Vinohradské hřbitovy');
INSERT INTO sqltutor.zastavky VALUES (242, 'Vítězné náměstí');
INSERT INTO sqltutor.zastavky VALUES (243, 'Vltavská');
INSERT INTO sqltutor.zastavky VALUES (244, 'Vodičkova');
INSERT INTO sqltutor.zastavky VALUES (245, 'Vojenská nemocnice');
INSERT INTO sqltutor.zastavky VALUES (246, 'Vosmíkových');
INSERT INTO sqltutor.zastavky VALUES (247, 'Vozovna Kobylisy');
INSERT INTO sqltutor.zastavky VALUES (248, 'Vozovna Motol');
INSERT INTO sqltutor.zastavky VALUES (249, 'Vozovna Pankrác');
INSERT INTO sqltutor.zastavky VALUES (250, 'Vozovna Strašnice');
INSERT INTO sqltutor.zastavky VALUES (251, 'Vozovna Střešovice');
INSERT INTO sqltutor.zastavky VALUES (252, 'Vozovna Vokovice');
INSERT INTO sqltutor.zastavky VALUES (253, 'Vršovické náměstí');
INSERT INTO sqltutor.zastavky VALUES (254, 'Vychovatelna');
INSERT INTO sqltutor.zastavky VALUES (255, 'Vypich');
INSERT INTO sqltutor.zastavky VALUES (256, 'Vysočanská');
INSERT INTO sqltutor.zastavky VALUES (257, 'Výstaviště');
INSERT INTO sqltutor.zastavky VALUES (258, 'Výtoň');
INSERT INTO sqltutor.zastavky VALUES (259, 'Zahradní Město');
INSERT INTO sqltutor.zastavky VALUES (260, 'Zborovská');
INSERT INTO sqltutor.zastavky VALUES (261, 'Zborov - Strašnické divadlo');
INSERT INTO sqltutor.zastavky VALUES (262, 'Želivského');
INSERT INTO sqltutor.zastavky VALUES (263, 'Zlíchov');

INSERT INTO sqltutor.linky VALUES (1, 1, 1, 161);
INSERT INTO sqltutor.linky VALUES (1, 1, 2, 144);
INSERT INTO sqltutor.linky VALUES (1, 1, 3, 237);
INSERT INTO sqltutor.linky VALUES (1, 1, 4, 245);
INSERT INTO sqltutor.linky VALUES (1, 1, 5, 5);
INSERT INTO sqltutor.linky VALUES (1, 1, 6, 152);
INSERT INTO sqltutor.linky VALUES (1, 1, 7, 189);
INSERT INTO sqltutor.linky VALUES (1, 1, 8, 251);
INSERT INTO sqltutor.linky VALUES (1, 1, 9, 176);
INSERT INTO sqltutor.linky VALUES (1, 1, 10, 54);
INSERT INTO sqltutor.linky VALUES (1, 1, 11, 29);
INSERT INTO sqltutor.linky VALUES (1, 1, 12, 22);
INSERT INTO sqltutor.linky VALUES (1, 1, 13, 214);
INSERT INTO sqltutor.linky VALUES (1, 1, 14, 243);
INSERT INTO sqltutor.linky VALUES (1, 1, 15, 178);
INSERT INTO sqltutor.linky VALUES (1, 1, 16, 32);
INSERT INTO sqltutor.linky VALUES (1, 1, 17, 103);
INSERT INTO sqltutor.linky VALUES (1, 1, 18, 93);
INSERT INTO sqltutor.linky VALUES (1, 1, 19, 158);
INSERT INTO sqltutor.linky VALUES (1, 1, 20, 78);
INSERT INTO sqltutor.linky VALUES (1, 1, 21, 147);
INSERT INTO sqltutor.linky VALUES (1, 1, 22, 235);
INSERT INTO sqltutor.linky VALUES (1, 1, 23, 212);
INSERT INTO sqltutor.linky VALUES (1, 1, 24, 27);
INSERT INTO sqltutor.linky VALUES (1, 1, 25, 72);
INSERT INTO sqltutor.linky VALUES (1, 2, 1, 204);
INSERT INTO sqltutor.linky VALUES (1, 2, 2, 72);
INSERT INTO sqltutor.linky VALUES (1, 2, 3, 27);
INSERT INTO sqltutor.linky VALUES (1, 2, 4, 212);
INSERT INTO sqltutor.linky VALUES (1, 2, 5, 235);
INSERT INTO sqltutor.linky VALUES (1, 2, 6, 147);
INSERT INTO sqltutor.linky VALUES (1, 2, 7, 78);
INSERT INTO sqltutor.linky VALUES (1, 2, 8, 158);
INSERT INTO sqltutor.linky VALUES (1, 2, 9, 93);
INSERT INTO sqltutor.linky VALUES (1, 2, 10, 103);
INSERT INTO sqltutor.linky VALUES (1, 2, 11, 223);
INSERT INTO sqltutor.linky VALUES (1, 2, 12, 178);
INSERT INTO sqltutor.linky VALUES (1, 2, 13, 243);
INSERT INTO sqltutor.linky VALUES (1, 2, 14, 214);
INSERT INTO sqltutor.linky VALUES (1, 2, 15, 114);
INSERT INTO sqltutor.linky VALUES (1, 2, 16, 22);
INSERT INTO sqltutor.linky VALUES (1, 2, 17, 99);
INSERT INTO sqltutor.linky VALUES (1, 2, 18, 29);
INSERT INTO sqltutor.linky VALUES (1, 2, 19, 54);
INSERT INTO sqltutor.linky VALUES (1, 2, 20, 176);
INSERT INTO sqltutor.linky VALUES (1, 2, 21, 251);
INSERT INTO sqltutor.linky VALUES (1, 2, 22, 189);
INSERT INTO sqltutor.linky VALUES (1, 2, 23, 152);
INSERT INTO sqltutor.linky VALUES (1, 2, 24, 5);
INSERT INTO sqltutor.linky VALUES (1, 2, 25, 245);
INSERT INTO sqltutor.linky VALUES (1, 2, 26, 237);
INSERT INTO sqltutor.linky VALUES (1, 2, 27, 144);
INSERT INTO sqltutor.linky VALUES (2, 1, 1, 161);
INSERT INTO sqltutor.linky VALUES (2, 1, 2, 144);
INSERT INTO sqltutor.linky VALUES (2, 1, 3, 237);
INSERT INTO sqltutor.linky VALUES (2, 1, 4, 245);
INSERT INTO sqltutor.linky VALUES (2, 1, 5, 5);
INSERT INTO sqltutor.linky VALUES (2, 1, 6, 152);
INSERT INTO sqltutor.linky VALUES (2, 1, 7, 189);
INSERT INTO sqltutor.linky VALUES (2, 1, 8, 251);
INSERT INTO sqltutor.linky VALUES (2, 1, 9, 176);
INSERT INTO sqltutor.linky VALUES (2, 1, 10, 242);
INSERT INTO sqltutor.linky VALUES (2, 1, 11, 31);
INSERT INTO sqltutor.linky VALUES (2, 1, 12, 220);
INSERT INTO sqltutor.linky VALUES (2, 1, 13, 43);
INSERT INTO sqltutor.linky VALUES (2, 1, 14, 12);
INSERT INTO sqltutor.linky VALUES (2, 1, 15, 51);
INSERT INTO sqltutor.linky VALUES (2, 1, 16, 191);
INSERT INTO sqltutor.linky VALUES (2, 2, 1, 25);
INSERT INTO sqltutor.linky VALUES (2, 2, 2, 191);
INSERT INTO sqltutor.linky VALUES (2, 2, 3, 51);
INSERT INTO sqltutor.linky VALUES (2, 2, 4, 12);
INSERT INTO sqltutor.linky VALUES (2, 2, 5, 43);
INSERT INTO sqltutor.linky VALUES (2, 2, 6, 220);
INSERT INTO sqltutor.linky VALUES (2, 2, 7, 31);
INSERT INTO sqltutor.linky VALUES (2, 2, 8, 242);
INSERT INTO sqltutor.linky VALUES (2, 2, 9, 176);
INSERT INTO sqltutor.linky VALUES (2, 2, 10, 251);
INSERT INTO sqltutor.linky VALUES (2, 2, 11, 189);
INSERT INTO sqltutor.linky VALUES (2, 2, 12, 152);
INSERT INTO sqltutor.linky VALUES (2, 2, 13, 5);
INSERT INTO sqltutor.linky VALUES (2, 2, 14, 245);
INSERT INTO sqltutor.linky VALUES (2, 2, 15, 237);
INSERT INTO sqltutor.linky VALUES (2, 2, 16, 144);
INSERT INTO sqltutor.linky VALUES (3, 1, 1, 92);
INSERT INTO sqltutor.linky VALUES (3, 1, 2, 194);
INSERT INTO sqltutor.linky VALUES (3, 1, 3, 108);
INSERT INTO sqltutor.linky VALUES (3, 1, 4, 228);
INSERT INTO sqltutor.linky VALUES (3, 1, 5, 172);
INSERT INTO sqltutor.linky VALUES (3, 1, 6, 20);
INSERT INTO sqltutor.linky VALUES (3, 1, 7, 122);
INSERT INTO sqltutor.linky VALUES (3, 1, 8, 109);
INSERT INTO sqltutor.linky VALUES (3, 1, 9, 6);
INSERT INTO sqltutor.linky VALUES (3, 1, 10, 24);
INSERT INTO sqltutor.linky VALUES (3, 1, 11, 118);
INSERT INTO sqltutor.linky VALUES (3, 1, 12, 164);
INSERT INTO sqltutor.linky VALUES (3, 1, 13, 181);
INSERT INTO sqltutor.linky VALUES (3, 1, 14, 39);
INSERT INTO sqltutor.linky VALUES (3, 1, 15, 85);
INSERT INTO sqltutor.linky VALUES (3, 1, 16, 169);
INSERT INTO sqltutor.linky VALUES (3, 1, 17, 258);
INSERT INTO sqltutor.linky VALUES (3, 1, 18, 157);
INSERT INTO sqltutor.linky VALUES (3, 1, 19, 157);
INSERT INTO sqltutor.linky VALUES (3, 1, 20, 65);
INSERT INTO sqltutor.linky VALUES (3, 1, 21, 89);
INSERT INTO sqltutor.linky VALUES (3, 1, 22, 244);
INSERT INTO sqltutor.linky VALUES (3, 1, 23, 234);
INSERT INTO sqltutor.linky VALUES (3, 1, 24, 60);
INSERT INTO sqltutor.linky VALUES (3, 1, 25, 105);
INSERT INTO sqltutor.linky VALUES (3, 1, 26, 9);
INSERT INTO sqltutor.linky VALUES (3, 1, 27, 219);
INSERT INTO sqltutor.linky VALUES (3, 1, 28, 243);
INSERT INTO sqltutor.linky VALUES (3, 1, 29, 243);
INSERT INTO sqltutor.linky VALUES (3, 1, 30, 178);
INSERT INTO sqltutor.linky VALUES (3, 1, 31, 32);
INSERT INTO sqltutor.linky VALUES (3, 1, 32, 103);
INSERT INTO sqltutor.linky VALUES (3, 1, 33, 93);
INSERT INTO sqltutor.linky VALUES (3, 1, 34, 158);
INSERT INTO sqltutor.linky VALUES (3, 1, 35, 4);
INSERT INTO sqltutor.linky VALUES (3, 1, 36, 146);
INSERT INTO sqltutor.linky VALUES (3, 1, 37, 188);
INSERT INTO sqltutor.linky VALUES (3, 1, 38, 121);
INSERT INTO sqltutor.linky VALUES (3, 1, 39, 168);
INSERT INTO sqltutor.linky VALUES (3, 1, 40, 224);
INSERT INTO sqltutor.linky VALUES (3, 1, 41, 116);
INSERT INTO sqltutor.linky VALUES (3, 1, 42, 69);
INSERT INTO sqltutor.linky VALUES (3, 1, 43, 47);
INSERT INTO sqltutor.linky VALUES (3, 1, 44, 193);
INSERT INTO sqltutor.linky VALUES (3, 2, 1, 90);
INSERT INTO sqltutor.linky VALUES (3, 2, 2, 193);
INSERT INTO sqltutor.linky VALUES (3, 2, 3, 47);
INSERT INTO sqltutor.linky VALUES (3, 2, 4, 69);
INSERT INTO sqltutor.linky VALUES (3, 2, 5, 116);
INSERT INTO sqltutor.linky VALUES (3, 2, 6, 224);
INSERT INTO sqltutor.linky VALUES (3, 2, 7, 168);
INSERT INTO sqltutor.linky VALUES (3, 2, 8, 121);
INSERT INTO sqltutor.linky VALUES (3, 2, 9, 188);
INSERT INTO sqltutor.linky VALUES (3, 2, 10, 146);
INSERT INTO sqltutor.linky VALUES (3, 2, 11, 4);
INSERT INTO sqltutor.linky VALUES (3, 2, 12, 158);
INSERT INTO sqltutor.linky VALUES (3, 2, 13, 158);
INSERT INTO sqltutor.linky VALUES (3, 2, 14, 93);
INSERT INTO sqltutor.linky VALUES (3, 2, 15, 103);
INSERT INTO sqltutor.linky VALUES (3, 2, 16, 223);
INSERT INTO sqltutor.linky VALUES (3, 2, 17, 178);
INSERT INTO sqltutor.linky VALUES (3, 2, 18, 243);
INSERT INTO sqltutor.linky VALUES (3, 2, 19, 243);
INSERT INTO sqltutor.linky VALUES (3, 2, 20, 219);
INSERT INTO sqltutor.linky VALUES (3, 2, 21, 9);
INSERT INTO sqltutor.linky VALUES (3, 2, 22, 105);
INSERT INTO sqltutor.linky VALUES (3, 2, 23, 60);
INSERT INTO sqltutor.linky VALUES (3, 2, 24, 234);
INSERT INTO sqltutor.linky VALUES (3, 2, 25, 244);
INSERT INTO sqltutor.linky VALUES (3, 2, 26, 89);
INSERT INTO sqltutor.linky VALUES (3, 2, 27, 65);
INSERT INTO sqltutor.linky VALUES (3, 2, 28, 110);
INSERT INTO sqltutor.linky VALUES (3, 2, 29, 157);
INSERT INTO sqltutor.linky VALUES (3, 2, 30, 157);
INSERT INTO sqltutor.linky VALUES (3, 2, 31, 258);
INSERT INTO sqltutor.linky VALUES (3, 2, 32, 169);
INSERT INTO sqltutor.linky VALUES (3, 2, 33, 85);
INSERT INTO sqltutor.linky VALUES (3, 2, 34, 39);
INSERT INTO sqltutor.linky VALUES (3, 2, 35, 181);
INSERT INTO sqltutor.linky VALUES (3, 2, 36, 164);
INSERT INTO sqltutor.linky VALUES (3, 2, 37, 118);
INSERT INTO sqltutor.linky VALUES (3, 2, 38, 24);
INSERT INTO sqltutor.linky VALUES (3, 2, 39, 6);
INSERT INTO sqltutor.linky VALUES (3, 2, 40, 109);
INSERT INTO sqltutor.linky VALUES (3, 2, 41, 122);
INSERT INTO sqltutor.linky VALUES (3, 2, 42, 20);
INSERT INTO sqltutor.linky VALUES (3, 2, 43, 172);
INSERT INTO sqltutor.linky VALUES (3, 2, 44, 228);
INSERT INTO sqltutor.linky VALUES (3, 2, 45, 108);
INSERT INTO sqltutor.linky VALUES (4, 1, 1, 195);
INSERT INTO sqltutor.linky VALUES (4, 1, 2, 11);
INSERT INTO sqltutor.linky VALUES (4, 1, 3, 198);
INSERT INTO sqltutor.linky VALUES (4, 1, 4, 49);
INSERT INTO sqltutor.linky VALUES (4, 1, 5, 79);
INSERT INTO sqltutor.linky VALUES (4, 1, 6, 111);
INSERT INTO sqltutor.linky VALUES (4, 1, 7, 248);
INSERT INTO sqltutor.linky VALUES (4, 1, 8, 53);
INSERT INTO sqltutor.linky VALUES (4, 1, 9, 174);
INSERT INTO sqltutor.linky VALUES (4, 1, 10, 76);
INSERT INTO sqltutor.linky VALUES (4, 1, 11, 76);
INSERT INTO sqltutor.linky VALUES (4, 1, 12, 67);
INSERT INTO sqltutor.linky VALUES (4, 1, 13, 71);
INSERT INTO sqltutor.linky VALUES (4, 1, 14, 233);
INSERT INTO sqltutor.linky VALUES (4, 1, 15, 7);
INSERT INTO sqltutor.linky VALUES (4, 1, 16, 2);
INSERT INTO sqltutor.linky VALUES (4, 1, 17, 260);
INSERT INTO sqltutor.linky VALUES (4, 1, 18, 157);
INSERT INTO sqltutor.linky VALUES (4, 1, 19, 65);
INSERT INTO sqltutor.linky VALUES (4, 1, 20, 209);
INSERT INTO sqltutor.linky VALUES (4, 1, 21, 57);
INSERT INTO sqltutor.linky VALUES (4, 1, 22, 134);
INSERT INTO sqltutor.linky VALUES (4, 1, 23, 59);
INSERT INTO sqltutor.linky VALUES (4, 1, 24, 83);
INSERT INTO sqltutor.linky VALUES (4, 1, 25, 187);
INSERT INTO sqltutor.linky VALUES (4, 1, 26, 253);
INSERT INTO sqltutor.linky VALUES (4, 2, 1, 21);
INSERT INTO sqltutor.linky VALUES (4, 2, 2, 253);
INSERT INTO sqltutor.linky VALUES (4, 2, 3, 187);
INSERT INTO sqltutor.linky VALUES (4, 2, 4, 59);
INSERT INTO sqltutor.linky VALUES (4, 2, 5, 134);
INSERT INTO sqltutor.linky VALUES (4, 2, 6, 57);
INSERT INTO sqltutor.linky VALUES (4, 2, 7, 209);
INSERT INTO sqltutor.linky VALUES (4, 2, 8, 65);
INSERT INTO sqltutor.linky VALUES (4, 2, 9, 110);
INSERT INTO sqltutor.linky VALUES (4, 2, 10, 157);
INSERT INTO sqltutor.linky VALUES (4, 2, 11, 260);
INSERT INTO sqltutor.linky VALUES (4, 2, 12, 2);
INSERT INTO sqltutor.linky VALUES (4, 2, 13, 7);
INSERT INTO sqltutor.linky VALUES (4, 2, 14, 233);
INSERT INTO sqltutor.linky VALUES (4, 2, 15, 71);
INSERT INTO sqltutor.linky VALUES (4, 2, 16, 67);
INSERT INTO sqltutor.linky VALUES (4, 2, 17, 76);
INSERT INTO sqltutor.linky VALUES (4, 2, 18, 174);
INSERT INTO sqltutor.linky VALUES (4, 2, 19, 53);
INSERT INTO sqltutor.linky VALUES (4, 2, 20, 248);
INSERT INTO sqltutor.linky VALUES (4, 2, 21, 111);
INSERT INTO sqltutor.linky VALUES (4, 2, 22, 79);
INSERT INTO sqltutor.linky VALUES (4, 2, 23, 49);
INSERT INTO sqltutor.linky VALUES (4, 2, 24, 198);
INSERT INTO sqltutor.linky VALUES (4, 2, 25, 11);
INSERT INTO sqltutor.linky VALUES (5, 1, 1, 150);
INSERT INTO sqltutor.linky VALUES (5, 1, 2, 40);
INSERT INTO sqltutor.linky VALUES (5, 1, 3, 151);
INSERT INTO sqltutor.linky VALUES (5, 1, 4, 96);
INSERT INTO sqltutor.linky VALUES (5, 1, 5, 55);
INSERT INTO sqltutor.linky VALUES (5, 1, 6, 46);
INSERT INTO sqltutor.linky VALUES (5, 1, 7, 105);
INSERT INTO sqltutor.linky VALUES (5, 1, 8, 9);
INSERT INTO sqltutor.linky VALUES (5, 1, 9, 219);
INSERT INTO sqltutor.linky VALUES (5, 1, 10, 243);
INSERT INTO sqltutor.linky VALUES (5, 1, 11, 243);
INSERT INTO sqltutor.linky VALUES (5, 1, 12, 178);
INSERT INTO sqltutor.linky VALUES (5, 1, 13, 32);
INSERT INTO sqltutor.linky VALUES (5, 1, 14, 229);
INSERT INTO sqltutor.linky VALUES (5, 1, 15, 154);
INSERT INTO sqltutor.linky VALUES (5, 1, 16, 119);
INSERT INTO sqltutor.linky VALUES (5, 1, 17, 257);
INSERT INTO sqltutor.linky VALUES (5, 2, 1, 257);
INSERT INTO sqltutor.linky VALUES (5, 2, 2, 257);
INSERT INTO sqltutor.linky VALUES (5, 2, 3, 119);
INSERT INTO sqltutor.linky VALUES (5, 2, 4, 154);
INSERT INTO sqltutor.linky VALUES (5, 2, 5, 32);
INSERT INTO sqltutor.linky VALUES (5, 2, 6, 223);
INSERT INTO sqltutor.linky VALUES (5, 2, 7, 178);
INSERT INTO sqltutor.linky VALUES (5, 2, 8, 243);
INSERT INTO sqltutor.linky VALUES (5, 2, 9, 243);
INSERT INTO sqltutor.linky VALUES (5, 2, 10, 219);
INSERT INTO sqltutor.linky VALUES (5, 2, 11, 9);
INSERT INTO sqltutor.linky VALUES (5, 2, 12, 105);
INSERT INTO sqltutor.linky VALUES (5, 2, 13, 46);
INSERT INTO sqltutor.linky VALUES (5, 2, 14, 55);
INSERT INTO sqltutor.linky VALUES (5, 2, 15, 96);
INSERT INTO sqltutor.linky VALUES (5, 2, 16, 151);
INSERT INTO sqltutor.linky VALUES (5, 2, 17, 40);
INSERT INTO sqltutor.linky VALUES (6, 1, 1, 76);
INSERT INTO sqltutor.linky VALUES (6, 1, 2, 76);
INSERT INTO sqltutor.linky VALUES (6, 1, 3, 67);
INSERT INTO sqltutor.linky VALUES (6, 1, 4, 71);
INSERT INTO sqltutor.linky VALUES (6, 1, 5, 233);
INSERT INTO sqltutor.linky VALUES (6, 1, 6, 7);
INSERT INTO sqltutor.linky VALUES (6, 1, 7, 2);
INSERT INTO sqltutor.linky VALUES (6, 1, 8, 3);
INSERT INTO sqltutor.linky VALUES (6, 1, 9, 216);
INSERT INTO sqltutor.linky VALUES (6, 1, 10, 225);
INSERT INTO sqltutor.linky VALUES (6, 1, 11, 137);
INSERT INTO sqltutor.linky VALUES (6, 1, 12, 138);
INSERT INTO sqltutor.linky VALUES (6, 1, 13, 65);
INSERT INTO sqltutor.linky VALUES (6, 1, 14, 209);
INSERT INTO sqltutor.linky VALUES (6, 1, 15, 57);
INSERT INTO sqltutor.linky VALUES (6, 1, 16, 17);
INSERT INTO sqltutor.linky VALUES (6, 1, 17, 167);
INSERT INTO sqltutor.linky VALUES (6, 1, 18, 143);
INSERT INTO sqltutor.linky VALUES (6, 1, 19, 156);
INSERT INTO sqltutor.linky VALUES (6, 1, 20, 125);
INSERT INTO sqltutor.linky VALUES (6, 1, 21, 145);
INSERT INTO sqltutor.linky VALUES (6, 1, 22, 74);
INSERT INTO sqltutor.linky VALUES (6, 1, 23, 199);
INSERT INTO sqltutor.linky VALUES (6, 2, 1, 84);
INSERT INTO sqltutor.linky VALUES (6, 2, 2, 199);
INSERT INTO sqltutor.linky VALUES (6, 2, 3, 74);
INSERT INTO sqltutor.linky VALUES (6, 2, 4, 145);
INSERT INTO sqltutor.linky VALUES (6, 2, 5, 125);
INSERT INTO sqltutor.linky VALUES (6, 2, 6, 156);
INSERT INTO sqltutor.linky VALUES (6, 2, 7, 143);
INSERT INTO sqltutor.linky VALUES (6, 2, 8, 17);
INSERT INTO sqltutor.linky VALUES (6, 2, 9, 57);
INSERT INTO sqltutor.linky VALUES (6, 2, 10, 209);
INSERT INTO sqltutor.linky VALUES (6, 2, 11, 65);
INSERT INTO sqltutor.linky VALUES (6, 2, 12, 138);
INSERT INTO sqltutor.linky VALUES (6, 2, 13, 137);
INSERT INTO sqltutor.linky VALUES (6, 2, 14, 225);
INSERT INTO sqltutor.linky VALUES (6, 2, 15, 216);
INSERT INTO sqltutor.linky VALUES (6, 2, 16, 3);
INSERT INTO sqltutor.linky VALUES (6, 2, 17, 2);
INSERT INTO sqltutor.linky VALUES (6, 2, 18, 7);
INSERT INTO sqltutor.linky VALUES (6, 2, 19, 233);
INSERT INTO sqltutor.linky VALUES (6, 2, 20, 71);
INSERT INTO sqltutor.linky VALUES (6, 2, 21, 67);
INSERT INTO sqltutor.linky VALUES (7, 1, 1, 184);
INSERT INTO sqltutor.linky VALUES (7, 1, 2, 197);
INSERT INTO sqltutor.linky VALUES (7, 1, 3, 88);
INSERT INTO sqltutor.linky VALUES (7, 1, 4, 14);
INSERT INTO sqltutor.linky VALUES (7, 1, 5, 82);
INSERT INTO sqltutor.linky VALUES (7, 1, 6, 132);
INSERT INTO sqltutor.linky VALUES (7, 1, 7, 2);
INSERT INTO sqltutor.linky VALUES (7, 1, 8, 260);
INSERT INTO sqltutor.linky VALUES (7, 1, 9, 157);
INSERT INTO sqltutor.linky VALUES (7, 1, 10, 258);
INSERT INTO sqltutor.linky VALUES (7, 1, 11, 1);
INSERT INTO sqltutor.linky VALUES (7, 1, 12, 155);
INSERT INTO sqltutor.linky VALUES (7, 1, 13, 217);
INSERT INTO sqltutor.linky VALUES (7, 1, 14, 34);
INSERT INTO sqltutor.linky VALUES (7, 1, 15, 156);
INSERT INTO sqltutor.linky VALUES (7, 1, 16, 125);
INSERT INTO sqltutor.linky VALUES (7, 1, 17, 145);
INSERT INTO sqltutor.linky VALUES (7, 1, 18, 74);
INSERT INTO sqltutor.linky VALUES (7, 1, 19, 199);
INSERT INTO sqltutor.linky VALUES (7, 1, 20, 84);
INSERT INTO sqltutor.linky VALUES (7, 1, 21, 182);
INSERT INTO sqltutor.linky VALUES (7, 1, 22, 211);
INSERT INTO sqltutor.linky VALUES (7, 1, 23, 238);
INSERT INTO sqltutor.linky VALUES (7, 1, 24, 201);
INSERT INTO sqltutor.linky VALUES (7, 1, 25, 261);
INSERT INTO sqltutor.linky VALUES (7, 1, 26, 140);
INSERT INTO sqltutor.linky VALUES (7, 1, 27, 23);
INSERT INTO sqltutor.linky VALUES (7, 1, 28, 33);
INSERT INTO sqltutor.linky VALUES (7, 1, 29, 98);
INSERT INTO sqltutor.linky VALUES (7, 1, 30, 129);
INSERT INTO sqltutor.linky VALUES (7, 2, 1, 231);
INSERT INTO sqltutor.linky VALUES (7, 2, 2, 129);
INSERT INTO sqltutor.linky VALUES (7, 2, 3, 98);
INSERT INTO sqltutor.linky VALUES (7, 2, 4, 33);
INSERT INTO sqltutor.linky VALUES (7, 2, 5, 23);
INSERT INTO sqltutor.linky VALUES (7, 2, 6, 140);
INSERT INTO sqltutor.linky VALUES (7, 2, 7, 261);
INSERT INTO sqltutor.linky VALUES (7, 2, 8, 201);
INSERT INTO sqltutor.linky VALUES (7, 2, 9, 117);
INSERT INTO sqltutor.linky VALUES (7, 2, 10, 211);
INSERT INTO sqltutor.linky VALUES (7, 2, 11, 182);
INSERT INTO sqltutor.linky VALUES (7, 2, 12, 84);
INSERT INTO sqltutor.linky VALUES (7, 2, 13, 199);
INSERT INTO sqltutor.linky VALUES (7, 2, 14, 74);
INSERT INTO sqltutor.linky VALUES (7, 2, 15, 145);
INSERT INTO sqltutor.linky VALUES (7, 2, 16, 125);
INSERT INTO sqltutor.linky VALUES (7, 2, 17, 156);
INSERT INTO sqltutor.linky VALUES (7, 2, 18, 34);
INSERT INTO sqltutor.linky VALUES (7, 2, 19, 217);
INSERT INTO sqltutor.linky VALUES (7, 2, 20, 155);
INSERT INTO sqltutor.linky VALUES (7, 2, 21, 1);
INSERT INTO sqltutor.linky VALUES (7, 2, 22, 258);
INSERT INTO sqltutor.linky VALUES (7, 2, 23, 157);
INSERT INTO sqltutor.linky VALUES (7, 2, 24, 260);
INSERT INTO sqltutor.linky VALUES (7, 2, 25, 2);
INSERT INTO sqltutor.linky VALUES (7, 2, 26, 132);
INSERT INTO sqltutor.linky VALUES (7, 2, 27, 82);
INSERT INTO sqltutor.linky VALUES (7, 2, 28, 14);
INSERT INTO sqltutor.linky VALUES (7, 2, 29, 88);
INSERT INTO sqltutor.linky VALUES (7, 2, 30, 197);
INSERT INTO sqltutor.linky VALUES (8, 1, 1, 36);
INSERT INTO sqltutor.linky VALUES (8, 1, 2, 252);
INSERT INTO sqltutor.linky VALUES (8, 1, 3, 115);
INSERT INTO sqltutor.linky VALUES (8, 1, 4, 124);
INSERT INTO sqltutor.linky VALUES (8, 1, 5, 25);
INSERT INTO sqltutor.linky VALUES (6, 1, 49, 84);
INSERT INTO sqltutor.linky VALUES (8, 1, 6, 191);
INSERT INTO sqltutor.linky VALUES (8, 1, 7, 51);
INSERT INTO sqltutor.linky VALUES (8, 1, 8, 12);
INSERT INTO sqltutor.linky VALUES (8, 1, 9, 43);
INSERT INTO sqltutor.linky VALUES (8, 1, 10, 220);
INSERT INTO sqltutor.linky VALUES (8, 1, 11, 31);
INSERT INTO sqltutor.linky VALUES (8, 1, 12, 242);
INSERT INTO sqltutor.linky VALUES (8, 1, 13, 54);
INSERT INTO sqltutor.linky VALUES (8, 1, 14, 29);
INSERT INTO sqltutor.linky VALUES (8, 1, 15, 22);
INSERT INTO sqltutor.linky VALUES (8, 1, 16, 37);
INSERT INTO sqltutor.linky VALUES (8, 1, 17, 135);
INSERT INTO sqltutor.linky VALUES (8, 1, 18, 9);
INSERT INTO sqltutor.linky VALUES (8, 1, 19, 41);
INSERT INTO sqltutor.linky VALUES (8, 1, 20, 64);
INSERT INTO sqltutor.linky VALUES (8, 1, 21, 81);
INSERT INTO sqltutor.linky VALUES (8, 1, 22, 230);
INSERT INTO sqltutor.linky VALUES (8, 1, 23, 56);
INSERT INTO sqltutor.linky VALUES (8, 1, 24, 158);
INSERT INTO sqltutor.linky VALUES (8, 1, 25, 4);
INSERT INTO sqltutor.linky VALUES (8, 1, 26, 232);
INSERT INTO sqltutor.linky VALUES (8, 1, 27, 173);
INSERT INTO sqltutor.linky VALUES (8, 2, 1, 256);
INSERT INTO sqltutor.linky VALUES (8, 2, 2, 126);
INSERT INTO sqltutor.linky VALUES (8, 2, 3, 173);
INSERT INTO sqltutor.linky VALUES (8, 2, 4, 232);
INSERT INTO sqltutor.linky VALUES (8, 2, 5, 4);
INSERT INTO sqltutor.linky VALUES (8, 2, 6, 158);
INSERT INTO sqltutor.linky VALUES (8, 2, 7, 158);
INSERT INTO sqltutor.linky VALUES (8, 2, 8, 56);
INSERT INTO sqltutor.linky VALUES (8, 2, 9, 230);
INSERT INTO sqltutor.linky VALUES (8, 2, 10, 81);
INSERT INTO sqltutor.linky VALUES (8, 2, 11, 64);
INSERT INTO sqltutor.linky VALUES (8, 2, 12, 41);
INSERT INTO sqltutor.linky VALUES (8, 2, 13, 9);
INSERT INTO sqltutor.linky VALUES (8, 2, 14, 135);
INSERT INTO sqltutor.linky VALUES (8, 2, 15, 37);
INSERT INTO sqltutor.linky VALUES (8, 2, 16, 22);
INSERT INTO sqltutor.linky VALUES (8, 2, 17, 99);
INSERT INTO sqltutor.linky VALUES (8, 2, 18, 29);
INSERT INTO sqltutor.linky VALUES (8, 2, 19, 54);
INSERT INTO sqltutor.linky VALUES (8, 2, 20, 242);
INSERT INTO sqltutor.linky VALUES (8, 2, 21, 31);
INSERT INTO sqltutor.linky VALUES (8, 2, 22, 220);
INSERT INTO sqltutor.linky VALUES (8, 2, 23, 43);
INSERT INTO sqltutor.linky VALUES (8, 2, 24, 12);
INSERT INTO sqltutor.linky VALUES (8, 2, 25, 51);
INSERT INTO sqltutor.linky VALUES (8, 2, 26, 191);
INSERT INTO sqltutor.linky VALUES (8, 2, 27, 25);
INSERT INTO sqltutor.linky VALUES (8, 2, 28, 124);
INSERT INTO sqltutor.linky VALUES (8, 2, 29, 115);
INSERT INTO sqltutor.linky VALUES (8, 2, 30, 252);
INSERT INTO sqltutor.linky VALUES (9, 1, 1, 195);
INSERT INTO sqltutor.linky VALUES (9, 1, 2, 11);
INSERT INTO sqltutor.linky VALUES (9, 1, 3, 198);
INSERT INTO sqltutor.linky VALUES (9, 1, 4, 49);
INSERT INTO sqltutor.linky VALUES (9, 1, 5, 79);
INSERT INTO sqltutor.linky VALUES (9, 1, 6, 111);
INSERT INTO sqltutor.linky VALUES (9, 1, 7, 248);
INSERT INTO sqltutor.linky VALUES (9, 1, 8, 53);
INSERT INTO sqltutor.linky VALUES (9, 1, 9, 174);
INSERT INTO sqltutor.linky VALUES (9, 1, 10, 76);
INSERT INTO sqltutor.linky VALUES (9, 1, 11, 67);
INSERT INTO sqltutor.linky VALUES (9, 1, 12, 71);
INSERT INTO sqltutor.linky VALUES (9, 1, 13, 233);
INSERT INTO sqltutor.linky VALUES (9, 1, 14, 7);
INSERT INTO sqltutor.linky VALUES (9, 1, 15, 2);
INSERT INTO sqltutor.linky VALUES (9, 1, 16, 3);
INSERT INTO sqltutor.linky VALUES (9, 1, 17, 216);
INSERT INTO sqltutor.linky VALUES (9, 1, 18, 225);
INSERT INTO sqltutor.linky VALUES (9, 1, 19, 137);
INSERT INTO sqltutor.linky VALUES (9, 1, 20, 138);
INSERT INTO sqltutor.linky VALUES (9, 1, 21, 89);
INSERT INTO sqltutor.linky VALUES (9, 1, 22, 244);
INSERT INTO sqltutor.linky VALUES (9, 1, 23, 234);
INSERT INTO sqltutor.linky VALUES (9, 1, 24, 60);
INSERT INTO sqltutor.linky VALUES (9, 1, 25, 46);
INSERT INTO sqltutor.linky VALUES (9, 1, 26, 55);
INSERT INTO sqltutor.linky VALUES (9, 1, 27, 96);
INSERT INTO sqltutor.linky VALUES (9, 1, 28, 151);
INSERT INTO sqltutor.linky VALUES (9, 1, 29, 149);
INSERT INTO sqltutor.linky VALUES (9, 1, 30, 131);
INSERT INTO sqltutor.linky VALUES (9, 1, 31, 131);
INSERT INTO sqltutor.linky VALUES (9, 1, 32, 10);
INSERT INTO sqltutor.linky VALUES (9, 1, 33, 147);
INSERT INTO sqltutor.linky VALUES (9, 1, 34, 235);
INSERT INTO sqltutor.linky VALUES (9, 1, 35, 212);
INSERT INTO sqltutor.linky VALUES (9, 1, 36, 27);
INSERT INTO sqltutor.linky VALUES (9, 1, 37, 72);
INSERT INTO sqltutor.linky VALUES (9, 2, 1, 204);
INSERT INTO sqltutor.linky VALUES (9, 2, 2, 72);
INSERT INTO sqltutor.linky VALUES (9, 2, 3, 27);
INSERT INTO sqltutor.linky VALUES (9, 2, 4, 212);
INSERT INTO sqltutor.linky VALUES (9, 2, 5, 235);
INSERT INTO sqltutor.linky VALUES (9, 2, 6, 147);
INSERT INTO sqltutor.linky VALUES (9, 2, 7, 10);
INSERT INTO sqltutor.linky VALUES (9, 2, 8, 131);
INSERT INTO sqltutor.linky VALUES (9, 2, 9, 131);
INSERT INTO sqltutor.linky VALUES (9, 2, 10, 149);
INSERT INTO sqltutor.linky VALUES (9, 2, 11, 151);
INSERT INTO sqltutor.linky VALUES (9, 2, 12, 96);
INSERT INTO sqltutor.linky VALUES (9, 2, 13, 55);
INSERT INTO sqltutor.linky VALUES (9, 2, 14, 46);
INSERT INTO sqltutor.linky VALUES (9, 2, 15, 60);
INSERT INTO sqltutor.linky VALUES (9, 2, 16, 234);
INSERT INTO sqltutor.linky VALUES (9, 2, 17, 244);
INSERT INTO sqltutor.linky VALUES (9, 2, 18, 89);
INSERT INTO sqltutor.linky VALUES (9, 2, 19, 138);
INSERT INTO sqltutor.linky VALUES (9, 2, 20, 137);
INSERT INTO sqltutor.linky VALUES (9, 2, 21, 225);
INSERT INTO sqltutor.linky VALUES (9, 2, 22, 216);
INSERT INTO sqltutor.linky VALUES (9, 2, 23, 3);
INSERT INTO sqltutor.linky VALUES (9, 2, 24, 2);
INSERT INTO sqltutor.linky VALUES (9, 2, 25, 7);
INSERT INTO sqltutor.linky VALUES (9, 2, 26, 233);
INSERT INTO sqltutor.linky VALUES (9, 2, 27, 71);
INSERT INTO sqltutor.linky VALUES (9, 2, 28, 67);
INSERT INTO sqltutor.linky VALUES (9, 2, 29, 76);
INSERT INTO sqltutor.linky VALUES (8, 2, 49, 36);
INSERT INTO sqltutor.linky VALUES (9, 2, 30, 174);
INSERT INTO sqltutor.linky VALUES (9, 2, 31, 53);
INSERT INTO sqltutor.linky VALUES (9, 2, 32, 248);
INSERT INTO sqltutor.linky VALUES (9, 2, 33, 111);
INSERT INTO sqltutor.linky VALUES (9, 2, 34, 79);
INSERT INTO sqltutor.linky VALUES (9, 2, 35, 49);
INSERT INTO sqltutor.linky VALUES (9, 2, 36, 198);
INSERT INTO sqltutor.linky VALUES (9, 2, 37, 11);
INSERT INTO sqltutor.linky VALUES (10, 1, 1, 195);
INSERT INTO sqltutor.linky VALUES (10, 1, 2, 11);
INSERT INTO sqltutor.linky VALUES (10, 1, 3, 198);
INSERT INTO sqltutor.linky VALUES (10, 1, 4, 49);
INSERT INTO sqltutor.linky VALUES (10, 1, 5, 79);
INSERT INTO sqltutor.linky VALUES (10, 1, 6, 111);
INSERT INTO sqltutor.linky VALUES (10, 1, 7, 248);
INSERT INTO sqltutor.linky VALUES (10, 1, 8, 53);
INSERT INTO sqltutor.linky VALUES (10, 1, 9, 174);
INSERT INTO sqltutor.linky VALUES (10, 1, 10, 76);
INSERT INTO sqltutor.linky VALUES (10, 1, 11, 67);
INSERT INTO sqltutor.linky VALUES (10, 1, 12, 71);
INSERT INTO sqltutor.linky VALUES (10, 1, 13, 233);
INSERT INTO sqltutor.linky VALUES (10, 1, 14, 7);
INSERT INTO sqltutor.linky VALUES (10, 1, 15, 2);
INSERT INTO sqltutor.linky VALUES (10, 1, 16, 260);
INSERT INTO sqltutor.linky VALUES (10, 1, 17, 157);
INSERT INTO sqltutor.linky VALUES (10, 1, 18, 65);
INSERT INTO sqltutor.linky VALUES (10, 1, 19, 209);
INSERT INTO sqltutor.linky VALUES (10, 1, 20, 57);
INSERT INTO sqltutor.linky VALUES (10, 1, 21, 134);
INSERT INTO sqltutor.linky VALUES (10, 1, 22, 215);
INSERT INTO sqltutor.linky VALUES (10, 1, 23, 240);
INSERT INTO sqltutor.linky VALUES (10, 1, 24, 160);
INSERT INTO sqltutor.linky VALUES (10, 1, 25, 153);
INSERT INTO sqltutor.linky VALUES (10, 1, 26, 40);
INSERT INTO sqltutor.linky VALUES (10, 1, 27, 150);
INSERT INTO sqltutor.linky VALUES (10, 1, 28, 262);
INSERT INTO sqltutor.linky VALUES (10, 1, 29, 106);
INSERT INTO sqltutor.linky VALUES (10, 1, 30, 131);
INSERT INTO sqltutor.linky VALUES (10, 1, 31, 10);
INSERT INTO sqltutor.linky VALUES (10, 1, 32, 78);
INSERT INTO sqltutor.linky VALUES (10, 1, 33, 158);
INSERT INTO sqltutor.linky VALUES (10, 1, 34, 208);
INSERT INTO sqltutor.linky VALUES (10, 1, 35, 227);
INSERT INTO sqltutor.linky VALUES (10, 1, 36, 246);
INSERT INTO sqltutor.linky VALUES (10, 1, 37, 19);
INSERT INTO sqltutor.linky VALUES (10, 1, 38, 254);
INSERT INTO sqltutor.linky VALUES (10, 1, 39, 148);
INSERT INTO sqltutor.linky VALUES (10, 1, 40, 70);
INSERT INTO sqltutor.linky VALUES (10, 1, 41, 73);
INSERT INTO sqltutor.linky VALUES (10, 1, 42, 213);
INSERT INTO sqltutor.linky VALUES (10, 1, 43, 86);
INSERT INTO sqltutor.linky VALUES (10, 1, 44, 87);
INSERT INTO sqltutor.linky VALUES (10, 1, 45, 210);
INSERT INTO sqltutor.linky VALUES (10, 2, 1, 192);
INSERT INTO sqltutor.linky VALUES (10, 2, 2, 221);
INSERT INTO sqltutor.linky VALUES (10, 2, 3, 210);
INSERT INTO sqltutor.linky VALUES (10, 2, 4, 87);
INSERT INTO sqltutor.linky VALUES (10, 2, 5, 86);
INSERT INTO sqltutor.linky VALUES (10, 2, 6, 213);
INSERT INTO sqltutor.linky VALUES (10, 2, 7, 73);
INSERT INTO sqltutor.linky VALUES (10, 2, 8, 70);
INSERT INTO sqltutor.linky VALUES (10, 2, 9, 148);
INSERT INTO sqltutor.linky VALUES (10, 2, 10, 254);
INSERT INTO sqltutor.linky VALUES (10, 2, 11, 19);
INSERT INTO sqltutor.linky VALUES (10, 2, 12, 246);
INSERT INTO sqltutor.linky VALUES (10, 2, 13, 227);
INSERT INTO sqltutor.linky VALUES (10, 2, 14, 208);
INSERT INTO sqltutor.linky VALUES (10, 2, 15, 35);
INSERT INTO sqltutor.linky VALUES (10, 2, 16, 158);
INSERT INTO sqltutor.linky VALUES (10, 2, 17, 78);
INSERT INTO sqltutor.linky VALUES (10, 2, 18, 10);
INSERT INTO sqltutor.linky VALUES (10, 2, 19, 131);
INSERT INTO sqltutor.linky VALUES (10, 2, 20, 106);
INSERT INTO sqltutor.linky VALUES (10, 2, 21, 262);
INSERT INTO sqltutor.linky VALUES (10, 2, 22, 150);
INSERT INTO sqltutor.linky VALUES (10, 2, 23, 40);
INSERT INTO sqltutor.linky VALUES (10, 2, 24, 153);
INSERT INTO sqltutor.linky VALUES (10, 2, 25, 160);
INSERT INTO sqltutor.linky VALUES (10, 2, 26, 240);
INSERT INTO sqltutor.linky VALUES (10, 2, 27, 215);
INSERT INTO sqltutor.linky VALUES (10, 2, 28, 134);
INSERT INTO sqltutor.linky VALUES (10, 2, 29, 57);
INSERT INTO sqltutor.linky VALUES (10, 2, 30, 209);
INSERT INTO sqltutor.linky VALUES (10, 2, 31, 65);
INSERT INTO sqltutor.linky VALUES (10, 2, 32, 110);
INSERT INTO sqltutor.linky VALUES (10, 2, 33, 157);
INSERT INTO sqltutor.linky VALUES (10, 2, 34, 260);
INSERT INTO sqltutor.linky VALUES (10, 2, 35, 2);
INSERT INTO sqltutor.linky VALUES (10, 2, 36, 7);
INSERT INTO sqltutor.linky VALUES (10, 2, 37, 233);
INSERT INTO sqltutor.linky VALUES (10, 2, 38, 71);
INSERT INTO sqltutor.linky VALUES (10, 2, 39, 67);
INSERT INTO sqltutor.linky VALUES (10, 2, 40, 76);
INSERT INTO sqltutor.linky VALUES (10, 2, 41, 174);
INSERT INTO sqltutor.linky VALUES (10, 2, 42, 53);
INSERT INTO sqltutor.linky VALUES (10, 2, 43, 248);
INSERT INTO sqltutor.linky VALUES (10, 2, 44, 111);
INSERT INTO sqltutor.linky VALUES (10, 2, 45, 79);
INSERT INTO sqltutor.linky VALUES (10, 2, 46, 49);
INSERT INTO sqltutor.linky VALUES (10, 2, 47, 198);
INSERT INTO sqltutor.linky VALUES (10, 2, 48, 11);
INSERT INTO sqltutor.linky VALUES (11, 1, 1, 205);
INSERT INTO sqltutor.linky VALUES (11, 1, 2, 218);
INSERT INTO sqltutor.linky VALUES (11, 1, 3, 28);
INSERT INTO sqltutor.linky VALUES (11, 1, 4, 162);
INSERT INTO sqltutor.linky VALUES (11, 1, 5, 107);
INSERT INTO sqltutor.linky VALUES (11, 1, 6, 166);
INSERT INTO sqltutor.linky VALUES (11, 1, 7, 50);
INSERT INTO sqltutor.linky VALUES (11, 1, 8, 133);
INSERT INTO sqltutor.linky VALUES (11, 1, 9, 143);
INSERT INTO sqltutor.linky VALUES (11, 1, 10, 17);
INSERT INTO sqltutor.linky VALUES (11, 1, 11, 57);
INSERT INTO sqltutor.linky VALUES (11, 1, 12, 112);
INSERT INTO sqltutor.linky VALUES (11, 1, 13, 58);
INSERT INTO sqltutor.linky VALUES (11, 1, 14, 239);
INSERT INTO sqltutor.linky VALUES (11, 1, 15, 62);
INSERT INTO sqltutor.linky VALUES (11, 1, 16, 183);
INSERT INTO sqltutor.linky VALUES (11, 1, 17, 40);
INSERT INTO sqltutor.linky VALUES (11, 1, 18, 150);
INSERT INTO sqltutor.linky VALUES (11, 1, 19, 262);
INSERT INTO sqltutor.linky VALUES (11, 1, 20, 262);
INSERT INTO sqltutor.linky VALUES (11, 1, 21, 241);
INSERT INTO sqltutor.linky VALUES (11, 1, 22, 80);
INSERT INTO sqltutor.linky VALUES (11, 1, 23, 250);
INSERT INTO sqltutor.linky VALUES (11, 1, 24, 238);
INSERT INTO sqltutor.linky VALUES (11, 1, 25, 201);
INSERT INTO sqltutor.linky VALUES (11, 1, 26, 261);
INSERT INTO sqltutor.linky VALUES (11, 1, 27, 140);
INSERT INTO sqltutor.linky VALUES (11, 2, 1, 23);
INSERT INTO sqltutor.linky VALUES (11, 2, 2, 140);
INSERT INTO sqltutor.linky VALUES (11, 2, 3, 261);
INSERT INTO sqltutor.linky VALUES (11, 2, 4, 201);
INSERT INTO sqltutor.linky VALUES (11, 2, 5, 250);
INSERT INTO sqltutor.linky VALUES (11, 2, 6, 80);
INSERT INTO sqltutor.linky VALUES (11, 2, 7, 241);
INSERT INTO sqltutor.linky VALUES (11, 2, 8, 262);
INSERT INTO sqltutor.linky VALUES (11, 2, 9, 262);
INSERT INTO sqltutor.linky VALUES (11, 2, 10, 150);
INSERT INTO sqltutor.linky VALUES (11, 2, 11, 40);
INSERT INTO sqltutor.linky VALUES (11, 2, 12, 183);
INSERT INTO sqltutor.linky VALUES (11, 2, 13, 62);
INSERT INTO sqltutor.linky VALUES (11, 2, 14, 239);
INSERT INTO sqltutor.linky VALUES (11, 2, 15, 58);
INSERT INTO sqltutor.linky VALUES (11, 2, 16, 112);
INSERT INTO sqltutor.linky VALUES (11, 2, 17, 57);
INSERT INTO sqltutor.linky VALUES (11, 2, 18, 17);
INSERT INTO sqltutor.linky VALUES (11, 2, 19, 167);
INSERT INTO sqltutor.linky VALUES (11, 2, 20, 143);
INSERT INTO sqltutor.linky VALUES (11, 2, 21, 133);
INSERT INTO sqltutor.linky VALUES (11, 2, 22, 50);
INSERT INTO sqltutor.linky VALUES (11, 2, 23, 166);
INSERT INTO sqltutor.linky VALUES (11, 2, 24, 107);
INSERT INTO sqltutor.linky VALUES (11, 2, 25, 162);
INSERT INTO sqltutor.linky VALUES (11, 2, 26, 28);
INSERT INTO sqltutor.linky VALUES (11, 2, 27, 218);
INSERT INTO sqltutor.linky VALUES (12, 1, 1, 190);
INSERT INTO sqltutor.linky VALUES (12, 1, 2, 171);
INSERT INTO sqltutor.linky VALUES (12, 1, 3, 26);
INSERT INTO sqltutor.linky VALUES (12, 1, 4, 68);
INSERT INTO sqltutor.linky VALUES (12, 1, 5, 42);
INSERT INTO sqltutor.linky VALUES (12, 1, 6, 48);
INSERT INTO sqltutor.linky VALUES (12, 1, 7, 263);
INSERT INTO sqltutor.linky VALUES (12, 1, 8, 95);
INSERT INTO sqltutor.linky VALUES (12, 1, 9, 30);
INSERT INTO sqltutor.linky VALUES (12, 1, 10, 200);
INSERT INTO sqltutor.linky VALUES (12, 1, 11, 163);
INSERT INTO sqltutor.linky VALUES (12, 1, 12, 132);
INSERT INTO sqltutor.linky VALUES (12, 1, 13, 2);
INSERT INTO sqltutor.linky VALUES (12, 1, 14, 3);
INSERT INTO sqltutor.linky VALUES (12, 1, 15, 216);
INSERT INTO sqltutor.linky VALUES (12, 1, 16, 225);
INSERT INTO sqltutor.linky VALUES (12, 1, 17, 44);
INSERT INTO sqltutor.linky VALUES (12, 1, 18, 100);
INSERT INTO sqltutor.linky VALUES (12, 1, 19, 99);
INSERT INTO sqltutor.linky VALUES (12, 1, 20, 22);
INSERT INTO sqltutor.linky VALUES (12, 1, 21, 214);
INSERT INTO sqltutor.linky VALUES (12, 1, 22, 236);
INSERT INTO sqltutor.linky VALUES (12, 1, 23, 257);
INSERT INTO sqltutor.linky VALUES (12, 1, 24, 119);
INSERT INTO sqltutor.linky VALUES (12, 1, 25, 154);
INSERT INTO sqltutor.linky VALUES (12, 1, 26, 32);
INSERT INTO sqltutor.linky VALUES (12, 1, 27, 103);
INSERT INTO sqltutor.linky VALUES (12, 1, 28, 93);
INSERT INTO sqltutor.linky VALUES (12, 2, 1, 158);
INSERT INTO sqltutor.linky VALUES (12, 2, 2, 93);
INSERT INTO sqltutor.linky VALUES (12, 2, 3, 103);
INSERT INTO sqltutor.linky VALUES (12, 2, 4, 229);
INSERT INTO sqltutor.linky VALUES (12, 2, 5, 154);
INSERT INTO sqltutor.linky VALUES (12, 2, 6, 119);
INSERT INTO sqltutor.linky VALUES (12, 2, 7, 257);
INSERT INTO sqltutor.linky VALUES (12, 2, 8, 236);
INSERT INTO sqltutor.linky VALUES (12, 2, 9, 214);
INSERT INTO sqltutor.linky VALUES (12, 2, 10, 114);
INSERT INTO sqltutor.linky VALUES (12, 2, 11, 22);
INSERT INTO sqltutor.linky VALUES (12, 2, 12, 99);
INSERT INTO sqltutor.linky VALUES (12, 2, 13, 99);
INSERT INTO sqltutor.linky VALUES (12, 2, 14, 100);
INSERT INTO sqltutor.linky VALUES (12, 2, 15, 44);
INSERT INTO sqltutor.linky VALUES (12, 2, 16, 225);
INSERT INTO sqltutor.linky VALUES (12, 2, 17, 216);
INSERT INTO sqltutor.linky VALUES (12, 2, 18, 3);
INSERT INTO sqltutor.linky VALUES (12, 2, 19, 2);
INSERT INTO sqltutor.linky VALUES (12, 2, 20, 132);
INSERT INTO sqltutor.linky VALUES (12, 2, 21, 163);
INSERT INTO sqltutor.linky VALUES (12, 2, 22, 200);
INSERT INTO sqltutor.linky VALUES (12, 2, 23, 30);
INSERT INTO sqltutor.linky VALUES (12, 2, 24, 95);
INSERT INTO sqltutor.linky VALUES (12, 2, 25, 263);
INSERT INTO sqltutor.linky VALUES (12, 2, 26, 48);
INSERT INTO sqltutor.linky VALUES (12, 2, 27, 42);
INSERT INTO sqltutor.linky VALUES (12, 2, 28, 68);
INSERT INTO sqltutor.linky VALUES (12, 2, 29, 26);
INSERT INTO sqltutor.linky VALUES (12, 2, 30, 171);
INSERT INTO sqltutor.linky VALUES (13, 1, 1, 190);
INSERT INTO sqltutor.linky VALUES (13, 1, 2, 171);
INSERT INTO sqltutor.linky VALUES (13, 1, 3, 26);
INSERT INTO sqltutor.linky VALUES (13, 1, 4, 68);
INSERT INTO sqltutor.linky VALUES (13, 1, 5, 42);
INSERT INTO sqltutor.linky VALUES (13, 1, 6, 48);
INSERT INTO sqltutor.linky VALUES (13, 1, 7, 263);
INSERT INTO sqltutor.linky VALUES (13, 1, 8, 95);
INSERT INTO sqltutor.linky VALUES (13, 1, 9, 30);
INSERT INTO sqltutor.linky VALUES (13, 2, 1, 200);
INSERT INTO sqltutor.linky VALUES (13, 2, 2, 30);
INSERT INTO sqltutor.linky VALUES (13, 2, 3, 95);
INSERT INTO sqltutor.linky VALUES (13, 2, 4, 263);
INSERT INTO sqltutor.linky VALUES (13, 2, 5, 48);
INSERT INTO sqltutor.linky VALUES (13, 2, 6, 42);
INSERT INTO sqltutor.linky VALUES (13, 2, 7, 68);
INSERT INTO sqltutor.linky VALUES (13, 2, 8, 26);
INSERT INTO sqltutor.linky VALUES (13, 2, 9, 171);
INSERT INTO sqltutor.linky VALUES (14, 1, 1, 190);
INSERT INTO sqltutor.linky VALUES (14, 1, 2, 171);
INSERT INTO sqltutor.linky VALUES (14, 1, 3, 26);
INSERT INTO sqltutor.linky VALUES (14, 1, 4, 68);
INSERT INTO sqltutor.linky VALUES (14, 1, 5, 42);
INSERT INTO sqltutor.linky VALUES (14, 1, 6, 48);
INSERT INTO sqltutor.linky VALUES (14, 1, 7, 263);
INSERT INTO sqltutor.linky VALUES (14, 1, 8, 95);
INSERT INTO sqltutor.linky VALUES (14, 1, 9, 30);
INSERT INTO sqltutor.linky VALUES (14, 1, 10, 200);
INSERT INTO sqltutor.linky VALUES (14, 1, 11, 163);
INSERT INTO sqltutor.linky VALUES (14, 1, 12, 132);
INSERT INTO sqltutor.linky VALUES (14, 1, 13, 2);
INSERT INTO sqltutor.linky VALUES (14, 1, 14, 260);
INSERT INTO sqltutor.linky VALUES (14, 1, 15, 157);
INSERT INTO sqltutor.linky VALUES (14, 1, 16, 65);
INSERT INTO sqltutor.linky VALUES (14, 1, 17, 89);
INSERT INTO sqltutor.linky VALUES (14, 1, 18, 244);
INSERT INTO sqltutor.linky VALUES (14, 1, 19, 234);
INSERT INTO sqltutor.linky VALUES (14, 1, 20, 60);
INSERT INTO sqltutor.linky VALUES (14, 1, 21, 105);
INSERT INTO sqltutor.linky VALUES (14, 1, 22, 135);
INSERT INTO sqltutor.linky VALUES (14, 1, 23, 37);
INSERT INTO sqltutor.linky VALUES (14, 1, 24, 214);
INSERT INTO sqltutor.linky VALUES (14, 1, 25, 236);
INSERT INTO sqltutor.linky VALUES (14, 1, 26, 257);
INSERT INTO sqltutor.linky VALUES (14, 1, 27, 119);
INSERT INTO sqltutor.linky VALUES (14, 1, 28, 222);
INSERT INTO sqltutor.linky VALUES (14, 1, 29, 127);
INSERT INTO sqltutor.linky VALUES (14, 1, 30, 45);
INSERT INTO sqltutor.linky VALUES (14, 1, 31, 70);
INSERT INTO sqltutor.linky VALUES (14, 1, 32, 73);
INSERT INTO sqltutor.linky VALUES (14, 1, 33, 16);
INSERT INTO sqltutor.linky VALUES (14, 1, 34, 94);
INSERT INTO sqltutor.linky VALUES (14, 2, 1, 247);
INSERT INTO sqltutor.linky VALUES (14, 2, 2, 94);
INSERT INTO sqltutor.linky VALUES (14, 2, 3, 16);
INSERT INTO sqltutor.linky VALUES (14, 2, 4, 73);
INSERT INTO sqltutor.linky VALUES (14, 2, 5, 70);
INSERT INTO sqltutor.linky VALUES (14, 2, 6, 45);
INSERT INTO sqltutor.linky VALUES (14, 2, 7, 127);
INSERT INTO sqltutor.linky VALUES (14, 2, 8, 222);
INSERT INTO sqltutor.linky VALUES (14, 2, 9, 119);
INSERT INTO sqltutor.linky VALUES (14, 2, 10, 257);
INSERT INTO sqltutor.linky VALUES (14, 2, 11, 257);
INSERT INTO sqltutor.linky VALUES (14, 2, 12, 236);
INSERT INTO sqltutor.linky VALUES (14, 2, 13, 214);
INSERT INTO sqltutor.linky VALUES (14, 2, 14, 114);
INSERT INTO sqltutor.linky VALUES (14, 2, 15, 37);
INSERT INTO sqltutor.linky VALUES (14, 2, 16, 135);
INSERT INTO sqltutor.linky VALUES (14, 2, 17, 105);
INSERT INTO sqltutor.linky VALUES (14, 2, 18, 60);
INSERT INTO sqltutor.linky VALUES (14, 2, 19, 234);
INSERT INTO sqltutor.linky VALUES (14, 2, 20, 244);
INSERT INTO sqltutor.linky VALUES (14, 2, 21, 89);
INSERT INTO sqltutor.linky VALUES (14, 2, 22, 65);
INSERT INTO sqltutor.linky VALUES (14, 2, 23, 110);
INSERT INTO sqltutor.linky VALUES (14, 2, 24, 157);
INSERT INTO sqltutor.linky VALUES (14, 2, 25, 260);
INSERT INTO sqltutor.linky VALUES (14, 2, 26, 2);
INSERT INTO sqltutor.linky VALUES (14, 2, 27, 132);
INSERT INTO sqltutor.linky VALUES (14, 2, 28, 163);
INSERT INTO sqltutor.linky VALUES (14, 2, 29, 200);
INSERT INTO sqltutor.linky VALUES (14, 2, 30, 30);
INSERT INTO sqltutor.linky VALUES (14, 2, 31, 95);
INSERT INTO sqltutor.linky VALUES (14, 2, 32, 263);
INSERT INTO sqltutor.linky VALUES (14, 2, 33, 48);
INSERT INTO sqltutor.linky VALUES (14, 2, 34, 42);
INSERT INTO sqltutor.linky VALUES (14, 2, 35, 68);
INSERT INTO sqltutor.linky VALUES (14, 2, 36, 26);
INSERT INTO sqltutor.linky VALUES (14, 2, 37, 171);
INSERT INTO sqltutor.linky VALUES (16, 1, 1, 118);
INSERT INTO sqltutor.linky VALUES (16, 1, 2, 164);
INSERT INTO sqltutor.linky VALUES (16, 1, 3, 181);
INSERT INTO sqltutor.linky VALUES (16, 1, 4, 39);
INSERT INTO sqltutor.linky VALUES (16, 1, 5, 85);
INSERT INTO sqltutor.linky VALUES (16, 1, 6, 169);
INSERT INTO sqltutor.linky VALUES (16, 1, 7, 258);
INSERT INTO sqltutor.linky VALUES (16, 1, 8, 157);
INSERT INTO sqltutor.linky VALUES (16, 1, 9, 157);
INSERT INTO sqltutor.linky VALUES (16, 1, 10, 65);
INSERT INTO sqltutor.linky VALUES (16, 1, 11, 209);
INSERT INTO sqltutor.linky VALUES (16, 1, 12, 57);
INSERT INTO sqltutor.linky VALUES (16, 1, 13, 134);
INSERT INTO sqltutor.linky VALUES (16, 1, 14, 215);
INSERT INTO sqltutor.linky VALUES (16, 1, 15, 240);
INSERT INTO sqltutor.linky VALUES (16, 1, 16, 160);
INSERT INTO sqltutor.linky VALUES (16, 1, 17, 153);
INSERT INTO sqltutor.linky VALUES (16, 1, 18, 40);
INSERT INTO sqltutor.linky VALUES (16, 1, 19, 150);
INSERT INTO sqltutor.linky VALUES (16, 1, 20, 262);
INSERT INTO sqltutor.linky VALUES (16, 1, 21, 106);
INSERT INTO sqltutor.linky VALUES (16, 1, 22, 131);
INSERT INTO sqltutor.linky VALUES (16, 1, 23, 10);
INSERT INTO sqltutor.linky VALUES (16, 1, 24, 147);
INSERT INTO sqltutor.linky VALUES (16, 1, 25, 235);
INSERT INTO sqltutor.linky VALUES (16, 1, 26, 212);
INSERT INTO sqltutor.linky VALUES (16, 1, 27, 27);
INSERT INTO sqltutor.linky VALUES (16, 1, 28, 72);
INSERT INTO sqltutor.linky VALUES (16, 2, 1, 204);
INSERT INTO sqltutor.linky VALUES (16, 2, 2, 72);
INSERT INTO sqltutor.linky VALUES (16, 2, 3, 27);
INSERT INTO sqltutor.linky VALUES (16, 2, 4, 212);
INSERT INTO sqltutor.linky VALUES (16, 2, 5, 235);
INSERT INTO sqltutor.linky VALUES (16, 2, 6, 147);
INSERT INTO sqltutor.linky VALUES (16, 2, 7, 10);
INSERT INTO sqltutor.linky VALUES (16, 2, 8, 131);
INSERT INTO sqltutor.linky VALUES (16, 2, 9, 106);
INSERT INTO sqltutor.linky VALUES (16, 2, 10, 262);
INSERT INTO sqltutor.linky VALUES (16, 2, 11, 150);
INSERT INTO sqltutor.linky VALUES (16, 2, 12, 40);
INSERT INTO sqltutor.linky VALUES (16, 2, 13, 153);
INSERT INTO sqltutor.linky VALUES (16, 2, 14, 160);
INSERT INTO sqltutor.linky VALUES (16, 2, 15, 240);
INSERT INTO sqltutor.linky VALUES (16, 2, 16, 215);
INSERT INTO sqltutor.linky VALUES (16, 2, 17, 134);
INSERT INTO sqltutor.linky VALUES (16, 2, 18, 57);
INSERT INTO sqltutor.linky VALUES (16, 2, 19, 209);
INSERT INTO sqltutor.linky VALUES (16, 2, 20, 65);
INSERT INTO sqltutor.linky VALUES (16, 2, 21, 110);
INSERT INTO sqltutor.linky VALUES (16, 2, 22, 157);
INSERT INTO sqltutor.linky VALUES (16, 2, 23, 157);
INSERT INTO sqltutor.linky VALUES (16, 2, 24, 258);
INSERT INTO sqltutor.linky VALUES (16, 2, 25, 169);
INSERT INTO sqltutor.linky VALUES (16, 2, 26, 85);
INSERT INTO sqltutor.linky VALUES (16, 2, 27, 39);
INSERT INTO sqltutor.linky VALUES (16, 2, 28, 181);
INSERT INTO sqltutor.linky VALUES (16, 2, 29, 164);
INSERT INTO sqltutor.linky VALUES (17, 1, 1, 92);
INSERT INTO sqltutor.linky VALUES (17, 1, 2, 194);
INSERT INTO sqltutor.linky VALUES (17, 1, 3, 108);
INSERT INTO sqltutor.linky VALUES (17, 1, 4, 228);
INSERT INTO sqltutor.linky VALUES (17, 1, 5, 172);
INSERT INTO sqltutor.linky VALUES (17, 1, 6, 20);
INSERT INTO sqltutor.linky VALUES (17, 1, 7, 122);
INSERT INTO sqltutor.linky VALUES (17, 1, 8, 109);
INSERT INTO sqltutor.linky VALUES (17, 1, 9, 6);
INSERT INTO sqltutor.linky VALUES (17, 1, 10, 24);
INSERT INTO sqltutor.linky VALUES (17, 1, 11, 118);
INSERT INTO sqltutor.linky VALUES (17, 1, 12, 164);
INSERT INTO sqltutor.linky VALUES (17, 1, 13, 181);
INSERT INTO sqltutor.linky VALUES (17, 1, 14, 39);
INSERT INTO sqltutor.linky VALUES (17, 1, 15, 85);
INSERT INTO sqltutor.linky VALUES (17, 1, 16, 169);
INSERT INTO sqltutor.linky VALUES (17, 1, 17, 258);
INSERT INTO sqltutor.linky VALUES (17, 1, 18, 157);
INSERT INTO sqltutor.linky VALUES (17, 1, 19, 61);
INSERT INTO sqltutor.linky VALUES (17, 1, 20, 137);
INSERT INTO sqltutor.linky VALUES (17, 1, 21, 206);
INSERT INTO sqltutor.linky VALUES (17, 1, 22, 177);
INSERT INTO sqltutor.linky VALUES (17, 1, 23, 22);
INSERT INTO sqltutor.linky VALUES (17, 1, 24, 214);
INSERT INTO sqltutor.linky VALUES (17, 1, 25, 236);
INSERT INTO sqltutor.linky VALUES (17, 1, 26, 257);
INSERT INTO sqltutor.linky VALUES (17, 1, 27, 119);
INSERT INTO sqltutor.linky VALUES (17, 1, 28, 222);
INSERT INTO sqltutor.linky VALUES (17, 1, 29, 127);
INSERT INTO sqltutor.linky VALUES (17, 1, 30, 45);
INSERT INTO sqltutor.linky VALUES (17, 1, 31, 70);
INSERT INTO sqltutor.linky VALUES (17, 1, 32, 73);
INSERT INTO sqltutor.linky VALUES (17, 1, 33, 213);
INSERT INTO sqltutor.linky VALUES (17, 1, 34, 86);
INSERT INTO sqltutor.linky VALUES (17, 1, 35, 87);
INSERT INTO sqltutor.linky VALUES (17, 1, 36, 210);
INSERT INTO sqltutor.linky VALUES (17, 2, 1, 192);
INSERT INTO sqltutor.linky VALUES (17, 2, 2, 221);
INSERT INTO sqltutor.linky VALUES (17, 2, 3, 210);
INSERT INTO sqltutor.linky VALUES (17, 2, 4, 87);
INSERT INTO sqltutor.linky VALUES (17, 2, 5, 86);
INSERT INTO sqltutor.linky VALUES (17, 2, 6, 213);
INSERT INTO sqltutor.linky VALUES (17, 2, 7, 73);
INSERT INTO sqltutor.linky VALUES (17, 2, 8, 70);
INSERT INTO sqltutor.linky VALUES (17, 2, 9, 45);
INSERT INTO sqltutor.linky VALUES (17, 2, 10, 127);
INSERT INTO sqltutor.linky VALUES (17, 2, 11, 222);
INSERT INTO sqltutor.linky VALUES (17, 2, 12, 119);
INSERT INTO sqltutor.linky VALUES (17, 2, 13, 257);
INSERT INTO sqltutor.linky VALUES (17, 2, 14, 236);
INSERT INTO sqltutor.linky VALUES (17, 2, 15, 214);
INSERT INTO sqltutor.linky VALUES (17, 2, 16, 114);
INSERT INTO sqltutor.linky VALUES (17, 2, 17, 22);
INSERT INTO sqltutor.linky VALUES (17, 2, 18, 177);
INSERT INTO sqltutor.linky VALUES (17, 2, 19, 206);
INSERT INTO sqltutor.linky VALUES (17, 2, 20, 66);
INSERT INTO sqltutor.linky VALUES (17, 2, 21, 137);
INSERT INTO sqltutor.linky VALUES (17, 2, 22, 61);
INSERT INTO sqltutor.linky VALUES (17, 2, 23, 157);
INSERT INTO sqltutor.linky VALUES (17, 2, 24, 258);
INSERT INTO sqltutor.linky VALUES (17, 2, 25, 169);
INSERT INTO sqltutor.linky VALUES (17, 2, 26, 85);
INSERT INTO sqltutor.linky VALUES (17, 2, 27, 39);
INSERT INTO sqltutor.linky VALUES (17, 2, 28, 181);
INSERT INTO sqltutor.linky VALUES (17, 2, 29, 164);
INSERT INTO sqltutor.linky VALUES (17, 2, 30, 118);
INSERT INTO sqltutor.linky VALUES (17, 2, 31, 24);
INSERT INTO sqltutor.linky VALUES (17, 2, 32, 6);
INSERT INTO sqltutor.linky VALUES (17, 2, 33, 109);
INSERT INTO sqltutor.linky VALUES (17, 2, 34, 122);
INSERT INTO sqltutor.linky VALUES (17, 2, 35, 20);
INSERT INTO sqltutor.linky VALUES (17, 2, 36, 172);
INSERT INTO sqltutor.linky VALUES (17, 2, 37, 228);
INSERT INTO sqltutor.linky VALUES (17, 2, 38, 108);
INSERT INTO sqltutor.linky VALUES (18, 1, 1, 161);
INSERT INTO sqltutor.linky VALUES (18, 1, 2, 144);
INSERT INTO sqltutor.linky VALUES (18, 1, 3, 237);
INSERT INTO sqltutor.linky VALUES (18, 1, 4, 245);
INSERT INTO sqltutor.linky VALUES (18, 1, 5, 5);
INSERT INTO sqltutor.linky VALUES (18, 1, 6, 152);
INSERT INTO sqltutor.linky VALUES (18, 1, 7, 189);
INSERT INTO sqltutor.linky VALUES (18, 1, 8, 251);
INSERT INTO sqltutor.linky VALUES (18, 1, 9, 176);
INSERT INTO sqltutor.linky VALUES (18, 1, 10, 54);
INSERT INTO sqltutor.linky VALUES (18, 1, 11, 29);
INSERT INTO sqltutor.linky VALUES (18, 1, 12, 99);
INSERT INTO sqltutor.linky VALUES (18, 1, 13, 206);
INSERT INTO sqltutor.linky VALUES (18, 1, 14, 66);
INSERT INTO sqltutor.linky VALUES (18, 1, 15, 137);
INSERT INTO sqltutor.linky VALUES (18, 1, 16, 138);
INSERT INTO sqltutor.linky VALUES (18, 1, 17, 65);
INSERT INTO sqltutor.linky VALUES (18, 1, 18, 110);
INSERT INTO sqltutor.linky VALUES (18, 1, 19, 13);
INSERT INTO sqltutor.linky VALUES (18, 1, 20, 1);
INSERT INTO sqltutor.linky VALUES (18, 1, 21, 155);
INSERT INTO sqltutor.linky VALUES (18, 1, 22, 217);
INSERT INTO sqltutor.linky VALUES (18, 1, 23, 34);
INSERT INTO sqltutor.linky VALUES (18, 1, 24, 133);
INSERT INTO sqltutor.linky VALUES (18, 1, 25, 142);
INSERT INTO sqltutor.linky VALUES (18, 1, 26, 159);
INSERT INTO sqltutor.linky VALUES (18, 1, 27, 179);
INSERT INTO sqltutor.linky VALUES (18, 1, 28, 139);
INSERT INTO sqltutor.linky VALUES (18, 2, 1, 249);
INSERT INTO sqltutor.linky VALUES (18, 2, 2, 139);
INSERT INTO sqltutor.linky VALUES (18, 2, 3, 179);
INSERT INTO sqltutor.linky VALUES (18, 2, 4, 159);
INSERT INTO sqltutor.linky VALUES (18, 2, 5, 142);
INSERT INTO sqltutor.linky VALUES (18, 2, 6, 133);
INSERT INTO sqltutor.linky VALUES (18, 2, 7, 34);
INSERT INTO sqltutor.linky VALUES (18, 2, 8, 217);
INSERT INTO sqltutor.linky VALUES (18, 2, 9, 155);
INSERT INTO sqltutor.linky VALUES (18, 2, 10, 1);
INSERT INTO sqltutor.linky VALUES (18, 2, 11, 13);
INSERT INTO sqltutor.linky VALUES (18, 2, 12, 65);
INSERT INTO sqltutor.linky VALUES (18, 2, 13, 138);
INSERT INTO sqltutor.linky VALUES (18, 2, 14, 137);
INSERT INTO sqltutor.linky VALUES (18, 2, 15, 137);
INSERT INTO sqltutor.linky VALUES (18, 2, 16, 206);
INSERT INTO sqltutor.linky VALUES (18, 2, 17, 99);
INSERT INTO sqltutor.linky VALUES (18, 2, 18, 29);
INSERT INTO sqltutor.linky VALUES (18, 2, 19, 54);
INSERT INTO sqltutor.linky VALUES (18, 2, 20, 176);
INSERT INTO sqltutor.linky VALUES (18, 2, 21, 251);
INSERT INTO sqltutor.linky VALUES (18, 2, 22, 189);
INSERT INTO sqltutor.linky VALUES (18, 2, 23, 152);
INSERT INTO sqltutor.linky VALUES (18, 2, 24, 5);
INSERT INTO sqltutor.linky VALUES (18, 2, 25, 245);
INSERT INTO sqltutor.linky VALUES (18, 2, 26, 237);
INSERT INTO sqltutor.linky VALUES (18, 2, 27, 144);
INSERT INTO sqltutor.linky VALUES (19, 1, 1, 90);
INSERT INTO sqltutor.linky VALUES (19, 1, 2, 193);
INSERT INTO sqltutor.linky VALUES (19, 1, 3, 47);
INSERT INTO sqltutor.linky VALUES (19, 1, 4, 69);
INSERT INTO sqltutor.linky VALUES (19, 1, 5, 207);
INSERT INTO sqltutor.linky VALUES (19, 1, 6, 141);
INSERT INTO sqltutor.linky VALUES (19, 1, 7, 75);
INSERT INTO sqltutor.linky VALUES (19, 1, 8, 175);
INSERT INTO sqltutor.linky VALUES (19, 1, 9, 203);
INSERT INTO sqltutor.linky VALUES (19, 1, 10, 126);
INSERT INTO sqltutor.linky VALUES (19, 1, 11, 173);
INSERT INTO sqltutor.linky VALUES (19, 1, 12, 232);
INSERT INTO sqltutor.linky VALUES (19, 1, 13, 4);
INSERT INTO sqltutor.linky VALUES (19, 1, 14, 158);
INSERT INTO sqltutor.linky VALUES (19, 1, 15, 158);
INSERT INTO sqltutor.linky VALUES (19, 1, 16, 78);
INSERT INTO sqltutor.linky VALUES (19, 1, 17, 10);
INSERT INTO sqltutor.linky VALUES (19, 1, 18, 131);
INSERT INTO sqltutor.linky VALUES (19, 1, 19, 106);
INSERT INTO sqltutor.linky VALUES (19, 1, 20, 262);
INSERT INTO sqltutor.linky VALUES (19, 1, 21, 241);
INSERT INTO sqltutor.linky VALUES (19, 1, 22, 80);
INSERT INTO sqltutor.linky VALUES (19, 1, 23, 250);
INSERT INTO sqltutor.linky VALUES (19, 1, 24, 117);
INSERT INTO sqltutor.linky VALUES (19, 1, 25, 211);
INSERT INTO sqltutor.linky VALUES (19, 1, 26, 130);
INSERT INTO sqltutor.linky VALUES (19, 2, 1, 185);
INSERT INTO sqltutor.linky VALUES (19, 2, 2, 123);
INSERT INTO sqltutor.linky VALUES (19, 2, 3, 130);
INSERT INTO sqltutor.linky VALUES (19, 2, 4, 211);
INSERT INTO sqltutor.linky VALUES (19, 2, 5, 250);
INSERT INTO sqltutor.linky VALUES (19, 2, 6, 80);
INSERT INTO sqltutor.linky VALUES (19, 2, 7, 241);
INSERT INTO sqltutor.linky VALUES (19, 2, 8, 262);
INSERT INTO sqltutor.linky VALUES (19, 2, 9, 106);
INSERT INTO sqltutor.linky VALUES (19, 2, 10, 131);
INSERT INTO sqltutor.linky VALUES (19, 2, 11, 10);
INSERT INTO sqltutor.linky VALUES (19, 2, 12, 78);
INSERT INTO sqltutor.linky VALUES (19, 2, 13, 158);
INSERT INTO sqltutor.linky VALUES (19, 2, 14, 4);
INSERT INTO sqltutor.linky VALUES (19, 2, 15, 232);
INSERT INTO sqltutor.linky VALUES (19, 2, 16, 173);
INSERT INTO sqltutor.linky VALUES (19, 2, 17, 126);
INSERT INTO sqltutor.linky VALUES (19, 2, 18, 203);
INSERT INTO sqltutor.linky VALUES (19, 2, 19, 175);
INSERT INTO sqltutor.linky VALUES (19, 2, 20, 75);
INSERT INTO sqltutor.linky VALUES (19, 2, 21, 141);
INSERT INTO sqltutor.linky VALUES (19, 2, 22, 207);
INSERT INTO sqltutor.linky VALUES (19, 2, 23, 69);
INSERT INTO sqltutor.linky VALUES (19, 2, 24, 47);
INSERT INTO sqltutor.linky VALUES (19, 2, 25, 193);
INSERT INTO sqltutor.linky VALUES (20, 1, 1, 165);
INSERT INTO sqltutor.linky VALUES (20, 1, 2, 97);
INSERT INTO sqltutor.linky VALUES (20, 1, 3, 242);
INSERT INTO sqltutor.linky VALUES (20, 1, 4, 54);
INSERT INTO sqltutor.linky VALUES (20, 1, 5, 29);
INSERT INTO sqltutor.linky VALUES (20, 1, 6, 99);
INSERT INTO sqltutor.linky VALUES (20, 1, 7, 100);
INSERT INTO sqltutor.linky VALUES (20, 1, 8, 44);
INSERT INTO sqltutor.linky VALUES (20, 1, 9, 225);
INSERT INTO sqltutor.linky VALUES (20, 1, 10, 216);
INSERT INTO sqltutor.linky VALUES (20, 1, 11, 3);
INSERT INTO sqltutor.linky VALUES (20, 1, 12, 2);
INSERT INTO sqltutor.linky VALUES (20, 1, 13, 132);
INSERT INTO sqltutor.linky VALUES (20, 1, 14, 163);
INSERT INTO sqltutor.linky VALUES (20, 1, 15, 200);
INSERT INTO sqltutor.linky VALUES (20, 1, 16, 30);
INSERT INTO sqltutor.linky VALUES (20, 1, 17, 95);
INSERT INTO sqltutor.linky VALUES (20, 1, 18, 263);
INSERT INTO sqltutor.linky VALUES (20, 1, 19, 48);
INSERT INTO sqltutor.linky VALUES (20, 1, 20, 42);
INSERT INTO sqltutor.linky VALUES (20, 1, 21, 68);
INSERT INTO sqltutor.linky VALUES (20, 1, 22, 26);
INSERT INTO sqltutor.linky VALUES (20, 1, 23, 171);
INSERT INTO sqltutor.linky VALUES (20, 2, 1, 190);
INSERT INTO sqltutor.linky VALUES (20, 2, 2, 171);
INSERT INTO sqltutor.linky VALUES (20, 2, 3, 26);
INSERT INTO sqltutor.linky VALUES (20, 2, 4, 68);
INSERT INTO sqltutor.linky VALUES (20, 2, 5, 42);
INSERT INTO sqltutor.linky VALUES (20, 2, 6, 48);
INSERT INTO sqltutor.linky VALUES (20, 2, 7, 263);
INSERT INTO sqltutor.linky VALUES (20, 2, 8, 95);
INSERT INTO sqltutor.linky VALUES (20, 2, 9, 30);
INSERT INTO sqltutor.linky VALUES (20, 2, 10, 200);
INSERT INTO sqltutor.linky VALUES (20, 2, 11, 200);
INSERT INTO sqltutor.linky VALUES (20, 2, 12, 163);
INSERT INTO sqltutor.linky VALUES (20, 2, 13, 132);
INSERT INTO sqltutor.linky VALUES (20, 2, 14, 2);
INSERT INTO sqltutor.linky VALUES (20, 2, 15, 3);
INSERT INTO sqltutor.linky VALUES (20, 2, 16, 216);
INSERT INTO sqltutor.linky VALUES (20, 2, 17, 225);
INSERT INTO sqltutor.linky VALUES (20, 2, 18, 44);
INSERT INTO sqltutor.linky VALUES (20, 2, 19, 100);
INSERT INTO sqltutor.linky VALUES (20, 2, 20, 99);
INSERT INTO sqltutor.linky VALUES (20, 2, 21, 29);
INSERT INTO sqltutor.linky VALUES (20, 2, 22, 54);
INSERT INTO sqltutor.linky VALUES (20, 2, 23, 242);
INSERT INTO sqltutor.linky VALUES (20, 2, 24, 97);
INSERT INTO sqltutor.linky VALUES (21, 1, 1, 92);
INSERT INTO sqltutor.linky VALUES (21, 1, 2, 194);
INSERT INTO sqltutor.linky VALUES (21, 1, 3, 108);
INSERT INTO sqltutor.linky VALUES (21, 1, 4, 228);
INSERT INTO sqltutor.linky VALUES (21, 1, 5, 172);
INSERT INTO sqltutor.linky VALUES (21, 1, 6, 20);
INSERT INTO sqltutor.linky VALUES (21, 1, 7, 122);
INSERT INTO sqltutor.linky VALUES (21, 1, 8, 109);
INSERT INTO sqltutor.linky VALUES (21, 1, 9, 6);
INSERT INTO sqltutor.linky VALUES (21, 1, 10, 24);
INSERT INTO sqltutor.linky VALUES (21, 1, 11, 118);
INSERT INTO sqltutor.linky VALUES (21, 1, 12, 164);
INSERT INTO sqltutor.linky VALUES (21, 1, 13, 181);
INSERT INTO sqltutor.linky VALUES (21, 1, 14, 39);
INSERT INTO sqltutor.linky VALUES (21, 1, 15, 85);
INSERT INTO sqltutor.linky VALUES (21, 1, 16, 169);
INSERT INTO sqltutor.linky VALUES (21, 1, 17, 258);
INSERT INTO sqltutor.linky VALUES (21, 1, 18, 157);
INSERT INTO sqltutor.linky VALUES (21, 1, 19, 61);
INSERT INTO sqltutor.linky VALUES (21, 1, 20, 137);
INSERT INTO sqltutor.linky VALUES (21, 1, 21, 138);
INSERT INTO sqltutor.linky VALUES (21, 1, 22, 113);
INSERT INTO sqltutor.linky VALUES (21, 1, 23, 61);
INSERT INTO sqltutor.linky VALUES (21, 1, 24, 157);
INSERT INTO sqltutor.linky VALUES (21, 1, 25, 258);
INSERT INTO sqltutor.linky VALUES (21, 1, 26, 169);
INSERT INTO sqltutor.linky VALUES (21, 1, 27, 85);
INSERT INTO sqltutor.linky VALUES (21, 1, 28, 39);
INSERT INTO sqltutor.linky VALUES (21, 1, 29, 181);
INSERT INTO sqltutor.linky VALUES (21, 1, 30, 164);
INSERT INTO sqltutor.linky VALUES (21, 1, 31, 118);
INSERT INTO sqltutor.linky VALUES (21, 1, 32, 24);
INSERT INTO sqltutor.linky VALUES (21, 1, 33, 6);
INSERT INTO sqltutor.linky VALUES (21, 1, 34, 109);
INSERT INTO sqltutor.linky VALUES (21, 1, 35, 122);
INSERT INTO sqltutor.linky VALUES (21, 1, 36, 20);
INSERT INTO sqltutor.linky VALUES (21, 1, 37, 172);
INSERT INTO sqltutor.linky VALUES (21, 1, 38, 228);
INSERT INTO sqltutor.linky VALUES (21, 1, 39, 108);
INSERT INTO sqltutor.linky VALUES (22, 2, 1, 8);
INSERT INTO sqltutor.linky VALUES (22, 2, 2, 102);
INSERT INTO sqltutor.linky VALUES (22, 2, 3, 255);
INSERT INTO sqltutor.linky VALUES (22, 2, 4, 186);
INSERT INTO sqltutor.linky VALUES (22, 2, 5, 15);
INSERT INTO sqltutor.linky VALUES (22, 2, 6, 226);
INSERT INTO sqltutor.linky VALUES (22, 2, 7, 38);
INSERT INTO sqltutor.linky VALUES (22, 2, 8, 104);
INSERT INTO sqltutor.linky VALUES (22, 2, 9, 101);
INSERT INTO sqltutor.linky VALUES (22, 2, 10, 170);
INSERT INTO sqltutor.linky VALUES (22, 2, 11, 18);
INSERT INTO sqltutor.linky VALUES (22, 2, 12, 180);
INSERT INTO sqltutor.linky VALUES (22, 2, 13, 77);
INSERT INTO sqltutor.linky VALUES (22, 2, 14, 99);
INSERT INTO sqltutor.linky VALUES (22, 2, 15, 100);
INSERT INTO sqltutor.linky VALUES (22, 2, 16, 44);
INSERT INTO sqltutor.linky VALUES (22, 2, 17, 225);
INSERT INTO sqltutor.linky VALUES (22, 2, 18, 137);
INSERT INTO sqltutor.linky VALUES (22, 2, 19, 138);
INSERT INTO sqltutor.linky VALUES (22, 2, 20, 65);
INSERT INTO sqltutor.linky VALUES (22, 2, 21, 209);
INSERT INTO sqltutor.linky VALUES (22, 2, 22, 57);
INSERT INTO sqltutor.linky VALUES (22, 2, 23, 134);
INSERT INTO sqltutor.linky VALUES (22, 2, 24, 59);
INSERT INTO sqltutor.linky VALUES (22, 2, 25, 83);
INSERT INTO sqltutor.linky VALUES (22, 2, 26, 187);
INSERT INTO sqltutor.linky VALUES (22, 2, 27, 253);
INSERT INTO sqltutor.linky VALUES (22, 2, 28, 21);
INSERT INTO sqltutor.linky VALUES (22, 2, 29, 74);
INSERT INTO sqltutor.linky VALUES (22, 2, 30, 199);
INSERT INTO sqltutor.linky VALUES (22, 2, 31, 84);
INSERT INTO sqltutor.linky VALUES (22, 2, 32, 182);
INSERT INTO sqltutor.linky VALUES (22, 2, 33, 130);
INSERT INTO sqltutor.linky VALUES (22, 2, 34, 123);
INSERT INTO sqltutor.linky VALUES (22, 2, 35, 185);
INSERT INTO sqltutor.linky VALUES (22, 2, 36, 136);
INSERT INTO sqltutor.linky VALUES (22, 2, 37, 259);
INSERT INTO sqltutor.linky VALUES (22, 2, 38, 196);
INSERT INTO sqltutor.linky VALUES (22, 2, 39, 128);
INSERT INTO sqltutor.linky VALUES (22, 2, 40, 52);
INSERT INTO sqltutor.linky VALUES (22, 1, 1, 120);
INSERT INTO sqltutor.linky VALUES (22, 1, 2, 52);
INSERT INTO sqltutor.linky VALUES (22, 1, 3, 128);
INSERT INTO sqltutor.linky VALUES (22, 1, 4, 196);
INSERT INTO sqltutor.linky VALUES (22, 1, 5, 259);
INSERT INTO sqltutor.linky VALUES (22, 1, 6, 136);
INSERT INTO sqltutor.linky VALUES (22, 1, 7, 185);
INSERT INTO sqltutor.linky VALUES (22, 1, 8, 123);
INSERT INTO sqltutor.linky VALUES (22, 1, 9, 130);
INSERT INTO sqltutor.linky VALUES (22, 1, 10, 182);
INSERT INTO sqltutor.linky VALUES (22, 1, 11, 84);
INSERT INTO sqltutor.linky VALUES (22, 1, 12, 199);
INSERT INTO sqltutor.linky VALUES (22, 1, 13, 74);
INSERT INTO sqltutor.linky VALUES (22, 1, 14, 253);
INSERT INTO sqltutor.linky VALUES (22, 1, 15, 187);
INSERT INTO sqltutor.linky VALUES (22, 1, 16, 59);
INSERT INTO sqltutor.linky VALUES (22, 1, 17, 134);
INSERT INTO sqltutor.linky VALUES (22, 1, 18, 57);
INSERT INTO sqltutor.linky VALUES (22, 1, 19, 209);
INSERT INTO sqltutor.linky VALUES (22, 1, 20, 65);
INSERT INTO sqltutor.linky VALUES (22, 1, 21, 138);
INSERT INTO sqltutor.linky VALUES (22, 1, 22, 137);
INSERT INTO sqltutor.linky VALUES (22, 1, 23, 225);
INSERT INTO sqltutor.linky VALUES (22, 1, 24, 44);
INSERT INTO sqltutor.linky VALUES (22, 1, 25, 100);
INSERT INTO sqltutor.linky VALUES (22, 1, 26, 99);
INSERT INTO sqltutor.linky VALUES (22, 1, 27, 77);
INSERT INTO sqltutor.linky VALUES (22, 1, 28, 180);
INSERT INTO sqltutor.linky VALUES (22, 1, 29, 18);
INSERT INTO sqltutor.linky VALUES (22, 1, 30, 170);
INSERT INTO sqltutor.linky VALUES (22, 1, 31, 101);
INSERT INTO sqltutor.linky VALUES (22, 1, 32, 104);
INSERT INTO sqltutor.linky VALUES (22, 1, 33, 38);
INSERT INTO sqltutor.linky VALUES (22, 1, 34, 226);
INSERT INTO sqltutor.linky VALUES (21, 1, 49, 194);
INSERT INTO sqltutor.linky VALUES (22, 1, 35, 15);
INSERT INTO sqltutor.linky VALUES (22, 1, 36, 186);
INSERT INTO sqltutor.linky VALUES (22, 1, 37, 255);
INSERT INTO sqltutor.linky VALUES (22, 1, 38, 102);
INSERT INTO sqltutor.linky VALUES (24, 2, 1, 84);
INSERT INTO sqltutor.linky VALUES (24, 2, 2, 199);
INSERT INTO sqltutor.linky VALUES (24, 2, 3, 74);
INSERT INTO sqltutor.linky VALUES (24, 2, 4, 145);
INSERT INTO sqltutor.linky VALUES (24, 2, 5, 125);
INSERT INTO sqltutor.linky VALUES (24, 2, 6, 156);
INSERT INTO sqltutor.linky VALUES (24, 2, 7, 34);
INSERT INTO sqltutor.linky VALUES (24, 2, 8, 217);
INSERT INTO sqltutor.linky VALUES (24, 2, 9, 155);
INSERT INTO sqltutor.linky VALUES (24, 2, 10, 1);
INSERT INTO sqltutor.linky VALUES (24, 2, 11, 13);
INSERT INTO sqltutor.linky VALUES (24, 2, 12, 65);
INSERT INTO sqltutor.linky VALUES (24, 2, 13, 89);
INSERT INTO sqltutor.linky VALUES (24, 2, 14, 244);
INSERT INTO sqltutor.linky VALUES (24, 2, 15, 234);
INSERT INTO sqltutor.linky VALUES (24, 2, 16, 60);
INSERT INTO sqltutor.linky VALUES (24, 2, 17, 105);
INSERT INTO sqltutor.linky VALUES (24, 2, 18, 9);
INSERT INTO sqltutor.linky VALUES (24, 2, 19, 41);
INSERT INTO sqltutor.linky VALUES (24, 2, 20, 64);
INSERT INTO sqltutor.linky VALUES (24, 2, 21, 81);
INSERT INTO sqltutor.linky VALUES (24, 2, 22, 230);
INSERT INTO sqltutor.linky VALUES (24, 2, 23, 56);
INSERT INTO sqltutor.linky VALUES (24, 2, 24, 158);
INSERT INTO sqltutor.linky VALUES (24, 2, 25, 208);
INSERT INTO sqltutor.linky VALUES (24, 2, 26, 227);
INSERT INTO sqltutor.linky VALUES (24, 2, 27, 246);
INSERT INTO sqltutor.linky VALUES (24, 2, 28, 19);
INSERT INTO sqltutor.linky VALUES (24, 2, 29, 254);
INSERT INTO sqltutor.linky VALUES (24, 2, 30, 148);
INSERT INTO sqltutor.linky VALUES (24, 2, 31, 70);
INSERT INTO sqltutor.linky VALUES (24, 1, 1, 16);
INSERT INTO sqltutor.linky VALUES (24, 1, 2, 73);
INSERT INTO sqltutor.linky VALUES (24, 1, 3, 70);
INSERT INTO sqltutor.linky VALUES (24, 1, 4, 148);
INSERT INTO sqltutor.linky VALUES (24, 1, 5, 254);
INSERT INTO sqltutor.linky VALUES (24, 1, 6, 19);
INSERT INTO sqltutor.linky VALUES (24, 1, 7, 246);
INSERT INTO sqltutor.linky VALUES (24, 1, 8, 227);
INSERT INTO sqltutor.linky VALUES (24, 1, 9, 208);
INSERT INTO sqltutor.linky VALUES (24, 1, 10, 35);
INSERT INTO sqltutor.linky VALUES (24, 1, 11, 158);
INSERT INTO sqltutor.linky VALUES (24, 1, 12, 56);
INSERT INTO sqltutor.linky VALUES (24, 1, 13, 230);
INSERT INTO sqltutor.linky VALUES (24, 1, 14, 81);
INSERT INTO sqltutor.linky VALUES (24, 1, 15, 64);
INSERT INTO sqltutor.linky VALUES (24, 1, 16, 41);
INSERT INTO sqltutor.linky VALUES (24, 1, 17, 9);
INSERT INTO sqltutor.linky VALUES (24, 1, 18, 105);
INSERT INTO sqltutor.linky VALUES (24, 1, 19, 60);
INSERT INTO sqltutor.linky VALUES (24, 1, 20, 234);
INSERT INTO sqltutor.linky VALUES (24, 1, 21, 244);
INSERT INTO sqltutor.linky VALUES (24, 1, 22, 89);
INSERT INTO sqltutor.linky VALUES (24, 1, 23, 65);
INSERT INTO sqltutor.linky VALUES (24, 1, 24, 110);
INSERT INTO sqltutor.linky VALUES (24, 1, 25, 13);
INSERT INTO sqltutor.linky VALUES (24, 1, 26, 1);
INSERT INTO sqltutor.linky VALUES (24, 1, 27, 155);
INSERT INTO sqltutor.linky VALUES (24, 1, 28, 217);
INSERT INTO sqltutor.linky VALUES (24, 1, 29, 34);
INSERT INTO sqltutor.linky VALUES (24, 1, 30, 156);
INSERT INTO sqltutor.linky VALUES (24, 1, 31, 125);
INSERT INTO sqltutor.linky VALUES (24, 1, 32, 145);
INSERT INTO sqltutor.linky VALUES (24, 1, 33, 74);
INSERT INTO sqltutor.linky VALUES (24, 1, 34, 199);
INSERT INTO sqltutor.linky VALUES (25, 2, 1, 202);
INSERT INTO sqltutor.linky VALUES (25, 2, 2, 91);
INSERT INTO sqltutor.linky VALUES (25, 2, 3, 63);
INSERT INTO sqltutor.linky VALUES (25, 2, 4, 214);
INSERT INTO sqltutor.linky VALUES (25, 2, 5, 243);
INSERT INTO sqltutor.linky VALUES (25, 2, 6, 178);
INSERT INTO sqltutor.linky VALUES (25, 2, 7, 32);
INSERT INTO sqltutor.linky VALUES (25, 2, 8, 103);
INSERT INTO sqltutor.linky VALUES (25, 2, 9, 93);
INSERT INTO sqltutor.linky VALUES (25, 2, 10, 158);
INSERT INTO sqltutor.linky VALUES (25, 2, 11, 208);
INSERT INTO sqltutor.linky VALUES (25, 2, 12, 227);
INSERT INTO sqltutor.linky VALUES (25, 2, 13, 246);
INSERT INTO sqltutor.linky VALUES (25, 2, 14, 19);
INSERT INTO sqltutor.linky VALUES (25, 2, 15, 254);
INSERT INTO sqltutor.linky VALUES (25, 2, 16, 148);
INSERT INTO sqltutor.linky VALUES (25, 2, 17, 70);
INSERT INTO sqltutor.linky VALUES (25, 2, 18, 73);
INSERT INTO sqltutor.linky VALUES (25, 2, 19, 16);
INSERT INTO sqltutor.linky VALUES (25, 2, 20, 94);
INSERT INTO sqltutor.linky VALUES (25, 1, 1, 247);
INSERT INTO sqltutor.linky VALUES (25, 1, 2, 94);
INSERT INTO sqltutor.linky VALUES (25, 1, 3, 16);
INSERT INTO sqltutor.linky VALUES (25, 1, 4, 73);
INSERT INTO sqltutor.linky VALUES (25, 1, 5, 70);
INSERT INTO sqltutor.linky VALUES (25, 1, 6, 148);
INSERT INTO sqltutor.linky VALUES (25, 1, 7, 254);
INSERT INTO sqltutor.linky VALUES (25, 1, 8, 19);
INSERT INTO sqltutor.linky VALUES (25, 1, 9, 246);
INSERT INTO sqltutor.linky VALUES (25, 1, 10, 227);
INSERT INTO sqltutor.linky VALUES (25, 1, 11, 208);
INSERT INTO sqltutor.linky VALUES (25, 1, 12, 35);
INSERT INTO sqltutor.linky VALUES (25, 1, 13, 158);
INSERT INTO sqltutor.linky VALUES (25, 1, 14, 93);
INSERT INTO sqltutor.linky VALUES (25, 1, 15, 103);
INSERT INTO sqltutor.linky VALUES (25, 1, 16, 223);
INSERT INTO sqltutor.linky VALUES (25, 1, 17, 178);
INSERT INTO sqltutor.linky VALUES (25, 1, 18, 243);
INSERT INTO sqltutor.linky VALUES (25, 1, 19, 214);
INSERT INTO sqltutor.linky VALUES (25, 1, 20, 63);
INSERT INTO sqltutor.linky VALUES (25, 1, 21, 91);
INSERT INTO sqltutor.linky VALUES (26, 2, 1, 202);
INSERT INTO sqltutor.linky VALUES (26, 2, 2, 91);
INSERT INTO sqltutor.linky VALUES (26, 2, 3, 63);
INSERT INTO sqltutor.linky VALUES (26, 2, 4, 214);
INSERT INTO sqltutor.linky VALUES (26, 2, 5, 114);
INSERT INTO sqltutor.linky VALUES (26, 2, 6, 37);
INSERT INTO sqltutor.linky VALUES (26, 2, 7, 135);
INSERT INTO sqltutor.linky VALUES (24, 2, 49, 73);
INSERT INTO sqltutor.linky VALUES (26, 2, 8, 105);
INSERT INTO sqltutor.linky VALUES (26, 2, 9, 46);
INSERT INTO sqltutor.linky VALUES (26, 2, 10, 55);
INSERT INTO sqltutor.linky VALUES (26, 2, 11, 96);
INSERT INTO sqltutor.linky VALUES (26, 2, 12, 151);
INSERT INTO sqltutor.linky VALUES (26, 2, 13, 149);
INSERT INTO sqltutor.linky VALUES (26, 2, 14, 131);
INSERT INTO sqltutor.linky VALUES (26, 2, 15, 106);
INSERT INTO sqltutor.linky VALUES (26, 2, 16, 262);
INSERT INTO sqltutor.linky VALUES (26, 2, 17, 241);
INSERT INTO sqltutor.linky VALUES (26, 2, 18, 80);
INSERT INTO sqltutor.linky VALUES (26, 2, 19, 250);
INSERT INTO sqltutor.linky VALUES (26, 2, 20, 117);
INSERT INTO sqltutor.linky VALUES (26, 2, 21, 211);
INSERT INTO sqltutor.linky VALUES (26, 2, 22, 130);
INSERT INTO sqltutor.linky VALUES (26, 2, 23, 123);
INSERT INTO sqltutor.linky VALUES (26, 2, 24, 185);
INSERT INTO sqltutor.linky VALUES (26, 2, 25, 136);
INSERT INTO sqltutor.linky VALUES (26, 2, 26, 259);
INSERT INTO sqltutor.linky VALUES (26, 2, 27, 196);
INSERT INTO sqltutor.linky VALUES (26, 2, 28, 128);
INSERT INTO sqltutor.linky VALUES (26, 2, 29, 52);
INSERT INTO sqltutor.linky VALUES (26, 1, 1, 120);
INSERT INTO sqltutor.linky VALUES (26, 1, 2, 52);
INSERT INTO sqltutor.linky VALUES (26, 1, 3, 128);
INSERT INTO sqltutor.linky VALUES (26, 1, 4, 196);
INSERT INTO sqltutor.linky VALUES (26, 1, 5, 259);
INSERT INTO sqltutor.linky VALUES (26, 1, 6, 136);
INSERT INTO sqltutor.linky VALUES (26, 1, 7, 185);
INSERT INTO sqltutor.linky VALUES (26, 1, 8, 123);
INSERT INTO sqltutor.linky VALUES (26, 1, 9, 130);
INSERT INTO sqltutor.linky VALUES (26, 1, 10, 211);
INSERT INTO sqltutor.linky VALUES (26, 1, 11, 250);
INSERT INTO sqltutor.linky VALUES (26, 1, 12, 80);
INSERT INTO sqltutor.linky VALUES (26, 1, 13, 241);
INSERT INTO sqltutor.linky VALUES (26, 1, 14, 262);
INSERT INTO sqltutor.linky VALUES (26, 1, 15, 106);
INSERT INTO sqltutor.linky VALUES (26, 1, 16, 131);
INSERT INTO sqltutor.linky VALUES (26, 1, 17, 149);
INSERT INTO sqltutor.linky VALUES (26, 1, 18, 151);
INSERT INTO sqltutor.linky VALUES (26, 1, 19, 96);
INSERT INTO sqltutor.linky VALUES (26, 1, 20, 55);
INSERT INTO sqltutor.linky VALUES (26, 1, 21, 46);
INSERT INTO sqltutor.linky VALUES (26, 1, 22, 105);
INSERT INTO sqltutor.linky VALUES (26, 1, 23, 135);
INSERT INTO sqltutor.linky VALUES (26, 1, 24, 37);
INSERT INTO sqltutor.linky VALUES (26, 1, 25, 214);
INSERT INTO sqltutor.linky VALUES (26, 1, 26, 63);
INSERT INTO sqltutor.linky VALUES (26, 1, 27, 91);
INSERT INTO sqltutor.linky VALUES (1, 1, 49, 204);
INSERT INTO sqltutor.linky VALUES (1, 2, 49, 161);
INSERT INTO sqltutor.linky VALUES (2, 1, 49, 25);
INSERT INTO sqltutor.linky VALUES (2, 2, 49, 161);
INSERT INTO sqltutor.linky VALUES (3, 1, 49, 90);
INSERT INTO sqltutor.linky VALUES (3, 2, 49, 194);
INSERT INTO sqltutor.linky VALUES (4, 1, 49, 21);
INSERT INTO sqltutor.linky VALUES (4, 2, 49, 195);
INSERT INTO sqltutor.linky VALUES (5, 1, 49, 257);
INSERT INTO sqltutor.linky VALUES (5, 2, 49, 150);
INSERT INTO sqltutor.linky VALUES (6, 2, 49, 76);
INSERT INTO sqltutor.linky VALUES (7, 1, 49, 231);
INSERT INTO sqltutor.linky VALUES (7, 2, 49, 184);
INSERT INTO sqltutor.linky VALUES (8, 1, 49, 126);
INSERT INTO sqltutor.linky VALUES (9, 1, 49, 204);
INSERT INTO sqltutor.linky VALUES (9, 2, 49, 195);
INSERT INTO sqltutor.linky VALUES (10, 1, 49, 192);
INSERT INTO sqltutor.linky VALUES (10, 2, 49, 195);
INSERT INTO sqltutor.linky VALUES (11, 1, 49, 23);
INSERT INTO sqltutor.linky VALUES (11, 2, 49, 205);
INSERT INTO sqltutor.linky VALUES (12, 1, 49, 158);
INSERT INTO sqltutor.linky VALUES (12, 2, 49, 190);
INSERT INTO sqltutor.linky VALUES (13, 1, 49, 200);
INSERT INTO sqltutor.linky VALUES (13, 2, 49, 190);
INSERT INTO sqltutor.linky VALUES (14, 1, 49, 247);
INSERT INTO sqltutor.linky VALUES (14, 2, 49, 190);
INSERT INTO sqltutor.linky VALUES (16, 1, 49, 204);
INSERT INTO sqltutor.linky VALUES (16, 2, 49, 118);
INSERT INTO sqltutor.linky VALUES (17, 1, 49, 192);
INSERT INTO sqltutor.linky VALUES (17, 2, 49, 194);
INSERT INTO sqltutor.linky VALUES (18, 1, 49, 249);
INSERT INTO sqltutor.linky VALUES (18, 2, 49, 161);
INSERT INTO sqltutor.linky VALUES (19, 1, 49, 123);
INSERT INTO sqltutor.linky VALUES (19, 2, 49, 90);
INSERT INTO sqltutor.linky VALUES (20, 1, 49, 190);
INSERT INTO sqltutor.linky VALUES (20, 2, 49, 165);
INSERT INTO sqltutor.linky VALUES (22, 2, 49, 120);
INSERT INTO sqltutor.linky VALUES (22, 1, 49, 8);
INSERT INTO sqltutor.linky VALUES (24, 1, 49, 84);
INSERT INTO sqltutor.linky VALUES (25, 2, 49, 247);
INSERT INTO sqltutor.linky VALUES (25, 1, 49, 202);
INSERT INTO sqltutor.linky VALUES (26, 2, 49, 120);
INSERT INTO sqltutor.linky VALUES (26, 1, 49, 202);

COMMIT;
