/* base64en.c - base64 encoding routines 
 * Copyright (C) 2005-2006 Jia Wang (skyroam@gmail.com)
 *
 *
 *
 * This file is part of proxyknife.
 * Proxyknife is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by the 
 * Free Software Foundation; either version 2 of the License, or (at your 
 * option) any later version.
 *
 * Proxyknife is distributed in the hope that it will be useful, but WITHOUT ANY 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License 
 * for more details.
 *
 *
 * You should have received a copy of the GNU General Public License 
 * along with Proxyknife; if not, write to the Free Software 
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/* Encode data in src as  RFC 1341 MIME base64.
   
   SRC_SIZE is length of data in src. SRC_SIZE should not be less than 3.
   DST_MAX is size of memory available in dst. 

   Return Value:
   -1: size of dst(DST_MAX) is too  small to store encoded data.
   >=4: success! 
 */

unsigned char en[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz"
  "0123456789+/";
int
base64en (unsigned char *dst, int dst_max, unsigned char *src, int src_size)
{
  int last_size = src_size % 3;
  int dst_size = src_size / 3 * 4 + (last_size ? 4 : 0);
  unsigned char *last = src + src_size - last_size;
  if (dst_size > dst_max)
    return -1;
  for (; src < last; src += 3, dst += 4)
    {
      dst[0] = en[src[0] >> 2];
      dst[1] = en[((src[0] & 3) << 4) + (src[1] >> 4)];
      dst[2] = en[((src[1] & 0xF) << 2) + (src[2] >> 6)];
      dst[3] = en[src[2] & 0x3F];
    }
  if (last_size)
    {
      dst[0] = en[last[0] >> 2];
      if (last_size == 1)
	{
	  dst[1] = en[(last[0] & 3) << 4];
	  dst[2] = '=';
	}
      else
	{
	  dst[1] = en[((last[0] & 3) << 4) + (last[1] >> 4)];
	  dst[2] = en[(last[1] & 0xF) << 2];
	}
      dst[3] = '=';
    }
  return dst_size;
}
