#| -*-Scheme-*-

Copyright (C) 1986, 1987, 1988, 1989, 1990, 1991, 1992, 1993, 1994,
    1995, 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005,
    2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016,
    2017, 2018, 2019 Massachusetts Institute of Technology

This file is part of MIT/GNU Scheme.

MIT/GNU Scheme is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or (at
your option) any later version.

MIT/GNU Scheme is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with MIT/GNU Scheme; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301,
USA.

|#

;;;; UCD property: WB (word-break)

;;; Generated from Unicode 9.0.0

(declare (usual-integrations))

(define (ucd-wb-value char)
  (let ((sv (char->integer char)))
    (vector-ref |ucd-WB-table-5| (bytevector-u8-ref |ucd-WB-table-4| (fix:or (fix:lsh (bytevector-u16be-ref |ucd-WB-table-3| (fix:lsh (fix:or (fix:lsh (bytevector-u8-ref |ucd-WB-table-2| (fix:or (fix:lsh (bytevector-u8-ref |ucd-WB-table-1| (fix:or (fix:lsh (bytevector-u8-ref |ucd-WB-table-0| (fix:lsh sv -16)) 4) (fix:and 15 (fix:lsh sv -12)))) 4) (fix:and 15 (fix:lsh sv -8)))) 4) (fix:and 15 (fix:lsh sv -4))) 1)) 4) (fix:and 15 sv))))))

(define-deferred |ucd-WB-table-0|
  (vector->bytevector '#(0 1 2 2 2 2 2 2 2 2 2 2 2 2 3 2 2)))

(define-deferred |ucd-WB-table-1|
  (vector->bytevector '#(0 1 2 3 4 4 4 4 4 4 5 6 6 7 4 8 9 10 11 12 13 4 14 4 4 4 4 15 4 16 17 18 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 19 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4)))

(define-deferred |ucd-WB-table-2|
  (vector->bytevector '#(0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 1 17 18 19 1 20 21 22 23 24 25 26 27 1 28 29 30 31 31 32 31 33 34 31 31 31 31 35 36 37 31 38 39 40 41 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 1 1 1 1 42 1 43 44 45 46 47 48 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 49 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 50 1 51 52 53 54 55 56 57 58 59 1 60 61 62 63 64 65 31 31 31 66 67 68 69 70 71 72 73 74 31 75 31 76 31 31 31 1 1 1 77 78 79 31 31 31 31 31 31 31 31 31 31 1 1 1 1 80 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 1 1 81 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 1 1 82 83 31 31 31 84 85 31 31 31 31 31 31 31 31 31 31 31 86 31 31 31 31 87 88 31 89 90 91 92 31 31 93 31 31 31 31 31 94 31 31 31 31 31 31 31 95 96 31 31 31 31 97 31 31 98 31 99 100 101 102 31 31 103 31 31 31 31 31 31 104 105 31 31 31 31 31 31 31 31 31 31 31 31 31 31)))

(define-deferred |ucd-WB-table-3|
  (vector->bytevector-u16be
   '#(0   1  2   3   4   5   4   6   7   1   8   9   10 11  10 11 10  10  10  10  10 10  10  10 10  10  10  10  10  10  10  10  10  10  10  10  10  10  10  10  10  10 10  10  12  13 14  1   15  15 15  15  15  15  15  16  17  10  18  10  10  10 10  19  10  10  10  10 10  10  10  10  20  10  10  10  10  10  10  10  10  10  10  4   10  21  4   10  22  23  15  24  25  26  27  28  29  30  10  10  31  15  32  33  10  10  10  10  10  34  35  36  37  38  10  15  39  10 10 10  10  10  40  41  42  10  31  43  10  44  45  1 10 46 1   1  1   1   10  47 1   48 49 15  50  10  10  51  15  52  53  4   54  55  56  57  58  59 53  60  61  55  56 62  63  64  65  66 67  18  56  68 69  70  53  71  72  55  56  68  73  74  53 75 76  77  78 79  80 81 65 1   82  83  56  84  85  86  53  1   87  83  56  88  85  89  53  90  91  83  10  92  93  94  53  95  96  97  10  98  99  100 65  101 1   1   1   102 103 104 1   1   1  1   1   105 106 104 1   1   70  107 104 108 109 10  110 23  111 112 15  113 114 1   1
      1   1  1   115 116 104 117 118 119 120 121 10  10 122 10 10 123 10  10  10  10 124 125 10 10  124 10  10  126 127 11  10  10  10  127 10  10  10  128 1   1   10 1   10  10  10 10  10  129 4  10  10  10  10  10  10  10  10  10  10  10  10 10  10  10  10  10  10 10  10  10  130 10  4   6   10  10  10  10  131 132 133 134 10  134 10  135 133 136 1   1   1   48  15  137 104 1   138 104 10  10  10  10  10  139 140 10  141 10  10  10  10  142 10  143 144 144 65 1  1   1   1   1   1   1   1   104 1   1   10  145 1 1  1  146 15 147 104 104 1  116 1  1  1   1   148 10  10  149 150 104 115 151 152 10  153 42  10 10  40  151 10  10 149 154 155 42  10 156 132 1   1  1   1   157 158 159 10  10  10  10  10  10 10 10  10  10 10  10 15 15 15  160 10  129 10  10  129 161 10  156 10  10  10  162 163 164 110 163 165 166 167 168 169 170 171 172 1   110 1   1   1   15  15  173 174 175 176 177 178 1   10  10 132 1   1   1   1   1   1   1   1   1   1   1   1   1   1   1   1   1   1   1   1   1
      1   1  1   1   1   1   1   1   1   1   1   1   1  179 10 10 180 1   1   181 1  1   1   1  1   1   1   1   1   1   1   1   1   182 183 1   1   1   1   1   184 1  1   1   1   1  1   1   1   1  10  10  143 10  10  143 10  10  10  10  10  10 10  10  185 186 10  10 122 10  10  10  187 188 10  189 190 190 190 190 15  15  1   1   191 1   1   1   1   1   1   1   1   1   1   1   1   1   192 1   193 194 1   1   1   1   1   195 196 196 196 196 196 197 198 10  156 4  10 10  10  10  143 1   10  6   1   1   1   196 1   1 1  1  1   1  1   1   1   1  1   1  1  196 196 199 196 196 196 196 196 200 1   1   1   1   1   1  1   1   1   1   10 10  10  10  10  10 10  10  110 1  1   1   1   10  10  156 110 10  201 1   10 10 202 203 10 204 10 10 10 10  10  205 1   206 207 10  10  10  10  10  208 10  143 139 1   1   1   206 209 10  210 1   10  10  10  211 212 10  10  149 213 104 15  214 42  10  215 10  216 151 10 110 50  10  10  217 218 104 219 104 10  10  220 221 222 104 1   223 1   1   1   224 225
      1   31 226 227 228 190 10  10  123 142 10  10  10 10  10 10 10  229 104 10  10 10  10  10 10  10  10  10  10  211 10  230 10  10  231 189 232 233 234 235 10  10 10  10  10  10 60  1   236 10 10  10  10  10  156 1   10  10  10  10  207 10 10  139 1   1   231 15 237 15  238 239 240 1   241 10  10  10  10  10  10  10  242 243 244 4   5   4   6   245 196 196 246 10  143 247 248 1   249 250 10  11  251 156 156 1   1   10  10  10  10  10  10  10  6   1   1   1  1  10  10  10  252 1   1   1   1   1   1   1   253 1 1  1  1   1  1   1   1   10 110 10 10 10  70  173 1   10  10  1   10  6   10  10  254 10  156 10 10  255 256 1   1  10  10  10  10  10 10  10  10  10 156 104 10  10  255 10  231 10  10  139 10 10 10  211 1  1   1  1  1  1   1   1   1   10  10  10  189 10  142 139 1   1   1   1   1   1   1   1   1   257 10  10  258 10  142 10  189 10  143 1   1   1   1   10  259 10  142 10  180 1   1  1   1   10  10  10  260 1   1   1   1   261 262 10  263 1   1   10  110 10  110 1   1
      109 10 264 1   10  10  10  142 10  142 10  265 10 60  1  1  1   1   1   1   10 10  10  10 132 1   1   1   10  10  10  265 10  10  10  265 152 10  10  266 221 1  65  188 152 10 10  267 1   10 132 104 152 10  216 268 1   10  10  269 152 10 10  217 270 271 1   1  10  18  272 273 1   1   1   1   274 275 132 10  10  202 276 104 277 55  56  68  73  278 279 280 1   1   1   1   1   1   1   1   10  10  10  281 282 104 1   1   10  10  10  15  283 104 1   1   1   1  1  1   1   1   1   1   10  10  202 284 173 285 1   1 10 10 10  15 286 104 1   1  10  10 31 154 104 1   1   1   1   287 144 104 1   1   1   1   1   1  1   1   1   1   1  1   1   1   1   1  1   1   1   1  1   1   10  10  10  10  104 191 1   1   1  1  1   1   1  1   1  1  1  1   10  10  10  132 56  10  202 288 70  104 1   207 10  289 112 221 1   1   1   1   10  10  10  10  10  10  10  10  10  180 1   1   1   1   1   1   10  10  10  10  10 10  143 1   10  10  10  10  10  10  10  10  10  10  10  10  211 1   1   1   1   1   1
      1   1  1   1   1   10  10  143 1   1   1   1   1  1   1  1  1   1   1   1   1  10  10  10 10  189 1   1   1   1   1   1   1   1   1   1   1   10  10  10  132 10 143 104 1   1  1   1   1   1  10  156 280 10  10  10  221 211 104 236 290 10 1   1   1   1   1   1  1   10  10  10  10  252 291 15  116 188 152 1   1   1   1   70  1   292 1   1   1   1   1   1   1   1   1   1   1   1   1   1   1   10  10  10  10  10  10  6   110 132 293 294 1   1   1   1   1   1  1  1   1   1   1   295 296 297 1   298 1   1   1   1 1  1  1   1  1   299 1   1  1   1  1  1   1   1   1   1   1   10  10  10  10  10  241 10  10  10 133 300 301 302 10 10  10  303 304 10 305 306 83  10 10  10  10  10  10  10  10  10  10  10  10 10 10  10  10 10  10 10 10 307 10  83  123 10  123 10  241 10  241 143 10  143 10  56  10  56  10  308 309 309 309 15  15  15  310 15  15  113 219 311 115 23  1   1   1   1   1   288 312 313 1  1   1   1   1   1   1   1   1   1   1   1   1   10  10  10  10  10  10  10  10  10  10
      10  10 252 221 1   1   10  10  10  10  314 104 1  1   1  1  1   1   1   1   1  1   302 10 315 316 317 318 319 320 321 231 322 231 1   1   1   1   1   1   1   10 180 10  180 10 180 1   1   1  1   1   323 324 1   1   1   1   1   1   1   1  325 1   1   1   326 1  1   327 1   1   1   1   328 329 330 331 332 1   333 1   1   1   1   1   1   1   1   1   1   1   1   334 1   335 1   1   1   1   336 1   1   1   1   1   337 1   1   1   1   1   338 339 329 1   1   1  1  340 341 342 1   1   1   1   1   1   1   1   1   1 1  1  343 1  15  15  15  15 15  15 1  1   1   1   1   1   1   1   15  15  15  15  15  15  15  15 15  15  15  15  15 15  15  1)))

(define-deferred |ucd-WB-table-4|
  (vector->bytevector
   '#(0  0  0  0  0  0  0  0  0  0  1  2  2  3  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  4  0  0  0  0  5  0  0  0  0  6  0  7  0  8  8  8  8  8  8  8  8  8  8  9  6  0  0  0  0  0  10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 0  0  0  0  11 10 10 10 10 10 10 10 10 10 10 10 0  0  0  0  0  0  0  0  0  0  2  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  10 0  0  12 0  0  0  0  0  0  0  10 0  9  0  0  10 0  0  0  0  0  10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 0  10 10 10 10 10 10 10 10 10 10 0  0  0  0  10 10 10 10 10 10 10 10 10 10 10 10 0  0  0  0  0  9  0  0  0  0  0  0  0  0  10 10 10 10 10 0  0  0  0  0  0  0  10 0  10 0  13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 10 10 10 10 10 0  10 10 0  0  10 10 10 10 6  10 0  0  0  0  0  0  10 9  10 10 10 0  10 0  10 10 10 10 0  10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 0  10 10 10 10 10 10 10 10 10 10 10 0  13 13 13 13 13 13 13
      10 10 10 10 10 10 10 10 10 10 10 10 10 0  0  10 0  0  0  0  0  0  10 10 10 10 10 10 10 10 0  6  0  0  0  0  0  0  0  13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 0  13 0  13 13 0  13 13 0  13 0  0  0  0  0  0  0  0  14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 14 0  0  0  0  0  14 14 14 10 9  0  0  0  0  0  0  0  0  0  0  0  12 12 12 12 12 12 0  0  0  0  0  0  6  6  0  0  13 13 13 13 13 13 13 13 13 13 13 0  12 0  0  0  10 10 10 10 10 10 10 10 10 10 10 13 13 13 13 13 8  8  8  8  8  8  8  8  8  8  0  8  6  0  10 10 13 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 0  10 13 13 13 13 13 13 13 12 0  13 13 13 13 13 13 10 10 13 13 0  13 13 13 13 10 10 8  8  8  8  8  8  8  8  8  8  10 10 10 0  0  10 0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  12 10 13 10 10 10 10 10 10 10 10 10 10 10 10 10 10 13 13 13 13 13 13 13 13 13 13 13 0  0  10 10 10 10 10 10 10 10 10 13 13 13 13 13 13 13 13 13 13 13 10 0  0
      0  0  0  0  0  0  0  0  0  0  0  0  8  8  8  8  8  8  8  8  8  8  10 10 10 10 10 10 13 13 13 13 10 10 0  0  6  0  10 0  0  0  0  0  10 10 10 10 10 10 13 13 13 13 10 13 13 13 13 13 13 13 13 13 10 13 13 13 10 13 13 13 13 13 0  0  10 10 10 10 10 10 10 10 10 13 13 13 0  0  0  0  10 10 10 10 10 0  10 10 10 10 10 10 10 10 0  0  0  0  0  0  13 13 13 13 13 13 13 13 13 13 13 13 13 13 12 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 13 13 13 10 13 13 10 13 13 13 13 13 13 13 10 10 10 10 10 10 10 10 10 10 13 13 0  0  8  8  8  8  8  8  8  8  8  8  10 13 13 13 0  10 10 10 10 10 10 10 10 0  0  10 10 0  0  10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 0  10 10 10 10 10 10 10 0  10 0  0  0  10 10 10 10 0  0  13 10 13 13 13 13 13 13 13 0  0  13 13 0  0  13 13 13 10 0  0  0  0  0  0  0  0  13 0  0  0  0  10 10 0  10 10 10 0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  13 13 13 0  10 10 10 10 10 10 0  0  0
      0  10 10 0  10 10 0  10 10 0  10 10 0  0  13 0  13 13 13 13 13 0  0  0  0  13 13 0  0  13 13 13 0  0  0  13 0  0  0  0  0  0  0  10 10 10 10 0  10 0  0  0  0  0  0  0  8  8  8  8  8  8  8  8  8  8  13 13 10 10 10 13 0  0  0  0  0  0  0  0  0  0  0  13 13 13 0  10 10 10 10 10 10 10 10 10 0  10 10 0  10 10 0  10 10 10 10 10 0  0  13 10 13 13 13 13 13 13 13 13 0  13 13 13 0  13 13 13 0  0  10 0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  10 0  0  0  0  0  0  0  13 13 13 0  10 10 10 10 10 10 10 10 0  0  10 13 13 13 13 13 0  0  13 13 0  0  13 13 13 0  0  0  0  0  0  0  0  13 13 0  0  0  0  10 10 0  10 0  10 0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  13 10 0  10 10 10 10 10 10 0  0  0  10 10 10 0  10 10 10 10 0  0  0  10 10 0  10 0  10 10 0  0  0  10 10 0  0  0  10 10 10 0  0  0  10 10 10 10 10 10 10 10 10 10 10 10 0  0  0  0  13 13 13 13 13 0  0  0  13 13 13 0  13 13 13 13 0  0  10 0  0  0  0  0  0  13 0  0  0  0  0  0  0  0  13 13 13 13 0  10 10 10
      10 10 10 10 10 0  10 10 10 0  10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 0  0  0  10 13 13 13 13 13 13 13 0  13 13 13 0  13 13 13 13 0  0  0  0  0  0  0  13 13 0  10 10 10 0  0  0  0  0  10 13 13 13 0  10 10 10 10 10 10 10 10 0  10 10 10 10 10 10 0  10 10 10 10 10 0  0  13 10 13 13 0  0  0  0  0  13 13 0  0  0  0  0  0  0  10 0  0  10 10 0  0  0  0  0  0  0  0  0  0  0  0  0  0  13 13 13 0  10 10 10 10 10 10 10 10 0  10 10 10 10 10 10 10 10 10 10 10 10 10 0  0  10 13 13 13 13 13 13 13 0  13 13 13 0  13 13 13 13 10 0  0  0  0  0  10 10 10 13 0  0  0  0  0  0  0  10 0  0  0  0  0  0  0  0  0  0  10 10 10 10 10 10 0  0  13 13 0  10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 0  0  0  10 10 10 10 10 10 10 10 0  10 10 10 10 10 10 10 10 10 0  10 0  0  10 10 10 10 10 10 10 0  0  0  13 0  0  0  0  13 13 13 13 13 13 0  13 0  13 13 13 13 13 13 13 13 0  0  13 13 0  0  0  0  0  0  0  0  0  0  0  0  0  13 0  0  13 13 13 13 13 13 13 0  0  0  0  0  0  0
      0  0  0  0  0  13 13 13 13 13 13 13 13 0  8  8  8  8  8  8  8  8  8  8  0  0  0  0  0  0  0  13 0  0  13 13 13 13 13 13 0  13 13 0  0  0  0  0  0  0  0  0  0  0  13 13 13 13 13 13 0  0  0  0  0  0  0  0  0  0  13 13 0  0  0  0  0  0  0  0  0  0  0  13 0  13 0  13 0  0  0  0  13 13 10 10 10 10 10 10 10 10 0  10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 0  0  0  13 13 13 13 13 0  13 13 10 10 10 10 10 13 13 13 13 13 13 13 13 13 13 13 0  13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 0  0  0  0  0  0  0  0  0  13 0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 0  0  0  0  0  0  0  13 13 13 13 0  0  0  0  13 13 13 0  13 13 13 0  0  13 13 13 13 13 13 13 0  0  0  13 13 13 13 0  0  0  0  0  0  0  0  0  0  0  0  0  13 13 13 13 13 13 13 13 13 13 13 13 0  13 8  8  8  8  8  8  8  8  8  8  13 13 13 13 0  0  10 10 10 10 10 10 0  10 0  0  0  0  0  10 0  0  10 10 10 10 10 10 10 10 10 10 10 0
      10 10 10 10 10 10 10 10 10 10 10 10 10 0  10 10 10 10 0  0  10 10 10 10 10 10 10 0  10 0  10 10 10 10 0  0  10 0  10 10 10 10 0  0  10 10 10 10 10 10 10 0  10 0  10 10 10 10 0  0  10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 0  0  13 13 13 10 10 10 10 10 10 0  0  10 10 10 10 10 10 0  0  10 10 10 10 10 10 10 10 10 10 10 10 10 0  0  10 10 10 10 10 10 10 10 10 10 10 10 0  0  0  10 10 10 10 10 10 10 10 10 10 10 0  0  0  0  0  0  0  10 10 10 10 10 10 10 10 10 10 10 10 10 0  10 10 10 10 13 13 13 0  0  0  0  0  0  0  0  0  0  0  10 10 13 13 0  0  0  0  0  0  0  0  0  0  0  0  10 0  13 13 0  0  0  0  0  0  0  0  0  0  0  0  13 13 13 13 0  0  0  0  0  0  0  0  0  13 0  0  0  0  0  0  0  0  0  0  0  0  0  13 13 13 12 0  10 10 10 10 10 10 10 10 0  0  0  0  0  0  0  0  10 10 10 10 10 13 13 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 13 10 0  0  0  0  0  10 10 10 10 10 10 0  0  0  0  0  0  0  0  0  0  10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 0  13 13 13 13 13 13
      13 13 13 13 13 13 0  0  0  0  10 10 10 10 10 10 10 13 13 13 13 13 0  0  0  0  0  0  0  0  0  13 13 13 13 13 13 13 13 13 13 0  13 13 13 13 13 13 13 13 13 13 13 13 13 0  0  13 13 13 13 13 13 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 10 10 10 10 10 10 10 0  0  0  0  13 13 13 13 0  0  0  0  0  0  0  0  0  0  0  0  13 13 13 10 10 10 10 10 10 10 10 10 10 10 10 10 10 13 13 13 13 13 13 13 13 13 13 13 13 13 10 10 13 13 13 13 13 13 13 13 0  0  0  0  0  0  0  0  8  8  8  8  8  8  8  8  8  8  0  0  0  10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 0  0  13 13 13 0  13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 10 10 10 10 13 10 10 10 10 13 13 13 10 10 0  13 13 0  0  0  0  0  0  13 13 13 13 13 13 0  0  0  0  0  13 13 13 13 13 10 10 10 10 10 10 10 10 0  10 0  10 0  10 0  10 10 10 10 10 10 0  10 10 10 10 10 10 10 0  10 0  0  0  10 10 10 0  10 10 10 10 10 10 10 0  0  0  10 10 10 10 0  0  10 10 10 10 10 10 0  0  0  0
      0  0  0  0  0  0  0  0  0  0  0  0  13 15 12 12 0  0  0  0  0  0  0  0  7  7  0  0  0  0  0  0  0  0  0  0  7  0  0  9  2  2  12 12 12 12 12 11 0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  11 11 0  0  0  6  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  11 0  0  0  0  0  0  0  0  0  0  0  12 12 12 12 12 0  12 12 12 12 12 12 12 12 12 12 0  10 0  0  0  0  0  0  0  0  0  0  0  0  0  10 13 0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  10 0  0  0  0  10 0  0  10 10 10 10 10 10 10 10 10 10 0  10 0  0  0  10 10 10 10 10 0  0  0  0  0  0  10 0  10 0  10 0  10 10 10 10 0  10 10 10 10 10 10 10 10 10 10 10 0  0  10 10 10 10 0  0  0  0  0  10 10 10 10 10 0  0  0  0  10 0  0  0  0  0  0  0  10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  16 0  0  0  0  0  0  0  0  0  0  0  16 0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  16 16 16 16 0  0  0  0  0  0  17 0  0  0  0  0  0  0  0  0  0  0  10 10 10 10 10 0  0  0  0  0
      0  10 10 10 10 13 13 13 10 10 0  0  0  0  0  0  0  0  0  0  0  0  10 10 10 10 10 10 10 10 0  0  0  0  0  0  0  10 0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  13 10 10 10 10 10 10 10 0  0  0  0  0  0  0  0  0  10 10 10 10 10 10 10 0  10 10 10 10 10 10 10 0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  10 0  0  0  0  0  10 0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  13 13 13 13 13 13 0  18 18 18 18 18 0  0  0  0  0  10 10 0  0  0  0  0  0  0  0  0  0  0  0  13 13 18 18 0  0  0  18 18 18 18 18 18 18 18 18 18 18 18 18 18 18 18 18 18 18 18 18 18 18 18 18 18 18 0  18 18 18 18 0  0  0  0  0  10 10 10 10 10 10 10 10 10 10 10 18 18 18 18 18 18 18 18 18 18 18 18 18 18 18 0  18 18 18 18 18 18 18 18 0  0  0  0  0  0  0  0  8  8  8  8  8  8  8  8  8  8  10 10 0  0  0  0  10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 13 13 13 13 0  13 13 13 13 13 13 13 13 13 13 0  10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 13 13 13 13 0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
      0  0  0  10 10 10 10 10 10 10 10 10 0  0  10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 0  0  10 10 10 10 10 10 10 13 10 10 10 13 10 10 10 10 13 10 10 10 10 10 10 10 13 13 13 13 13 0  0  0  0  0  0  0  0  10 10 10 10 0  0  0  0  0  0  0  0  0  0  0  0  13 13 10 10 10 10 10 10 10 10 10 10 10 10 10 10 13 13 13 13 13 13 0  0  0  0  0  0  0  0  0  0  13 13 10 10 10 10 10 10 0  0  0  10 0  10 0  0  10 10 10 10 10 10 13 13 13 13 13 13 13 13 0  0  10 10 10 10 10 10 10 13 13 13 13 13 13 13 13 13 10 10 10 13 13 13 13 13 13 13 13 13 13 13 13 13 13 0  0  0  0  0  0  0  0  0  0  0  0  0  0  10 0  0  0  0  0  13 0  0  0  0  0  0  0  0  0  0  10 10 10 10 10 10 10 10 10 13 13 13 13 13 13 13 13 13 13 13 13 13 13 0  0  0  0  0  0  0  0  0  10 10 10 13 10 10 10 10 10 10 10 10 13 13 0  0  0  0  0  0  0  0  0  0  0  0  0  13 13 13 0  0  13 0  13 13 13 0  0  13 13 0  0  0  0  0  13 13 0  13 0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  10 10 10 13 13 0  0  0  0  0  0  0
      0  0  0  10 10 10 10 10 10 0  0  10 10 10 10 10 10 0  0  10 10 10 10 10 10 0  0  0  0  0  0  0  0  0  10 10 10 13 13 13 13 13 13 13 13 0  13 13 0  0  10 10 10 10 10 10 10 0  0  0  0  10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 0  0  0  0  0  0  0  10 10 10 10 10 0  0  0  0  0  14 13 14 14 14 14 14 14 14 14 14 14 0  14 14 14 14 14 14 14 14 14 14 14 14 14 0  14 14 14 14 14 0  14 0  14 14 0  14 14 0  14 14 14 14 14 14 14 14 14 14 0  0  0  10 10 10 10 10 10 10 10 10 10 10 10 10 6  0  0  9  6  0  0  0  0  0  0  0  0  0  0  0  0  0  0  11 11 0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  11 11 11 6  0  7  0  6  9  0  0  0  0  0  0  0  0  0  0  10 10 10 10 10 0  10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 0  0  12 0  0  0  0  0  0  0  7  0  0  0  0  6  0  7  0  0  0  0  0  0  0  0  0  0  0  9  6  0  0  0  0  0  0  0  0  0  0  18 18 18 18 18 18 18 18 18 18 18 18 18 18 18 18 18 18 18 18 18 18 18 18 13 13 0  0  10 10 10 10 10 10
      0  0  10 10 10 10 10 10 0  0  10 10 10 10 10 10 0  0  10 10 10 0  0  0  0  0  0  0  0  0  0  0  0  12 12 12 0  0  0  0  10 10 10 10 10 10 10 10 10 10 10 10 0  10 10 10 10 10 10 10 10 10 10 10 10 10 10 0  10 10 0  10 10 10 10 10 10 0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  13 0  0  10 10 10 10 10 10 13 13 13 13 13 0  0  0  0  0  10 10 10 10 0  0  0  0  10 10 10 10 10 10 10 10 0  10 10 10 10 10 0  0  0  0  0  0  0  0  0  0  10 10 10 10 10 10 0  0  10 0  10 10 10 10 10 10 10 10 10 10 10 10 0  10 10 0  0  0  10 0  0  10 10 10 10 0  10 10 0  0  0  0  0  0  0  0  0  0  10 10 10 10 10 10 10 10 0  0  0  0  0  0  10 10 10 13 13 13 0  13 13 0  0  0  0  0  13 13 13 13 10 10 10 10 0  10 10 10 0  10 10 10 10 10 10 10 10 10 10 10 0  0  0  0  13 13 13 0  0  0  0  13 10 10 10 10 10 13 13 0  0  0  0  0  0  0  0  0  10 10 10 0  0  0  0  0  0  0  0  0  0  0  0  0  10 10 10 10 10 10 10 10 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 0  0  12 0  0  13 13
      13 13 13 0  8  8  8  8  8  8  8  8  8  8  10 10 10 13 0  0  10 0  0  0  0  0  0  0  0  0  13 10 10 10 10 0  0  0  0  0  13 13 13 0  0  0  8  8  8  8  8  8  8  8  8  8  10 0  10 0  0  0  10 10 10 10 10 10 10 10 10 10 10 10 13 13 13 13 13 13 13 13 13 13 13 13 0  0  0  0  0  0  13 0  10 10 10 10 10 10 10 0  10 0  10 10 10 10 0  10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 0  10 13 13 13 13 13 13 13 13 13 13 13 0  0  0  0  0  13 13 13 13 0  10 10 10 10 10 10 10 10 0  0  10 10 0  0  0  0  0  0  13 0  0  0  0  0  10 10 10 10 10 13 13 0  0  13 13 13 13 13 13 13 0  0  0  13 13 13 13 13 0  0  0  0  0  0  0  0  0  0  0  10 10 10 10 10 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 10 10 10 10 0  0  0  0  0  13 13 13 13 10 10 0  10 0  0  0  0  0  0  0  0  13 13 13 13 13 13 0  0  13 13 13 13 13 13 13 13 0  0  0  0  0  0  0  0  10 10 10 10 13 13 0  0  13 0  0  0  10 0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  13 13 13 13 13 13 13 13 13 13 0  13 13 13 13
      13 13 13 13 0  0  13 13 13 13 13 13 13 13 13 13 13 13 13 13 10 10 10 10 10 10 10 10 0  0  0  0  0  10 10 10 10 13 13 13 13 13 13 13 13 13 13 13 13 13 13 13 18 0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  10 10 10 10 10 10 10 10 10 10 0  0  0  13 13 0  12 12 12 12 0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  13 13 13 13 13 0  0  0  13 13 13 13 13 13 12 12 12 12 12 12 12 12 13 13 13 13 13 13 13 13 0  0  13 13 13 13 13 13 13 0  0  0  0  0  0  0  0  0  0  0  0  0  0  13 13 13 13 0  0  0  0  13 13 13 0  0  0  0  0  0  0  0  0  0  0  0  0  10 0  0  10 10 0  0  10 10 10 10 0  10 10 10 10 10 10 10 10 10 10 10 10 0  10 0  10 10 10 10 10 10 10 0  10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 10 0  10 10 10 10 0  0  10 10 10 10 10 10 10 10 0  10 10 10 10 10 10 10 0  10 10 10 10 10 10 10 10 10 10 10 10 0  10 10 10 10 0  10 10 10 10 10 0  10 0  0  0  10 10 10 10 10 10 10 10 10 10 10 10 0  0  10 10 10 10 10 10 10 10 10 10 10 0  10 10 10 10 10 10 10 10 0  0  8  8  8  8  8  8  8  8
      8  8  8  8  8  8  8  8  8  8  13 13 13 13 13 13 13 0  0  0  0  13 13 13 13 13 0  0  0  0  13 0  0  0  0  0  0  0  0  0  0  0  13 13 13 13 13 13 13 13 13 0  0  13 13 13 13 13 13 13 0  13 13 0  13 13 13 13 13 0  0  0  0  0  10 10 10 10 13 13 13 13 13 13 13 0  0  0  0  0  0  10 10 0  10 0  0  10 0  10 10 10 10 10 10 10 10 10 10 0  10 10 10 10 0  10 0  10 0  0  0  0  0  0  10 0  0  0  0  10 0  10 0  10 0  10 10 10 0  10 10 0  10 0  0  10 0  10 0  10 0  10 0  10 0  10 10 0  10 0  0  10 10 10 10 0  10 10 10 10 10 10 10 0  10 10 10 10 0  10 10 10 10 0  10 0  10 10 10 10 10 10 10 10 10 10 0  10 10 10 10 10 0  10 10 10 0  10 10 10 10 10 0  10 10 10 10 10 0  0  0  0  0  0  19 19 19 19 19 19 19 19 19 19 19 19 19 19 19 19 19 19 19 19 19 19 19 19 19 19 0  0  0  0  0  16 0  0  0  0  0  0  0  0  0  0  0  0  0  16 16 0  0  0  0  0  16 16 0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  20 20 20 20 20 0  0  16 16 0  0  16 16 16 16 16 16 16 16 16 16 16 0  0  0  0  0  0  0  0  0  0  0  0  0  0  0
      0  0  0  0  0  0  21 21 21 21 0  0  0  0  16 0  16 16 16 16 16 16 16 16 16 0  0  0  16 0  0  0  0  16 16 16 0  16 16 16 0  0  0  17 0  0  0  0  0  0  0  0  0  0  0  0  0  0  16 0  0  0  0  0  0  0  0  0  0  16 0  0  0  0  16 0  0  0  0  0  16 0  0  0  0  16 16 0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  17 0  0  0  0  0  0  0  0  0  0  0  0  16 16 16 0  0  0  16 16 16 16 16 0  0  0  16 0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  16 16 16 0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  16 16 16 16 16 16 16 0  0  0  0  0  0  0  16 0  0  0  0  0  0  0  0  0  16 0  0  16 16 16 16 16 16 16 0  0  16 16 16 0  0  12 0  0  0  0  0  0  0  0  0  0  0  0  0  0)))

(define-deferred |ucd-WB-table-5|
  #(20 12 16 0 1 19 15 13 17 14 11 5 7 6 9 21 2 8 10 18 4 3))
