/*
 * Decompiled with CFR 0.152.
 */
package kawa;

import com.sun.net.httpserver.HttpServer;
import gnu.expr.Language;
import gnu.kawa.io.BinaryInPort;
import gnu.kawa.io.BinaryOutPort;
import gnu.kawa.io.CheckConsole;
import gnu.kawa.io.InPort;
import gnu.kawa.io.OutPort;
import gnu.kawa.io.Path;
import gnu.kawa.io.QueueReader;
import gnu.kawa.io.TtyInPort;
import gnu.kawa.servlet.KawaHttpHandler;
import gnu.mapping.Environment;
import gnu.mapping.ThreadLocation;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.UnknownHostException;
import kawa.Shell;
import org.domterm.Backend;
import org.domterm.util.DomTermErrorWriter;
import org.domterm.util.StyleSheets;
import org.domterm.util.Utf8WriterOutputStream;
import org.domterm.websocket.DomServer;

public class DomTermBackend
extends Backend
implements Runnable {
    Language language;
    QueueReader inIn;
    Appendable inOut;
    OutputStream inOutS;
    boolean usingJLine;
    TtyInPort in_p;
    PipedInputStream inPipe;
    Method setSizeMethod;
    public static final ThreadLocation<DomTermBackend> instance = new ThreadLocation("domterm-backend");
    public volatile int nrows = -1;
    public volatile int ncols = -1;
    public volatile int pixw;
    public volatile int pixh;

    public static String startDomTermConsole(String command) throws Throwable {
        int htport = 0;
        if (command.startsWith("serve=")) {
            String portArg = command.substring(6);
            try {
                htport = Integer.parseInt(portArg);
            }
            catch (NumberFormatException ex) {
                return "bad port specifier in -w" + command + " option";
            }
        }
        boolean exitOnClose = !command.startsWith("serve");
        int wsport = WebSocketServer.getInstancePort();
        DomServer.setExitOnClose((boolean)exitOnClose);
        String defaultUrl = "/repl-client.html#ws=//localhost:" + wsport + "/";
        String kawaHome = System.getProperty("kawa.home");
        if (kawaHome == null) {
            return "kawa.home not set";
        }
        File domtermJar = new File(kawaHome + "/lib/domterm.jar");
        if (!domtermJar.exists()) {
            return domtermJar.toString() + " does not exist";
        }
        String pathPrefix = "jar:file:" + domtermJar + "!";
        KawaHttpHandler.addStaticFileHandler("/", pathPrefix, defaultUrl, exitOnClose);
        HttpServer httpHandler = KawaHttpHandler.startServer(htport, System.err);
        htport = httpHandler.getAddress().getPort();
        String webUrl = "http://127.0.0.1:" + htport + "/";
        if (command.equals("browser")) {
            if (!Desktop.isDesktopSupported()) {
                return "using default desktop browser not supported";
            }
            Desktop.getDesktop().browse(new URI(webUrl));
            return null;
        }
        if (command.startsWith("browser=")) {
            String cmd = command.substring(8);
            if (cmd.indexOf(37) < 0) {
                cmd = cmd + " %U";
            }
            cmd = cmd.replace("%U", webUrl).replace("%W", Integer.toString(wsport));
            Runtime.getRuntime().exec(cmd);
            return null;
        }
        if (command.startsWith("serve")) {
            return null;
        }
        return "unrecognized -w subcommand '" + command + "'";
    }

    public DomTermBackend(Language language, Environment penvironment, boolean shared) {
        this.language = language;
    }

    public DomTermBackend() {
        this(Language.getDefaultLanguage(), Environment.getCurrent(), false);
    }

    public void reportEvent(String name, String str) {
        if (name.equals("KEY") && str.equals("-3 \"\\u0003\"") && this.in_p.sigIntHandler != null) {
            this.in_p.sigIntHandler.run();
        } else if (name.equals("KEY") && str.equals("-4 \"\\u0004\"") && this.inIn != null) {
            this.inIn.appendEOF();
        } else {
            super.reportEvent(name, str);
        }
    }

    @Override
    public void run() {
        Path inPath;
        OutPort outp;
        DomTermErrorWriter errWriter;
        block9: {
            errWriter = new DomTermErrorWriter(this.termWriter);
            outp = new OutPort(this.termWriter, true, true, Path.valueOf("/dev/stdout"));
            inPath = Path.valueOf("/dev/stdin");
            int useJLine = CheckConsole.useJLine();
            instance.set(this);
            if (useJLine >= 0) {
                try {
                    this.inPipe = new PipedInputStream();
                    this.inOutS = new PipedOutputStream(this.inPipe);
                    Class<?> JLineClass = Class.forName("gnu.kawa.io.JLineInPort");
                    this.in_p = (TtyInPort)JLineClass.getConstructor(InputStream.class, Path.class, OutputStream.class, OutPort.class).newInstance(this.inPipe, inPath, new Utf8WriterOutputStream((Writer)outp), outp);
                    this.setSizeMethod = JLineClass.getMethod("setSize", Integer.TYPE, Integer.TYPE);
                    this.usingJLine = true;
                }
                catch (Throwable ex) {
                    this.inOutS = null;
                    if (useJLine <= 0) break block9;
                    ex.printStackTrace();
                }
            }
        }
        if (this.in_p == null) {
            QueueReader inQ;
            this.inIn = inQ = new QueueReader(){

                @Override
                public void checkAvailable() {
                }
            };
            this.inOut = inQ;
            this.in_p = new TtyInPort(this.inIn, inPath, outp);
        }
        this.in_p.setInDomTerm(true);
        InPort.setInDefault(this.in_p);
        OutPort.setOutDefault(outp);
        OutPort errp = new OutPort((Writer)errWriter, true, true, Path.valueOf("/dev/stderr"));
        outp.setDomTerm(true);
        errp.setDomTerm(true);
        OutPort.setErrDefault(errp);
        Environment env = Environment.getCurrent();
        try {
            this.sendInputMode(this.usingJLine ? (char)'c' : 'p');
            this.setAutomaticNewline(true);
            this.termWriter.write("\u001b]0;Kawa\u0007");
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        if (this.nrows >= 0) {
            this.setWindowSize(this.nrows, this.ncols, this.pixw, this.pixh);
        }
        Shell.run(this.language, env);
        try {
            this.termWriter.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void run(Writer out) throws Exception {
        this.termWriter = out;
        Thread thread2 = new Thread(this);
        thread2.start();
    }

    public void processInputCharacters(String text) {
        try {
            if (this.inOutS != null) {
                this.inOutS.write(text.getBytes());
                this.inOutS.flush();
            } else if (this.inOut != null) {
                this.inOut.append(text, 0, text.length());
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setWindowSize(int nrows, int ncols, int pixw, int pixh) {
        this.nrows = nrows;
        this.ncols = ncols;
        this.pixw = pixw;
        this.pixh = pixh;
        if (this.in_p != null && this.setSizeMethod != null) {
            try {
                this.setSizeMethod.invoke((Object)this.in_p, ncols, nrows);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void loadStyleSheet(String name, String fname) throws IOException {
        Writer commandWriter;
        InPort breader;
        String command = StyleSheets.loadStyleSheetRequest((String)name, (String)fname);
        DomTermBackend backend = instance.get(null);
        if (backend != null) {
            breader = backend.usingJLine ? new BinaryInPort(backend.inPipe) : backend.in_p;
            commandWriter = backend.termWriter;
        } else {
            BinaryOutPort outDefault = OutPort.getSystemOut();
            InPort inDefault = InPort.inDefault();
            if (!outDefault.isDomTerm() || !(inDefault instanceof TtyInPort)) {
                return;
            }
            commandWriter = outDefault;
            breader = inDefault;
        }
        commandWriter.write(command);
        commandWriter.flush();
        breader.mark(1);
        int ch = breader.read();
        if (ch == 157) {
            String string = breader.readLine();
        }
        if (ch >= 0) {
            breader.reset();
        }
    }

    public static class WebSocketServer
    extends DomServer {
        private static WebSocketServer instance = null;

        public WebSocketServer(int port) throws UnknownHostException {
            super(port, new String[0]);
        }

        protected Backend createBackend() {
            return new DomTermBackend();
        }

        public static synchronized WebSocketServer getInstance() {
            if (instance == null) {
                try {
                    instance = new WebSocketServer(0);
                }
                catch (UnknownHostException ex) {
                    throw new RuntimeException(ex);
                }
                instance.start();
            }
            return instance;
        }

        public static int getInstancePort() {
            return WebSocketServer.getInstance().getPort();
        }
    }
}

