/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl.jansi;

import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.fusesource.jansi.WindowsAnsiOutputStream;
import org.fusesource.jansi.internal.Kernel32;
import org.fusesource.jansi.internal.WindowsSupport;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.AbstractTerminal;
import org.jline.utils.Curses;
import org.jline.utils.InfoCmp;
import org.jline.utils.InputStreamReader;
import org.jline.utils.Log;
import org.jline.utils.NonBlockingReader;
import org.jline.utils.ShutdownHooks;
import org.jline.utils.Signals;

public class JansiWinSysTerminal
extends AbstractTerminal {
    protected final InputStream input;
    protected final OutputStream output;
    protected final NonBlockingReader reader;
    protected final PrintWriter writer;
    protected final Map<Terminal.Signal, Object> nativeHandlers = new HashMap<Terminal.Signal, Object>();
    protected final ShutdownHooks.Task closer;
    private static final int ENABLE_PROCESSED_INPUT = 1;
    private static final int ENABLE_LINE_INPUT = 2;
    private static final int ENABLE_ECHO_INPUT = 4;
    private static final int ENABLE_WINDOW_INPUT = 8;
    private static final int ENABLE_MOUSE_INPUT = 16;
    private static final int ENABLE_INSERT_MODE = 32;
    private static final int ENABLE_QUICK_EDIT_MODE = 64;

    public JansiWinSysTerminal(String name, boolean nativeSignals) throws IOException {
        super(name, "windows");
        this.input = new DirectInputStream();
        this.output = new WindowsAnsiOutputStream((OutputStream)new FileOutputStream(FileDescriptor.out));
        String encoding = JansiWinSysTerminal.getConsoleEncoding();
        if (encoding == null) {
            encoding = Charset.defaultCharset().name();
        }
        this.reader = new NonBlockingReader(this.getName(), new InputStreamReader(this.input, encoding));
        this.writer = new PrintWriter(new OutputStreamWriter(this.output, encoding));
        this.parseInfoCmp();
        if (nativeSignals) {
            for (Terminal.Signal signal : Terminal.Signal.values()) {
                this.nativeHandlers.put(signal, Signals.register(signal.name(), () -> this.raise(signal)));
            }
        }
        this.closer = this::close;
        ShutdownHooks.add(this.closer);
    }

    protected static String getConsoleEncoding() {
        int codepage = Kernel32.GetConsoleOutputCP();
        String charsetMS = "ms" + codepage;
        if (Charset.isSupported(charsetMS)) {
            return charsetMS;
        }
        String charsetCP = "cp" + codepage;
        if (Charset.isSupported(charsetCP)) {
            return charsetCP;
        }
        return null;
    }

    @Override
    public NonBlockingReader reader() {
        return this.reader;
    }

    @Override
    public PrintWriter writer() {
        return this.writer;
    }

    @Override
    public InputStream input() {
        return this.input;
    }

    @Override
    public OutputStream output() {
        return this.output;
    }

    @Override
    public Attributes getAttributes() {
        int mode = WindowsSupport.getConsoleMode();
        Attributes attributes = new Attributes();
        if ((mode & 4) != 0) {
            attributes.setLocalFlag(Attributes.LocalFlag.ECHO, true);
        }
        if ((mode & 2) != 0) {
            attributes.setLocalFlag(Attributes.LocalFlag.ICANON, true);
        }
        return attributes;
    }

    @Override
    public void setAttributes(Attributes attr) {
        int mode = 0;
        if (attr.getLocalFlag(Attributes.LocalFlag.ECHO)) {
            mode |= 4;
        }
        if (attr.getLocalFlag(Attributes.LocalFlag.ICANON)) {
            mode |= 2;
        }
        WindowsSupport.setConsoleMode((int)mode);
    }

    @Override
    public Size getSize() {
        Size size = new Size();
        size.setColumns(WindowsSupport.getWindowsTerminalWidth());
        size.setRows(WindowsSupport.getWindowsTerminalHeight());
        return size;
    }

    @Override
    public void setSize(Size size) {
        throw new UnsupportedOperationException("Can not resize windows terminal");
    }

    @Override
    public void close() throws IOException {
        ShutdownHooks.remove(this.closer);
        for (Map.Entry<Terminal.Signal, Object> entry : this.nativeHandlers.entrySet()) {
            Signals.unregister(entry.getKey().name(), entry.getValue());
        }
        this.reader.close();
        this.writer.close();
    }

    private byte[] readConsoleInput() {
        Kernel32.INPUT_RECORD[] events = null;
        try {
            events = WindowsSupport.readConsoleInput((int)1);
        }
        catch (IOException e) {
            Log.debug("read Windows terminal input error: ", e);
        }
        if (events == null) {
            return new byte[0];
        }
        StringBuilder sb = new StringBuilder();
        for (Kernel32.INPUT_RECORD event : events) {
            boolean isAlt;
            Kernel32.KEY_EVENT_RECORD keyEvent = event.keyEvent;
            int altState = Kernel32.KEY_EVENT_RECORD.LEFT_ALT_PRESSED | Kernel32.KEY_EVENT_RECORD.RIGHT_ALT_PRESSED;
            int ctrlState = Kernel32.KEY_EVENT_RECORD.LEFT_CTRL_PRESSED | Kernel32.KEY_EVENT_RECORD.RIGHT_CTRL_PRESSED;
            boolean bl = isAlt = (keyEvent.controlKeyState & altState) != 0 && (keyEvent.controlKeyState & ctrlState) == 0;
            if (keyEvent.keyDown) {
                if (keyEvent.uchar > '\u0000') {
                    if (isAlt) {
                        sb.append('\u001b');
                    }
                    sb.append(keyEvent.uchar);
                    continue;
                }
                String escapeSequence = null;
                switch (keyEvent.keyCode) {
                    case 8: {
                        escapeSequence = this.getSequence(InfoCmp.Capability.key_backspace);
                        break;
                    }
                    case 33: {
                        escapeSequence = this.getSequence(InfoCmp.Capability.key_ppage);
                        break;
                    }
                    case 34: {
                        escapeSequence = this.getSequence(InfoCmp.Capability.key_npage);
                        break;
                    }
                    case 35: {
                        escapeSequence = this.getSequence(InfoCmp.Capability.key_end);
                        break;
                    }
                    case 36: {
                        escapeSequence = this.getSequence(InfoCmp.Capability.key_home);
                        break;
                    }
                    case 37: {
                        escapeSequence = this.getSequence(InfoCmp.Capability.key_left);
                        break;
                    }
                    case 38: {
                        escapeSequence = this.getSequence(InfoCmp.Capability.key_up);
                        break;
                    }
                    case 39: {
                        escapeSequence = this.getSequence(InfoCmp.Capability.key_right);
                        break;
                    }
                    case 40: {
                        escapeSequence = this.getSequence(InfoCmp.Capability.key_down);
                        break;
                    }
                    case 45: {
                        escapeSequence = this.getSequence(InfoCmp.Capability.key_ic);
                        break;
                    }
                    case 46: {
                        escapeSequence = this.getSequence(InfoCmp.Capability.key_dc);
                        break;
                    }
                    case 112: {
                        escapeSequence = this.getSequence(InfoCmp.Capability.key_f1);
                        break;
                    }
                    case 113: {
                        escapeSequence = this.getSequence(InfoCmp.Capability.key_f2);
                        break;
                    }
                    case 114: {
                        escapeSequence = this.getSequence(InfoCmp.Capability.key_f3);
                        break;
                    }
                    case 115: {
                        escapeSequence = this.getSequence(InfoCmp.Capability.key_f4);
                        break;
                    }
                    case 116: {
                        escapeSequence = this.getSequence(InfoCmp.Capability.key_f5);
                        break;
                    }
                    case 117: {
                        escapeSequence = this.getSequence(InfoCmp.Capability.key_f6);
                        break;
                    }
                    case 118: {
                        escapeSequence = this.getSequence(InfoCmp.Capability.key_f7);
                        break;
                    }
                    case 119: {
                        escapeSequence = this.getSequence(InfoCmp.Capability.key_f8);
                        break;
                    }
                    case 120: {
                        escapeSequence = this.getSequence(InfoCmp.Capability.key_f9);
                        break;
                    }
                    case 121: {
                        escapeSequence = this.getSequence(InfoCmp.Capability.key_f10);
                        break;
                    }
                    case 122: {
                        escapeSequence = this.getSequence(InfoCmp.Capability.key_f11);
                        break;
                    }
                    case 123: {
                        escapeSequence = this.getSequence(InfoCmp.Capability.key_f12);
                        break;
                    }
                }
                if (escapeSequence == null) continue;
                for (int k = 0; k < keyEvent.repeatCount; ++k) {
                    if (isAlt) {
                        sb.append('\u001b');
                    }
                    sb.append(escapeSequence);
                }
                continue;
            }
            if (keyEvent.keyCode != 18 || keyEvent.uchar <= '\u0000') continue;
            sb.append(keyEvent.uchar);
        }
        return sb.toString().getBytes();
    }

    private String getSequence(InfoCmp.Capability cap) {
        String str = (String)this.strings.get((Object)cap);
        if (str != null) {
            StringWriter sw = new StringWriter();
            try {
                Curses.tputs(sw, str, new Object[0]);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
            return sw.toString();
        }
        return null;
    }

    private class DirectInputStream
    extends InputStream {
        private byte[] buf = null;
        int bufIdx = 0;

        private DirectInputStream() {
        }

        @Override
        public int read() throws IOException {
            while (this.buf == null || this.bufIdx == this.buf.length) {
                this.buf = JansiWinSysTerminal.this.readConsoleInput();
                this.bufIdx = 0;
            }
            int c = this.buf[this.bufIdx] & 0xFF;
            ++this.bufIdx;
            return c;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int c = this.read();
            if (c == -1) {
                return -1;
            }
            b[off] = (byte)c;
            return 1;
        }
    }
}

