
;;; datify.el

;; Copyright (C) 2006-2014 Davin Pearson

;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords: Cull Size Quota
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;; This file puts timestamps on archive files based on the date that
;; the archive file was last modified.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; m4_install_instructions(datify)

;;; Known Bugs:

;; None!

;;; Code:

;; (setq filename "~/abc.tar")
;; (setq filename "cosc363-assignment-20081010-122731.zip")
;; (setq filename "~/foo.zip")
;; (setq ext "zip")
;;
(defun datify--file (filename)
  ;;(message "* inside datify--file filename = %s " filename)
  (let (extension basename time)
    (setq extension (cond
                     ((string-match "\\.exe$" filename)
                      ".exe")
                     ((string-match "\\.tar\\.gz$" filename)
                      ".tar.gz")
                     ((string-match "\\.tar$" filename)
                      ".tar")
                     ((string-match "\\.zip$" filename)
                      ".zip")
                     ((string-match "\\.pdf$" filename)
                      ".pdf")
                     (t
                      (error "must be a exe|tar|tar.gz|zip|pdf file"))))

    (assert (string-match "\\.\\(exe\\|tar\\|tar.gz\\|zip\\|pdf\\)$" extension))
    (assert (file-exists-p filename))
    (setq time (nth 5 (file-attributes filename)))

    ;;(debug)

    (if (not (string-match (concat bak--yyyymmdd bak--hhmmss (regexp-quote extension) "$") filename))
        ;;                                Y Y    Y   Y        M    M   D    D           H    H    M    M     S    S
        ;;(if (not (string-match (concat "[0-9][0-9][0-9][0-9]" "[0-9][0-9][0-9][0-9]" "-" "[0-9][0-9][0-9][0-9][0-9][0-9]\\."
        (progn

          (d-quote
           ;;
           ;; BOTE: sanity check
           ;;
           (assert (string-match (concat "^[-a-zA-Z0-9.]*[a-zA-Z]+" (regexp-quote extension) "$")
                                 (file-name-nondirectory filename))))

          (progn
            ;;(debug)
            (assert (string-match (concat "\\(.*\\)" (regexp-quote extension) "$") filename))
            (setq basename (substring filename (match-beginning 1) (match-end 1)))
            (rename-file filename
                         (concat basename "-" (d-time--decode-time-readable time) extension)
                         'OK-IF-ALREADY-EXISTS))))))

;; (datify--dir (concat (bak-dir) "baz"))
;; (datify--dir "~/bak")
(defun datify--dir (&optional dirname)
  (interactive)
  (let (list ptr)
    (if (and (eq dirname nil) (eq major-mode 'dired-mode))
        (setq dirname default-directory))
    (setq list (directory-files dirname t "\\.\\(exe\\|tar\\|tar\\.gz\\|zip\\|pdf\\)$"))
    (setq ptr list)
    (let ((i 0)
          (len (length list)))
      (while ptr
        (incf i)
        (message "datify--dir dirname=%s progress=%d%%" (prin1-to-string dirname) (/ (* 100 i) len))
        (datify--file (car ptr))
        (setq ptr (cdr ptr))
        ))
  ))

(defun datify ()
  (interactive)
  ;;(d-time--update-timestamps)
  (let ((dirname default-directory))
    (assert (eq major-mode 'dired-mode))
    (datify--dir dirname)))

(defun datify-bak-dir ()
  (interactive)
  (datify--dir (bak-dir)))

(provide 'datify)
;;; datify.el ends here
