/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.IntegerStack;
import gnu.jel.debug.Tester;
import java.util.Stack;

public class TypesStack
implements Cloneable {
    protected static Class tsb_class = null;
    protected static Class string_class = null;
    public static final Class[] primitiveTypes;
    public static final char[] primitiveCodes;
    public static final String[] primitiveTypeNames;
    protected static final byte[] stkoccup;
    private IntegerStack primitiveIDs = new IntegerStack();
    private Stack classes = new Stack();
    protected int currWords = 0;
    private int maxWords = 0;
    private static final byte[] cvt_wide;

    static {
        try {
            string_class = Class.forName("java.lang.String");
            tsb_class = Class.forName("gnu.jel.TempStringBuffer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        primitiveTypes = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, null, Void.TYPE};
        primitiveCodes = new char[]{'Z', 'B', 'C', 'S', 'I', 'J', 'F', 'D', 'L', 'V'};
        primitiveTypeNames = new String[]{"boolean", "byte", "char", "short", "int", "long", "float", "double", "reference", "void"};
        byte[] byArray = new byte[10];
        byArray[0] = 1;
        byArray[1] = 1;
        byArray[2] = 1;
        byArray[3] = 1;
        byArray[4] = 1;
        byArray[5] = 2;
        byArray[6] = 1;
        byArray[7] = 2;
        byArray[8] = 1;
        stkoccup = byArray;
        cvt_wide = new byte[]{-128, 64, 96, 80, 120, 92, 94, 95};
    }

    public Object clone() {
        TypesStack typesStack = null;
        try {
            typesStack = (TypesStack)super.clone();
            typesStack.primitiveIDs = (IntegerStack)typesStack.primitiveIDs.clone();
            typesStack.classes = (Stack)typesStack.classes.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return typesStack;
    }

    public final int getMaxOccupation() {
        return this.maxWords;
    }

    public static boolean isString(Class clazz) {
        return clazz == string_class;
    }

    public static boolean isTSB(Class clazz) {
        return clazz == tsb_class;
    }

    public static boolean isWidening(int n, int n2) {
        if (n < 8 && n2 < 8) {
            return (cvt_wide[n2] & 128 >> n) > 0;
        }
        return false;
    }

    public static boolean isWidening(Class clazz, Class clazz2) {
        boolean bl = clazz.isPrimitive();
        boolean bl2 = clazz2.isPrimitive();
        if (bl2 && bl) {
            return TypesStack.isWidening(TypesStack.primitiveID(clazz), TypesStack.primitiveID(clazz2));
        }
        if (bl2 ^ bl) {
            return false;
        }
        if (clazz == tsb_class && clazz2 == string_class || clazz2 == tsb_class && clazz == string_class) {
            return true;
        }
        return clazz2.isAssignableFrom(clazz);
    }

    public static void main(String[] stringArray) {
    }

    protected static Object narrow(Number number, int n) {
        switch (n) {
            case 0: {
                if (number.longValue() != 0L) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case 1: {
                return new Byte(number.byteValue());
            }
            case 2: {
                return new Character((char)number.longValue());
            }
            case 3: {
                return new Short(number.shortValue());
            }
            case 4: {
                return new Integer(number.intValue());
            }
            case 5: {
                return new Long(number.longValue());
            }
            case 6: {
                return new Float(number.floatValue());
            }
            case 7: {
                return new Double(number.doubleValue());
            }
        }
        return null;
    }

    public final Class peek() {
        return (Class)this.classes.peek();
    }

    public final Class peek(int n) {
        return (Class)this.classes.elementAt(this.classes.size() - 1 - n);
    }

    public final int peekID() {
        return this.primitiveIDs.peek();
    }

    public final int peekID(int n) {
        return this.primitiveIDs.peek(n);
    }

    public final Class pop() {
        int n = this.primitiveIDs.pop();
        this.currWords -= stkoccup[n];
        return (Class)this.classes.pop();
    }

    public static final int primitiveID(Class clazz) {
        if (clazz == null || !clazz.isPrimitive()) {
            return 8;
        }
        int n = 0;
        while (n < primitiveTypes.length && primitiveTypes[n] != clazz) {
            ++n;
        }
        return n;
    }

    public static final int primitiveID(Object object) {
        if (object instanceof Boolean) {
            return 0;
        }
        if (object instanceof Byte) {
            return 1;
        }
        if (object instanceof Character) {
            return 2;
        }
        if (object instanceof Short) {
            return 3;
        }
        if (object instanceof Integer) {
            return 4;
        }
        if (object instanceof Long) {
            return 5;
        }
        if (object instanceof Float) {
            return 6;
        }
        if (object instanceof Double) {
            return 7;
        }
        return 8;
    }

    public final void push(Class clazz) {
        this.pushID(TypesStack.primitiveID(clazz), clazz);
    }

    public final void push(Class clazz, int n) {
        int n2 = TypesStack.primitiveID(clazz);
        this.primitiveIDs.push(n2, n);
        this.classes.insertElementAt(clazz, this.classes.size() - n);
        this.currWords += stkoccup[n2];
        if (this.currWords > this.maxWords) {
            this.maxWords = this.currWords;
        }
    }

    public final void pushID(int n) {
        this.pushID(n, null);
    }

    public final void pushID(int n, int n2) {
        Class clazz = primitiveTypes[n];
        this.primitiveIDs.push(n, n2);
        this.classes.insertElementAt(clazz, this.classes.size() - n2);
        this.currWords += stkoccup[n];
        if (this.currWords > this.maxWords) {
            this.maxWords = this.currWords;
        }
    }

    public final void pushID(int n, Class clazz) {
        this.primitiveIDs.push(n);
        if (n == 8) {
            this.classes.push(clazz);
        } else {
            this.classes.push(primitiveTypes[n]);
        }
        this.currWords += stkoccup[n];
        if (this.currWords > this.maxWords) {
            this.maxWords = this.currWords;
        }
    }

    public final void resetStats() {
        this.maxWords = 0;
    }

    public final int size() {
        return this.primitiveIDs.size();
    }

    public final void tempExcessWords(int n) {
        if ((n = this.currWords + n) > this.maxWords) {
            this.maxWords = n;
        }
    }

    public static void test(Tester tester) {
    }

    protected static Number widen(Object object, int n) {
        switch (n) {
            case 0: {
                if (((Boolean)object).booleanValue()) {
                    return new Long(1L);
                }
                return new Long(0L);
            }
            case 1: {
                return (Number)object;
            }
            case 2: {
                return new Long(((Character)object).charValue());
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return (Number)object;
            }
        }
        return new Long(0L);
    }
}

