/*  GFAX - Gnome fax application
 *  Copyright (C) 1999 George A. Farris
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

typedef struct _setup Setup;
typedef struct _mgettyconfigdata MgettyConfigData;
typedef struct _hylafaxconfigdata HylafaxConfigData;

struct _setup {
	GnomePropertyBox *setup;
	GtkCheckButton *emailNotifyCheckButton;
	GtkCheckButton *sendNowCheckButton;
	GtkCheckButton *coverPageCheckButton;
	GtkCheckButton *resolutionCheckButton;
	GtkRadioButton *hylafaxRadioButton;	
	GtkRadioButton *mgettyRadioButton;	
	GtkWidget *userTab;
	GtkWidget *hylafaxTab;
	GtkWidget *mgettyTab;
	GtkTable *mgettyTable;
	GtkEntry *emailAddressEntry;
	GtkEntry *phonePrefixEntry;
	GtkEntry *ourFaxNumberEntry;

	/* mgetty setup widgets */
	GtkEntry *mgettyModemInitEntry;
	GtkEntry *mgettyModemPortCombo;
	GtkEntry *mgettyModemHandshakeEntry;			/**/
	GtkEntry *mgettyModemQuirksEntry;				/**/
 	GtkEntry *mgettySendfaxConfigFileEntry;
	GtkEntry *mgettyDialCommandEntry;				/**/
	GnomeFileEntry *mgettyFileEntry;
	GtkOptionMenu *mgettyMaxTriesOptionmenu;
	GtkOptionMenu *mgettyIgnoreCarrierOptionmenu;
	GtkOptionMenu *mgettyMaxTriesContOptionmenu;	/**/
	GtkOptionMenu *mgettyModemSpeedOptionmenu;
	GtkOptionMenu *mgettyModemSwitchSpeedOptionmenu;/**/
	GtkOptionMenu *mgettyModemTypeOptionmenu;
	GtkOptionMenu *mgettyDebugLevelOptionmenu;		/**/
	GtkOptionMenu *mgettyOpenDelayOptionmenu;		/**/
	GtkOptionMenu *mgRunQueueOptionmenu;
	GtkCheckButton *mgettyConfigControlCheckButton;
	GtkText *mgUserAllowText;
	GtkText *mgUserDenyText;
	GtkButton *mgettySetupDruidButton;

	/* hylafax setup widgets */
        GtkEntry *hylafaxServerNameEntry;
        GtkEntry *hylafaxServerPortEntry;
        GtkCheckButton *hylafaxServerInternalSendfax;
};

struct _mgettyconfigdata {
	gboolean disabledConfig;
	gint ignoreCarrier;		/* ignore the modem if it lowers the cd line */
	gint portSpeed;			/* serial port speed */
	gint portSpeedSwitch;	/* serial port speed to switch to */
	gint modemType;			/* class 2, class 2.0 type modem */
	gint maxTries;			/* maximum tries on each page before giving up */
	gint maxTriesContinue;	/* Continue after max tries or not */
	gint debugLevel;		/* Debug level for log */	
	gint openDelay;			/* Delay response when opening device */
	gint runQueuePeriod;	/* how often do we run faxrunq in minutes */
	gchar *modemInit;		/* modem initailizer string */
	gchar *modemHandshake;	/* Aditional handshake to send modem after init */
	gchar *modemQuirks;		/* A bitmask to get some special modems to work */
	gchar *modemDialCommand;/* The command to dial the phone default is ATDT */
	gchar *modemPort;		/* serial port */
	gchar *configFile;		/* the sendfax config file */

};

struct _hylafaxconfigdata {
  	gchar   *serverHost;		/* hostname of hylafax server */
	gint     serverPort;		/* port of hylafax server */
	gboolean internalSendfax;      	/* use internal sendfax? */
};

/*
extern Setup *prop;
extern MgettyConfigData *mgetty;
extern HylafaxConfigData *hylafax;
*/

void setup_changed(GtkWidget *widget, gpointer data);
void setup_help(GtkWidget *propertybox, gint pageNumber, gpointer data);
void set_config(GtkWidget *propertybox, gint pageNumber, gpointer data);

void mgetty_setup_changed(GtkWidget *widget, gpointer data);
void mgetty_setup_druid(GtkWidget *widget, gpointer data);
void mgetty_get_config(gboolean calledFromMain, Setup *prop, MgettyConfigData *mgetty);
void mgetty_set_config(Setup *prop, MgettyConfigData *mgetty);

void hylafax_setup_changed(GtkWidget *widget, gpointer data);
void hylafax_get_config(gboolean calledFromMain, Setup *prop, HylafaxConfigData *hylafax);
void hylafax_set_config(Setup *prop, HylafaxConfigData *hylafax);


void append_crontab_entry(gchar *fields);
void delete_crontab_entry(gchar *entry);


/* These are Emacs variables to use a common "Gfax" coding style:
 * ;;; Local Variables: ***
 * ;;; mode:C ***
 * ;;; c-basic-offset:8 ***
 * ;;; indent-tabs-mode:t ***
 * ;;; End: ***
 */
