/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/*
 *  Copyright 1999 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */

#ifndef _VRUDPSOURCE_H_
#define _VRUDPSOURCE_H_

#include <VrSource.h>

#include <string.h> 
#include <sys/types.h> 
#include <netinet/in.h> 
#include <sys/socket.h> 
#include <sys/wait.h>
#include <arpa/inet.h>
#include <netinet/in.h>

#define MAX_UDP_SIZE	3000

template<class oType> 
class VrUDPSource : public VrSource<oType> {
protected:
  int sockfd;
  struct sockaddr_in my_addr;    /* my address information */
  struct sockaddr_in their_addr; /* connector's address information */
  unsigned char tempbuf[MAX_UDP_SIZE];
  int tempbuf_index, tempbuf_size;
public: 
  virtual const char *name() { return "VrUDPSource"; }

  virtual int work2(VrSampleRange output, void *o[]);

  VrUDPSource (double sampling_freq, int port);
  virtual ~VrUDPSource() {}
};
    
template<class oType> int
VrUDPSource<oType>::work2(VrSampleRange output, void *ao[])
{
  oType **o= (oType **)ao;
  unsigned int addr_len = sizeof(struct sockaddr);
  int size = output.size * sizeof(oType);
  unsigned char *cp = (unsigned char *)o[0];
  int temp;
  
  //jca printf ("[%s] work %ld\n", __FILE__, output.size);
  printf ("[%s] work %ld\n", __FILE__, output.size);
  while (size > 0) {
   if (tempbuf_size > 0) {
      *cp++ = tempbuf[tempbuf_index++];
      tempbuf_size--;
      size--;
      continue;
   }
   if (size < MAX_UDP_SIZE) {
      tempbuf_index = 0;
      tempbuf_size = recvfrom(sockfd, tempbuf, sizeof(tempbuf), 0,
          (struct sockaddr *)&their_addr, &addr_len);
      continue;
   }
   temp = recvfrom(sockfd, cp, size, 0,
       (struct sockaddr *)&their_addr, &addr_len);
   if (temp > 0){
     // jca printf ("received %d bytes from %s\n", temp, inet_ntoa(their_addr.sin_addr) );
     printf ("received %d bytes from %s\n", temp, inet_ntoa(their_addr.sin_addr) );
     size -= temp;
     cp += temp;
   }
   else {
     printf ("[%s:%d] error in recvfrom %d\n", __FILE__, __LINE__, errno);
     break;
   }
  }
  return (int)output.size;
}

template<class oType> 
VrUDPSource<oType>::VrUDPSource(double sampling_freq, int port)
{
  setSamplingFrequency (sampling_freq);
  tempbuf_index = 0;
  tempbuf_size = 0;
  if ((sockfd = socket(AF_INET, SOCK_DGRAM, 0)) == -1) {
    perror("socket");
    exit(1);
  }
  my_addr.sin_family = AF_INET;         /* host byte order */
  my_addr.sin_port = htons(port);       /* short, network byte order */
  my_addr.sin_addr.s_addr = INADDR_ANY; /* auto-fill with my IP */
  bzero(&(my_addr.sin_zero), 8);        /* zero the rest of the struct */

  if (bind(sockfd, (struct sockaddr *)&my_addr, sizeof(struct sockaddr))  == -1) {
    perror("bind");
    exit(1);
  }
}
#endif
