#ifndef __BDK_CSRS_PEM_H__
#define __BDK_CSRS_PEM_H__
/* This file is auto-generated. Do not edit */

/***********************license start***************
 * Copyright (c) 2003-2017  Cavium Inc. (support@cavium.com). All rights
 * reserved.
 *
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *   * Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *
 *   * Redistributions in binary form must reproduce the above
 *     copyright notice, this list of conditions and the following
 *     disclaimer in the documentation and/or other materials provided
 *     with the distribution.

 *   * Neither the name of Cavium Inc. nor the names of
 *     its contributors may be used to endorse or promote products
 *     derived from this software without specific prior written
 *     permission.

 * This Software, including technical data, may be subject to U.S. export  control
 * laws, including the U.S. Export Administration Act and its  associated
 * regulations, and may be subject to export or import  regulations in other
 * countries.

 * TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
 * AND WITH ALL FAULTS AND CAVIUM  NETWORKS MAKES NO PROMISES, REPRESENTATIONS OR
 * WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT TO
 * THE SOFTWARE, INCLUDING ITS CONDITION, ITS CONFORMITY TO ANY REPRESENTATION OR
 * DESCRIPTION, OR THE EXISTENCE OF ANY LATENT OR PATENT DEFECTS, AND CAVIUM
 * SPECIFICALLY DISCLAIMS ALL IMPLIED (IF ANY) WARRANTIES OF TITLE,
 * MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE, LACK OF
 * VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION OR
 * CORRESPONDENCE TO DESCRIPTION. THE ENTIRE  RISK ARISING OUT OF USE OR
 * PERFORMANCE OF THE SOFTWARE LIES WITH YOU.
 ***********************license end**************************************/


/**
 * @file
 *
 * Configuration and status register (CSR) address and type definitions for
 * Cavium PEM.
 *
 * This file is auto generated. Do not edit.
 *
 */

/**
 * Enumeration pem_bar_e
 *
 * PEM Base Address Register Enumeration
 * Enumerates the base address registers.
 */
#define BDK_PEM_BAR_E_PEMX_PF_BAR0_CN8(a) (0x87e0c0000000ll + 0x1000000ll * (a))
#define BDK_PEM_BAR_E_PEMX_PF_BAR0_CN8_SIZE 0x800000ull
#define BDK_PEM_BAR_E_PEMX_PF_BAR0_CN9(a) (0x8e0000000000ll + 0x1000000000ll * (a))
#define BDK_PEM_BAR_E_PEMX_PF_BAR0_CN9_SIZE 0x40000000ull
#define BDK_PEM_BAR_E_PEMX_PF_BAR4_CN8(a) (0x87e0c0f00000ll + 0x1000000ll * (a))
#define BDK_PEM_BAR_E_PEMX_PF_BAR4_CN8_SIZE 0x100000ull
#define BDK_PEM_BAR_E_PEMX_PF_BAR4_CN9(a) (0x8e0f00000000ll + 0x1000000000ll * (a))
#define BDK_PEM_BAR_E_PEMX_PF_BAR4_CN9_SIZE 0x100000ull

/**
 * Enumeration pem_ep_functions_e
 *
 * PEM EP Mode Function Number Enumeration
 * Enumerates the function numbers that an EP PEM masters.
 */
#define BDK_PEM_EP_FUNCTIONS_E_PF0 (0)
#define BDK_PEM_EP_FUNCTIONS_E_PF0_VFX(a) (0 + (a))

/**
 * Enumeration pem_int_vec_e
 *
 * PEM MSI-X Vector Enumeration
 * Enumerates the MSI-X interrupt vectors.
 */
#define BDK_PEM_INT_VEC_E_DBG_INFO_CN81XX (0xb)
#define BDK_PEM_INT_VEC_E_DBG_INFO_CN88XX (0xd)
#define BDK_PEM_INT_VEC_E_DBG_INFO_CN83XX (0xb)
#define BDK_PEM_INT_VEC_E_ERROR_AERI (0)
#define BDK_PEM_INT_VEC_E_ERROR_AERI_CLEAR (1)
#define BDK_PEM_INT_VEC_E_ERROR_PMEI (2)
#define BDK_PEM_INT_VEC_E_ERROR_PMEI_CLEAR (3)
#define BDK_PEM_INT_VEC_E_HP_INT (0xe)
#define BDK_PEM_INT_VEC_E_HP_INT_CLEAR (0xf)
#define BDK_PEM_INT_VEC_E_HP_PMEI (1)
#define BDK_PEM_INT_VEC_E_INTA_CN9 (0)
#define BDK_PEM_INT_VEC_E_INTA_CN81XX (2)
#define BDK_PEM_INT_VEC_E_INTA_CN88XX (4)
#define BDK_PEM_INT_VEC_E_INTA_CN83XX (2)
#define BDK_PEM_INT_VEC_E_INTA_CLEAR_CN9 (1)
#define BDK_PEM_INT_VEC_E_INTA_CLEAR_CN81XX (3)
#define BDK_PEM_INT_VEC_E_INTA_CLEAR_CN88XX (5)
#define BDK_PEM_INT_VEC_E_INTA_CLEAR_CN83XX (3)
#define BDK_PEM_INT_VEC_E_INTB_CN9 (2)
#define BDK_PEM_INT_VEC_E_INTB_CN81XX (4)
#define BDK_PEM_INT_VEC_E_INTB_CN88XX (6)
#define BDK_PEM_INT_VEC_E_INTB_CN83XX (4)
#define BDK_PEM_INT_VEC_E_INTB_CLEAR_CN9 (3)
#define BDK_PEM_INT_VEC_E_INTB_CLEAR_CN81XX (5)
#define BDK_PEM_INT_VEC_E_INTB_CLEAR_CN88XX (7)
#define BDK_PEM_INT_VEC_E_INTB_CLEAR_CN83XX (5)
#define BDK_PEM_INT_VEC_E_INTC_CN9 (4)
#define BDK_PEM_INT_VEC_E_INTC_CN81XX (6)
#define BDK_PEM_INT_VEC_E_INTC_CN88XX (8)
#define BDK_PEM_INT_VEC_E_INTC_CN83XX (6)
#define BDK_PEM_INT_VEC_E_INTC_CLEAR_CN9 (5)
#define BDK_PEM_INT_VEC_E_INTC_CLEAR_CN81XX (7)
#define BDK_PEM_INT_VEC_E_INTC_CLEAR_CN88XX (9)
#define BDK_PEM_INT_VEC_E_INTC_CLEAR_CN83XX (7)
#define BDK_PEM_INT_VEC_E_INTD_CN9 (6)
#define BDK_PEM_INT_VEC_E_INTD_CN81XX (8)
#define BDK_PEM_INT_VEC_E_INTD_CN88XX (0xa)
#define BDK_PEM_INT_VEC_E_INTD_CN83XX (8)
#define BDK_PEM_INT_VEC_E_INTD_CLEAR_CN9 (7)
#define BDK_PEM_INT_VEC_E_INTD_CLEAR_CN81XX (9)
#define BDK_PEM_INT_VEC_E_INTD_CLEAR_CN88XX (0xb)
#define BDK_PEM_INT_VEC_E_INTD_CLEAR_CN83XX (9)
#define BDK_PEM_INT_VEC_E_INT_SUM_CN9 (8)
#define BDK_PEM_INT_VEC_E_INT_SUM_CN81XX (0xa)
#define BDK_PEM_INT_VEC_E_INT_SUM_CN88XX (0xc)
#define BDK_PEM_INT_VEC_E_INT_SUM_CN83XX (0xa)

/**
 * Register (RSL) pem#_bar1_index#
 *
 * PEM BAR1 Index 0-15 Register
 * This register contains the address index and control bits for access to memory ranges of BAR1.
 * The index is selected from the PCIe address depending on the programmed BAR-1 size.
 */
union bdk_pemx_bar1_indexx
{
    uint64_t u;
    struct bdk_pemx_bar1_indexx_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_31_63        : 33;
        uint64_t addr_idx              : 27; /**< [ 30:  4](R/W) Address index. Address bits [48:22] sent to L2C. */
        uint64_t ca                    : 1;  /**< [  3:  3](R/W) Cached. Set to 1 when access is not to be cached in L2. */
        uint64_t end_swp               : 2;  /**< [  2:  1](R/W) Endian-swap mode. */
        uint64_t addr_v                : 1;  /**< [  0:  0](R/W) Address valid. Set to 1 when the selected address range is valid. */
#else /* Word 0 - Little Endian */
        uint64_t addr_v                : 1;  /**< [  0:  0](R/W) Address valid. Set to 1 when the selected address range is valid. */
        uint64_t end_swp               : 2;  /**< [  2:  1](R/W) Endian-swap mode. */
        uint64_t ca                    : 1;  /**< [  3:  3](R/W) Cached. Set to 1 when access is not to be cached in L2. */
        uint64_t addr_idx              : 27; /**< [ 30:  4](R/W) Address index. Address bits [48:22] sent to L2C. */
        uint64_t reserved_31_63        : 33;
#endif /* Word 0 - End */
    } s;
    struct bdk_pemx_bar1_indexx_cn81xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_31_63        : 33;
        uint64_t addr_idx              : 27; /**< [ 30:  4](R/W) Address index. Address bits [48:22] sent to L2C. */
        uint64_t ca                    : 1;  /**< [  3:  3](R/W) Cached. Set to 1 when access is not to be cached in L2. */
        uint64_t reserved_1_2          : 2;
        uint64_t addr_v                : 1;  /**< [  0:  0](R/W) Address valid. Set to 1 when the selected address range is valid. */
#else /* Word 0 - Little Endian */
        uint64_t addr_v                : 1;  /**< [  0:  0](R/W) Address valid. Set to 1 when the selected address range is valid. */
        uint64_t reserved_1_2          : 2;
        uint64_t ca                    : 1;  /**< [  3:  3](R/W) Cached. Set to 1 when access is not to be cached in L2. */
        uint64_t addr_idx              : 27; /**< [ 30:  4](R/W) Address index. Address bits [48:22] sent to L2C. */
        uint64_t reserved_31_63        : 33;
#endif /* Word 0 - End */
    } cn81xx;
    /* struct bdk_pemx_bar1_indexx_cn81xx cn88xx; */
    /* struct bdk_pemx_bar1_indexx_s cn83xx; */
};
typedef union bdk_pemx_bar1_indexx bdk_pemx_bar1_indexx_t;

static inline uint64_t BDK_PEMX_BAR1_INDEXX(unsigned long a, unsigned long b) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_BAR1_INDEXX(unsigned long a, unsigned long b)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN81XX) && ((a<=2) && (b<=15)))
        return 0x87e0c0000100ll + 0x1000000ll * ((a) & 0x3) + 8ll * ((b) & 0xf);
    if (CAVIUM_IS_MODEL(CAVIUM_CN83XX) && ((a<=3) && (b<=15)))
        return 0x87e0c0000100ll + 0x1000000ll * ((a) & 0x3) + 8ll * ((b) & 0xf);
    if (CAVIUM_IS_MODEL(CAVIUM_CN88XX) && ((a<=5) && (b<=15)))
        return 0x87e0c0000100ll + 0x1000000ll * ((a) & 0x7) + 8ll * ((b) & 0xf);
    __bdk_csr_fatal("PEMX_BAR1_INDEXX", 2, a, b, 0, 0);
}

#define typedef_BDK_PEMX_BAR1_INDEXX(a,b) bdk_pemx_bar1_indexx_t
#define bustype_BDK_PEMX_BAR1_INDEXX(a,b) BDK_CSR_TYPE_RSL
#define basename_BDK_PEMX_BAR1_INDEXX(a,b) "PEMX_BAR1_INDEXX"
#define device_bar_BDK_PEMX_BAR1_INDEXX(a,b) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_BAR1_INDEXX(a,b) (a)
#define arguments_BDK_PEMX_BAR1_INDEXX(a,b) (a),(b),-1,-1

/**
 * Register (NCB) pem#_bar2_mask
 *
 * PEM BAR2 Mask Register
 * This register contains the mask pattern that is ANDed with the address from the PCIe core for
 * inbound PF BAR2 hits in either RC or EP mode. This mask is only applied if
 * PEM()_EBUS_CTL[PF_BAR2_SEL] is clear and the address hits in the PCIEEP_BAR2L / PCIEEP_BAR2U
 * registers (EP mode) or PEM()_P2N_BAR2_START / PEM()_BAR_CTL[BAR2_SIZ] registers (RC mode).
 *
 * This register is not accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on PEM domain reset.
 */
union bdk_pemx_bar2_mask
{
    uint64_t u;
    struct bdk_pemx_bar2_mask_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_53_63        : 11;
        uint64_t mask                  : 49; /**< [ 52:  4](R/W) The value to be ANDED with the address sent to memory. */
        uint64_t reserved_0_3          : 4;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0_3          : 4;
        uint64_t mask                  : 49; /**< [ 52:  4](R/W) The value to be ANDED with the address sent to memory. */
        uint64_t reserved_53_63        : 11;
#endif /* Word 0 - End */
    } s;
    struct bdk_pemx_bar2_mask_cn9
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_53_63        : 11;
        uint64_t mask                  : 49; /**< [ 52:  4](R/W) The value to be ANDed with the address sent to memory (to IOB). */
        uint64_t reserved_0_3          : 4;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0_3          : 4;
        uint64_t mask                  : 49; /**< [ 52:  4](R/W) The value to be ANDed with the address sent to memory (to IOB). */
        uint64_t reserved_53_63        : 11;
#endif /* Word 0 - End */
    } cn9;
    struct bdk_pemx_bar2_mask_cn81xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_49_63        : 15;
        uint64_t mask                  : 45; /**< [ 48:  4](R/W) The value to be ANDED with the address sent to memory. */
        uint64_t reserved_0_3          : 4;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0_3          : 4;
        uint64_t mask                  : 45; /**< [ 48:  4](R/W) The value to be ANDED with the address sent to memory. */
        uint64_t reserved_49_63        : 15;
#endif /* Word 0 - End */
    } cn81xx;
    /* struct bdk_pemx_bar2_mask_cn81xx cn88xx; */
    struct bdk_pemx_bar2_mask_cn83xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_49_63        : 15;
        uint64_t mask                  : 45; /**< [ 48:  4](R/W) The value to be ANDed with the address sent to memory (to IOB). */
        uint64_t reserved_0_3          : 4;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0_3          : 4;
        uint64_t mask                  : 45; /**< [ 48:  4](R/W) The value to be ANDed with the address sent to memory (to IOB). */
        uint64_t reserved_49_63        : 15;
#endif /* Word 0 - End */
    } cn83xx;
};
typedef union bdk_pemx_bar2_mask bdk_pemx_bar2_mask_t;

static inline uint64_t BDK_PEMX_BAR2_MASK(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_BAR2_MASK(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN81XX) && (a<=2))
        return 0x87e0c00000b0ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN83XX) && (a<=3))
        return 0x87e0c00000b0ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN88XX) && (a<=5))
        return 0x87e0c00000b0ll + 0x1000000ll * ((a) & 0x7);
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e0000000040ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_BAR2_MASK", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_BAR2_MASK(a) bdk_pemx_bar2_mask_t
#define bustype_BDK_PEMX_BAR2_MASK(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_BAR2_MASK(a) "PEMX_BAR2_MASK"
#define device_bar_BDK_PEMX_BAR2_MASK(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_BAR2_MASK(a) (a)
#define arguments_BDK_PEMX_BAR2_MASK(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_bar4_index#
 *
 * PEM BAR4 Index 0-15 Register
 * This register contains the address index and control bits for access to memory ranges of BAR4.
 * The index is built from the PCI inbound address \<25:22\>. The bits in this register only apply to
 * inbound accesses targeting the NCB bus in both RC and EP modes, this register is ignored
 * when PEM()_EBUS_CTL[PF_BAR4_SEL] is set.
 *
 * This register is not accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on PEM domain reset.
 */
union bdk_pemx_bar4_indexx
{
    uint64_t u;
    struct bdk_pemx_bar4_indexx_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_35_63        : 29;
        uint64_t addr_idx              : 31; /**< [ 34:  4](R/W) Address index. IOVA \<52:22\> sent to NCB. */
        uint64_t ca                    : 1;  /**< [  3:  3](R/W) Cached. Set to 1 when access is not to be cached in LLC. */
        uint64_t reserved_1_2          : 2;
        uint64_t addr_v                : 1;  /**< [  0:  0](R/W) Address valid. Set to 1 when the selected address range is valid. */
#else /* Word 0 - Little Endian */
        uint64_t addr_v                : 1;  /**< [  0:  0](R/W) Address valid. Set to 1 when the selected address range is valid. */
        uint64_t reserved_1_2          : 2;
        uint64_t ca                    : 1;  /**< [  3:  3](R/W) Cached. Set to 1 when access is not to be cached in LLC. */
        uint64_t addr_idx              : 31; /**< [ 34:  4](R/W) Address index. IOVA \<52:22\> sent to NCB. */
        uint64_t reserved_35_63        : 29;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_bar4_indexx_s cn; */
};
typedef union bdk_pemx_bar4_indexx bdk_pemx_bar4_indexx_t;

static inline uint64_t BDK_PEMX_BAR4_INDEXX(unsigned long a, unsigned long b) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_BAR4_INDEXX(unsigned long a, unsigned long b)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && ((a<=3) && (b<=15)))
        return 0x8e0000000700ll + 0x1000000000ll * ((a) & 0x3) + 8ll * ((b) & 0xf);
    __bdk_csr_fatal("PEMX_BAR4_INDEXX", 2, a, b, 0, 0);
}

#define typedef_BDK_PEMX_BAR4_INDEXX(a,b) bdk_pemx_bar4_indexx_t
#define bustype_BDK_PEMX_BAR4_INDEXX(a,b) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_BAR4_INDEXX(a,b) "PEMX_BAR4_INDEXX"
#define device_bar_BDK_PEMX_BAR4_INDEXX(a,b) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_BAR4_INDEXX(a,b) (a)
#define arguments_BDK_PEMX_BAR4_INDEXX(a,b) (a),(b),-1,-1

/**
 * Register (NCB) pem#_bar_ctl
 *
 * PEM BAR Control Register
 * This register contains control for BAR accesses. This control always
 * applies to memory accesses targeting the NCBI bus. Some of the fields also
 * apply to accesses targeting EBUS in RC mode only, see the individual field
 * descriptions for more detail.
 *
 * This register is not accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on PEM domain reset.
 */
union bdk_pemx_bar_ctl
{
    uint64_t u;
    struct bdk_pemx_bar_ctl_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_38_63        : 26;
        uint64_t vf_bar4_enb           : 1;  /**< [ 37: 37](R/W) This bit controls whether BAR4 for all virtual functions is enabled.

                                                                 In RC mode:
                                                                 * VF BAR4 does not exist. This bit has no effect.

                                                                 In EP mode:

                                                                  * VF BAR4 hits are based on a combination of this bit and
                                                                  config registers PCIEEP_SRIOV_BAR4U, PCIEEP_SRIOV_BAR4L, and
                                                                  PCIEEP_SRIOV_CTL[VFE].  Both PCIEEP_SRIOV_CTL[VFE] and this
                                                                  bit must be set to enable a VF BAR4 hit to the PCI address
                                                                  specified by PCIEEP_SRIOV_BAR4U / PCIEEP_SRIOV_BAR4L. */
        uint64_t vf_bar2_enb           : 1;  /**< [ 36: 36](R/W) This bit controls whether BAR2 for all virtual functions is enabled.

                                                                 In RC mode:
                                                                 * VF BAR2 does not exist. This bit has no effect.

                                                                 In EP mode:

                                                                  * VF BAR2 hits are based on a combination of this bit and
                                                                  config registers PCIEEP_SRIOV_BAR2U, PCIEEP_SRIOV_BAR2L, and
                                                                  PCIEEP_SRIOV_CTL[VFE].  Both PCIEEP_SRIOV_CTL[VFE] and this
                                                                  bit must be set to enable a VF BAR2 hit to the PCI address
                                                                  specified by PCIEEP_SRIOV_BAR2U / PCIEEP_SRIOV_BAR2L. */
        uint64_t vf_bar0_enb           : 1;  /**< [ 35: 35](R/W) This bit controls whether BAR0 for all virtual functions is enabled.

                                                                 In RC mode:
                                                                 * VF BAR0 does not exist. This bit has no effect.

                                                                 In EP mode:

                                                                  * VF BAR0 hits are based on a combination of this bit and
                                                                  config registers PCIEEP_SRIOV_BAR0U, PCIEEP_SRIOV_BAR0L, and
                                                                  PCIEEP_SRIOV_CTL[VFE].  Both PCIEEP_SRIOV_CTL[VFE] and this
                                                                  bit must be set to enable a VF BAR0 hit to the PCI address
                                                                  specified by PCIEEP_SRIOV_BAR0U / PCIEEP_SRIOV_BAR0L. */
        uint64_t erom_siz              : 3;  /**< [ 34: 32](R/W) PCIe EROM BAR size. Used to mask off upper bits of address
                                                                 when sending to NCBI or via private EROM interface to MIO.

                                                                 0x0 = Reserved.
                                                                 0x1 = 64 KB; 2^16.
                                                                 0x2 = 128 KB; 2^17.
                                                                 0x3 = 256 KB; 2^18.
                                                                 0x4 = 512 KB; 2^19.
                                                                 0x5 = 1 MB; 2^20.
                                                                 0x6 = 2 MB; 2^21.
                                                                 0x7 = 4 MB; 2^22. */
        uint64_t bar4_enb              : 1;  /**< [ 31: 31](R/W) In RC mode:
                                                                  0 = BAR4 access will cause UR responses. This applies no
                                                                  matter the value of PEM()_EBUS_CTL[PF_BAR4_SEL].
                                                                  1 = BAR4 is enabled and will respond if the corresponding
                                                                  bits in PEM()_BAR4_INDEX() are set and the address matches
                                                                  an enabled indexed address range.

                                                                 In EP mode:

                                                                  * If PEM()_EBUS_CTL[PF_BAR4_SEL] is set, BAR4 hits are based on
                                                                  a combination of this bit and config registers PCIEEP_BAR4U / PCIEEP_BAR4L.
                                                                  Both enable bits must be set to enable a BAR4 hit.
                                                                  * If PEM()_EBUS_CTL[PF_BAR4_SEL] is clear, BAR4 hits are based
                                                                  on a combination of this bit, the config registers PCIEEP_BAR4U /
                                                                  PCIEEP_BAR4L, and the PEM()_BAR4_INDEX() registers.
                                                                  Both enable bits must be set along with the appropriate bits in
                                                                  PEM()_BAR4_INDEX() in order for a BAR4 access to respond. */
        uint64_t bar0_siz              : 5;  /**< [ 30: 26](R/W) PCIe BAR0 size.
                                                                 0x0 = Reserved.
                                                                 0x1 = 64 KB; 2^16.
                                                                 0x2 = 128 KB; 2^17.
                                                                 0x3 = 256 KB; 2^18.
                                                                 0x4 = 512 KB; 2^19.
                                                                 0x5 = 1 MB; 2^20.
                                                                 0x6 = 2 MB; 2^21.
                                                                 0x7 = 4 MB; 2^22.
                                                                 0x8 = 8 MB; 2^23.
                                                                 0x9 = 16 MB; 2^24.
                                                                 0xA = 32 MB; 2^25.
                                                                 0xB = 64 MB; 2^26.
                                                                 0xC - 0x1F = Reserved. */
        uint64_t bar0_enb              : 1;  /**< [ 25: 25](R/W) In RC mode:
                                                                  0 = BAR0 access will cause UR responses. This applies no
                                                                  matter the value of PEM()_EBUS_CTL[PF_BAR0_SEL].
                                                                  1 = BAR0 is enabled and will respond.

                                                                 In EP mode:

                                                                  * BAR0 hits are based on a combination of this bit and
                                                                  config registers PCIEEP_BAR0U / PCIEEP_BAR0L. Both enable
                                                                  bits must be set to enable a BAR0 hit. */
        uint64_t bar2_ebit             : 6;  /**< [ 24: 19](R/W) Address bits for ESX\<1:0\> in a PCIe BAR2 address.

                                                                 When [BAR2_EBIT] is zero, a PCIe BAR2 address does not contain an ESX\<1:0\> field,
                                                                 and [BAR2_ESX] is the endian-swap used for all BAR2 requests.

                                                                 When [BAR2_EBIT] is non-zero, it places ESX\<1:0\> (ESX\<0\> is at PCIe BAR2 address bit
                                                                 [BAR2_EBIT], and ESX\<1\> is at PCIe BAR2 address bit [BAR2_EBIT]+1). [BAR2_EBIT] must
                                                                 be in the range 16 .. [BAR2_SIZ]+18 and must not conflict with a non-zero
                                                                 [BAR2_CBIT] in this case. [BAR2_ESX] XOR ESX\<1:0\> is the endian-swap
                                                                 used for BAR2 requests in this case. If [BAR2_EBIT] \<= 48 in this case, then
                                                                 one or two PCIe BAR2 address ESX field bit(s) are in the address forwarded to
                                                                 SLI and the SMMU, in the same position. */
        uint64_t bar2_cbit             : 6;  /**< [ 18: 13](R/W) Address bit for CAX in a PCIe BAR2 address.

                                                                 When [BAR2_CBIT] is zero, a PCIe BAR2 address does not contain a CAX bit,
                                                                 and [BAR2_CAX] is the cache allocation for all BAR2 requests.

                                                                 When [BAR2_CBIT] is non-zero, the CAX bit is at bit [BAR2_CBIT] in the PCIe
                                                                 BAR2 address. [BAR2_CBIT] must be in the range 16 .. [BAR2_SIZ]+19 and must
                                                                 not conflict with a non-zero [BAR2_EBIT] in this case. [BAR2_CBIT] XOR CAX is
                                                                 the cache allocation for BAR2 requests. If [BAR2_CBIT] \<= 48 in this
                                                                 case, then the PCIe BAR2 address CAX bit is in the address forwarded to
                                                                 SLI and the SMMU, in the same position. */
        uint64_t bar2_siz              : 6;  /**< [ 12:  7](R/W) BAR2 size. Encoded identically to PCIEEP()_CFG190[RBARS]. Resets to 0x1D (512 TB).

                                                                 In EP mode, [BAR2_SIZ] must equal the corresponding PCIEEP()_CFG190[RBARS].

                                                                 In RC mode, [BAR2_SIZ] determines the PEM()_P2N_BAR2_START[ADDR] bits used/compared
                                                                 to an incoming PCIe address.

                                                                 On a BAR2 match, PEM zeroes the PCIe address bits outside [BAR2_SIZ], applies
                                                                 [BAR2_EBIT,BAR2_CBIT], and forwards the request to SLI and the SMMU. */
        uint64_t reserved_4_6          : 3;
        uint64_t bar2_enb              : 1;  /**< [  3:  3](R/W) When set to 1, BAR2 is enabled and will respond; when clear, BAR2 access will cause UR responses. */
        uint64_t bar2_esx              : 2;  /**< [  2:  1](R/W) Value is XORed with PCIe addresses as defined by [BAR2_EBIT] to determine the
                                                                 endian swap mode. */
        uint64_t bar2_cax              : 1;  /**< [  0:  0](R/W) Value is XORed with PCIe address \<49\> to determine the L2 cache attribute. Not cached in
                                                                 L2 if XOR result is 1. */
#else /* Word 0 - Little Endian */
        uint64_t bar2_cax              : 1;  /**< [  0:  0](R/W) Value is XORed with PCIe address \<49\> to determine the L2 cache attribute. Not cached in
                                                                 L2 if XOR result is 1. */
        uint64_t bar2_esx              : 2;  /**< [  2:  1](R/W) Value is XORed with PCIe addresses as defined by [BAR2_EBIT] to determine the
                                                                 endian swap mode. */
        uint64_t bar2_enb              : 1;  /**< [  3:  3](R/W) When set to 1, BAR2 is enabled and will respond; when clear, BAR2 access will cause UR responses. */
        uint64_t reserved_4_6          : 3;
        uint64_t bar2_siz              : 6;  /**< [ 12:  7](R/W) BAR2 size. Encoded identically to PCIEEP()_CFG190[RBARS]. Resets to 0x1D (512 TB).

                                                                 In EP mode, [BAR2_SIZ] must equal the corresponding PCIEEP()_CFG190[RBARS].

                                                                 In RC mode, [BAR2_SIZ] determines the PEM()_P2N_BAR2_START[ADDR] bits used/compared
                                                                 to an incoming PCIe address.

                                                                 On a BAR2 match, PEM zeroes the PCIe address bits outside [BAR2_SIZ], applies
                                                                 [BAR2_EBIT,BAR2_CBIT], and forwards the request to SLI and the SMMU. */
        uint64_t bar2_cbit             : 6;  /**< [ 18: 13](R/W) Address bit for CAX in a PCIe BAR2 address.

                                                                 When [BAR2_CBIT] is zero, a PCIe BAR2 address does not contain a CAX bit,
                                                                 and [BAR2_CAX] is the cache allocation for all BAR2 requests.

                                                                 When [BAR2_CBIT] is non-zero, the CAX bit is at bit [BAR2_CBIT] in the PCIe
                                                                 BAR2 address. [BAR2_CBIT] must be in the range 16 .. [BAR2_SIZ]+19 and must
                                                                 not conflict with a non-zero [BAR2_EBIT] in this case. [BAR2_CBIT] XOR CAX is
                                                                 the cache allocation for BAR2 requests. If [BAR2_CBIT] \<= 48 in this
                                                                 case, then the PCIe BAR2 address CAX bit is in the address forwarded to
                                                                 SLI and the SMMU, in the same position. */
        uint64_t bar2_ebit             : 6;  /**< [ 24: 19](R/W) Address bits for ESX\<1:0\> in a PCIe BAR2 address.

                                                                 When [BAR2_EBIT] is zero, a PCIe BAR2 address does not contain an ESX\<1:0\> field,
                                                                 and [BAR2_ESX] is the endian-swap used for all BAR2 requests.

                                                                 When [BAR2_EBIT] is non-zero, it places ESX\<1:0\> (ESX\<0\> is at PCIe BAR2 address bit
                                                                 [BAR2_EBIT], and ESX\<1\> is at PCIe BAR2 address bit [BAR2_EBIT]+1). [BAR2_EBIT] must
                                                                 be in the range 16 .. [BAR2_SIZ]+18 and must not conflict with a non-zero
                                                                 [BAR2_CBIT] in this case. [BAR2_ESX] XOR ESX\<1:0\> is the endian-swap
                                                                 used for BAR2 requests in this case. If [BAR2_EBIT] \<= 48 in this case, then
                                                                 one or two PCIe BAR2 address ESX field bit(s) are in the address forwarded to
                                                                 SLI and the SMMU, in the same position. */
        uint64_t bar0_enb              : 1;  /**< [ 25: 25](R/W) In RC mode:
                                                                  0 = BAR0 access will cause UR responses. This applies no
                                                                  matter the value of PEM()_EBUS_CTL[PF_BAR0_SEL].
                                                                  1 = BAR0 is enabled and will respond.

                                                                 In EP mode:

                                                                  * BAR0 hits are based on a combination of this bit and
                                                                  config registers PCIEEP_BAR0U / PCIEEP_BAR0L. Both enable
                                                                  bits must be set to enable a BAR0 hit. */
        uint64_t bar0_siz              : 5;  /**< [ 30: 26](R/W) PCIe BAR0 size.
                                                                 0x0 = Reserved.
                                                                 0x1 = 64 KB; 2^16.
                                                                 0x2 = 128 KB; 2^17.
                                                                 0x3 = 256 KB; 2^18.
                                                                 0x4 = 512 KB; 2^19.
                                                                 0x5 = 1 MB; 2^20.
                                                                 0x6 = 2 MB; 2^21.
                                                                 0x7 = 4 MB; 2^22.
                                                                 0x8 = 8 MB; 2^23.
                                                                 0x9 = 16 MB; 2^24.
                                                                 0xA = 32 MB; 2^25.
                                                                 0xB = 64 MB; 2^26.
                                                                 0xC - 0x1F = Reserved. */
        uint64_t bar4_enb              : 1;  /**< [ 31: 31](R/W) In RC mode:
                                                                  0 = BAR4 access will cause UR responses. This applies no
                                                                  matter the value of PEM()_EBUS_CTL[PF_BAR4_SEL].
                                                                  1 = BAR4 is enabled and will respond if the corresponding
                                                                  bits in PEM()_BAR4_INDEX() are set and the address matches
                                                                  an enabled indexed address range.

                                                                 In EP mode:

                                                                  * If PEM()_EBUS_CTL[PF_BAR4_SEL] is set, BAR4 hits are based on
                                                                  a combination of this bit and config registers PCIEEP_BAR4U / PCIEEP_BAR4L.
                                                                  Both enable bits must be set to enable a BAR4 hit.
                                                                  * If PEM()_EBUS_CTL[PF_BAR4_SEL] is clear, BAR4 hits are based
                                                                  on a combination of this bit, the config registers PCIEEP_BAR4U /
                                                                  PCIEEP_BAR4L, and the PEM()_BAR4_INDEX() registers.
                                                                  Both enable bits must be set along with the appropriate bits in
                                                                  PEM()_BAR4_INDEX() in order for a BAR4 access to respond. */
        uint64_t erom_siz              : 3;  /**< [ 34: 32](R/W) PCIe EROM BAR size. Used to mask off upper bits of address
                                                                 when sending to NCBI or via private EROM interface to MIO.

                                                                 0x0 = Reserved.
                                                                 0x1 = 64 KB; 2^16.
                                                                 0x2 = 128 KB; 2^17.
                                                                 0x3 = 256 KB; 2^18.
                                                                 0x4 = 512 KB; 2^19.
                                                                 0x5 = 1 MB; 2^20.
                                                                 0x6 = 2 MB; 2^21.
                                                                 0x7 = 4 MB; 2^22. */
        uint64_t vf_bar0_enb           : 1;  /**< [ 35: 35](R/W) This bit controls whether BAR0 for all virtual functions is enabled.

                                                                 In RC mode:
                                                                 * VF BAR0 does not exist. This bit has no effect.

                                                                 In EP mode:

                                                                  * VF BAR0 hits are based on a combination of this bit and
                                                                  config registers PCIEEP_SRIOV_BAR0U, PCIEEP_SRIOV_BAR0L, and
                                                                  PCIEEP_SRIOV_CTL[VFE].  Both PCIEEP_SRIOV_CTL[VFE] and this
                                                                  bit must be set to enable a VF BAR0 hit to the PCI address
                                                                  specified by PCIEEP_SRIOV_BAR0U / PCIEEP_SRIOV_BAR0L. */
        uint64_t vf_bar2_enb           : 1;  /**< [ 36: 36](R/W) This bit controls whether BAR2 for all virtual functions is enabled.

                                                                 In RC mode:
                                                                 * VF BAR2 does not exist. This bit has no effect.

                                                                 In EP mode:

                                                                  * VF BAR2 hits are based on a combination of this bit and
                                                                  config registers PCIEEP_SRIOV_BAR2U, PCIEEP_SRIOV_BAR2L, and
                                                                  PCIEEP_SRIOV_CTL[VFE].  Both PCIEEP_SRIOV_CTL[VFE] and this
                                                                  bit must be set to enable a VF BAR2 hit to the PCI address
                                                                  specified by PCIEEP_SRIOV_BAR2U / PCIEEP_SRIOV_BAR2L. */
        uint64_t vf_bar4_enb           : 1;  /**< [ 37: 37](R/W) This bit controls whether BAR4 for all virtual functions is enabled.

                                                                 In RC mode:
                                                                 * VF BAR4 does not exist. This bit has no effect.

                                                                 In EP mode:

                                                                  * VF BAR4 hits are based on a combination of this bit and
                                                                  config registers PCIEEP_SRIOV_BAR4U, PCIEEP_SRIOV_BAR4L, and
                                                                  PCIEEP_SRIOV_CTL[VFE].  Both PCIEEP_SRIOV_CTL[VFE] and this
                                                                  bit must be set to enable a VF BAR4 hit to the PCI address
                                                                  specified by PCIEEP_SRIOV_BAR4U / PCIEEP_SRIOV_BAR4L. */
        uint64_t reserved_38_63        : 26;
#endif /* Word 0 - End */
    } s;
    struct bdk_pemx_bar_ctl_cn9
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_38_63        : 26;
        uint64_t vf_bar4_enb           : 1;  /**< [ 37: 37](R/W) This bit controls whether BAR4 for all virtual functions is enabled.

                                                                 In RC mode:
                                                                 * VF BAR4 does not exist. This bit has no effect.

                                                                 In EP mode:

                                                                  * VF BAR4 hits are based on a combination of this bit and
                                                                  config registers PCIEEP_SRIOV_BAR4U, PCIEEP_SRIOV_BAR4L, and
                                                                  PCIEEP_SRIOV_CTL[VFE].  Both PCIEEP_SRIOV_CTL[VFE] and this
                                                                  bit must be set to enable a VF BAR4 hit to the PCI address
                                                                  specified by PCIEEP_SRIOV_BAR4U / PCIEEP_SRIOV_BAR4L. */
        uint64_t vf_bar2_enb           : 1;  /**< [ 36: 36](R/W) This bit controls whether BAR2 for all virtual functions is enabled.

                                                                 In RC mode:
                                                                 * VF BAR2 does not exist. This bit has no effect.

                                                                 In EP mode:

                                                                  * VF BAR2 hits are based on a combination of this bit and
                                                                  config registers PCIEEP_SRIOV_BAR2U, PCIEEP_SRIOV_BAR2L, and
                                                                  PCIEEP_SRIOV_CTL[VFE].  Both PCIEEP_SRIOV_CTL[VFE] and this
                                                                  bit must be set to enable a VF BAR2 hit to the PCI address
                                                                  specified by PCIEEP_SRIOV_BAR2U / PCIEEP_SRIOV_BAR2L. */
        uint64_t vf_bar0_enb           : 1;  /**< [ 35: 35](R/W) This bit controls whether BAR0 for all virtual functions is enabled.

                                                                 In RC mode:
                                                                 * VF BAR0 does not exist. This bit has no effect.

                                                                 In EP mode:

                                                                  * VF BAR0 hits are based on a combination of this bit and
                                                                  config registers PCIEEP_SRIOV_BAR0U, PCIEEP_SRIOV_BAR0L, and
                                                                  PCIEEP_SRIOV_CTL[VFE].  Both PCIEEP_SRIOV_CTL[VFE] and this
                                                                  bit must be set to enable a VF BAR0 hit to the PCI address
                                                                  specified by PCIEEP_SRIOV_BAR0U / PCIEEP_SRIOV_BAR0L. */
        uint64_t erom_siz              : 3;  /**< [ 34: 32](R/W) PCIe EROM BAR size. Used to mask off upper bits of address
                                                                 when sending to NCBI or via private EROM interface to MIO.

                                                                 0x0 = Reserved.
                                                                 0x1 = 64 KB; 2^16.
                                                                 0x2 = 128 KB; 2^17.
                                                                 0x3 = 256 KB; 2^18.
                                                                 0x4 = 512 KB; 2^19.
                                                                 0x5 = 1 MB; 2^20.
                                                                 0x6 = 2 MB; 2^21.
                                                                 0x7 = 4 MB; 2^22. */
        uint64_t bar4_enb              : 1;  /**< [ 31: 31](R/W) In RC mode:
                                                                  0 = BAR4 access will cause UR responses. This applies no
                                                                  matter the value of PEM()_EBUS_CTL[PF_BAR4_SEL].
                                                                  1 = BAR4 is enabled and will respond if the corresponding
                                                                  bits in PEM()_BAR4_INDEX() are set and the address matches
                                                                  an enabled indexed address range.

                                                                 In EP mode:

                                                                  * If PEM()_EBUS_CTL[PF_BAR4_SEL] is set, BAR4 hits are based on
                                                                  a combination of this bit and config registers PCIEEP_BAR4U / PCIEEP_BAR4L.
                                                                  Both enable bits must be set to enable a BAR4 hit.
                                                                  * If PEM()_EBUS_CTL[PF_BAR4_SEL] is clear, BAR4 hits are based
                                                                  on a combination of this bit, the config registers PCIEEP_BAR4U /
                                                                  PCIEEP_BAR4L, and the PEM()_BAR4_INDEX() registers.
                                                                  Both enable bits must be set along with the appropriate bits in
                                                                  PEM()_BAR4_INDEX() in order for a BAR4 access to respond. */
        uint64_t bar0_siz              : 5;  /**< [ 30: 26](R/W) PCIe BAR0 size.
                                                                 0x0 = Reserved.
                                                                 0x1 = 64 KB; 2^16.
                                                                 0x2 = 128 KB; 2^17.
                                                                 0x3 = 256 KB; 2^18.
                                                                 0x4 = 512 KB; 2^19.
                                                                 0x5 = 1 MB; 2^20.
                                                                 0x6 = 2 MB; 2^21.
                                                                 0x7 = 4 MB; 2^22.
                                                                 0x8 = 8 MB; 2^23.
                                                                 0x9 = 16 MB; 2^24.
                                                                 0xA = 32 MB; 2^25.
                                                                 0xB = 64 MB; 2^26.
                                                                 0xC - 0x1F = Reserved. */
        uint64_t bar0_enb              : 1;  /**< [ 25: 25](R/W) In RC mode:
                                                                  0 = BAR0 access will cause UR responses. This applies no
                                                                  matter the value of PEM()_EBUS_CTL[PF_BAR0_SEL].
                                                                  1 = BAR0 is enabled and will respond.

                                                                 In EP mode:

                                                                  * BAR0 hits are based on a combination of this bit and
                                                                  config registers PCIEEP_BAR0U / PCIEEP_BAR0L. Both enable
                                                                  bits must be set to enable a BAR0 hit. */
        uint64_t reserved_19_24        : 6;
        uint64_t bar2_cbit             : 6;  /**< [ 18: 13](R/W) Address bit to be mapped to BAR2's CAX. When 0x0, BAR2's CAX is disabled;
                                                                 otherwise must be 16 to 63 inclusive. Not used if PEM()_EBUS_CTL[PF_BAR2_SEL]
                                                                 is set. */
        uint64_t bar2_siz              : 6;  /**< [ 12:  7](R/W) BAR2 size. Encoded similar to PCIEEP_RBAR_CTL[RBARS]. Used in RC mode to create
                                                                 a mask that is ANDED with the address prior to applying
                                                                 [BAR2_CAX]. Defaults to 0x21 (8192 TB). */
        uint64_t bar4_siz              : 3;  /**< [  6:  4](R/W) PCIe Port 0 BAR4 size.
                                                                 0x0 = Reserved.
                                                                 0x1 = 64 MB; 2^26.
                                                                 0x2 = 128 MB; 2^27.
                                                                 0x3 = 256 MB; 2^28.
                                                                 0x4 = 512 MB; 2^29.
                                                                 0x5 = 1024 MB; 2^30.
                                                                 0x6 = 2048 MB; 2^31.
                                                                 0x7 = Reserved. */
        uint64_t bar2_enb              : 1;  /**< [  3:  3](R/W) In RC mode:
                                                                  0 = BAR2 access will cause UR responses. This applies no
                                                                  matter the value of PEM()_EBUS_CTL[PF_BAR2_SEL].
                                                                  1 = BAR2 is enabled and will respond.

                                                                 In EP mode:

                                                                  * BAR2 hits are based on a combination of this bit and
                                                                  config registers PCIEEP_BAR2U / PCIEEP_BAR2L. Both enable
                                                                  bits must be set to enable a BAR2 hit. */
        uint64_t reserved_1_2          : 2;
        uint64_t bar2_cax              : 1;  /**< [  0:  0](R/W) Value is XORed with PCIe address as defined by [BAR2_CBIT] to determine the LLC
                                                                 cache attribute. Not cached in LLC if XOR result is 1. Not used if PEM()_EBUS_CTL[PF_BAR2_SEL]
                                                                 is set. */
#else /* Word 0 - Little Endian */
        uint64_t bar2_cax              : 1;  /**< [  0:  0](R/W) Value is XORed with PCIe address as defined by [BAR2_CBIT] to determine the LLC
                                                                 cache attribute. Not cached in LLC if XOR result is 1. Not used if PEM()_EBUS_CTL[PF_BAR2_SEL]
                                                                 is set. */
        uint64_t reserved_1_2          : 2;
        uint64_t bar2_enb              : 1;  /**< [  3:  3](R/W) In RC mode:
                                                                  0 = BAR2 access will cause UR responses. This applies no
                                                                  matter the value of PEM()_EBUS_CTL[PF_BAR2_SEL].
                                                                  1 = BAR2 is enabled and will respond.

                                                                 In EP mode:

                                                                  * BAR2 hits are based on a combination of this bit and
                                                                  config registers PCIEEP_BAR2U / PCIEEP_BAR2L. Both enable
                                                                  bits must be set to enable a BAR2 hit. */
        uint64_t bar4_siz              : 3;  /**< [  6:  4](R/W) PCIe Port 0 BAR4 size.
                                                                 0x0 = Reserved.
                                                                 0x1 = 64 MB; 2^26.
                                                                 0x2 = 128 MB; 2^27.
                                                                 0x3 = 256 MB; 2^28.
                                                                 0x4 = 512 MB; 2^29.
                                                                 0x5 = 1024 MB; 2^30.
                                                                 0x6 = 2048 MB; 2^31.
                                                                 0x7 = Reserved. */
        uint64_t bar2_siz              : 6;  /**< [ 12:  7](R/W) BAR2 size. Encoded similar to PCIEEP_RBAR_CTL[RBARS]. Used in RC mode to create
                                                                 a mask that is ANDED with the address prior to applying
                                                                 [BAR2_CAX]. Defaults to 0x21 (8192 TB). */
        uint64_t bar2_cbit             : 6;  /**< [ 18: 13](R/W) Address bit to be mapped to BAR2's CAX. When 0x0, BAR2's CAX is disabled;
                                                                 otherwise must be 16 to 63 inclusive. Not used if PEM()_EBUS_CTL[PF_BAR2_SEL]
                                                                 is set. */
        uint64_t reserved_19_24        : 6;
        uint64_t bar0_enb              : 1;  /**< [ 25: 25](R/W) In RC mode:
                                                                  0 = BAR0 access will cause UR responses. This applies no
                                                                  matter the value of PEM()_EBUS_CTL[PF_BAR0_SEL].
                                                                  1 = BAR0 is enabled and will respond.

                                                                 In EP mode:

                                                                  * BAR0 hits are based on a combination of this bit and
                                                                  config registers PCIEEP_BAR0U / PCIEEP_BAR0L. Both enable
                                                                  bits must be set to enable a BAR0 hit. */
        uint64_t bar0_siz              : 5;  /**< [ 30: 26](R/W) PCIe BAR0 size.
                                                                 0x0 = Reserved.
                                                                 0x1 = 64 KB; 2^16.
                                                                 0x2 = 128 KB; 2^17.
                                                                 0x3 = 256 KB; 2^18.
                                                                 0x4 = 512 KB; 2^19.
                                                                 0x5 = 1 MB; 2^20.
                                                                 0x6 = 2 MB; 2^21.
                                                                 0x7 = 4 MB; 2^22.
                                                                 0x8 = 8 MB; 2^23.
                                                                 0x9 = 16 MB; 2^24.
                                                                 0xA = 32 MB; 2^25.
                                                                 0xB = 64 MB; 2^26.
                                                                 0xC - 0x1F = Reserved. */
        uint64_t bar4_enb              : 1;  /**< [ 31: 31](R/W) In RC mode:
                                                                  0 = BAR4 access will cause UR responses. This applies no
                                                                  matter the value of PEM()_EBUS_CTL[PF_BAR4_SEL].
                                                                  1 = BAR4 is enabled and will respond if the corresponding
                                                                  bits in PEM()_BAR4_INDEX() are set and the address matches
                                                                  an enabled indexed address range.

                                                                 In EP mode:

                                                                  * If PEM()_EBUS_CTL[PF_BAR4_SEL] is set, BAR4 hits are based on
                                                                  a combination of this bit and config registers PCIEEP_BAR4U / PCIEEP_BAR4L.
                                                                  Both enable bits must be set to enable a BAR4 hit.
                                                                  * If PEM()_EBUS_CTL[PF_BAR4_SEL] is clear, BAR4 hits are based
                                                                  on a combination of this bit, the config registers PCIEEP_BAR4U /
                                                                  PCIEEP_BAR4L, and the PEM()_BAR4_INDEX() registers.
                                                                  Both enable bits must be set along with the appropriate bits in
                                                                  PEM()_BAR4_INDEX() in order for a BAR4 access to respond. */
        uint64_t erom_siz              : 3;  /**< [ 34: 32](R/W) PCIe EROM BAR size. Used to mask off upper bits of address
                                                                 when sending to NCBI or via private EROM interface to MIO.

                                                                 0x0 = Reserved.
                                                                 0x1 = 64 KB; 2^16.
                                                                 0x2 = 128 KB; 2^17.
                                                                 0x3 = 256 KB; 2^18.
                                                                 0x4 = 512 KB; 2^19.
                                                                 0x5 = 1 MB; 2^20.
                                                                 0x6 = 2 MB; 2^21.
                                                                 0x7 = 4 MB; 2^22. */
        uint64_t vf_bar0_enb           : 1;  /**< [ 35: 35](R/W) This bit controls whether BAR0 for all virtual functions is enabled.

                                                                 In RC mode:
                                                                 * VF BAR0 does not exist. This bit has no effect.

                                                                 In EP mode:

                                                                  * VF BAR0 hits are based on a combination of this bit and
                                                                  config registers PCIEEP_SRIOV_BAR0U, PCIEEP_SRIOV_BAR0L, and
                                                                  PCIEEP_SRIOV_CTL[VFE].  Both PCIEEP_SRIOV_CTL[VFE] and this
                                                                  bit must be set to enable a VF BAR0 hit to the PCI address
                                                                  specified by PCIEEP_SRIOV_BAR0U / PCIEEP_SRIOV_BAR0L. */
        uint64_t vf_bar2_enb           : 1;  /**< [ 36: 36](R/W) This bit controls whether BAR2 for all virtual functions is enabled.

                                                                 In RC mode:
                                                                 * VF BAR2 does not exist. This bit has no effect.

                                                                 In EP mode:

                                                                  * VF BAR2 hits are based on a combination of this bit and
                                                                  config registers PCIEEP_SRIOV_BAR2U, PCIEEP_SRIOV_BAR2L, and
                                                                  PCIEEP_SRIOV_CTL[VFE].  Both PCIEEP_SRIOV_CTL[VFE] and this
                                                                  bit must be set to enable a VF BAR2 hit to the PCI address
                                                                  specified by PCIEEP_SRIOV_BAR2U / PCIEEP_SRIOV_BAR2L. */
        uint64_t vf_bar4_enb           : 1;  /**< [ 37: 37](R/W) This bit controls whether BAR4 for all virtual functions is enabled.

                                                                 In RC mode:
                                                                 * VF BAR4 does not exist. This bit has no effect.

                                                                 In EP mode:

                                                                  * VF BAR4 hits are based on a combination of this bit and
                                                                  config registers PCIEEP_SRIOV_BAR4U, PCIEEP_SRIOV_BAR4L, and
                                                                  PCIEEP_SRIOV_CTL[VFE].  Both PCIEEP_SRIOV_CTL[VFE] and this
                                                                  bit must be set to enable a VF BAR4 hit to the PCI address
                                                                  specified by PCIEEP_SRIOV_BAR4U / PCIEEP_SRIOV_BAR4L. */
        uint64_t reserved_38_63        : 26;
#endif /* Word 0 - End */
    } cn9;
    struct bdk_pemx_bar_ctl_cn81xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_7_63         : 57;
        uint64_t bar1_siz              : 3;  /**< [  6:  4](R/W) PCIe Port 0 BAR1 size.
                                                                 0x0 = Reserved.
                                                                 0x1 = 64 MB; 2^26.
                                                                 0x2 = 128 MB; 2^27.
                                                                 0x3 = 256 MB; 2^28.
                                                                 0x4 = 512 MB; 2^29.
                                                                 0x5 = 1024 MB; 2^30.
                                                                 0x6 = 2048 MB; 2^31.
                                                                 0x7 = Reserved. */
        uint64_t bar2_enb              : 1;  /**< [  3:  3](R/W) When set to 1, BAR2 is enabled and will respond; when clear, BAR2 access will cause UR responses. */
        uint64_t reserved_1_2          : 2;
        uint64_t bar2_cax              : 1;  /**< [  0:  0](R/W) Value is XORed with PCIe address \<49\> to determine the L2 cache attribute. Not cached in
                                                                 L2 if XOR result is 1. */
#else /* Word 0 - Little Endian */
        uint64_t bar2_cax              : 1;  /**< [  0:  0](R/W) Value is XORed with PCIe address \<49\> to determine the L2 cache attribute. Not cached in
                                                                 L2 if XOR result is 1. */
        uint64_t reserved_1_2          : 2;
        uint64_t bar2_enb              : 1;  /**< [  3:  3](R/W) When set to 1, BAR2 is enabled and will respond; when clear, BAR2 access will cause UR responses. */
        uint64_t bar1_siz              : 3;  /**< [  6:  4](R/W) PCIe Port 0 BAR1 size.
                                                                 0x0 = Reserved.
                                                                 0x1 = 64 MB; 2^26.
                                                                 0x2 = 128 MB; 2^27.
                                                                 0x3 = 256 MB; 2^28.
                                                                 0x4 = 512 MB; 2^29.
                                                                 0x5 = 1024 MB; 2^30.
                                                                 0x6 = 2048 MB; 2^31.
                                                                 0x7 = Reserved. */
        uint64_t reserved_7_63         : 57;
#endif /* Word 0 - End */
    } cn81xx;
    /* struct bdk_pemx_bar_ctl_cn81xx cn88xx; */
    struct bdk_pemx_bar_ctl_cn83xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_25_63        : 39;
        uint64_t bar2_ebit             : 6;  /**< [ 24: 19](R/W) Address bits for ESX\<1:0\> in a PCIe BAR2 address.

                                                                 When [BAR2_EBIT] is zero, a PCIe BAR2 address does not contain an ESX\<1:0\> field,
                                                                 and [BAR2_ESX] is the endian-swap used for all BAR2 requests.

                                                                 When [BAR2_EBIT] is non-zero, it places ESX\<1:0\> (ESX\<0\> is at PCIe BAR2 address bit
                                                                 [BAR2_EBIT], and ESX\<1\> is at PCIe BAR2 address bit [BAR2_EBIT]+1). [BAR2_EBIT] must
                                                                 be in the range 16 .. [BAR2_SIZ]+18 and must not conflict with a non-zero
                                                                 [BAR2_CBIT] in this case. [BAR2_ESX] XOR ESX\<1:0\> is the endian-swap
                                                                 used for BAR2 requests in this case. If [BAR2_EBIT] \<= 48 in this case, then
                                                                 one or two PCIe BAR2 address ESX field bit(s) are in the address forwarded to
                                                                 SLI and the SMMU, in the same position. */
        uint64_t bar2_cbit             : 6;  /**< [ 18: 13](R/W) Address bit for CAX in a PCIe BAR2 address.

                                                                 When [BAR2_CBIT] is zero, a PCIe BAR2 address does not contain a CAX bit,
                                                                 and [BAR2_CAX] is the cache allocation for all BAR2 requests.

                                                                 When [BAR2_CBIT] is non-zero, the CAX bit is at bit [BAR2_CBIT] in the PCIe
                                                                 BAR2 address. [BAR2_CBIT] must be in the range 16 .. [BAR2_SIZ]+19 and must
                                                                 not conflict with a non-zero [BAR2_EBIT] in this case. [BAR2_CBIT] XOR CAX is
                                                                 the cache allocation for BAR2 requests. If [BAR2_CBIT] \<= 48 in this
                                                                 case, then the PCIe BAR2 address CAX bit is in the address forwarded to
                                                                 SLI and the SMMU, in the same position. */
        uint64_t bar2_siz              : 6;  /**< [ 12:  7](R/W) BAR2 size. Encoded identically to PCIEEP()_CFG190[RBARS]. Resets to 0x1D (512 TB).

                                                                 In EP mode, [BAR2_SIZ] must equal the corresponding PCIEEP()_CFG190[RBARS].

                                                                 In RC mode, [BAR2_SIZ] determines the PEM()_P2N_BAR2_START[ADDR] bits used/compared
                                                                 to an incoming PCIe address.

                                                                 On a BAR2 match, PEM zeroes the PCIe address bits outside [BAR2_SIZ], applies
                                                                 [BAR2_EBIT,BAR2_CBIT], and forwards the request to SLI and the SMMU. */
        uint64_t bar1_siz              : 3;  /**< [  6:  4](R/W) PCIe Port 0 BAR1 size.
                                                                 0x0 = Reserved.
                                                                 0x1 = 64 MB; 2^26.
                                                                 0x2 = 128 MB; 2^27.
                                                                 0x3 = 256 MB; 2^28.
                                                                 0x4 = 512 MB; 2^29.
                                                                 0x5 = 1024 MB; 2^30.
                                                                 0x6 = 2048 MB; 2^31.
                                                                 0x7 = Reserved. */
        uint64_t bar2_enb              : 1;  /**< [  3:  3](R/W) When set to 1, BAR2 is enabled and will respond; when clear, BAR2 access will cause UR responses. */
        uint64_t bar2_esx              : 2;  /**< [  2:  1](R/W) Value is XORed with PCIe addresses as defined by [BAR2_EBIT] to determine the
                                                                 endian swap mode. */
        uint64_t bar2_cax              : 1;  /**< [  0:  0](R/W) Value is XORed with PCIe address as defined by [BAR2_CBIT] to determine the L2
                                                                 cache attribute. Not cached in L2 if XOR result is 1. */
#else /* Word 0 - Little Endian */
        uint64_t bar2_cax              : 1;  /**< [  0:  0](R/W) Value is XORed with PCIe address as defined by [BAR2_CBIT] to determine the L2
                                                                 cache attribute. Not cached in L2 if XOR result is 1. */
        uint64_t bar2_esx              : 2;  /**< [  2:  1](R/W) Value is XORed with PCIe addresses as defined by [BAR2_EBIT] to determine the
                                                                 endian swap mode. */
        uint64_t bar2_enb              : 1;  /**< [  3:  3](R/W) When set to 1, BAR2 is enabled and will respond; when clear, BAR2 access will cause UR responses. */
        uint64_t bar1_siz              : 3;  /**< [  6:  4](R/W) PCIe Port 0 BAR1 size.
                                                                 0x0 = Reserved.
                                                                 0x1 = 64 MB; 2^26.
                                                                 0x2 = 128 MB; 2^27.
                                                                 0x3 = 256 MB; 2^28.
                                                                 0x4 = 512 MB; 2^29.
                                                                 0x5 = 1024 MB; 2^30.
                                                                 0x6 = 2048 MB; 2^31.
                                                                 0x7 = Reserved. */
        uint64_t bar2_siz              : 6;  /**< [ 12:  7](R/W) BAR2 size. Encoded identically to PCIEEP()_CFG190[RBARS]. Resets to 0x1D (512 TB).

                                                                 In EP mode, [BAR2_SIZ] must equal the corresponding PCIEEP()_CFG190[RBARS].

                                                                 In RC mode, [BAR2_SIZ] determines the PEM()_P2N_BAR2_START[ADDR] bits used/compared
                                                                 to an incoming PCIe address.

                                                                 On a BAR2 match, PEM zeroes the PCIe address bits outside [BAR2_SIZ], applies
                                                                 [BAR2_EBIT,BAR2_CBIT], and forwards the request to SLI and the SMMU. */
        uint64_t bar2_cbit             : 6;  /**< [ 18: 13](R/W) Address bit for CAX in a PCIe BAR2 address.

                                                                 When [BAR2_CBIT] is zero, a PCIe BAR2 address does not contain a CAX bit,
                                                                 and [BAR2_CAX] is the cache allocation for all BAR2 requests.

                                                                 When [BAR2_CBIT] is non-zero, the CAX bit is at bit [BAR2_CBIT] in the PCIe
                                                                 BAR2 address. [BAR2_CBIT] must be in the range 16 .. [BAR2_SIZ]+19 and must
                                                                 not conflict with a non-zero [BAR2_EBIT] in this case. [BAR2_CBIT] XOR CAX is
                                                                 the cache allocation for BAR2 requests. If [BAR2_CBIT] \<= 48 in this
                                                                 case, then the PCIe BAR2 address CAX bit is in the address forwarded to
                                                                 SLI and the SMMU, in the same position. */
        uint64_t bar2_ebit             : 6;  /**< [ 24: 19](R/W) Address bits for ESX\<1:0\> in a PCIe BAR2 address.

                                                                 When [BAR2_EBIT] is zero, a PCIe BAR2 address does not contain an ESX\<1:0\> field,
                                                                 and [BAR2_ESX] is the endian-swap used for all BAR2 requests.

                                                                 When [BAR2_EBIT] is non-zero, it places ESX\<1:0\> (ESX\<0\> is at PCIe BAR2 address bit
                                                                 [BAR2_EBIT], and ESX\<1\> is at PCIe BAR2 address bit [BAR2_EBIT]+1). [BAR2_EBIT] must
                                                                 be in the range 16 .. [BAR2_SIZ]+18 and must not conflict with a non-zero
                                                                 [BAR2_CBIT] in this case. [BAR2_ESX] XOR ESX\<1:0\> is the endian-swap
                                                                 used for BAR2 requests in this case. If [BAR2_EBIT] \<= 48 in this case, then
                                                                 one or two PCIe BAR2 address ESX field bit(s) are in the address forwarded to
                                                                 SLI and the SMMU, in the same position. */
        uint64_t reserved_25_63        : 39;
#endif /* Word 0 - End */
    } cn83xx;
};
typedef union bdk_pemx_bar_ctl bdk_pemx_bar_ctl_t;

static inline uint64_t BDK_PEMX_BAR_CTL(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_BAR_CTL(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN81XX) && (a<=2))
        return 0x87e0c00000a8ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN83XX) && (a<=3))
        return 0x87e0c00000a8ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN88XX) && (a<=5))
        return 0x87e0c00000a8ll + 0x1000000ll * ((a) & 0x7);
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e0000000158ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_BAR_CTL", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_BAR_CTL(a) bdk_pemx_bar_ctl_t
#define bustype_BDK_PEMX_BAR_CTL(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_BAR_CTL(a) "PEMX_BAR_CTL"
#define device_bar_BDK_PEMX_BAR_CTL(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_BAR_CTL(a) (a)
#define arguments_BDK_PEMX_BAR_CTL(a) (a),-1,-1,-1

/**
 * Register (RSL) pem#_bist_status
 *
 * PEM BIST Status Register
 * This register contains results from BIST runs of PEM's memories.
 */
union bdk_pemx_bist_status
{
    uint64_t u;
    struct bdk_pemx_bist_status_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_10_63        : 54;
        uint64_t tlpn_d0               : 1;  /**< [  9:  9](RO) BIST status for tlp_n_fifo_data0. */
        uint64_t tlpn_d1               : 1;  /**< [  8:  8](RO) BIST status for tlp_n_fifo_data1. */
        uint64_t tlpn_ctl              : 1;  /**< [  7:  7](RO) BIST status for tlp_n_fifo_ctl. */
        uint64_t tlpp_d0               : 1;  /**< [  6:  6](RO) BIST status for tlp_p_fifo_data0. */
        uint64_t tlpp_d1               : 1;  /**< [  5:  5](RO) BIST status for tlp_p_fifo_data1. */
        uint64_t tlpp_ctl              : 1;  /**< [  4:  4](RO) BIST status for tlp_p_fifo_ctl. */
        uint64_t tlpc_d0               : 1;  /**< [  3:  3](RO) BIST status for tlp_c_fifo_data0. */
        uint64_t tlpc_d1               : 1;  /**< [  2:  2](RO) BIST status for tlp_c_fifo_data1. */
        uint64_t tlpc_ctl              : 1;  /**< [  1:  1](RO) BIST status for tlp_c_fifo_ctl. */
        uint64_t m2s                   : 1;  /**< [  0:  0](RO) BIST status for m2s_fifo. */
#else /* Word 0 - Little Endian */
        uint64_t m2s                   : 1;  /**< [  0:  0](RO) BIST status for m2s_fifo. */
        uint64_t tlpc_ctl              : 1;  /**< [  1:  1](RO) BIST status for tlp_c_fifo_ctl. */
        uint64_t tlpc_d1               : 1;  /**< [  2:  2](RO) BIST status for tlp_c_fifo_data1. */
        uint64_t tlpc_d0               : 1;  /**< [  3:  3](RO) BIST status for tlp_c_fifo_data0. */
        uint64_t tlpp_ctl              : 1;  /**< [  4:  4](RO) BIST status for tlp_p_fifo_ctl. */
        uint64_t tlpp_d1               : 1;  /**< [  5:  5](RO) BIST status for tlp_p_fifo_data1. */
        uint64_t tlpp_d0               : 1;  /**< [  6:  6](RO) BIST status for tlp_p_fifo_data0. */
        uint64_t tlpn_ctl              : 1;  /**< [  7:  7](RO) BIST status for tlp_n_fifo_ctl. */
        uint64_t tlpn_d1               : 1;  /**< [  8:  8](RO) BIST status for tlp_n_fifo_data1. */
        uint64_t tlpn_d0               : 1;  /**< [  9:  9](RO) BIST status for tlp_n_fifo_data0. */
        uint64_t reserved_10_63        : 54;
#endif /* Word 0 - End */
    } s;
    struct bdk_pemx_bist_status_cn88xxp1
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_26_63        : 38;
        uint64_t retryc                : 1;  /**< [ 25: 25](RO) Retry buffer memory C. */
        uint64_t sot                   : 1;  /**< [ 24: 24](RO) Start of transfer memory. */
        uint64_t rqhdrb0               : 1;  /**< [ 23: 23](RO) RX queue header memory buffer 0. */
        uint64_t rqhdrb1               : 1;  /**< [ 22: 22](RO) RX queue header memory buffer 1. */
        uint64_t rqdatab0              : 1;  /**< [ 21: 21](RO) RX queue data buffer 0. */
        uint64_t rqdatab1              : 1;  /**< [ 20: 20](RO) RX queue data buffer 1. */
        uint64_t tlpan_d0              : 1;  /**< [ 19: 19](RO) BIST Status for the tlp_n_afifo_data0. */
        uint64_t tlpan_d1              : 1;  /**< [ 18: 18](RO) BIST Status for the tlp_n_afifo_data1. */
        uint64_t tlpan_ctl             : 1;  /**< [ 17: 17](RO) BIST Status for the tlp_n_afifo_ctl. */
        uint64_t tlpap_d0              : 1;  /**< [ 16: 16](RO) BIST Status for the tlp_p_afifo_data0. */
        uint64_t tlpap_d1              : 1;  /**< [ 15: 15](RO) BIST Status for the tlp_p_afifo_data1. */
        uint64_t tlpap_ctl             : 1;  /**< [ 14: 14](RO) BIST Status for the tlp_p_afifo_ctl. */
        uint64_t tlpac_d0              : 1;  /**< [ 13: 13](RO) BIST Status for the tlp_c_afifo_data0. */
        uint64_t tlpac_d1              : 1;  /**< [ 12: 12](RO) BIST Status for the tlp_c_afifo_data1. */
        uint64_t tlpac_ctl             : 1;  /**< [ 11: 11](RO) BIST Status for the tlp_c_afifo_ctl. */
        uint64_t peai_p2e              : 1;  /**< [ 10: 10](RO) BIST Status for the peai__pesc_fifo. */
        uint64_t tlpn_d0               : 1;  /**< [  9:  9](RO) BIST status for tlp_n_fifo_data0. */
        uint64_t tlpn_d1               : 1;  /**< [  8:  8](RO) BIST status for tlp_n_fifo_data1. */
        uint64_t tlpn_ctl              : 1;  /**< [  7:  7](RO) BIST status for tlp_n_fifo_ctl. */
        uint64_t tlpp_d0               : 1;  /**< [  6:  6](RO) BIST status for tlp_p_fifo_data0. */
        uint64_t tlpp_d1               : 1;  /**< [  5:  5](RO) BIST status for tlp_p_fifo_data1. */
        uint64_t tlpp_ctl              : 1;  /**< [  4:  4](RO) BIST status for tlp_p_fifo_ctl. */
        uint64_t tlpc_d0               : 1;  /**< [  3:  3](RO) BIST status for tlp_c_fifo_data0. */
        uint64_t tlpc_d1               : 1;  /**< [  2:  2](RO) BIST status for tlp_c_fifo_data1. */
        uint64_t tlpc_ctl              : 1;  /**< [  1:  1](RO) BIST status for tlp_c_fifo_ctl. */
        uint64_t m2s                   : 1;  /**< [  0:  0](RO) BIST status for m2s_fifo. */
#else /* Word 0 - Little Endian */
        uint64_t m2s                   : 1;  /**< [  0:  0](RO) BIST status for m2s_fifo. */
        uint64_t tlpc_ctl              : 1;  /**< [  1:  1](RO) BIST status for tlp_c_fifo_ctl. */
        uint64_t tlpc_d1               : 1;  /**< [  2:  2](RO) BIST status for tlp_c_fifo_data1. */
        uint64_t tlpc_d0               : 1;  /**< [  3:  3](RO) BIST status for tlp_c_fifo_data0. */
        uint64_t tlpp_ctl              : 1;  /**< [  4:  4](RO) BIST status for tlp_p_fifo_ctl. */
        uint64_t tlpp_d1               : 1;  /**< [  5:  5](RO) BIST status for tlp_p_fifo_data1. */
        uint64_t tlpp_d0               : 1;  /**< [  6:  6](RO) BIST status for tlp_p_fifo_data0. */
        uint64_t tlpn_ctl              : 1;  /**< [  7:  7](RO) BIST status for tlp_n_fifo_ctl. */
        uint64_t tlpn_d1               : 1;  /**< [  8:  8](RO) BIST status for tlp_n_fifo_data1. */
        uint64_t tlpn_d0               : 1;  /**< [  9:  9](RO) BIST status for tlp_n_fifo_data0. */
        uint64_t peai_p2e              : 1;  /**< [ 10: 10](RO) BIST Status for the peai__pesc_fifo. */
        uint64_t tlpac_ctl             : 1;  /**< [ 11: 11](RO) BIST Status for the tlp_c_afifo_ctl. */
        uint64_t tlpac_d1              : 1;  /**< [ 12: 12](RO) BIST Status for the tlp_c_afifo_data1. */
        uint64_t tlpac_d0              : 1;  /**< [ 13: 13](RO) BIST Status for the tlp_c_afifo_data0. */
        uint64_t tlpap_ctl             : 1;  /**< [ 14: 14](RO) BIST Status for the tlp_p_afifo_ctl. */
        uint64_t tlpap_d1              : 1;  /**< [ 15: 15](RO) BIST Status for the tlp_p_afifo_data1. */
        uint64_t tlpap_d0              : 1;  /**< [ 16: 16](RO) BIST Status for the tlp_p_afifo_data0. */
        uint64_t tlpan_ctl             : 1;  /**< [ 17: 17](RO) BIST Status for the tlp_n_afifo_ctl. */
        uint64_t tlpan_d1              : 1;  /**< [ 18: 18](RO) BIST Status for the tlp_n_afifo_data1. */
        uint64_t tlpan_d0              : 1;  /**< [ 19: 19](RO) BIST Status for the tlp_n_afifo_data0. */
        uint64_t rqdatab1              : 1;  /**< [ 20: 20](RO) RX queue data buffer 1. */
        uint64_t rqdatab0              : 1;  /**< [ 21: 21](RO) RX queue data buffer 0. */
        uint64_t rqhdrb1               : 1;  /**< [ 22: 22](RO) RX queue header memory buffer 1. */
        uint64_t rqhdrb0               : 1;  /**< [ 23: 23](RO) RX queue header memory buffer 0. */
        uint64_t sot                   : 1;  /**< [ 24: 24](RO) Start of transfer memory. */
        uint64_t retryc                : 1;  /**< [ 25: 25](RO) Retry buffer memory C. */
        uint64_t reserved_26_63        : 38;
#endif /* Word 0 - End */
    } cn88xxp1;
    struct bdk_pemx_bist_status_cn81xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_26_63        : 38;
        uint64_t retryc                : 1;  /**< [ 25: 25](RO) Retry buffer memory C. */
        uint64_t sot                   : 1;  /**< [ 24: 24](RO) Start of transfer memory. */
        uint64_t rqhdrb0               : 1;  /**< [ 23: 23](RO) RX queue header memory buffer 0. */
        uint64_t rqhdrb1               : 1;  /**< [ 22: 22](RO) RX queue header memory buffer 1. */
        uint64_t rqdatab0              : 1;  /**< [ 21: 21](RO) RX queue data buffer 0. */
        uint64_t rqdatab1              : 1;  /**< [ 20: 20](RO) RX queue data buffer 1. */
        uint64_t tlpan_d0              : 1;  /**< [ 19: 19](RO) Reserved. */
        uint64_t tlpan_d1              : 1;  /**< [ 18: 18](RO) Reserved. */
        uint64_t tlpan_ctl             : 1;  /**< [ 17: 17](RO) Reserved. */
        uint64_t tlpap_d0              : 1;  /**< [ 16: 16](RO) Reserved. */
        uint64_t tlpap_d1              : 1;  /**< [ 15: 15](RO) Reserved. */
        uint64_t tlpap_ctl             : 1;  /**< [ 14: 14](RO) Reserved. */
        uint64_t tlpac_d0              : 1;  /**< [ 13: 13](RO) Reserved. */
        uint64_t tlpac_d1              : 1;  /**< [ 12: 12](RO) Reserved. */
        uint64_t tlpac_ctl             : 1;  /**< [ 11: 11](RO) Reserved. */
        uint64_t peai_p2e              : 1;  /**< [ 10: 10](RO) Reserved. */
        uint64_t tlpn_d0               : 1;  /**< [  9:  9](RO) BIST status for tlp_n_fifo_data0. */
        uint64_t tlpn_d1               : 1;  /**< [  8:  8](RO) BIST status for tlp_n_fifo_data1. */
        uint64_t tlpn_ctl              : 1;  /**< [  7:  7](RO) BIST status for tlp_n_fifo_ctl. */
        uint64_t tlpp_d0               : 1;  /**< [  6:  6](RO) BIST status for tlp_p_fifo_data0. */
        uint64_t tlpp_d1               : 1;  /**< [  5:  5](RO) BIST status for tlp_p_fifo_data1. */
        uint64_t tlpp_ctl              : 1;  /**< [  4:  4](RO) BIST status for tlp_p_fifo_ctl. */
        uint64_t tlpc_d0               : 1;  /**< [  3:  3](RO) BIST status for tlp_c_fifo_data0. */
        uint64_t tlpc_d1               : 1;  /**< [  2:  2](RO) BIST status for tlp_c_fifo_data1. */
        uint64_t tlpc_ctl              : 1;  /**< [  1:  1](RO) BIST status for tlp_c_fifo_ctl. */
        uint64_t m2s                   : 1;  /**< [  0:  0](RO) BIST status for m2s_fifo. */
#else /* Word 0 - Little Endian */
        uint64_t m2s                   : 1;  /**< [  0:  0](RO) BIST status for m2s_fifo. */
        uint64_t tlpc_ctl              : 1;  /**< [  1:  1](RO) BIST status for tlp_c_fifo_ctl. */
        uint64_t tlpc_d1               : 1;  /**< [  2:  2](RO) BIST status for tlp_c_fifo_data1. */
        uint64_t tlpc_d0               : 1;  /**< [  3:  3](RO) BIST status for tlp_c_fifo_data0. */
        uint64_t tlpp_ctl              : 1;  /**< [  4:  4](RO) BIST status for tlp_p_fifo_ctl. */
        uint64_t tlpp_d1               : 1;  /**< [  5:  5](RO) BIST status for tlp_p_fifo_data1. */
        uint64_t tlpp_d0               : 1;  /**< [  6:  6](RO) BIST status for tlp_p_fifo_data0. */
        uint64_t tlpn_ctl              : 1;  /**< [  7:  7](RO) BIST status for tlp_n_fifo_ctl. */
        uint64_t tlpn_d1               : 1;  /**< [  8:  8](RO) BIST status for tlp_n_fifo_data1. */
        uint64_t tlpn_d0               : 1;  /**< [  9:  9](RO) BIST status for tlp_n_fifo_data0. */
        uint64_t peai_p2e              : 1;  /**< [ 10: 10](RO) Reserved. */
        uint64_t tlpac_ctl             : 1;  /**< [ 11: 11](RO) Reserved. */
        uint64_t tlpac_d1              : 1;  /**< [ 12: 12](RO) Reserved. */
        uint64_t tlpac_d0              : 1;  /**< [ 13: 13](RO) Reserved. */
        uint64_t tlpap_ctl             : 1;  /**< [ 14: 14](RO) Reserved. */
        uint64_t tlpap_d1              : 1;  /**< [ 15: 15](RO) Reserved. */
        uint64_t tlpap_d0              : 1;  /**< [ 16: 16](RO) Reserved. */
        uint64_t tlpan_ctl             : 1;  /**< [ 17: 17](RO) Reserved. */
        uint64_t tlpan_d1              : 1;  /**< [ 18: 18](RO) Reserved. */
        uint64_t tlpan_d0              : 1;  /**< [ 19: 19](RO) Reserved. */
        uint64_t rqdatab1              : 1;  /**< [ 20: 20](RO) RX queue data buffer 1. */
        uint64_t rqdatab0              : 1;  /**< [ 21: 21](RO) RX queue data buffer 0. */
        uint64_t rqhdrb1               : 1;  /**< [ 22: 22](RO) RX queue header memory buffer 1. */
        uint64_t rqhdrb0               : 1;  /**< [ 23: 23](RO) RX queue header memory buffer 0. */
        uint64_t sot                   : 1;  /**< [ 24: 24](RO) Start of transfer memory. */
        uint64_t retryc                : 1;  /**< [ 25: 25](RO) Retry buffer memory C. */
        uint64_t reserved_26_63        : 38;
#endif /* Word 0 - End */
    } cn81xx;
    struct bdk_pemx_bist_status_cn83xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_16_63        : 48;
        uint64_t retryc                : 1;  /**< [ 15: 15](RO) Retry buffer memory C. */
        uint64_t sot                   : 1;  /**< [ 14: 14](RO) Start of transfer memory. */
        uint64_t rqhdrb0               : 1;  /**< [ 13: 13](RO) RX queue header memory buffer 0. */
        uint64_t rqhdrb1               : 1;  /**< [ 12: 12](RO) RX queue header memory buffer 1. */
        uint64_t rqdatab0              : 1;  /**< [ 11: 11](RO) RX queue data buffer 0. */
        uint64_t rqdatab1              : 1;  /**< [ 10: 10](RO) RX queue data buffer 1. */
        uint64_t tlpn_d0               : 1;  /**< [  9:  9](RO) BIST status for tlp_n_fifo_data0. */
        uint64_t tlpn_d1               : 1;  /**< [  8:  8](RO) BIST status for tlp_n_fifo_data1. */
        uint64_t tlpn_ctl              : 1;  /**< [  7:  7](RO) BIST status for tlp_n_fifo_ctl. */
        uint64_t tlpp_d0               : 1;  /**< [  6:  6](RO) BIST status for tlp_p_fifo_data0. */
        uint64_t tlpp_d1               : 1;  /**< [  5:  5](RO) BIST status for tlp_p_fifo_data1. */
        uint64_t tlpp_ctl              : 1;  /**< [  4:  4](RO) BIST status for tlp_p_fifo_ctl. */
        uint64_t tlpc_d0               : 1;  /**< [  3:  3](RO) BIST status for tlp_c_fifo_data0. */
        uint64_t tlpc_d1               : 1;  /**< [  2:  2](RO) BIST status for tlp_c_fifo_data1. */
        uint64_t tlpc_ctl              : 1;  /**< [  1:  1](RO) BIST status for tlp_c_fifo_ctl. */
        uint64_t m2s                   : 1;  /**< [  0:  0](RO) BIST status for m2s_fifo. */
#else /* Word 0 - Little Endian */
        uint64_t m2s                   : 1;  /**< [  0:  0](RO) BIST status for m2s_fifo. */
        uint64_t tlpc_ctl              : 1;  /**< [  1:  1](RO) BIST status for tlp_c_fifo_ctl. */
        uint64_t tlpc_d1               : 1;  /**< [  2:  2](RO) BIST status for tlp_c_fifo_data1. */
        uint64_t tlpc_d0               : 1;  /**< [  3:  3](RO) BIST status for tlp_c_fifo_data0. */
        uint64_t tlpp_ctl              : 1;  /**< [  4:  4](RO) BIST status for tlp_p_fifo_ctl. */
        uint64_t tlpp_d1               : 1;  /**< [  5:  5](RO) BIST status for tlp_p_fifo_data1. */
        uint64_t tlpp_d0               : 1;  /**< [  6:  6](RO) BIST status for tlp_p_fifo_data0. */
        uint64_t tlpn_ctl              : 1;  /**< [  7:  7](RO) BIST status for tlp_n_fifo_ctl. */
        uint64_t tlpn_d1               : 1;  /**< [  8:  8](RO) BIST status for tlp_n_fifo_data1. */
        uint64_t tlpn_d0               : 1;  /**< [  9:  9](RO) BIST status for tlp_n_fifo_data0. */
        uint64_t rqdatab1              : 1;  /**< [ 10: 10](RO) RX queue data buffer 1. */
        uint64_t rqdatab0              : 1;  /**< [ 11: 11](RO) RX queue data buffer 0. */
        uint64_t rqhdrb1               : 1;  /**< [ 12: 12](RO) RX queue header memory buffer 1. */
        uint64_t rqhdrb0               : 1;  /**< [ 13: 13](RO) RX queue header memory buffer 0. */
        uint64_t sot                   : 1;  /**< [ 14: 14](RO) Start of transfer memory. */
        uint64_t retryc                : 1;  /**< [ 15: 15](RO) Retry buffer memory C. */
        uint64_t reserved_16_63        : 48;
#endif /* Word 0 - End */
    } cn83xx;
    /* struct bdk_pemx_bist_status_cn81xx cn88xxp2; */
};
typedef union bdk_pemx_bist_status bdk_pemx_bist_status_t;

static inline uint64_t BDK_PEMX_BIST_STATUS(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_BIST_STATUS(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN81XX) && (a<=2))
        return 0x87e0c0000468ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN83XX) && (a<=3))
        return 0x87e0c0000468ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN88XX) && (a<=5))
        return 0x87e0c0000468ll + 0x1000000ll * ((a) & 0x7);
    __bdk_csr_fatal("PEMX_BIST_STATUS", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_BIST_STATUS(a) bdk_pemx_bist_status_t
#define bustype_BDK_PEMX_BIST_STATUS(a) BDK_CSR_TYPE_RSL
#define basename_BDK_PEMX_BIST_STATUS(a) "PEMX_BIST_STATUS"
#define device_bar_BDK_PEMX_BIST_STATUS(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_BIST_STATUS(a) (a)
#define arguments_BDK_PEMX_BIST_STATUS(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_bp_test0
 *
 * INTERNAL: PEM Backpressure Test Register 0
 *
 * This register is for diagnostic use only.
 *
 * This register is not accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on PEM domain reset.
 */
union bdk_pemx_bp_test0
{
    uint64_t u;
    struct bdk_pemx_bp_test0_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t enable                : 4;  /**< [ 63: 60](R/W) Enable test mode. For diagnostic use only.
                                                                 Internal:
                                                                 Once a bit is set, random backpressure is generated
                                                                 at the corresponding point to allow for more frequent backpressure.
                                                                 \<63\> = Limit the NCBI posted FIFO, backpressure doing posted requests to ncb_gnt.
                                                                 \<62\> = Limit the NCBI nonposted FIFO, backpressure doing nonposted requests to ncb_gnt.
                                                                 \<61\> = Limit the NCBI completion FIFO, backpressure doing completion requests to ncb_gnt.
                                                                 \<60\> = Limit the NCBI CSR completion FIFO, backpressure doing requests for CSR responses
                                                                 to ncb_gnt. */
        uint64_t reserved_24_59        : 36;
        uint64_t bp_cfg                : 8;  /**< [ 23: 16](R/W) Backpressure weight. For diagnostic use only.
                                                                 Internal:
                                                                 There are 2 backpressure configuration bits per enable, with the two bits
                                                                 defined as 0x0=100% of the time, 0x1=75% of the time, 0x2=50% of the time,
                                                                 0x3=25% of the time.
                                                                   \<23:22\> = Config 3.
                                                                   \<21:20\> = Config 2.
                                                                   \<19:18\> = Config 1.
                                                                   \<17:16\> = Config 0. */
        uint64_t reserved_12_15        : 4;
        uint64_t lfsr_freq             : 12; /**< [ 11:  0](R/W) Test LFSR update frequency in coprocessor-clocks minus one. */
#else /* Word 0 - Little Endian */
        uint64_t lfsr_freq             : 12; /**< [ 11:  0](R/W) Test LFSR update frequency in coprocessor-clocks minus one. */
        uint64_t reserved_12_15        : 4;
        uint64_t bp_cfg                : 8;  /**< [ 23: 16](R/W) Backpressure weight. For diagnostic use only.
                                                                 Internal:
                                                                 There are 2 backpressure configuration bits per enable, with the two bits
                                                                 defined as 0x0=100% of the time, 0x1=75% of the time, 0x2=50% of the time,
                                                                 0x3=25% of the time.
                                                                   \<23:22\> = Config 3.
                                                                   \<21:20\> = Config 2.
                                                                   \<19:18\> = Config 1.
                                                                   \<17:16\> = Config 0. */
        uint64_t reserved_24_59        : 36;
        uint64_t enable                : 4;  /**< [ 63: 60](R/W) Enable test mode. For diagnostic use only.
                                                                 Internal:
                                                                 Once a bit is set, random backpressure is generated
                                                                 at the corresponding point to allow for more frequent backpressure.
                                                                 \<63\> = Limit the NCBI posted FIFO, backpressure doing posted requests to ncb_gnt.
                                                                 \<62\> = Limit the NCBI nonposted FIFO, backpressure doing nonposted requests to ncb_gnt.
                                                                 \<61\> = Limit the NCBI completion FIFO, backpressure doing completion requests to ncb_gnt.
                                                                 \<60\> = Limit the NCBI CSR completion FIFO, backpressure doing requests for CSR responses
                                                                 to ncb_gnt. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_bp_test0_s cn; */
};
typedef union bdk_pemx_bp_test0 bdk_pemx_bp_test0_t;

static inline uint64_t BDK_PEMX_BP_TEST0(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_BP_TEST0(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e00000001d0ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_BP_TEST0", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_BP_TEST0(a) bdk_pemx_bp_test0_t
#define bustype_BDK_PEMX_BP_TEST0(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_BP_TEST0(a) "PEMX_BP_TEST0"
#define device_bar_BDK_PEMX_BP_TEST0(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_BP_TEST0(a) (a)
#define arguments_BDK_PEMX_BP_TEST0(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_bp_test1
 *
 * INTERNAL: PEM Backpressure Test Register 1
 *
 * This register is for diagnostic use only.
 *
 * This register is not accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on PEM domain reset.
 */
union bdk_pemx_bp_test1
{
    uint64_t u;
    struct bdk_pemx_bp_test1_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t enable                : 4;  /**< [ 63: 60](R/W) Enable test mode. For diagnostic use only.
                                                                 Internal:
                                                                 Once a bit is set, random backpressure is generated
                                                                 at the corresponding point to allow for more frequent backpressure.
                                                                 \<63\> = Reserved.
                                                                 \<62\> = Reserved.
                                                                 \<61\> = Reserved.
                                                                 \<60\> = Limit the MAC core incoming TLP FIFO; backpressure taking data from this FIFO. */
        uint64_t reserved_24_59        : 36;
        uint64_t bp_cfg                : 8;  /**< [ 23: 16](R/W) Backpressure weight. For diagnostic use only.
                                                                 Internal:
                                                                 There are 2 backpressure configuration bits per enable, with the two bits
                                                                 defined as 0x0=100% of the time, 0x1=75% of the time, 0x2=50% of the time,
                                                                 0x3=25% of the time.
                                                                   \<23:22\> = Config 3.
                                                                   \<21:20\> = Config 2.
                                                                   \<19:18\> = Config 1.
                                                                   \<17:16\> = Config 0. */
        uint64_t reserved_12_15        : 4;
        uint64_t lfsr_freq             : 12; /**< [ 11:  0](R/W) Test LFSR update frequency in coprocessor-clocks minus one. */
#else /* Word 0 - Little Endian */
        uint64_t lfsr_freq             : 12; /**< [ 11:  0](R/W) Test LFSR update frequency in coprocessor-clocks minus one. */
        uint64_t reserved_12_15        : 4;
        uint64_t bp_cfg                : 8;  /**< [ 23: 16](R/W) Backpressure weight. For diagnostic use only.
                                                                 Internal:
                                                                 There are 2 backpressure configuration bits per enable, with the two bits
                                                                 defined as 0x0=100% of the time, 0x1=75% of the time, 0x2=50% of the time,
                                                                 0x3=25% of the time.
                                                                   \<23:22\> = Config 3.
                                                                   \<21:20\> = Config 2.
                                                                   \<19:18\> = Config 1.
                                                                   \<17:16\> = Config 0. */
        uint64_t reserved_24_59        : 36;
        uint64_t enable                : 4;  /**< [ 63: 60](R/W) Enable test mode. For diagnostic use only.
                                                                 Internal:
                                                                 Once a bit is set, random backpressure is generated
                                                                 at the corresponding point to allow for more frequent backpressure.
                                                                 \<63\> = Reserved.
                                                                 \<62\> = Reserved.
                                                                 \<61\> = Reserved.
                                                                 \<60\> = Limit the MAC core incoming TLP FIFO; backpressure taking data from this FIFO. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_bp_test1_s cn; */
};
typedef union bdk_pemx_bp_test1 bdk_pemx_bp_test1_t;

static inline uint64_t BDK_PEMX_BP_TEST1(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_BP_TEST1(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e00000001d8ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_BP_TEST1", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_BP_TEST1(a) bdk_pemx_bp_test1_t
#define bustype_BDK_PEMX_BP_TEST1(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_BP_TEST1(a) "PEMX_BP_TEST1"
#define device_bar_BDK_PEMX_BP_TEST1(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_BP_TEST1(a) (a)
#define arguments_BDK_PEMX_BP_TEST1(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_bp_test2
 *
 * INTERNAL: PEM Backpressure Test Register 2
 *
 * This register is for diagnostic use only.
 *
 * This register is not accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on PEM domain reset.
 */
union bdk_pemx_bp_test2
{
    uint64_t u;
    struct bdk_pemx_bp_test2_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t enable                : 4;  /**< [ 63: 60](R/W) Enable test mode. For diagnostic use only.
                                                                 Internal:
                                                                 Once a bit is set, random backpressure is generated
                                                                 at the corresponding point to allow for more frequent backpressure.
                                                                 NOTE: Test backpressure will only be applied at an NCBO transaction boundary.
                                                                 \<63\> = Limit the draining of NCBO CSR offloading FIFO.
                                                                 \<62\> = Reserved
                                                                 \<61\> = Limit the draining of NCBO Non-posted offloading FIFO.
                                                                 \<60\> = Limit the draining of NCBO Posted offloading FIFO. */
        uint64_t reserved_24_59        : 36;
        uint64_t bp_cfg                : 8;  /**< [ 23: 16](R/W) Backpressure weight. For diagnostic use only.
                                                                 Internal:
                                                                 There are 2 backpressure configuration bits per enable, with the two bits
                                                                 defined as 0x0=100% of the time, 0x1=75% of the time, 0x2=50% of the time,
                                                                 0x3=25% of the time.
                                                                   \<23:22\> = Config 3.
                                                                   \<21:20\> = Config 2.
                                                                   \<19:18\> = Config 1.
                                                                   \<17:16\> = Config 0. */
        uint64_t reserved_12_15        : 4;
        uint64_t lfsr_freq             : 12; /**< [ 11:  0](R/W) Test LFSR update frequency in coprocessor-clocks minus one. */
#else /* Word 0 - Little Endian */
        uint64_t lfsr_freq             : 12; /**< [ 11:  0](R/W) Test LFSR update frequency in coprocessor-clocks minus one. */
        uint64_t reserved_12_15        : 4;
        uint64_t bp_cfg                : 8;  /**< [ 23: 16](R/W) Backpressure weight. For diagnostic use only.
                                                                 Internal:
                                                                 There are 2 backpressure configuration bits per enable, with the two bits
                                                                 defined as 0x0=100% of the time, 0x1=75% of the time, 0x2=50% of the time,
                                                                 0x3=25% of the time.
                                                                   \<23:22\> = Config 3.
                                                                   \<21:20\> = Config 2.
                                                                   \<19:18\> = Config 1.
                                                                   \<17:16\> = Config 0. */
        uint64_t reserved_24_59        : 36;
        uint64_t enable                : 4;  /**< [ 63: 60](R/W) Enable test mode. For diagnostic use only.
                                                                 Internal:
                                                                 Once a bit is set, random backpressure is generated
                                                                 at the corresponding point to allow for more frequent backpressure.
                                                                 NOTE: Test backpressure will only be applied at an NCBO transaction boundary.
                                                                 \<63\> = Limit the draining of NCBO CSR offloading FIFO.
                                                                 \<62\> = Reserved
                                                                 \<61\> = Limit the draining of NCBO Non-posted offloading FIFO.
                                                                 \<60\> = Limit the draining of NCBO Posted offloading FIFO. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_bp_test2_s cn; */
};
typedef union bdk_pemx_bp_test2 bdk_pemx_bp_test2_t;

static inline uint64_t BDK_PEMX_BP_TEST2(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_BP_TEST2(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e00000001e8ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_BP_TEST2", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_BP_TEST2(a) bdk_pemx_bp_test2_t
#define bustype_BDK_PEMX_BP_TEST2(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_BP_TEST2(a) "PEMX_BP_TEST2"
#define device_bar_BDK_PEMX_BP_TEST2(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_BP_TEST2(a) (a)
#define arguments_BDK_PEMX_BP_TEST2(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_bp_test3
 *
 * INTERNAL: PEM Backpressure Test Register 3
 *
 * This register is for diagnostic use only.
 *
 * This register is not accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on PEM domain reset.
 */
union bdk_pemx_bp_test3
{
    uint64_t u;
    struct bdk_pemx_bp_test3_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t enable                : 4;  /**< [ 63: 60](R/W) Enable test mode. For diagnostic use only.
                                                                 Internal:
                                                                 Once a bit is set, random backpressure is generated
                                                                 at the corresponding point to allow for more frequent backpressure.
                                                                 NOTE: Test backpressure will only be applied at a TLP boundary.
                                                                 \<63\> = Reserved.
                                                                 \<62\> = Limit the transfers of Completion TLPs from pemm to pemc.
                                                                 \<61\> = Limit the transfers of Non-posted TLPs from pemm to pemc.
                                                                 \<60\> = Limit the transfers of Posted TLPs from pemm to pemc. */
        uint64_t reserved_24_59        : 36;
        uint64_t bp_cfg                : 8;  /**< [ 23: 16](R/W) Backpressure weight. For diagnostic use only.
                                                                 Internal:
                                                                 There are 2 backpressure configuration bits per enable, with the two bits
                                                                 defined as 0x0=100% of the time, 0x1=75% of the time, 0x2=50% of the time,
                                                                 0x3=25% of the time.
                                                                   \<23:22\> = Config 3.
                                                                   \<21:20\> = Config 2.
                                                                   \<19:18\> = Config 1.
                                                                   \<17:16\> = Config 0. */
        uint64_t reserved_12_15        : 4;
        uint64_t lfsr_freq             : 12; /**< [ 11:  0](R/W) Test LFSR update frequency in coprocessor-clocks minus one. */
#else /* Word 0 - Little Endian */
        uint64_t lfsr_freq             : 12; /**< [ 11:  0](R/W) Test LFSR update frequency in coprocessor-clocks minus one. */
        uint64_t reserved_12_15        : 4;
        uint64_t bp_cfg                : 8;  /**< [ 23: 16](R/W) Backpressure weight. For diagnostic use only.
                                                                 Internal:
                                                                 There are 2 backpressure configuration bits per enable, with the two bits
                                                                 defined as 0x0=100% of the time, 0x1=75% of the time, 0x2=50% of the time,
                                                                 0x3=25% of the time.
                                                                   \<23:22\> = Config 3.
                                                                   \<21:20\> = Config 2.
                                                                   \<19:18\> = Config 1.
                                                                   \<17:16\> = Config 0. */
        uint64_t reserved_24_59        : 36;
        uint64_t enable                : 4;  /**< [ 63: 60](R/W) Enable test mode. For diagnostic use only.
                                                                 Internal:
                                                                 Once a bit is set, random backpressure is generated
                                                                 at the corresponding point to allow for more frequent backpressure.
                                                                 NOTE: Test backpressure will only be applied at a TLP boundary.
                                                                 \<63\> = Reserved.
                                                                 \<62\> = Limit the transfers of Completion TLPs from pemm to pemc.
                                                                 \<61\> = Limit the transfers of Non-posted TLPs from pemm to pemc.
                                                                 \<60\> = Limit the transfers of Posted TLPs from pemm to pemc. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_bp_test3_s cn; */
};
typedef union bdk_pemx_bp_test3 bdk_pemx_bp_test3_t;

static inline uint64_t BDK_PEMX_BP_TEST3(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_BP_TEST3(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e00000001f0ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_BP_TEST3", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_BP_TEST3(a) bdk_pemx_bp_test3_t
#define bustype_BDK_PEMX_BP_TEST3(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_BP_TEST3(a) "PEMX_BP_TEST3"
#define device_bar_BDK_PEMX_BP_TEST3(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_BP_TEST3(a) (a)
#define arguments_BDK_PEMX_BP_TEST3(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_bp_test4
 *
 * INTERNAL: PEM Backpressure Test Register 4
 *
 * This register is for diagnostic use only.
 *
 * This register is not accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on PEM domain reset.
 */
union bdk_pemx_bp_test4
{
    uint64_t u;
    struct bdk_pemx_bp_test4_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t enable                : 4;  /**< [ 63: 60](R/W) Enable test mode. For diagnostic use only.
                                                                 Internal:
                                                                 Once a bit is set, random backpressure is generated
                                                                 at the corresponding point to allow for more frequent backpressure.
                                                                 \<63\> = Limit the EBI posted FIFO.
                                                                 \<62\> = Limit the EBI nonposted FIFO.
                                                                 \<61\> = Limit the EBI completion FIFO.
                                                                 \<60\> = Limit the EBI completion fault FIFO. */
        uint64_t reserved_24_59        : 36;
        uint64_t bp_cfg                : 8;  /**< [ 23: 16](R/W) Backpressure weight. For diagnostic use only.
                                                                 Internal:
                                                                 There are 2 backpressure configuration bits per enable, with the two bits
                                                                 defined as 0x0=100% of the time, 0x1=75% of the time, 0x2=50% of the time,
                                                                 0x3=25% of the time.
                                                                   \<23:22\> = Config 3.
                                                                   \<21:20\> = Config 2.
                                                                   \<19:18\> = Config 1.
                                                                   \<17:16\> = Config 0. */
        uint64_t reserved_12_15        : 4;
        uint64_t lfsr_freq             : 12; /**< [ 11:  0](R/W) Test LFSR update frequency in coprocessor-clocks minus one. */
#else /* Word 0 - Little Endian */
        uint64_t lfsr_freq             : 12; /**< [ 11:  0](R/W) Test LFSR update frequency in coprocessor-clocks minus one. */
        uint64_t reserved_12_15        : 4;
        uint64_t bp_cfg                : 8;  /**< [ 23: 16](R/W) Backpressure weight. For diagnostic use only.
                                                                 Internal:
                                                                 There are 2 backpressure configuration bits per enable, with the two bits
                                                                 defined as 0x0=100% of the time, 0x1=75% of the time, 0x2=50% of the time,
                                                                 0x3=25% of the time.
                                                                   \<23:22\> = Config 3.
                                                                   \<21:20\> = Config 2.
                                                                   \<19:18\> = Config 1.
                                                                   \<17:16\> = Config 0. */
        uint64_t reserved_24_59        : 36;
        uint64_t enable                : 4;  /**< [ 63: 60](R/W) Enable test mode. For diagnostic use only.
                                                                 Internal:
                                                                 Once a bit is set, random backpressure is generated
                                                                 at the corresponding point to allow for more frequent backpressure.
                                                                 \<63\> = Limit the EBI posted FIFO.
                                                                 \<62\> = Limit the EBI nonposted FIFO.
                                                                 \<61\> = Limit the EBI completion FIFO.
                                                                 \<60\> = Limit the EBI completion fault FIFO. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_bp_test4_s cn; */
};
typedef union bdk_pemx_bp_test4 bdk_pemx_bp_test4_t;

static inline uint64_t BDK_PEMX_BP_TEST4(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_BP_TEST4(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e00000001f8ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_BP_TEST4", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_BP_TEST4(a) bdk_pemx_bp_test4_t
#define bustype_BDK_PEMX_BP_TEST4(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_BP_TEST4(a) "PEMX_BP_TEST4"
#define device_bar_BDK_PEMX_BP_TEST4(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_BP_TEST4(a) (a)
#define arguments_BDK_PEMX_BP_TEST4(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_bp_test5
 *
 * INTERNAL: PEM Backpressure Test Register 5
 *
 * This register is for diagnostic use only.
 *
 * This register is not accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on PEM domain reset.
 */
union bdk_pemx_bp_test5
{
    uint64_t u;
    struct bdk_pemx_bp_test5_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t enable                : 4;  /**< [ 63: 60](R/W) Enable test mode. For diagnostic use only.
                                                                 Internal:
                                                                 Once a bit is set, random backpressure is generated
                                                                 at the corresponding point to allow for more frequent backpressure.
                                                                 Note backpressure will only be applied at an EBO transaction boundary.
                                                                 \<63\> = Reserved.
                                                                 \<62\> = Limit the draining of EBO Completion offloading buffer.
                                                                 \<61\> = Limit the draining of EBO Non-posted offloading FIFO.
                                                                 \<60\> = Limit the draining of EBO Posted offloading FIFO. */
        uint64_t reserved_24_59        : 36;
        uint64_t bp_cfg                : 8;  /**< [ 23: 16](R/W) Backpressure weight. For diagnostic use only.
                                                                 Internal:
                                                                 There are 2 backpressure configuration bits per enable, with the two bits
                                                                 defined as 0x0=100% of the time, 0x1=75% of the time, 0x2=50% of the time,
                                                                 0x3=25% of the time.
                                                                   \<23:22\> = Config 3.
                                                                   \<21:20\> = Config 2.
                                                                   \<19:18\> = Config 1.
                                                                   \<17:16\> = Config 0. */
        uint64_t reserved_12_15        : 4;
        uint64_t lfsr_freq             : 12; /**< [ 11:  0](R/W) Test LFSR update frequency in coprocessor-clocks minus one. */
#else /* Word 0 - Little Endian */
        uint64_t lfsr_freq             : 12; /**< [ 11:  0](R/W) Test LFSR update frequency in coprocessor-clocks minus one. */
        uint64_t reserved_12_15        : 4;
        uint64_t bp_cfg                : 8;  /**< [ 23: 16](R/W) Backpressure weight. For diagnostic use only.
                                                                 Internal:
                                                                 There are 2 backpressure configuration bits per enable, with the two bits
                                                                 defined as 0x0=100% of the time, 0x1=75% of the time, 0x2=50% of the time,
                                                                 0x3=25% of the time.
                                                                   \<23:22\> = Config 3.
                                                                   \<21:20\> = Config 2.
                                                                   \<19:18\> = Config 1.
                                                                   \<17:16\> = Config 0. */
        uint64_t reserved_24_59        : 36;
        uint64_t enable                : 4;  /**< [ 63: 60](R/W) Enable test mode. For diagnostic use only.
                                                                 Internal:
                                                                 Once a bit is set, random backpressure is generated
                                                                 at the corresponding point to allow for more frequent backpressure.
                                                                 Note backpressure will only be applied at an EBO transaction boundary.
                                                                 \<63\> = Reserved.
                                                                 \<62\> = Limit the draining of EBO Completion offloading buffer.
                                                                 \<61\> = Limit the draining of EBO Non-posted offloading FIFO.
                                                                 \<60\> = Limit the draining of EBO Posted offloading FIFO. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_bp_test5_s cn; */
};
typedef union bdk_pemx_bp_test5 bdk_pemx_bp_test5_t;

static inline uint64_t BDK_PEMX_BP_TEST5(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_BP_TEST5(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e0000000200ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_BP_TEST5", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_BP_TEST5(a) bdk_pemx_bp_test5_t
#define bustype_BDK_PEMX_BP_TEST5(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_BP_TEST5(a) "PEMX_BP_TEST5"
#define device_bar_BDK_PEMX_BP_TEST5(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_BP_TEST5(a) (a)
#define arguments_BDK_PEMX_BP_TEST5(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_bp_test6
 *
 * INTERNAL: PEM Backpressure Test Register 6
 *
 * This register is for diagnostic use only.
 *
 * This register is not accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on PEM domain reset.
 */
union bdk_pemx_bp_test6
{
    uint64_t u;
    struct bdk_pemx_bp_test6_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t enable                : 4;  /**< [ 63: 60](R/W) Enable test mode. For diagnostic use only.
                                                                 Internal:
                                                                 Once a bit is set, random backpressure is generated
                                                                 at the corresponding point to allow for more frequent backpressure.
                                                                 \<63\> = Reserved.
                                                                 \<62\> = Limit the PSPI nonposted FIFO.
                                                                 \<61\> = Reserved.
                                                                 \<60\> = Reserved. */
        uint64_t reserved_24_59        : 36;
        uint64_t bp_cfg                : 8;  /**< [ 23: 16](R/W) Backpressure weight. For diagnostic use only.
                                                                 Internal:
                                                                 There are 2 backpressure configuration bits per enable, with the two bits
                                                                 defined as 0x0=100% of the time, 0x1=75% of the time, 0x2=50% of the time,
                                                                 0x3=25% of the time.
                                                                   \<23:22\> = Config 3.
                                                                   \<21:20\> = Config 2.
                                                                   \<19:18\> = Config 1.
                                                                   \<17:16\> = Config 0. */
        uint64_t reserved_12_15        : 4;
        uint64_t lfsr_freq             : 12; /**< [ 11:  0](R/W) Test LFSR update frequency in coprocessor-clocks minus one. */
#else /* Word 0 - Little Endian */
        uint64_t lfsr_freq             : 12; /**< [ 11:  0](R/W) Test LFSR update frequency in coprocessor-clocks minus one. */
        uint64_t reserved_12_15        : 4;
        uint64_t bp_cfg                : 8;  /**< [ 23: 16](R/W) Backpressure weight. For diagnostic use only.
                                                                 Internal:
                                                                 There are 2 backpressure configuration bits per enable, with the two bits
                                                                 defined as 0x0=100% of the time, 0x1=75% of the time, 0x2=50% of the time,
                                                                 0x3=25% of the time.
                                                                   \<23:22\> = Config 3.
                                                                   \<21:20\> = Config 2.
                                                                   \<19:18\> = Config 1.
                                                                   \<17:16\> = Config 0. */
        uint64_t reserved_24_59        : 36;
        uint64_t enable                : 4;  /**< [ 63: 60](R/W) Enable test mode. For diagnostic use only.
                                                                 Internal:
                                                                 Once a bit is set, random backpressure is generated
                                                                 at the corresponding point to allow for more frequent backpressure.
                                                                 \<63\> = Reserved.
                                                                 \<62\> = Limit the PSPI nonposted FIFO.
                                                                 \<61\> = Reserved.
                                                                 \<60\> = Reserved. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_bp_test6_s cn; */
};
typedef union bdk_pemx_bp_test6 bdk_pemx_bp_test6_t;

static inline uint64_t BDK_PEMX_BP_TEST6(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_BP_TEST6(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e0000000208ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_BP_TEST6", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_BP_TEST6(a) bdk_pemx_bp_test6_t
#define bustype_BDK_PEMX_BP_TEST6(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_BP_TEST6(a) "PEMX_BP_TEST6"
#define device_bar_BDK_PEMX_BP_TEST6(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_BP_TEST6(a) (a)
#define arguments_BDK_PEMX_BP_TEST6(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_cfg
 *
 * PEM Application Configuration Register
 * This register configures the PCIe application.
 *
 * This register is accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on cold reset.
 */
union bdk_pemx_cfg
{
    uint64_t u;
    struct bdk_pemx_cfg_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_0_63         : 64;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0_63         : 64;
#endif /* Word 0 - End */
    } s;
    struct bdk_pemx_cfg_cn9
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_8_63         : 56;
        uint64_t pipe_grp_ptr          : 3;  /**< [  7:  5](R/W/H) Each PEM brings in 24 lanes of RX Pipe.
                                                                 Configures the PEM to point to the RX Pipe quad containing
                                                                 Lane 0.
                                                                 0x0 = grp0 (lane 0).
                                                                 0x1 = grp1 (lane 4).
                                                                 0x2 = grp2 (lane 8).
                                                                 0x3 = grp3 (lane 12).
                                                                 0x4 = grp4 (lane 16).
                                                                 0x5 = grp5 (lane 20).
                                                                 0x6 - 0x7 = Reserved.

                                                                 CN93XX configuration:
                                                                 \<pre\>
                                                                 PEM0: Configure to grp0 (QLM0/1/2/3).
                                                                 PEM1: Configure to grp0 (QLM1).
                                                                       Configure to grp1 (DLM4/5).
                                                                 PEM2: Configure to grp0 (QLM3).
                                                                       Configure to grp1 (DLM5).
                                                                       Configure to grp2 (QLM6/7).
                                                                 PEM3: Configure to grp0 (QLM2/3).
                                                                 \</pre\> */
        uint64_t pipe                  : 2;  /**< [  4:  3](R/W/H) Configures the PEM pipe sources.
                                                                 0x0 = Pipe 0.
                                                                 0x1 = Pipe 1.
                                                                 0x2 = Pipe 2.
                                                                 0x3 = Reserved.

                                                                 CN93XX configuration:
                                                                 \<pre\>
                                                                 PEM0: Configure to Pipe 0 (QLM0/1/2/3).
                                                                 PEM1: Configure to Pipe 0 (QLM1).
                                                                       Configure to Pipe 1 (DLM4/5).
                                                                 PEM2: Configure to Pipe 0 (QLM3).
                                                                       Configure to Pipe 1 (DLM5).
                                                                       Configure to Pipe 2 (QLM6/7).
                                                                 PEM3: Configure to Pipe 0 (QLM2/3).
                                                                 \</pre\> */
        uint64_t lanes                 : 2;  /**< [  2:  1](R/W/H) Ties off RX Pipe for unused lanes.
                                                                 0x0 = 2 lanes.
                                                                 0x1 = 4 lanes.
                                                                 0x2 = 8 lanes.
                                                                 0x3 = 16 lanes.

                                                                 CN93XX configuration:
                                                                 \<pre\>
                                                                 PEM0: Configure to 16 Lanes (QLM0/1/2/3).
                                                                       Configure to  8 Lanes (QLM0/1).
                                                                       Configure to  4 Lanes (QLM0).
                                                                 PEM1: Configure to  4 Lanes (QLM1 or DLM4/5).
                                                                       Configure to  2 Lanes (DLM4).
                                                                 PEM2: Configure to  4 Lanes (QLM3).
                                                                       Configure to  2 Lanes (DLM5).
                                                                       Configure to  8 Lanes (QLM6/7).
                                                                       Configure to  4 Lanes (QLM6).
                                                                 PEM3: Configure to  8 Lanes (QLM2/3 or QLM6/7).
                                                                       Configure to  4 Lanes (QLM 2 or QLM6).
                                                                 \</pre\> */
        uint64_t hostmd                : 1;  /**< [  0:  0](R/W/H) Host mode.
                                                                 0 = PEM is configured to be an end point (EP mode).
                                                                 1 = PEM is configured to be a root complex (RC mode). */
#else /* Word 0 - Little Endian */
        uint64_t hostmd                : 1;  /**< [  0:  0](R/W/H) Host mode.
                                                                 0 = PEM is configured to be an end point (EP mode).
                                                                 1 = PEM is configured to be a root complex (RC mode). */
        uint64_t lanes                 : 2;  /**< [  2:  1](R/W/H) Ties off RX Pipe for unused lanes.
                                                                 0x0 = 2 lanes.
                                                                 0x1 = 4 lanes.
                                                                 0x2 = 8 lanes.
                                                                 0x3 = 16 lanes.

                                                                 CN93XX configuration:
                                                                 \<pre\>
                                                                 PEM0: Configure to 16 Lanes (QLM0/1/2/3).
                                                                       Configure to  8 Lanes (QLM0/1).
                                                                       Configure to  4 Lanes (QLM0).
                                                                 PEM1: Configure to  4 Lanes (QLM1 or DLM4/5).
                                                                       Configure to  2 Lanes (DLM4).
                                                                 PEM2: Configure to  4 Lanes (QLM3).
                                                                       Configure to  2 Lanes (DLM5).
                                                                       Configure to  8 Lanes (QLM6/7).
                                                                       Configure to  4 Lanes (QLM6).
                                                                 PEM3: Configure to  8 Lanes (QLM2/3 or QLM6/7).
                                                                       Configure to  4 Lanes (QLM 2 or QLM6).
                                                                 \</pre\> */
        uint64_t pipe                  : 2;  /**< [  4:  3](R/W/H) Configures the PEM pipe sources.
                                                                 0x0 = Pipe 0.
                                                                 0x1 = Pipe 1.
                                                                 0x2 = Pipe 2.
                                                                 0x3 = Reserved.

                                                                 CN93XX configuration:
                                                                 \<pre\>
                                                                 PEM0: Configure to Pipe 0 (QLM0/1/2/3).
                                                                 PEM1: Configure to Pipe 0 (QLM1).
                                                                       Configure to Pipe 1 (DLM4/5).
                                                                 PEM2: Configure to Pipe 0 (QLM3).
                                                                       Configure to Pipe 1 (DLM5).
                                                                       Configure to Pipe 2 (QLM6/7).
                                                                 PEM3: Configure to Pipe 0 (QLM2/3).
                                                                 \</pre\> */
        uint64_t pipe_grp_ptr          : 3;  /**< [  7:  5](R/W/H) Each PEM brings in 24 lanes of RX Pipe.
                                                                 Configures the PEM to point to the RX Pipe quad containing
                                                                 Lane 0.
                                                                 0x0 = grp0 (lane 0).
                                                                 0x1 = grp1 (lane 4).
                                                                 0x2 = grp2 (lane 8).
                                                                 0x3 = grp3 (lane 12).
                                                                 0x4 = grp4 (lane 16).
                                                                 0x5 = grp5 (lane 20).
                                                                 0x6 - 0x7 = Reserved.

                                                                 CN93XX configuration:
                                                                 \<pre\>
                                                                 PEM0: Configure to grp0 (QLM0/1/2/3).
                                                                 PEM1: Configure to grp0 (QLM1).
                                                                       Configure to grp1 (DLM4/5).
                                                                 PEM2: Configure to grp0 (QLM3).
                                                                       Configure to grp1 (DLM5).
                                                                       Configure to grp2 (QLM6/7).
                                                                 PEM3: Configure to grp0 (QLM2/3).
                                                                 \</pre\> */
        uint64_t reserved_8_63         : 56;
#endif /* Word 0 - End */
    } cn9;
    struct bdk_pemx_cfg_cn81xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_6_63         : 58;
        uint64_t lanes4                : 1;  /**< [  5:  5](R/W) Determines the number of lanes.
                                                                 When set, the PEM is configured for a maximum of 4 lanes. When clear, the PEM is
                                                                 configured for a maximum of 2 lanes. This value is used to set the maximum link width
                                                                 field in the core's link capabilities register (CFG031) to indicate the maximum number of
                                                                 lanes supported. Note that less lanes than the specified maximum can be configured for use
                                                                 via the core's link control register (CFG032) negotiated link width field. */
        uint64_t laneswap              : 1;  /**< [  4:  4](R/W) Determines lane swapping. When set, lane swapping is
                                                                 performed to/from the SerDes. When clear, no lane swapping is performed. */
        uint64_t reserved_2_3          : 2;
        uint64_t md                    : 2;  /**< [  1:  0](R/W) Determines the speed.
                                                                   0x0 = Gen1 speed.
                                                                   0x1 = Gen2 speed.
                                                                   0x2 = Gen3 speed.
                                                                   0x3 = Gen3 speed. */
#else /* Word 0 - Little Endian */
        uint64_t md                    : 2;  /**< [  1:  0](R/W) Determines the speed.
                                                                   0x0 = Gen1 speed.
                                                                   0x1 = Gen2 speed.
                                                                   0x2 = Gen3 speed.
                                                                   0x3 = Gen3 speed. */
        uint64_t reserved_2_3          : 2;
        uint64_t laneswap              : 1;  /**< [  4:  4](R/W) Determines lane swapping. When set, lane swapping is
                                                                 performed to/from the SerDes. When clear, no lane swapping is performed. */
        uint64_t lanes4                : 1;  /**< [  5:  5](R/W) Determines the number of lanes.
                                                                 When set, the PEM is configured for a maximum of 4 lanes. When clear, the PEM is
                                                                 configured for a maximum of 2 lanes. This value is used to set the maximum link width
                                                                 field in the core's link capabilities register (CFG031) to indicate the maximum number of
                                                                 lanes supported. Note that less lanes than the specified maximum can be configured for use
                                                                 via the core's link control register (CFG032) negotiated link width field. */
        uint64_t reserved_6_63         : 58;
#endif /* Word 0 - End */
    } cn81xx;
    struct bdk_pemx_cfg_cn88xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_5_63         : 59;
        uint64_t laneswap              : 1;  /**< [  4:  4](R/W/H) Determines lane swapping. When set, lane swapping is
                                                                 performed to/from the SerDes. When clear, no lane swapping is performed. */
        uint64_t lanes8                : 1;  /**< [  3:  3](R/W/H) Determines the number of lanes.
                                                                 When set, the PEM is configured for a maximum of 8 lanes. When clear, the PEM is
                                                                 configured for a maximum of 4 lanes. This value is used to set the maximum link width
                                                                 field in the core's link capabilities register (CFG031) to indicate the maximum number of
                                                                 lanes supported. Note that less lanes than the specified maximum can be configured for use
                                                                 via the core's link control register (CFG032) negotiated link width field. */
        uint64_t reserved_2            : 1;
        uint64_t md                    : 2;  /**< [  1:  0](R/W/H) Determines the speed.
                                                                   0x0 = Gen1 speed.
                                                                   0x1 = Gen2 speed.
                                                                   0x2 = Gen3 speed.
                                                                   0x3 = Gen3 speed. */
#else /* Word 0 - Little Endian */
        uint64_t md                    : 2;  /**< [  1:  0](R/W/H) Determines the speed.
                                                                   0x0 = Gen1 speed.
                                                                   0x1 = Gen2 speed.
                                                                   0x2 = Gen3 speed.
                                                                   0x3 = Gen3 speed. */
        uint64_t reserved_2            : 1;
        uint64_t lanes8                : 1;  /**< [  3:  3](R/W/H) Determines the number of lanes.
                                                                 When set, the PEM is configured for a maximum of 8 lanes. When clear, the PEM is
                                                                 configured for a maximum of 4 lanes. This value is used to set the maximum link width
                                                                 field in the core's link capabilities register (CFG031) to indicate the maximum number of
                                                                 lanes supported. Note that less lanes than the specified maximum can be configured for use
                                                                 via the core's link control register (CFG032) negotiated link width field. */
        uint64_t laneswap              : 1;  /**< [  4:  4](R/W/H) Determines lane swapping. When set, lane swapping is
                                                                 performed to/from the SerDes. When clear, no lane swapping is performed. */
        uint64_t reserved_5_63         : 59;
#endif /* Word 0 - End */
    } cn88xx;
    struct bdk_pemx_cfg_cn83xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_5_63         : 59;
        uint64_t laneswap              : 1;  /**< [  4:  4](R/W/H) Enables overwriting the value for lane swapping. The reset value is captured on
                                                                 cold reset by the pin straps (see PEM()_STRAP[PILANESWAP]). When set, lane swapping is
                                                                 performed to/from the SerDes. When clear, no lane swapping is performed. */
        uint64_t lanes8                : 1;  /**< [  3:  3](R/W/H) Enables overwriting the value for the maximum number of lanes. The reset value
                                                                 is captured on cold reset by the pin straps (see PEM()_STRAP[PILANES8]). When set, the
                                                                 PEM is configured for a maximum of 8 lanes. When clear, the PEM is configured for a
                                                                 maximum of 4 or 2 lanes. This value is used to set the maximum link width field in the
                                                                 core's
                                                                 link capabilities register (CFG031) to indicate the maximum number of lanes
                                                                 supported. Note that less lanes than the specified maximum can be configured for use via
                                                                 the core's link control register (CFG032) negotiated link width field. */
        uint64_t hostmd                : 1;  /**< [  2:  2](R/W/H) Enables overwriting the value for host mode. The reset value is captured on
                                                                 cold reset by the pin straps. (See PEM()_STRAP[PIMODE]. The HOSTMD reset value is the
                                                                 bit-wise AND of the PIMODE straps.  When set, the PEM is configured to be a root complex.
                                                                 When clear, the PEM is configured to be an end point. */
        uint64_t md                    : 2;  /**< [  1:  0](R/W/H) Enables overwriting the value for speed. The reset value is captured on cold
                                                                 reset by the pin straps (see PEM()_STRAP[PIMODE]). For a root complex configuration
                                                                 that is not running at Gen3 speed, the HOSTMD bit of this register must be set when this
                                                                 field is changed.
                                                                 0x0 = Gen1 speed.
                                                                 0x1 = Gen2 speed.
                                                                 0x2 = Gen3 speed.
                                                                 0x3 = Reserved. */
#else /* Word 0 - Little Endian */
        uint64_t md                    : 2;  /**< [  1:  0](R/W/H) Enables overwriting the value for speed. The reset value is captured on cold
                                                                 reset by the pin straps (see PEM()_STRAP[PIMODE]). For a root complex configuration
                                                                 that is not running at Gen3 speed, the HOSTMD bit of this register must be set when this
                                                                 field is changed.
                                                                 0x0 = Gen1 speed.
                                                                 0x1 = Gen2 speed.
                                                                 0x2 = Gen3 speed.
                                                                 0x3 = Reserved. */
        uint64_t hostmd                : 1;  /**< [  2:  2](R/W/H) Enables overwriting the value for host mode. The reset value is captured on
                                                                 cold reset by the pin straps. (See PEM()_STRAP[PIMODE]. The HOSTMD reset value is the
                                                                 bit-wise AND of the PIMODE straps.  When set, the PEM is configured to be a root complex.
                                                                 When clear, the PEM is configured to be an end point. */
        uint64_t lanes8                : 1;  /**< [  3:  3](R/W/H) Enables overwriting the value for the maximum number of lanes. The reset value
                                                                 is captured on cold reset by the pin straps (see PEM()_STRAP[PILANES8]). When set, the
                                                                 PEM is configured for a maximum of 8 lanes. When clear, the PEM is configured for a
                                                                 maximum of 4 or 2 lanes. This value is used to set the maximum link width field in the
                                                                 core's
                                                                 link capabilities register (CFG031) to indicate the maximum number of lanes
                                                                 supported. Note that less lanes than the specified maximum can be configured for use via
                                                                 the core's link control register (CFG032) negotiated link width field. */
        uint64_t laneswap              : 1;  /**< [  4:  4](R/W/H) Enables overwriting the value for lane swapping. The reset value is captured on
                                                                 cold reset by the pin straps (see PEM()_STRAP[PILANESWAP]). When set, lane swapping is
                                                                 performed to/from the SerDes. When clear, no lane swapping is performed. */
        uint64_t reserved_5_63         : 59;
#endif /* Word 0 - End */
    } cn83xx;
};
typedef union bdk_pemx_cfg bdk_pemx_cfg_t;

static inline uint64_t BDK_PEMX_CFG(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_CFG(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN81XX) && (a<=2))
        return 0x87e0c0000410ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN83XX) && (a<=3))
        return 0x87e0c0000410ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN88XX) && (a<=5))
        return 0x87e0c0000410ll + 0x1000000ll * ((a) & 0x7);
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e00000000c8ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_CFG", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_CFG(a) bdk_pemx_cfg_t
#define bustype_BDK_PEMX_CFG(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_CFG(a) "PEMX_CFG"
#define device_bar_BDK_PEMX_CFG(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_CFG(a) (a)
#define arguments_BDK_PEMX_CFG(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_cfg_rd
 *
 * PEM Configuration Read Register
 * This register allows read access to the configuration in the PCIe core, but is for
 * legacy application use. PEM()_PF()_CS()_PFCFG() and PEM()_PF()_VF()_VFCFG() should
 * typically be used instead.
 *
 * This register is accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on MAC reset.
 */
union bdk_pemx_cfg_rd
{
    uint64_t u;
    struct bdk_pemx_cfg_rd_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t data                  : 32; /**< [ 63: 32](R/W/H) Data. */
        uint64_t addr                  : 32; /**< [ 31:  0](R/W/H) Address to read. A write to this register starts a read operation.
                                                                 Following are the sub-fields of the ADDR field.

                                                                 \<11:0\> The offset of the PCIe core CFG register being accessed. */
#else /* Word 0 - Little Endian */
        uint64_t addr                  : 32; /**< [ 31:  0](R/W/H) Address to read. A write to this register starts a read operation.
                                                                 Following are the sub-fields of the ADDR field.

                                                                 \<11:0\> The offset of the PCIe core CFG register being accessed. */
        uint64_t data                  : 32; /**< [ 63: 32](R/W/H) Data. */
#endif /* Word 0 - End */
    } s;
    struct bdk_pemx_cfg_rd_cn9
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t data                  : 32; /**< [ 63: 32](R/W/H) Data. */
        uint64_t addr                  : 32; /**< [ 31:  0](R/W) Address to read. A write to this register starts a read operation.
                                                                 Following are the subfields of [ADDR].

                                                                 \<31:30\> = Reserved. Must be zero.

                                                                 \<29:22\> = The selected virtual function. Must be zero when \<17\> is
                                                                           clear. Must be zero in RC mode.

                                                                 \<21:18\> = The selected physical function. Must be zero in RC mode.

                                                                 \<17\>    = When clear, the write accesses the physical function. When set,
                                                                           the write accesses the virtual function selected by \<29:22\>.
                                                                           Must be zero when SR-IOV is not used in the physical function.
                                                                           Must be zero in RC mode.

                                                                 \<16\>    = When clear, the write is the same as a config space write received
                                                                           from external. When set, the write can modify more fields than
                                                                           an external write could (i.e. configuration mask register).

                                                                           Corresponds to the CS2 field in Byte2 of the EEPROM.

                                                                 \<15\>    = Must be 1.

                                                                 \<14:12\> = Reserved. Must be zero.

                                                                 \<11:0\>  = Selects the PCIe config space register being written in the
                                                                         function.

                                                                 Internal:
                                                                 \<16\>    = asserts dbi_cs2 at PCIe core.
                                                                 \<17\>    = dbi_vfunc_active to the core.
                                                                 \<29:22\> = dbi_vfunc_num to the core. */
#else /* Word 0 - Little Endian */
        uint64_t addr                  : 32; /**< [ 31:  0](R/W) Address to read. A write to this register starts a read operation.
                                                                 Following are the subfields of [ADDR].

                                                                 \<31:30\> = Reserved. Must be zero.

                                                                 \<29:22\> = The selected virtual function. Must be zero when \<17\> is
                                                                           clear. Must be zero in RC mode.

                                                                 \<21:18\> = The selected physical function. Must be zero in RC mode.

                                                                 \<17\>    = When clear, the write accesses the physical function. When set,
                                                                           the write accesses the virtual function selected by \<29:22\>.
                                                                           Must be zero when SR-IOV is not used in the physical function.
                                                                           Must be zero in RC mode.

                                                                 \<16\>    = When clear, the write is the same as a config space write received
                                                                           from external. When set, the write can modify more fields than
                                                                           an external write could (i.e. configuration mask register).

                                                                           Corresponds to the CS2 field in Byte2 of the EEPROM.

                                                                 \<15\>    = Must be 1.

                                                                 \<14:12\> = Reserved. Must be zero.

                                                                 \<11:0\>  = Selects the PCIe config space register being written in the
                                                                         function.

                                                                 Internal:
                                                                 \<16\>    = asserts dbi_cs2 at PCIe core.
                                                                 \<17\>    = dbi_vfunc_active to the core.
                                                                 \<29:22\> = dbi_vfunc_num to the core. */
        uint64_t data                  : 32; /**< [ 63: 32](R/W/H) Data. */
#endif /* Word 0 - End */
    } cn9;
    /* struct bdk_pemx_cfg_rd_s cn81xx; */
    /* struct bdk_pemx_cfg_rd_s cn88xx; */
    struct bdk_pemx_cfg_rd_cn83xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t data                  : 32; /**< [ 63: 32](R/W/H) Data. */
        uint64_t addr                  : 32; /**< [ 31:  0](R/W) Address to read. A write to this register starts a read operation.
                                                                 Following are the subfields of the ADDR field.

                                                                 \<31:24\> = Reserved. Must be zero.

                                                                 \<23\>    = When clear, the read accesses the physical function. When set,
                                                                         the read accesses the virtual function selected by \<22:12\>.
                                                                         Must be zero when SR-IOV is not used in the physical function.
                                                                         Must be zero in RC mode.

                                                                 \<22:18\> = Reserved. Must be zero.

                                                                 \<17:12\> = The selected virtual function. Must be zero when \<23\> is
                                                                         clear. Must be zero in RC mode.

                                                                 \<11:0\>  = Selects the PCIe config space register being read in the
                                                                         function.

                                                                 Internal:
                                                                 \<31\>    = asserts dbi_cs2 at PCIe core.
                                                                   \<23\>    = dbi_vfunc_active to the core.
                                                                   \<22:12\> = dbi_vfunc_num to the core. */
#else /* Word 0 - Little Endian */
        uint64_t addr                  : 32; /**< [ 31:  0](R/W) Address to read. A write to this register starts a read operation.
                                                                 Following are the subfields of the ADDR field.

                                                                 \<31:24\> = Reserved. Must be zero.

                                                                 \<23\>    = When clear, the read accesses the physical function. When set,
                                                                         the read accesses the virtual function selected by \<22:12\>.
                                                                         Must be zero when SR-IOV is not used in the physical function.
                                                                         Must be zero in RC mode.

                                                                 \<22:18\> = Reserved. Must be zero.

                                                                 \<17:12\> = The selected virtual function. Must be zero when \<23\> is
                                                                         clear. Must be zero in RC mode.

                                                                 \<11:0\>  = Selects the PCIe config space register being read in the
                                                                         function.

                                                                 Internal:
                                                                 \<31\>    = asserts dbi_cs2 at PCIe core.
                                                                   \<23\>    = dbi_vfunc_active to the core.
                                                                   \<22:12\> = dbi_vfunc_num to the core. */
        uint64_t data                  : 32; /**< [ 63: 32](R/W/H) Data. */
#endif /* Word 0 - End */
    } cn83xx;
};
typedef union bdk_pemx_cfg_rd bdk_pemx_cfg_rd_t;

static inline uint64_t BDK_PEMX_CFG_RD(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_CFG_RD(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN81XX) && (a<=2))
        return 0x87e0c0000030ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN83XX) && (a<=3))
        return 0x87e0c0000030ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN88XX) && (a<=5))
        return 0x87e0c0000030ll + 0x1000000ll * ((a) & 0x7);
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e0000000020ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_CFG_RD", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_CFG_RD(a) bdk_pemx_cfg_rd_t
#define bustype_BDK_PEMX_CFG_RD(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_CFG_RD(a) "PEMX_CFG_RD"
#define device_bar_BDK_PEMX_CFG_RD(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_CFG_RD(a) (a)
#define arguments_BDK_PEMX_CFG_RD(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_cfg_tbl#
 *
 * PEM Configuration Table Registers
 * Software managed table with list of config registers to update when
 * PEM()_CTL_STATUS[LNK_ENB] is written with a 1. Typically the last
 * table action should be to set PEM()_CTL_STATUS[SCR_DONE].
 *
 * This register is accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on cold reset.
 */
union bdk_pemx_cfg_tblx
{
    uint64_t u;
    struct bdk_pemx_cfg_tblx_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t data                  : 32; /**< [ 63: 32](R/W) Data to write. */
        uint64_t broadcast             : 1;  /**< [ 31: 31](R/W) When set, [PF] field is ignored and the write will occur to every Physical Function.
                                                                 When set and [VF_ACTIVE] is set, write will occur to VF0 within every Physical Function. */
        uint64_t reserved_30           : 1;
        uint64_t vf                    : 8;  /**< [ 29: 22](R/W) The selected virtual function.  Must be zero when [VF_ACTIVE] is clear, or when configured
                                                                 for RC mode. */
        uint64_t pf                    : 4;  /**< [ 21: 18](R/W) Physical function number associated with this access. In RC mode, this
                                                                 field must be zero. */
        uint64_t vf_active             : 1;  /**< [ 17: 17](R/W) VF active.
                                                                 0 = Write accesses the physical function.
                                                                 1 = Write accesses the virtual function selected by [VF] belonging to [PF].

                                                                 Must be zero when SR-IOV is not used in the physical function.
                                                                 Must be zero in RC mode. */
        uint64_t shadow                : 1;  /**< [ 16: 16](R/W) Shadow space.
                                                                 0 = The destination CSR is the standard PCI configuration write register.
                                                                 This may write WRSL fields.
                                                                 1 = The destination is the shadow CSR space, e.g. PCIEEP_BAR0_MASKL. */
        uint64_t wmask                 : 4;  /**< [ 15: 12](R/W) Byte mask to apply when writing data. If set, the corresponding byte will be written. */
        uint64_t offset                : 12; /**< [ 11:  0](R/W) Selects the PCIe config space register being written in the function. */
#else /* Word 0 - Little Endian */
        uint64_t offset                : 12; /**< [ 11:  0](R/W) Selects the PCIe config space register being written in the function. */
        uint64_t wmask                 : 4;  /**< [ 15: 12](R/W) Byte mask to apply when writing data. If set, the corresponding byte will be written. */
        uint64_t shadow                : 1;  /**< [ 16: 16](R/W) Shadow space.
                                                                 0 = The destination CSR is the standard PCI configuration write register.
                                                                 This may write WRSL fields.
                                                                 1 = The destination is the shadow CSR space, e.g. PCIEEP_BAR0_MASKL. */
        uint64_t vf_active             : 1;  /**< [ 17: 17](R/W) VF active.
                                                                 0 = Write accesses the physical function.
                                                                 1 = Write accesses the virtual function selected by [VF] belonging to [PF].

                                                                 Must be zero when SR-IOV is not used in the physical function.
                                                                 Must be zero in RC mode. */
        uint64_t pf                    : 4;  /**< [ 21: 18](R/W) Physical function number associated with this access. In RC mode, this
                                                                 field must be zero. */
        uint64_t vf                    : 8;  /**< [ 29: 22](R/W) The selected virtual function.  Must be zero when [VF_ACTIVE] is clear, or when configured
                                                                 for RC mode. */
        uint64_t reserved_30           : 1;
        uint64_t broadcast             : 1;  /**< [ 31: 31](R/W) When set, [PF] field is ignored and the write will occur to every Physical Function.
                                                                 When set and [VF_ACTIVE] is set, write will occur to VF0 within every Physical Function. */
        uint64_t data                  : 32; /**< [ 63: 32](R/W) Data to write. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_cfg_tblx_s cn; */
};
typedef union bdk_pemx_cfg_tblx bdk_pemx_cfg_tblx_t;

static inline uint64_t BDK_PEMX_CFG_TBLX(unsigned long a, unsigned long b) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_CFG_TBLX(unsigned long a, unsigned long b)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && ((a<=3) && (b<=1023)))
        return 0x8e0000002000ll + 0x1000000000ll * ((a) & 0x3) + 8ll * ((b) & 0x3ff);
    __bdk_csr_fatal("PEMX_CFG_TBLX", 2, a, b, 0, 0);
}

#define typedef_BDK_PEMX_CFG_TBLX(a,b) bdk_pemx_cfg_tblx_t
#define bustype_BDK_PEMX_CFG_TBLX(a,b) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_CFG_TBLX(a,b) "PEMX_CFG_TBLX"
#define device_bar_BDK_PEMX_CFG_TBLX(a,b) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_CFG_TBLX(a,b) (a)
#define arguments_BDK_PEMX_CFG_TBLX(a,b) (a),(b),-1,-1

/**
 * Register (NCB) pem#_cfg_tbl_size
 *
 * PEM Configuration Table Size Register
 * This register is accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on cold reset.
 */
union bdk_pemx_cfg_tbl_size
{
    uint64_t u;
    struct bdk_pemx_cfg_tbl_size_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_11_63        : 53;
        uint64_t size                  : 11; /**< [ 10:  0](R/W) The number of valid entries in PEM()_CFG_TBL(). When hardware plays out the
                                                                 PEM()_CFG_TBL() table, it will read PEM()_CFG_TBL() entries 0x0 through
                                                                 [SIZE]-1, or take no action if [SIZE] is 0x0.

                                                                 Software, before rewriting PEM()_CFG_TBL(), should clear [SIZE], write all of
                                                                 the desired entries, then write the [SIZE] with the number of written entries. */
#else /* Word 0 - Little Endian */
        uint64_t size                  : 11; /**< [ 10:  0](R/W) The number of valid entries in PEM()_CFG_TBL(). When hardware plays out the
                                                                 PEM()_CFG_TBL() table, it will read PEM()_CFG_TBL() entries 0x0 through
                                                                 [SIZE]-1, or take no action if [SIZE] is 0x0.

                                                                 Software, before rewriting PEM()_CFG_TBL(), should clear [SIZE], write all of
                                                                 the desired entries, then write the [SIZE] with the number of written entries. */
        uint64_t reserved_11_63        : 53;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_cfg_tbl_size_s cn; */
};
typedef union bdk_pemx_cfg_tbl_size bdk_pemx_cfg_tbl_size_t;

static inline uint64_t BDK_PEMX_CFG_TBL_SIZE(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_CFG_TBL_SIZE(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e0000000218ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_CFG_TBL_SIZE", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_CFG_TBL_SIZE(a) bdk_pemx_cfg_tbl_size_t
#define bustype_BDK_PEMX_CFG_TBL_SIZE(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_CFG_TBL_SIZE(a) "PEMX_CFG_TBL_SIZE"
#define device_bar_BDK_PEMX_CFG_TBL_SIZE(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_CFG_TBL_SIZE(a) (a)
#define arguments_BDK_PEMX_CFG_TBL_SIZE(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_cfg_wr
 *
 * PEM Configuration Write Register
 * This register allows write access to the configuration in the PCIe core, but is for
 * legacy application use. PEM()_PF()_CS()_PFCFG() and PEM()_PF()_VF()_VFCFG() should
 * typically be used instead.
 *
 * This register is accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on MAC reset.
 */
union bdk_pemx_cfg_wr
{
    uint64_t u;
    struct bdk_pemx_cfg_wr_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t data                  : 32; /**< [ 63: 32](R/W/H) Data to write. A write to this register starts a write operation. */
        uint64_t addr                  : 32; /**< [ 31:  0](R/W/H) Address to write. A write to this register starts a write operation.
                                                                 Following are the sub-fields of the ADDR field.

                                                                 \<31\>   When set, asserts dbi_cs2 at PCIe core.
                                                                 \<11:0\> The offset of the PCIe core CFG register being accessed. */
#else /* Word 0 - Little Endian */
        uint64_t addr                  : 32; /**< [ 31:  0](R/W/H) Address to write. A write to this register starts a write operation.
                                                                 Following are the sub-fields of the ADDR field.

                                                                 \<31\>   When set, asserts dbi_cs2 at PCIe core.
                                                                 \<11:0\> The offset of the PCIe core CFG register being accessed. */
        uint64_t data                  : 32; /**< [ 63: 32](R/W/H) Data to write. A write to this register starts a write operation. */
#endif /* Word 0 - End */
    } s;
    struct bdk_pemx_cfg_wr_cn9
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t data                  : 32; /**< [ 63: 32](R/W) Data to write. A write to this register starts a write operation. */
        uint64_t addr                  : 32; /**< [ 31:  0](R/W) Address to write. A write to this register starts a write operation.
                                                                 Following are the subfields of [ADDR].

                                                                 \<31:30\> = Reserved. Must be zero.

                                                                 \<29:22\> = The selected virtual function. Must be zero when \<17\> is
                                                                           clear. Must be zero in RC mode.

                                                                 \<21:18\> = The selected physical function. Must be zero in RC mode.

                                                                 \<17\>    = When clear, the write accesses the physical function. When set,
                                                                           the write accesses the virtual function selected by \<29:22\>.
                                                                           Must be zero when SR-IOV is not used in the physical function.
                                                                           Must be zero in RC mode.

                                                                 \<16\>    = When clear, the write is the same as a config space write received
                                                                           from external. When set, the write can modify more fields than
                                                                           an external write could (i.e. configuration mask register).

                                                                           Corresponds to the CS2 field in Byte2 of the EEPROM.

                                                                 \<15\>    = Must be 1.

                                                                 \<14:12\> = Reserved. Must be zero.

                                                                 \<11:0\>  = Selects the PCIe config space register being written in the
                                                                         function.

                                                                 Internal:
                                                                 \<16\>    = asserts dbi_cs2 at PCIe core.
                                                                 \<17\>    = dbi_vfunc_active to the core.
                                                                 \<29:22\> = dbi_vfunc_num to the core. */
#else /* Word 0 - Little Endian */
        uint64_t addr                  : 32; /**< [ 31:  0](R/W) Address to write. A write to this register starts a write operation.
                                                                 Following are the subfields of [ADDR].

                                                                 \<31:30\> = Reserved. Must be zero.

                                                                 \<29:22\> = The selected virtual function. Must be zero when \<17\> is
                                                                           clear. Must be zero in RC mode.

                                                                 \<21:18\> = The selected physical function. Must be zero in RC mode.

                                                                 \<17\>    = When clear, the write accesses the physical function. When set,
                                                                           the write accesses the virtual function selected by \<29:22\>.
                                                                           Must be zero when SR-IOV is not used in the physical function.
                                                                           Must be zero in RC mode.

                                                                 \<16\>    = When clear, the write is the same as a config space write received
                                                                           from external. When set, the write can modify more fields than
                                                                           an external write could (i.e. configuration mask register).

                                                                           Corresponds to the CS2 field in Byte2 of the EEPROM.

                                                                 \<15\>    = Must be 1.

                                                                 \<14:12\> = Reserved. Must be zero.

                                                                 \<11:0\>  = Selects the PCIe config space register being written in the
                                                                         function.

                                                                 Internal:
                                                                 \<16\>    = asserts dbi_cs2 at PCIe core.
                                                                 \<17\>    = dbi_vfunc_active to the core.
                                                                 \<29:22\> = dbi_vfunc_num to the core. */
        uint64_t data                  : 32; /**< [ 63: 32](R/W) Data to write. A write to this register starts a write operation. */
#endif /* Word 0 - End */
    } cn9;
    /* struct bdk_pemx_cfg_wr_s cn81xx; */
    /* struct bdk_pemx_cfg_wr_s cn88xx; */
    struct bdk_pemx_cfg_wr_cn83xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t data                  : 32; /**< [ 63: 32](R/W) Data to write. A write to this register starts a write operation. */
        uint64_t addr                  : 32; /**< [ 31:  0](R/W) Address to write. A write to this register starts a write operation.
                                                                 Following are the subfields of the ADDR field.

                                                                 \<31\>    = When clear, the write is the same as a config space write received
                                                                         from external. When set, the write can modify more fields than
                                                                         an external write could (i.e. configuration mask register).

                                                                         Corresponds to the CS2 field in Byte2 of the EEPROM.

                                                                 \<30:24\> = Reserved. Must be zero.

                                                                 \<23\>    = When clear, the write accesses the physical function. When set,
                                                                         the write accesses the virtual function selected by \<22:12\>.
                                                                         Must be zero when SR-IOV is not used in the physical function.
                                                                         Must be zero in RC mode.

                                                                 \<22:18\> = Reserved. Must be zero.

                                                                 \<17:12\> = The selected virtual function. Must be zero when \<23\> is
                                                                         clear. Must be zero in RC mode.

                                                                 \<11:0\>  = Selects the PCIe config space register being written in the
                                                                         function.

                                                                 Internal:
                                                                 \<31\>    = asserts dbi_cs2 at PCIe core.
                                                                   \<23\>    = dbi_vfunc_active to the core.
                                                                   \<22:12\> = dbi_vfunc_num to the core. */
#else /* Word 0 - Little Endian */
        uint64_t addr                  : 32; /**< [ 31:  0](R/W) Address to write. A write to this register starts a write operation.
                                                                 Following are the subfields of the ADDR field.

                                                                 \<31\>    = When clear, the write is the same as a config space write received
                                                                         from external. When set, the write can modify more fields than
                                                                         an external write could (i.e. configuration mask register).

                                                                         Corresponds to the CS2 field in Byte2 of the EEPROM.

                                                                 \<30:24\> = Reserved. Must be zero.

                                                                 \<23\>    = When clear, the write accesses the physical function. When set,
                                                                         the write accesses the virtual function selected by \<22:12\>.
                                                                         Must be zero when SR-IOV is not used in the physical function.
                                                                         Must be zero in RC mode.

                                                                 \<22:18\> = Reserved. Must be zero.

                                                                 \<17:12\> = The selected virtual function. Must be zero when \<23\> is
                                                                         clear. Must be zero in RC mode.

                                                                 \<11:0\>  = Selects the PCIe config space register being written in the
                                                                         function.

                                                                 Internal:
                                                                 \<31\>    = asserts dbi_cs2 at PCIe core.
                                                                   \<23\>    = dbi_vfunc_active to the core.
                                                                   \<22:12\> = dbi_vfunc_num to the core. */
        uint64_t data                  : 32; /**< [ 63: 32](R/W) Data to write. A write to this register starts a write operation. */
#endif /* Word 0 - End */
    } cn83xx;
};
typedef union bdk_pemx_cfg_wr bdk_pemx_cfg_wr_t;

static inline uint64_t BDK_PEMX_CFG_WR(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_CFG_WR(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN81XX) && (a<=2))
        return 0x87e0c0000028ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN83XX) && (a<=3))
        return 0x87e0c0000028ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN88XX) && (a<=5))
        return 0x87e0c0000028ll + 0x1000000ll * ((a) & 0x7);
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e0000000018ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_CFG_WR", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_CFG_WR(a) bdk_pemx_cfg_wr_t
#define bustype_BDK_PEMX_CFG_WR(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_CFG_WR(a) "PEMX_CFG_WR"
#define device_bar_BDK_PEMX_CFG_WR(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_CFG_WR(a) (a)
#define arguments_BDK_PEMX_CFG_WR(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_clk_en
 *
 * PEM Clock Enable Register
 * This register contains the clock enable for CSCLK and PCE_CLK.
 *
 * This register is accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on cold reset.
 */
union bdk_pemx_clk_en
{
    uint64_t u;
    struct bdk_pemx_clk_en_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_5_63         : 59;
        uint64_t pemc_pceclkx_force    : 1;  /**< [  4:  4](R/W) When set, the pclk is forced on at all times to the PEM core MAC memories.
                                                                 When clear, the pclk to the PEM core MAC memories can be gated in hardware. */
        uint64_t pemc_macclk_force     : 1;  /**< [  3:  3](R/W) When set, aux_clk & radm_clk are forced on at all times to the PEM core MAC.
                                                                 When clear, aux_clk & radm_clk can be gated by the PEM core MAC. */
        uint64_t reserved_0_2          : 3;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0_2          : 3;
        uint64_t pemc_macclk_force     : 1;  /**< [  3:  3](R/W) When set, aux_clk & radm_clk are forced on at all times to the PEM core MAC.
                                                                 When clear, aux_clk & radm_clk can be gated by the PEM core MAC. */
        uint64_t pemc_pceclkx_force    : 1;  /**< [  4:  4](R/W) When set, the pclk is forced on at all times to the PEM core MAC memories.
                                                                 When clear, the pclk to the PEM core MAC memories can be gated in hardware. */
        uint64_t reserved_5_63         : 59;
#endif /* Word 0 - End */
    } s;
    struct bdk_pemx_clk_en_cn9
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_5_63         : 59;
        uint64_t pemc_pceclkx_force    : 1;  /**< [  4:  4](R/W) When set, the pclk is forced on at all times to the PEM core MAC memories.
                                                                 When clear, the pclk to the PEM core MAC memories can be gated in hardware. */
        uint64_t pemc_macclk_force     : 1;  /**< [  3:  3](R/W) When set, aux_clk & radm_clk are forced on at all times to the PEM core MAC.
                                                                 When clear, aux_clk & radm_clk can be gated by the PEM core MAC. */
        uint64_t pceclk_gate           : 1;  /**< [  2:  2](R/W) When set, PCE_CLK is gated off in PEM core.
                                                                 When clear, PCE_CLK is enabled in PEM core. */
        uint64_t pemc_csclk_gate       : 1;  /**< [  1:  1](R/W) When set, SCLK is gated off in PEM core.
                                                                 When clear, SCLK is enabled in PEM core. */
        uint64_t pemm_csclk_force      : 1;  /**< [  0:  0](R/W) When set, CSCLK is forced on at all times in PEM main.
                                                                 When clear, CSCLK gating in PEM main is controlled by hardware. */
#else /* Word 0 - Little Endian */
        uint64_t pemm_csclk_force      : 1;  /**< [  0:  0](R/W) When set, CSCLK is forced on at all times in PEM main.
                                                                 When clear, CSCLK gating in PEM main is controlled by hardware. */
        uint64_t pemc_csclk_gate       : 1;  /**< [  1:  1](R/W) When set, SCLK is gated off in PEM core.
                                                                 When clear, SCLK is enabled in PEM core. */
        uint64_t pceclk_gate           : 1;  /**< [  2:  2](R/W) When set, PCE_CLK is gated off in PEM core.
                                                                 When clear, PCE_CLK is enabled in PEM core. */
        uint64_t pemc_macclk_force     : 1;  /**< [  3:  3](R/W) When set, aux_clk & radm_clk are forced on at all times to the PEM core MAC.
                                                                 When clear, aux_clk & radm_clk can be gated by the PEM core MAC. */
        uint64_t pemc_pceclkx_force    : 1;  /**< [  4:  4](R/W) When set, the pclk is forced on at all times to the PEM core MAC memories.
                                                                 When clear, the pclk to the PEM core MAC memories can be gated in hardware. */
        uint64_t reserved_5_63         : 59;
#endif /* Word 0 - End */
    } cn9;
    struct bdk_pemx_clk_en_cn81xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_2_63         : 62;
        uint64_t pceclk_gate           : 1;  /**< [  1:  1](R/W/H) When set, PCE_CLK is gated off. When clear, PCE_CLK is enabled.
                                                                 Software should set this bit when the PEM is in reset or otherwise not
                                                                 being used in order to reduce power. */
        uint64_t csclk_gate            : 1;  /**< [  0:  0](R/W/H) When set, CSCLK is gated off. When clear, CSCLK is enabled.
                                                                 Software should set this bit when the PEM is in reset or otherwise not
                                                                 being used in order to reduce power. */
#else /* Word 0 - Little Endian */
        uint64_t csclk_gate            : 1;  /**< [  0:  0](R/W/H) When set, CSCLK is gated off. When clear, CSCLK is enabled.
                                                                 Software should set this bit when the PEM is in reset or otherwise not
                                                                 being used in order to reduce power. */
        uint64_t pceclk_gate           : 1;  /**< [  1:  1](R/W/H) When set, PCE_CLK is gated off. When clear, PCE_CLK is enabled.
                                                                 Software should set this bit when the PEM is in reset or otherwise not
                                                                 being used in order to reduce power. */
        uint64_t reserved_2_63         : 62;
#endif /* Word 0 - End */
    } cn81xx;
    /* struct bdk_pemx_clk_en_cn81xx cn88xx; */
    struct bdk_pemx_clk_en_cn83xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_2_63         : 62;
        uint64_t pceclk_gate           : 1;  /**< [  1:  1](R/W/H) When set, PCE_CLK is gated off. When clear, PCE_CLK is enabled.
                                                                 PEM0 & PEM2 will come up with clocks disabled when configured as
                                                                 an RC i.e. PEM()_STRAP[PIMODE] set to 0x3.
                                                                 PEM1 & PEM3 always come up with clocks disabled. */
        uint64_t csclk_gate            : 1;  /**< [  0:  0](R/W/H) When set, ECLK is gated off. When clear, ECLK is enabled.
                                                                 PEM0 & PEM2 will come up with clocks disabled when configured as
                                                                 an RC i.e. PEM()_STRAP[PIMODE] set to 0x3.
                                                                 PEM1 & PEM3 always come up with clocks disabled. */
#else /* Word 0 - Little Endian */
        uint64_t csclk_gate            : 1;  /**< [  0:  0](R/W/H) When set, ECLK is gated off. When clear, ECLK is enabled.
                                                                 PEM0 & PEM2 will come up with clocks disabled when configured as
                                                                 an RC i.e. PEM()_STRAP[PIMODE] set to 0x3.
                                                                 PEM1 & PEM3 always come up with clocks disabled. */
        uint64_t pceclk_gate           : 1;  /**< [  1:  1](R/W/H) When set, PCE_CLK is gated off. When clear, PCE_CLK is enabled.
                                                                 PEM0 & PEM2 will come up with clocks disabled when configured as
                                                                 an RC i.e. PEM()_STRAP[PIMODE] set to 0x3.
                                                                 PEM1 & PEM3 always come up with clocks disabled. */
        uint64_t reserved_2_63         : 62;
#endif /* Word 0 - End */
    } cn83xx;
};
typedef union bdk_pemx_clk_en bdk_pemx_clk_en_t;

static inline uint64_t BDK_PEMX_CLK_EN(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_CLK_EN(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN81XX) && (a<=2))
        return 0x87e0c0000400ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN83XX) && (a<=3))
        return 0x87e0c0000400ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN88XX) && (a<=5))
        return 0x87e0c0000400ll + 0x1000000ll * ((a) & 0x7);
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e00000000b8ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_CLK_EN", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_CLK_EN(a) bdk_pemx_clk_en_t
#define bustype_BDK_PEMX_CLK_EN(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_CLK_EN(a) "PEMX_CLK_EN"
#define device_bar_BDK_PEMX_CLK_EN(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_CLK_EN(a) (a)
#define arguments_BDK_PEMX_CLK_EN(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_cmerge_merged_pc
 *
 * PEM Merge Completions Merged Performance Counter Register
 * This register is a performance counter of how many completions merged within the
 * outbound completion merge units.
 *
 * This register is not accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on PEM domain reset.
 */
union bdk_pemx_cmerge_merged_pc
{
    uint64_t u;
    struct bdk_pemx_cmerge_merged_pc_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t cmerge_merged         : 64; /**< [ 63:  0](R/W/H) Each NCBO completion operation that merges with a previous
                                                                 read will increment this count. */
#else /* Word 0 - Little Endian */
        uint64_t cmerge_merged         : 64; /**< [ 63:  0](R/W/H) Each NCBO completion operation that merges with a previous
                                                                 read will increment this count. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_cmerge_merged_pc_s cn; */
};
typedef union bdk_pemx_cmerge_merged_pc bdk_pemx_cmerge_merged_pc_t;

static inline uint64_t BDK_PEMX_CMERGE_MERGED_PC(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_CMERGE_MERGED_PC(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e00000001a8ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_CMERGE_MERGED_PC", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_CMERGE_MERGED_PC(a) bdk_pemx_cmerge_merged_pc_t
#define bustype_BDK_PEMX_CMERGE_MERGED_PC(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_CMERGE_MERGED_PC(a) "PEMX_CMERGE_MERGED_PC"
#define device_bar_BDK_PEMX_CMERGE_MERGED_PC(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_CMERGE_MERGED_PC(a) (a)
#define arguments_BDK_PEMX_CMERGE_MERGED_PC(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_cmerge_received_pc
 *
 * PEM Merge Completions Received Performance Counter Register
 * This register reports the number of reads that enter the outbound read merge unit.
 *
 * This register is not accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on PEM domain reset.
 */
union bdk_pemx_cmerge_received_pc
{
    uint64_t u;
    struct bdk_pemx_cmerge_received_pc_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t cmerge_reads          : 64; /**< [ 63:  0](R/W/H) Each NCBO completion operation increments this count. */
#else /* Word 0 - Little Endian */
        uint64_t cmerge_reads          : 64; /**< [ 63:  0](R/W/H) Each NCBO completion operation increments this count. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_cmerge_received_pc_s cn; */
};
typedef union bdk_pemx_cmerge_received_pc bdk_pemx_cmerge_received_pc_t;

static inline uint64_t BDK_PEMX_CMERGE_RECEIVED_PC(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_CMERGE_RECEIVED_PC(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e00000001a0ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_CMERGE_RECEIVED_PC", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_CMERGE_RECEIVED_PC(a) bdk_pemx_cmerge_received_pc_t
#define bustype_BDK_PEMX_CMERGE_RECEIVED_PC(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_CMERGE_RECEIVED_PC(a) "PEMX_CMERGE_RECEIVED_PC"
#define device_bar_BDK_PEMX_CMERGE_RECEIVED_PC(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_CMERGE_RECEIVED_PC(a) (a)
#define arguments_BDK_PEMX_CMERGE_RECEIVED_PC(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_const_acc
 *
 * PEM Constant ACC Register
 * Contains contant attributes related to the PEM ACC tables.
 */
union bdk_pemx_const_acc
{
    uint64_t u;
    struct bdk_pemx_const_acc_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t bits_huge             : 16; /**< [ 63: 48](RO) Number of bits in the address aperture for a huge-sized ACC table entry. See
                                                                 PEM()_REG_HUGE()_ACC. */
        uint64_t num_huge              : 16; /**< [ 47: 32](RO) Number of huge-sized ACC table entries. See PEM()_REG_HUGE()_ACC. */
        uint64_t bits_norm             : 16; /**< [ 31: 16](RO) Number of bits in the address aperture for a normal-sized ACC table entry. See
                                                                 PEM()_REG_NORM()_ACC. */
        uint64_t num_norm              : 16; /**< [ 15:  0](RO) Number of normal-sized ACC table entries. See PEM()_REG_NORM()_ACC. */
#else /* Word 0 - Little Endian */
        uint64_t num_norm              : 16; /**< [ 15:  0](RO) Number of normal-sized ACC table entries. See PEM()_REG_NORM()_ACC. */
        uint64_t bits_norm             : 16; /**< [ 31: 16](RO) Number of bits in the address aperture for a normal-sized ACC table entry. See
                                                                 PEM()_REG_NORM()_ACC. */
        uint64_t num_huge              : 16; /**< [ 47: 32](RO) Number of huge-sized ACC table entries. See PEM()_REG_HUGE()_ACC. */
        uint64_t bits_huge             : 16; /**< [ 63: 48](RO) Number of bits in the address aperture for a huge-sized ACC table entry. See
                                                                 PEM()_REG_HUGE()_ACC. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_const_acc_s cn; */
};
typedef union bdk_pemx_const_acc bdk_pemx_const_acc_t;

static inline uint64_t BDK_PEMX_CONST_ACC(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_CONST_ACC(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e0000000210ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_CONST_ACC", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_CONST_ACC(a) bdk_pemx_const_acc_t
#define bustype_BDK_PEMX_CONST_ACC(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_CONST_ACC(a) "PEMX_CONST_ACC"
#define device_bar_BDK_PEMX_CONST_ACC(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_CONST_ACC(a) (a)
#define arguments_BDK_PEMX_CONST_ACC(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_cpl_lut_valid
 *
 * PEM Completion Lookup Table Valid Register
 * This register specifies how many tags are outstanding for reads.
 *
 * This register is not accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on MAC reset.
 */
union bdk_pemx_cpl_lut_valid
{
    uint64_t u;
    struct bdk_pemx_cpl_lut_valid_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t tag                   : 64; /**< [ 63:  0](RO/H) Bit vector set corresponds to an outstanding tag. */
#else /* Word 0 - Little Endian */
        uint64_t tag                   : 64; /**< [ 63:  0](RO/H) Bit vector set corresponds to an outstanding tag. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_cpl_lut_valid_s cn8; */
    struct bdk_pemx_cpl_lut_valid_cn9
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_10_63        : 54;
        uint64_t tag                   : 10; /**< [  9:  0](RO/H) Number of read tags outstanding for outbound reads on PCIe. */
#else /* Word 0 - Little Endian */
        uint64_t tag                   : 10; /**< [  9:  0](RO/H) Number of read tags outstanding for outbound reads on PCIe. */
        uint64_t reserved_10_63        : 54;
#endif /* Word 0 - End */
    } cn9;
};
typedef union bdk_pemx_cpl_lut_valid bdk_pemx_cpl_lut_valid_t;

static inline uint64_t BDK_PEMX_CPL_LUT_VALID(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_CPL_LUT_VALID(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN81XX) && (a<=2))
        return 0x87e0c0000098ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN83XX) && (a<=3))
        return 0x87e0c0000098ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN88XX) && (a<=5))
        return 0x87e0c0000098ll + 0x1000000ll * ((a) & 0x7);
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e0000000038ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_CPL_LUT_VALID", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_CPL_LUT_VALID(a) bdk_pemx_cpl_lut_valid_t
#define bustype_BDK_PEMX_CPL_LUT_VALID(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_CPL_LUT_VALID(a) "PEMX_CPL_LUT_VALID"
#define device_bar_BDK_PEMX_CPL_LUT_VALID(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_CPL_LUT_VALID(a) (a)
#define arguments_BDK_PEMX_CPL_LUT_VALID(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_csclk_active_pc
 *
 * PEM Conditional Coprocessor Clock Counter Register
 * This register counts conditional clocks for power management.
 *
 * This register is not accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on PEM domain reset.
 */
union bdk_pemx_csclk_active_pc
{
    uint64_t u;
    struct bdk_pemx_csclk_active_pc_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t count                 : 64; /**< [ 63:  0](R/W/H) Count of conditional coprocessor-clock cycles since reset. */
#else /* Word 0 - Little Endian */
        uint64_t count                 : 64; /**< [ 63:  0](R/W/H) Count of conditional coprocessor-clock cycles since reset. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_csclk_active_pc_s cn; */
};
typedef union bdk_pemx_csclk_active_pc bdk_pemx_csclk_active_pc_t;

static inline uint64_t BDK_PEMX_CSCLK_ACTIVE_PC(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_CSCLK_ACTIVE_PC(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e0000000050ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_CSCLK_ACTIVE_PC", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_CSCLK_ACTIVE_PC(a) bdk_pemx_csclk_active_pc_t
#define bustype_BDK_PEMX_CSCLK_ACTIVE_PC(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_CSCLK_ACTIVE_PC(a) "PEMX_CSCLK_ACTIVE_PC"
#define device_bar_BDK_PEMX_CSCLK_ACTIVE_PC(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_CSCLK_ACTIVE_PC(a) (a)
#define arguments_BDK_PEMX_CSCLK_ACTIVE_PC(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_ctl_status
 *
 * PEM Control Status Register
 * This is a general control and status register of the PEM.
 *
 * This register is accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on MAC cold reset. Note this differs from PEM()_CTL_STATUS2's reset.
 */
union bdk_pemx_ctl_status
{
    uint64_t u;
    struct bdk_pemx_ctl_status_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_55_63        : 9;
        uint64_t inb_grant_limit       : 3;  /**< [ 54: 52](R/W) The number of inbound TLPs allowed in flight in PEM. */
        uint64_t rd_flt                : 1;  /**< [ 51: 51](RO) Read fault.

                                                                   0 = A PCIe non-config read which is terminated by PCIe with an error (UR, etc) will
                                                                       return to the NCB/cores all-ones and non-fault.
                                                                       This is compatible with CN88XX pass 1.0.
                                                                   1 = A PCIe non-config read which is terminated by PCIe with an error (UR, etc) will
                                                                       return to the NCB/cores all-ones and fault. In the case of a read by a core,
                                                                       this fault will cause a synchronous external abort in the core.

                                                                 Config reads which are terminated by PCIe with an error (UR, etc), or config reads
                                                                 when the PEM is disabled or link is down, will return to the NCB/cores all-ones and
                                                                 non-fault regardless of this bit. */
        uint64_t inv_dpar              : 1;  /**< [ 50: 50](R/W) Invert the generated parity to be written into the most significant data queue buffer RAM
                                                                 block to force a parity error when it is later read. */
        uint64_t reserved_32_49        : 18;
        uint64_t cfg_rtry              : 16; /**< [ 31: 16](R/W) The time in units of 0x10000 in coprocessor clocks to wait for a CPL to a
                                                                 configuration read that does not carry a retry status. Until such time that the
                                                                 timeout occurs and retry status is received for a configuration read, the read
                                                                 will be resent. A value of 0 disables retries and treats a CPL retry as a CPL
                                                                 UR.

                                                                 To use, it is recommended [CFG_RTRY] be set value corresponding to 200ms or
                                                                 less, although the PCI Express Base Specification allows up to 900ms for a
                                                                 device to send a successful completion.  When enabled, only one CFG RD may be
                                                                 issued until either successful completion or CPL UR. */
        uint64_t reserved_12_15        : 4;
        uint64_t pm_xtoff              : 1;  /**< [ 11: 11](R/W/H) When written with one, a single cycle pulse is sent to the PCIe core pm_xmt_turnoff port. RC mode. */
        uint64_t pm_xpme               : 1;  /**< [ 10: 10](R/W/H) When written with one, a single cycle pulse is sent to the PCIe core pm_xmt_pme port. EP mode. */
        uint64_t ob_p_cmd              : 1;  /**< [  9:  9](R/W/H) When written with one, a single cycle pulse is sent to the PCIe core outband_pwrup_cmd
                                                                 port. EP mode. */
        uint64_t clk_req_n             : 1;  /**< [  8:  8](R/W) Indicates that the application logic is ready to have reference clock
                                                                 removed.  The application should set this signal when it is ready to
                                                                 have reference clock removed trhough either L1 PM Sub-states or L1 CPM.
                                                                 If the application does not want to remove reference clock it should
                                                                 set this clear this bit.

                                                                 Internal:
                                                                 Controls app_clk_req_n input to the DW core. */
        uint64_t rdy_entr_l23          : 1;  /**< [  7:  7](R/W) Application ready to enter L23.  Indication that the application is
                                                                 ready to enter the L23 state. This provides control of the L23 entry
                                                                 (in case certain tasks must be performed before going into L23).
                                                                 The Mac delays sending PM_Enter_L23 (in response to PM_Turn_Off)
                                                                 until this signal becomes active. When this signal has been asserted
                                                                 by the application, it must be kept asserted until L2 entry has completed

                                                                 Internal:
                                                                 Controls app_ready_entr_l23 input to the DW core. */
        uint64_t reserved_5_6          : 2;
        uint64_t lnk_enb               : 1;  /**< [  4:  4](R/W) When set, the link is enabled; when clear (0) the link is disabled. This bit only is
                                                                 active when in RC mode. */
        uint64_t reserved_3            : 1;
        uint64_t fast_lm               : 1;  /**< [  2:  2](R/W) When set, forces fast link mode. */
        uint64_t inv_ecrc              : 1;  /**< [  1:  1](R/W) When set, causes the LSB of the ECRC to be inverted. */
        uint64_t inv_lcrc              : 1;  /**< [  0:  0](R/W) When set, causes the LSB of the LCRC to be inverted. */
#else /* Word 0 - Little Endian */
        uint64_t inv_lcrc              : 1;  /**< [  0:  0](R/W) When set, causes the LSB of the LCRC to be inverted. */
        uint64_t inv_ecrc              : 1;  /**< [  1:  1](R/W) When set, causes the LSB of the ECRC to be inverted. */
        uint64_t fast_lm               : 1;  /**< [  2:  2](R/W) When set, forces fast link mode. */
        uint64_t reserved_3            : 1;
        uint64_t lnk_enb               : 1;  /**< [  4:  4](R/W) When set, the link is enabled; when clear (0) the link is disabled. This bit only is
                                                                 active when in RC mode. */
        uint64_t reserved_5_6          : 2;
        uint64_t rdy_entr_l23          : 1;  /**< [  7:  7](R/W) Application ready to enter L23.  Indication that the application is
                                                                 ready to enter the L23 state. This provides control of the L23 entry
                                                                 (in case certain tasks must be performed before going into L23).
                                                                 The Mac delays sending PM_Enter_L23 (in response to PM_Turn_Off)
                                                                 until this signal becomes active. When this signal has been asserted
                                                                 by the application, it must be kept asserted until L2 entry has completed

                                                                 Internal:
                                                                 Controls app_ready_entr_l23 input to the DW core. */
        uint64_t clk_req_n             : 1;  /**< [  8:  8](R/W) Indicates that the application logic is ready to have reference clock
                                                                 removed.  The application should set this signal when it is ready to
                                                                 have reference clock removed trhough either L1 PM Sub-states or L1 CPM.
                                                                 If the application does not want to remove reference clock it should
                                                                 set this clear this bit.

                                                                 Internal:
                                                                 Controls app_clk_req_n input to the DW core. */
        uint64_t ob_p_cmd              : 1;  /**< [  9:  9](R/W/H) When written with one, a single cycle pulse is sent to the PCIe core outband_pwrup_cmd
                                                                 port. EP mode. */
        uint64_t pm_xpme               : 1;  /**< [ 10: 10](R/W/H) When written with one, a single cycle pulse is sent to the PCIe core pm_xmt_pme port. EP mode. */
        uint64_t pm_xtoff              : 1;  /**< [ 11: 11](R/W/H) When written with one, a single cycle pulse is sent to the PCIe core pm_xmt_turnoff port. RC mode. */
        uint64_t reserved_12_15        : 4;
        uint64_t cfg_rtry              : 16; /**< [ 31: 16](R/W) The time in units of 0x10000 in coprocessor clocks to wait for a CPL to a
                                                                 configuration read that does not carry a retry status. Until such time that the
                                                                 timeout occurs and retry status is received for a configuration read, the read
                                                                 will be resent. A value of 0 disables retries and treats a CPL retry as a CPL
                                                                 UR.

                                                                 To use, it is recommended [CFG_RTRY] be set value corresponding to 200ms or
                                                                 less, although the PCI Express Base Specification allows up to 900ms for a
                                                                 device to send a successful completion.  When enabled, only one CFG RD may be
                                                                 issued until either successful completion or CPL UR. */
        uint64_t reserved_32_49        : 18;
        uint64_t inv_dpar              : 1;  /**< [ 50: 50](R/W) Invert the generated parity to be written into the most significant data queue buffer RAM
                                                                 block to force a parity error when it is later read. */
        uint64_t rd_flt                : 1;  /**< [ 51: 51](RO) Read fault.

                                                                   0 = A PCIe non-config read which is terminated by PCIe with an error (UR, etc) will
                                                                       return to the NCB/cores all-ones and non-fault.
                                                                       This is compatible with CN88XX pass 1.0.
                                                                   1 = A PCIe non-config read which is terminated by PCIe with an error (UR, etc) will
                                                                       return to the NCB/cores all-ones and fault. In the case of a read by a core,
                                                                       this fault will cause a synchronous external abort in the core.

                                                                 Config reads which are terminated by PCIe with an error (UR, etc), or config reads
                                                                 when the PEM is disabled or link is down, will return to the NCB/cores all-ones and
                                                                 non-fault regardless of this bit. */
        uint64_t inb_grant_limit       : 3;  /**< [ 54: 52](R/W) The number of inbound TLPs allowed in flight in PEM. */
        uint64_t reserved_55_63        : 9;
#endif /* Word 0 - End */
    } s;
    struct bdk_pemx_ctl_status_cn88xxp1
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_52_63        : 12;
        uint64_t rd_flt                : 1;  /**< [ 51: 51](RO) Read fault.

                                                                   0 = A PCIe non-config read which is terminated by PCIe with an error (UR, etc) will
                                                                       return to the NCB/cores all-ones and non-fault.
                                                                       This is compatible with CN88XX pass 1.0.
                                                                   1 = A PCIe non-config read which is terminated by PCIe with an error (UR, etc) will
                                                                       return to the NCB/cores all-ones and fault. In the case of a read by a core,
                                                                       this fault will cause a synchronous external abort in the core.

                                                                 Config reads which are terminated by PCIe with an error (UR, etc), or config reads
                                                                 when the PEM is disabled or link is down, will return to the NCB/cores all-ones and
                                                                 non-fault regardless of this bit. */
        uint64_t inv_dpar              : 1;  /**< [ 50: 50](R/W) Invert the generated parity to be written into the most significant data queue buffer RAM
                                                                 block to force a parity error when it is later read. */
        uint64_t reserved_48_49        : 2;
        uint64_t auto_sd               : 1;  /**< [ 47: 47](RO/H) Link hardware autonomous speed disable. */
        uint64_t dnum                  : 5;  /**< [ 46: 42](RO/H) Primary bus device number. */
        uint64_t pbus                  : 8;  /**< [ 41: 34](RO/H) Primary bus number. */
        uint64_t reserved_32_33        : 2;
        uint64_t cfg_rtry              : 16; /**< [ 31: 16](R/W) The time in units of 0x10000 in coprocessor clocks to wait for a CPL to a
                                                                 configuration read that does not carry a retry status. Until such time that the
                                                                 timeout occurs and retry status is received for a configuration read, the read
                                                                 will be resent. A value of 0 disables retries and treats a CPL retry as a CPL
                                                                 UR.

                                                                 To use, it is recommended [CFG_RTRY] be set value corresponding to 200ms or
                                                                 less, although the PCI Express Base Specification allows up to 900ms for a
                                                                 device to send a successful completion.  When enabled, only one CFG RD may be
                                                                 issued until either successful completion or CPL UR. */
        uint64_t spares                : 4;  /**< [ 15: 12](R/W) Spare flops. */
        uint64_t pm_xtoff              : 1;  /**< [ 11: 11](R/W/H) When written with one, a single cycle pulse is sent to the PCIe core pm_xmt_turnoff port. RC mode. */
        uint64_t reserved_6_10         : 5;
        uint64_t dly_one               : 1;  /**< [  5:  5](R/W/H) When set the output client state machines will wait one cycle before starting a new TLP out. */
        uint64_t lnk_enb               : 1;  /**< [  4:  4](R/W) When set, the link is enabled; when clear (0) the link is disabled. This bit only is
                                                                 active when in RC mode. */
        uint64_t ro_ctlp               : 1;  /**< [  3:  3](R/W) When set, C-TLPs that have the RO bit set will not wait for P-TLPs that are normally sent first. */
        uint64_t fast_lm               : 1;  /**< [  2:  2](R/W) When set, forces fast link mode. */
        uint64_t inv_ecrc              : 1;  /**< [  1:  1](R/W) When set, causes the LSB of the ECRC to be inverted. */
        uint64_t inv_lcrc              : 1;  /**< [  0:  0](R/W) When set, causes the LSB of the LCRC to be inverted. */
#else /* Word 0 - Little Endian */
        uint64_t inv_lcrc              : 1;  /**< [  0:  0](R/W) When set, causes the LSB of the LCRC to be inverted. */
        uint64_t inv_ecrc              : 1;  /**< [  1:  1](R/W) When set, causes the LSB of the ECRC to be inverted. */
        uint64_t fast_lm               : 1;  /**< [  2:  2](R/W) When set, forces fast link mode. */
        uint64_t ro_ctlp               : 1;  /**< [  3:  3](R/W) When set, C-TLPs that have the RO bit set will not wait for P-TLPs that are normally sent first. */
        uint64_t lnk_enb               : 1;  /**< [  4:  4](R/W) When set, the link is enabled; when clear (0) the link is disabled. This bit only is
                                                                 active when in RC mode. */
        uint64_t dly_one               : 1;  /**< [  5:  5](R/W/H) When set the output client state machines will wait one cycle before starting a new TLP out. */
        uint64_t reserved_6_10         : 5;
        uint64_t pm_xtoff              : 1;  /**< [ 11: 11](R/W/H) When written with one, a single cycle pulse is sent to the PCIe core pm_xmt_turnoff port. RC mode. */
        uint64_t spares                : 4;  /**< [ 15: 12](R/W) Spare flops. */
        uint64_t cfg_rtry              : 16; /**< [ 31: 16](R/W) The time in units of 0x10000 in coprocessor clocks to wait for a CPL to a
                                                                 configuration read that does not carry a retry status. Until such time that the
                                                                 timeout occurs and retry status is received for a configuration read, the read
                                                                 will be resent. A value of 0 disables retries and treats a CPL retry as a CPL
                                                                 UR.

                                                                 To use, it is recommended [CFG_RTRY] be set value corresponding to 200ms or
                                                                 less, although the PCI Express Base Specification allows up to 900ms for a
                                                                 device to send a successful completion.  When enabled, only one CFG RD may be
                                                                 issued until either successful completion or CPL UR. */
        uint64_t reserved_32_33        : 2;
        uint64_t pbus                  : 8;  /**< [ 41: 34](RO/H) Primary bus number. */
        uint64_t dnum                  : 5;  /**< [ 46: 42](RO/H) Primary bus device number. */
        uint64_t auto_sd               : 1;  /**< [ 47: 47](RO/H) Link hardware autonomous speed disable. */
        uint64_t reserved_48_49        : 2;
        uint64_t inv_dpar              : 1;  /**< [ 50: 50](R/W) Invert the generated parity to be written into the most significant data queue buffer RAM
                                                                 block to force a parity error when it is later read. */
        uint64_t rd_flt                : 1;  /**< [ 51: 51](RO) Read fault.

                                                                   0 = A PCIe non-config read which is terminated by PCIe with an error (UR, etc) will
                                                                       return to the NCB/cores all-ones and non-fault.
                                                                       This is compatible with CN88XX pass 1.0.
                                                                   1 = A PCIe non-config read which is terminated by PCIe with an error (UR, etc) will
                                                                       return to the NCB/cores all-ones and fault. In the case of a read by a core,
                                                                       this fault will cause a synchronous external abort in the core.

                                                                 Config reads which are terminated by PCIe with an error (UR, etc), or config reads
                                                                 when the PEM is disabled or link is down, will return to the NCB/cores all-ones and
                                                                 non-fault regardless of this bit. */
        uint64_t reserved_52_63        : 12;
#endif /* Word 0 - End */
    } cn88xxp1;
    struct bdk_pemx_ctl_status_cn9
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_46_63        : 18;
        uint64_t auto_sd               : 1;  /**< [ 45: 45](RO/H) Link hardware autonomous speed disable. */
        uint64_t dnum                  : 5;  /**< [ 44: 40](RO/H) Primary bus device number. */
        uint64_t pbus                  : 8;  /**< [ 39: 32](RO/H) Primary bus number. */
        uint64_t reserved_16_31        : 16;
        uint64_t spares                : 3;  /**< [ 15: 13](R/W) Spare flops. */
        uint64_t scr_done              : 1;  /**< [ 12: 12](R/W) The ROM script (if present) can test this bit to see if the ROM script has
                                                                 already run. Typical usage is for the ROM script to test [SCR_DONE] and exit if
                                                                 true, else at the end of the ROM script, the script sets this bit. */
        uint64_t pm_xtoff              : 1;  /**< [ 11: 11](WO) When written with one, a single cycle pulse to request from application
                                                                 to generate a PM_Turn_Off message. RC mode.

                                                                 Internal:
                                                                 Controls apps_pm_xmt_turnoff input to the DW core. */
        uint64_t reserved_9_10         : 2;
        uint64_t clk_req_n             : 1;  /**< [  8:  8](R/W) Indicates that the application logic is ready to have reference clock
                                                                 removed.  The application should set this signal when it is ready to
                                                                 have reference clock removed trhough either L1 PM Sub-states or L1 CPM.
                                                                 If the application does not want to remove reference clock it should
                                                                 set this clear this bit.

                                                                 Internal:
                                                                 Controls app_clk_req_n input to the DW core. */
        uint64_t rdy_entr_l23          : 1;  /**< [  7:  7](R/W) Application ready to enter L23.  Indication that the application is
                                                                 ready to enter the L23 state. This provides control of the L23 entry
                                                                 (in case certain tasks must be performed before going into L23).
                                                                 The Mac delays sending PM_Enter_L23 (in response to PM_Turn_Off)
                                                                 until this signal becomes active. When this signal has been asserted
                                                                 by the application, it must be kept asserted until L2 entry has completed

                                                                 Internal:
                                                                 Controls app_ready_entr_l23 input to the DW core. */
        uint64_t margin_rdy            : 1;  /**< [  6:  6](R/W) Margining ready. Indicates when the PHY ready to accept margining commands. This
                                                                 signal is reflected in PCIEEP_MRG_PORT_CAP_STAT[M_RDY] /
                                                                 PCIERC_MRG_PORT_CAP_STAT[M_RDY].

                                                                 Internal:
                                                                 Controls app_margining_ready input to the DW core. */
        uint64_t frc_retry             : 1;  /**< [  5:  5](R/W) When set, forces CRS status to be returned for any config access.
                                                                 Internal:
                                                                 Controls app_req_retry_en input to the DW core. */
        uint64_t lnk_enb               : 1;  /**< [  4:  4](R/W) When set, the link is enabled; when clear the link is disabled.
                                                                 Once set, can only be cleared by a MAC power reset.

                                                                 Internal:
                                                                 Controls app_ltssm_en input to the DW core. */
        uint64_t l1_exit               : 1;  /**< [  3:  3](R/W) L1 exit control.
                                                                 0 = Hardware is allowed to enter L1 power state and will only exit when woken
                                                                 up by the remote link partner or traffic arrives on NCBO or EBO busses.
                                                                 1 = Entry into L1 state is disabled and if already in L1 state, will force an
                                                                 exit.

                                                                 Internal:
                                                                 Controls app_req_exit_l1 input high to the DW core. */
        uint64_t fast_lm               : 1;  /**< [  2:  2](R/W) When set, forces fast link mode.
                                                                 Internal:
                                                                 Controls diag_ctrl_bus[2] input to the DW core. */
        uint64_t inv_ecrc              : 1;  /**< [  1:  1](R/W) When set, causes the LSB of the ECRC to be inverted.
                                                                 Internal:
                                                                 Controls diag_ctrl_bus[1] input to the DW core. */
        uint64_t inv_lcrc              : 1;  /**< [  0:  0](R/W) When set, causes the LSB of the LCRC to be inverted.
                                                                 Internal:
                                                                 Controls diag_ctrl_bus[0] input to the DW core. */
#else /* Word 0 - Little Endian */
        uint64_t inv_lcrc              : 1;  /**< [  0:  0](R/W) When set, causes the LSB of the LCRC to be inverted.
                                                                 Internal:
                                                                 Controls diag_ctrl_bus[0] input to the DW core. */
        uint64_t inv_ecrc              : 1;  /**< [  1:  1](R/W) When set, causes the LSB of the ECRC to be inverted.
                                                                 Internal:
                                                                 Controls diag_ctrl_bus[1] input to the DW core. */
        uint64_t fast_lm               : 1;  /**< [  2:  2](R/W) When set, forces fast link mode.
                                                                 Internal:
                                                                 Controls diag_ctrl_bus[2] input to the DW core. */
        uint64_t l1_exit               : 1;  /**< [  3:  3](R/W) L1 exit control.
                                                                 0 = Hardware is allowed to enter L1 power state and will only exit when woken
                                                                 up by the remote link partner or traffic arrives on NCBO or EBO busses.
                                                                 1 = Entry into L1 state is disabled and if already in L1 state, will force an
                                                                 exit.

                                                                 Internal:
                                                                 Controls app_req_exit_l1 input high to the DW core. */
        uint64_t lnk_enb               : 1;  /**< [  4:  4](R/W) When set, the link is enabled; when clear the link is disabled.
                                                                 Once set, can only be cleared by a MAC power reset.

                                                                 Internal:
                                                                 Controls app_ltssm_en input to the DW core. */
        uint64_t frc_retry             : 1;  /**< [  5:  5](R/W) When set, forces CRS status to be returned for any config access.
                                                                 Internal:
                                                                 Controls app_req_retry_en input to the DW core. */
        uint64_t margin_rdy            : 1;  /**< [  6:  6](R/W) Margining ready. Indicates when the PHY ready to accept margining commands. This
                                                                 signal is reflected in PCIEEP_MRG_PORT_CAP_STAT[M_RDY] /
                                                                 PCIERC_MRG_PORT_CAP_STAT[M_RDY].

                                                                 Internal:
                                                                 Controls app_margining_ready input to the DW core. */
        uint64_t rdy_entr_l23          : 1;  /**< [  7:  7](R/W) Application ready to enter L23.  Indication that the application is
                                                                 ready to enter the L23 state. This provides control of the L23 entry
                                                                 (in case certain tasks must be performed before going into L23).
                                                                 The Mac delays sending PM_Enter_L23 (in response to PM_Turn_Off)
                                                                 until this signal becomes active. When this signal has been asserted
                                                                 by the application, it must be kept asserted until L2 entry has completed

                                                                 Internal:
                                                                 Controls app_ready_entr_l23 input to the DW core. */
        uint64_t clk_req_n             : 1;  /**< [  8:  8](R/W) Indicates that the application logic is ready to have reference clock
                                                                 removed.  The application should set this signal when it is ready to
                                                                 have reference clock removed trhough either L1 PM Sub-states or L1 CPM.
                                                                 If the application does not want to remove reference clock it should
                                                                 set this clear this bit.

                                                                 Internal:
                                                                 Controls app_clk_req_n input to the DW core. */
        uint64_t reserved_9_10         : 2;
        uint64_t pm_xtoff              : 1;  /**< [ 11: 11](WO) When written with one, a single cycle pulse to request from application
                                                                 to generate a PM_Turn_Off message. RC mode.

                                                                 Internal:
                                                                 Controls apps_pm_xmt_turnoff input to the DW core. */
        uint64_t scr_done              : 1;  /**< [ 12: 12](R/W) The ROM script (if present) can test this bit to see if the ROM script has
                                                                 already run. Typical usage is for the ROM script to test [SCR_DONE] and exit if
                                                                 true, else at the end of the ROM script, the script sets this bit. */
        uint64_t spares                : 3;  /**< [ 15: 13](R/W) Spare flops. */
        uint64_t reserved_16_31        : 16;
        uint64_t pbus                  : 8;  /**< [ 39: 32](RO/H) Primary bus number. */
        uint64_t dnum                  : 5;  /**< [ 44: 40](RO/H) Primary bus device number. */
        uint64_t auto_sd               : 1;  /**< [ 45: 45](RO/H) Link hardware autonomous speed disable. */
        uint64_t reserved_46_63        : 18;
#endif /* Word 0 - End */
    } cn9;
    struct bdk_pemx_ctl_status_cn81xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_55_63        : 9;
        uint64_t inb_grant_limit       : 3;  /**< [ 54: 52](R/W) The number of inbound TLPs allowed in flight in PEM.to improve
                                                                 small TLP performance. */
        uint64_t reserved_51           : 1;
        uint64_t inv_dpar              : 1;  /**< [ 50: 50](R/W) Invert the generated parity to be written into the most significant data queue buffer RAM
                                                                 block to force a parity error when it is later read. */
        uint64_t reserved_48_49        : 2;
        uint64_t auto_sd               : 1;  /**< [ 47: 47](RO/H) Link hardware autonomous speed disable. */
        uint64_t dnum                  : 5;  /**< [ 46: 42](RO/H) Primary bus device number. */
        uint64_t pbus                  : 8;  /**< [ 41: 34](RO/H) Primary bus number. */
        uint64_t reserved_32_33        : 2;
        uint64_t cfg_rtry              : 16; /**< [ 31: 16](R/W) The time in units of 0x10000 in coprocessor clocks to wait for a CPL to a
                                                                 configuration read that does not carry a retry status. Until such time that the
                                                                 timeout occurs and retry status is received for a configuration read, the read
                                                                 will be resent. A value of 0 disables retries and treats a CPL retry as a CPL
                                                                 UR.

                                                                 To use, it is recommended [CFG_RTRY] be set value corresponding to 200ms or
                                                                 less, although the PCI Express Base Specification allows up to 900ms for a
                                                                 device to send a successful completion.  When enabled, only one CFG RD may be
                                                                 issued until either successful completion or CPL UR. */
        uint64_t spares                : 4;  /**< [ 15: 12](R/W) Spare flops. */
        uint64_t pm_xtoff              : 1;  /**< [ 11: 11](R/W/H) When written with one, a single cycle pulse is sent to the PCIe core pm_xmt_turnoff port. RC mode. */
        uint64_t reserved_6_10         : 5;
        uint64_t dly_one               : 1;  /**< [  5:  5](R/W/H) When set the output client state machines will wait one cycle before starting a new TLP out. */
        uint64_t lnk_enb               : 1;  /**< [  4:  4](R/W) When set, the link is enabled; when clear (0) the link is disabled. This bit only is
                                                                 active when in RC mode. */
        uint64_t ro_ctlp               : 1;  /**< [  3:  3](R/W) When set, C-TLPs that have the RO bit set will not wait for P-TLPs that are normally sent first. */
        uint64_t fast_lm               : 1;  /**< [  2:  2](R/W) When set, forces fast link mode. */
        uint64_t inv_ecrc              : 1;  /**< [  1:  1](R/W) When set, causes the LSB of the ECRC to be inverted. */
        uint64_t inv_lcrc              : 1;  /**< [  0:  0](R/W) When set, causes the LSB of the LCRC to be inverted. */
#else /* Word 0 - Little Endian */
        uint64_t inv_lcrc              : 1;  /**< [  0:  0](R/W) When set, causes the LSB of the LCRC to be inverted. */
        uint64_t inv_ecrc              : 1;  /**< [  1:  1](R/W) When set, causes the LSB of the ECRC to be inverted. */
        uint64_t fast_lm               : 1;  /**< [  2:  2](R/W) When set, forces fast link mode. */
        uint64_t ro_ctlp               : 1;  /**< [  3:  3](R/W) When set, C-TLPs that have the RO bit set will not wait for P-TLPs that are normally sent first. */
        uint64_t lnk_enb               : 1;  /**< [  4:  4](R/W) When set, the link is enabled; when clear (0) the link is disabled. This bit only is
                                                                 active when in RC mode. */
        uint64_t dly_one               : 1;  /**< [  5:  5](R/W/H) When set the output client state machines will wait one cycle before starting a new TLP out. */
        uint64_t reserved_6_10         : 5;
        uint64_t pm_xtoff              : 1;  /**< [ 11: 11](R/W/H) When written with one, a single cycle pulse is sent to the PCIe core pm_xmt_turnoff port. RC mode. */
        uint64_t spares                : 4;  /**< [ 15: 12](R/W) Spare flops. */
        uint64_t cfg_rtry              : 16; /**< [ 31: 16](R/W) The time in units of 0x10000 in coprocessor clocks to wait for a CPL to a
                                                                 configuration read that does not carry a retry status. Until such time that the
                                                                 timeout occurs and retry status is received for a configuration read, the read
                                                                 will be resent. A value of 0 disables retries and treats a CPL retry as a CPL
                                                                 UR.

                                                                 To use, it is recommended [CFG_RTRY] be set value corresponding to 200ms or
                                                                 less, although the PCI Express Base Specification allows up to 900ms for a
                                                                 device to send a successful completion.  When enabled, only one CFG RD may be
                                                                 issued until either successful completion or CPL UR. */
        uint64_t reserved_32_33        : 2;
        uint64_t pbus                  : 8;  /**< [ 41: 34](RO/H) Primary bus number. */
        uint64_t dnum                  : 5;  /**< [ 46: 42](RO/H) Primary bus device number. */
        uint64_t auto_sd               : 1;  /**< [ 47: 47](RO/H) Link hardware autonomous speed disable. */
        uint64_t reserved_48_49        : 2;
        uint64_t inv_dpar              : 1;  /**< [ 50: 50](R/W) Invert the generated parity to be written into the most significant data queue buffer RAM
                                                                 block to force a parity error when it is later read. */
        uint64_t reserved_51           : 1;
        uint64_t inb_grant_limit       : 3;  /**< [ 54: 52](R/W) The number of inbound TLPs allowed in flight in PEM.to improve
                                                                 small TLP performance. */
        uint64_t reserved_55_63        : 9;
#endif /* Word 0 - End */
    } cn81xx;
    struct bdk_pemx_ctl_status_cn83xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_48_63        : 16;
        uint64_t auto_sd               : 1;  /**< [ 47: 47](RO/H) Link hardware autonomous speed disable. */
        uint64_t dnum                  : 5;  /**< [ 46: 42](RO/H) Primary bus device number. */
        uint64_t pbus                  : 8;  /**< [ 41: 34](RO/H) Primary bus number. */
        uint64_t reserved_32_33        : 2;
        uint64_t cfg_rtry              : 16; /**< [ 31: 16](R/W) The time in units of 0x10000 in coprocessor clocks to wait for a CPL to a
                                                                 configuration read that does not carry a retry status. Until such time that the
                                                                 timeout occurs and retry status is received for a configuration read, the read
                                                                 will be resent. A value of 0 disables retries and treats a CPL retry as a CPL
                                                                 UR.

                                                                 To use, it is recommended [CFG_RTRY] be set value corresponding to 200ms or
                                                                 less, although the PCI Express Base Specification allows up to 900ms for a
                                                                 device to send a successful completion.  When enabled, only one CFG RD may be
                                                                 issued until either successful completion or CPL UR. */
        uint64_t spares                : 4;  /**< [ 15: 12](R/W) Spare flops. */
        uint64_t pm_xtoff              : 1;  /**< [ 11: 11](R/W/H) When written with one, a single cycle pulse is sent to the PCIe core pm_xmt_turnoff port. RC mode. */
        uint64_t pm_xpme               : 1;  /**< [ 10: 10](R/W/H) When written with one, a single cycle pulse is sent to the PCIe core pm_xmt_pme port. EP mode. */
        uint64_t ob_p_cmd              : 1;  /**< [  9:  9](R/W/H) When written with one, a single cycle pulse is sent to the PCIe core outband_pwrup_cmd
                                                                 port. EP mode. */
        uint64_t reserved_8            : 1;
        uint64_t reserved_7            : 1;
        uint64_t nf_ecrc               : 1;  /**< [  6:  6](R/W) Do not forward peer-to-peer ECRC TLPs. */
        uint64_t reserved_5            : 1;
        uint64_t lnk_enb               : 1;  /**< [  4:  4](R/W) When set, the link is enabled; when clear (0) the link is disabled. This bit only is
                                                                 active when in RC mode. */
        uint64_t ro_ctlp               : 1;  /**< [  3:  3](R/W) When set, C-TLPs that have the RO bit set will not wait for P-TLPs that are normally sent first. */
        uint64_t fast_lm               : 1;  /**< [  2:  2](R/W) When set, forces fast link mode. */
        uint64_t inv_ecrc              : 1;  /**< [  1:  1](R/W) When set, causes the LSB of the ECRC to be inverted. */
        uint64_t inv_lcrc              : 1;  /**< [  0:  0](R/W) When set, causes the LSB of the LCRC to be inverted. */
#else /* Word 0 - Little Endian */
        uint64_t inv_lcrc              : 1;  /**< [  0:  0](R/W) When set, causes the LSB of the LCRC to be inverted. */
        uint64_t inv_ecrc              : 1;  /**< [  1:  1](R/W) When set, causes the LSB of the ECRC to be inverted. */
        uint64_t fast_lm               : 1;  /**< [  2:  2](R/W) When set, forces fast link mode. */
        uint64_t ro_ctlp               : 1;  /**< [  3:  3](R/W) When set, C-TLPs that have the RO bit set will not wait for P-TLPs that are normally sent first. */
        uint64_t lnk_enb               : 1;  /**< [  4:  4](R/W) When set, the link is enabled; when clear (0) the link is disabled. This bit only is
                                                                 active when in RC mode. */
        uint64_t reserved_5            : 1;
        uint64_t nf_ecrc               : 1;  /**< [  6:  6](R/W) Do not forward peer-to-peer ECRC TLPs. */
        uint64_t reserved_7            : 1;
        uint64_t reserved_8            : 1;
        uint64_t ob_p_cmd              : 1;  /**< [  9:  9](R/W/H) When written with one, a single cycle pulse is sent to the PCIe core outband_pwrup_cmd
                                                                 port. EP mode. */
        uint64_t pm_xpme               : 1;  /**< [ 10: 10](R/W/H) When written with one, a single cycle pulse is sent to the PCIe core pm_xmt_pme port. EP mode. */
        uint64_t pm_xtoff              : 1;  /**< [ 11: 11](R/W/H) When written with one, a single cycle pulse is sent to the PCIe core pm_xmt_turnoff port. RC mode. */
        uint64_t spares                : 4;  /**< [ 15: 12](R/W) Spare flops. */
        uint64_t cfg_rtry              : 16; /**< [ 31: 16](R/W) The time in units of 0x10000 in coprocessor clocks to wait for a CPL to a
                                                                 configuration read that does not carry a retry status. Until such time that the
                                                                 timeout occurs and retry status is received for a configuration read, the read
                                                                 will be resent. A value of 0 disables retries and treats a CPL retry as a CPL
                                                                 UR.

                                                                 To use, it is recommended [CFG_RTRY] be set value corresponding to 200ms or
                                                                 less, although the PCI Express Base Specification allows up to 900ms for a
                                                                 device to send a successful completion.  When enabled, only one CFG RD may be
                                                                 issued until either successful completion or CPL UR. */
        uint64_t reserved_32_33        : 2;
        uint64_t pbus                  : 8;  /**< [ 41: 34](RO/H) Primary bus number. */
        uint64_t dnum                  : 5;  /**< [ 46: 42](RO/H) Primary bus device number. */
        uint64_t auto_sd               : 1;  /**< [ 47: 47](RO/H) Link hardware autonomous speed disable. */
        uint64_t reserved_48_63        : 16;
#endif /* Word 0 - End */
    } cn83xx;
    struct bdk_pemx_ctl_status_cn88xxp2
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_55_63        : 9;
        uint64_t inb_grant_limit       : 3;  /**< [ 54: 52](R/W) The number of inbound TLPs allowed in flight in PEM. */
        uint64_t reserved_51           : 1;
        uint64_t inv_dpar              : 1;  /**< [ 50: 50](R/W) Invert the generated parity to be written into the most significant data queue buffer RAM
                                                                 block to force a parity error when it is later read. */
        uint64_t reserved_48_49        : 2;
        uint64_t auto_sd               : 1;  /**< [ 47: 47](RO/H) Link hardware autonomous speed disable. */
        uint64_t dnum                  : 5;  /**< [ 46: 42](RO/H) Primary bus device number. */
        uint64_t pbus                  : 8;  /**< [ 41: 34](RO/H) Primary bus number. */
        uint64_t reserved_32_33        : 2;
        uint64_t cfg_rtry              : 16; /**< [ 31: 16](R/W) The time in units of 0x10000 in coprocessor clocks to wait for a CPL to a
                                                                 configuration read that does not carry a retry status. Until such time that the
                                                                 timeout occurs and retry status is received for a configuration read, the read
                                                                 will be resent. A value of 0 disables retries and treats a CPL retry as a CPL
                                                                 UR.

                                                                 To use, it is recommended [CFG_RTRY] be set value corresponding to 200ms or
                                                                 less, although the PCI Express Base Specification allows up to 900ms for a
                                                                 device to send a successful completion.  When enabled, only one CFG RD may be
                                                                 issued until either successful completion or CPL UR. */
        uint64_t spares                : 4;  /**< [ 15: 12](R/W) Spare flops. */
        uint64_t pm_xtoff              : 1;  /**< [ 11: 11](R/W/H) When written with one, a single cycle pulse is sent to the PCIe core pm_xmt_turnoff port. RC mode. */
        uint64_t reserved_6_10         : 5;
        uint64_t dly_one               : 1;  /**< [  5:  5](R/W/H) When set the output client state machines will wait one cycle before starting a new TLP out. */
        uint64_t lnk_enb               : 1;  /**< [  4:  4](R/W) When set, the link is enabled; when clear (0) the link is disabled. This bit only is
                                                                 active when in RC mode. */
        uint64_t ro_ctlp               : 1;  /**< [  3:  3](R/W) When set, C-TLPs that have the RO bit set will not wait for P-TLPs that are normally sent first. */
        uint64_t fast_lm               : 1;  /**< [  2:  2](R/W) When set, forces fast link mode. */
        uint64_t inv_ecrc              : 1;  /**< [  1:  1](R/W) When set, causes the LSB of the ECRC to be inverted. */
        uint64_t inv_lcrc              : 1;  /**< [  0:  0](R/W) When set, causes the LSB of the LCRC to be inverted. */
#else /* Word 0 - Little Endian */
        uint64_t inv_lcrc              : 1;  /**< [  0:  0](R/W) When set, causes the LSB of the LCRC to be inverted. */
        uint64_t inv_ecrc              : 1;  /**< [  1:  1](R/W) When set, causes the LSB of the ECRC to be inverted. */
        uint64_t fast_lm               : 1;  /**< [  2:  2](R/W) When set, forces fast link mode. */
        uint64_t ro_ctlp               : 1;  /**< [  3:  3](R/W) When set, C-TLPs that have the RO bit set will not wait for P-TLPs that are normally sent first. */
        uint64_t lnk_enb               : 1;  /**< [  4:  4](R/W) When set, the link is enabled; when clear (0) the link is disabled. This bit only is
                                                                 active when in RC mode. */
        uint64_t dly_one               : 1;  /**< [  5:  5](R/W/H) When set the output client state machines will wait one cycle before starting a new TLP out. */
        uint64_t reserved_6_10         : 5;
        uint64_t pm_xtoff              : 1;  /**< [ 11: 11](R/W/H) When written with one, a single cycle pulse is sent to the PCIe core pm_xmt_turnoff port. RC mode. */
        uint64_t spares                : 4;  /**< [ 15: 12](R/W) Spare flops. */
        uint64_t cfg_rtry              : 16; /**< [ 31: 16](R/W) The time in units of 0x10000 in coprocessor clocks to wait for a CPL to a
                                                                 configuration read that does not carry a retry status. Until such time that the
                                                                 timeout occurs and retry status is received for a configuration read, the read
                                                                 will be resent. A value of 0 disables retries and treats a CPL retry as a CPL
                                                                 UR.

                                                                 To use, it is recommended [CFG_RTRY] be set value corresponding to 200ms or
                                                                 less, although the PCI Express Base Specification allows up to 900ms for a
                                                                 device to send a successful completion.  When enabled, only one CFG RD may be
                                                                 issued until either successful completion or CPL UR. */
        uint64_t reserved_32_33        : 2;
        uint64_t pbus                  : 8;  /**< [ 41: 34](RO/H) Primary bus number. */
        uint64_t dnum                  : 5;  /**< [ 46: 42](RO/H) Primary bus device number. */
        uint64_t auto_sd               : 1;  /**< [ 47: 47](RO/H) Link hardware autonomous speed disable. */
        uint64_t reserved_48_49        : 2;
        uint64_t inv_dpar              : 1;  /**< [ 50: 50](R/W) Invert the generated parity to be written into the most significant data queue buffer RAM
                                                                 block to force a parity error when it is later read. */
        uint64_t reserved_51           : 1;
        uint64_t inb_grant_limit       : 3;  /**< [ 54: 52](R/W) The number of inbound TLPs allowed in flight in PEM. */
        uint64_t reserved_55_63        : 9;
#endif /* Word 0 - End */
    } cn88xxp2;
};
typedef union bdk_pemx_ctl_status bdk_pemx_ctl_status_t;

static inline uint64_t BDK_PEMX_CTL_STATUS(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_CTL_STATUS(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN81XX) && (a<=2))
        return 0x87e0c0000000ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN83XX) && (a<=3))
        return 0x87e0c0000000ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN88XX) && (a<=5))
        return 0x87e0c0000000ll + 0x1000000ll * ((a) & 0x7);
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e0000000000ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_CTL_STATUS", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_CTL_STATUS(a) bdk_pemx_ctl_status_t
#define bustype_BDK_PEMX_CTL_STATUS(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_CTL_STATUS(a) "PEMX_CTL_STATUS"
#define device_bar_BDK_PEMX_CTL_STATUS(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_CTL_STATUS(a) (a)
#define arguments_BDK_PEMX_CTL_STATUS(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_ctl_status2
 *
 * PEM Control Status 2 Register
 * This register contains additional general control and status of the PEM.
 *
 * This register is accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on PEM domain reset. Note this differs from PEM()_CTL_STATUS's reset.
 */
union bdk_pemx_ctl_status2
{
    uint64_t u;
    struct bdk_pemx_ctl_status2_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_33_63        : 31;
        uint64_t trgt1_ecc_cor_dis     : 1;  /**< [ 32: 32](R/W) Disable correction of single bit ECC errors on TRGT1 data from PEMC to PEMM. */
        uint64_t cfg_rtry              : 16; /**< [ 31: 16](R/W) The time in units of 655,360 ns clocks to wait for a CPL to an
                                                                 outbound configuration read that does not carry a retry status. Until such time
                                                                 that the timeout occurs and retry status is received for a configuration read,
                                                                 the read will be resent. A value of zero disables retries and treats a CPL retry
                                                                 as a CPL UR.

                                                                 To use, it is recommended [CFG_RTRY] be set value corresponding to 200 ms or
                                                                 less, although the PCI express base specification allows up to 900 ms for a
                                                                 device to send a successful completion.  When enabled, only one CFG RD may be
                                                                 issued until either successful completion or CPL UR. */
        uint64_t no_fwd_prg            : 16; /**< [ 15:  0](R/W) The time * 0x10000 in core clocks to wait for the TLP FIFOs to be able to unload an entry.
                                                                 If there is no forward progress, such that the timeout occurs, credits are returned to the
                                                                 SLI and an interrupt (if enabled) is asserted. Any more TLPs received are dropped on the
                                                                 floor and the credits associated with those TLPs are returned as well. Note that 0xFFFF is
                                                                 a reserved value that will put the PEM in the 'forward progress stopped' state
                                                                 immediately. This state holds until a MAC reset is received. */
#else /* Word 0 - Little Endian */
        uint64_t no_fwd_prg            : 16; /**< [ 15:  0](R/W) The time * 0x10000 in core clocks to wait for the TLP FIFOs to be able to unload an entry.
                                                                 If there is no forward progress, such that the timeout occurs, credits are returned to the
                                                                 SLI and an interrupt (if enabled) is asserted. Any more TLPs received are dropped on the
                                                                 floor and the credits associated with those TLPs are returned as well. Note that 0xFFFF is
                                                                 a reserved value that will put the PEM in the 'forward progress stopped' state
                                                                 immediately. This state holds until a MAC reset is received. */
        uint64_t cfg_rtry              : 16; /**< [ 31: 16](R/W) The time in units of 655,360 ns clocks to wait for a CPL to an
                                                                 outbound configuration read that does not carry a retry status. Until such time
                                                                 that the timeout occurs and retry status is received for a configuration read,
                                                                 the read will be resent. A value of zero disables retries and treats a CPL retry
                                                                 as a CPL UR.

                                                                 To use, it is recommended [CFG_RTRY] be set value corresponding to 200 ms or
                                                                 less, although the PCI express base specification allows up to 900 ms for a
                                                                 device to send a successful completion.  When enabled, only one CFG RD may be
                                                                 issued until either successful completion or CPL UR. */
        uint64_t trgt1_ecc_cor_dis     : 1;  /**< [ 32: 32](R/W) Disable correction of single bit ECC errors on TRGT1 data from PEMC to PEMM. */
        uint64_t reserved_33_63        : 31;
#endif /* Word 0 - End */
    } s;
    struct bdk_pemx_ctl_status2_cn8
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_16_63        : 48;
        uint64_t no_fwd_prg            : 16; /**< [ 15:  0](R/W) The time * 0x10000 in core clocks to wait for the TLP FIFOs to be able to unload an entry.
                                                                 If there is no forward progress, such that the timeout occurs, credits are returned to the
                                                                 SLI and an interrupt (if enabled) is asserted. Any more TLPs received are dropped on the
                                                                 floor and the credits associated with those TLPs are returned as well. Note that 0xFFFF is
                                                                 a reserved value that will put the PEM in the 'forward progress stopped' state
                                                                 immediately. This state holds until a MAC reset is received. */
#else /* Word 0 - Little Endian */
        uint64_t no_fwd_prg            : 16; /**< [ 15:  0](R/W) The time * 0x10000 in core clocks to wait for the TLP FIFOs to be able to unload an entry.
                                                                 If there is no forward progress, such that the timeout occurs, credits are returned to the
                                                                 SLI and an interrupt (if enabled) is asserted. Any more TLPs received are dropped on the
                                                                 floor and the credits associated with those TLPs are returned as well. Note that 0xFFFF is
                                                                 a reserved value that will put the PEM in the 'forward progress stopped' state
                                                                 immediately. This state holds until a MAC reset is received. */
        uint64_t reserved_16_63        : 48;
#endif /* Word 0 - End */
    } cn8;
    struct bdk_pemx_ctl_status2_cn9
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_33_63        : 31;
        uint64_t trgt1_ecc_cor_dis     : 1;  /**< [ 32: 32](R/W) Disable correction of single bit ECC errors on TRGT1 data from PEMC to PEMM. */
        uint64_t cfg_rtry              : 16; /**< [ 31: 16](R/W) The time in units of 655,360 ns clocks to wait for a CPL to an
                                                                 outbound configuration read that does not carry a retry status. Until such time
                                                                 that the timeout occurs and retry status is received for a configuration read,
                                                                 the read will be resent. A value of zero disables retries and treats a CPL retry
                                                                 as a CPL UR.

                                                                 To use, it is recommended [CFG_RTRY] be set value corresponding to 200 ms or
                                                                 less, although the PCI express base specification allows up to 900 ms for a
                                                                 device to send a successful completion.  When enabled, only one CFG RD may be
                                                                 issued until either successful completion or CPL UR. */
        uint64_t no_fwd_prg            : 16; /**< [ 15:  0](R/W) The time in units of 655,360 ns clocks to wait for the TLP FIFOs to be able to
                                                                 unload an outbound entry. If there is no forward progress, such that the timeout
                                                                 occurs, credits are returned to the originating bus and an interrupt (if enabled)
                                                                 is asserted. Further TLPs received are dropped on the floor and the credits
                                                                 associated with those TLPs are returned as well. Non-Posted are dropped with a
                                                                 completion returned (all 1's if config else completion with fault). Note that 0x0000
                                                                 will block detection of no forward progress.  Note that 0xFFFF is a reserved value
                                                                 that will immediately place the PEM into the 'forward progress stopped' state.
                                                                 This state holds until a MAC reset is received. */
#else /* Word 0 - Little Endian */
        uint64_t no_fwd_prg            : 16; /**< [ 15:  0](R/W) The time in units of 655,360 ns clocks to wait for the TLP FIFOs to be able to
                                                                 unload an outbound entry. If there is no forward progress, such that the timeout
                                                                 occurs, credits are returned to the originating bus and an interrupt (if enabled)
                                                                 is asserted. Further TLPs received are dropped on the floor and the credits
                                                                 associated with those TLPs are returned as well. Non-Posted are dropped with a
                                                                 completion returned (all 1's if config else completion with fault). Note that 0x0000
                                                                 will block detection of no forward progress.  Note that 0xFFFF is a reserved value
                                                                 that will immediately place the PEM into the 'forward progress stopped' state.
                                                                 This state holds until a MAC reset is received. */
        uint64_t cfg_rtry              : 16; /**< [ 31: 16](R/W) The time in units of 655,360 ns clocks to wait for a CPL to an
                                                                 outbound configuration read that does not carry a retry status. Until such time
                                                                 that the timeout occurs and retry status is received for a configuration read,
                                                                 the read will be resent. A value of zero disables retries and treats a CPL retry
                                                                 as a CPL UR.

                                                                 To use, it is recommended [CFG_RTRY] be set value corresponding to 200 ms or
                                                                 less, although the PCI express base specification allows up to 900 ms for a
                                                                 device to send a successful completion.  When enabled, only one CFG RD may be
                                                                 issued until either successful completion or CPL UR. */
        uint64_t trgt1_ecc_cor_dis     : 1;  /**< [ 32: 32](R/W) Disable correction of single bit ECC errors on TRGT1 data from PEMC to PEMM. */
        uint64_t reserved_33_63        : 31;
#endif /* Word 0 - End */
    } cn9;
};
typedef union bdk_pemx_ctl_status2 bdk_pemx_ctl_status2_t;

static inline uint64_t BDK_PEMX_CTL_STATUS2(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_CTL_STATUS2(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN81XX) && (a<=2))
        return 0x87e0c0000008ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN83XX) && (a<=3))
        return 0x87e0c0000008ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN88XX) && (a<=5))
        return 0x87e0c0000008ll + 0x1000000ll * ((a) & 0x7);
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e0000000120ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_CTL_STATUS2", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_CTL_STATUS2(a) bdk_pemx_ctl_status2_t
#define bustype_BDK_PEMX_CTL_STATUS2(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_CTL_STATUS2(a) "PEMX_CTL_STATUS2"
#define device_bar_BDK_PEMX_CTL_STATUS2(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_CTL_STATUS2(a) (a)
#define arguments_BDK_PEMX_CTL_STATUS2(a) (a),-1,-1,-1

/**
 * Register (RSL) pem#_ctl_stream
 *
 * PEM EP Mode Stream Register
 * This register is used to generate the SMMU stream ID when in endpoint mode.
 */
union bdk_pemx_ctl_stream
{
    uint64_t u;
    struct bdk_pemx_ctl_stream_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_32_63        : 32;
        uint64_t epsbmax               : 16; /**< [ 31: 16](R/W) The maximum SSU stream ID that will be generated by inbound endpoint
                                                                 transactions. See [EPSBBASE]. Resets to PCC_DEV_CON_E::PCIERC({a}) where {a} is
                                                                 the PEM number. */
        uint64_t epsbbase              : 16; /**< [ 15:  0](R/W) The base SMMU stream ID that will be generated by inbound endpoint
                                                                 transactions. Resets to PCC_DEV_CON_E::PCIERC({a}) where {a} is the PEM number.

                                                                 When in EP mode:
                                                                   _ stream id = min( (PCI_stream_id\<15:0\> + [EPSBBASE]), [EPSBMAX]).

                                                                 When [EPSBBASE]/[EPSBMAX] are changed from the reset values then:

                                                                 * Different endpoint requestors will map to different SMMU streams, enabling the
                                                                 possibility of having different SMMU translations for each endpoint requestor.

                                                                 * Software must ensure that [EPSBBASE]...[EPSBMAX] are non-overlapping between
                                                                 all endpoint PEMs and non-overlapping with existing PCC devices.

                                                                 * IOBN()_SLITAG()_CONTROL[BITS_DIS] must be set. */
#else /* Word 0 - Little Endian */
        uint64_t epsbbase              : 16; /**< [ 15:  0](R/W) The base SMMU stream ID that will be generated by inbound endpoint
                                                                 transactions. Resets to PCC_DEV_CON_E::PCIERC({a}) where {a} is the PEM number.

                                                                 When in EP mode:
                                                                   _ stream id = min( (PCI_stream_id\<15:0\> + [EPSBBASE]), [EPSBMAX]).

                                                                 When [EPSBBASE]/[EPSBMAX] are changed from the reset values then:

                                                                 * Different endpoint requestors will map to different SMMU streams, enabling the
                                                                 possibility of having different SMMU translations for each endpoint requestor.

                                                                 * Software must ensure that [EPSBBASE]...[EPSBMAX] are non-overlapping between
                                                                 all endpoint PEMs and non-overlapping with existing PCC devices.

                                                                 * IOBN()_SLITAG()_CONTROL[BITS_DIS] must be set. */
        uint64_t epsbmax               : 16; /**< [ 31: 16](R/W) The maximum SSU stream ID that will be generated by inbound endpoint
                                                                 transactions. See [EPSBBASE]. Resets to PCC_DEV_CON_E::PCIERC({a}) where {a} is
                                                                 the PEM number. */
        uint64_t reserved_32_63        : 32;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_ctl_stream_s cn; */
};
typedef union bdk_pemx_ctl_stream bdk_pemx_ctl_stream_t;

static inline uint64_t BDK_PEMX_CTL_STREAM(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_CTL_STREAM(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN83XX) && (a<=3))
        return 0x87e0c00004d0ll + 0x1000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_CTL_STREAM", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_CTL_STREAM(a) bdk_pemx_ctl_stream_t
#define bustype_BDK_PEMX_CTL_STREAM(a) BDK_CSR_TYPE_RSL
#define basename_BDK_PEMX_CTL_STREAM(a) "PEMX_CTL_STREAM"
#define device_bar_BDK_PEMX_CTL_STREAM(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_CTL_STREAM(a) (a)
#define arguments_BDK_PEMX_CTL_STREAM(a) (a),-1,-1,-1

/**
 * Register (RSL) pem#_dbg_ena_w1c
 *
 * PEM Debug Information Enable Clear Register
 * This register clears interrupt enable bits.
 */
union bdk_pemx_dbg_ena_w1c
{
    uint64_t u;
    struct bdk_pemx_dbg_ena_w1c_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_58_63        : 6;
        uint64_t m2s_pe                : 1;  /**< [ 57: 57](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[M2S_PE]. */
        uint64_t qhdr_b1_dbe           : 1;  /**< [ 56: 56](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[QHDR_B1_DBE]. */
        uint64_t reserved_51_55        : 5;
        uint64_t c_c_dbe               : 1;  /**< [ 50: 50](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[C_C_DBE]. */
        uint64_t c_c_sbe               : 1;  /**< [ 49: 49](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[C_C_SBE]. */
        uint64_t c_d1_dbe              : 1;  /**< [ 48: 48](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[C_D1_DBE]. */
        uint64_t c_d1_sbe              : 1;  /**< [ 47: 47](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[C_D1_SBE]. */
        uint64_t c_d0_dbe              : 1;  /**< [ 46: 46](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[C_D0_DBE]. */
        uint64_t c_d0_sbe              : 1;  /**< [ 45: 45](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[C_D0_SBE]. */
        uint64_t n_c_dbe               : 1;  /**< [ 44: 44](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[N_C_DBE]. */
        uint64_t n_c_sbe               : 1;  /**< [ 43: 43](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[N_C_SBE]. */
        uint64_t n_d1_dbe              : 1;  /**< [ 42: 42](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[N_D1_DBE]. */
        uint64_t n_d1_sbe              : 1;  /**< [ 41: 41](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[N_D1_SBE]. */
        uint64_t n_d0_dbe              : 1;  /**< [ 40: 40](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[N_D0_DBE]. */
        uint64_t n_d0_sbe              : 1;  /**< [ 39: 39](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[N_D0_SBE]. */
        uint64_t p_c_dbe               : 1;  /**< [ 38: 38](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[P_C_DBE]. */
        uint64_t p_c_sbe               : 1;  /**< [ 37: 37](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[P_C_SBE]. */
        uint64_t p_d1_dbe              : 1;  /**< [ 36: 36](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[P_D1_DBE]. */
        uint64_t p_d1_sbe              : 1;  /**< [ 35: 35](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[P_D1_SBE]. */
        uint64_t p_d0_dbe              : 1;  /**< [ 34: 34](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[P_D0_DBE]. */
        uint64_t p_d0_sbe              : 1;  /**< [ 33: 33](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[P_D0_SBE]. */
        uint64_t reserved_32           : 1;
        uint64_t lofp                  : 1;  /**< [ 31: 31](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[LOFP]. */
        uint64_t ecrc_e                : 1;  /**< [ 30: 30](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[ECRC_E]. */
        uint64_t rawwpp                : 1;  /**< [ 29: 29](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RAWWPP].
                                                                 Internal:
                                                                 radm_rcvd_wreq_poisoned. */
        uint64_t racpp                 : 1;  /**< [ 28: 28](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RACPP].
                                                                 Internal:
                                                                 radm_rcvd_cpl_poisoned. */
        uint64_t ramtlp                : 1;  /**< [ 27: 27](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RAMTLP].
                                                                 Internal:
                                                                 radm_mlf_tlp_err. */
        uint64_t rarwdns               : 1;  /**< [ 26: 26](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RARWDNS].
                                                                 Internal:
                                                                 radm_rcvd_ur_req. */
        uint64_t caar                  : 1;  /**< [ 25: 25](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[CAAR]. */
        uint64_t racca                 : 1;  /**< [ 24: 24](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RACCA].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ca. */
        uint64_t racur                 : 1;  /**< [ 23: 23](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RACUR].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ur. */
        uint64_t rauc                  : 1;  /**< [ 22: 22](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RAUC].
                                                                 Internal:
                                                                 radm_unexp_cpl_err. */
        uint64_t rqo                   : 1;  /**< [ 21: 21](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RQO].
                                                                 Internal:
                                                                 radm_qoverflow. */
        uint64_t fcuv                  : 1;  /**< [ 20: 20](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[FCUV].
                                                                 Internal:
                                                                 (opt. checks) int_xadm_fc_prot_err. */
        uint64_t rpe                   : 1;  /**< [ 19: 19](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RPE].
                                                                 Internal:
                                                                 rmlh_rcvd_err. */
        uint64_t fcpvwt                : 1;  /**< [ 18: 18](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[FCPVWT].
                                                                 Internal:
                                                                 rtlh_fc_prot_err. */
        uint64_t dpeoosd               : 1;  /**< [ 17: 17](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[DPEOOSD].
                                                                 Internal:
                                                                 rdlh_prot_err. */
        uint64_t rtwdle                : 1;  /**< [ 16: 16](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RTWDLE].
                                                                 Internal:
                                                                 rdlh_bad_tlp_err. */
        uint64_t rdwdle                : 1;  /**< [ 15: 15](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RDWDLE].
                                                                 Internal:
                                                                 rdlh_bad_dllp_err. */
        uint64_t mre                   : 1;  /**< [ 14: 14](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[MRE].
                                                                 Internal:
                                                                 xdlh_replay_num_rlover_err. */
        uint64_t rte                   : 1;  /**< [ 13: 13](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RTE].
                                                                 Internal:
                                                                 xdlh_replay_timeout_err. */
        uint64_t acto                  : 1;  /**< [ 12: 12](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[ACTO].
                                                                 Internal:
                                                                 pedc_radm_cpl_timeout. */
        uint64_t rvdm                  : 1;  /**< [ 11: 11](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RVDM].
                                                                 Internal:
                                                                 pedc_radm_vendor_msg. */
        uint64_t rumep                 : 1;  /**< [ 10: 10](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RUMEP].
                                                                 Internal:
                                                                 pedc_radm_msg_unlock. */
        uint64_t rptamrc               : 1;  /**< [  9:  9](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RPTAMRC].
                                                                 Internal:
                                                                 pedc_radm_pm_to_ack. */
        uint64_t rpmerc                : 1;  /**< [  8:  8](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RPMERC].
                                                                 Internal:
                                                                 pedc_radm_pm_pme. */
        uint64_t rfemrc                : 1;  /**< [  7:  7](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RFEMRC].
                                                                 Internal:
                                                                 pedc_radm_fatal_err. */
        uint64_t rnfemrc               : 1;  /**< [  6:  6](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RNFEMRC].
                                                                 Internal:
                                                                 pedc_radm_nonfatal_err. */
        uint64_t rcemrc                : 1;  /**< [  5:  5](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RCEMRC].
                                                                 Internal:
                                                                 pedc_radm_correctable_err. */
        uint64_t rpoison               : 1;  /**< [  4:  4](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RPOISON].
                                                                 Internal:
                                                                 pedc__radm_trgt1_poisoned & pedc__radm_trgt1_hv. */
        uint64_t recrce                : 1;  /**< [  3:  3](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RECRCE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_ecrc_err & pedc__radm_trgt1_eot. */
        uint64_t rtlplle               : 1;  /**< [  2:  2](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RTLPLLE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_dllp_abort &
                                                                 pedc__radm_trgt1_eot. */
        uint64_t rtlpmal               : 1;  /**< [  1:  1](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RTLPMAL].
                                                                 Internal:
                                                                 pedc_radm_trgt1_tlp_abort & pedc__radm_trgt1_eot. */
        uint64_t spoison               : 1;  /**< [  0:  0](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[SPOISON].
                                                                 Internal:
                                                                 peai__client0_tlp_ep & peai__client0_tlp_hv or
                                                                 peai__client1_tlp_ep & peai__client1_tlp_hv (atomic_op). */
#else /* Word 0 - Little Endian */
        uint64_t spoison               : 1;  /**< [  0:  0](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[SPOISON].
                                                                 Internal:
                                                                 peai__client0_tlp_ep & peai__client0_tlp_hv or
                                                                 peai__client1_tlp_ep & peai__client1_tlp_hv (atomic_op). */
        uint64_t rtlpmal               : 1;  /**< [  1:  1](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RTLPMAL].
                                                                 Internal:
                                                                 pedc_radm_trgt1_tlp_abort & pedc__radm_trgt1_eot. */
        uint64_t rtlplle               : 1;  /**< [  2:  2](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RTLPLLE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_dllp_abort &
                                                                 pedc__radm_trgt1_eot. */
        uint64_t recrce                : 1;  /**< [  3:  3](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RECRCE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_ecrc_err & pedc__radm_trgt1_eot. */
        uint64_t rpoison               : 1;  /**< [  4:  4](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RPOISON].
                                                                 Internal:
                                                                 pedc__radm_trgt1_poisoned & pedc__radm_trgt1_hv. */
        uint64_t rcemrc                : 1;  /**< [  5:  5](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RCEMRC].
                                                                 Internal:
                                                                 pedc_radm_correctable_err. */
        uint64_t rnfemrc               : 1;  /**< [  6:  6](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RNFEMRC].
                                                                 Internal:
                                                                 pedc_radm_nonfatal_err. */
        uint64_t rfemrc                : 1;  /**< [  7:  7](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RFEMRC].
                                                                 Internal:
                                                                 pedc_radm_fatal_err. */
        uint64_t rpmerc                : 1;  /**< [  8:  8](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RPMERC].
                                                                 Internal:
                                                                 pedc_radm_pm_pme. */
        uint64_t rptamrc               : 1;  /**< [  9:  9](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RPTAMRC].
                                                                 Internal:
                                                                 pedc_radm_pm_to_ack. */
        uint64_t rumep                 : 1;  /**< [ 10: 10](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RUMEP].
                                                                 Internal:
                                                                 pedc_radm_msg_unlock. */
        uint64_t rvdm                  : 1;  /**< [ 11: 11](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RVDM].
                                                                 Internal:
                                                                 pedc_radm_vendor_msg. */
        uint64_t acto                  : 1;  /**< [ 12: 12](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[ACTO].
                                                                 Internal:
                                                                 pedc_radm_cpl_timeout. */
        uint64_t rte                   : 1;  /**< [ 13: 13](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RTE].
                                                                 Internal:
                                                                 xdlh_replay_timeout_err. */
        uint64_t mre                   : 1;  /**< [ 14: 14](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[MRE].
                                                                 Internal:
                                                                 xdlh_replay_num_rlover_err. */
        uint64_t rdwdle                : 1;  /**< [ 15: 15](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RDWDLE].
                                                                 Internal:
                                                                 rdlh_bad_dllp_err. */
        uint64_t rtwdle                : 1;  /**< [ 16: 16](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RTWDLE].
                                                                 Internal:
                                                                 rdlh_bad_tlp_err. */
        uint64_t dpeoosd               : 1;  /**< [ 17: 17](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[DPEOOSD].
                                                                 Internal:
                                                                 rdlh_prot_err. */
        uint64_t fcpvwt                : 1;  /**< [ 18: 18](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[FCPVWT].
                                                                 Internal:
                                                                 rtlh_fc_prot_err. */
        uint64_t rpe                   : 1;  /**< [ 19: 19](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RPE].
                                                                 Internal:
                                                                 rmlh_rcvd_err. */
        uint64_t fcuv                  : 1;  /**< [ 20: 20](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[FCUV].
                                                                 Internal:
                                                                 (opt. checks) int_xadm_fc_prot_err. */
        uint64_t rqo                   : 1;  /**< [ 21: 21](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RQO].
                                                                 Internal:
                                                                 radm_qoverflow. */
        uint64_t rauc                  : 1;  /**< [ 22: 22](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RAUC].
                                                                 Internal:
                                                                 radm_unexp_cpl_err. */
        uint64_t racur                 : 1;  /**< [ 23: 23](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RACUR].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ur. */
        uint64_t racca                 : 1;  /**< [ 24: 24](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RACCA].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ca. */
        uint64_t caar                  : 1;  /**< [ 25: 25](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[CAAR]. */
        uint64_t rarwdns               : 1;  /**< [ 26: 26](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RARWDNS].
                                                                 Internal:
                                                                 radm_rcvd_ur_req. */
        uint64_t ramtlp                : 1;  /**< [ 27: 27](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RAMTLP].
                                                                 Internal:
                                                                 radm_mlf_tlp_err. */
        uint64_t racpp                 : 1;  /**< [ 28: 28](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RACPP].
                                                                 Internal:
                                                                 radm_rcvd_cpl_poisoned. */
        uint64_t rawwpp                : 1;  /**< [ 29: 29](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RAWWPP].
                                                                 Internal:
                                                                 radm_rcvd_wreq_poisoned. */
        uint64_t ecrc_e                : 1;  /**< [ 30: 30](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[ECRC_E]. */
        uint64_t lofp                  : 1;  /**< [ 31: 31](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[LOFP]. */
        uint64_t reserved_32           : 1;
        uint64_t p_d0_sbe              : 1;  /**< [ 33: 33](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[P_D0_SBE]. */
        uint64_t p_d0_dbe              : 1;  /**< [ 34: 34](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[P_D0_DBE]. */
        uint64_t p_d1_sbe              : 1;  /**< [ 35: 35](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[P_D1_SBE]. */
        uint64_t p_d1_dbe              : 1;  /**< [ 36: 36](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[P_D1_DBE]. */
        uint64_t p_c_sbe               : 1;  /**< [ 37: 37](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[P_C_SBE]. */
        uint64_t p_c_dbe               : 1;  /**< [ 38: 38](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[P_C_DBE]. */
        uint64_t n_d0_sbe              : 1;  /**< [ 39: 39](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[N_D0_SBE]. */
        uint64_t n_d0_dbe              : 1;  /**< [ 40: 40](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[N_D0_DBE]. */
        uint64_t n_d1_sbe              : 1;  /**< [ 41: 41](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[N_D1_SBE]. */
        uint64_t n_d1_dbe              : 1;  /**< [ 42: 42](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[N_D1_DBE]. */
        uint64_t n_c_sbe               : 1;  /**< [ 43: 43](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[N_C_SBE]. */
        uint64_t n_c_dbe               : 1;  /**< [ 44: 44](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[N_C_DBE]. */
        uint64_t c_d0_sbe              : 1;  /**< [ 45: 45](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[C_D0_SBE]. */
        uint64_t c_d0_dbe              : 1;  /**< [ 46: 46](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[C_D0_DBE]. */
        uint64_t c_d1_sbe              : 1;  /**< [ 47: 47](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[C_D1_SBE]. */
        uint64_t c_d1_dbe              : 1;  /**< [ 48: 48](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[C_D1_DBE]. */
        uint64_t c_c_sbe               : 1;  /**< [ 49: 49](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[C_C_SBE]. */
        uint64_t c_c_dbe               : 1;  /**< [ 50: 50](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[C_C_DBE]. */
        uint64_t reserved_51_55        : 5;
        uint64_t qhdr_b1_dbe           : 1;  /**< [ 56: 56](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[QHDR_B1_DBE]. */
        uint64_t m2s_pe                : 1;  /**< [ 57: 57](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[M2S_PE]. */
        uint64_t reserved_58_63        : 6;
#endif /* Word 0 - End */
    } s;
    struct bdk_pemx_dbg_ena_w1c_cn88xxp1
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_57_63        : 7;
        uint64_t qhdr_b1_dbe           : 1;  /**< [ 56: 56](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[QHDR_B1_DBE]. */
        uint64_t qhdr_b1_sbe           : 1;  /**< [ 55: 55](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[QHDR_B1_SBE]. */
        uint64_t qhdr_b0_dbe           : 1;  /**< [ 54: 54](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[QHDR_B0_DBE]. */
        uint64_t qhdr_b0_sbe           : 1;  /**< [ 53: 53](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[QHDR_B0_SBE]. */
        uint64_t rtry_dbe              : 1;  /**< [ 52: 52](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RTRY_DBE]. */
        uint64_t rtry_sbe              : 1;  /**< [ 51: 51](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RTRY_SBE]. */
        uint64_t c_c_dbe               : 1;  /**< [ 50: 50](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[C_C_DBE]. */
        uint64_t c_c_sbe               : 1;  /**< [ 49: 49](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[C_C_SBE]. */
        uint64_t c_d1_dbe              : 1;  /**< [ 48: 48](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[C_D1_DBE]. */
        uint64_t c_d1_sbe              : 1;  /**< [ 47: 47](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[C_D1_SBE]. */
        uint64_t c_d0_dbe              : 1;  /**< [ 46: 46](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[C_D0_DBE]. */
        uint64_t c_d0_sbe              : 1;  /**< [ 45: 45](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[C_D0_SBE]. */
        uint64_t n_c_dbe               : 1;  /**< [ 44: 44](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[N_C_DBE]. */
        uint64_t n_c_sbe               : 1;  /**< [ 43: 43](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[N_C_SBE]. */
        uint64_t n_d1_dbe              : 1;  /**< [ 42: 42](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[N_D1_DBE]. */
        uint64_t n_d1_sbe              : 1;  /**< [ 41: 41](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[N_D1_SBE]. */
        uint64_t n_d0_dbe              : 1;  /**< [ 40: 40](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[N_D0_DBE]. */
        uint64_t n_d0_sbe              : 1;  /**< [ 39: 39](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[N_D0_SBE]. */
        uint64_t p_c_dbe               : 1;  /**< [ 38: 38](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[P_C_DBE]. */
        uint64_t p_c_sbe               : 1;  /**< [ 37: 37](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[P_C_SBE]. */
        uint64_t p_d1_dbe              : 1;  /**< [ 36: 36](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[P_D1_DBE]. */
        uint64_t p_d1_sbe              : 1;  /**< [ 35: 35](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[P_D1_SBE]. */
        uint64_t p_d0_dbe              : 1;  /**< [ 34: 34](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[P_D0_DBE]. */
        uint64_t p_d0_sbe              : 1;  /**< [ 33: 33](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[P_D0_SBE]. */
        uint64_t datq_pe               : 1;  /**< [ 32: 32](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[DATQ_PE]. */
        uint64_t lofp                  : 1;  /**< [ 31: 31](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[LOFP]. */
        uint64_t ecrc_e                : 1;  /**< [ 30: 30](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[ECRC_E]. */
        uint64_t rawwpp                : 1;  /**< [ 29: 29](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RAWWPP].
                                                                 Internal:
                                                                 radm_rcvd_wreq_poisoned. */
        uint64_t racpp                 : 1;  /**< [ 28: 28](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RACPP].
                                                                 Internal:
                                                                 radm_rcvd_cpl_poisoned. */
        uint64_t ramtlp                : 1;  /**< [ 27: 27](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RAMTLP].
                                                                 Internal:
                                                                 radm_mlf_tlp_err. */
        uint64_t rarwdns               : 1;  /**< [ 26: 26](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RARWDNS].
                                                                 Internal:
                                                                 radm_rcvd_ur_req. */
        uint64_t caar                  : 1;  /**< [ 25: 25](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[CAAR]. */
        uint64_t racca                 : 1;  /**< [ 24: 24](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RACCA].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ca. */
        uint64_t racur                 : 1;  /**< [ 23: 23](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RACUR].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ur. */
        uint64_t rauc                  : 1;  /**< [ 22: 22](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RAUC].
                                                                 Internal:
                                                                 radm_unexp_cpl_err. */
        uint64_t rqo                   : 1;  /**< [ 21: 21](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RQO].
                                                                 Internal:
                                                                 radm_qoverflow. */
        uint64_t fcuv                  : 1;  /**< [ 20: 20](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[FCUV].
                                                                 Internal:
                                                                 (opt. checks) int_xadm_fc_prot_err. */
        uint64_t rpe                   : 1;  /**< [ 19: 19](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RPE].
                                                                 Internal:
                                                                 rmlh_rcvd_err. */
        uint64_t fcpvwt                : 1;  /**< [ 18: 18](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[FCPVWT].
                                                                 Internal:
                                                                 rtlh_fc_prot_err. */
        uint64_t dpeoosd               : 1;  /**< [ 17: 17](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[DPEOOSD].
                                                                 Internal:
                                                                 rdlh_prot_err. */
        uint64_t rtwdle                : 1;  /**< [ 16: 16](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RTWDLE].
                                                                 Internal:
                                                                 rdlh_bad_tlp_err. */
        uint64_t rdwdle                : 1;  /**< [ 15: 15](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RDWDLE].
                                                                 Internal:
                                                                 rdlh_bad_dllp_err. */
        uint64_t mre                   : 1;  /**< [ 14: 14](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[MRE].
                                                                 Internal:
                                                                 xdlh_replay_num_rlover_err. */
        uint64_t rte                   : 1;  /**< [ 13: 13](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RTE].
                                                                 Internal:
                                                                 xdlh_replay_timeout_err. */
        uint64_t acto                  : 1;  /**< [ 12: 12](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[ACTO].
                                                                 Internal:
                                                                 pedc_radm_cpl_timeout. */
        uint64_t rvdm                  : 1;  /**< [ 11: 11](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RVDM].
                                                                 Internal:
                                                                 pedc_radm_vendor_msg. */
        uint64_t reserved_10           : 1;
        uint64_t rptamrc               : 1;  /**< [  9:  9](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RPTAMRC].
                                                                 Internal:
                                                                 pedc_radm_pm_to_ack. */
        uint64_t rpmerc                : 1;  /**< [  8:  8](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RPMERC].
                                                                 Internal:
                                                                 pedc_radm_pm_pme. */
        uint64_t rfemrc                : 1;  /**< [  7:  7](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RFEMRC].
                                                                 Internal:
                                                                 pedc_radm_fatal_err. */
        uint64_t rnfemrc               : 1;  /**< [  6:  6](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RNFEMRC].
                                                                 Internal:
                                                                 pedc_radm_nonfatal_err. */
        uint64_t rcemrc                : 1;  /**< [  5:  5](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RCEMRC].
                                                                 Internal:
                                                                 pedc_radm_correctable_err. */
        uint64_t rpoison               : 1;  /**< [  4:  4](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RPOISON].
                                                                 Internal:
                                                                 pedc__radm_trgt1_poisoned & pedc__radm_trgt1_hv. */
        uint64_t recrce                : 1;  /**< [  3:  3](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RECRCE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_ecrc_err & pedc__radm_trgt1_eot. */
        uint64_t rtlplle               : 1;  /**< [  2:  2](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RTLPLLE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_dllp_abort &
                                                                 pedc__radm_trgt1_eot. */
        uint64_t rtlpmal               : 1;  /**< [  1:  1](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RTLPMAL].
                                                                 Internal:
                                                                 pedc_radm_trgt1_tlp_abort & pedc__radm_trgt1_eot. */
        uint64_t spoison               : 1;  /**< [  0:  0](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[SPOISON].
                                                                 Internal:
                                                                 peai__client0_tlp_ep & peai__client0_tlp_hv or
                                                                 peai__client1_tlp_ep & peai__client1_tlp_hv (atomic_op). */
#else /* Word 0 - Little Endian */
        uint64_t spoison               : 1;  /**< [  0:  0](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[SPOISON].
                                                                 Internal:
                                                                 peai__client0_tlp_ep & peai__client0_tlp_hv or
                                                                 peai__client1_tlp_ep & peai__client1_tlp_hv (atomic_op). */
        uint64_t rtlpmal               : 1;  /**< [  1:  1](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RTLPMAL].
                                                                 Internal:
                                                                 pedc_radm_trgt1_tlp_abort & pedc__radm_trgt1_eot. */
        uint64_t rtlplle               : 1;  /**< [  2:  2](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RTLPLLE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_dllp_abort &
                                                                 pedc__radm_trgt1_eot. */
        uint64_t recrce                : 1;  /**< [  3:  3](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RECRCE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_ecrc_err & pedc__radm_trgt1_eot. */
        uint64_t rpoison               : 1;  /**< [  4:  4](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RPOISON].
                                                                 Internal:
                                                                 pedc__radm_trgt1_poisoned & pedc__radm_trgt1_hv. */
        uint64_t rcemrc                : 1;  /**< [  5:  5](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RCEMRC].
                                                                 Internal:
                                                                 pedc_radm_correctable_err. */
        uint64_t rnfemrc               : 1;  /**< [  6:  6](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RNFEMRC].
                                                                 Internal:
                                                                 pedc_radm_nonfatal_err. */
        uint64_t rfemrc                : 1;  /**< [  7:  7](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RFEMRC].
                                                                 Internal:
                                                                 pedc_radm_fatal_err. */
        uint64_t rpmerc                : 1;  /**< [  8:  8](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RPMERC].
                                                                 Internal:
                                                                 pedc_radm_pm_pme. */
        uint64_t rptamrc               : 1;  /**< [  9:  9](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RPTAMRC].
                                                                 Internal:
                                                                 pedc_radm_pm_to_ack. */
        uint64_t reserved_10           : 1;
        uint64_t rvdm                  : 1;  /**< [ 11: 11](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RVDM].
                                                                 Internal:
                                                                 pedc_radm_vendor_msg. */
        uint64_t acto                  : 1;  /**< [ 12: 12](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[ACTO].
                                                                 Internal:
                                                                 pedc_radm_cpl_timeout. */
        uint64_t rte                   : 1;  /**< [ 13: 13](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RTE].
                                                                 Internal:
                                                                 xdlh_replay_timeout_err. */
        uint64_t mre                   : 1;  /**< [ 14: 14](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[MRE].
                                                                 Internal:
                                                                 xdlh_replay_num_rlover_err. */
        uint64_t rdwdle                : 1;  /**< [ 15: 15](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RDWDLE].
                                                                 Internal:
                                                                 rdlh_bad_dllp_err. */
        uint64_t rtwdle                : 1;  /**< [ 16: 16](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RTWDLE].
                                                                 Internal:
                                                                 rdlh_bad_tlp_err. */
        uint64_t dpeoosd               : 1;  /**< [ 17: 17](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[DPEOOSD].
                                                                 Internal:
                                                                 rdlh_prot_err. */
        uint64_t fcpvwt                : 1;  /**< [ 18: 18](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[FCPVWT].
                                                                 Internal:
                                                                 rtlh_fc_prot_err. */
        uint64_t rpe                   : 1;  /**< [ 19: 19](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RPE].
                                                                 Internal:
                                                                 rmlh_rcvd_err. */
        uint64_t fcuv                  : 1;  /**< [ 20: 20](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[FCUV].
                                                                 Internal:
                                                                 (opt. checks) int_xadm_fc_prot_err. */
        uint64_t rqo                   : 1;  /**< [ 21: 21](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RQO].
                                                                 Internal:
                                                                 radm_qoverflow. */
        uint64_t rauc                  : 1;  /**< [ 22: 22](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RAUC].
                                                                 Internal:
                                                                 radm_unexp_cpl_err. */
        uint64_t racur                 : 1;  /**< [ 23: 23](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RACUR].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ur. */
        uint64_t racca                 : 1;  /**< [ 24: 24](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RACCA].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ca. */
        uint64_t caar                  : 1;  /**< [ 25: 25](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[CAAR]. */
        uint64_t rarwdns               : 1;  /**< [ 26: 26](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RARWDNS].
                                                                 Internal:
                                                                 radm_rcvd_ur_req. */
        uint64_t ramtlp                : 1;  /**< [ 27: 27](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RAMTLP].
                                                                 Internal:
                                                                 radm_mlf_tlp_err. */
        uint64_t racpp                 : 1;  /**< [ 28: 28](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RACPP].
                                                                 Internal:
                                                                 radm_rcvd_cpl_poisoned. */
        uint64_t rawwpp                : 1;  /**< [ 29: 29](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RAWWPP].
                                                                 Internal:
                                                                 radm_rcvd_wreq_poisoned. */
        uint64_t ecrc_e                : 1;  /**< [ 30: 30](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[ECRC_E]. */
        uint64_t lofp                  : 1;  /**< [ 31: 31](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[LOFP]. */
        uint64_t datq_pe               : 1;  /**< [ 32: 32](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[DATQ_PE]. */
        uint64_t p_d0_sbe              : 1;  /**< [ 33: 33](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[P_D0_SBE]. */
        uint64_t p_d0_dbe              : 1;  /**< [ 34: 34](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[P_D0_DBE]. */
        uint64_t p_d1_sbe              : 1;  /**< [ 35: 35](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[P_D1_SBE]. */
        uint64_t p_d1_dbe              : 1;  /**< [ 36: 36](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[P_D1_DBE]. */
        uint64_t p_c_sbe               : 1;  /**< [ 37: 37](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[P_C_SBE]. */
        uint64_t p_c_dbe               : 1;  /**< [ 38: 38](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[P_C_DBE]. */
        uint64_t n_d0_sbe              : 1;  /**< [ 39: 39](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[N_D0_SBE]. */
        uint64_t n_d0_dbe              : 1;  /**< [ 40: 40](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[N_D0_DBE]. */
        uint64_t n_d1_sbe              : 1;  /**< [ 41: 41](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[N_D1_SBE]. */
        uint64_t n_d1_dbe              : 1;  /**< [ 42: 42](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[N_D1_DBE]. */
        uint64_t n_c_sbe               : 1;  /**< [ 43: 43](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[N_C_SBE]. */
        uint64_t n_c_dbe               : 1;  /**< [ 44: 44](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[N_C_DBE]. */
        uint64_t c_d0_sbe              : 1;  /**< [ 45: 45](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[C_D0_SBE]. */
        uint64_t c_d0_dbe              : 1;  /**< [ 46: 46](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[C_D0_DBE]. */
        uint64_t c_d1_sbe              : 1;  /**< [ 47: 47](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[C_D1_SBE]. */
        uint64_t c_d1_dbe              : 1;  /**< [ 48: 48](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[C_D1_DBE]. */
        uint64_t c_c_sbe               : 1;  /**< [ 49: 49](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[C_C_SBE]. */
        uint64_t c_c_dbe               : 1;  /**< [ 50: 50](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[C_C_DBE]. */
        uint64_t rtry_sbe              : 1;  /**< [ 51: 51](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RTRY_SBE]. */
        uint64_t rtry_dbe              : 1;  /**< [ 52: 52](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RTRY_DBE]. */
        uint64_t qhdr_b0_sbe           : 1;  /**< [ 53: 53](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[QHDR_B0_SBE]. */
        uint64_t qhdr_b0_dbe           : 1;  /**< [ 54: 54](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[QHDR_B0_DBE]. */
        uint64_t qhdr_b1_sbe           : 1;  /**< [ 55: 55](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[QHDR_B1_SBE]. */
        uint64_t qhdr_b1_dbe           : 1;  /**< [ 56: 56](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[QHDR_B1_DBE]. */
        uint64_t reserved_57_63        : 7;
#endif /* Word 0 - End */
    } cn88xxp1;
    struct bdk_pemx_dbg_ena_w1c_cn81xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_58_63        : 6;
        uint64_t m2s_pe                : 1;  /**< [ 57: 57](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[M2S_PE]. */
        uint64_t qhdr_b1_dbe           : 1;  /**< [ 56: 56](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[QHDR_B1_DBE]. */
        uint64_t qhdr_b1_sbe           : 1;  /**< [ 55: 55](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[QHDR_B1_SBE]. */
        uint64_t qhdr_b0_dbe           : 1;  /**< [ 54: 54](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[QHDR_B0_DBE]. */
        uint64_t qhdr_b0_sbe           : 1;  /**< [ 53: 53](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[QHDR_B0_SBE]. */
        uint64_t rtry_dbe              : 1;  /**< [ 52: 52](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RTRY_DBE]. */
        uint64_t rtry_sbe              : 1;  /**< [ 51: 51](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RTRY_SBE]. */
        uint64_t c_c_dbe               : 1;  /**< [ 50: 50](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[C_C_DBE]. */
        uint64_t c_c_sbe               : 1;  /**< [ 49: 49](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[C_C_SBE]. */
        uint64_t c_d1_dbe              : 1;  /**< [ 48: 48](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[C_D1_DBE]. */
        uint64_t c_d1_sbe              : 1;  /**< [ 47: 47](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[C_D1_SBE]. */
        uint64_t c_d0_dbe              : 1;  /**< [ 46: 46](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[C_D0_DBE]. */
        uint64_t c_d0_sbe              : 1;  /**< [ 45: 45](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[C_D0_SBE]. */
        uint64_t n_c_dbe               : 1;  /**< [ 44: 44](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[N_C_DBE]. */
        uint64_t n_c_sbe               : 1;  /**< [ 43: 43](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[N_C_SBE]. */
        uint64_t n_d1_dbe              : 1;  /**< [ 42: 42](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[N_D1_DBE]. */
        uint64_t n_d1_sbe              : 1;  /**< [ 41: 41](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[N_D1_SBE]. */
        uint64_t n_d0_dbe              : 1;  /**< [ 40: 40](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[N_D0_DBE]. */
        uint64_t n_d0_sbe              : 1;  /**< [ 39: 39](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[N_D0_SBE]. */
        uint64_t p_c_dbe               : 1;  /**< [ 38: 38](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[P_C_DBE]. */
        uint64_t p_c_sbe               : 1;  /**< [ 37: 37](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[P_C_SBE]. */
        uint64_t p_d1_dbe              : 1;  /**< [ 36: 36](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[P_D1_DBE]. */
        uint64_t p_d1_sbe              : 1;  /**< [ 35: 35](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[P_D1_SBE]. */
        uint64_t p_d0_dbe              : 1;  /**< [ 34: 34](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[P_D0_DBE]. */
        uint64_t p_d0_sbe              : 1;  /**< [ 33: 33](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[P_D0_SBE]. */
        uint64_t datq_pe               : 1;  /**< [ 32: 32](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[DATQ_PE]. */
        uint64_t lofp                  : 1;  /**< [ 31: 31](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[LOFP]. */
        uint64_t ecrc_e                : 1;  /**< [ 30: 30](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[ECRC_E]. */
        uint64_t rawwpp                : 1;  /**< [ 29: 29](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RAWWPP].
                                                                 Internal:
                                                                 radm_rcvd_wreq_poisoned. */
        uint64_t racpp                 : 1;  /**< [ 28: 28](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RACPP].
                                                                 Internal:
                                                                 radm_rcvd_cpl_poisoned. */
        uint64_t ramtlp                : 1;  /**< [ 27: 27](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RAMTLP].
                                                                 Internal:
                                                                 radm_mlf_tlp_err. */
        uint64_t rarwdns               : 1;  /**< [ 26: 26](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RARWDNS].
                                                                 Internal:
                                                                 radm_rcvd_ur_req. */
        uint64_t caar                  : 1;  /**< [ 25: 25](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[CAAR]. */
        uint64_t racca                 : 1;  /**< [ 24: 24](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RACCA].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ca. */
        uint64_t racur                 : 1;  /**< [ 23: 23](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RACUR].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ur. */
        uint64_t rauc                  : 1;  /**< [ 22: 22](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RAUC].
                                                                 Internal:
                                                                 radm_unexp_cpl_err. */
        uint64_t rqo                   : 1;  /**< [ 21: 21](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RQO].
                                                                 Internal:
                                                                 radm_qoverflow. */
        uint64_t fcuv                  : 1;  /**< [ 20: 20](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[FCUV].
                                                                 Internal:
                                                                 (opt. checks) int_xadm_fc_prot_err. */
        uint64_t rpe                   : 1;  /**< [ 19: 19](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RPE].
                                                                 Internal:
                                                                 rmlh_rcvd_err. */
        uint64_t fcpvwt                : 1;  /**< [ 18: 18](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[FCPVWT].
                                                                 Internal:
                                                                 rtlh_fc_prot_err. */
        uint64_t dpeoosd               : 1;  /**< [ 17: 17](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[DPEOOSD].
                                                                 Internal:
                                                                 rdlh_prot_err. */
        uint64_t rtwdle                : 1;  /**< [ 16: 16](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RTWDLE].
                                                                 Internal:
                                                                 rdlh_bad_tlp_err. */
        uint64_t rdwdle                : 1;  /**< [ 15: 15](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RDWDLE].
                                                                 Internal:
                                                                 rdlh_bad_dllp_err. */
        uint64_t mre                   : 1;  /**< [ 14: 14](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[MRE].
                                                                 Internal:
                                                                 xdlh_replay_num_rlover_err. */
        uint64_t rte                   : 1;  /**< [ 13: 13](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RTE].
                                                                 Internal:
                                                                 xdlh_replay_timeout_err. */
        uint64_t acto                  : 1;  /**< [ 12: 12](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[ACTO].
                                                                 Internal:
                                                                 pedc_radm_cpl_timeout. */
        uint64_t rvdm                  : 1;  /**< [ 11: 11](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RVDM].
                                                                 Internal:
                                                                 pedc_radm_vendor_msg. */
        uint64_t reserved_10           : 1;
        uint64_t rptamrc               : 1;  /**< [  9:  9](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RPTAMRC].
                                                                 Internal:
                                                                 pedc_radm_pm_to_ack. */
        uint64_t rpmerc                : 1;  /**< [  8:  8](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RPMERC].
                                                                 Internal:
                                                                 pedc_radm_pm_pme. */
        uint64_t rfemrc                : 1;  /**< [  7:  7](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RFEMRC].
                                                                 Internal:
                                                                 pedc_radm_fatal_err. */
        uint64_t rnfemrc               : 1;  /**< [  6:  6](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RNFEMRC].
                                                                 Internal:
                                                                 pedc_radm_nonfatal_err. */
        uint64_t rcemrc                : 1;  /**< [  5:  5](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RCEMRC].
                                                                 Internal:
                                                                 pedc_radm_correctable_err. */
        uint64_t rpoison               : 1;  /**< [  4:  4](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RPOISON].
                                                                 Internal:
                                                                 pedc__radm_trgt1_poisoned & pedc__radm_trgt1_hv. */
        uint64_t recrce                : 1;  /**< [  3:  3](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RECRCE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_ecrc_err & pedc__radm_trgt1_eot. */
        uint64_t rtlplle               : 1;  /**< [  2:  2](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RTLPLLE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_dllp_abort &
                                                                 pedc__radm_trgt1_eot. */
        uint64_t rtlpmal               : 1;  /**< [  1:  1](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RTLPMAL].
                                                                 Internal:
                                                                 pedc_radm_trgt1_tlp_abort & pedc__radm_trgt1_eot. */
        uint64_t spoison               : 1;  /**< [  0:  0](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[SPOISON].
                                                                 Internal:
                                                                 peai__client0_tlp_ep & peai__client0_tlp_hv or
                                                                 peai__client1_tlp_ep & peai__client1_tlp_hv (atomic_op). */
#else /* Word 0 - Little Endian */
        uint64_t spoison               : 1;  /**< [  0:  0](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[SPOISON].
                                                                 Internal:
                                                                 peai__client0_tlp_ep & peai__client0_tlp_hv or
                                                                 peai__client1_tlp_ep & peai__client1_tlp_hv (atomic_op). */
        uint64_t rtlpmal               : 1;  /**< [  1:  1](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RTLPMAL].
                                                                 Internal:
                                                                 pedc_radm_trgt1_tlp_abort & pedc__radm_trgt1_eot. */
        uint64_t rtlplle               : 1;  /**< [  2:  2](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RTLPLLE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_dllp_abort &
                                                                 pedc__radm_trgt1_eot. */
        uint64_t recrce                : 1;  /**< [  3:  3](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RECRCE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_ecrc_err & pedc__radm_trgt1_eot. */
        uint64_t rpoison               : 1;  /**< [  4:  4](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RPOISON].
                                                                 Internal:
                                                                 pedc__radm_trgt1_poisoned & pedc__radm_trgt1_hv. */
        uint64_t rcemrc                : 1;  /**< [  5:  5](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RCEMRC].
                                                                 Internal:
                                                                 pedc_radm_correctable_err. */
        uint64_t rnfemrc               : 1;  /**< [  6:  6](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RNFEMRC].
                                                                 Internal:
                                                                 pedc_radm_nonfatal_err. */
        uint64_t rfemrc                : 1;  /**< [  7:  7](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RFEMRC].
                                                                 Internal:
                                                                 pedc_radm_fatal_err. */
        uint64_t rpmerc                : 1;  /**< [  8:  8](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RPMERC].
                                                                 Internal:
                                                                 pedc_radm_pm_pme. */
        uint64_t rptamrc               : 1;  /**< [  9:  9](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RPTAMRC].
                                                                 Internal:
                                                                 pedc_radm_pm_to_ack. */
        uint64_t reserved_10           : 1;
        uint64_t rvdm                  : 1;  /**< [ 11: 11](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RVDM].
                                                                 Internal:
                                                                 pedc_radm_vendor_msg. */
        uint64_t acto                  : 1;  /**< [ 12: 12](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[ACTO].
                                                                 Internal:
                                                                 pedc_radm_cpl_timeout. */
        uint64_t rte                   : 1;  /**< [ 13: 13](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RTE].
                                                                 Internal:
                                                                 xdlh_replay_timeout_err. */
        uint64_t mre                   : 1;  /**< [ 14: 14](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[MRE].
                                                                 Internal:
                                                                 xdlh_replay_num_rlover_err. */
        uint64_t rdwdle                : 1;  /**< [ 15: 15](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RDWDLE].
                                                                 Internal:
                                                                 rdlh_bad_dllp_err. */
        uint64_t rtwdle                : 1;  /**< [ 16: 16](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RTWDLE].
                                                                 Internal:
                                                                 rdlh_bad_tlp_err. */
        uint64_t dpeoosd               : 1;  /**< [ 17: 17](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[DPEOOSD].
                                                                 Internal:
                                                                 rdlh_prot_err. */
        uint64_t fcpvwt                : 1;  /**< [ 18: 18](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[FCPVWT].
                                                                 Internal:
                                                                 rtlh_fc_prot_err. */
        uint64_t rpe                   : 1;  /**< [ 19: 19](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RPE].
                                                                 Internal:
                                                                 rmlh_rcvd_err. */
        uint64_t fcuv                  : 1;  /**< [ 20: 20](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[FCUV].
                                                                 Internal:
                                                                 (opt. checks) int_xadm_fc_prot_err. */
        uint64_t rqo                   : 1;  /**< [ 21: 21](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RQO].
                                                                 Internal:
                                                                 radm_qoverflow. */
        uint64_t rauc                  : 1;  /**< [ 22: 22](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RAUC].
                                                                 Internal:
                                                                 radm_unexp_cpl_err. */
        uint64_t racur                 : 1;  /**< [ 23: 23](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RACUR].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ur. */
        uint64_t racca                 : 1;  /**< [ 24: 24](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RACCA].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ca. */
        uint64_t caar                  : 1;  /**< [ 25: 25](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[CAAR]. */
        uint64_t rarwdns               : 1;  /**< [ 26: 26](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RARWDNS].
                                                                 Internal:
                                                                 radm_rcvd_ur_req. */
        uint64_t ramtlp                : 1;  /**< [ 27: 27](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RAMTLP].
                                                                 Internal:
                                                                 radm_mlf_tlp_err. */
        uint64_t racpp                 : 1;  /**< [ 28: 28](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RACPP].
                                                                 Internal:
                                                                 radm_rcvd_cpl_poisoned. */
        uint64_t rawwpp                : 1;  /**< [ 29: 29](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RAWWPP].
                                                                 Internal:
                                                                 radm_rcvd_wreq_poisoned. */
        uint64_t ecrc_e                : 1;  /**< [ 30: 30](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[ECRC_E]. */
        uint64_t lofp                  : 1;  /**< [ 31: 31](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[LOFP]. */
        uint64_t datq_pe               : 1;  /**< [ 32: 32](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[DATQ_PE]. */
        uint64_t p_d0_sbe              : 1;  /**< [ 33: 33](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[P_D0_SBE]. */
        uint64_t p_d0_dbe              : 1;  /**< [ 34: 34](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[P_D0_DBE]. */
        uint64_t p_d1_sbe              : 1;  /**< [ 35: 35](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[P_D1_SBE]. */
        uint64_t p_d1_dbe              : 1;  /**< [ 36: 36](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[P_D1_DBE]. */
        uint64_t p_c_sbe               : 1;  /**< [ 37: 37](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[P_C_SBE]. */
        uint64_t p_c_dbe               : 1;  /**< [ 38: 38](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[P_C_DBE]. */
        uint64_t n_d0_sbe              : 1;  /**< [ 39: 39](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[N_D0_SBE]. */
        uint64_t n_d0_dbe              : 1;  /**< [ 40: 40](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[N_D0_DBE]. */
        uint64_t n_d1_sbe              : 1;  /**< [ 41: 41](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[N_D1_SBE]. */
        uint64_t n_d1_dbe              : 1;  /**< [ 42: 42](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[N_D1_DBE]. */
        uint64_t n_c_sbe               : 1;  /**< [ 43: 43](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[N_C_SBE]. */
        uint64_t n_c_dbe               : 1;  /**< [ 44: 44](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[N_C_DBE]. */
        uint64_t c_d0_sbe              : 1;  /**< [ 45: 45](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[C_D0_SBE]. */
        uint64_t c_d0_dbe              : 1;  /**< [ 46: 46](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[C_D0_DBE]. */
        uint64_t c_d1_sbe              : 1;  /**< [ 47: 47](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[C_D1_SBE]. */
        uint64_t c_d1_dbe              : 1;  /**< [ 48: 48](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[C_D1_DBE]. */
        uint64_t c_c_sbe               : 1;  /**< [ 49: 49](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[C_C_SBE]. */
        uint64_t c_c_dbe               : 1;  /**< [ 50: 50](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[C_C_DBE]. */
        uint64_t rtry_sbe              : 1;  /**< [ 51: 51](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RTRY_SBE]. */
        uint64_t rtry_dbe              : 1;  /**< [ 52: 52](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[RTRY_DBE]. */
        uint64_t qhdr_b0_sbe           : 1;  /**< [ 53: 53](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[QHDR_B0_SBE]. */
        uint64_t qhdr_b0_dbe           : 1;  /**< [ 54: 54](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[QHDR_B0_DBE]. */
        uint64_t qhdr_b1_sbe           : 1;  /**< [ 55: 55](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[QHDR_B1_SBE]. */
        uint64_t qhdr_b1_dbe           : 1;  /**< [ 56: 56](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[QHDR_B1_DBE]. */
        uint64_t m2s_pe                : 1;  /**< [ 57: 57](R/W1C/H) Reads or clears enable for PEM(0..2)_DBG_INFO[M2S_PE]. */
        uint64_t reserved_58_63        : 6;
#endif /* Word 0 - End */
    } cn81xx;
    struct bdk_pemx_dbg_ena_w1c_cn83xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_56_63        : 8;
        uint64_t rasdp                 : 1;  /**< [ 55: 55](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RASDP]. */
        uint64_t m2s_d_dbe             : 1;  /**< [ 54: 54](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[M2S_D_DBE]. */
        uint64_t m2s_d_sbe             : 1;  /**< [ 53: 53](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[M2S_D_SBE]. */
        uint64_t m2s_c_dbe             : 1;  /**< [ 52: 52](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[M2S_C_DBE]. */
        uint64_t m2s_c_sbe             : 1;  /**< [ 51: 51](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[M2S_C_SBE]. */
        uint64_t c_c_dbe               : 1;  /**< [ 50: 50](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[C_C_DBE]. */
        uint64_t c_c_sbe               : 1;  /**< [ 49: 49](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[C_C_SBE]. */
        uint64_t c_d1_dbe              : 1;  /**< [ 48: 48](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[C_D1_DBE]. */
        uint64_t c_d1_sbe              : 1;  /**< [ 47: 47](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[C_D1_SBE]. */
        uint64_t c_d0_dbe              : 1;  /**< [ 46: 46](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[C_D0_DBE]. */
        uint64_t c_d0_sbe              : 1;  /**< [ 45: 45](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[C_D0_SBE]. */
        uint64_t n_c_dbe               : 1;  /**< [ 44: 44](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[N_C_DBE]. */
        uint64_t n_c_sbe               : 1;  /**< [ 43: 43](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[N_C_SBE]. */
        uint64_t n_d1_dbe              : 1;  /**< [ 42: 42](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[N_D1_DBE]. */
        uint64_t n_d1_sbe              : 1;  /**< [ 41: 41](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[N_D1_SBE]. */
        uint64_t n_d0_dbe              : 1;  /**< [ 40: 40](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[N_D0_DBE]. */
        uint64_t n_d0_sbe              : 1;  /**< [ 39: 39](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[N_D0_SBE]. */
        uint64_t p_c_dbe               : 1;  /**< [ 38: 38](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[P_C_DBE]. */
        uint64_t p_c_sbe               : 1;  /**< [ 37: 37](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[P_C_SBE]. */
        uint64_t p_d1_dbe              : 1;  /**< [ 36: 36](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[P_D1_DBE]. */
        uint64_t p_d1_sbe              : 1;  /**< [ 35: 35](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[P_D1_SBE]. */
        uint64_t p_d0_dbe              : 1;  /**< [ 34: 34](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[P_D0_DBE]. */
        uint64_t p_d0_sbe              : 1;  /**< [ 33: 33](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[P_D0_SBE]. */
        uint64_t bmd_e                 : 1;  /**< [ 32: 32](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[BMD_E]. */
        uint64_t lofp                  : 1;  /**< [ 31: 31](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[LOFP]. */
        uint64_t ecrc_e                : 1;  /**< [ 30: 30](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[ECRC_E]. */
        uint64_t rawwpp                : 1;  /**< [ 29: 29](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RAWWPP].
                                                                 Internal:
                                                                 radm_rcvd_wreq_poisoned. */
        uint64_t racpp                 : 1;  /**< [ 28: 28](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RACPP].
                                                                 Internal:
                                                                 radm_rcvd_cpl_poisoned. */
        uint64_t ramtlp                : 1;  /**< [ 27: 27](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RAMTLP].
                                                                 Internal:
                                                                 radm_mlf_tlp_err. */
        uint64_t rarwdns               : 1;  /**< [ 26: 26](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RARWDNS].
                                                                 Internal:
                                                                 radm_rcvd_ur_req. */
        uint64_t caar                  : 1;  /**< [ 25: 25](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[CAAR]. */
        uint64_t racca                 : 1;  /**< [ 24: 24](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RACCA].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ca. */
        uint64_t racur                 : 1;  /**< [ 23: 23](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RACUR].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ur. */
        uint64_t rauc                  : 1;  /**< [ 22: 22](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RAUC].
                                                                 Internal:
                                                                 radm_unexp_cpl_err. */
        uint64_t rqo                   : 1;  /**< [ 21: 21](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RQO].
                                                                 Internal:
                                                                 radm_qoverflow. */
        uint64_t fcuv                  : 1;  /**< [ 20: 20](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[FCUV].
                                                                 Internal:
                                                                 (opt. checks) int_xadm_fc_prot_err. */
        uint64_t rpe                   : 1;  /**< [ 19: 19](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RPE].
                                                                 Internal:
                                                                 rmlh_rcvd_err. */
        uint64_t fcpvwt                : 1;  /**< [ 18: 18](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[FCPVWT].
                                                                 Internal:
                                                                 rtlh_fc_prot_err. */
        uint64_t dpeoosd               : 1;  /**< [ 17: 17](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[DPEOOSD].
                                                                 Internal:
                                                                 rdlh_prot_err. */
        uint64_t rtwdle                : 1;  /**< [ 16: 16](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RTWDLE].
                                                                 Internal:
                                                                 rdlh_bad_tlp_err. */
        uint64_t rdwdle                : 1;  /**< [ 15: 15](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RDWDLE].
                                                                 Internal:
                                                                 rdlh_bad_dllp_err. */
        uint64_t mre                   : 1;  /**< [ 14: 14](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[MRE].
                                                                 Internal:
                                                                 xdlh_replay_num_rlover_err. */
        uint64_t rte                   : 1;  /**< [ 13: 13](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RTE].
                                                                 Internal:
                                                                 xdlh_replay_timeout_err. */
        uint64_t acto                  : 1;  /**< [ 12: 12](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[ACTO].
                                                                 Internal:
                                                                 pedc_radm_cpl_timeout. */
        uint64_t rvdm                  : 1;  /**< [ 11: 11](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RVDM].
                                                                 Internal:
                                                                 pedc_radm_vendor_msg. */
        uint64_t rumep                 : 1;  /**< [ 10: 10](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RUMEP].
                                                                 Internal:
                                                                 pedc_radm_msg_unlock. */
        uint64_t rptamrc               : 1;  /**< [  9:  9](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RPTAMRC].
                                                                 Internal:
                                                                 pedc_radm_pm_to_ack. */
        uint64_t rpmerc                : 1;  /**< [  8:  8](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RPMERC].
                                                                 Internal:
                                                                 pedc_radm_pm_pme. */
        uint64_t rfemrc                : 1;  /**< [  7:  7](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RFEMRC].
                                                                 Internal:
                                                                 pedc_radm_fatal_err. */
        uint64_t rnfemrc               : 1;  /**< [  6:  6](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RNFEMRC].
                                                                 Internal:
                                                                 pedc_radm_nonfatal_err. */
        uint64_t rcemrc                : 1;  /**< [  5:  5](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RCEMRC].
                                                                 Internal:
                                                                 pedc_radm_correctable_err. */
        uint64_t rpoison               : 1;  /**< [  4:  4](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RPOISON].
                                                                 Internal:
                                                                 pedc__radm_trgt1_poisoned & pedc__radm_trgt1_hv. */
        uint64_t recrce                : 1;  /**< [  3:  3](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RECRCE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_ecrc_err & pedc__radm_trgt1_eot. */
        uint64_t rtlplle               : 1;  /**< [  2:  2](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RTLPLLE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_dllp_abort &
                                                                 pedc__radm_trgt1_eot. */
        uint64_t rtlpmal               : 1;  /**< [  1:  1](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RTLPMAL].
                                                                 Internal:
                                                                 pedc_radm_trgt1_tlp_abort & pedc__radm_trgt1_eot. */
        uint64_t spoison               : 1;  /**< [  0:  0](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[SPOISON]. */
#else /* Word 0 - Little Endian */
        uint64_t spoison               : 1;  /**< [  0:  0](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[SPOISON]. */
        uint64_t rtlpmal               : 1;  /**< [  1:  1](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RTLPMAL].
                                                                 Internal:
                                                                 pedc_radm_trgt1_tlp_abort & pedc__radm_trgt1_eot. */
        uint64_t rtlplle               : 1;  /**< [  2:  2](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RTLPLLE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_dllp_abort &
                                                                 pedc__radm_trgt1_eot. */
        uint64_t recrce                : 1;  /**< [  3:  3](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RECRCE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_ecrc_err & pedc__radm_trgt1_eot. */
        uint64_t rpoison               : 1;  /**< [  4:  4](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RPOISON].
                                                                 Internal:
                                                                 pedc__radm_trgt1_poisoned & pedc__radm_trgt1_hv. */
        uint64_t rcemrc                : 1;  /**< [  5:  5](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RCEMRC].
                                                                 Internal:
                                                                 pedc_radm_correctable_err. */
        uint64_t rnfemrc               : 1;  /**< [  6:  6](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RNFEMRC].
                                                                 Internal:
                                                                 pedc_radm_nonfatal_err. */
        uint64_t rfemrc                : 1;  /**< [  7:  7](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RFEMRC].
                                                                 Internal:
                                                                 pedc_radm_fatal_err. */
        uint64_t rpmerc                : 1;  /**< [  8:  8](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RPMERC].
                                                                 Internal:
                                                                 pedc_radm_pm_pme. */
        uint64_t rptamrc               : 1;  /**< [  9:  9](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RPTAMRC].
                                                                 Internal:
                                                                 pedc_radm_pm_to_ack. */
        uint64_t rumep                 : 1;  /**< [ 10: 10](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RUMEP].
                                                                 Internal:
                                                                 pedc_radm_msg_unlock. */
        uint64_t rvdm                  : 1;  /**< [ 11: 11](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RVDM].
                                                                 Internal:
                                                                 pedc_radm_vendor_msg. */
        uint64_t acto                  : 1;  /**< [ 12: 12](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[ACTO].
                                                                 Internal:
                                                                 pedc_radm_cpl_timeout. */
        uint64_t rte                   : 1;  /**< [ 13: 13](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RTE].
                                                                 Internal:
                                                                 xdlh_replay_timeout_err. */
        uint64_t mre                   : 1;  /**< [ 14: 14](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[MRE].
                                                                 Internal:
                                                                 xdlh_replay_num_rlover_err. */
        uint64_t rdwdle                : 1;  /**< [ 15: 15](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RDWDLE].
                                                                 Internal:
                                                                 rdlh_bad_dllp_err. */
        uint64_t rtwdle                : 1;  /**< [ 16: 16](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RTWDLE].
                                                                 Internal:
                                                                 rdlh_bad_tlp_err. */
        uint64_t dpeoosd               : 1;  /**< [ 17: 17](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[DPEOOSD].
                                                                 Internal:
                                                                 rdlh_prot_err. */
        uint64_t fcpvwt                : 1;  /**< [ 18: 18](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[FCPVWT].
                                                                 Internal:
                                                                 rtlh_fc_prot_err. */
        uint64_t rpe                   : 1;  /**< [ 19: 19](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RPE].
                                                                 Internal:
                                                                 rmlh_rcvd_err. */
        uint64_t fcuv                  : 1;  /**< [ 20: 20](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[FCUV].
                                                                 Internal:
                                                                 (opt. checks) int_xadm_fc_prot_err. */
        uint64_t rqo                   : 1;  /**< [ 21: 21](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RQO].
                                                                 Internal:
                                                                 radm_qoverflow. */
        uint64_t rauc                  : 1;  /**< [ 22: 22](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RAUC].
                                                                 Internal:
                                                                 radm_unexp_cpl_err. */
        uint64_t racur                 : 1;  /**< [ 23: 23](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RACUR].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ur. */
        uint64_t racca                 : 1;  /**< [ 24: 24](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RACCA].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ca. */
        uint64_t caar                  : 1;  /**< [ 25: 25](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[CAAR]. */
        uint64_t rarwdns               : 1;  /**< [ 26: 26](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RARWDNS].
                                                                 Internal:
                                                                 radm_rcvd_ur_req. */
        uint64_t ramtlp                : 1;  /**< [ 27: 27](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RAMTLP].
                                                                 Internal:
                                                                 radm_mlf_tlp_err. */
        uint64_t racpp                 : 1;  /**< [ 28: 28](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RACPP].
                                                                 Internal:
                                                                 radm_rcvd_cpl_poisoned. */
        uint64_t rawwpp                : 1;  /**< [ 29: 29](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RAWWPP].
                                                                 Internal:
                                                                 radm_rcvd_wreq_poisoned. */
        uint64_t ecrc_e                : 1;  /**< [ 30: 30](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[ECRC_E]. */
        uint64_t lofp                  : 1;  /**< [ 31: 31](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[LOFP]. */
        uint64_t bmd_e                 : 1;  /**< [ 32: 32](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[BMD_E]. */
        uint64_t p_d0_sbe              : 1;  /**< [ 33: 33](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[P_D0_SBE]. */
        uint64_t p_d0_dbe              : 1;  /**< [ 34: 34](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[P_D0_DBE]. */
        uint64_t p_d1_sbe              : 1;  /**< [ 35: 35](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[P_D1_SBE]. */
        uint64_t p_d1_dbe              : 1;  /**< [ 36: 36](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[P_D1_DBE]. */
        uint64_t p_c_sbe               : 1;  /**< [ 37: 37](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[P_C_SBE]. */
        uint64_t p_c_dbe               : 1;  /**< [ 38: 38](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[P_C_DBE]. */
        uint64_t n_d0_sbe              : 1;  /**< [ 39: 39](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[N_D0_SBE]. */
        uint64_t n_d0_dbe              : 1;  /**< [ 40: 40](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[N_D0_DBE]. */
        uint64_t n_d1_sbe              : 1;  /**< [ 41: 41](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[N_D1_SBE]. */
        uint64_t n_d1_dbe              : 1;  /**< [ 42: 42](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[N_D1_DBE]. */
        uint64_t n_c_sbe               : 1;  /**< [ 43: 43](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[N_C_SBE]. */
        uint64_t n_c_dbe               : 1;  /**< [ 44: 44](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[N_C_DBE]. */
        uint64_t c_d0_sbe              : 1;  /**< [ 45: 45](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[C_D0_SBE]. */
        uint64_t c_d0_dbe              : 1;  /**< [ 46: 46](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[C_D0_DBE]. */
        uint64_t c_d1_sbe              : 1;  /**< [ 47: 47](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[C_D1_SBE]. */
        uint64_t c_d1_dbe              : 1;  /**< [ 48: 48](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[C_D1_DBE]. */
        uint64_t c_c_sbe               : 1;  /**< [ 49: 49](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[C_C_SBE]. */
        uint64_t c_c_dbe               : 1;  /**< [ 50: 50](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[C_C_DBE]. */
        uint64_t m2s_c_sbe             : 1;  /**< [ 51: 51](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[M2S_C_SBE]. */
        uint64_t m2s_c_dbe             : 1;  /**< [ 52: 52](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[M2S_C_DBE]. */
        uint64_t m2s_d_sbe             : 1;  /**< [ 53: 53](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[M2S_D_SBE]. */
        uint64_t m2s_d_dbe             : 1;  /**< [ 54: 54](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[M2S_D_DBE]. */
        uint64_t rasdp                 : 1;  /**< [ 55: 55](R/W1C/H) Reads or clears enable for PEM(0..3)_DBG_INFO[RASDP]. */
        uint64_t reserved_56_63        : 8;
#endif /* Word 0 - End */
    } cn83xx;
    struct bdk_pemx_dbg_ena_w1c_cn88xxp2
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_58_63        : 6;
        uint64_t m2s_pe                : 1;  /**< [ 57: 57](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[M2S_PE]. */
        uint64_t qhdr_b1_dbe           : 1;  /**< [ 56: 56](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[QHDR_B1_DBE]. */
        uint64_t qhdr_b1_sbe           : 1;  /**< [ 55: 55](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[QHDR_B1_SBE]. */
        uint64_t qhdr_b0_dbe           : 1;  /**< [ 54: 54](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[QHDR_B0_DBE]. */
        uint64_t qhdr_b0_sbe           : 1;  /**< [ 53: 53](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[QHDR_B0_SBE]. */
        uint64_t rtry_dbe              : 1;  /**< [ 52: 52](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RTRY_DBE]. */
        uint64_t rtry_sbe              : 1;  /**< [ 51: 51](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RTRY_SBE]. */
        uint64_t c_c_dbe               : 1;  /**< [ 50: 50](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[C_C_DBE]. */
        uint64_t c_c_sbe               : 1;  /**< [ 49: 49](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[C_C_SBE]. */
        uint64_t c_d1_dbe              : 1;  /**< [ 48: 48](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[C_D1_DBE]. */
        uint64_t c_d1_sbe              : 1;  /**< [ 47: 47](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[C_D1_SBE]. */
        uint64_t c_d0_dbe              : 1;  /**< [ 46: 46](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[C_D0_DBE]. */
        uint64_t c_d0_sbe              : 1;  /**< [ 45: 45](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[C_D0_SBE]. */
        uint64_t n_c_dbe               : 1;  /**< [ 44: 44](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[N_C_DBE]. */
        uint64_t n_c_sbe               : 1;  /**< [ 43: 43](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[N_C_SBE]. */
        uint64_t n_d1_dbe              : 1;  /**< [ 42: 42](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[N_D1_DBE]. */
        uint64_t n_d1_sbe              : 1;  /**< [ 41: 41](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[N_D1_SBE]. */
        uint64_t n_d0_dbe              : 1;  /**< [ 40: 40](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[N_D0_DBE]. */
        uint64_t n_d0_sbe              : 1;  /**< [ 39: 39](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[N_D0_SBE]. */
        uint64_t p_c_dbe               : 1;  /**< [ 38: 38](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[P_C_DBE]. */
        uint64_t p_c_sbe               : 1;  /**< [ 37: 37](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[P_C_SBE]. */
        uint64_t p_d1_dbe              : 1;  /**< [ 36: 36](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[P_D1_DBE]. */
        uint64_t p_d1_sbe              : 1;  /**< [ 35: 35](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[P_D1_SBE]. */
        uint64_t p_d0_dbe              : 1;  /**< [ 34: 34](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[P_D0_DBE]. */
        uint64_t p_d0_sbe              : 1;  /**< [ 33: 33](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[P_D0_SBE]. */
        uint64_t datq_pe               : 1;  /**< [ 32: 32](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[DATQ_PE]. */
        uint64_t lofp                  : 1;  /**< [ 31: 31](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[LOFP]. */
        uint64_t ecrc_e                : 1;  /**< [ 30: 30](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[ECRC_E]. */
        uint64_t rawwpp                : 1;  /**< [ 29: 29](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RAWWPP].
                                                                 Internal:
                                                                 radm_rcvd_wreq_poisoned. */
        uint64_t racpp                 : 1;  /**< [ 28: 28](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RACPP].
                                                                 Internal:
                                                                 radm_rcvd_cpl_poisoned. */
        uint64_t ramtlp                : 1;  /**< [ 27: 27](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RAMTLP].
                                                                 Internal:
                                                                 radm_mlf_tlp_err. */
        uint64_t rarwdns               : 1;  /**< [ 26: 26](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RARWDNS].
                                                                 Internal:
                                                                 radm_rcvd_ur_req. */
        uint64_t caar                  : 1;  /**< [ 25: 25](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[CAAR]. */
        uint64_t racca                 : 1;  /**< [ 24: 24](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RACCA].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ca. */
        uint64_t racur                 : 1;  /**< [ 23: 23](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RACUR].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ur. */
        uint64_t rauc                  : 1;  /**< [ 22: 22](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RAUC].
                                                                 Internal:
                                                                 radm_unexp_cpl_err. */
        uint64_t rqo                   : 1;  /**< [ 21: 21](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RQO].
                                                                 Internal:
                                                                 radm_qoverflow. */
        uint64_t fcuv                  : 1;  /**< [ 20: 20](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[FCUV].
                                                                 Internal:
                                                                 (opt. checks) int_xadm_fc_prot_err. */
        uint64_t rpe                   : 1;  /**< [ 19: 19](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RPE].
                                                                 Internal:
                                                                 rmlh_rcvd_err. */
        uint64_t fcpvwt                : 1;  /**< [ 18: 18](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[FCPVWT].
                                                                 Internal:
                                                                 rtlh_fc_prot_err. */
        uint64_t dpeoosd               : 1;  /**< [ 17: 17](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[DPEOOSD].
                                                                 Internal:
                                                                 rdlh_prot_err. */
        uint64_t rtwdle                : 1;  /**< [ 16: 16](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RTWDLE].
                                                                 Internal:
                                                                 rdlh_bad_tlp_err. */
        uint64_t rdwdle                : 1;  /**< [ 15: 15](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RDWDLE].
                                                                 Internal:
                                                                 rdlh_bad_dllp_err. */
        uint64_t mre                   : 1;  /**< [ 14: 14](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[MRE].
                                                                 Internal:
                                                                 xdlh_replay_num_rlover_err. */
        uint64_t rte                   : 1;  /**< [ 13: 13](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RTE].
                                                                 Internal:
                                                                 xdlh_replay_timeout_err. */
        uint64_t acto                  : 1;  /**< [ 12: 12](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[ACTO].
                                                                 Internal:
                                                                 pedc_radm_cpl_timeout. */
        uint64_t rvdm                  : 1;  /**< [ 11: 11](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RVDM].
                                                                 Internal:
                                                                 pedc_radm_vendor_msg. */
        uint64_t reserved_10           : 1;
        uint64_t rptamrc               : 1;  /**< [  9:  9](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RPTAMRC].
                                                                 Internal:
                                                                 pedc_radm_pm_to_ack. */
        uint64_t rpmerc                : 1;  /**< [  8:  8](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RPMERC].
                                                                 Internal:
                                                                 pedc_radm_pm_pme. */
        uint64_t rfemrc                : 1;  /**< [  7:  7](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RFEMRC].
                                                                 Internal:
                                                                 pedc_radm_fatal_err. */
        uint64_t rnfemrc               : 1;  /**< [  6:  6](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RNFEMRC].
                                                                 Internal:
                                                                 pedc_radm_nonfatal_err. */
        uint64_t rcemrc                : 1;  /**< [  5:  5](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RCEMRC].
                                                                 Internal:
                                                                 pedc_radm_correctable_err. */
        uint64_t rpoison               : 1;  /**< [  4:  4](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RPOISON].
                                                                 Internal:
                                                                 pedc__radm_trgt1_poisoned & pedc__radm_trgt1_hv. */
        uint64_t recrce                : 1;  /**< [  3:  3](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RECRCE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_ecrc_err & pedc__radm_trgt1_eot. */
        uint64_t rtlplle               : 1;  /**< [  2:  2](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RTLPLLE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_dllp_abort &
                                                                 pedc__radm_trgt1_eot. */
        uint64_t rtlpmal               : 1;  /**< [  1:  1](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RTLPMAL].
                                                                 Internal:
                                                                 pedc_radm_trgt1_tlp_abort & pedc__radm_trgt1_eot. */
        uint64_t spoison               : 1;  /**< [  0:  0](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[SPOISON].
                                                                 Internal:
                                                                 peai__client0_tlp_ep & peai__client0_tlp_hv or
                                                                 peai__client1_tlp_ep & peai__client1_tlp_hv (atomic_op). */
#else /* Word 0 - Little Endian */
        uint64_t spoison               : 1;  /**< [  0:  0](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[SPOISON].
                                                                 Internal:
                                                                 peai__client0_tlp_ep & peai__client0_tlp_hv or
                                                                 peai__client1_tlp_ep & peai__client1_tlp_hv (atomic_op). */
        uint64_t rtlpmal               : 1;  /**< [  1:  1](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RTLPMAL].
                                                                 Internal:
                                                                 pedc_radm_trgt1_tlp_abort & pedc__radm_trgt1_eot. */
        uint64_t rtlplle               : 1;  /**< [  2:  2](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RTLPLLE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_dllp_abort &
                                                                 pedc__radm_trgt1_eot. */
        uint64_t recrce                : 1;  /**< [  3:  3](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RECRCE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_ecrc_err & pedc__radm_trgt1_eot. */
        uint64_t rpoison               : 1;  /**< [  4:  4](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RPOISON].
                                                                 Internal:
                                                                 pedc__radm_trgt1_poisoned & pedc__radm_trgt1_hv. */
        uint64_t rcemrc                : 1;  /**< [  5:  5](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RCEMRC].
                                                                 Internal:
                                                                 pedc_radm_correctable_err. */
        uint64_t rnfemrc               : 1;  /**< [  6:  6](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RNFEMRC].
                                                                 Internal:
                                                                 pedc_radm_nonfatal_err. */
        uint64_t rfemrc                : 1;  /**< [  7:  7](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RFEMRC].
                                                                 Internal:
                                                                 pedc_radm_fatal_err. */
        uint64_t rpmerc                : 1;  /**< [  8:  8](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RPMERC].
                                                                 Internal:
                                                                 pedc_radm_pm_pme. */
        uint64_t rptamrc               : 1;  /**< [  9:  9](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RPTAMRC].
                                                                 Internal:
                                                                 pedc_radm_pm_to_ack. */
        uint64_t reserved_10           : 1;
        uint64_t rvdm                  : 1;  /**< [ 11: 11](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RVDM].
                                                                 Internal:
                                                                 pedc_radm_vendor_msg. */
        uint64_t acto                  : 1;  /**< [ 12: 12](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[ACTO].
                                                                 Internal:
                                                                 pedc_radm_cpl_timeout. */
        uint64_t rte                   : 1;  /**< [ 13: 13](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RTE].
                                                                 Internal:
                                                                 xdlh_replay_timeout_err. */
        uint64_t mre                   : 1;  /**< [ 14: 14](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[MRE].
                                                                 Internal:
                                                                 xdlh_replay_num_rlover_err. */
        uint64_t rdwdle                : 1;  /**< [ 15: 15](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RDWDLE].
                                                                 Internal:
                                                                 rdlh_bad_dllp_err. */
        uint64_t rtwdle                : 1;  /**< [ 16: 16](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RTWDLE].
                                                                 Internal:
                                                                 rdlh_bad_tlp_err. */
        uint64_t dpeoosd               : 1;  /**< [ 17: 17](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[DPEOOSD].
                                                                 Internal:
                                                                 rdlh_prot_err. */
        uint64_t fcpvwt                : 1;  /**< [ 18: 18](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[FCPVWT].
                                                                 Internal:
                                                                 rtlh_fc_prot_err. */
        uint64_t rpe                   : 1;  /**< [ 19: 19](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RPE].
                                                                 Internal:
                                                                 rmlh_rcvd_err. */
        uint64_t fcuv                  : 1;  /**< [ 20: 20](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[FCUV].
                                                                 Internal:
                                                                 (opt. checks) int_xadm_fc_prot_err. */
        uint64_t rqo                   : 1;  /**< [ 21: 21](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RQO].
                                                                 Internal:
                                                                 radm_qoverflow. */
        uint64_t rauc                  : 1;  /**< [ 22: 22](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RAUC].
                                                                 Internal:
                                                                 radm_unexp_cpl_err. */
        uint64_t racur                 : 1;  /**< [ 23: 23](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RACUR].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ur. */
        uint64_t racca                 : 1;  /**< [ 24: 24](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RACCA].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ca. */
        uint64_t caar                  : 1;  /**< [ 25: 25](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[CAAR]. */
        uint64_t rarwdns               : 1;  /**< [ 26: 26](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RARWDNS].
                                                                 Internal:
                                                                 radm_rcvd_ur_req. */
        uint64_t ramtlp                : 1;  /**< [ 27: 27](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RAMTLP].
                                                                 Internal:
                                                                 radm_mlf_tlp_err. */
        uint64_t racpp                 : 1;  /**< [ 28: 28](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RACPP].
                                                                 Internal:
                                                                 radm_rcvd_cpl_poisoned. */
        uint64_t rawwpp                : 1;  /**< [ 29: 29](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RAWWPP].
                                                                 Internal:
                                                                 radm_rcvd_wreq_poisoned. */
        uint64_t ecrc_e                : 1;  /**< [ 30: 30](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[ECRC_E]. */
        uint64_t lofp                  : 1;  /**< [ 31: 31](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[LOFP]. */
        uint64_t datq_pe               : 1;  /**< [ 32: 32](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[DATQ_PE]. */
        uint64_t p_d0_sbe              : 1;  /**< [ 33: 33](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[P_D0_SBE]. */
        uint64_t p_d0_dbe              : 1;  /**< [ 34: 34](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[P_D0_DBE]. */
        uint64_t p_d1_sbe              : 1;  /**< [ 35: 35](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[P_D1_SBE]. */
        uint64_t p_d1_dbe              : 1;  /**< [ 36: 36](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[P_D1_DBE]. */
        uint64_t p_c_sbe               : 1;  /**< [ 37: 37](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[P_C_SBE]. */
        uint64_t p_c_dbe               : 1;  /**< [ 38: 38](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[P_C_DBE]. */
        uint64_t n_d0_sbe              : 1;  /**< [ 39: 39](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[N_D0_SBE]. */
        uint64_t n_d0_dbe              : 1;  /**< [ 40: 40](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[N_D0_DBE]. */
        uint64_t n_d1_sbe              : 1;  /**< [ 41: 41](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[N_D1_SBE]. */
        uint64_t n_d1_dbe              : 1;  /**< [ 42: 42](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[N_D1_DBE]. */
        uint64_t n_c_sbe               : 1;  /**< [ 43: 43](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[N_C_SBE]. */
        uint64_t n_c_dbe               : 1;  /**< [ 44: 44](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[N_C_DBE]. */
        uint64_t c_d0_sbe              : 1;  /**< [ 45: 45](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[C_D0_SBE]. */
        uint64_t c_d0_dbe              : 1;  /**< [ 46: 46](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[C_D0_DBE]. */
        uint64_t c_d1_sbe              : 1;  /**< [ 47: 47](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[C_D1_SBE]. */
        uint64_t c_d1_dbe              : 1;  /**< [ 48: 48](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[C_D1_DBE]. */
        uint64_t c_c_sbe               : 1;  /**< [ 49: 49](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[C_C_SBE]. */
        uint64_t c_c_dbe               : 1;  /**< [ 50: 50](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[C_C_DBE]. */
        uint64_t rtry_sbe              : 1;  /**< [ 51: 51](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RTRY_SBE]. */
        uint64_t rtry_dbe              : 1;  /**< [ 52: 52](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[RTRY_DBE]. */
        uint64_t qhdr_b0_sbe           : 1;  /**< [ 53: 53](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[QHDR_B0_SBE]. */
        uint64_t qhdr_b0_dbe           : 1;  /**< [ 54: 54](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[QHDR_B0_DBE]. */
        uint64_t qhdr_b1_sbe           : 1;  /**< [ 55: 55](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[QHDR_B1_SBE]. */
        uint64_t qhdr_b1_dbe           : 1;  /**< [ 56: 56](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[QHDR_B1_DBE]. */
        uint64_t m2s_pe                : 1;  /**< [ 57: 57](R/W1C/H) Reads or clears enable for PEM(0..5)_DBG_INFO[M2S_PE]. */
        uint64_t reserved_58_63        : 6;
#endif /* Word 0 - End */
    } cn88xxp2;
};
typedef union bdk_pemx_dbg_ena_w1c bdk_pemx_dbg_ena_w1c_t;

static inline uint64_t BDK_PEMX_DBG_ENA_W1C(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_DBG_ENA_W1C(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN81XX) && (a<=2))
        return 0x87e0c0000458ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN83XX) && (a<=3))
        return 0x87e0c0000458ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN88XX) && (a<=5))
        return 0x87e0c0000458ll + 0x1000000ll * ((a) & 0x7);
    __bdk_csr_fatal("PEMX_DBG_ENA_W1C", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_DBG_ENA_W1C(a) bdk_pemx_dbg_ena_w1c_t
#define bustype_BDK_PEMX_DBG_ENA_W1C(a) BDK_CSR_TYPE_RSL
#define basename_BDK_PEMX_DBG_ENA_W1C(a) "PEMX_DBG_ENA_W1C"
#define device_bar_BDK_PEMX_DBG_ENA_W1C(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_DBG_ENA_W1C(a) (a)
#define arguments_BDK_PEMX_DBG_ENA_W1C(a) (a),-1,-1,-1

/**
 * Register (RSL) pem#_dbg_ena_w1s
 *
 * PEM Debug Information Enable Set Register
 * This register sets interrupt enable bits.
 */
union bdk_pemx_dbg_ena_w1s
{
    uint64_t u;
    struct bdk_pemx_dbg_ena_w1s_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_58_63        : 6;
        uint64_t m2s_pe                : 1;  /**< [ 57: 57](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[M2S_PE]. */
        uint64_t qhdr_b1_dbe           : 1;  /**< [ 56: 56](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[QHDR_B1_DBE]. */
        uint64_t reserved_51_55        : 5;
        uint64_t c_c_dbe               : 1;  /**< [ 50: 50](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[C_C_DBE]. */
        uint64_t c_c_sbe               : 1;  /**< [ 49: 49](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[C_C_SBE]. */
        uint64_t c_d1_dbe              : 1;  /**< [ 48: 48](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[C_D1_DBE]. */
        uint64_t c_d1_sbe              : 1;  /**< [ 47: 47](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[C_D1_SBE]. */
        uint64_t c_d0_dbe              : 1;  /**< [ 46: 46](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[C_D0_DBE]. */
        uint64_t c_d0_sbe              : 1;  /**< [ 45: 45](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[C_D0_SBE]. */
        uint64_t n_c_dbe               : 1;  /**< [ 44: 44](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[N_C_DBE]. */
        uint64_t n_c_sbe               : 1;  /**< [ 43: 43](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[N_C_SBE]. */
        uint64_t n_d1_dbe              : 1;  /**< [ 42: 42](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[N_D1_DBE]. */
        uint64_t n_d1_sbe              : 1;  /**< [ 41: 41](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[N_D1_SBE]. */
        uint64_t n_d0_dbe              : 1;  /**< [ 40: 40](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[N_D0_DBE]. */
        uint64_t n_d0_sbe              : 1;  /**< [ 39: 39](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[N_D0_SBE]. */
        uint64_t p_c_dbe               : 1;  /**< [ 38: 38](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[P_C_DBE]. */
        uint64_t p_c_sbe               : 1;  /**< [ 37: 37](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[P_C_SBE]. */
        uint64_t p_d1_dbe              : 1;  /**< [ 36: 36](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[P_D1_DBE]. */
        uint64_t p_d1_sbe              : 1;  /**< [ 35: 35](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[P_D1_SBE]. */
        uint64_t p_d0_dbe              : 1;  /**< [ 34: 34](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[P_D0_DBE]. */
        uint64_t p_d0_sbe              : 1;  /**< [ 33: 33](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[P_D0_SBE]. */
        uint64_t reserved_32           : 1;
        uint64_t lofp                  : 1;  /**< [ 31: 31](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[LOFP]. */
        uint64_t ecrc_e                : 1;  /**< [ 30: 30](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[ECRC_E]. */
        uint64_t rawwpp                : 1;  /**< [ 29: 29](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RAWWPP].
                                                                 Internal:
                                                                 radm_rcvd_wreq_poisoned. */
        uint64_t racpp                 : 1;  /**< [ 28: 28](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RACPP].
                                                                 Internal:
                                                                 radm_rcvd_cpl_poisoned. */
        uint64_t ramtlp                : 1;  /**< [ 27: 27](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RAMTLP].
                                                                 Internal:
                                                                 radm_mlf_tlp_err. */
        uint64_t rarwdns               : 1;  /**< [ 26: 26](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RARWDNS].
                                                                 Internal:
                                                                 radm_rcvd_ur_req. */
        uint64_t caar                  : 1;  /**< [ 25: 25](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[CAAR]. */
        uint64_t racca                 : 1;  /**< [ 24: 24](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RACCA].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ca. */
        uint64_t racur                 : 1;  /**< [ 23: 23](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RACUR].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ur. */
        uint64_t rauc                  : 1;  /**< [ 22: 22](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RAUC].
                                                                 Internal:
                                                                 radm_unexp_cpl_err. */
        uint64_t rqo                   : 1;  /**< [ 21: 21](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RQO].
                                                                 Internal:
                                                                 radm_qoverflow. */
        uint64_t fcuv                  : 1;  /**< [ 20: 20](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[FCUV].
                                                                 Internal:
                                                                 (opt. checks) int_xadm_fc_prot_err. */
        uint64_t rpe                   : 1;  /**< [ 19: 19](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RPE].
                                                                 Internal:
                                                                 rmlh_rcvd_err. */
        uint64_t fcpvwt                : 1;  /**< [ 18: 18](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[FCPVWT].
                                                                 Internal:
                                                                 rtlh_fc_prot_err. */
        uint64_t dpeoosd               : 1;  /**< [ 17: 17](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[DPEOOSD].
                                                                 Internal:
                                                                 rdlh_prot_err. */
        uint64_t rtwdle                : 1;  /**< [ 16: 16](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RTWDLE].
                                                                 Internal:
                                                                 rdlh_bad_tlp_err. */
        uint64_t rdwdle                : 1;  /**< [ 15: 15](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RDWDLE].
                                                                 Internal:
                                                                 rdlh_bad_dllp_err. */
        uint64_t mre                   : 1;  /**< [ 14: 14](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[MRE].
                                                                 Internal:
                                                                 xdlh_replay_num_rlover_err. */
        uint64_t rte                   : 1;  /**< [ 13: 13](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RTE].
                                                                 Internal:
                                                                 xdlh_replay_timeout_err. */
        uint64_t acto                  : 1;  /**< [ 12: 12](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[ACTO].
                                                                 Internal:
                                                                 pedc_radm_cpl_timeout. */
        uint64_t rvdm                  : 1;  /**< [ 11: 11](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RVDM].
                                                                 Internal:
                                                                 pedc_radm_vendor_msg. */
        uint64_t rumep                 : 1;  /**< [ 10: 10](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RUMEP].
                                                                 Internal:
                                                                 pedc_radm_msg_unlock. */
        uint64_t rptamrc               : 1;  /**< [  9:  9](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RPTAMRC].
                                                                 Internal:
                                                                 pedc_radm_pm_to_ack. */
        uint64_t rpmerc                : 1;  /**< [  8:  8](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RPMERC].
                                                                 Internal:
                                                                 pedc_radm_pm_pme. */
        uint64_t rfemrc                : 1;  /**< [  7:  7](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RFEMRC].
                                                                 Internal:
                                                                 pedc_radm_fatal_err. */
        uint64_t rnfemrc               : 1;  /**< [  6:  6](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RNFEMRC].
                                                                 Internal:
                                                                 pedc_radm_nonfatal_err. */
        uint64_t rcemrc                : 1;  /**< [  5:  5](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RCEMRC].
                                                                 Internal:
                                                                 pedc_radm_correctable_err. */
        uint64_t rpoison               : 1;  /**< [  4:  4](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RPOISON].
                                                                 Internal:
                                                                 pedc__radm_trgt1_poisoned & pedc__radm_trgt1_hv. */
        uint64_t recrce                : 1;  /**< [  3:  3](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RECRCE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_ecrc_err & pedc__radm_trgt1_eot. */
        uint64_t rtlplle               : 1;  /**< [  2:  2](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RTLPLLE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_dllp_abort &
                                                                 pedc__radm_trgt1_eot. */
        uint64_t rtlpmal               : 1;  /**< [  1:  1](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RTLPMAL].
                                                                 Internal:
                                                                 pedc_radm_trgt1_tlp_abort & pedc__radm_trgt1_eot. */
        uint64_t spoison               : 1;  /**< [  0:  0](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[SPOISON].
                                                                 Internal:
                                                                 peai__client0_tlp_ep & peai__client0_tlp_hv or
                                                                 peai__client1_tlp_ep & peai__client1_tlp_hv (atomic_op). */
#else /* Word 0 - Little Endian */
        uint64_t spoison               : 1;  /**< [  0:  0](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[SPOISON].
                                                                 Internal:
                                                                 peai__client0_tlp_ep & peai__client0_tlp_hv or
                                                                 peai__client1_tlp_ep & peai__client1_tlp_hv (atomic_op). */
        uint64_t rtlpmal               : 1;  /**< [  1:  1](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RTLPMAL].
                                                                 Internal:
                                                                 pedc_radm_trgt1_tlp_abort & pedc__radm_trgt1_eot. */
        uint64_t rtlplle               : 1;  /**< [  2:  2](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RTLPLLE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_dllp_abort &
                                                                 pedc__radm_trgt1_eot. */
        uint64_t recrce                : 1;  /**< [  3:  3](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RECRCE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_ecrc_err & pedc__radm_trgt1_eot. */
        uint64_t rpoison               : 1;  /**< [  4:  4](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RPOISON].
                                                                 Internal:
                                                                 pedc__radm_trgt1_poisoned & pedc__radm_trgt1_hv. */
        uint64_t rcemrc                : 1;  /**< [  5:  5](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RCEMRC].
                                                                 Internal:
                                                                 pedc_radm_correctable_err. */
        uint64_t rnfemrc               : 1;  /**< [  6:  6](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RNFEMRC].
                                                                 Internal:
                                                                 pedc_radm_nonfatal_err. */
        uint64_t rfemrc                : 1;  /**< [  7:  7](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RFEMRC].
                                                                 Internal:
                                                                 pedc_radm_fatal_err. */
        uint64_t rpmerc                : 1;  /**< [  8:  8](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RPMERC].
                                                                 Internal:
                                                                 pedc_radm_pm_pme. */
        uint64_t rptamrc               : 1;  /**< [  9:  9](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RPTAMRC].
                                                                 Internal:
                                                                 pedc_radm_pm_to_ack. */
        uint64_t rumep                 : 1;  /**< [ 10: 10](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RUMEP].
                                                                 Internal:
                                                                 pedc_radm_msg_unlock. */
        uint64_t rvdm                  : 1;  /**< [ 11: 11](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RVDM].
                                                                 Internal:
                                                                 pedc_radm_vendor_msg. */
        uint64_t acto                  : 1;  /**< [ 12: 12](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[ACTO].
                                                                 Internal:
                                                                 pedc_radm_cpl_timeout. */
        uint64_t rte                   : 1;  /**< [ 13: 13](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RTE].
                                                                 Internal:
                                                                 xdlh_replay_timeout_err. */
        uint64_t mre                   : 1;  /**< [ 14: 14](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[MRE].
                                                                 Internal:
                                                                 xdlh_replay_num_rlover_err. */
        uint64_t rdwdle                : 1;  /**< [ 15: 15](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RDWDLE].
                                                                 Internal:
                                                                 rdlh_bad_dllp_err. */
        uint64_t rtwdle                : 1;  /**< [ 16: 16](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RTWDLE].
                                                                 Internal:
                                                                 rdlh_bad_tlp_err. */
        uint64_t dpeoosd               : 1;  /**< [ 17: 17](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[DPEOOSD].
                                                                 Internal:
                                                                 rdlh_prot_err. */
        uint64_t fcpvwt                : 1;  /**< [ 18: 18](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[FCPVWT].
                                                                 Internal:
                                                                 rtlh_fc_prot_err. */
        uint64_t rpe                   : 1;  /**< [ 19: 19](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RPE].
                                                                 Internal:
                                                                 rmlh_rcvd_err. */
        uint64_t fcuv                  : 1;  /**< [ 20: 20](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[FCUV].
                                                                 Internal:
                                                                 (opt. checks) int_xadm_fc_prot_err. */
        uint64_t rqo                   : 1;  /**< [ 21: 21](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RQO].
                                                                 Internal:
                                                                 radm_qoverflow. */
        uint64_t rauc                  : 1;  /**< [ 22: 22](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RAUC].
                                                                 Internal:
                                                                 radm_unexp_cpl_err. */
        uint64_t racur                 : 1;  /**< [ 23: 23](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RACUR].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ur. */
        uint64_t racca                 : 1;  /**< [ 24: 24](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RACCA].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ca. */
        uint64_t caar                  : 1;  /**< [ 25: 25](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[CAAR]. */
        uint64_t rarwdns               : 1;  /**< [ 26: 26](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RARWDNS].
                                                                 Internal:
                                                                 radm_rcvd_ur_req. */
        uint64_t ramtlp                : 1;  /**< [ 27: 27](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RAMTLP].
                                                                 Internal:
                                                                 radm_mlf_tlp_err. */
        uint64_t racpp                 : 1;  /**< [ 28: 28](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RACPP].
                                                                 Internal:
                                                                 radm_rcvd_cpl_poisoned. */
        uint64_t rawwpp                : 1;  /**< [ 29: 29](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RAWWPP].
                                                                 Internal:
                                                                 radm_rcvd_wreq_poisoned. */
        uint64_t ecrc_e                : 1;  /**< [ 30: 30](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[ECRC_E]. */
        uint64_t lofp                  : 1;  /**< [ 31: 31](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[LOFP]. */
        uint64_t reserved_32           : 1;
        uint64_t p_d0_sbe              : 1;  /**< [ 33: 33](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[P_D0_SBE]. */
        uint64_t p_d0_dbe              : 1;  /**< [ 34: 34](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[P_D0_DBE]. */
        uint64_t p_d1_sbe              : 1;  /**< [ 35: 35](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[P_D1_SBE]. */
        uint64_t p_d1_dbe              : 1;  /**< [ 36: 36](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[P_D1_DBE]. */
        uint64_t p_c_sbe               : 1;  /**< [ 37: 37](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[P_C_SBE]. */
        uint64_t p_c_dbe               : 1;  /**< [ 38: 38](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[P_C_DBE]. */
        uint64_t n_d0_sbe              : 1;  /**< [ 39: 39](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[N_D0_SBE]. */
        uint64_t n_d0_dbe              : 1;  /**< [ 40: 40](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[N_D0_DBE]. */
        uint64_t n_d1_sbe              : 1;  /**< [ 41: 41](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[N_D1_SBE]. */
        uint64_t n_d1_dbe              : 1;  /**< [ 42: 42](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[N_D1_DBE]. */
        uint64_t n_c_sbe               : 1;  /**< [ 43: 43](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[N_C_SBE]. */
        uint64_t n_c_dbe               : 1;  /**< [ 44: 44](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[N_C_DBE]. */
        uint64_t c_d0_sbe              : 1;  /**< [ 45: 45](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[C_D0_SBE]. */
        uint64_t c_d0_dbe              : 1;  /**< [ 46: 46](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[C_D0_DBE]. */
        uint64_t c_d1_sbe              : 1;  /**< [ 47: 47](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[C_D1_SBE]. */
        uint64_t c_d1_dbe              : 1;  /**< [ 48: 48](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[C_D1_DBE]. */
        uint64_t c_c_sbe               : 1;  /**< [ 49: 49](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[C_C_SBE]. */
        uint64_t c_c_dbe               : 1;  /**< [ 50: 50](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[C_C_DBE]. */
        uint64_t reserved_51_55        : 5;
        uint64_t qhdr_b1_dbe           : 1;  /**< [ 56: 56](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[QHDR_B1_DBE]. */
        uint64_t m2s_pe                : 1;  /**< [ 57: 57](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[M2S_PE]. */
        uint64_t reserved_58_63        : 6;
#endif /* Word 0 - End */
    } s;
    struct bdk_pemx_dbg_ena_w1s_cn88xxp1
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_57_63        : 7;
        uint64_t qhdr_b1_dbe           : 1;  /**< [ 56: 56](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[QHDR_B1_DBE]. */
        uint64_t qhdr_b1_sbe           : 1;  /**< [ 55: 55](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[QHDR_B1_SBE]. */
        uint64_t qhdr_b0_dbe           : 1;  /**< [ 54: 54](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[QHDR_B0_DBE]. */
        uint64_t qhdr_b0_sbe           : 1;  /**< [ 53: 53](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[QHDR_B0_SBE]. */
        uint64_t rtry_dbe              : 1;  /**< [ 52: 52](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RTRY_DBE]. */
        uint64_t rtry_sbe              : 1;  /**< [ 51: 51](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RTRY_SBE]. */
        uint64_t c_c_dbe               : 1;  /**< [ 50: 50](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[C_C_DBE]. */
        uint64_t c_c_sbe               : 1;  /**< [ 49: 49](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[C_C_SBE]. */
        uint64_t c_d1_dbe              : 1;  /**< [ 48: 48](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[C_D1_DBE]. */
        uint64_t c_d1_sbe              : 1;  /**< [ 47: 47](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[C_D1_SBE]. */
        uint64_t c_d0_dbe              : 1;  /**< [ 46: 46](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[C_D0_DBE]. */
        uint64_t c_d0_sbe              : 1;  /**< [ 45: 45](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[C_D0_SBE]. */
        uint64_t n_c_dbe               : 1;  /**< [ 44: 44](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[N_C_DBE]. */
        uint64_t n_c_sbe               : 1;  /**< [ 43: 43](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[N_C_SBE]. */
        uint64_t n_d1_dbe              : 1;  /**< [ 42: 42](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[N_D1_DBE]. */
        uint64_t n_d1_sbe              : 1;  /**< [ 41: 41](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[N_D1_SBE]. */
        uint64_t n_d0_dbe              : 1;  /**< [ 40: 40](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[N_D0_DBE]. */
        uint64_t n_d0_sbe              : 1;  /**< [ 39: 39](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[N_D0_SBE]. */
        uint64_t p_c_dbe               : 1;  /**< [ 38: 38](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[P_C_DBE]. */
        uint64_t p_c_sbe               : 1;  /**< [ 37: 37](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[P_C_SBE]. */
        uint64_t p_d1_dbe              : 1;  /**< [ 36: 36](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[P_D1_DBE]. */
        uint64_t p_d1_sbe              : 1;  /**< [ 35: 35](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[P_D1_SBE]. */
        uint64_t p_d0_dbe              : 1;  /**< [ 34: 34](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[P_D0_DBE]. */
        uint64_t p_d0_sbe              : 1;  /**< [ 33: 33](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[P_D0_SBE]. */
        uint64_t datq_pe               : 1;  /**< [ 32: 32](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[DATQ_PE]. */
        uint64_t lofp                  : 1;  /**< [ 31: 31](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[LOFP]. */
        uint64_t ecrc_e                : 1;  /**< [ 30: 30](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[ECRC_E]. */
        uint64_t rawwpp                : 1;  /**< [ 29: 29](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RAWWPP].
                                                                 Internal:
                                                                 radm_rcvd_wreq_poisoned. */
        uint64_t racpp                 : 1;  /**< [ 28: 28](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RACPP].
                                                                 Internal:
                                                                 radm_rcvd_cpl_poisoned. */
        uint64_t ramtlp                : 1;  /**< [ 27: 27](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RAMTLP].
                                                                 Internal:
                                                                 radm_mlf_tlp_err. */
        uint64_t rarwdns               : 1;  /**< [ 26: 26](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RARWDNS].
                                                                 Internal:
                                                                 radm_rcvd_ur_req. */
        uint64_t caar                  : 1;  /**< [ 25: 25](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[CAAR]. */
        uint64_t racca                 : 1;  /**< [ 24: 24](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RACCA].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ca. */
        uint64_t racur                 : 1;  /**< [ 23: 23](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RACUR].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ur. */
        uint64_t rauc                  : 1;  /**< [ 22: 22](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RAUC].
                                                                 Internal:
                                                                 radm_unexp_cpl_err. */
        uint64_t rqo                   : 1;  /**< [ 21: 21](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RQO].
                                                                 Internal:
                                                                 radm_qoverflow. */
        uint64_t fcuv                  : 1;  /**< [ 20: 20](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[FCUV].
                                                                 Internal:
                                                                 (opt. checks) int_xadm_fc_prot_err. */
        uint64_t rpe                   : 1;  /**< [ 19: 19](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RPE].
                                                                 Internal:
                                                                 rmlh_rcvd_err. */
        uint64_t fcpvwt                : 1;  /**< [ 18: 18](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[FCPVWT].
                                                                 Internal:
                                                                 rtlh_fc_prot_err. */
        uint64_t dpeoosd               : 1;  /**< [ 17: 17](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[DPEOOSD].
                                                                 Internal:
                                                                 rdlh_prot_err. */
        uint64_t rtwdle                : 1;  /**< [ 16: 16](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RTWDLE].
                                                                 Internal:
                                                                 rdlh_bad_tlp_err. */
        uint64_t rdwdle                : 1;  /**< [ 15: 15](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RDWDLE].
                                                                 Internal:
                                                                 rdlh_bad_dllp_err. */
        uint64_t mre                   : 1;  /**< [ 14: 14](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[MRE].
                                                                 Internal:
                                                                 xdlh_replay_num_rlover_err. */
        uint64_t rte                   : 1;  /**< [ 13: 13](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RTE].
                                                                 Internal:
                                                                 xdlh_replay_timeout_err. */
        uint64_t acto                  : 1;  /**< [ 12: 12](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[ACTO].
                                                                 Internal:
                                                                 pedc_radm_cpl_timeout. */
        uint64_t rvdm                  : 1;  /**< [ 11: 11](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RVDM].
                                                                 Internal:
                                                                 pedc_radm_vendor_msg. */
        uint64_t reserved_10           : 1;
        uint64_t rptamrc               : 1;  /**< [  9:  9](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RPTAMRC].
                                                                 Internal:
                                                                 pedc_radm_pm_to_ack. */
        uint64_t rpmerc                : 1;  /**< [  8:  8](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RPMERC].
                                                                 Internal:
                                                                 pedc_radm_pm_pme. */
        uint64_t rfemrc                : 1;  /**< [  7:  7](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RFEMRC].
                                                                 Internal:
                                                                 pedc_radm_fatal_err. */
        uint64_t rnfemrc               : 1;  /**< [  6:  6](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RNFEMRC].
                                                                 Internal:
                                                                 pedc_radm_nonfatal_err. */
        uint64_t rcemrc                : 1;  /**< [  5:  5](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RCEMRC].
                                                                 Internal:
                                                                 pedc_radm_correctable_err. */
        uint64_t rpoison               : 1;  /**< [  4:  4](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RPOISON].
                                                                 Internal:
                                                                 pedc__radm_trgt1_poisoned & pedc__radm_trgt1_hv. */
        uint64_t recrce                : 1;  /**< [  3:  3](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RECRCE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_ecrc_err & pedc__radm_trgt1_eot. */
        uint64_t rtlplle               : 1;  /**< [  2:  2](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RTLPLLE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_dllp_abort &
                                                                 pedc__radm_trgt1_eot. */
        uint64_t rtlpmal               : 1;  /**< [  1:  1](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RTLPMAL].
                                                                 Internal:
                                                                 pedc_radm_trgt1_tlp_abort & pedc__radm_trgt1_eot. */
        uint64_t spoison               : 1;  /**< [  0:  0](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[SPOISON].
                                                                 Internal:
                                                                 peai__client0_tlp_ep & peai__client0_tlp_hv or
                                                                 peai__client1_tlp_ep & peai__client1_tlp_hv (atomic_op). */
#else /* Word 0 - Little Endian */
        uint64_t spoison               : 1;  /**< [  0:  0](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[SPOISON].
                                                                 Internal:
                                                                 peai__client0_tlp_ep & peai__client0_tlp_hv or
                                                                 peai__client1_tlp_ep & peai__client1_tlp_hv (atomic_op). */
        uint64_t rtlpmal               : 1;  /**< [  1:  1](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RTLPMAL].
                                                                 Internal:
                                                                 pedc_radm_trgt1_tlp_abort & pedc__radm_trgt1_eot. */
        uint64_t rtlplle               : 1;  /**< [  2:  2](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RTLPLLE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_dllp_abort &
                                                                 pedc__radm_trgt1_eot. */
        uint64_t recrce                : 1;  /**< [  3:  3](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RECRCE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_ecrc_err & pedc__radm_trgt1_eot. */
        uint64_t rpoison               : 1;  /**< [  4:  4](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RPOISON].
                                                                 Internal:
                                                                 pedc__radm_trgt1_poisoned & pedc__radm_trgt1_hv. */
        uint64_t rcemrc                : 1;  /**< [  5:  5](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RCEMRC].
                                                                 Internal:
                                                                 pedc_radm_correctable_err. */
        uint64_t rnfemrc               : 1;  /**< [  6:  6](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RNFEMRC].
                                                                 Internal:
                                                                 pedc_radm_nonfatal_err. */
        uint64_t rfemrc                : 1;  /**< [  7:  7](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RFEMRC].
                                                                 Internal:
                                                                 pedc_radm_fatal_err. */
        uint64_t rpmerc                : 1;  /**< [  8:  8](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RPMERC].
                                                                 Internal:
                                                                 pedc_radm_pm_pme. */
        uint64_t rptamrc               : 1;  /**< [  9:  9](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RPTAMRC].
                                                                 Internal:
                                                                 pedc_radm_pm_to_ack. */
        uint64_t reserved_10           : 1;
        uint64_t rvdm                  : 1;  /**< [ 11: 11](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RVDM].
                                                                 Internal:
                                                                 pedc_radm_vendor_msg. */
        uint64_t acto                  : 1;  /**< [ 12: 12](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[ACTO].
                                                                 Internal:
                                                                 pedc_radm_cpl_timeout. */
        uint64_t rte                   : 1;  /**< [ 13: 13](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RTE].
                                                                 Internal:
                                                                 xdlh_replay_timeout_err. */
        uint64_t mre                   : 1;  /**< [ 14: 14](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[MRE].
                                                                 Internal:
                                                                 xdlh_replay_num_rlover_err. */
        uint64_t rdwdle                : 1;  /**< [ 15: 15](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RDWDLE].
                                                                 Internal:
                                                                 rdlh_bad_dllp_err. */
        uint64_t rtwdle                : 1;  /**< [ 16: 16](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RTWDLE].
                                                                 Internal:
                                                                 rdlh_bad_tlp_err. */
        uint64_t dpeoosd               : 1;  /**< [ 17: 17](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[DPEOOSD].
                                                                 Internal:
                                                                 rdlh_prot_err. */
        uint64_t fcpvwt                : 1;  /**< [ 18: 18](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[FCPVWT].
                                                                 Internal:
                                                                 rtlh_fc_prot_err. */
        uint64_t rpe                   : 1;  /**< [ 19: 19](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RPE].
                                                                 Internal:
                                                                 rmlh_rcvd_err. */
        uint64_t fcuv                  : 1;  /**< [ 20: 20](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[FCUV].
                                                                 Internal:
                                                                 (opt. checks) int_xadm_fc_prot_err. */
        uint64_t rqo                   : 1;  /**< [ 21: 21](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RQO].
                                                                 Internal:
                                                                 radm_qoverflow. */
        uint64_t rauc                  : 1;  /**< [ 22: 22](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RAUC].
                                                                 Internal:
                                                                 radm_unexp_cpl_err. */
        uint64_t racur                 : 1;  /**< [ 23: 23](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RACUR].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ur. */
        uint64_t racca                 : 1;  /**< [ 24: 24](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RACCA].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ca. */
        uint64_t caar                  : 1;  /**< [ 25: 25](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[CAAR]. */
        uint64_t rarwdns               : 1;  /**< [ 26: 26](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RARWDNS].
                                                                 Internal:
                                                                 radm_rcvd_ur_req. */
        uint64_t ramtlp                : 1;  /**< [ 27: 27](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RAMTLP].
                                                                 Internal:
                                                                 radm_mlf_tlp_err. */
        uint64_t racpp                 : 1;  /**< [ 28: 28](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RACPP].
                                                                 Internal:
                                                                 radm_rcvd_cpl_poisoned. */
        uint64_t rawwpp                : 1;  /**< [ 29: 29](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RAWWPP].
                                                                 Internal:
                                                                 radm_rcvd_wreq_poisoned. */
        uint64_t ecrc_e                : 1;  /**< [ 30: 30](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[ECRC_E]. */
        uint64_t lofp                  : 1;  /**< [ 31: 31](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[LOFP]. */
        uint64_t datq_pe               : 1;  /**< [ 32: 32](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[DATQ_PE]. */
        uint64_t p_d0_sbe              : 1;  /**< [ 33: 33](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[P_D0_SBE]. */
        uint64_t p_d0_dbe              : 1;  /**< [ 34: 34](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[P_D0_DBE]. */
        uint64_t p_d1_sbe              : 1;  /**< [ 35: 35](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[P_D1_SBE]. */
        uint64_t p_d1_dbe              : 1;  /**< [ 36: 36](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[P_D1_DBE]. */
        uint64_t p_c_sbe               : 1;  /**< [ 37: 37](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[P_C_SBE]. */
        uint64_t p_c_dbe               : 1;  /**< [ 38: 38](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[P_C_DBE]. */
        uint64_t n_d0_sbe              : 1;  /**< [ 39: 39](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[N_D0_SBE]. */
        uint64_t n_d0_dbe              : 1;  /**< [ 40: 40](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[N_D0_DBE]. */
        uint64_t n_d1_sbe              : 1;  /**< [ 41: 41](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[N_D1_SBE]. */
        uint64_t n_d1_dbe              : 1;  /**< [ 42: 42](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[N_D1_DBE]. */
        uint64_t n_c_sbe               : 1;  /**< [ 43: 43](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[N_C_SBE]. */
        uint64_t n_c_dbe               : 1;  /**< [ 44: 44](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[N_C_DBE]. */
        uint64_t c_d0_sbe              : 1;  /**< [ 45: 45](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[C_D0_SBE]. */
        uint64_t c_d0_dbe              : 1;  /**< [ 46: 46](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[C_D0_DBE]. */
        uint64_t c_d1_sbe              : 1;  /**< [ 47: 47](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[C_D1_SBE]. */
        uint64_t c_d1_dbe              : 1;  /**< [ 48: 48](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[C_D1_DBE]. */
        uint64_t c_c_sbe               : 1;  /**< [ 49: 49](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[C_C_SBE]. */
        uint64_t c_c_dbe               : 1;  /**< [ 50: 50](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[C_C_DBE]. */
        uint64_t rtry_sbe              : 1;  /**< [ 51: 51](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RTRY_SBE]. */
        uint64_t rtry_dbe              : 1;  /**< [ 52: 52](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RTRY_DBE]. */
        uint64_t qhdr_b0_sbe           : 1;  /**< [ 53: 53](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[QHDR_B0_SBE]. */
        uint64_t qhdr_b0_dbe           : 1;  /**< [ 54: 54](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[QHDR_B0_DBE]. */
        uint64_t qhdr_b1_sbe           : 1;  /**< [ 55: 55](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[QHDR_B1_SBE]. */
        uint64_t qhdr_b1_dbe           : 1;  /**< [ 56: 56](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[QHDR_B1_DBE]. */
        uint64_t reserved_57_63        : 7;
#endif /* Word 0 - End */
    } cn88xxp1;
    struct bdk_pemx_dbg_ena_w1s_cn81xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_58_63        : 6;
        uint64_t m2s_pe                : 1;  /**< [ 57: 57](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[M2S_PE]. */
        uint64_t qhdr_b1_dbe           : 1;  /**< [ 56: 56](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[QHDR_B1_DBE]. */
        uint64_t qhdr_b1_sbe           : 1;  /**< [ 55: 55](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[QHDR_B1_SBE]. */
        uint64_t qhdr_b0_dbe           : 1;  /**< [ 54: 54](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[QHDR_B0_DBE]. */
        uint64_t qhdr_b0_sbe           : 1;  /**< [ 53: 53](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[QHDR_B0_SBE]. */
        uint64_t rtry_dbe              : 1;  /**< [ 52: 52](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RTRY_DBE]. */
        uint64_t rtry_sbe              : 1;  /**< [ 51: 51](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RTRY_SBE]. */
        uint64_t c_c_dbe               : 1;  /**< [ 50: 50](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[C_C_DBE]. */
        uint64_t c_c_sbe               : 1;  /**< [ 49: 49](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[C_C_SBE]. */
        uint64_t c_d1_dbe              : 1;  /**< [ 48: 48](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[C_D1_DBE]. */
        uint64_t c_d1_sbe              : 1;  /**< [ 47: 47](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[C_D1_SBE]. */
        uint64_t c_d0_dbe              : 1;  /**< [ 46: 46](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[C_D0_DBE]. */
        uint64_t c_d0_sbe              : 1;  /**< [ 45: 45](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[C_D0_SBE]. */
        uint64_t n_c_dbe               : 1;  /**< [ 44: 44](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[N_C_DBE]. */
        uint64_t n_c_sbe               : 1;  /**< [ 43: 43](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[N_C_SBE]. */
        uint64_t n_d1_dbe              : 1;  /**< [ 42: 42](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[N_D1_DBE]. */
        uint64_t n_d1_sbe              : 1;  /**< [ 41: 41](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[N_D1_SBE]. */
        uint64_t n_d0_dbe              : 1;  /**< [ 40: 40](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[N_D0_DBE]. */
        uint64_t n_d0_sbe              : 1;  /**< [ 39: 39](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[N_D0_SBE]. */
        uint64_t p_c_dbe               : 1;  /**< [ 38: 38](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[P_C_DBE]. */
        uint64_t p_c_sbe               : 1;  /**< [ 37: 37](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[P_C_SBE]. */
        uint64_t p_d1_dbe              : 1;  /**< [ 36: 36](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[P_D1_DBE]. */
        uint64_t p_d1_sbe              : 1;  /**< [ 35: 35](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[P_D1_SBE]. */
        uint64_t p_d0_dbe              : 1;  /**< [ 34: 34](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[P_D0_DBE]. */
        uint64_t p_d0_sbe              : 1;  /**< [ 33: 33](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[P_D0_SBE]. */
        uint64_t datq_pe               : 1;  /**< [ 32: 32](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[DATQ_PE]. */
        uint64_t lofp                  : 1;  /**< [ 31: 31](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[LOFP]. */
        uint64_t ecrc_e                : 1;  /**< [ 30: 30](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[ECRC_E]. */
        uint64_t rawwpp                : 1;  /**< [ 29: 29](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RAWWPP].
                                                                 Internal:
                                                                 radm_rcvd_wreq_poisoned. */
        uint64_t racpp                 : 1;  /**< [ 28: 28](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RACPP].
                                                                 Internal:
                                                                 radm_rcvd_cpl_poisoned. */
        uint64_t ramtlp                : 1;  /**< [ 27: 27](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RAMTLP].
                                                                 Internal:
                                                                 radm_mlf_tlp_err. */
        uint64_t rarwdns               : 1;  /**< [ 26: 26](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RARWDNS].
                                                                 Internal:
                                                                 radm_rcvd_ur_req. */
        uint64_t caar                  : 1;  /**< [ 25: 25](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[CAAR]. */
        uint64_t racca                 : 1;  /**< [ 24: 24](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RACCA].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ca. */
        uint64_t racur                 : 1;  /**< [ 23: 23](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RACUR].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ur. */
        uint64_t rauc                  : 1;  /**< [ 22: 22](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RAUC].
                                                                 Internal:
                                                                 radm_unexp_cpl_err. */
        uint64_t rqo                   : 1;  /**< [ 21: 21](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RQO].
                                                                 Internal:
                                                                 radm_qoverflow. */
        uint64_t fcuv                  : 1;  /**< [ 20: 20](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[FCUV].
                                                                 Internal:
                                                                 (opt. checks) int_xadm_fc_prot_err. */
        uint64_t rpe                   : 1;  /**< [ 19: 19](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RPE].
                                                                 Internal:
                                                                 rmlh_rcvd_err. */
        uint64_t fcpvwt                : 1;  /**< [ 18: 18](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[FCPVWT].
                                                                 Internal:
                                                                 rtlh_fc_prot_err. */
        uint64_t dpeoosd               : 1;  /**< [ 17: 17](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[DPEOOSD].
                                                                 Internal:
                                                                 rdlh_prot_err. */
        uint64_t rtwdle                : 1;  /**< [ 16: 16](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RTWDLE].
                                                                 Internal:
                                                                 rdlh_bad_tlp_err. */
        uint64_t rdwdle                : 1;  /**< [ 15: 15](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RDWDLE].
                                                                 Internal:
                                                                 rdlh_bad_dllp_err. */
        uint64_t mre                   : 1;  /**< [ 14: 14](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[MRE].
                                                                 Internal:
                                                                 xdlh_replay_num_rlover_err. */
        uint64_t rte                   : 1;  /**< [ 13: 13](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RTE].
                                                                 Internal:
                                                                 xdlh_replay_timeout_err. */
        uint64_t acto                  : 1;  /**< [ 12: 12](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[ACTO].
                                                                 Internal:
                                                                 pedc_radm_cpl_timeout. */
        uint64_t rvdm                  : 1;  /**< [ 11: 11](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RVDM].
                                                                 Internal:
                                                                 pedc_radm_vendor_msg. */
        uint64_t reserved_10           : 1;
        uint64_t rptamrc               : 1;  /**< [  9:  9](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RPTAMRC].
                                                                 Internal:
                                                                 pedc_radm_pm_to_ack. */
        uint64_t rpmerc                : 1;  /**< [  8:  8](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RPMERC].
                                                                 Internal:
                                                                 pedc_radm_pm_pme. */
        uint64_t rfemrc                : 1;  /**< [  7:  7](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RFEMRC].
                                                                 Internal:
                                                                 pedc_radm_fatal_err. */
        uint64_t rnfemrc               : 1;  /**< [  6:  6](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RNFEMRC].
                                                                 Internal:
                                                                 pedc_radm_nonfatal_err. */
        uint64_t rcemrc                : 1;  /**< [  5:  5](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RCEMRC].
                                                                 Internal:
                                                                 pedc_radm_correctable_err. */
        uint64_t rpoison               : 1;  /**< [  4:  4](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RPOISON].
                                                                 Internal:
                                                                 pedc__radm_trgt1_poisoned & pedc__radm_trgt1_hv. */
        uint64_t recrce                : 1;  /**< [  3:  3](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RECRCE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_ecrc_err & pedc__radm_trgt1_eot. */
        uint64_t rtlplle               : 1;  /**< [  2:  2](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RTLPLLE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_dllp_abort &
                                                                 pedc__radm_trgt1_eot. */
        uint64_t rtlpmal               : 1;  /**< [  1:  1](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RTLPMAL].
                                                                 Internal:
                                                                 pedc_radm_trgt1_tlp_abort & pedc__radm_trgt1_eot. */
        uint64_t spoison               : 1;  /**< [  0:  0](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[SPOISON].
                                                                 Internal:
                                                                 peai__client0_tlp_ep & peai__client0_tlp_hv or
                                                                 peai__client1_tlp_ep & peai__client1_tlp_hv (atomic_op). */
#else /* Word 0 - Little Endian */
        uint64_t spoison               : 1;  /**< [  0:  0](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[SPOISON].
                                                                 Internal:
                                                                 peai__client0_tlp_ep & peai__client0_tlp_hv or
                                                                 peai__client1_tlp_ep & peai__client1_tlp_hv (atomic_op). */
        uint64_t rtlpmal               : 1;  /**< [  1:  1](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RTLPMAL].
                                                                 Internal:
                                                                 pedc_radm_trgt1_tlp_abort & pedc__radm_trgt1_eot. */
        uint64_t rtlplle               : 1;  /**< [  2:  2](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RTLPLLE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_dllp_abort &
                                                                 pedc__radm_trgt1_eot. */
        uint64_t recrce                : 1;  /**< [  3:  3](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RECRCE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_ecrc_err & pedc__radm_trgt1_eot. */
        uint64_t rpoison               : 1;  /**< [  4:  4](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RPOISON].
                                                                 Internal:
                                                                 pedc__radm_trgt1_poisoned & pedc__radm_trgt1_hv. */
        uint64_t rcemrc                : 1;  /**< [  5:  5](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RCEMRC].
                                                                 Internal:
                                                                 pedc_radm_correctable_err. */
        uint64_t rnfemrc               : 1;  /**< [  6:  6](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RNFEMRC].
                                                                 Internal:
                                                                 pedc_radm_nonfatal_err. */
        uint64_t rfemrc                : 1;  /**< [  7:  7](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RFEMRC].
                                                                 Internal:
                                                                 pedc_radm_fatal_err. */
        uint64_t rpmerc                : 1;  /**< [  8:  8](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RPMERC].
                                                                 Internal:
                                                                 pedc_radm_pm_pme. */
        uint64_t rptamrc               : 1;  /**< [  9:  9](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RPTAMRC].
                                                                 Internal:
                                                                 pedc_radm_pm_to_ack. */
        uint64_t reserved_10           : 1;
        uint64_t rvdm                  : 1;  /**< [ 11: 11](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RVDM].
                                                                 Internal:
                                                                 pedc_radm_vendor_msg. */
        uint64_t acto                  : 1;  /**< [ 12: 12](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[ACTO].
                                                                 Internal:
                                                                 pedc_radm_cpl_timeout. */
        uint64_t rte                   : 1;  /**< [ 13: 13](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RTE].
                                                                 Internal:
                                                                 xdlh_replay_timeout_err. */
        uint64_t mre                   : 1;  /**< [ 14: 14](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[MRE].
                                                                 Internal:
                                                                 xdlh_replay_num_rlover_err. */
        uint64_t rdwdle                : 1;  /**< [ 15: 15](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RDWDLE].
                                                                 Internal:
                                                                 rdlh_bad_dllp_err. */
        uint64_t rtwdle                : 1;  /**< [ 16: 16](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RTWDLE].
                                                                 Internal:
                                                                 rdlh_bad_tlp_err. */
        uint64_t dpeoosd               : 1;  /**< [ 17: 17](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[DPEOOSD].
                                                                 Internal:
                                                                 rdlh_prot_err. */
        uint64_t fcpvwt                : 1;  /**< [ 18: 18](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[FCPVWT].
                                                                 Internal:
                                                                 rtlh_fc_prot_err. */
        uint64_t rpe                   : 1;  /**< [ 19: 19](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RPE].
                                                                 Internal:
                                                                 rmlh_rcvd_err. */
        uint64_t fcuv                  : 1;  /**< [ 20: 20](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[FCUV].
                                                                 Internal:
                                                                 (opt. checks) int_xadm_fc_prot_err. */
        uint64_t rqo                   : 1;  /**< [ 21: 21](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RQO].
                                                                 Internal:
                                                                 radm_qoverflow. */
        uint64_t rauc                  : 1;  /**< [ 22: 22](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RAUC].
                                                                 Internal:
                                                                 radm_unexp_cpl_err. */
        uint64_t racur                 : 1;  /**< [ 23: 23](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RACUR].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ur. */
        uint64_t racca                 : 1;  /**< [ 24: 24](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RACCA].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ca. */
        uint64_t caar                  : 1;  /**< [ 25: 25](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[CAAR]. */
        uint64_t rarwdns               : 1;  /**< [ 26: 26](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RARWDNS].
                                                                 Internal:
                                                                 radm_rcvd_ur_req. */
        uint64_t ramtlp                : 1;  /**< [ 27: 27](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RAMTLP].
                                                                 Internal:
                                                                 radm_mlf_tlp_err. */
        uint64_t racpp                 : 1;  /**< [ 28: 28](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RACPP].
                                                                 Internal:
                                                                 radm_rcvd_cpl_poisoned. */
        uint64_t rawwpp                : 1;  /**< [ 29: 29](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RAWWPP].
                                                                 Internal:
                                                                 radm_rcvd_wreq_poisoned. */
        uint64_t ecrc_e                : 1;  /**< [ 30: 30](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[ECRC_E]. */
        uint64_t lofp                  : 1;  /**< [ 31: 31](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[LOFP]. */
        uint64_t datq_pe               : 1;  /**< [ 32: 32](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[DATQ_PE]. */
        uint64_t p_d0_sbe              : 1;  /**< [ 33: 33](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[P_D0_SBE]. */
        uint64_t p_d0_dbe              : 1;  /**< [ 34: 34](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[P_D0_DBE]. */
        uint64_t p_d1_sbe              : 1;  /**< [ 35: 35](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[P_D1_SBE]. */
        uint64_t p_d1_dbe              : 1;  /**< [ 36: 36](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[P_D1_DBE]. */
        uint64_t p_c_sbe               : 1;  /**< [ 37: 37](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[P_C_SBE]. */
        uint64_t p_c_dbe               : 1;  /**< [ 38: 38](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[P_C_DBE]. */
        uint64_t n_d0_sbe              : 1;  /**< [ 39: 39](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[N_D0_SBE]. */
        uint64_t n_d0_dbe              : 1;  /**< [ 40: 40](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[N_D0_DBE]. */
        uint64_t n_d1_sbe              : 1;  /**< [ 41: 41](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[N_D1_SBE]. */
        uint64_t n_d1_dbe              : 1;  /**< [ 42: 42](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[N_D1_DBE]. */
        uint64_t n_c_sbe               : 1;  /**< [ 43: 43](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[N_C_SBE]. */
        uint64_t n_c_dbe               : 1;  /**< [ 44: 44](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[N_C_DBE]. */
        uint64_t c_d0_sbe              : 1;  /**< [ 45: 45](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[C_D0_SBE]. */
        uint64_t c_d0_dbe              : 1;  /**< [ 46: 46](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[C_D0_DBE]. */
        uint64_t c_d1_sbe              : 1;  /**< [ 47: 47](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[C_D1_SBE]. */
        uint64_t c_d1_dbe              : 1;  /**< [ 48: 48](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[C_D1_DBE]. */
        uint64_t c_c_sbe               : 1;  /**< [ 49: 49](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[C_C_SBE]. */
        uint64_t c_c_dbe               : 1;  /**< [ 50: 50](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[C_C_DBE]. */
        uint64_t rtry_sbe              : 1;  /**< [ 51: 51](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RTRY_SBE]. */
        uint64_t rtry_dbe              : 1;  /**< [ 52: 52](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[RTRY_DBE]. */
        uint64_t qhdr_b0_sbe           : 1;  /**< [ 53: 53](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[QHDR_B0_SBE]. */
        uint64_t qhdr_b0_dbe           : 1;  /**< [ 54: 54](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[QHDR_B0_DBE]. */
        uint64_t qhdr_b1_sbe           : 1;  /**< [ 55: 55](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[QHDR_B1_SBE]. */
        uint64_t qhdr_b1_dbe           : 1;  /**< [ 56: 56](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[QHDR_B1_DBE]. */
        uint64_t m2s_pe                : 1;  /**< [ 57: 57](R/W1S/H) Reads or sets enable for PEM(0..2)_DBG_INFO[M2S_PE]. */
        uint64_t reserved_58_63        : 6;
#endif /* Word 0 - End */
    } cn81xx;
    struct bdk_pemx_dbg_ena_w1s_cn83xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_56_63        : 8;
        uint64_t rasdp                 : 1;  /**< [ 55: 55](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RASDP]. */
        uint64_t m2s_d_dbe             : 1;  /**< [ 54: 54](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[M2S_D_DBE]. */
        uint64_t m2s_d_sbe             : 1;  /**< [ 53: 53](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[M2S_D_SBE]. */
        uint64_t m2s_c_dbe             : 1;  /**< [ 52: 52](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[M2S_C_DBE]. */
        uint64_t m2s_c_sbe             : 1;  /**< [ 51: 51](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[M2S_C_SBE]. */
        uint64_t c_c_dbe               : 1;  /**< [ 50: 50](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[C_C_DBE]. */
        uint64_t c_c_sbe               : 1;  /**< [ 49: 49](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[C_C_SBE]. */
        uint64_t c_d1_dbe              : 1;  /**< [ 48: 48](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[C_D1_DBE]. */
        uint64_t c_d1_sbe              : 1;  /**< [ 47: 47](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[C_D1_SBE]. */
        uint64_t c_d0_dbe              : 1;  /**< [ 46: 46](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[C_D0_DBE]. */
        uint64_t c_d0_sbe              : 1;  /**< [ 45: 45](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[C_D0_SBE]. */
        uint64_t n_c_dbe               : 1;  /**< [ 44: 44](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[N_C_DBE]. */
        uint64_t n_c_sbe               : 1;  /**< [ 43: 43](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[N_C_SBE]. */
        uint64_t n_d1_dbe              : 1;  /**< [ 42: 42](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[N_D1_DBE]. */
        uint64_t n_d1_sbe              : 1;  /**< [ 41: 41](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[N_D1_SBE]. */
        uint64_t n_d0_dbe              : 1;  /**< [ 40: 40](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[N_D0_DBE]. */
        uint64_t n_d0_sbe              : 1;  /**< [ 39: 39](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[N_D0_SBE]. */
        uint64_t p_c_dbe               : 1;  /**< [ 38: 38](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[P_C_DBE]. */
        uint64_t p_c_sbe               : 1;  /**< [ 37: 37](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[P_C_SBE]. */
        uint64_t p_d1_dbe              : 1;  /**< [ 36: 36](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[P_D1_DBE]. */
        uint64_t p_d1_sbe              : 1;  /**< [ 35: 35](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[P_D1_SBE]. */
        uint64_t p_d0_dbe              : 1;  /**< [ 34: 34](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[P_D0_DBE]. */
        uint64_t p_d0_sbe              : 1;  /**< [ 33: 33](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[P_D0_SBE]. */
        uint64_t bmd_e                 : 1;  /**< [ 32: 32](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[BMD_E]. */
        uint64_t lofp                  : 1;  /**< [ 31: 31](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[LOFP]. */
        uint64_t ecrc_e                : 1;  /**< [ 30: 30](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[ECRC_E]. */
        uint64_t rawwpp                : 1;  /**< [ 29: 29](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RAWWPP].
                                                                 Internal:
                                                                 radm_rcvd_wreq_poisoned. */
        uint64_t racpp                 : 1;  /**< [ 28: 28](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RACPP].
                                                                 Internal:
                                                                 radm_rcvd_cpl_poisoned. */
        uint64_t ramtlp                : 1;  /**< [ 27: 27](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RAMTLP].
                                                                 Internal:
                                                                 radm_mlf_tlp_err. */
        uint64_t rarwdns               : 1;  /**< [ 26: 26](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RARWDNS].
                                                                 Internal:
                                                                 radm_rcvd_ur_req. */
        uint64_t caar                  : 1;  /**< [ 25: 25](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[CAAR]. */
        uint64_t racca                 : 1;  /**< [ 24: 24](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RACCA].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ca. */
        uint64_t racur                 : 1;  /**< [ 23: 23](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RACUR].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ur. */
        uint64_t rauc                  : 1;  /**< [ 22: 22](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RAUC].
                                                                 Internal:
                                                                 radm_unexp_cpl_err. */
        uint64_t rqo                   : 1;  /**< [ 21: 21](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RQO].
                                                                 Internal:
                                                                 radm_qoverflow. */
        uint64_t fcuv                  : 1;  /**< [ 20: 20](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[FCUV].
                                                                 Internal:
                                                                 (opt. checks) int_xadm_fc_prot_err. */
        uint64_t rpe                   : 1;  /**< [ 19: 19](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RPE].
                                                                 Internal:
                                                                 rmlh_rcvd_err. */
        uint64_t fcpvwt                : 1;  /**< [ 18: 18](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[FCPVWT].
                                                                 Internal:
                                                                 rtlh_fc_prot_err. */
        uint64_t dpeoosd               : 1;  /**< [ 17: 17](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[DPEOOSD].
                                                                 Internal:
                                                                 rdlh_prot_err. */
        uint64_t rtwdle                : 1;  /**< [ 16: 16](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RTWDLE].
                                                                 Internal:
                                                                 rdlh_bad_tlp_err. */
        uint64_t rdwdle                : 1;  /**< [ 15: 15](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RDWDLE].
                                                                 Internal:
                                                                 rdlh_bad_dllp_err. */
        uint64_t mre                   : 1;  /**< [ 14: 14](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[MRE].
                                                                 Internal:
                                                                 xdlh_replay_num_rlover_err. */
        uint64_t rte                   : 1;  /**< [ 13: 13](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RTE].
                                                                 Internal:
                                                                 xdlh_replay_timeout_err. */
        uint64_t acto                  : 1;  /**< [ 12: 12](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[ACTO].
                                                                 Internal:
                                                                 pedc_radm_cpl_timeout. */
        uint64_t rvdm                  : 1;  /**< [ 11: 11](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RVDM].
                                                                 Internal:
                                                                 pedc_radm_vendor_msg. */
        uint64_t rumep                 : 1;  /**< [ 10: 10](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RUMEP].
                                                                 Internal:
                                                                 pedc_radm_msg_unlock. */
        uint64_t rptamrc               : 1;  /**< [  9:  9](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RPTAMRC].
                                                                 Internal:
                                                                 pedc_radm_pm_to_ack. */
        uint64_t rpmerc                : 1;  /**< [  8:  8](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RPMERC].
                                                                 Internal:
                                                                 pedc_radm_pm_pme. */
        uint64_t rfemrc                : 1;  /**< [  7:  7](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RFEMRC].
                                                                 Internal:
                                                                 pedc_radm_fatal_err. */
        uint64_t rnfemrc               : 1;  /**< [  6:  6](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RNFEMRC].
                                                                 Internal:
                                                                 pedc_radm_nonfatal_err. */
        uint64_t rcemrc                : 1;  /**< [  5:  5](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RCEMRC].
                                                                 Internal:
                                                                 pedc_radm_correctable_err. */
        uint64_t rpoison               : 1;  /**< [  4:  4](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RPOISON].
                                                                 Internal:
                                                                 pedc__radm_trgt1_poisoned & pedc__radm_trgt1_hv. */
        uint64_t recrce                : 1;  /**< [  3:  3](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RECRCE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_ecrc_err & pedc__radm_trgt1_eot. */
        uint64_t rtlplle               : 1;  /**< [  2:  2](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RTLPLLE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_dllp_abort &
                                                                 pedc__radm_trgt1_eot. */
        uint64_t rtlpmal               : 1;  /**< [  1:  1](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RTLPMAL].
                                                                 Internal:
                                                                 pedc_radm_trgt1_tlp_abort & pedc__radm_trgt1_eot. */
        uint64_t spoison               : 1;  /**< [  0:  0](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[SPOISON]. */
#else /* Word 0 - Little Endian */
        uint64_t spoison               : 1;  /**< [  0:  0](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[SPOISON]. */
        uint64_t rtlpmal               : 1;  /**< [  1:  1](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RTLPMAL].
                                                                 Internal:
                                                                 pedc_radm_trgt1_tlp_abort & pedc__radm_trgt1_eot. */
        uint64_t rtlplle               : 1;  /**< [  2:  2](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RTLPLLE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_dllp_abort &
                                                                 pedc__radm_trgt1_eot. */
        uint64_t recrce                : 1;  /**< [  3:  3](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RECRCE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_ecrc_err & pedc__radm_trgt1_eot. */
        uint64_t rpoison               : 1;  /**< [  4:  4](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RPOISON].
                                                                 Internal:
                                                                 pedc__radm_trgt1_poisoned & pedc__radm_trgt1_hv. */
        uint64_t rcemrc                : 1;  /**< [  5:  5](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RCEMRC].
                                                                 Internal:
                                                                 pedc_radm_correctable_err. */
        uint64_t rnfemrc               : 1;  /**< [  6:  6](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RNFEMRC].
                                                                 Internal:
                                                                 pedc_radm_nonfatal_err. */
        uint64_t rfemrc                : 1;  /**< [  7:  7](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RFEMRC].
                                                                 Internal:
                                                                 pedc_radm_fatal_err. */
        uint64_t rpmerc                : 1;  /**< [  8:  8](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RPMERC].
                                                                 Internal:
                                                                 pedc_radm_pm_pme. */
        uint64_t rptamrc               : 1;  /**< [  9:  9](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RPTAMRC].
                                                                 Internal:
                                                                 pedc_radm_pm_to_ack. */
        uint64_t rumep                 : 1;  /**< [ 10: 10](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RUMEP].
                                                                 Internal:
                                                                 pedc_radm_msg_unlock. */
        uint64_t rvdm                  : 1;  /**< [ 11: 11](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RVDM].
                                                                 Internal:
                                                                 pedc_radm_vendor_msg. */
        uint64_t acto                  : 1;  /**< [ 12: 12](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[ACTO].
                                                                 Internal:
                                                                 pedc_radm_cpl_timeout. */
        uint64_t rte                   : 1;  /**< [ 13: 13](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RTE].
                                                                 Internal:
                                                                 xdlh_replay_timeout_err. */
        uint64_t mre                   : 1;  /**< [ 14: 14](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[MRE].
                                                                 Internal:
                                                                 xdlh_replay_num_rlover_err. */
        uint64_t rdwdle                : 1;  /**< [ 15: 15](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RDWDLE].
                                                                 Internal:
                                                                 rdlh_bad_dllp_err. */
        uint64_t rtwdle                : 1;  /**< [ 16: 16](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RTWDLE].
                                                                 Internal:
                                                                 rdlh_bad_tlp_err. */
        uint64_t dpeoosd               : 1;  /**< [ 17: 17](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[DPEOOSD].
                                                                 Internal:
                                                                 rdlh_prot_err. */
        uint64_t fcpvwt                : 1;  /**< [ 18: 18](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[FCPVWT].
                                                                 Internal:
                                                                 rtlh_fc_prot_err. */
        uint64_t rpe                   : 1;  /**< [ 19: 19](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RPE].
                                                                 Internal:
                                                                 rmlh_rcvd_err. */
        uint64_t fcuv                  : 1;  /**< [ 20: 20](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[FCUV].
                                                                 Internal:
                                                                 (opt. checks) int_xadm_fc_prot_err. */
        uint64_t rqo                   : 1;  /**< [ 21: 21](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RQO].
                                                                 Internal:
                                                                 radm_qoverflow. */
        uint64_t rauc                  : 1;  /**< [ 22: 22](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RAUC].
                                                                 Internal:
                                                                 radm_unexp_cpl_err. */
        uint64_t racur                 : 1;  /**< [ 23: 23](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RACUR].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ur. */
        uint64_t racca                 : 1;  /**< [ 24: 24](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RACCA].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ca. */
        uint64_t caar                  : 1;  /**< [ 25: 25](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[CAAR]. */
        uint64_t rarwdns               : 1;  /**< [ 26: 26](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RARWDNS].
                                                                 Internal:
                                                                 radm_rcvd_ur_req. */
        uint64_t ramtlp                : 1;  /**< [ 27: 27](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RAMTLP].
                                                                 Internal:
                                                                 radm_mlf_tlp_err. */
        uint64_t racpp                 : 1;  /**< [ 28: 28](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RACPP].
                                                                 Internal:
                                                                 radm_rcvd_cpl_poisoned. */
        uint64_t rawwpp                : 1;  /**< [ 29: 29](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RAWWPP].
                                                                 Internal:
                                                                 radm_rcvd_wreq_poisoned. */
        uint64_t ecrc_e                : 1;  /**< [ 30: 30](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[ECRC_E]. */
        uint64_t lofp                  : 1;  /**< [ 31: 31](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[LOFP]. */
        uint64_t bmd_e                 : 1;  /**< [ 32: 32](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[BMD_E]. */
        uint64_t p_d0_sbe              : 1;  /**< [ 33: 33](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[P_D0_SBE]. */
        uint64_t p_d0_dbe              : 1;  /**< [ 34: 34](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[P_D0_DBE]. */
        uint64_t p_d1_sbe              : 1;  /**< [ 35: 35](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[P_D1_SBE]. */
        uint64_t p_d1_dbe              : 1;  /**< [ 36: 36](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[P_D1_DBE]. */
        uint64_t p_c_sbe               : 1;  /**< [ 37: 37](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[P_C_SBE]. */
        uint64_t p_c_dbe               : 1;  /**< [ 38: 38](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[P_C_DBE]. */
        uint64_t n_d0_sbe              : 1;  /**< [ 39: 39](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[N_D0_SBE]. */
        uint64_t n_d0_dbe              : 1;  /**< [ 40: 40](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[N_D0_DBE]. */
        uint64_t n_d1_sbe              : 1;  /**< [ 41: 41](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[N_D1_SBE]. */
        uint64_t n_d1_dbe              : 1;  /**< [ 42: 42](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[N_D1_DBE]. */
        uint64_t n_c_sbe               : 1;  /**< [ 43: 43](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[N_C_SBE]. */
        uint64_t n_c_dbe               : 1;  /**< [ 44: 44](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[N_C_DBE]. */
        uint64_t c_d0_sbe              : 1;  /**< [ 45: 45](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[C_D0_SBE]. */
        uint64_t c_d0_dbe              : 1;  /**< [ 46: 46](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[C_D0_DBE]. */
        uint64_t c_d1_sbe              : 1;  /**< [ 47: 47](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[C_D1_SBE]. */
        uint64_t c_d1_dbe              : 1;  /**< [ 48: 48](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[C_D1_DBE]. */
        uint64_t c_c_sbe               : 1;  /**< [ 49: 49](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[C_C_SBE]. */
        uint64_t c_c_dbe               : 1;  /**< [ 50: 50](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[C_C_DBE]. */
        uint64_t m2s_c_sbe             : 1;  /**< [ 51: 51](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[M2S_C_SBE]. */
        uint64_t m2s_c_dbe             : 1;  /**< [ 52: 52](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[M2S_C_DBE]. */
        uint64_t m2s_d_sbe             : 1;  /**< [ 53: 53](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[M2S_D_SBE]. */
        uint64_t m2s_d_dbe             : 1;  /**< [ 54: 54](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[M2S_D_DBE]. */
        uint64_t rasdp                 : 1;  /**< [ 55: 55](R/W1S/H) Reads or sets enable for PEM(0..3)_DBG_INFO[RASDP]. */
        uint64_t reserved_56_63        : 8;
#endif /* Word 0 - End */
    } cn83xx;
    struct bdk_pemx_dbg_ena_w1s_cn88xxp2
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_58_63        : 6;
        uint64_t m2s_pe                : 1;  /**< [ 57: 57](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[M2S_PE]. */
        uint64_t qhdr_b1_dbe           : 1;  /**< [ 56: 56](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[QHDR_B1_DBE]. */
        uint64_t qhdr_b1_sbe           : 1;  /**< [ 55: 55](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[QHDR_B1_SBE]. */
        uint64_t qhdr_b0_dbe           : 1;  /**< [ 54: 54](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[QHDR_B0_DBE]. */
        uint64_t qhdr_b0_sbe           : 1;  /**< [ 53: 53](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[QHDR_B0_SBE]. */
        uint64_t rtry_dbe              : 1;  /**< [ 52: 52](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RTRY_DBE]. */
        uint64_t rtry_sbe              : 1;  /**< [ 51: 51](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RTRY_SBE]. */
        uint64_t c_c_dbe               : 1;  /**< [ 50: 50](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[C_C_DBE]. */
        uint64_t c_c_sbe               : 1;  /**< [ 49: 49](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[C_C_SBE]. */
        uint64_t c_d1_dbe              : 1;  /**< [ 48: 48](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[C_D1_DBE]. */
        uint64_t c_d1_sbe              : 1;  /**< [ 47: 47](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[C_D1_SBE]. */
        uint64_t c_d0_dbe              : 1;  /**< [ 46: 46](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[C_D0_DBE]. */
        uint64_t c_d0_sbe              : 1;  /**< [ 45: 45](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[C_D0_SBE]. */
        uint64_t n_c_dbe               : 1;  /**< [ 44: 44](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[N_C_DBE]. */
        uint64_t n_c_sbe               : 1;  /**< [ 43: 43](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[N_C_SBE]. */
        uint64_t n_d1_dbe              : 1;  /**< [ 42: 42](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[N_D1_DBE]. */
        uint64_t n_d1_sbe              : 1;  /**< [ 41: 41](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[N_D1_SBE]. */
        uint64_t n_d0_dbe              : 1;  /**< [ 40: 40](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[N_D0_DBE]. */
        uint64_t n_d0_sbe              : 1;  /**< [ 39: 39](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[N_D0_SBE]. */
        uint64_t p_c_dbe               : 1;  /**< [ 38: 38](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[P_C_DBE]. */
        uint64_t p_c_sbe               : 1;  /**< [ 37: 37](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[P_C_SBE]. */
        uint64_t p_d1_dbe              : 1;  /**< [ 36: 36](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[P_D1_DBE]. */
        uint64_t p_d1_sbe              : 1;  /**< [ 35: 35](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[P_D1_SBE]. */
        uint64_t p_d0_dbe              : 1;  /**< [ 34: 34](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[P_D0_DBE]. */
        uint64_t p_d0_sbe              : 1;  /**< [ 33: 33](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[P_D0_SBE]. */
        uint64_t datq_pe               : 1;  /**< [ 32: 32](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[DATQ_PE]. */
        uint64_t lofp                  : 1;  /**< [ 31: 31](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[LOFP]. */
        uint64_t ecrc_e                : 1;  /**< [ 30: 30](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[ECRC_E]. */
        uint64_t rawwpp                : 1;  /**< [ 29: 29](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RAWWPP].
                                                                 Internal:
                                                                 radm_rcvd_wreq_poisoned. */
        uint64_t racpp                 : 1;  /**< [ 28: 28](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RACPP].
                                                                 Internal:
                                                                 radm_rcvd_cpl_poisoned. */
        uint64_t ramtlp                : 1;  /**< [ 27: 27](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RAMTLP].
                                                                 Internal:
                                                                 radm_mlf_tlp_err. */
        uint64_t rarwdns               : 1;  /**< [ 26: 26](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RARWDNS].
                                                                 Internal:
                                                                 radm_rcvd_ur_req. */
        uint64_t caar                  : 1;  /**< [ 25: 25](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[CAAR]. */
        uint64_t racca                 : 1;  /**< [ 24: 24](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RACCA].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ca. */
        uint64_t racur                 : 1;  /**< [ 23: 23](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RACUR].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ur. */
        uint64_t rauc                  : 1;  /**< [ 22: 22](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RAUC].
                                                                 Internal:
                                                                 radm_unexp_cpl_err. */
        uint64_t rqo                   : 1;  /**< [ 21: 21](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RQO].
                                                                 Internal:
                                                                 radm_qoverflow. */
        uint64_t fcuv                  : 1;  /**< [ 20: 20](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[FCUV].
                                                                 Internal:
                                                                 (opt. checks) int_xadm_fc_prot_err. */
        uint64_t rpe                   : 1;  /**< [ 19: 19](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RPE].
                                                                 Internal:
                                                                 rmlh_rcvd_err. */
        uint64_t fcpvwt                : 1;  /**< [ 18: 18](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[FCPVWT].
                                                                 Internal:
                                                                 rtlh_fc_prot_err. */
        uint64_t dpeoosd               : 1;  /**< [ 17: 17](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[DPEOOSD].
                                                                 Internal:
                                                                 rdlh_prot_err. */
        uint64_t rtwdle                : 1;  /**< [ 16: 16](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RTWDLE].
                                                                 Internal:
                                                                 rdlh_bad_tlp_err. */
        uint64_t rdwdle                : 1;  /**< [ 15: 15](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RDWDLE].
                                                                 Internal:
                                                                 rdlh_bad_dllp_err. */
        uint64_t mre                   : 1;  /**< [ 14: 14](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[MRE].
                                                                 Internal:
                                                                 xdlh_replay_num_rlover_err. */
        uint64_t rte                   : 1;  /**< [ 13: 13](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RTE].
                                                                 Internal:
                                                                 xdlh_replay_timeout_err. */
        uint64_t acto                  : 1;  /**< [ 12: 12](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[ACTO].
                                                                 Internal:
                                                                 pedc_radm_cpl_timeout. */
        uint64_t rvdm                  : 1;  /**< [ 11: 11](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RVDM].
                                                                 Internal:
                                                                 pedc_radm_vendor_msg. */
        uint64_t reserved_10           : 1;
        uint64_t rptamrc               : 1;  /**< [  9:  9](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RPTAMRC].
                                                                 Internal:
                                                                 pedc_radm_pm_to_ack. */
        uint64_t rpmerc                : 1;  /**< [  8:  8](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RPMERC].
                                                                 Internal:
                                                                 pedc_radm_pm_pme. */
        uint64_t rfemrc                : 1;  /**< [  7:  7](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RFEMRC].
                                                                 Internal:
                                                                 pedc_radm_fatal_err. */
        uint64_t rnfemrc               : 1;  /**< [  6:  6](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RNFEMRC].
                                                                 Internal:
                                                                 pedc_radm_nonfatal_err. */
        uint64_t rcemrc                : 1;  /**< [  5:  5](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RCEMRC].
                                                                 Internal:
                                                                 pedc_radm_correctable_err. */
        uint64_t rpoison               : 1;  /**< [  4:  4](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RPOISON].
                                                                 Internal:
                                                                 pedc__radm_trgt1_poisoned & pedc__radm_trgt1_hv. */
        uint64_t recrce                : 1;  /**< [  3:  3](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RECRCE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_ecrc_err & pedc__radm_trgt1_eot. */
        uint64_t rtlplle               : 1;  /**< [  2:  2](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RTLPLLE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_dllp_abort &
                                                                 pedc__radm_trgt1_eot. */
        uint64_t rtlpmal               : 1;  /**< [  1:  1](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RTLPMAL].
                                                                 Internal:
                                                                 pedc_radm_trgt1_tlp_abort & pedc__radm_trgt1_eot. */
        uint64_t spoison               : 1;  /**< [  0:  0](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[SPOISON].
                                                                 Internal:
                                                                 peai__client0_tlp_ep & peai__client0_tlp_hv or
                                                                 peai__client1_tlp_ep & peai__client1_tlp_hv (atomic_op). */
#else /* Word 0 - Little Endian */
        uint64_t spoison               : 1;  /**< [  0:  0](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[SPOISON].
                                                                 Internal:
                                                                 peai__client0_tlp_ep & peai__client0_tlp_hv or
                                                                 peai__client1_tlp_ep & peai__client1_tlp_hv (atomic_op). */
        uint64_t rtlpmal               : 1;  /**< [  1:  1](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RTLPMAL].
                                                                 Internal:
                                                                 pedc_radm_trgt1_tlp_abort & pedc__radm_trgt1_eot. */
        uint64_t rtlplle               : 1;  /**< [  2:  2](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RTLPLLE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_dllp_abort &
                                                                 pedc__radm_trgt1_eot. */
        uint64_t recrce                : 1;  /**< [  3:  3](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RECRCE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_ecrc_err & pedc__radm_trgt1_eot. */
        uint64_t rpoison               : 1;  /**< [  4:  4](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RPOISON].
                                                                 Internal:
                                                                 pedc__radm_trgt1_poisoned & pedc__radm_trgt1_hv. */
        uint64_t rcemrc                : 1;  /**< [  5:  5](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RCEMRC].
                                                                 Internal:
                                                                 pedc_radm_correctable_err. */
        uint64_t rnfemrc               : 1;  /**< [  6:  6](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RNFEMRC].
                                                                 Internal:
                                                                 pedc_radm_nonfatal_err. */
        uint64_t rfemrc                : 1;  /**< [  7:  7](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RFEMRC].
                                                                 Internal:
                                                                 pedc_radm_fatal_err. */
        uint64_t rpmerc                : 1;  /**< [  8:  8](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RPMERC].
                                                                 Internal:
                                                                 pedc_radm_pm_pme. */
        uint64_t rptamrc               : 1;  /**< [  9:  9](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RPTAMRC].
                                                                 Internal:
                                                                 pedc_radm_pm_to_ack. */
        uint64_t reserved_10           : 1;
        uint64_t rvdm                  : 1;  /**< [ 11: 11](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RVDM].
                                                                 Internal:
                                                                 pedc_radm_vendor_msg. */
        uint64_t acto                  : 1;  /**< [ 12: 12](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[ACTO].
                                                                 Internal:
                                                                 pedc_radm_cpl_timeout. */
        uint64_t rte                   : 1;  /**< [ 13: 13](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RTE].
                                                                 Internal:
                                                                 xdlh_replay_timeout_err. */
        uint64_t mre                   : 1;  /**< [ 14: 14](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[MRE].
                                                                 Internal:
                                                                 xdlh_replay_num_rlover_err. */
        uint64_t rdwdle                : 1;  /**< [ 15: 15](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RDWDLE].
                                                                 Internal:
                                                                 rdlh_bad_dllp_err. */
        uint64_t rtwdle                : 1;  /**< [ 16: 16](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RTWDLE].
                                                                 Internal:
                                                                 rdlh_bad_tlp_err. */
        uint64_t dpeoosd               : 1;  /**< [ 17: 17](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[DPEOOSD].
                                                                 Internal:
                                                                 rdlh_prot_err. */
        uint64_t fcpvwt                : 1;  /**< [ 18: 18](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[FCPVWT].
                                                                 Internal:
                                                                 rtlh_fc_prot_err. */
        uint64_t rpe                   : 1;  /**< [ 19: 19](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RPE].
                                                                 Internal:
                                                                 rmlh_rcvd_err. */
        uint64_t fcuv                  : 1;  /**< [ 20: 20](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[FCUV].
                                                                 Internal:
                                                                 (opt. checks) int_xadm_fc_prot_err. */
        uint64_t rqo                   : 1;  /**< [ 21: 21](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RQO].
                                                                 Internal:
                                                                 radm_qoverflow. */
        uint64_t rauc                  : 1;  /**< [ 22: 22](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RAUC].
                                                                 Internal:
                                                                 radm_unexp_cpl_err. */
        uint64_t racur                 : 1;  /**< [ 23: 23](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RACUR].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ur. */
        uint64_t racca                 : 1;  /**< [ 24: 24](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RACCA].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ca. */
        uint64_t caar                  : 1;  /**< [ 25: 25](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[CAAR]. */
        uint64_t rarwdns               : 1;  /**< [ 26: 26](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RARWDNS].
                                                                 Internal:
                                                                 radm_rcvd_ur_req. */
        uint64_t ramtlp                : 1;  /**< [ 27: 27](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RAMTLP].
                                                                 Internal:
                                                                 radm_mlf_tlp_err. */
        uint64_t racpp                 : 1;  /**< [ 28: 28](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RACPP].
                                                                 Internal:
                                                                 radm_rcvd_cpl_poisoned. */
        uint64_t rawwpp                : 1;  /**< [ 29: 29](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RAWWPP].
                                                                 Internal:
                                                                 radm_rcvd_wreq_poisoned. */
        uint64_t ecrc_e                : 1;  /**< [ 30: 30](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[ECRC_E]. */
        uint64_t lofp                  : 1;  /**< [ 31: 31](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[LOFP]. */
        uint64_t datq_pe               : 1;  /**< [ 32: 32](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[DATQ_PE]. */
        uint64_t p_d0_sbe              : 1;  /**< [ 33: 33](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[P_D0_SBE]. */
        uint64_t p_d0_dbe              : 1;  /**< [ 34: 34](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[P_D0_DBE]. */
        uint64_t p_d1_sbe              : 1;  /**< [ 35: 35](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[P_D1_SBE]. */
        uint64_t p_d1_dbe              : 1;  /**< [ 36: 36](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[P_D1_DBE]. */
        uint64_t p_c_sbe               : 1;  /**< [ 37: 37](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[P_C_SBE]. */
        uint64_t p_c_dbe               : 1;  /**< [ 38: 38](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[P_C_DBE]. */
        uint64_t n_d0_sbe              : 1;  /**< [ 39: 39](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[N_D0_SBE]. */
        uint64_t n_d0_dbe              : 1;  /**< [ 40: 40](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[N_D0_DBE]. */
        uint64_t n_d1_sbe              : 1;  /**< [ 41: 41](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[N_D1_SBE]. */
        uint64_t n_d1_dbe              : 1;  /**< [ 42: 42](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[N_D1_DBE]. */
        uint64_t n_c_sbe               : 1;  /**< [ 43: 43](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[N_C_SBE]. */
        uint64_t n_c_dbe               : 1;  /**< [ 44: 44](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[N_C_DBE]. */
        uint64_t c_d0_sbe              : 1;  /**< [ 45: 45](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[C_D0_SBE]. */
        uint64_t c_d0_dbe              : 1;  /**< [ 46: 46](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[C_D0_DBE]. */
        uint64_t c_d1_sbe              : 1;  /**< [ 47: 47](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[C_D1_SBE]. */
        uint64_t c_d1_dbe              : 1;  /**< [ 48: 48](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[C_D1_DBE]. */
        uint64_t c_c_sbe               : 1;  /**< [ 49: 49](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[C_C_SBE]. */
        uint64_t c_c_dbe               : 1;  /**< [ 50: 50](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[C_C_DBE]. */
        uint64_t rtry_sbe              : 1;  /**< [ 51: 51](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RTRY_SBE]. */
        uint64_t rtry_dbe              : 1;  /**< [ 52: 52](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[RTRY_DBE]. */
        uint64_t qhdr_b0_sbe           : 1;  /**< [ 53: 53](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[QHDR_B0_SBE]. */
        uint64_t qhdr_b0_dbe           : 1;  /**< [ 54: 54](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[QHDR_B0_DBE]. */
        uint64_t qhdr_b1_sbe           : 1;  /**< [ 55: 55](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[QHDR_B1_SBE]. */
        uint64_t qhdr_b1_dbe           : 1;  /**< [ 56: 56](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[QHDR_B1_DBE]. */
        uint64_t m2s_pe                : 1;  /**< [ 57: 57](R/W1S/H) Reads or sets enable for PEM(0..5)_DBG_INFO[M2S_PE]. */
        uint64_t reserved_58_63        : 6;
#endif /* Word 0 - End */
    } cn88xxp2;
};
typedef union bdk_pemx_dbg_ena_w1s bdk_pemx_dbg_ena_w1s_t;

static inline uint64_t BDK_PEMX_DBG_ENA_W1S(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_DBG_ENA_W1S(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN81XX) && (a<=2))
        return 0x87e0c0000460ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN83XX) && (a<=3))
        return 0x87e0c0000460ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN88XX) && (a<=5))
        return 0x87e0c0000460ll + 0x1000000ll * ((a) & 0x7);
    __bdk_csr_fatal("PEMX_DBG_ENA_W1S", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_DBG_ENA_W1S(a) bdk_pemx_dbg_ena_w1s_t
#define bustype_BDK_PEMX_DBG_ENA_W1S(a) BDK_CSR_TYPE_RSL
#define basename_BDK_PEMX_DBG_ENA_W1S(a) "PEMX_DBG_ENA_W1S"
#define device_bar_BDK_PEMX_DBG_ENA_W1S(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_DBG_ENA_W1S(a) (a)
#define arguments_BDK_PEMX_DBG_ENA_W1S(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_dbg_info
 *
 * PEM Debug Information Register
 * This is a debug information register of the PEM.
 *
 * This register is accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on PEM domain reset.
 */
union bdk_pemx_dbg_info
{
    uint64_t u;
    struct bdk_pemx_dbg_info_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_58_63        : 6;
        uint64_t m2s_pe                : 1;  /**< [ 57: 57](R/W1C/H) Detected a M2S FIFO parity error. */
        uint64_t qhdr_b1_dbe           : 1;  /**< [ 56: 56](R/W1C/H) Detected a core header queue bank1 double-bit error. */
        uint64_t reserved_32_55        : 24;
        uint64_t lofp                  : 1;  /**< [ 31: 31](R/W1C/H) Lack of forward progress at TLP FIFOs timeout occurred. */
        uint64_t ecrc_e                : 1;  /**< [ 30: 30](R/W1C/H) Received an ECRC error. */
        uint64_t rawwpp                : 1;  /**< [ 29: 29](R/W1C/H) Received a write with poisoned payload.
                                                                 Internal:
                                                                 radm_rcvd_wreq_poisoned. */
        uint64_t racpp                 : 1;  /**< [ 28: 28](R/W1C/H) Received a completion with poisoned payload.
                                                                 Internal:
                                                                 radm_rcvd_cpl_poisoned. */
        uint64_t ramtlp                : 1;  /**< [ 27: 27](R/W1C/H) Received a malformed TLP.
                                                                 Internal:
                                                                 radm_mlf_tlp_err. */
        uint64_t rarwdns               : 1;  /**< [ 26: 26](R/W1C/H) Received a request which device does not support.
                                                                 Internal:
                                                                 radm_rcvd_ur_req. */
        uint64_t caar                  : 1;  /**< [ 25: 25](R/W1C/H) Completer aborted a request. This bit is never set because CNXXXX does not generate
                                                                 completer aborts. */
        uint64_t racca                 : 1;  /**< [ 24: 24](R/W1C/H) Received a completion with CA status.
                                                                 Internal:
                                                                 radm_rcvd_cpl_ca. */
        uint64_t racur                 : 1;  /**< [ 23: 23](R/W1C/H) Received a completion with UR status.
                                                                 Internal:
                                                                 radm_rcvd_cpl_ur. */
        uint64_t rauc                  : 1;  /**< [ 22: 22](R/W1C/H) Received an unexpected completion.
                                                                 Internal:
                                                                 radm_unexp_cpl_err. */
        uint64_t rqo                   : 1;  /**< [ 21: 21](R/W1C/H) Receive queue overflow. Normally happens only when flow control advertisements are
                                                                 ignored.

                                                                 Internal:
                                                                 radm_qoverflow. */
        uint64_t fcuv                  : 1;  /**< [ 20: 20](R/W1C/H) Flow control update violation.
                                                                 Internal:
                                                                 (opt. checks) int_xadm_fc_prot_err. */
        uint64_t rpe                   : 1;  /**< [ 19: 19](R/W1C/H) PHY reported an 8 B/10 B decode error (RxStatus = 0x4) or disparity error (RxStatus =
                                                                 0x7).

                                                                 Internal:
                                                                 rmlh_rcvd_err. */
        uint64_t fcpvwt                : 1;  /**< [ 18: 18](R/W1C/H) Flow control protocol violation (watchdog timer).
                                                                 Internal:
                                                                 rtlh_fc_prot_err. */
        uint64_t dpeoosd               : 1;  /**< [ 17: 17](R/W1C/H) DLLP protocol error (out of sequence DLLP).
                                                                 Internal:
                                                                 rdlh_prot_err. */
        uint64_t rtwdle                : 1;  /**< [ 16: 16](R/W1C/H) Received TLP with datalink layer error.
                                                                 Internal:
                                                                 rdlh_bad_tlp_err. */
        uint64_t rdwdle                : 1;  /**< [ 15: 15](R/W1C/H) Received DLLP with datalink layer error.
                                                                 Internal:
                                                                 rdlh_bad_dllp_err. */
        uint64_t mre                   : 1;  /**< [ 14: 14](R/W1C/H) Maximum number of retries exceeded.
                                                                 Internal:
                                                                 xdlh_replay_num_rlover_err. */
        uint64_t rte                   : 1;  /**< [ 13: 13](R/W1C/H) Replay timer expired. This bit is set when the REPLAY_TIMER expires in the PCIe core. The
                                                                 probability of this bit being set increases with the traffic load.

                                                                 Internal:
                                                                 xdlh_replay_timeout_err. */
        uint64_t acto                  : 1;  /**< [ 12: 12](R/W1C/H) A completion timeout occurred.
                                                                 Internal:
                                                                 pedc_radm_cpl_timeout. */
        uint64_t rvdm                  : 1;  /**< [ 11: 11](R/W1C/H) Received vendor-defined message.
                                                                 Internal:
                                                                 pedc_radm_vendor_msg. */
        uint64_t rumep                 : 1;  /**< [ 10: 10](R/W1C/H) Received unlock message (EP mode only).
                                                                 Internal:
                                                                 pedc_radm_msg_unlock. */
        uint64_t rptamrc               : 1;  /**< [  9:  9](R/W1C/H) Received PME turnoff acknowledge message (RC mode only).
                                                                 Internal:
                                                                 pedc_radm_pm_to_ack. */
        uint64_t rpmerc                : 1;  /**< [  8:  8](R/W1C/H) Received PME message (RC mode only).
                                                                 Internal:
                                                                 pedc_radm_pm_pme. */
        uint64_t rfemrc                : 1;  /**< [  7:  7](R/W1C/H) Received fatal-error message (RC mode only). This bit is set when a message with ERR_FATAL
                                                                 is set.

                                                                 Internal:
                                                                 pedc_radm_fatal_err. */
        uint64_t rnfemrc               : 1;  /**< [  6:  6](R/W1C/H) Received nonfatal error message (RC mode only).
                                                                 Internal:
                                                                 pedc_radm_nonfatal_err. */
        uint64_t rcemrc                : 1;  /**< [  5:  5](R/W1C/H) Received correctable error message (RC mode only).
                                                                 Internal:
                                                                 pedc_radm_correctable_err. */
        uint64_t rpoison               : 1;  /**< [  4:  4](R/W1C/H) Received poisoned TLP.
                                                                 Internal:
                                                                 pedc__radm_trgt1_poisoned & pedc__radm_trgt1_hv. */
        uint64_t recrce                : 1;  /**< [  3:  3](R/W1C/H) Received ECRC error.
                                                                 Internal:
                                                                 pedc_radm_trgt1_ecrc_err & pedc__radm_trgt1_eot. */
        uint64_t rtlplle               : 1;  /**< [  2:  2](R/W1C/H) Received TLP has link layer error.
                                                                 Internal:
                                                                 pedc_radm_trgt1_dllp_abort &
                                                                 pedc__radm_trgt1_eot. */
        uint64_t rtlpmal               : 1;  /**< [  1:  1](R/W1C/H) Received TLP is malformed or a message. If the core receives a MSG (or Vendor Message) or
                                                                 if a received AtomicOp violates address/length rules, this bit is set as well.

                                                                 Internal:
                                                                 pedc_radm_trgt1_tlp_abort & pedc__radm_trgt1_eot. */
        uint64_t spoison               : 1;  /**< [  0:  0](R/W1C/H) Poisoned TLP sent.
                                                                 Internal:
                                                                 peai__client0_tlp_ep & peai__client0_tlp_hv or
                                                                 peai__client1_tlp_ep & peai__client1_tlp_hv (atomic_op). */
#else /* Word 0 - Little Endian */
        uint64_t spoison               : 1;  /**< [  0:  0](R/W1C/H) Poisoned TLP sent.
                                                                 Internal:
                                                                 peai__client0_tlp_ep & peai__client0_tlp_hv or
                                                                 peai__client1_tlp_ep & peai__client1_tlp_hv (atomic_op). */
        uint64_t rtlpmal               : 1;  /**< [  1:  1](R/W1C/H) Received TLP is malformed or a message. If the core receives a MSG (or Vendor Message) or
                                                                 if a received AtomicOp violates address/length rules, this bit is set as well.

                                                                 Internal:
                                                                 pedc_radm_trgt1_tlp_abort & pedc__radm_trgt1_eot. */
        uint64_t rtlplle               : 1;  /**< [  2:  2](R/W1C/H) Received TLP has link layer error.
                                                                 Internal:
                                                                 pedc_radm_trgt1_dllp_abort &
                                                                 pedc__radm_trgt1_eot. */
        uint64_t recrce                : 1;  /**< [  3:  3](R/W1C/H) Received ECRC error.
                                                                 Internal:
                                                                 pedc_radm_trgt1_ecrc_err & pedc__radm_trgt1_eot. */
        uint64_t rpoison               : 1;  /**< [  4:  4](R/W1C/H) Received poisoned TLP.
                                                                 Internal:
                                                                 pedc__radm_trgt1_poisoned & pedc__radm_trgt1_hv. */
        uint64_t rcemrc                : 1;  /**< [  5:  5](R/W1C/H) Received correctable error message (RC mode only).
                                                                 Internal:
                                                                 pedc_radm_correctable_err. */
        uint64_t rnfemrc               : 1;  /**< [  6:  6](R/W1C/H) Received nonfatal error message (RC mode only).
                                                                 Internal:
                                                                 pedc_radm_nonfatal_err. */
        uint64_t rfemrc                : 1;  /**< [  7:  7](R/W1C/H) Received fatal-error message (RC mode only). This bit is set when a message with ERR_FATAL
                                                                 is set.

                                                                 Internal:
                                                                 pedc_radm_fatal_err. */
        uint64_t rpmerc                : 1;  /**< [  8:  8](R/W1C/H) Received PME message (RC mode only).
                                                                 Internal:
                                                                 pedc_radm_pm_pme. */
        uint64_t rptamrc               : 1;  /**< [  9:  9](R/W1C/H) Received PME turnoff acknowledge message (RC mode only).
                                                                 Internal:
                                                                 pedc_radm_pm_to_ack. */
        uint64_t rumep                 : 1;  /**< [ 10: 10](R/W1C/H) Received unlock message (EP mode only).
                                                                 Internal:
                                                                 pedc_radm_msg_unlock. */
        uint64_t rvdm                  : 1;  /**< [ 11: 11](R/W1C/H) Received vendor-defined message.
                                                                 Internal:
                                                                 pedc_radm_vendor_msg. */
        uint64_t acto                  : 1;  /**< [ 12: 12](R/W1C/H) A completion timeout occurred.
                                                                 Internal:
                                                                 pedc_radm_cpl_timeout. */
        uint64_t rte                   : 1;  /**< [ 13: 13](R/W1C/H) Replay timer expired. This bit is set when the REPLAY_TIMER expires in the PCIe core. The
                                                                 probability of this bit being set increases with the traffic load.

                                                                 Internal:
                                                                 xdlh_replay_timeout_err. */
        uint64_t mre                   : 1;  /**< [ 14: 14](R/W1C/H) Maximum number of retries exceeded.
                                                                 Internal:
                                                                 xdlh_replay_num_rlover_err. */
        uint64_t rdwdle                : 1;  /**< [ 15: 15](R/W1C/H) Received DLLP with datalink layer error.
                                                                 Internal:
                                                                 rdlh_bad_dllp_err. */
        uint64_t rtwdle                : 1;  /**< [ 16: 16](R/W1C/H) Received TLP with datalink layer error.
                                                                 Internal:
                                                                 rdlh_bad_tlp_err. */
        uint64_t dpeoosd               : 1;  /**< [ 17: 17](R/W1C/H) DLLP protocol error (out of sequence DLLP).
                                                                 Internal:
                                                                 rdlh_prot_err. */
        uint64_t fcpvwt                : 1;  /**< [ 18: 18](R/W1C/H) Flow control protocol violation (watchdog timer).
                                                                 Internal:
                                                                 rtlh_fc_prot_err. */
        uint64_t rpe                   : 1;  /**< [ 19: 19](R/W1C/H) PHY reported an 8 B/10 B decode error (RxStatus = 0x4) or disparity error (RxStatus =
                                                                 0x7).

                                                                 Internal:
                                                                 rmlh_rcvd_err. */
        uint64_t fcuv                  : 1;  /**< [ 20: 20](R/W1C/H) Flow control update violation.
                                                                 Internal:
                                                                 (opt. checks) int_xadm_fc_prot_err. */
        uint64_t rqo                   : 1;  /**< [ 21: 21](R/W1C/H) Receive queue overflow. Normally happens only when flow control advertisements are
                                                                 ignored.

                                                                 Internal:
                                                                 radm_qoverflow. */
        uint64_t rauc                  : 1;  /**< [ 22: 22](R/W1C/H) Received an unexpected completion.
                                                                 Internal:
                                                                 radm_unexp_cpl_err. */
        uint64_t racur                 : 1;  /**< [ 23: 23](R/W1C/H) Received a completion with UR status.
                                                                 Internal:
                                                                 radm_rcvd_cpl_ur. */
        uint64_t racca                 : 1;  /**< [ 24: 24](R/W1C/H) Received a completion with CA status.
                                                                 Internal:
                                                                 radm_rcvd_cpl_ca. */
        uint64_t caar                  : 1;  /**< [ 25: 25](R/W1C/H) Completer aborted a request. This bit is never set because CNXXXX does not generate
                                                                 completer aborts. */
        uint64_t rarwdns               : 1;  /**< [ 26: 26](R/W1C/H) Received a request which device does not support.
                                                                 Internal:
                                                                 radm_rcvd_ur_req. */
        uint64_t ramtlp                : 1;  /**< [ 27: 27](R/W1C/H) Received a malformed TLP.
                                                                 Internal:
                                                                 radm_mlf_tlp_err. */
        uint64_t racpp                 : 1;  /**< [ 28: 28](R/W1C/H) Received a completion with poisoned payload.
                                                                 Internal:
                                                                 radm_rcvd_cpl_poisoned. */
        uint64_t rawwpp                : 1;  /**< [ 29: 29](R/W1C/H) Received a write with poisoned payload.
                                                                 Internal:
                                                                 radm_rcvd_wreq_poisoned. */
        uint64_t ecrc_e                : 1;  /**< [ 30: 30](R/W1C/H) Received an ECRC error. */
        uint64_t lofp                  : 1;  /**< [ 31: 31](R/W1C/H) Lack of forward progress at TLP FIFOs timeout occurred. */
        uint64_t reserved_32_55        : 24;
        uint64_t qhdr_b1_dbe           : 1;  /**< [ 56: 56](R/W1C/H) Detected a core header queue bank1 double-bit error. */
        uint64_t m2s_pe                : 1;  /**< [ 57: 57](R/W1C/H) Detected a M2S FIFO parity error. */
        uint64_t reserved_58_63        : 6;
#endif /* Word 0 - End */
    } s;
    struct bdk_pemx_dbg_info_cn88xxp1
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_57_63        : 7;
        uint64_t qhdr_b1_dbe           : 1;  /**< [ 56: 56](R/W1C/H) Detected a core header queue bank1 double-bit error. */
        uint64_t qhdr_b1_sbe           : 1;  /**< [ 55: 55](R/W1C/H) Detected a core header queue bank1 single-bit error. */
        uint64_t qhdr_b0_dbe           : 1;  /**< [ 54: 54](R/W1C/H) Detected a core header queue bank0 double-bit error. */
        uint64_t qhdr_b0_sbe           : 1;  /**< [ 53: 53](R/W1C/H) Detected a core header queue bank0 single-bit error. */
        uint64_t rtry_dbe              : 1;  /**< [ 52: 52](R/W1C/H) Detected a core retry RAM double-bit error. */
        uint64_t rtry_sbe              : 1;  /**< [ 51: 51](R/W1C/H) Detected a core retry RAM single-bit error. */
        uint64_t c_c_dbe               : 1;  /**< [ 50: 50](R/W1C/H) Detected a TLP CPL FIFO control double-bit error. */
        uint64_t c_c_sbe               : 1;  /**< [ 49: 49](R/W1C/H) Detected a TLP CPL FIFO control single-bit error. */
        uint64_t c_d1_dbe              : 1;  /**< [ 48: 48](R/W1C/H) Detected a TLP CPL FIFO data1 double-bit error. */
        uint64_t c_d1_sbe              : 1;  /**< [ 47: 47](R/W1C/H) Detected a TLP CPL FIFO data1 single-bit error. */
        uint64_t c_d0_dbe              : 1;  /**< [ 46: 46](R/W1C/H) Detected a TLP CPL FIFO data0 double-bit error. */
        uint64_t c_d0_sbe              : 1;  /**< [ 45: 45](R/W1C/H) Detected a TLP CPL FIFO data0 single-bit error. */
        uint64_t n_c_dbe               : 1;  /**< [ 44: 44](R/W1C/H) Detected a TLP NP FIFO control double-bit error. */
        uint64_t n_c_sbe               : 1;  /**< [ 43: 43](R/W1C/H) Detected a TLP NP FIFO control single-bit error. */
        uint64_t n_d1_dbe              : 1;  /**< [ 42: 42](R/W1C/H) Detected a TLP NP FIFO data1 double-bit error. */
        uint64_t n_d1_sbe              : 1;  /**< [ 41: 41](R/W1C/H) Detected a TLP NP FIFO data1 single-bit error. */
        uint64_t n_d0_dbe              : 1;  /**< [ 40: 40](R/W1C/H) Detected a TLP NP FIFO data0 double-bit error. */
        uint64_t n_d0_sbe              : 1;  /**< [ 39: 39](R/W1C/H) Detected a TLP NP FIFO data0 single-bit error. */
        uint64_t p_c_dbe               : 1;  /**< [ 38: 38](R/W1C/H) Detected a TLP posted FIFO control double-bit error. */
        uint64_t p_c_sbe               : 1;  /**< [ 37: 37](R/W1C/H) Detected a TLP posted FIFO control single-bit error. */
        uint64_t p_d1_dbe              : 1;  /**< [ 36: 36](R/W1C/H) Detected a TLP posted FIFO data1 double-bit error. */
        uint64_t p_d1_sbe              : 1;  /**< [ 35: 35](R/W1C/H) Detected a TLP posted FIFO data1 single-bit error. */
        uint64_t p_d0_dbe              : 1;  /**< [ 34: 34](R/W1C/H) Detected a TLP posted FIFO data0 double-bit error. */
        uint64_t p_d0_sbe              : 1;  /**< [ 33: 33](R/W1C/H) Detected a TLP posted FIFO data0 single-bit error. */
        uint64_t datq_pe               : 1;  /**< [ 32: 32](R/W1C/H) Detected a data queue RAM parity error. */
        uint64_t lofp                  : 1;  /**< [ 31: 31](R/W1C/H) Lack of forward progress at TLP FIFOs timeout occurred. */
        uint64_t ecrc_e                : 1;  /**< [ 30: 30](R/W1C/H) Received an ECRC error. */
        uint64_t rawwpp                : 1;  /**< [ 29: 29](R/W1C/H) Received a write with poisoned payload.
                                                                 Internal:
                                                                 radm_rcvd_wreq_poisoned. */
        uint64_t racpp                 : 1;  /**< [ 28: 28](R/W1C/H) Received a completion with poisoned payload.
                                                                 Internal:
                                                                 radm_rcvd_cpl_poisoned. */
        uint64_t ramtlp                : 1;  /**< [ 27: 27](R/W1C/H) Received a malformed TLP.
                                                                 Internal:
                                                                 radm_mlf_tlp_err. */
        uint64_t rarwdns               : 1;  /**< [ 26: 26](R/W1C/H) Received a request which device does not support.
                                                                 Internal:
                                                                 radm_rcvd_ur_req. */
        uint64_t caar                  : 1;  /**< [ 25: 25](R/W1C/H) Completer aborted a request. This bit is never set because CNXXXX does not generate
                                                                 completer aborts. */
        uint64_t racca                 : 1;  /**< [ 24: 24](R/W1C/H) Received a completion with CA status.
                                                                 Internal:
                                                                 radm_rcvd_cpl_ca. */
        uint64_t racur                 : 1;  /**< [ 23: 23](R/W1C/H) Received a completion with UR status.
                                                                 Internal:
                                                                 radm_rcvd_cpl_ur. */
        uint64_t rauc                  : 1;  /**< [ 22: 22](R/W1C/H) Received an unexpected completion.
                                                                 Internal:
                                                                 radm_unexp_cpl_err. */
        uint64_t rqo                   : 1;  /**< [ 21: 21](R/W1C/H) Receive queue overflow. Normally happens only when flow control advertisements are
                                                                 ignored.

                                                                 Internal:
                                                                 radm_qoverflow. */
        uint64_t fcuv                  : 1;  /**< [ 20: 20](R/W1C/H) Flow control update violation.
                                                                 Internal:
                                                                 (opt. checks) int_xadm_fc_prot_err. */
        uint64_t rpe                   : 1;  /**< [ 19: 19](R/W1C/H) PHY reported an 8 B/10 B decode error (RxStatus = 0x4) or disparity error (RxStatus =
                                                                 0x7).

                                                                 Internal:
                                                                 rmlh_rcvd_err. */
        uint64_t fcpvwt                : 1;  /**< [ 18: 18](R/W1C/H) Flow control protocol violation (watchdog timer).
                                                                 Internal:
                                                                 rtlh_fc_prot_err. */
        uint64_t dpeoosd               : 1;  /**< [ 17: 17](R/W1C/H) DLLP protocol error (out of sequence DLLP).
                                                                 Internal:
                                                                 rdlh_prot_err. */
        uint64_t rtwdle                : 1;  /**< [ 16: 16](R/W1C/H) Received TLP with datalink layer error.
                                                                 Internal:
                                                                 rdlh_bad_tlp_err. */
        uint64_t rdwdle                : 1;  /**< [ 15: 15](R/W1C/H) Received DLLP with datalink layer error.
                                                                 Internal:
                                                                 rdlh_bad_dllp_err. */
        uint64_t mre                   : 1;  /**< [ 14: 14](R/W1C/H) Maximum number of retries exceeded.
                                                                 Internal:
                                                                 xdlh_replay_num_rlover_err. */
        uint64_t rte                   : 1;  /**< [ 13: 13](R/W1C/H) Replay timer expired. This bit is set when the REPLAY_TIMER expires in the PCIe core. The
                                                                 probability of this bit being set increases with the traffic load.

                                                                 Internal:
                                                                 xdlh_replay_timeout_err. */
        uint64_t acto                  : 1;  /**< [ 12: 12](R/W1C/H) A completion timeout occurred.
                                                                 Internal:
                                                                 pedc_radm_cpl_timeout. */
        uint64_t rvdm                  : 1;  /**< [ 11: 11](R/W1C/H) Received vendor-defined message.
                                                                 Internal:
                                                                 pedc_radm_vendor_msg. */
        uint64_t reserved_10           : 1;
        uint64_t rptamrc               : 1;  /**< [  9:  9](R/W1C/H) Received PME turnoff acknowledge message (RC mode only).
                                                                 Internal:
                                                                 pedc_radm_pm_to_ack. */
        uint64_t rpmerc                : 1;  /**< [  8:  8](R/W1C/H) Received PME message (RC mode only).
                                                                 Internal:
                                                                 pedc_radm_pm_pme. */
        uint64_t rfemrc                : 1;  /**< [  7:  7](R/W1C/H) Received fatal-error message (RC mode only). This bit is set when a message with ERR_FATAL
                                                                 is set.

                                                                 Internal:
                                                                 pedc_radm_fatal_err. */
        uint64_t rnfemrc               : 1;  /**< [  6:  6](R/W1C/H) Received nonfatal error message (RC mode only).
                                                                 Internal:
                                                                 pedc_radm_nonfatal_err. */
        uint64_t rcemrc                : 1;  /**< [  5:  5](R/W1C/H) Received correctable error message (RC mode only).
                                                                 Internal:
                                                                 pedc_radm_correctable_err. */
        uint64_t rpoison               : 1;  /**< [  4:  4](R/W1C/H) Received poisoned TLP.
                                                                 Internal:
                                                                 pedc__radm_trgt1_poisoned & pedc__radm_trgt1_hv. */
        uint64_t recrce                : 1;  /**< [  3:  3](R/W1C/H) Received ECRC error.
                                                                 Internal:
                                                                 pedc_radm_trgt1_ecrc_err & pedc__radm_trgt1_eot. */
        uint64_t rtlplle               : 1;  /**< [  2:  2](R/W1C/H) Received TLP has link layer error.
                                                                 Internal:
                                                                 pedc_radm_trgt1_dllp_abort &
                                                                 pedc__radm_trgt1_eot. */
        uint64_t rtlpmal               : 1;  /**< [  1:  1](R/W1C/H) Received TLP is malformed or a message. If the core receives a MSG (or Vendor Message) or
                                                                 if a received AtomicOp violates address/length rules, this bit is set as well.

                                                                 Internal:
                                                                 pedc_radm_trgt1_tlp_abort & pedc__radm_trgt1_eot. */
        uint64_t spoison               : 1;  /**< [  0:  0](R/W1C/H) Poisoned TLP sent.
                                                                 Internal:
                                                                 peai__client0_tlp_ep & peai__client0_tlp_hv or
                                                                 peai__client1_tlp_ep & peai__client1_tlp_hv (atomic_op). */
#else /* Word 0 - Little Endian */
        uint64_t spoison               : 1;  /**< [  0:  0](R/W1C/H) Poisoned TLP sent.
                                                                 Internal:
                                                                 peai__client0_tlp_ep & peai__client0_tlp_hv or
                                                                 peai__client1_tlp_ep & peai__client1_tlp_hv (atomic_op). */
        uint64_t rtlpmal               : 1;  /**< [  1:  1](R/W1C/H) Received TLP is malformed or a message. If the core receives a MSG (or Vendor Message) or
                                                                 if a received AtomicOp violates address/length rules, this bit is set as well.

                                                                 Internal:
                                                                 pedc_radm_trgt1_tlp_abort & pedc__radm_trgt1_eot. */
        uint64_t rtlplle               : 1;  /**< [  2:  2](R/W1C/H) Received TLP has link layer error.
                                                                 Internal:
                                                                 pedc_radm_trgt1_dllp_abort &
                                                                 pedc__radm_trgt1_eot. */
        uint64_t recrce                : 1;  /**< [  3:  3](R/W1C/H) Received ECRC error.
                                                                 Internal:
                                                                 pedc_radm_trgt1_ecrc_err & pedc__radm_trgt1_eot. */
        uint64_t rpoison               : 1;  /**< [  4:  4](R/W1C/H) Received poisoned TLP.
                                                                 Internal:
                                                                 pedc__radm_trgt1_poisoned & pedc__radm_trgt1_hv. */
        uint64_t rcemrc                : 1;  /**< [  5:  5](R/W1C/H) Received correctable error message (RC mode only).
                                                                 Internal:
                                                                 pedc_radm_correctable_err. */
        uint64_t rnfemrc               : 1;  /**< [  6:  6](R/W1C/H) Received nonfatal error message (RC mode only).
                                                                 Internal:
                                                                 pedc_radm_nonfatal_err. */
        uint64_t rfemrc                : 1;  /**< [  7:  7](R/W1C/H) Received fatal-error message (RC mode only). This bit is set when a message with ERR_FATAL
                                                                 is set.

                                                                 Internal:
                                                                 pedc_radm_fatal_err. */
        uint64_t rpmerc                : 1;  /**< [  8:  8](R/W1C/H) Received PME message (RC mode only).
                                                                 Internal:
                                                                 pedc_radm_pm_pme. */
        uint64_t rptamrc               : 1;  /**< [  9:  9](R/W1C/H) Received PME turnoff acknowledge message (RC mode only).
                                                                 Internal:
                                                                 pedc_radm_pm_to_ack. */
        uint64_t reserved_10           : 1;
        uint64_t rvdm                  : 1;  /**< [ 11: 11](R/W1C/H) Received vendor-defined message.
                                                                 Internal:
                                                                 pedc_radm_vendor_msg. */
        uint64_t acto                  : 1;  /**< [ 12: 12](R/W1C/H) A completion timeout occurred.
                                                                 Internal:
                                                                 pedc_radm_cpl_timeout. */
        uint64_t rte                   : 1;  /**< [ 13: 13](R/W1C/H) Replay timer expired. This bit is set when the REPLAY_TIMER expires in the PCIe core. The
                                                                 probability of this bit being set increases with the traffic load.

                                                                 Internal:
                                                                 xdlh_replay_timeout_err. */
        uint64_t mre                   : 1;  /**< [ 14: 14](R/W1C/H) Maximum number of retries exceeded.
                                                                 Internal:
                                                                 xdlh_replay_num_rlover_err. */
        uint64_t rdwdle                : 1;  /**< [ 15: 15](R/W1C/H) Received DLLP with datalink layer error.
                                                                 Internal:
                                                                 rdlh_bad_dllp_err. */
        uint64_t rtwdle                : 1;  /**< [ 16: 16](R/W1C/H) Received TLP with datalink layer error.
                                                                 Internal:
                                                                 rdlh_bad_tlp_err. */
        uint64_t dpeoosd               : 1;  /**< [ 17: 17](R/W1C/H) DLLP protocol error (out of sequence DLLP).
                                                                 Internal:
                                                                 rdlh_prot_err. */
        uint64_t fcpvwt                : 1;  /**< [ 18: 18](R/W1C/H) Flow control protocol violation (watchdog timer).
                                                                 Internal:
                                                                 rtlh_fc_prot_err. */
        uint64_t rpe                   : 1;  /**< [ 19: 19](R/W1C/H) PHY reported an 8 B/10 B decode error (RxStatus = 0x4) or disparity error (RxStatus =
                                                                 0x7).

                                                                 Internal:
                                                                 rmlh_rcvd_err. */
        uint64_t fcuv                  : 1;  /**< [ 20: 20](R/W1C/H) Flow control update violation.
                                                                 Internal:
                                                                 (opt. checks) int_xadm_fc_prot_err. */
        uint64_t rqo                   : 1;  /**< [ 21: 21](R/W1C/H) Receive queue overflow. Normally happens only when flow control advertisements are
                                                                 ignored.

                                                                 Internal:
                                                                 radm_qoverflow. */
        uint64_t rauc                  : 1;  /**< [ 22: 22](R/W1C/H) Received an unexpected completion.
                                                                 Internal:
                                                                 radm_unexp_cpl_err. */
        uint64_t racur                 : 1;  /**< [ 23: 23](R/W1C/H) Received a completion with UR status.
                                                                 Internal:
                                                                 radm_rcvd_cpl_ur. */
        uint64_t racca                 : 1;  /**< [ 24: 24](R/W1C/H) Received a completion with CA status.
                                                                 Internal:
                                                                 radm_rcvd_cpl_ca. */
        uint64_t caar                  : 1;  /**< [ 25: 25](R/W1C/H) Completer aborted a request. This bit is never set because CNXXXX does not generate
                                                                 completer aborts. */
        uint64_t rarwdns               : 1;  /**< [ 26: 26](R/W1C/H) Received a request which device does not support.
                                                                 Internal:
                                                                 radm_rcvd_ur_req. */
        uint64_t ramtlp                : 1;  /**< [ 27: 27](R/W1C/H) Received a malformed TLP.
                                                                 Internal:
                                                                 radm_mlf_tlp_err. */
        uint64_t racpp                 : 1;  /**< [ 28: 28](R/W1C/H) Received a completion with poisoned payload.
                                                                 Internal:
                                                                 radm_rcvd_cpl_poisoned. */
        uint64_t rawwpp                : 1;  /**< [ 29: 29](R/W1C/H) Received a write with poisoned payload.
                                                                 Internal:
                                                                 radm_rcvd_wreq_poisoned. */
        uint64_t ecrc_e                : 1;  /**< [ 30: 30](R/W1C/H) Received an ECRC error. */
        uint64_t lofp                  : 1;  /**< [ 31: 31](R/W1C/H) Lack of forward progress at TLP FIFOs timeout occurred. */
        uint64_t datq_pe               : 1;  /**< [ 32: 32](R/W1C/H) Detected a data queue RAM parity error. */
        uint64_t p_d0_sbe              : 1;  /**< [ 33: 33](R/W1C/H) Detected a TLP posted FIFO data0 single-bit error. */
        uint64_t p_d0_dbe              : 1;  /**< [ 34: 34](R/W1C/H) Detected a TLP posted FIFO data0 double-bit error. */
        uint64_t p_d1_sbe              : 1;  /**< [ 35: 35](R/W1C/H) Detected a TLP posted FIFO data1 single-bit error. */
        uint64_t p_d1_dbe              : 1;  /**< [ 36: 36](R/W1C/H) Detected a TLP posted FIFO data1 double-bit error. */
        uint64_t p_c_sbe               : 1;  /**< [ 37: 37](R/W1C/H) Detected a TLP posted FIFO control single-bit error. */
        uint64_t p_c_dbe               : 1;  /**< [ 38: 38](R/W1C/H) Detected a TLP posted FIFO control double-bit error. */
        uint64_t n_d0_sbe              : 1;  /**< [ 39: 39](R/W1C/H) Detected a TLP NP FIFO data0 single-bit error. */
        uint64_t n_d0_dbe              : 1;  /**< [ 40: 40](R/W1C/H) Detected a TLP NP FIFO data0 double-bit error. */
        uint64_t n_d1_sbe              : 1;  /**< [ 41: 41](R/W1C/H) Detected a TLP NP FIFO data1 single-bit error. */
        uint64_t n_d1_dbe              : 1;  /**< [ 42: 42](R/W1C/H) Detected a TLP NP FIFO data1 double-bit error. */
        uint64_t n_c_sbe               : 1;  /**< [ 43: 43](R/W1C/H) Detected a TLP NP FIFO control single-bit error. */
        uint64_t n_c_dbe               : 1;  /**< [ 44: 44](R/W1C/H) Detected a TLP NP FIFO control double-bit error. */
        uint64_t c_d0_sbe              : 1;  /**< [ 45: 45](R/W1C/H) Detected a TLP CPL FIFO data0 single-bit error. */
        uint64_t c_d0_dbe              : 1;  /**< [ 46: 46](R/W1C/H) Detected a TLP CPL FIFO data0 double-bit error. */
        uint64_t c_d1_sbe              : 1;  /**< [ 47: 47](R/W1C/H) Detected a TLP CPL FIFO data1 single-bit error. */
        uint64_t c_d1_dbe              : 1;  /**< [ 48: 48](R/W1C/H) Detected a TLP CPL FIFO data1 double-bit error. */
        uint64_t c_c_sbe               : 1;  /**< [ 49: 49](R/W1C/H) Detected a TLP CPL FIFO control single-bit error. */
        uint64_t c_c_dbe               : 1;  /**< [ 50: 50](R/W1C/H) Detected a TLP CPL FIFO control double-bit error. */
        uint64_t rtry_sbe              : 1;  /**< [ 51: 51](R/W1C/H) Detected a core retry RAM single-bit error. */
        uint64_t rtry_dbe              : 1;  /**< [ 52: 52](R/W1C/H) Detected a core retry RAM double-bit error. */
        uint64_t qhdr_b0_sbe           : 1;  /**< [ 53: 53](R/W1C/H) Detected a core header queue bank0 single-bit error. */
        uint64_t qhdr_b0_dbe           : 1;  /**< [ 54: 54](R/W1C/H) Detected a core header queue bank0 double-bit error. */
        uint64_t qhdr_b1_sbe           : 1;  /**< [ 55: 55](R/W1C/H) Detected a core header queue bank1 single-bit error. */
        uint64_t qhdr_b1_dbe           : 1;  /**< [ 56: 56](R/W1C/H) Detected a core header queue bank1 double-bit error. */
        uint64_t reserved_57_63        : 7;
#endif /* Word 0 - End */
    } cn88xxp1;
    struct bdk_pemx_dbg_info_cn9
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_34_63        : 30;
        uint64_t rasdp                 : 1;  /**< [ 33: 33](R/W1C/H) Core entered RAS data protection error mode. */
        uint64_t bmd_e                 : 1;  /**< [ 32: 32](R/W1C/H) A NP or P TLP was seen in the outbound path, but it was not allowed to master the bus.
                                                                 If a PF TLP and the PCIEEP_CMD[ME] is not set.
                                                                 For VF TLP, either the PCIEEP_CMD[ME]/PCIEEPVF_CMD[ME] are not set. */
        uint64_t lofp                  : 1;  /**< [ 31: 31](R/W1C/H) Lack of forward progress at TLP FIFOs timeout occurred. */
        uint64_t ecrc_e                : 1;  /**< [ 30: 30](R/W1C/H) Received an ECRC error. */
        uint64_t rawwpp                : 1;  /**< [ 29: 29](R/W1C/H) Received a write with poisoned payload.
                                                                 Internal:
                                                                 radm_rcvd_wreq_poisoned. */
        uint64_t racpp                 : 1;  /**< [ 28: 28](R/W1C/H) Received a completion with poisoned payload.
                                                                 Internal:
                                                                 radm_rcvd_cpl_poisoned. */
        uint64_t ramtlp                : 1;  /**< [ 27: 27](R/W1C/H) Received a malformed TLP.
                                                                 Internal:
                                                                 radm_mlf_tlp_err. */
        uint64_t rarwdns               : 1;  /**< [ 26: 26](R/W1C/H) Received a request which device does not support.
                                                                 Internal:
                                                                 radm_rcvd_ur_req. */
        uint64_t caar                  : 1;  /**< [ 25: 25](R/W1C/H) Completer aborted a request. This bit is never set because CNXXXX does not generate
                                                                 completer aborts. */
        uint64_t racca                 : 1;  /**< [ 24: 24](R/W1C/H) Received a completion with CA status.
                                                                 Internal:
                                                                 radm_rcvd_cpl_ca. */
        uint64_t racur                 : 1;  /**< [ 23: 23](R/W1C/H) Received a completion with UR status.
                                                                 Internal:
                                                                 radm_rcvd_cpl_ur. */
        uint64_t rauc                  : 1;  /**< [ 22: 22](R/W1C/H) Received an unexpected completion.
                                                                 Internal:
                                                                 radm_unexp_cpl_err. */
        uint64_t rqo                   : 1;  /**< [ 21: 21](R/W1C/H) Receive queue overflow. Normally happens only when flow control advertisements are
                                                                 ignored.

                                                                 Internal:
                                                                 radm_qoverflow. */
        uint64_t fcuv                  : 1;  /**< [ 20: 20](R/W1C/H) Flow control update violation.
                                                                 Internal:
                                                                 (opt. checks) int_xadm_fc_prot_err. */
        uint64_t rpe                   : 1;  /**< [ 19: 19](R/W1C/H) PHY reported an 8 B/10 B decode error (RxStatus = 0x4) or disparity error (RxStatus =
                                                                 0x7).

                                                                 Internal:
                                                                 rmlh_rcvd_err. */
        uint64_t fcpvwt                : 1;  /**< [ 18: 18](R/W1C/H) Flow control protocol violation (watchdog timer).
                                                                 Internal:
                                                                 rtlh_fc_prot_err. */
        uint64_t dpeoosd               : 1;  /**< [ 17: 17](R/W1C/H) DLLP protocol error (out of sequence DLLP).
                                                                 Internal:
                                                                 rdlh_prot_err. */
        uint64_t rtwdle                : 1;  /**< [ 16: 16](R/W1C/H) Received TLP with datalink layer error.
                                                                 Internal:
                                                                 rdlh_bad_tlp_err. */
        uint64_t rdwdle                : 1;  /**< [ 15: 15](R/W1C/H) Received DLLP with datalink layer error.
                                                                 Internal:
                                                                 rdlh_bad_dllp_err. */
        uint64_t mre                   : 1;  /**< [ 14: 14](R/W1C/H) Maximum number of retries exceeded.
                                                                 Internal:
                                                                 xdlh_replay_num_rlover_err. */
        uint64_t rte                   : 1;  /**< [ 13: 13](R/W1C/H) Replay timer expired. This bit is set when the replay timer expires in the PCIe core. The
                                                                 probability of this bit being set increases with the traffic load.

                                                                 Internal:
                                                                 xdlh_replay_timeout_err. */
        uint64_t acto                  : 1;  /**< [ 12: 12](R/W1C/H) A completion timeout occurred.
                                                                 Internal:
                                                                 pedc_radm_cpl_timeout. */
        uint64_t rvdm                  : 1;  /**< [ 11: 11](R/W1C/H) Received vendor-defined message.
                                                                 Internal:
                                                                 pedc_radm_vendor_msg. */
        uint64_t rumep                 : 1;  /**< [ 10: 10](R/W1C/H) Received unlock message (EP mode only).
                                                                 Internal:
                                                                 pedc_radm_msg_unlock. */
        uint64_t rptamrc               : 1;  /**< [  9:  9](R/W1C/H) Received PME turnoff acknowledge message (RC mode only).
                                                                 Internal:
                                                                 pedc_radm_pm_to_ack. */
        uint64_t rpmerc                : 1;  /**< [  8:  8](R/W1C/H) Received PME message (RC mode only).
                                                                 Internal:
                                                                 pedc_radm_pm_pme. */
        uint64_t rfemrc                : 1;  /**< [  7:  7](R/W1C/H) Received fatal-error message. This bit is set when a message with ERR_FATAL
                                                                 is received.

                                                                 Internal:
                                                                 pedc_radm_fatal_err. */
        uint64_t rnfemrc               : 1;  /**< [  6:  6](R/W1C/H) Received nonfatal error message.
                                                                 Internal:
                                                                 pedc_radm_nonfatal_err. */
        uint64_t rcemrc                : 1;  /**< [  5:  5](R/W1C/H) Received correctable error message.
                                                                 Internal:
                                                                 pedc_radm_correctable_err. */
        uint64_t rpoison               : 1;  /**< [  4:  4](R/W1C/H) Received poisoned TLP not to be forwarded to the peer.
                                                                 Internal:
                                                                 pedc__radm_trgt1_poisoned & pedc__radm_trgt1_hv. */
        uint64_t recrce                : 1;  /**< [  3:  3](R/W1C/H) Received ECRC error.
                                                                 Internal:
                                                                 pedc_radm_trgt1_ecrc_err & pedc__radm_trgt1_eot. */
        uint64_t rtlplle               : 1;  /**< [  2:  2](R/W1C/H) Received TLP has link layer error.
                                                                 Internal:
                                                                 pedc_radm_trgt1_dllp_abort &
                                                                 pedc__radm_trgt1_eot. */
        uint64_t rtlpmal               : 1;  /**< [  1:  1](R/W1C/H) Received TLP is malformed or a message. If the core receives a MSG (or vendor message) or
                                                                 if a received AtomicOp violates address/length rules, this bit is set as well.

                                                                 Internal:
                                                                 pedc_radm_trgt1_tlp_abort & pedc__radm_trgt1_eot. */
        uint64_t spoison               : 1;  /**< [  0:  0](R/W1C/H) Poisoned TLP sent. This legacy interrupt is deprecated and is never set. */
#else /* Word 0 - Little Endian */
        uint64_t spoison               : 1;  /**< [  0:  0](R/W1C/H) Poisoned TLP sent. This legacy interrupt is deprecated and is never set. */
        uint64_t rtlpmal               : 1;  /**< [  1:  1](R/W1C/H) Received TLP is malformed or a message. If the core receives a MSG (or vendor message) or
                                                                 if a received AtomicOp violates address/length rules, this bit is set as well.

                                                                 Internal:
                                                                 pedc_radm_trgt1_tlp_abort & pedc__radm_trgt1_eot. */
        uint64_t rtlplle               : 1;  /**< [  2:  2](R/W1C/H) Received TLP has link layer error.
                                                                 Internal:
                                                                 pedc_radm_trgt1_dllp_abort &
                                                                 pedc__radm_trgt1_eot. */
        uint64_t recrce                : 1;  /**< [  3:  3](R/W1C/H) Received ECRC error.
                                                                 Internal:
                                                                 pedc_radm_trgt1_ecrc_err & pedc__radm_trgt1_eot. */
        uint64_t rpoison               : 1;  /**< [  4:  4](R/W1C/H) Received poisoned TLP not to be forwarded to the peer.
                                                                 Internal:
                                                                 pedc__radm_trgt1_poisoned & pedc__radm_trgt1_hv. */
        uint64_t rcemrc                : 1;  /**< [  5:  5](R/W1C/H) Received correctable error message.
                                                                 Internal:
                                                                 pedc_radm_correctable_err. */
        uint64_t rnfemrc               : 1;  /**< [  6:  6](R/W1C/H) Received nonfatal error message.
                                                                 Internal:
                                                                 pedc_radm_nonfatal_err. */
        uint64_t rfemrc                : 1;  /**< [  7:  7](R/W1C/H) Received fatal-error message. This bit is set when a message with ERR_FATAL
                                                                 is received.

                                                                 Internal:
                                                                 pedc_radm_fatal_err. */
        uint64_t rpmerc                : 1;  /**< [  8:  8](R/W1C/H) Received PME message (RC mode only).
                                                                 Internal:
                                                                 pedc_radm_pm_pme. */
        uint64_t rptamrc               : 1;  /**< [  9:  9](R/W1C/H) Received PME turnoff acknowledge message (RC mode only).
                                                                 Internal:
                                                                 pedc_radm_pm_to_ack. */
        uint64_t rumep                 : 1;  /**< [ 10: 10](R/W1C/H) Received unlock message (EP mode only).
                                                                 Internal:
                                                                 pedc_radm_msg_unlock. */
        uint64_t rvdm                  : 1;  /**< [ 11: 11](R/W1C/H) Received vendor-defined message.
                                                                 Internal:
                                                                 pedc_radm_vendor_msg. */
        uint64_t acto                  : 1;  /**< [ 12: 12](R/W1C/H) A completion timeout occurred.
                                                                 Internal:
                                                                 pedc_radm_cpl_timeout. */
        uint64_t rte                   : 1;  /**< [ 13: 13](R/W1C/H) Replay timer expired. This bit is set when the replay timer expires in the PCIe core. The
                                                                 probability of this bit being set increases with the traffic load.

                                                                 Internal:
                                                                 xdlh_replay_timeout_err. */
        uint64_t mre                   : 1;  /**< [ 14: 14](R/W1C/H) Maximum number of retries exceeded.
                                                                 Internal:
                                                                 xdlh_replay_num_rlover_err. */
        uint64_t rdwdle                : 1;  /**< [ 15: 15](R/W1C/H) Received DLLP with datalink layer error.
                                                                 Internal:
                                                                 rdlh_bad_dllp_err. */
        uint64_t rtwdle                : 1;  /**< [ 16: 16](R/W1C/H) Received TLP with datalink layer error.
                                                                 Internal:
                                                                 rdlh_bad_tlp_err. */
        uint64_t dpeoosd               : 1;  /**< [ 17: 17](R/W1C/H) DLLP protocol error (out of sequence DLLP).
                                                                 Internal:
                                                                 rdlh_prot_err. */
        uint64_t fcpvwt                : 1;  /**< [ 18: 18](R/W1C/H) Flow control protocol violation (watchdog timer).
                                                                 Internal:
                                                                 rtlh_fc_prot_err. */
        uint64_t rpe                   : 1;  /**< [ 19: 19](R/W1C/H) PHY reported an 8 B/10 B decode error (RxStatus = 0x4) or disparity error (RxStatus =
                                                                 0x7).

                                                                 Internal:
                                                                 rmlh_rcvd_err. */
        uint64_t fcuv                  : 1;  /**< [ 20: 20](R/W1C/H) Flow control update violation.
                                                                 Internal:
                                                                 (opt. checks) int_xadm_fc_prot_err. */
        uint64_t rqo                   : 1;  /**< [ 21: 21](R/W1C/H) Receive queue overflow. Normally happens only when flow control advertisements are
                                                                 ignored.

                                                                 Internal:
                                                                 radm_qoverflow. */
        uint64_t rauc                  : 1;  /**< [ 22: 22](R/W1C/H) Received an unexpected completion.
                                                                 Internal:
                                                                 radm_unexp_cpl_err. */
        uint64_t racur                 : 1;  /**< [ 23: 23](R/W1C/H) Received a completion with UR status.
                                                                 Internal:
                                                                 radm_rcvd_cpl_ur. */
        uint64_t racca                 : 1;  /**< [ 24: 24](R/W1C/H) Received a completion with CA status.
                                                                 Internal:
                                                                 radm_rcvd_cpl_ca. */
        uint64_t caar                  : 1;  /**< [ 25: 25](R/W1C/H) Completer aborted a request. This bit is never set because CNXXXX does not generate
                                                                 completer aborts. */
        uint64_t rarwdns               : 1;  /**< [ 26: 26](R/W1C/H) Received a request which device does not support.
                                                                 Internal:
                                                                 radm_rcvd_ur_req. */
        uint64_t ramtlp                : 1;  /**< [ 27: 27](R/W1C/H) Received a malformed TLP.
                                                                 Internal:
                                                                 radm_mlf_tlp_err. */
        uint64_t racpp                 : 1;  /**< [ 28: 28](R/W1C/H) Received a completion with poisoned payload.
                                                                 Internal:
                                                                 radm_rcvd_cpl_poisoned. */
        uint64_t rawwpp                : 1;  /**< [ 29: 29](R/W1C/H) Received a write with poisoned payload.
                                                                 Internal:
                                                                 radm_rcvd_wreq_poisoned. */
        uint64_t ecrc_e                : 1;  /**< [ 30: 30](R/W1C/H) Received an ECRC error. */
        uint64_t lofp                  : 1;  /**< [ 31: 31](R/W1C/H) Lack of forward progress at TLP FIFOs timeout occurred. */
        uint64_t bmd_e                 : 1;  /**< [ 32: 32](R/W1C/H) A NP or P TLP was seen in the outbound path, but it was not allowed to master the bus.
                                                                 If a PF TLP and the PCIEEP_CMD[ME] is not set.
                                                                 For VF TLP, either the PCIEEP_CMD[ME]/PCIEEPVF_CMD[ME] are not set. */
        uint64_t rasdp                 : 1;  /**< [ 33: 33](R/W1C/H) Core entered RAS data protection error mode. */
        uint64_t reserved_34_63        : 30;
#endif /* Word 0 - End */
    } cn9;
    struct bdk_pemx_dbg_info_cn81xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_58_63        : 6;
        uint64_t m2s_pe                : 1;  /**< [ 57: 57](R/W1C/H) Detected a M2S FIFO parity error. */
        uint64_t qhdr_b1_dbe           : 1;  /**< [ 56: 56](R/W1C/H) Detected a core header queue bank1 double-bit error. */
        uint64_t qhdr_b1_sbe           : 1;  /**< [ 55: 55](R/W1C/H) Detected a core header queue bank1 single-bit error. */
        uint64_t qhdr_b0_dbe           : 1;  /**< [ 54: 54](R/W1C/H) Detected a core header queue bank0 double-bit error. */
        uint64_t qhdr_b0_sbe           : 1;  /**< [ 53: 53](R/W1C/H) Detected a core header queue bank0 single-bit error. */
        uint64_t rtry_dbe              : 1;  /**< [ 52: 52](R/W1C/H) Detected a core retry RAM double-bit error. */
        uint64_t rtry_sbe              : 1;  /**< [ 51: 51](R/W1C/H) Detected a core retry RAM single-bit error. */
        uint64_t c_c_dbe               : 1;  /**< [ 50: 50](R/W1C/H) Detected a TLP CPL FIFO control double-bit error. */
        uint64_t c_c_sbe               : 1;  /**< [ 49: 49](R/W1C/H) Detected a TLP CPL FIFO control single-bit error. */
        uint64_t c_d1_dbe              : 1;  /**< [ 48: 48](R/W1C/H) Detected a TLP CPL FIFO data1 double-bit error. */
        uint64_t c_d1_sbe              : 1;  /**< [ 47: 47](R/W1C/H) Detected a TLP CPL FIFO data1 single-bit error. */
        uint64_t c_d0_dbe              : 1;  /**< [ 46: 46](R/W1C/H) Detected a TLP CPL FIFO data0 double-bit error. */
        uint64_t c_d0_sbe              : 1;  /**< [ 45: 45](R/W1C/H) Detected a TLP CPL FIFO data0 single-bit error. */
        uint64_t n_c_dbe               : 1;  /**< [ 44: 44](R/W1C/H) Detected a TLP NP FIFO control double-bit error. */
        uint64_t n_c_sbe               : 1;  /**< [ 43: 43](R/W1C/H) Detected a TLP NP FIFO control single-bit error. */
        uint64_t n_d1_dbe              : 1;  /**< [ 42: 42](R/W1C/H) Detected a TLP NP FIFO data1 double-bit error. */
        uint64_t n_d1_sbe              : 1;  /**< [ 41: 41](R/W1C/H) Detected a TLP NP FIFO data1 single-bit error. */
        uint64_t n_d0_dbe              : 1;  /**< [ 40: 40](R/W1C/H) Detected a TLP NP FIFO data0 double-bit error. */
        uint64_t n_d0_sbe              : 1;  /**< [ 39: 39](R/W1C/H) Detected a TLP NP FIFO data0 single-bit error. */
        uint64_t p_c_dbe               : 1;  /**< [ 38: 38](R/W1C/H) Detected a TLP posted FIFO control double-bit error. */
        uint64_t p_c_sbe               : 1;  /**< [ 37: 37](R/W1C/H) Detected a TLP posted FIFO control single-bit error. */
        uint64_t p_d1_dbe              : 1;  /**< [ 36: 36](R/W1C/H) Detected a TLP posted FIFO data1 double-bit error. */
        uint64_t p_d1_sbe              : 1;  /**< [ 35: 35](R/W1C/H) Detected a TLP posted FIFO data1 single-bit error. */
        uint64_t p_d0_dbe              : 1;  /**< [ 34: 34](R/W1C/H) Detected a TLP posted FIFO data0 double-bit error. */
        uint64_t p_d0_sbe              : 1;  /**< [ 33: 33](R/W1C/H) Detected a TLP posted FIFO data0 single-bit error. */
        uint64_t datq_pe               : 1;  /**< [ 32: 32](R/W1C/H) Detected a data queue RAM parity error. */
        uint64_t lofp                  : 1;  /**< [ 31: 31](R/W1C/H) Lack of forward progress at TLP FIFOs timeout occurred. */
        uint64_t ecrc_e                : 1;  /**< [ 30: 30](R/W1C/H) Received an ECRC error. */
        uint64_t rawwpp                : 1;  /**< [ 29: 29](R/W1C/H) Received a write with poisoned payload.
                                                                 Internal:
                                                                 radm_rcvd_wreq_poisoned. */
        uint64_t racpp                 : 1;  /**< [ 28: 28](R/W1C/H) Received a completion with poisoned payload.
                                                                 Internal:
                                                                 radm_rcvd_cpl_poisoned. */
        uint64_t ramtlp                : 1;  /**< [ 27: 27](R/W1C/H) Received a malformed TLP.
                                                                 Internal:
                                                                 radm_mlf_tlp_err. */
        uint64_t rarwdns               : 1;  /**< [ 26: 26](R/W1C/H) Received a request which device does not support.
                                                                 Internal:
                                                                 radm_rcvd_ur_req. */
        uint64_t caar                  : 1;  /**< [ 25: 25](R/W1C/H) Completer aborted a request. This bit is never set because CNXXXX does not generate
                                                                 completer aborts. */
        uint64_t racca                 : 1;  /**< [ 24: 24](R/W1C/H) Received a completion with CA status.
                                                                 Internal:
                                                                 radm_rcvd_cpl_ca. */
        uint64_t racur                 : 1;  /**< [ 23: 23](R/W1C/H) Received a completion with UR status.
                                                                 Internal:
                                                                 radm_rcvd_cpl_ur. */
        uint64_t rauc                  : 1;  /**< [ 22: 22](R/W1C/H) Received an unexpected completion.
                                                                 Internal:
                                                                 radm_unexp_cpl_err. */
        uint64_t rqo                   : 1;  /**< [ 21: 21](R/W1C/H) Receive queue overflow. Normally happens only when flow control advertisements are
                                                                 ignored.

                                                                 Internal:
                                                                 radm_qoverflow. */
        uint64_t fcuv                  : 1;  /**< [ 20: 20](R/W1C/H) Flow control update violation.
                                                                 Internal:
                                                                 (opt. checks) int_xadm_fc_prot_err. */
        uint64_t rpe                   : 1;  /**< [ 19: 19](R/W1C/H) PHY reported an 8 B/10 B decode error (RxStatus = 0x4) or disparity error (RxStatus =
                                                                 0x7).

                                                                 Internal:
                                                                 rmlh_rcvd_err. */
        uint64_t fcpvwt                : 1;  /**< [ 18: 18](R/W1C/H) Flow control protocol violation (watchdog timer).
                                                                 Internal:
                                                                 rtlh_fc_prot_err. */
        uint64_t dpeoosd               : 1;  /**< [ 17: 17](R/W1C/H) DLLP protocol error (out of sequence DLLP).
                                                                 Internal:
                                                                 rdlh_prot_err. */
        uint64_t rtwdle                : 1;  /**< [ 16: 16](R/W1C/H) Received TLP with datalink layer error.
                                                                 Internal:
                                                                 rdlh_bad_tlp_err. */
        uint64_t rdwdle                : 1;  /**< [ 15: 15](R/W1C/H) Received DLLP with datalink layer error.
                                                                 Internal:
                                                                 rdlh_bad_dllp_err. */
        uint64_t mre                   : 1;  /**< [ 14: 14](R/W1C/H) Maximum number of retries exceeded.
                                                                 Internal:
                                                                 xdlh_replay_num_rlover_err. */
        uint64_t rte                   : 1;  /**< [ 13: 13](R/W1C/H) Replay timer expired. This bit is set when the REPLAY_TIMER expires in the PCIe core. The
                                                                 probability of this bit being set increases with the traffic load.

                                                                 Internal:
                                                                 xdlh_replay_timeout_err. */
        uint64_t acto                  : 1;  /**< [ 12: 12](R/W1C/H) A completion timeout occurred.
                                                                 Internal:
                                                                 pedc_radm_cpl_timeout. */
        uint64_t rvdm                  : 1;  /**< [ 11: 11](R/W1C/H) Received vendor-defined message.
                                                                 Internal:
                                                                 pedc_radm_vendor_msg. */
        uint64_t reserved_10           : 1;
        uint64_t rptamrc               : 1;  /**< [  9:  9](R/W1C/H) Received PME turnoff acknowledge message (RC mode only).
                                                                 Internal:
                                                                 pedc_radm_pm_to_ack. */
        uint64_t rpmerc                : 1;  /**< [  8:  8](R/W1C/H) Received PME message (RC mode only).
                                                                 Internal:
                                                                 pedc_radm_pm_pme. */
        uint64_t rfemrc                : 1;  /**< [  7:  7](R/W1C/H) Received fatal-error message (RC mode only). This bit is set when a message with ERR_FATAL
                                                                 is set.

                                                                 Internal:
                                                                 pedc_radm_fatal_err. */
        uint64_t rnfemrc               : 1;  /**< [  6:  6](R/W1C/H) Received nonfatal error message (RC mode only).
                                                                 Internal:
                                                                 pedc_radm_nonfatal_err. */
        uint64_t rcemrc                : 1;  /**< [  5:  5](R/W1C/H) Received correctable error message (RC mode only).
                                                                 Internal:
                                                                 pedc_radm_correctable_err. */
        uint64_t rpoison               : 1;  /**< [  4:  4](R/W1C/H) Received poisoned TLP.
                                                                 Internal:
                                                                 pedc__radm_trgt1_poisoned & pedc__radm_trgt1_hv. */
        uint64_t recrce                : 1;  /**< [  3:  3](R/W1C/H) Received ECRC error.
                                                                 Internal:
                                                                 pedc_radm_trgt1_ecrc_err & pedc__radm_trgt1_eot. */
        uint64_t rtlplle               : 1;  /**< [  2:  2](R/W1C/H) Received TLP has link layer error.
                                                                 Internal:
                                                                 pedc_radm_trgt1_dllp_abort &
                                                                 pedc__radm_trgt1_eot. */
        uint64_t rtlpmal               : 1;  /**< [  1:  1](R/W1C/H) Received TLP is malformed or a message. If the core receives a MSG (or Vendor Message) or
                                                                 if a received AtomicOp violates address/length rules, this bit is set as well.

                                                                 Internal:
                                                                 pedc_radm_trgt1_tlp_abort & pedc__radm_trgt1_eot. */
        uint64_t spoison               : 1;  /**< [  0:  0](R/W1C/H) Poisoned TLP sent.
                                                                 Internal:
                                                                 peai__client0_tlp_ep & peai__client0_tlp_hv or
                                                                 peai__client1_tlp_ep & peai__client1_tlp_hv (atomic_op). */
#else /* Word 0 - Little Endian */
        uint64_t spoison               : 1;  /**< [  0:  0](R/W1C/H) Poisoned TLP sent.
                                                                 Internal:
                                                                 peai__client0_tlp_ep & peai__client0_tlp_hv or
                                                                 peai__client1_tlp_ep & peai__client1_tlp_hv (atomic_op). */
        uint64_t rtlpmal               : 1;  /**< [  1:  1](R/W1C/H) Received TLP is malformed or a message. If the core receives a MSG (or Vendor Message) or
                                                                 if a received AtomicOp violates address/length rules, this bit is set as well.

                                                                 Internal:
                                                                 pedc_radm_trgt1_tlp_abort & pedc__radm_trgt1_eot. */
        uint64_t rtlplle               : 1;  /**< [  2:  2](R/W1C/H) Received TLP has link layer error.
                                                                 Internal:
                                                                 pedc_radm_trgt1_dllp_abort &
                                                                 pedc__radm_trgt1_eot. */
        uint64_t recrce                : 1;  /**< [  3:  3](R/W1C/H) Received ECRC error.
                                                                 Internal:
                                                                 pedc_radm_trgt1_ecrc_err & pedc__radm_trgt1_eot. */
        uint64_t rpoison               : 1;  /**< [  4:  4](R/W1C/H) Received poisoned TLP.
                                                                 Internal:
                                                                 pedc__radm_trgt1_poisoned & pedc__radm_trgt1_hv. */
        uint64_t rcemrc                : 1;  /**< [  5:  5](R/W1C/H) Received correctable error message (RC mode only).
                                                                 Internal:
                                                                 pedc_radm_correctable_err. */
        uint64_t rnfemrc               : 1;  /**< [  6:  6](R/W1C/H) Received nonfatal error message (RC mode only).
                                                                 Internal:
                                                                 pedc_radm_nonfatal_err. */
        uint64_t rfemrc                : 1;  /**< [  7:  7](R/W1C/H) Received fatal-error message (RC mode only). This bit is set when a message with ERR_FATAL
                                                                 is set.

                                                                 Internal:
                                                                 pedc_radm_fatal_err. */
        uint64_t rpmerc                : 1;  /**< [  8:  8](R/W1C/H) Received PME message (RC mode only).
                                                                 Internal:
                                                                 pedc_radm_pm_pme. */
        uint64_t rptamrc               : 1;  /**< [  9:  9](R/W1C/H) Received PME turnoff acknowledge message (RC mode only).
                                                                 Internal:
                                                                 pedc_radm_pm_to_ack. */
        uint64_t reserved_10           : 1;
        uint64_t rvdm                  : 1;  /**< [ 11: 11](R/W1C/H) Received vendor-defined message.
                                                                 Internal:
                                                                 pedc_radm_vendor_msg. */
        uint64_t acto                  : 1;  /**< [ 12: 12](R/W1C/H) A completion timeout occurred.
                                                                 Internal:
                                                                 pedc_radm_cpl_timeout. */
        uint64_t rte                   : 1;  /**< [ 13: 13](R/W1C/H) Replay timer expired. This bit is set when the REPLAY_TIMER expires in the PCIe core. The
                                                                 probability of this bit being set increases with the traffic load.

                                                                 Internal:
                                                                 xdlh_replay_timeout_err. */
        uint64_t mre                   : 1;  /**< [ 14: 14](R/W1C/H) Maximum number of retries exceeded.
                                                                 Internal:
                                                                 xdlh_replay_num_rlover_err. */
        uint64_t rdwdle                : 1;  /**< [ 15: 15](R/W1C/H) Received DLLP with datalink layer error.
                                                                 Internal:
                                                                 rdlh_bad_dllp_err. */
        uint64_t rtwdle                : 1;  /**< [ 16: 16](R/W1C/H) Received TLP with datalink layer error.
                                                                 Internal:
                                                                 rdlh_bad_tlp_err. */
        uint64_t dpeoosd               : 1;  /**< [ 17: 17](R/W1C/H) DLLP protocol error (out of sequence DLLP).
                                                                 Internal:
                                                                 rdlh_prot_err. */
        uint64_t fcpvwt                : 1;  /**< [ 18: 18](R/W1C/H) Flow control protocol violation (watchdog timer).
                                                                 Internal:
                                                                 rtlh_fc_prot_err. */
        uint64_t rpe                   : 1;  /**< [ 19: 19](R/W1C/H) PHY reported an 8 B/10 B decode error (RxStatus = 0x4) or disparity error (RxStatus =
                                                                 0x7).

                                                                 Internal:
                                                                 rmlh_rcvd_err. */
        uint64_t fcuv                  : 1;  /**< [ 20: 20](R/W1C/H) Flow control update violation.
                                                                 Internal:
                                                                 (opt. checks) int_xadm_fc_prot_err. */
        uint64_t rqo                   : 1;  /**< [ 21: 21](R/W1C/H) Receive queue overflow. Normally happens only when flow control advertisements are
                                                                 ignored.

                                                                 Internal:
                                                                 radm_qoverflow. */
        uint64_t rauc                  : 1;  /**< [ 22: 22](R/W1C/H) Received an unexpected completion.
                                                                 Internal:
                                                                 radm_unexp_cpl_err. */
        uint64_t racur                 : 1;  /**< [ 23: 23](R/W1C/H) Received a completion with UR status.
                                                                 Internal:
                                                                 radm_rcvd_cpl_ur. */
        uint64_t racca                 : 1;  /**< [ 24: 24](R/W1C/H) Received a completion with CA status.
                                                                 Internal:
                                                                 radm_rcvd_cpl_ca. */
        uint64_t caar                  : 1;  /**< [ 25: 25](R/W1C/H) Completer aborted a request. This bit is never set because CNXXXX does not generate
                                                                 completer aborts. */
        uint64_t rarwdns               : 1;  /**< [ 26: 26](R/W1C/H) Received a request which device does not support.
                                                                 Internal:
                                                                 radm_rcvd_ur_req. */
        uint64_t ramtlp                : 1;  /**< [ 27: 27](R/W1C/H) Received a malformed TLP.
                                                                 Internal:
                                                                 radm_mlf_tlp_err. */
        uint64_t racpp                 : 1;  /**< [ 28: 28](R/W1C/H) Received a completion with poisoned payload.
                                                                 Internal:
                                                                 radm_rcvd_cpl_poisoned. */
        uint64_t rawwpp                : 1;  /**< [ 29: 29](R/W1C/H) Received a write with poisoned payload.
                                                                 Internal:
                                                                 radm_rcvd_wreq_poisoned. */
        uint64_t ecrc_e                : 1;  /**< [ 30: 30](R/W1C/H) Received an ECRC error. */
        uint64_t lofp                  : 1;  /**< [ 31: 31](R/W1C/H) Lack of forward progress at TLP FIFOs timeout occurred. */
        uint64_t datq_pe               : 1;  /**< [ 32: 32](R/W1C/H) Detected a data queue RAM parity error. */
        uint64_t p_d0_sbe              : 1;  /**< [ 33: 33](R/W1C/H) Detected a TLP posted FIFO data0 single-bit error. */
        uint64_t p_d0_dbe              : 1;  /**< [ 34: 34](R/W1C/H) Detected a TLP posted FIFO data0 double-bit error. */
        uint64_t p_d1_sbe              : 1;  /**< [ 35: 35](R/W1C/H) Detected a TLP posted FIFO data1 single-bit error. */
        uint64_t p_d1_dbe              : 1;  /**< [ 36: 36](R/W1C/H) Detected a TLP posted FIFO data1 double-bit error. */
        uint64_t p_c_sbe               : 1;  /**< [ 37: 37](R/W1C/H) Detected a TLP posted FIFO control single-bit error. */
        uint64_t p_c_dbe               : 1;  /**< [ 38: 38](R/W1C/H) Detected a TLP posted FIFO control double-bit error. */
        uint64_t n_d0_sbe              : 1;  /**< [ 39: 39](R/W1C/H) Detected a TLP NP FIFO data0 single-bit error. */
        uint64_t n_d0_dbe              : 1;  /**< [ 40: 40](R/W1C/H) Detected a TLP NP FIFO data0 double-bit error. */
        uint64_t n_d1_sbe              : 1;  /**< [ 41: 41](R/W1C/H) Detected a TLP NP FIFO data1 single-bit error. */
        uint64_t n_d1_dbe              : 1;  /**< [ 42: 42](R/W1C/H) Detected a TLP NP FIFO data1 double-bit error. */
        uint64_t n_c_sbe               : 1;  /**< [ 43: 43](R/W1C/H) Detected a TLP NP FIFO control single-bit error. */
        uint64_t n_c_dbe               : 1;  /**< [ 44: 44](R/W1C/H) Detected a TLP NP FIFO control double-bit error. */
        uint64_t c_d0_sbe              : 1;  /**< [ 45: 45](R/W1C/H) Detected a TLP CPL FIFO data0 single-bit error. */
        uint64_t c_d0_dbe              : 1;  /**< [ 46: 46](R/W1C/H) Detected a TLP CPL FIFO data0 double-bit error. */
        uint64_t c_d1_sbe              : 1;  /**< [ 47: 47](R/W1C/H) Detected a TLP CPL FIFO data1 single-bit error. */
        uint64_t c_d1_dbe              : 1;  /**< [ 48: 48](R/W1C/H) Detected a TLP CPL FIFO data1 double-bit error. */
        uint64_t c_c_sbe               : 1;  /**< [ 49: 49](R/W1C/H) Detected a TLP CPL FIFO control single-bit error. */
        uint64_t c_c_dbe               : 1;  /**< [ 50: 50](R/W1C/H) Detected a TLP CPL FIFO control double-bit error. */
        uint64_t rtry_sbe              : 1;  /**< [ 51: 51](R/W1C/H) Detected a core retry RAM single-bit error. */
        uint64_t rtry_dbe              : 1;  /**< [ 52: 52](R/W1C/H) Detected a core retry RAM double-bit error. */
        uint64_t qhdr_b0_sbe           : 1;  /**< [ 53: 53](R/W1C/H) Detected a core header queue bank0 single-bit error. */
        uint64_t qhdr_b0_dbe           : 1;  /**< [ 54: 54](R/W1C/H) Detected a core header queue bank0 double-bit error. */
        uint64_t qhdr_b1_sbe           : 1;  /**< [ 55: 55](R/W1C/H) Detected a core header queue bank1 single-bit error. */
        uint64_t qhdr_b1_dbe           : 1;  /**< [ 56: 56](R/W1C/H) Detected a core header queue bank1 double-bit error. */
        uint64_t m2s_pe                : 1;  /**< [ 57: 57](R/W1C/H) Detected a M2S FIFO parity error. */
        uint64_t reserved_58_63        : 6;
#endif /* Word 0 - End */
    } cn81xx;
    struct bdk_pemx_dbg_info_cn83xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_56_63        : 8;
        uint64_t rasdp                 : 1;  /**< [ 55: 55](R/W1C/H) Core entered RAS data protection error mode. */
        uint64_t m2s_d_dbe             : 1;  /**< [ 54: 54](R/W1C/H) Detected a M2S data fifo double bit error. */
        uint64_t m2s_d_sbe             : 1;  /**< [ 53: 53](R/W1C/H) Detected a M2S data fifo single bit error. */
        uint64_t m2s_c_dbe             : 1;  /**< [ 52: 52](R/W1C/H) Detected a M2S data fifo double bit error. */
        uint64_t m2s_c_sbe             : 1;  /**< [ 51: 51](R/W1C/H) Detected a M2S control fifo single bit error. */
        uint64_t c_c_dbe               : 1;  /**< [ 50: 50](R/W1C/H) Detected a TLP CPL FIFO control double-bit error. */
        uint64_t c_c_sbe               : 1;  /**< [ 49: 49](R/W1C/H) Detected a TLP CPL FIFO control single-bit error. */
        uint64_t c_d1_dbe              : 1;  /**< [ 48: 48](R/W1C/H) Detected a TLP CPL FIFO data1 double-bit error. */
        uint64_t c_d1_sbe              : 1;  /**< [ 47: 47](R/W1C/H) Detected a TLP CPL FIFO data1 single-bit error. */
        uint64_t c_d0_dbe              : 1;  /**< [ 46: 46](R/W1C/H) Detected a TLP CPL FIFO data0 double-bit error. */
        uint64_t c_d0_sbe              : 1;  /**< [ 45: 45](R/W1C/H) Detected a TLP CPL FIFO data0 single-bit error. */
        uint64_t n_c_dbe               : 1;  /**< [ 44: 44](R/W1C/H) Detected a TLP NP FIFO control double-bit error. */
        uint64_t n_c_sbe               : 1;  /**< [ 43: 43](R/W1C/H) Detected a TLP NP FIFO control single-bit error. */
        uint64_t n_d1_dbe              : 1;  /**< [ 42: 42](R/W1C/H) Detected a TLP NP FIFO data1 double-bit error. */
        uint64_t n_d1_sbe              : 1;  /**< [ 41: 41](R/W1C/H) Detected a TLP NP FIFO data1 single-bit error. */
        uint64_t n_d0_dbe              : 1;  /**< [ 40: 40](R/W1C/H) Detected a TLP NP FIFO data0 double-bit error. */
        uint64_t n_d0_sbe              : 1;  /**< [ 39: 39](R/W1C/H) Detected a TLP NP FIFO data0 single-bit error. */
        uint64_t p_c_dbe               : 1;  /**< [ 38: 38](R/W1C/H) Detected a TLP posted FIFO control double-bit error. */
        uint64_t p_c_sbe               : 1;  /**< [ 37: 37](R/W1C/H) Detected a TLP posted FIFO control single-bit error. */
        uint64_t p_d1_dbe              : 1;  /**< [ 36: 36](R/W1C/H) Detected a TLP posted FIFO data1 double-bit error. */
        uint64_t p_d1_sbe              : 1;  /**< [ 35: 35](R/W1C/H) Detected a TLP posted FIFO data1 single-bit error. */
        uint64_t p_d0_dbe              : 1;  /**< [ 34: 34](R/W1C/H) Detected a TLP posted FIFO data0 double-bit error. */
        uint64_t p_d0_sbe              : 1;  /**< [ 33: 33](R/W1C/H) Detected a TLP posted FIFO data0 single-bit error. */
        uint64_t bmd_e                 : 1;  /**< [ 32: 32](R/W1C/H) A NP or P TLP was seen in the outbound path, but it was not allowed to master the bus.
                                                                 If a PF TLP and the PCIEEP()_CFG001[ME] is not set.
                                                                 For VF TLP, either the PCIEEP()_CFG001[ME]/PCIEEPVF()_CFG001[ME] are not set. */
        uint64_t lofp                  : 1;  /**< [ 31: 31](R/W1C/H) Lack of forward progress at TLP FIFOs timeout occurred. */
        uint64_t ecrc_e                : 1;  /**< [ 30: 30](R/W1C/H) Received an ECRC error. */
        uint64_t rawwpp                : 1;  /**< [ 29: 29](R/W1C/H) Received a write with poisoned payload.
                                                                 Internal:
                                                                 radm_rcvd_wreq_poisoned. */
        uint64_t racpp                 : 1;  /**< [ 28: 28](R/W1C/H) Received a completion with poisoned payload.
                                                                 Internal:
                                                                 radm_rcvd_cpl_poisoned. */
        uint64_t ramtlp                : 1;  /**< [ 27: 27](R/W1C/H) Received a malformed TLP.
                                                                 Internal:
                                                                 radm_mlf_tlp_err. */
        uint64_t rarwdns               : 1;  /**< [ 26: 26](R/W1C/H) Received a request which device does not support.
                                                                 Internal:
                                                                 radm_rcvd_ur_req. */
        uint64_t caar                  : 1;  /**< [ 25: 25](R/W1C/H) Completer aborted a request. This bit is never set because CNXXXX does not generate
                                                                 completer aborts. */
        uint64_t racca                 : 1;  /**< [ 24: 24](R/W1C/H) Received a completion with CA status.
                                                                 Internal:
                                                                 radm_rcvd_cpl_ca. */
        uint64_t racur                 : 1;  /**< [ 23: 23](R/W1C/H) Received a completion with UR status.
                                                                 Internal:
                                                                 radm_rcvd_cpl_ur. */
        uint64_t rauc                  : 1;  /**< [ 22: 22](R/W1C/H) Received an unexpected completion.
                                                                 Internal:
                                                                 radm_unexp_cpl_err. */
        uint64_t rqo                   : 1;  /**< [ 21: 21](R/W1C/H) Receive queue overflow. Normally happens only when flow control advertisements are
                                                                 ignored.

                                                                 Internal:
                                                                 radm_qoverflow. */
        uint64_t fcuv                  : 1;  /**< [ 20: 20](R/W1C/H) Flow control update violation.
                                                                 Internal:
                                                                 (opt. checks) int_xadm_fc_prot_err. */
        uint64_t rpe                   : 1;  /**< [ 19: 19](R/W1C/H) PHY reported an 8 B/10 B decode error (RxStatus = 0x4) or disparity error (RxStatus =
                                                                 0x7).

                                                                 Internal:
                                                                 rmlh_rcvd_err. */
        uint64_t fcpvwt                : 1;  /**< [ 18: 18](R/W1C/H) Flow control protocol violation (watchdog timer).
                                                                 Internal:
                                                                 rtlh_fc_prot_err. */
        uint64_t dpeoosd               : 1;  /**< [ 17: 17](R/W1C/H) DLLP protocol error (out of sequence DLLP).
                                                                 Internal:
                                                                 rdlh_prot_err. */
        uint64_t rtwdle                : 1;  /**< [ 16: 16](R/W1C/H) Received TLP with datalink layer error.
                                                                 Internal:
                                                                 rdlh_bad_tlp_err. */
        uint64_t rdwdle                : 1;  /**< [ 15: 15](R/W1C/H) Received DLLP with datalink layer error.
                                                                 Internal:
                                                                 rdlh_bad_dllp_err. */
        uint64_t mre                   : 1;  /**< [ 14: 14](R/W1C/H) Maximum number of retries exceeded.
                                                                 Internal:
                                                                 xdlh_replay_num_rlover_err. */
        uint64_t rte                   : 1;  /**< [ 13: 13](R/W1C/H) Replay timer expired. This bit is set when the REPLAY_TIMER expires in the PCIe core. The
                                                                 probability of this bit being set increases with the traffic load.

                                                                 Internal:
                                                                 xdlh_replay_timeout_err. */
        uint64_t acto                  : 1;  /**< [ 12: 12](R/W1C/H) A completion timeout occurred.
                                                                 Internal:
                                                                 pedc_radm_cpl_timeout. */
        uint64_t rvdm                  : 1;  /**< [ 11: 11](R/W1C/H) Received vendor-defined message.
                                                                 Internal:
                                                                 pedc_radm_vendor_msg. */
        uint64_t rumep                 : 1;  /**< [ 10: 10](R/W1C/H) Received unlock message (EP mode only).
                                                                 Internal:
                                                                 pedc_radm_msg_unlock. */
        uint64_t rptamrc               : 1;  /**< [  9:  9](R/W1C/H) Received PME turnoff acknowledge message (RC mode only).
                                                                 Internal:
                                                                 pedc_radm_pm_to_ack. */
        uint64_t rpmerc                : 1;  /**< [  8:  8](R/W1C/H) Received PME message (RC mode only).
                                                                 Internal:
                                                                 pedc_radm_pm_pme. */
        uint64_t rfemrc                : 1;  /**< [  7:  7](R/W1C/H) Received fatal-error message. This bit is set when a message with ERR_FATAL
                                                                 is set.

                                                                 Internal:
                                                                 pedc_radm_fatal_err. */
        uint64_t rnfemrc               : 1;  /**< [  6:  6](R/W1C/H) Received nonfatal error message.
                                                                 Internal:
                                                                 pedc_radm_nonfatal_err. */
        uint64_t rcemrc                : 1;  /**< [  5:  5](R/W1C/H) Received correctable error message.
                                                                 Internal:
                                                                 pedc_radm_correctable_err. */
        uint64_t rpoison               : 1;  /**< [  4:  4](R/W1C/H) Received poisoned TLP not to be forwarded to the peer.
                                                                 Internal:
                                                                 pedc__radm_trgt1_poisoned & pedc__radm_trgt1_hv. */
        uint64_t recrce                : 1;  /**< [  3:  3](R/W1C/H) Received ECRC error.
                                                                 Internal:
                                                                 pedc_radm_trgt1_ecrc_err & pedc__radm_trgt1_eot. */
        uint64_t rtlplle               : 1;  /**< [  2:  2](R/W1C/H) Received TLP has link layer error.
                                                                 Internal:
                                                                 pedc_radm_trgt1_dllp_abort &
                                                                 pedc__radm_trgt1_eot. */
        uint64_t rtlpmal               : 1;  /**< [  1:  1](R/W1C/H) Received TLP is malformed or a message. If the core receives a MSG (or Vendor Message) or
                                                                 if a received AtomicOp violates address/length rules, this bit is set as well.

                                                                 Internal:
                                                                 pedc_radm_trgt1_tlp_abort & pedc__radm_trgt1_eot. */
        uint64_t spoison               : 1;  /**< [  0:  0](R/W1C/H) Poisoned TLP sent. This legacy interrupt is deprecated and is never set. */
#else /* Word 0 - Little Endian */
        uint64_t spoison               : 1;  /**< [  0:  0](R/W1C/H) Poisoned TLP sent. This legacy interrupt is deprecated and is never set. */
        uint64_t rtlpmal               : 1;  /**< [  1:  1](R/W1C/H) Received TLP is malformed or a message. If the core receives a MSG (or Vendor Message) or
                                                                 if a received AtomicOp violates address/length rules, this bit is set as well.

                                                                 Internal:
                                                                 pedc_radm_trgt1_tlp_abort & pedc__radm_trgt1_eot. */
        uint64_t rtlplle               : 1;  /**< [  2:  2](R/W1C/H) Received TLP has link layer error.
                                                                 Internal:
                                                                 pedc_radm_trgt1_dllp_abort &
                                                                 pedc__radm_trgt1_eot. */
        uint64_t recrce                : 1;  /**< [  3:  3](R/W1C/H) Received ECRC error.
                                                                 Internal:
                                                                 pedc_radm_trgt1_ecrc_err & pedc__radm_trgt1_eot. */
        uint64_t rpoison               : 1;  /**< [  4:  4](R/W1C/H) Received poisoned TLP not to be forwarded to the peer.
                                                                 Internal:
                                                                 pedc__radm_trgt1_poisoned & pedc__radm_trgt1_hv. */
        uint64_t rcemrc                : 1;  /**< [  5:  5](R/W1C/H) Received correctable error message.
                                                                 Internal:
                                                                 pedc_radm_correctable_err. */
        uint64_t rnfemrc               : 1;  /**< [  6:  6](R/W1C/H) Received nonfatal error message.
                                                                 Internal:
                                                                 pedc_radm_nonfatal_err. */
        uint64_t rfemrc                : 1;  /**< [  7:  7](R/W1C/H) Received fatal-error message. This bit is set when a message with ERR_FATAL
                                                                 is set.

                                                                 Internal:
                                                                 pedc_radm_fatal_err. */
        uint64_t rpmerc                : 1;  /**< [  8:  8](R/W1C/H) Received PME message (RC mode only).
                                                                 Internal:
                                                                 pedc_radm_pm_pme. */
        uint64_t rptamrc               : 1;  /**< [  9:  9](R/W1C/H) Received PME turnoff acknowledge message (RC mode only).
                                                                 Internal:
                                                                 pedc_radm_pm_to_ack. */
        uint64_t rumep                 : 1;  /**< [ 10: 10](R/W1C/H) Received unlock message (EP mode only).
                                                                 Internal:
                                                                 pedc_radm_msg_unlock. */
        uint64_t rvdm                  : 1;  /**< [ 11: 11](R/W1C/H) Received vendor-defined message.
                                                                 Internal:
                                                                 pedc_radm_vendor_msg. */
        uint64_t acto                  : 1;  /**< [ 12: 12](R/W1C/H) A completion timeout occurred.
                                                                 Internal:
                                                                 pedc_radm_cpl_timeout. */
        uint64_t rte                   : 1;  /**< [ 13: 13](R/W1C/H) Replay timer expired. This bit is set when the REPLAY_TIMER expires in the PCIe core. The
                                                                 probability of this bit being set increases with the traffic load.

                                                                 Internal:
                                                                 xdlh_replay_timeout_err. */
        uint64_t mre                   : 1;  /**< [ 14: 14](R/W1C/H) Maximum number of retries exceeded.
                                                                 Internal:
                                                                 xdlh_replay_num_rlover_err. */
        uint64_t rdwdle                : 1;  /**< [ 15: 15](R/W1C/H) Received DLLP with datalink layer error.
                                                                 Internal:
                                                                 rdlh_bad_dllp_err. */
        uint64_t rtwdle                : 1;  /**< [ 16: 16](R/W1C/H) Received TLP with datalink layer error.
                                                                 Internal:
                                                                 rdlh_bad_tlp_err. */
        uint64_t dpeoosd               : 1;  /**< [ 17: 17](R/W1C/H) DLLP protocol error (out of sequence DLLP).
                                                                 Internal:
                                                                 rdlh_prot_err. */
        uint64_t fcpvwt                : 1;  /**< [ 18: 18](R/W1C/H) Flow control protocol violation (watchdog timer).
                                                                 Internal:
                                                                 rtlh_fc_prot_err. */
        uint64_t rpe                   : 1;  /**< [ 19: 19](R/W1C/H) PHY reported an 8 B/10 B decode error (RxStatus = 0x4) or disparity error (RxStatus =
                                                                 0x7).

                                                                 Internal:
                                                                 rmlh_rcvd_err. */
        uint64_t fcuv                  : 1;  /**< [ 20: 20](R/W1C/H) Flow control update violation.
                                                                 Internal:
                                                                 (opt. checks) int_xadm_fc_prot_err. */
        uint64_t rqo                   : 1;  /**< [ 21: 21](R/W1C/H) Receive queue overflow. Normally happens only when flow control advertisements are
                                                                 ignored.

                                                                 Internal:
                                                                 radm_qoverflow. */
        uint64_t rauc                  : 1;  /**< [ 22: 22](R/W1C/H) Received an unexpected completion.
                                                                 Internal:
                                                                 radm_unexp_cpl_err. */
        uint64_t racur                 : 1;  /**< [ 23: 23](R/W1C/H) Received a completion with UR status.
                                                                 Internal:
                                                                 radm_rcvd_cpl_ur. */
        uint64_t racca                 : 1;  /**< [ 24: 24](R/W1C/H) Received a completion with CA status.
                                                                 Internal:
                                                                 radm_rcvd_cpl_ca. */
        uint64_t caar                  : 1;  /**< [ 25: 25](R/W1C/H) Completer aborted a request. This bit is never set because CNXXXX does not generate
                                                                 completer aborts. */
        uint64_t rarwdns               : 1;  /**< [ 26: 26](R/W1C/H) Received a request which device does not support.
                                                                 Internal:
                                                                 radm_rcvd_ur_req. */
        uint64_t ramtlp                : 1;  /**< [ 27: 27](R/W1C/H) Received a malformed TLP.
                                                                 Internal:
                                                                 radm_mlf_tlp_err. */
        uint64_t racpp                 : 1;  /**< [ 28: 28](R/W1C/H) Received a completion with poisoned payload.
                                                                 Internal:
                                                                 radm_rcvd_cpl_poisoned. */
        uint64_t rawwpp                : 1;  /**< [ 29: 29](R/W1C/H) Received a write with poisoned payload.
                                                                 Internal:
                                                                 radm_rcvd_wreq_poisoned. */
        uint64_t ecrc_e                : 1;  /**< [ 30: 30](R/W1C/H) Received an ECRC error. */
        uint64_t lofp                  : 1;  /**< [ 31: 31](R/W1C/H) Lack of forward progress at TLP FIFOs timeout occurred. */
        uint64_t bmd_e                 : 1;  /**< [ 32: 32](R/W1C/H) A NP or P TLP was seen in the outbound path, but it was not allowed to master the bus.
                                                                 If a PF TLP and the PCIEEP()_CFG001[ME] is not set.
                                                                 For VF TLP, either the PCIEEP()_CFG001[ME]/PCIEEPVF()_CFG001[ME] are not set. */
        uint64_t p_d0_sbe              : 1;  /**< [ 33: 33](R/W1C/H) Detected a TLP posted FIFO data0 single-bit error. */
        uint64_t p_d0_dbe              : 1;  /**< [ 34: 34](R/W1C/H) Detected a TLP posted FIFO data0 double-bit error. */
        uint64_t p_d1_sbe              : 1;  /**< [ 35: 35](R/W1C/H) Detected a TLP posted FIFO data1 single-bit error. */
        uint64_t p_d1_dbe              : 1;  /**< [ 36: 36](R/W1C/H) Detected a TLP posted FIFO data1 double-bit error. */
        uint64_t p_c_sbe               : 1;  /**< [ 37: 37](R/W1C/H) Detected a TLP posted FIFO control single-bit error. */
        uint64_t p_c_dbe               : 1;  /**< [ 38: 38](R/W1C/H) Detected a TLP posted FIFO control double-bit error. */
        uint64_t n_d0_sbe              : 1;  /**< [ 39: 39](R/W1C/H) Detected a TLP NP FIFO data0 single-bit error. */
        uint64_t n_d0_dbe              : 1;  /**< [ 40: 40](R/W1C/H) Detected a TLP NP FIFO data0 double-bit error. */
        uint64_t n_d1_sbe              : 1;  /**< [ 41: 41](R/W1C/H) Detected a TLP NP FIFO data1 single-bit error. */
        uint64_t n_d1_dbe              : 1;  /**< [ 42: 42](R/W1C/H) Detected a TLP NP FIFO data1 double-bit error. */
        uint64_t n_c_sbe               : 1;  /**< [ 43: 43](R/W1C/H) Detected a TLP NP FIFO control single-bit error. */
        uint64_t n_c_dbe               : 1;  /**< [ 44: 44](R/W1C/H) Detected a TLP NP FIFO control double-bit error. */
        uint64_t c_d0_sbe              : 1;  /**< [ 45: 45](R/W1C/H) Detected a TLP CPL FIFO data0 single-bit error. */
        uint64_t c_d0_dbe              : 1;  /**< [ 46: 46](R/W1C/H) Detected a TLP CPL FIFO data0 double-bit error. */
        uint64_t c_d1_sbe              : 1;  /**< [ 47: 47](R/W1C/H) Detected a TLP CPL FIFO data1 single-bit error. */
        uint64_t c_d1_dbe              : 1;  /**< [ 48: 48](R/W1C/H) Detected a TLP CPL FIFO data1 double-bit error. */
        uint64_t c_c_sbe               : 1;  /**< [ 49: 49](R/W1C/H) Detected a TLP CPL FIFO control single-bit error. */
        uint64_t c_c_dbe               : 1;  /**< [ 50: 50](R/W1C/H) Detected a TLP CPL FIFO control double-bit error. */
        uint64_t m2s_c_sbe             : 1;  /**< [ 51: 51](R/W1C/H) Detected a M2S control fifo single bit error. */
        uint64_t m2s_c_dbe             : 1;  /**< [ 52: 52](R/W1C/H) Detected a M2S data fifo double bit error. */
        uint64_t m2s_d_sbe             : 1;  /**< [ 53: 53](R/W1C/H) Detected a M2S data fifo single bit error. */
        uint64_t m2s_d_dbe             : 1;  /**< [ 54: 54](R/W1C/H) Detected a M2S data fifo double bit error. */
        uint64_t rasdp                 : 1;  /**< [ 55: 55](R/W1C/H) Core entered RAS data protection error mode. */
        uint64_t reserved_56_63        : 8;
#endif /* Word 0 - End */
    } cn83xx;
    /* struct bdk_pemx_dbg_info_cn81xx cn88xxp2; */
};
typedef union bdk_pemx_dbg_info bdk_pemx_dbg_info_t;

static inline uint64_t BDK_PEMX_DBG_INFO(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_DBG_INFO(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN81XX) && (a<=2))
        return 0x87e0c0000448ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN83XX) && (a<=3))
        return 0x87e0c0000448ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN88XX) && (a<=5))
        return 0x87e0c0000448ll + 0x1000000ll * ((a) & 0x7);
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e00000000f8ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_DBG_INFO", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_DBG_INFO(a) bdk_pemx_dbg_info_t
#define bustype_BDK_PEMX_DBG_INFO(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_DBG_INFO(a) "PEMX_DBG_INFO"
#define device_bar_BDK_PEMX_DBG_INFO(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_DBG_INFO(a) (a)
#define arguments_BDK_PEMX_DBG_INFO(a) (a),-1,-1,-1

/**
 * Register (RSL) pem#_dbg_info_w1s
 *
 * PEM Debug Information Set Register
 * This register sets interrupt bits.
 */
union bdk_pemx_dbg_info_w1s
{
    uint64_t u;
    struct bdk_pemx_dbg_info_w1s_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_58_63        : 6;
        uint64_t m2s_pe                : 1;  /**< [ 57: 57](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[M2S_PE]. */
        uint64_t qhdr_b1_dbe           : 1;  /**< [ 56: 56](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[QHDR_B1_DBE]. */
        uint64_t reserved_51_55        : 5;
        uint64_t c_c_dbe               : 1;  /**< [ 50: 50](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[C_C_DBE]. */
        uint64_t c_c_sbe               : 1;  /**< [ 49: 49](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[C_C_SBE]. */
        uint64_t c_d1_dbe              : 1;  /**< [ 48: 48](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[C_D1_DBE]. */
        uint64_t c_d1_sbe              : 1;  /**< [ 47: 47](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[C_D1_SBE]. */
        uint64_t c_d0_dbe              : 1;  /**< [ 46: 46](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[C_D0_DBE]. */
        uint64_t c_d0_sbe              : 1;  /**< [ 45: 45](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[C_D0_SBE]. */
        uint64_t n_c_dbe               : 1;  /**< [ 44: 44](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[N_C_DBE]. */
        uint64_t n_c_sbe               : 1;  /**< [ 43: 43](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[N_C_SBE]. */
        uint64_t n_d1_dbe              : 1;  /**< [ 42: 42](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[N_D1_DBE]. */
        uint64_t n_d1_sbe              : 1;  /**< [ 41: 41](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[N_D1_SBE]. */
        uint64_t n_d0_dbe              : 1;  /**< [ 40: 40](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[N_D0_DBE]. */
        uint64_t n_d0_sbe              : 1;  /**< [ 39: 39](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[N_D0_SBE]. */
        uint64_t p_c_dbe               : 1;  /**< [ 38: 38](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[P_C_DBE]. */
        uint64_t p_c_sbe               : 1;  /**< [ 37: 37](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[P_C_SBE]. */
        uint64_t p_d1_dbe              : 1;  /**< [ 36: 36](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[P_D1_DBE]. */
        uint64_t p_d1_sbe              : 1;  /**< [ 35: 35](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[P_D1_SBE]. */
        uint64_t p_d0_dbe              : 1;  /**< [ 34: 34](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[P_D0_DBE]. */
        uint64_t p_d0_sbe              : 1;  /**< [ 33: 33](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[P_D0_SBE]. */
        uint64_t reserved_32           : 1;
        uint64_t lofp                  : 1;  /**< [ 31: 31](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[LOFP]. */
        uint64_t ecrc_e                : 1;  /**< [ 30: 30](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[ECRC_E]. */
        uint64_t rawwpp                : 1;  /**< [ 29: 29](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RAWWPP].
                                                                 Internal:
                                                                 radm_rcvd_wreq_poisoned. */
        uint64_t racpp                 : 1;  /**< [ 28: 28](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RACPP].
                                                                 Internal:
                                                                 radm_rcvd_cpl_poisoned. */
        uint64_t ramtlp                : 1;  /**< [ 27: 27](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RAMTLP].
                                                                 Internal:
                                                                 radm_mlf_tlp_err. */
        uint64_t rarwdns               : 1;  /**< [ 26: 26](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RARWDNS].
                                                                 Internal:
                                                                 radm_rcvd_ur_req. */
        uint64_t caar                  : 1;  /**< [ 25: 25](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[CAAR]. */
        uint64_t racca                 : 1;  /**< [ 24: 24](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RACCA].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ca. */
        uint64_t racur                 : 1;  /**< [ 23: 23](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RACUR].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ur. */
        uint64_t rauc                  : 1;  /**< [ 22: 22](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RAUC].
                                                                 Internal:
                                                                 radm_unexp_cpl_err. */
        uint64_t rqo                   : 1;  /**< [ 21: 21](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RQO].
                                                                 Internal:
                                                                 radm_qoverflow. */
        uint64_t fcuv                  : 1;  /**< [ 20: 20](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[FCUV].
                                                                 Internal:
                                                                 (opt. checks) int_xadm_fc_prot_err. */
        uint64_t rpe                   : 1;  /**< [ 19: 19](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RPE].
                                                                 Internal:
                                                                 rmlh_rcvd_err. */
        uint64_t fcpvwt                : 1;  /**< [ 18: 18](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[FCPVWT].
                                                                 Internal:
                                                                 rtlh_fc_prot_err. */
        uint64_t dpeoosd               : 1;  /**< [ 17: 17](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[DPEOOSD].
                                                                 Internal:
                                                                 rdlh_prot_err. */
        uint64_t rtwdle                : 1;  /**< [ 16: 16](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RTWDLE].
                                                                 Internal:
                                                                 rdlh_bad_tlp_err. */
        uint64_t rdwdle                : 1;  /**< [ 15: 15](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RDWDLE].
                                                                 Internal:
                                                                 rdlh_bad_dllp_err. */
        uint64_t mre                   : 1;  /**< [ 14: 14](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[MRE].
                                                                 Internal:
                                                                 xdlh_replay_num_rlover_err. */
        uint64_t rte                   : 1;  /**< [ 13: 13](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RTE].
                                                                 Internal:
                                                                 xdlh_replay_timeout_err. */
        uint64_t acto                  : 1;  /**< [ 12: 12](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[ACTO].
                                                                 Internal:
                                                                 pedc_radm_cpl_timeout. */
        uint64_t rvdm                  : 1;  /**< [ 11: 11](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RVDM].
                                                                 Internal:
                                                                 pedc_radm_vendor_msg. */
        uint64_t rumep                 : 1;  /**< [ 10: 10](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RUMEP].
                                                                 Internal:
                                                                 pedc_radm_msg_unlock. */
        uint64_t rptamrc               : 1;  /**< [  9:  9](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RPTAMRC].
                                                                 Internal:
                                                                 pedc_radm_pm_to_ack. */
        uint64_t rpmerc                : 1;  /**< [  8:  8](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RPMERC].
                                                                 Internal:
                                                                 pedc_radm_pm_pme. */
        uint64_t rfemrc                : 1;  /**< [  7:  7](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RFEMRC].
                                                                 Internal:
                                                                 pedc_radm_fatal_err. */
        uint64_t rnfemrc               : 1;  /**< [  6:  6](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RNFEMRC].
                                                                 Internal:
                                                                 pedc_radm_nonfatal_err. */
        uint64_t rcemrc                : 1;  /**< [  5:  5](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RCEMRC].
                                                                 Internal:
                                                                 pedc_radm_correctable_err. */
        uint64_t rpoison               : 1;  /**< [  4:  4](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RPOISON].
                                                                 Internal:
                                                                 pedc__radm_trgt1_poisoned & pedc__radm_trgt1_hv. */
        uint64_t recrce                : 1;  /**< [  3:  3](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RECRCE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_ecrc_err & pedc__radm_trgt1_eot. */
        uint64_t rtlplle               : 1;  /**< [  2:  2](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RTLPLLE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_dllp_abort &
                                                                 pedc__radm_trgt1_eot. */
        uint64_t rtlpmal               : 1;  /**< [  1:  1](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RTLPMAL].
                                                                 Internal:
                                                                 pedc_radm_trgt1_tlp_abort & pedc__radm_trgt1_eot. */
        uint64_t spoison               : 1;  /**< [  0:  0](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[SPOISON].
                                                                 Internal:
                                                                 peai__client0_tlp_ep & peai__client0_tlp_hv or
                                                                 peai__client1_tlp_ep & peai__client1_tlp_hv (atomic_op). */
#else /* Word 0 - Little Endian */
        uint64_t spoison               : 1;  /**< [  0:  0](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[SPOISON].
                                                                 Internal:
                                                                 peai__client0_tlp_ep & peai__client0_tlp_hv or
                                                                 peai__client1_tlp_ep & peai__client1_tlp_hv (atomic_op). */
        uint64_t rtlpmal               : 1;  /**< [  1:  1](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RTLPMAL].
                                                                 Internal:
                                                                 pedc_radm_trgt1_tlp_abort & pedc__radm_trgt1_eot. */
        uint64_t rtlplle               : 1;  /**< [  2:  2](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RTLPLLE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_dllp_abort &
                                                                 pedc__radm_trgt1_eot. */
        uint64_t recrce                : 1;  /**< [  3:  3](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RECRCE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_ecrc_err & pedc__radm_trgt1_eot. */
        uint64_t rpoison               : 1;  /**< [  4:  4](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RPOISON].
                                                                 Internal:
                                                                 pedc__radm_trgt1_poisoned & pedc__radm_trgt1_hv. */
        uint64_t rcemrc                : 1;  /**< [  5:  5](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RCEMRC].
                                                                 Internal:
                                                                 pedc_radm_correctable_err. */
        uint64_t rnfemrc               : 1;  /**< [  6:  6](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RNFEMRC].
                                                                 Internal:
                                                                 pedc_radm_nonfatal_err. */
        uint64_t rfemrc                : 1;  /**< [  7:  7](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RFEMRC].
                                                                 Internal:
                                                                 pedc_radm_fatal_err. */
        uint64_t rpmerc                : 1;  /**< [  8:  8](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RPMERC].
                                                                 Internal:
                                                                 pedc_radm_pm_pme. */
        uint64_t rptamrc               : 1;  /**< [  9:  9](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RPTAMRC].
                                                                 Internal:
                                                                 pedc_radm_pm_to_ack. */
        uint64_t rumep                 : 1;  /**< [ 10: 10](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RUMEP].
                                                                 Internal:
                                                                 pedc_radm_msg_unlock. */
        uint64_t rvdm                  : 1;  /**< [ 11: 11](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RVDM].
                                                                 Internal:
                                                                 pedc_radm_vendor_msg. */
        uint64_t acto                  : 1;  /**< [ 12: 12](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[ACTO].
                                                                 Internal:
                                                                 pedc_radm_cpl_timeout. */
        uint64_t rte                   : 1;  /**< [ 13: 13](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RTE].
                                                                 Internal:
                                                                 xdlh_replay_timeout_err. */
        uint64_t mre                   : 1;  /**< [ 14: 14](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[MRE].
                                                                 Internal:
                                                                 xdlh_replay_num_rlover_err. */
        uint64_t rdwdle                : 1;  /**< [ 15: 15](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RDWDLE].
                                                                 Internal:
                                                                 rdlh_bad_dllp_err. */
        uint64_t rtwdle                : 1;  /**< [ 16: 16](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RTWDLE].
                                                                 Internal:
                                                                 rdlh_bad_tlp_err. */
        uint64_t dpeoosd               : 1;  /**< [ 17: 17](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[DPEOOSD].
                                                                 Internal:
                                                                 rdlh_prot_err. */
        uint64_t fcpvwt                : 1;  /**< [ 18: 18](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[FCPVWT].
                                                                 Internal:
                                                                 rtlh_fc_prot_err. */
        uint64_t rpe                   : 1;  /**< [ 19: 19](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RPE].
                                                                 Internal:
                                                                 rmlh_rcvd_err. */
        uint64_t fcuv                  : 1;  /**< [ 20: 20](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[FCUV].
                                                                 Internal:
                                                                 (opt. checks) int_xadm_fc_prot_err. */
        uint64_t rqo                   : 1;  /**< [ 21: 21](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RQO].
                                                                 Internal:
                                                                 radm_qoverflow. */
        uint64_t rauc                  : 1;  /**< [ 22: 22](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RAUC].
                                                                 Internal:
                                                                 radm_unexp_cpl_err. */
        uint64_t racur                 : 1;  /**< [ 23: 23](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RACUR].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ur. */
        uint64_t racca                 : 1;  /**< [ 24: 24](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RACCA].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ca. */
        uint64_t caar                  : 1;  /**< [ 25: 25](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[CAAR]. */
        uint64_t rarwdns               : 1;  /**< [ 26: 26](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RARWDNS].
                                                                 Internal:
                                                                 radm_rcvd_ur_req. */
        uint64_t ramtlp                : 1;  /**< [ 27: 27](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RAMTLP].
                                                                 Internal:
                                                                 radm_mlf_tlp_err. */
        uint64_t racpp                 : 1;  /**< [ 28: 28](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RACPP].
                                                                 Internal:
                                                                 radm_rcvd_cpl_poisoned. */
        uint64_t rawwpp                : 1;  /**< [ 29: 29](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RAWWPP].
                                                                 Internal:
                                                                 radm_rcvd_wreq_poisoned. */
        uint64_t ecrc_e                : 1;  /**< [ 30: 30](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[ECRC_E]. */
        uint64_t lofp                  : 1;  /**< [ 31: 31](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[LOFP]. */
        uint64_t reserved_32           : 1;
        uint64_t p_d0_sbe              : 1;  /**< [ 33: 33](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[P_D0_SBE]. */
        uint64_t p_d0_dbe              : 1;  /**< [ 34: 34](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[P_D0_DBE]. */
        uint64_t p_d1_sbe              : 1;  /**< [ 35: 35](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[P_D1_SBE]. */
        uint64_t p_d1_dbe              : 1;  /**< [ 36: 36](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[P_D1_DBE]. */
        uint64_t p_c_sbe               : 1;  /**< [ 37: 37](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[P_C_SBE]. */
        uint64_t p_c_dbe               : 1;  /**< [ 38: 38](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[P_C_DBE]. */
        uint64_t n_d0_sbe              : 1;  /**< [ 39: 39](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[N_D0_SBE]. */
        uint64_t n_d0_dbe              : 1;  /**< [ 40: 40](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[N_D0_DBE]. */
        uint64_t n_d1_sbe              : 1;  /**< [ 41: 41](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[N_D1_SBE]. */
        uint64_t n_d1_dbe              : 1;  /**< [ 42: 42](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[N_D1_DBE]. */
        uint64_t n_c_sbe               : 1;  /**< [ 43: 43](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[N_C_SBE]. */
        uint64_t n_c_dbe               : 1;  /**< [ 44: 44](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[N_C_DBE]. */
        uint64_t c_d0_sbe              : 1;  /**< [ 45: 45](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[C_D0_SBE]. */
        uint64_t c_d0_dbe              : 1;  /**< [ 46: 46](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[C_D0_DBE]. */
        uint64_t c_d1_sbe              : 1;  /**< [ 47: 47](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[C_D1_SBE]. */
        uint64_t c_d1_dbe              : 1;  /**< [ 48: 48](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[C_D1_DBE]. */
        uint64_t c_c_sbe               : 1;  /**< [ 49: 49](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[C_C_SBE]. */
        uint64_t c_c_dbe               : 1;  /**< [ 50: 50](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[C_C_DBE]. */
        uint64_t reserved_51_55        : 5;
        uint64_t qhdr_b1_dbe           : 1;  /**< [ 56: 56](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[QHDR_B1_DBE]. */
        uint64_t m2s_pe                : 1;  /**< [ 57: 57](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[M2S_PE]. */
        uint64_t reserved_58_63        : 6;
#endif /* Word 0 - End */
    } s;
    struct bdk_pemx_dbg_info_w1s_cn88xxp1
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_57_63        : 7;
        uint64_t qhdr_b1_dbe           : 1;  /**< [ 56: 56](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[QHDR_B1_DBE]. */
        uint64_t qhdr_b1_sbe           : 1;  /**< [ 55: 55](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[QHDR_B1_SBE]. */
        uint64_t qhdr_b0_dbe           : 1;  /**< [ 54: 54](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[QHDR_B0_DBE]. */
        uint64_t qhdr_b0_sbe           : 1;  /**< [ 53: 53](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[QHDR_B0_SBE]. */
        uint64_t rtry_dbe              : 1;  /**< [ 52: 52](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RTRY_DBE]. */
        uint64_t rtry_sbe              : 1;  /**< [ 51: 51](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RTRY_SBE]. */
        uint64_t c_c_dbe               : 1;  /**< [ 50: 50](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[C_C_DBE]. */
        uint64_t c_c_sbe               : 1;  /**< [ 49: 49](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[C_C_SBE]. */
        uint64_t c_d1_dbe              : 1;  /**< [ 48: 48](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[C_D1_DBE]. */
        uint64_t c_d1_sbe              : 1;  /**< [ 47: 47](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[C_D1_SBE]. */
        uint64_t c_d0_dbe              : 1;  /**< [ 46: 46](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[C_D0_DBE]. */
        uint64_t c_d0_sbe              : 1;  /**< [ 45: 45](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[C_D0_SBE]. */
        uint64_t n_c_dbe               : 1;  /**< [ 44: 44](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[N_C_DBE]. */
        uint64_t n_c_sbe               : 1;  /**< [ 43: 43](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[N_C_SBE]. */
        uint64_t n_d1_dbe              : 1;  /**< [ 42: 42](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[N_D1_DBE]. */
        uint64_t n_d1_sbe              : 1;  /**< [ 41: 41](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[N_D1_SBE]. */
        uint64_t n_d0_dbe              : 1;  /**< [ 40: 40](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[N_D0_DBE]. */
        uint64_t n_d0_sbe              : 1;  /**< [ 39: 39](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[N_D0_SBE]. */
        uint64_t p_c_dbe               : 1;  /**< [ 38: 38](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[P_C_DBE]. */
        uint64_t p_c_sbe               : 1;  /**< [ 37: 37](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[P_C_SBE]. */
        uint64_t p_d1_dbe              : 1;  /**< [ 36: 36](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[P_D1_DBE]. */
        uint64_t p_d1_sbe              : 1;  /**< [ 35: 35](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[P_D1_SBE]. */
        uint64_t p_d0_dbe              : 1;  /**< [ 34: 34](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[P_D0_DBE]. */
        uint64_t p_d0_sbe              : 1;  /**< [ 33: 33](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[P_D0_SBE]. */
        uint64_t datq_pe               : 1;  /**< [ 32: 32](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[DATQ_PE]. */
        uint64_t lofp                  : 1;  /**< [ 31: 31](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[LOFP]. */
        uint64_t ecrc_e                : 1;  /**< [ 30: 30](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[ECRC_E]. */
        uint64_t rawwpp                : 1;  /**< [ 29: 29](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RAWWPP].
                                                                 Internal:
                                                                 radm_rcvd_wreq_poisoned. */
        uint64_t racpp                 : 1;  /**< [ 28: 28](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RACPP].
                                                                 Internal:
                                                                 radm_rcvd_cpl_poisoned. */
        uint64_t ramtlp                : 1;  /**< [ 27: 27](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RAMTLP].
                                                                 Internal:
                                                                 radm_mlf_tlp_err. */
        uint64_t rarwdns               : 1;  /**< [ 26: 26](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RARWDNS].
                                                                 Internal:
                                                                 radm_rcvd_ur_req. */
        uint64_t caar                  : 1;  /**< [ 25: 25](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[CAAR]. */
        uint64_t racca                 : 1;  /**< [ 24: 24](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RACCA].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ca. */
        uint64_t racur                 : 1;  /**< [ 23: 23](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RACUR].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ur. */
        uint64_t rauc                  : 1;  /**< [ 22: 22](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RAUC].
                                                                 Internal:
                                                                 radm_unexp_cpl_err. */
        uint64_t rqo                   : 1;  /**< [ 21: 21](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RQO].
                                                                 Internal:
                                                                 radm_qoverflow. */
        uint64_t fcuv                  : 1;  /**< [ 20: 20](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[FCUV].
                                                                 Internal:
                                                                 (opt. checks) int_xadm_fc_prot_err. */
        uint64_t rpe                   : 1;  /**< [ 19: 19](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RPE].
                                                                 Internal:
                                                                 rmlh_rcvd_err. */
        uint64_t fcpvwt                : 1;  /**< [ 18: 18](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[FCPVWT].
                                                                 Internal:
                                                                 rtlh_fc_prot_err. */
        uint64_t dpeoosd               : 1;  /**< [ 17: 17](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[DPEOOSD].
                                                                 Internal:
                                                                 rdlh_prot_err. */
        uint64_t rtwdle                : 1;  /**< [ 16: 16](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RTWDLE].
                                                                 Internal:
                                                                 rdlh_bad_tlp_err. */
        uint64_t rdwdle                : 1;  /**< [ 15: 15](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RDWDLE].
                                                                 Internal:
                                                                 rdlh_bad_dllp_err. */
        uint64_t mre                   : 1;  /**< [ 14: 14](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[MRE].
                                                                 Internal:
                                                                 xdlh_replay_num_rlover_err. */
        uint64_t rte                   : 1;  /**< [ 13: 13](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RTE].
                                                                 Internal:
                                                                 xdlh_replay_timeout_err. */
        uint64_t acto                  : 1;  /**< [ 12: 12](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[ACTO].
                                                                 Internal:
                                                                 pedc_radm_cpl_timeout. */
        uint64_t rvdm                  : 1;  /**< [ 11: 11](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RVDM].
                                                                 Internal:
                                                                 pedc_radm_vendor_msg. */
        uint64_t reserved_10           : 1;
        uint64_t rptamrc               : 1;  /**< [  9:  9](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RPTAMRC].
                                                                 Internal:
                                                                 pedc_radm_pm_to_ack. */
        uint64_t rpmerc                : 1;  /**< [  8:  8](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RPMERC].
                                                                 Internal:
                                                                 pedc_radm_pm_pme. */
        uint64_t rfemrc                : 1;  /**< [  7:  7](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RFEMRC].
                                                                 Internal:
                                                                 pedc_radm_fatal_err. */
        uint64_t rnfemrc               : 1;  /**< [  6:  6](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RNFEMRC].
                                                                 Internal:
                                                                 pedc_radm_nonfatal_err. */
        uint64_t rcemrc                : 1;  /**< [  5:  5](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RCEMRC].
                                                                 Internal:
                                                                 pedc_radm_correctable_err. */
        uint64_t rpoison               : 1;  /**< [  4:  4](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RPOISON].
                                                                 Internal:
                                                                 pedc__radm_trgt1_poisoned & pedc__radm_trgt1_hv. */
        uint64_t recrce                : 1;  /**< [  3:  3](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RECRCE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_ecrc_err & pedc__radm_trgt1_eot. */
        uint64_t rtlplle               : 1;  /**< [  2:  2](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RTLPLLE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_dllp_abort &
                                                                 pedc__radm_trgt1_eot. */
        uint64_t rtlpmal               : 1;  /**< [  1:  1](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RTLPMAL].
                                                                 Internal:
                                                                 pedc_radm_trgt1_tlp_abort & pedc__radm_trgt1_eot. */
        uint64_t spoison               : 1;  /**< [  0:  0](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[SPOISON].
                                                                 Internal:
                                                                 peai__client0_tlp_ep & peai__client0_tlp_hv or
                                                                 peai__client1_tlp_ep & peai__client1_tlp_hv (atomic_op). */
#else /* Word 0 - Little Endian */
        uint64_t spoison               : 1;  /**< [  0:  0](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[SPOISON].
                                                                 Internal:
                                                                 peai__client0_tlp_ep & peai__client0_tlp_hv or
                                                                 peai__client1_tlp_ep & peai__client1_tlp_hv (atomic_op). */
        uint64_t rtlpmal               : 1;  /**< [  1:  1](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RTLPMAL].
                                                                 Internal:
                                                                 pedc_radm_trgt1_tlp_abort & pedc__radm_trgt1_eot. */
        uint64_t rtlplle               : 1;  /**< [  2:  2](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RTLPLLE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_dllp_abort &
                                                                 pedc__radm_trgt1_eot. */
        uint64_t recrce                : 1;  /**< [  3:  3](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RECRCE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_ecrc_err & pedc__radm_trgt1_eot. */
        uint64_t rpoison               : 1;  /**< [  4:  4](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RPOISON].
                                                                 Internal:
                                                                 pedc__radm_trgt1_poisoned & pedc__radm_trgt1_hv. */
        uint64_t rcemrc                : 1;  /**< [  5:  5](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RCEMRC].
                                                                 Internal:
                                                                 pedc_radm_correctable_err. */
        uint64_t rnfemrc               : 1;  /**< [  6:  6](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RNFEMRC].
                                                                 Internal:
                                                                 pedc_radm_nonfatal_err. */
        uint64_t rfemrc                : 1;  /**< [  7:  7](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RFEMRC].
                                                                 Internal:
                                                                 pedc_radm_fatal_err. */
        uint64_t rpmerc                : 1;  /**< [  8:  8](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RPMERC].
                                                                 Internal:
                                                                 pedc_radm_pm_pme. */
        uint64_t rptamrc               : 1;  /**< [  9:  9](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RPTAMRC].
                                                                 Internal:
                                                                 pedc_radm_pm_to_ack. */
        uint64_t reserved_10           : 1;
        uint64_t rvdm                  : 1;  /**< [ 11: 11](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RVDM].
                                                                 Internal:
                                                                 pedc_radm_vendor_msg. */
        uint64_t acto                  : 1;  /**< [ 12: 12](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[ACTO].
                                                                 Internal:
                                                                 pedc_radm_cpl_timeout. */
        uint64_t rte                   : 1;  /**< [ 13: 13](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RTE].
                                                                 Internal:
                                                                 xdlh_replay_timeout_err. */
        uint64_t mre                   : 1;  /**< [ 14: 14](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[MRE].
                                                                 Internal:
                                                                 xdlh_replay_num_rlover_err. */
        uint64_t rdwdle                : 1;  /**< [ 15: 15](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RDWDLE].
                                                                 Internal:
                                                                 rdlh_bad_dllp_err. */
        uint64_t rtwdle                : 1;  /**< [ 16: 16](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RTWDLE].
                                                                 Internal:
                                                                 rdlh_bad_tlp_err. */
        uint64_t dpeoosd               : 1;  /**< [ 17: 17](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[DPEOOSD].
                                                                 Internal:
                                                                 rdlh_prot_err. */
        uint64_t fcpvwt                : 1;  /**< [ 18: 18](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[FCPVWT].
                                                                 Internal:
                                                                 rtlh_fc_prot_err. */
        uint64_t rpe                   : 1;  /**< [ 19: 19](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RPE].
                                                                 Internal:
                                                                 rmlh_rcvd_err. */
        uint64_t fcuv                  : 1;  /**< [ 20: 20](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[FCUV].
                                                                 Internal:
                                                                 (opt. checks) int_xadm_fc_prot_err. */
        uint64_t rqo                   : 1;  /**< [ 21: 21](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RQO].
                                                                 Internal:
                                                                 radm_qoverflow. */
        uint64_t rauc                  : 1;  /**< [ 22: 22](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RAUC].
                                                                 Internal:
                                                                 radm_unexp_cpl_err. */
        uint64_t racur                 : 1;  /**< [ 23: 23](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RACUR].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ur. */
        uint64_t racca                 : 1;  /**< [ 24: 24](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RACCA].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ca. */
        uint64_t caar                  : 1;  /**< [ 25: 25](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[CAAR]. */
        uint64_t rarwdns               : 1;  /**< [ 26: 26](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RARWDNS].
                                                                 Internal:
                                                                 radm_rcvd_ur_req. */
        uint64_t ramtlp                : 1;  /**< [ 27: 27](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RAMTLP].
                                                                 Internal:
                                                                 radm_mlf_tlp_err. */
        uint64_t racpp                 : 1;  /**< [ 28: 28](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RACPP].
                                                                 Internal:
                                                                 radm_rcvd_cpl_poisoned. */
        uint64_t rawwpp                : 1;  /**< [ 29: 29](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RAWWPP].
                                                                 Internal:
                                                                 radm_rcvd_wreq_poisoned. */
        uint64_t ecrc_e                : 1;  /**< [ 30: 30](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[ECRC_E]. */
        uint64_t lofp                  : 1;  /**< [ 31: 31](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[LOFP]. */
        uint64_t datq_pe               : 1;  /**< [ 32: 32](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[DATQ_PE]. */
        uint64_t p_d0_sbe              : 1;  /**< [ 33: 33](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[P_D0_SBE]. */
        uint64_t p_d0_dbe              : 1;  /**< [ 34: 34](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[P_D0_DBE]. */
        uint64_t p_d1_sbe              : 1;  /**< [ 35: 35](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[P_D1_SBE]. */
        uint64_t p_d1_dbe              : 1;  /**< [ 36: 36](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[P_D1_DBE]. */
        uint64_t p_c_sbe               : 1;  /**< [ 37: 37](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[P_C_SBE]. */
        uint64_t p_c_dbe               : 1;  /**< [ 38: 38](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[P_C_DBE]. */
        uint64_t n_d0_sbe              : 1;  /**< [ 39: 39](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[N_D0_SBE]. */
        uint64_t n_d0_dbe              : 1;  /**< [ 40: 40](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[N_D0_DBE]. */
        uint64_t n_d1_sbe              : 1;  /**< [ 41: 41](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[N_D1_SBE]. */
        uint64_t n_d1_dbe              : 1;  /**< [ 42: 42](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[N_D1_DBE]. */
        uint64_t n_c_sbe               : 1;  /**< [ 43: 43](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[N_C_SBE]. */
        uint64_t n_c_dbe               : 1;  /**< [ 44: 44](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[N_C_DBE]. */
        uint64_t c_d0_sbe              : 1;  /**< [ 45: 45](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[C_D0_SBE]. */
        uint64_t c_d0_dbe              : 1;  /**< [ 46: 46](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[C_D0_DBE]. */
        uint64_t c_d1_sbe              : 1;  /**< [ 47: 47](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[C_D1_SBE]. */
        uint64_t c_d1_dbe              : 1;  /**< [ 48: 48](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[C_D1_DBE]. */
        uint64_t c_c_sbe               : 1;  /**< [ 49: 49](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[C_C_SBE]. */
        uint64_t c_c_dbe               : 1;  /**< [ 50: 50](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[C_C_DBE]. */
        uint64_t rtry_sbe              : 1;  /**< [ 51: 51](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RTRY_SBE]. */
        uint64_t rtry_dbe              : 1;  /**< [ 52: 52](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RTRY_DBE]. */
        uint64_t qhdr_b0_sbe           : 1;  /**< [ 53: 53](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[QHDR_B0_SBE]. */
        uint64_t qhdr_b0_dbe           : 1;  /**< [ 54: 54](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[QHDR_B0_DBE]. */
        uint64_t qhdr_b1_sbe           : 1;  /**< [ 55: 55](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[QHDR_B1_SBE]. */
        uint64_t qhdr_b1_dbe           : 1;  /**< [ 56: 56](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[QHDR_B1_DBE]. */
        uint64_t reserved_57_63        : 7;
#endif /* Word 0 - End */
    } cn88xxp1;
    struct bdk_pemx_dbg_info_w1s_cn81xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_58_63        : 6;
        uint64_t m2s_pe                : 1;  /**< [ 57: 57](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[M2S_PE]. */
        uint64_t qhdr_b1_dbe           : 1;  /**< [ 56: 56](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[QHDR_B1_DBE]. */
        uint64_t qhdr_b1_sbe           : 1;  /**< [ 55: 55](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[QHDR_B1_SBE]. */
        uint64_t qhdr_b0_dbe           : 1;  /**< [ 54: 54](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[QHDR_B0_DBE]. */
        uint64_t qhdr_b0_sbe           : 1;  /**< [ 53: 53](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[QHDR_B0_SBE]. */
        uint64_t rtry_dbe              : 1;  /**< [ 52: 52](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RTRY_DBE]. */
        uint64_t rtry_sbe              : 1;  /**< [ 51: 51](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RTRY_SBE]. */
        uint64_t c_c_dbe               : 1;  /**< [ 50: 50](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[C_C_DBE]. */
        uint64_t c_c_sbe               : 1;  /**< [ 49: 49](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[C_C_SBE]. */
        uint64_t c_d1_dbe              : 1;  /**< [ 48: 48](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[C_D1_DBE]. */
        uint64_t c_d1_sbe              : 1;  /**< [ 47: 47](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[C_D1_SBE]. */
        uint64_t c_d0_dbe              : 1;  /**< [ 46: 46](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[C_D0_DBE]. */
        uint64_t c_d0_sbe              : 1;  /**< [ 45: 45](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[C_D0_SBE]. */
        uint64_t n_c_dbe               : 1;  /**< [ 44: 44](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[N_C_DBE]. */
        uint64_t n_c_sbe               : 1;  /**< [ 43: 43](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[N_C_SBE]. */
        uint64_t n_d1_dbe              : 1;  /**< [ 42: 42](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[N_D1_DBE]. */
        uint64_t n_d1_sbe              : 1;  /**< [ 41: 41](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[N_D1_SBE]. */
        uint64_t n_d0_dbe              : 1;  /**< [ 40: 40](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[N_D0_DBE]. */
        uint64_t n_d0_sbe              : 1;  /**< [ 39: 39](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[N_D0_SBE]. */
        uint64_t p_c_dbe               : 1;  /**< [ 38: 38](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[P_C_DBE]. */
        uint64_t p_c_sbe               : 1;  /**< [ 37: 37](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[P_C_SBE]. */
        uint64_t p_d1_dbe              : 1;  /**< [ 36: 36](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[P_D1_DBE]. */
        uint64_t p_d1_sbe              : 1;  /**< [ 35: 35](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[P_D1_SBE]. */
        uint64_t p_d0_dbe              : 1;  /**< [ 34: 34](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[P_D0_DBE]. */
        uint64_t p_d0_sbe              : 1;  /**< [ 33: 33](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[P_D0_SBE]. */
        uint64_t datq_pe               : 1;  /**< [ 32: 32](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[DATQ_PE]. */
        uint64_t lofp                  : 1;  /**< [ 31: 31](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[LOFP]. */
        uint64_t ecrc_e                : 1;  /**< [ 30: 30](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[ECRC_E]. */
        uint64_t rawwpp                : 1;  /**< [ 29: 29](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RAWWPP].
                                                                 Internal:
                                                                 radm_rcvd_wreq_poisoned. */
        uint64_t racpp                 : 1;  /**< [ 28: 28](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RACPP].
                                                                 Internal:
                                                                 radm_rcvd_cpl_poisoned. */
        uint64_t ramtlp                : 1;  /**< [ 27: 27](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RAMTLP].
                                                                 Internal:
                                                                 radm_mlf_tlp_err. */
        uint64_t rarwdns               : 1;  /**< [ 26: 26](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RARWDNS].
                                                                 Internal:
                                                                 radm_rcvd_ur_req. */
        uint64_t caar                  : 1;  /**< [ 25: 25](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[CAAR]. */
        uint64_t racca                 : 1;  /**< [ 24: 24](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RACCA].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ca. */
        uint64_t racur                 : 1;  /**< [ 23: 23](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RACUR].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ur. */
        uint64_t rauc                  : 1;  /**< [ 22: 22](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RAUC].
                                                                 Internal:
                                                                 radm_unexp_cpl_err. */
        uint64_t rqo                   : 1;  /**< [ 21: 21](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RQO].
                                                                 Internal:
                                                                 radm_qoverflow. */
        uint64_t fcuv                  : 1;  /**< [ 20: 20](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[FCUV].
                                                                 Internal:
                                                                 (opt. checks) int_xadm_fc_prot_err. */
        uint64_t rpe                   : 1;  /**< [ 19: 19](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RPE].
                                                                 Internal:
                                                                 rmlh_rcvd_err. */
        uint64_t fcpvwt                : 1;  /**< [ 18: 18](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[FCPVWT].
                                                                 Internal:
                                                                 rtlh_fc_prot_err. */
        uint64_t dpeoosd               : 1;  /**< [ 17: 17](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[DPEOOSD].
                                                                 Internal:
                                                                 rdlh_prot_err. */
        uint64_t rtwdle                : 1;  /**< [ 16: 16](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RTWDLE].
                                                                 Internal:
                                                                 rdlh_bad_tlp_err. */
        uint64_t rdwdle                : 1;  /**< [ 15: 15](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RDWDLE].
                                                                 Internal:
                                                                 rdlh_bad_dllp_err. */
        uint64_t mre                   : 1;  /**< [ 14: 14](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[MRE].
                                                                 Internal:
                                                                 xdlh_replay_num_rlover_err. */
        uint64_t rte                   : 1;  /**< [ 13: 13](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RTE].
                                                                 Internal:
                                                                 xdlh_replay_timeout_err. */
        uint64_t acto                  : 1;  /**< [ 12: 12](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[ACTO].
                                                                 Internal:
                                                                 pedc_radm_cpl_timeout. */
        uint64_t rvdm                  : 1;  /**< [ 11: 11](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RVDM].
                                                                 Internal:
                                                                 pedc_radm_vendor_msg. */
        uint64_t reserved_10           : 1;
        uint64_t rptamrc               : 1;  /**< [  9:  9](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RPTAMRC].
                                                                 Internal:
                                                                 pedc_radm_pm_to_ack. */
        uint64_t rpmerc                : 1;  /**< [  8:  8](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RPMERC].
                                                                 Internal:
                                                                 pedc_radm_pm_pme. */
        uint64_t rfemrc                : 1;  /**< [  7:  7](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RFEMRC].
                                                                 Internal:
                                                                 pedc_radm_fatal_err. */
        uint64_t rnfemrc               : 1;  /**< [  6:  6](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RNFEMRC].
                                                                 Internal:
                                                                 pedc_radm_nonfatal_err. */
        uint64_t rcemrc                : 1;  /**< [  5:  5](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RCEMRC].
                                                                 Internal:
                                                                 pedc_radm_correctable_err. */
        uint64_t rpoison               : 1;  /**< [  4:  4](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RPOISON].
                                                                 Internal:
                                                                 pedc__radm_trgt1_poisoned & pedc__radm_trgt1_hv. */
        uint64_t recrce                : 1;  /**< [  3:  3](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RECRCE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_ecrc_err & pedc__radm_trgt1_eot. */
        uint64_t rtlplle               : 1;  /**< [  2:  2](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RTLPLLE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_dllp_abort &
                                                                 pedc__radm_trgt1_eot. */
        uint64_t rtlpmal               : 1;  /**< [  1:  1](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RTLPMAL].
                                                                 Internal:
                                                                 pedc_radm_trgt1_tlp_abort & pedc__radm_trgt1_eot. */
        uint64_t spoison               : 1;  /**< [  0:  0](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[SPOISON].
                                                                 Internal:
                                                                 peai__client0_tlp_ep & peai__client0_tlp_hv or
                                                                 peai__client1_tlp_ep & peai__client1_tlp_hv (atomic_op). */
#else /* Word 0 - Little Endian */
        uint64_t spoison               : 1;  /**< [  0:  0](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[SPOISON].
                                                                 Internal:
                                                                 peai__client0_tlp_ep & peai__client0_tlp_hv or
                                                                 peai__client1_tlp_ep & peai__client1_tlp_hv (atomic_op). */
        uint64_t rtlpmal               : 1;  /**< [  1:  1](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RTLPMAL].
                                                                 Internal:
                                                                 pedc_radm_trgt1_tlp_abort & pedc__radm_trgt1_eot. */
        uint64_t rtlplle               : 1;  /**< [  2:  2](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RTLPLLE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_dllp_abort &
                                                                 pedc__radm_trgt1_eot. */
        uint64_t recrce                : 1;  /**< [  3:  3](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RECRCE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_ecrc_err & pedc__radm_trgt1_eot. */
        uint64_t rpoison               : 1;  /**< [  4:  4](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RPOISON].
                                                                 Internal:
                                                                 pedc__radm_trgt1_poisoned & pedc__radm_trgt1_hv. */
        uint64_t rcemrc                : 1;  /**< [  5:  5](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RCEMRC].
                                                                 Internal:
                                                                 pedc_radm_correctable_err. */
        uint64_t rnfemrc               : 1;  /**< [  6:  6](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RNFEMRC].
                                                                 Internal:
                                                                 pedc_radm_nonfatal_err. */
        uint64_t rfemrc                : 1;  /**< [  7:  7](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RFEMRC].
                                                                 Internal:
                                                                 pedc_radm_fatal_err. */
        uint64_t rpmerc                : 1;  /**< [  8:  8](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RPMERC].
                                                                 Internal:
                                                                 pedc_radm_pm_pme. */
        uint64_t rptamrc               : 1;  /**< [  9:  9](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RPTAMRC].
                                                                 Internal:
                                                                 pedc_radm_pm_to_ack. */
        uint64_t reserved_10           : 1;
        uint64_t rvdm                  : 1;  /**< [ 11: 11](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RVDM].
                                                                 Internal:
                                                                 pedc_radm_vendor_msg. */
        uint64_t acto                  : 1;  /**< [ 12: 12](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[ACTO].
                                                                 Internal:
                                                                 pedc_radm_cpl_timeout. */
        uint64_t rte                   : 1;  /**< [ 13: 13](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RTE].
                                                                 Internal:
                                                                 xdlh_replay_timeout_err. */
        uint64_t mre                   : 1;  /**< [ 14: 14](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[MRE].
                                                                 Internal:
                                                                 xdlh_replay_num_rlover_err. */
        uint64_t rdwdle                : 1;  /**< [ 15: 15](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RDWDLE].
                                                                 Internal:
                                                                 rdlh_bad_dllp_err. */
        uint64_t rtwdle                : 1;  /**< [ 16: 16](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RTWDLE].
                                                                 Internal:
                                                                 rdlh_bad_tlp_err. */
        uint64_t dpeoosd               : 1;  /**< [ 17: 17](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[DPEOOSD].
                                                                 Internal:
                                                                 rdlh_prot_err. */
        uint64_t fcpvwt                : 1;  /**< [ 18: 18](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[FCPVWT].
                                                                 Internal:
                                                                 rtlh_fc_prot_err. */
        uint64_t rpe                   : 1;  /**< [ 19: 19](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RPE].
                                                                 Internal:
                                                                 rmlh_rcvd_err. */
        uint64_t fcuv                  : 1;  /**< [ 20: 20](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[FCUV].
                                                                 Internal:
                                                                 (opt. checks) int_xadm_fc_prot_err. */
        uint64_t rqo                   : 1;  /**< [ 21: 21](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RQO].
                                                                 Internal:
                                                                 radm_qoverflow. */
        uint64_t rauc                  : 1;  /**< [ 22: 22](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RAUC].
                                                                 Internal:
                                                                 radm_unexp_cpl_err. */
        uint64_t racur                 : 1;  /**< [ 23: 23](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RACUR].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ur. */
        uint64_t racca                 : 1;  /**< [ 24: 24](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RACCA].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ca. */
        uint64_t caar                  : 1;  /**< [ 25: 25](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[CAAR]. */
        uint64_t rarwdns               : 1;  /**< [ 26: 26](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RARWDNS].
                                                                 Internal:
                                                                 radm_rcvd_ur_req. */
        uint64_t ramtlp                : 1;  /**< [ 27: 27](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RAMTLP].
                                                                 Internal:
                                                                 radm_mlf_tlp_err. */
        uint64_t racpp                 : 1;  /**< [ 28: 28](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RACPP].
                                                                 Internal:
                                                                 radm_rcvd_cpl_poisoned. */
        uint64_t rawwpp                : 1;  /**< [ 29: 29](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RAWWPP].
                                                                 Internal:
                                                                 radm_rcvd_wreq_poisoned. */
        uint64_t ecrc_e                : 1;  /**< [ 30: 30](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[ECRC_E]. */
        uint64_t lofp                  : 1;  /**< [ 31: 31](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[LOFP]. */
        uint64_t datq_pe               : 1;  /**< [ 32: 32](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[DATQ_PE]. */
        uint64_t p_d0_sbe              : 1;  /**< [ 33: 33](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[P_D0_SBE]. */
        uint64_t p_d0_dbe              : 1;  /**< [ 34: 34](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[P_D0_DBE]. */
        uint64_t p_d1_sbe              : 1;  /**< [ 35: 35](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[P_D1_SBE]. */
        uint64_t p_d1_dbe              : 1;  /**< [ 36: 36](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[P_D1_DBE]. */
        uint64_t p_c_sbe               : 1;  /**< [ 37: 37](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[P_C_SBE]. */
        uint64_t p_c_dbe               : 1;  /**< [ 38: 38](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[P_C_DBE]. */
        uint64_t n_d0_sbe              : 1;  /**< [ 39: 39](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[N_D0_SBE]. */
        uint64_t n_d0_dbe              : 1;  /**< [ 40: 40](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[N_D0_DBE]. */
        uint64_t n_d1_sbe              : 1;  /**< [ 41: 41](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[N_D1_SBE]. */
        uint64_t n_d1_dbe              : 1;  /**< [ 42: 42](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[N_D1_DBE]. */
        uint64_t n_c_sbe               : 1;  /**< [ 43: 43](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[N_C_SBE]. */
        uint64_t n_c_dbe               : 1;  /**< [ 44: 44](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[N_C_DBE]. */
        uint64_t c_d0_sbe              : 1;  /**< [ 45: 45](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[C_D0_SBE]. */
        uint64_t c_d0_dbe              : 1;  /**< [ 46: 46](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[C_D0_DBE]. */
        uint64_t c_d1_sbe              : 1;  /**< [ 47: 47](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[C_D1_SBE]. */
        uint64_t c_d1_dbe              : 1;  /**< [ 48: 48](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[C_D1_DBE]. */
        uint64_t c_c_sbe               : 1;  /**< [ 49: 49](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[C_C_SBE]. */
        uint64_t c_c_dbe               : 1;  /**< [ 50: 50](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[C_C_DBE]. */
        uint64_t rtry_sbe              : 1;  /**< [ 51: 51](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RTRY_SBE]. */
        uint64_t rtry_dbe              : 1;  /**< [ 52: 52](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[RTRY_DBE]. */
        uint64_t qhdr_b0_sbe           : 1;  /**< [ 53: 53](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[QHDR_B0_SBE]. */
        uint64_t qhdr_b0_dbe           : 1;  /**< [ 54: 54](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[QHDR_B0_DBE]. */
        uint64_t qhdr_b1_sbe           : 1;  /**< [ 55: 55](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[QHDR_B1_SBE]. */
        uint64_t qhdr_b1_dbe           : 1;  /**< [ 56: 56](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[QHDR_B1_DBE]. */
        uint64_t m2s_pe                : 1;  /**< [ 57: 57](R/W1S/H) Reads or sets PEM(0..2)_DBG_INFO[M2S_PE]. */
        uint64_t reserved_58_63        : 6;
#endif /* Word 0 - End */
    } cn81xx;
    struct bdk_pemx_dbg_info_w1s_cn83xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_56_63        : 8;
        uint64_t rasdp                 : 1;  /**< [ 55: 55](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RASDP]. */
        uint64_t m2s_d_dbe             : 1;  /**< [ 54: 54](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[M2S_D_DBE]. */
        uint64_t m2s_d_sbe             : 1;  /**< [ 53: 53](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[M2S_D_SBE]. */
        uint64_t m2s_c_dbe             : 1;  /**< [ 52: 52](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[M2S_C_DBE]. */
        uint64_t m2s_c_sbe             : 1;  /**< [ 51: 51](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[M2S_C_SBE]. */
        uint64_t c_c_dbe               : 1;  /**< [ 50: 50](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[C_C_DBE]. */
        uint64_t c_c_sbe               : 1;  /**< [ 49: 49](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[C_C_SBE]. */
        uint64_t c_d1_dbe              : 1;  /**< [ 48: 48](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[C_D1_DBE]. */
        uint64_t c_d1_sbe              : 1;  /**< [ 47: 47](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[C_D1_SBE]. */
        uint64_t c_d0_dbe              : 1;  /**< [ 46: 46](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[C_D0_DBE]. */
        uint64_t c_d0_sbe              : 1;  /**< [ 45: 45](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[C_D0_SBE]. */
        uint64_t n_c_dbe               : 1;  /**< [ 44: 44](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[N_C_DBE]. */
        uint64_t n_c_sbe               : 1;  /**< [ 43: 43](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[N_C_SBE]. */
        uint64_t n_d1_dbe              : 1;  /**< [ 42: 42](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[N_D1_DBE]. */
        uint64_t n_d1_sbe              : 1;  /**< [ 41: 41](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[N_D1_SBE]. */
        uint64_t n_d0_dbe              : 1;  /**< [ 40: 40](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[N_D0_DBE]. */
        uint64_t n_d0_sbe              : 1;  /**< [ 39: 39](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[N_D0_SBE]. */
        uint64_t p_c_dbe               : 1;  /**< [ 38: 38](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[P_C_DBE]. */
        uint64_t p_c_sbe               : 1;  /**< [ 37: 37](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[P_C_SBE]. */
        uint64_t p_d1_dbe              : 1;  /**< [ 36: 36](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[P_D1_DBE]. */
        uint64_t p_d1_sbe              : 1;  /**< [ 35: 35](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[P_D1_SBE]. */
        uint64_t p_d0_dbe              : 1;  /**< [ 34: 34](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[P_D0_DBE]. */
        uint64_t p_d0_sbe              : 1;  /**< [ 33: 33](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[P_D0_SBE]. */
        uint64_t bmd_e                 : 1;  /**< [ 32: 32](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[BMD_E]. */
        uint64_t lofp                  : 1;  /**< [ 31: 31](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[LOFP]. */
        uint64_t ecrc_e                : 1;  /**< [ 30: 30](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[ECRC_E]. */
        uint64_t rawwpp                : 1;  /**< [ 29: 29](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RAWWPP].
                                                                 Internal:
                                                                 radm_rcvd_wreq_poisoned. */
        uint64_t racpp                 : 1;  /**< [ 28: 28](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RACPP].
                                                                 Internal:
                                                                 radm_rcvd_cpl_poisoned. */
        uint64_t ramtlp                : 1;  /**< [ 27: 27](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RAMTLP].
                                                                 Internal:
                                                                 radm_mlf_tlp_err. */
        uint64_t rarwdns               : 1;  /**< [ 26: 26](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RARWDNS].
                                                                 Internal:
                                                                 radm_rcvd_ur_req. */
        uint64_t caar                  : 1;  /**< [ 25: 25](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[CAAR]. */
        uint64_t racca                 : 1;  /**< [ 24: 24](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RACCA].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ca. */
        uint64_t racur                 : 1;  /**< [ 23: 23](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RACUR].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ur. */
        uint64_t rauc                  : 1;  /**< [ 22: 22](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RAUC].
                                                                 Internal:
                                                                 radm_unexp_cpl_err. */
        uint64_t rqo                   : 1;  /**< [ 21: 21](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RQO].
                                                                 Internal:
                                                                 radm_qoverflow. */
        uint64_t fcuv                  : 1;  /**< [ 20: 20](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[FCUV].
                                                                 Internal:
                                                                 (opt. checks) int_xadm_fc_prot_err. */
        uint64_t rpe                   : 1;  /**< [ 19: 19](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RPE].
                                                                 Internal:
                                                                 rmlh_rcvd_err. */
        uint64_t fcpvwt                : 1;  /**< [ 18: 18](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[FCPVWT].
                                                                 Internal:
                                                                 rtlh_fc_prot_err. */
        uint64_t dpeoosd               : 1;  /**< [ 17: 17](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[DPEOOSD].
                                                                 Internal:
                                                                 rdlh_prot_err. */
        uint64_t rtwdle                : 1;  /**< [ 16: 16](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RTWDLE].
                                                                 Internal:
                                                                 rdlh_bad_tlp_err. */
        uint64_t rdwdle                : 1;  /**< [ 15: 15](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RDWDLE].
                                                                 Internal:
                                                                 rdlh_bad_dllp_err. */
        uint64_t mre                   : 1;  /**< [ 14: 14](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[MRE].
                                                                 Internal:
                                                                 xdlh_replay_num_rlover_err. */
        uint64_t rte                   : 1;  /**< [ 13: 13](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RTE].
                                                                 Internal:
                                                                 xdlh_replay_timeout_err. */
        uint64_t acto                  : 1;  /**< [ 12: 12](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[ACTO].
                                                                 Internal:
                                                                 pedc_radm_cpl_timeout. */
        uint64_t rvdm                  : 1;  /**< [ 11: 11](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RVDM].
                                                                 Internal:
                                                                 pedc_radm_vendor_msg. */
        uint64_t rumep                 : 1;  /**< [ 10: 10](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RUMEP].
                                                                 Internal:
                                                                 pedc_radm_msg_unlock. */
        uint64_t rptamrc               : 1;  /**< [  9:  9](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RPTAMRC].
                                                                 Internal:
                                                                 pedc_radm_pm_to_ack. */
        uint64_t rpmerc                : 1;  /**< [  8:  8](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RPMERC].
                                                                 Internal:
                                                                 pedc_radm_pm_pme. */
        uint64_t rfemrc                : 1;  /**< [  7:  7](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RFEMRC].
                                                                 Internal:
                                                                 pedc_radm_fatal_err. */
        uint64_t rnfemrc               : 1;  /**< [  6:  6](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RNFEMRC].
                                                                 Internal:
                                                                 pedc_radm_nonfatal_err. */
        uint64_t rcemrc                : 1;  /**< [  5:  5](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RCEMRC].
                                                                 Internal:
                                                                 pedc_radm_correctable_err. */
        uint64_t rpoison               : 1;  /**< [  4:  4](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RPOISON].
                                                                 Internal:
                                                                 pedc__radm_trgt1_poisoned & pedc__radm_trgt1_hv. */
        uint64_t recrce                : 1;  /**< [  3:  3](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RECRCE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_ecrc_err & pedc__radm_trgt1_eot. */
        uint64_t rtlplle               : 1;  /**< [  2:  2](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RTLPLLE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_dllp_abort &
                                                                 pedc__radm_trgt1_eot. */
        uint64_t rtlpmal               : 1;  /**< [  1:  1](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RTLPMAL].
                                                                 Internal:
                                                                 pedc_radm_trgt1_tlp_abort & pedc__radm_trgt1_eot. */
        uint64_t spoison               : 1;  /**< [  0:  0](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[SPOISON]. */
#else /* Word 0 - Little Endian */
        uint64_t spoison               : 1;  /**< [  0:  0](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[SPOISON]. */
        uint64_t rtlpmal               : 1;  /**< [  1:  1](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RTLPMAL].
                                                                 Internal:
                                                                 pedc_radm_trgt1_tlp_abort & pedc__radm_trgt1_eot. */
        uint64_t rtlplle               : 1;  /**< [  2:  2](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RTLPLLE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_dllp_abort &
                                                                 pedc__radm_trgt1_eot. */
        uint64_t recrce                : 1;  /**< [  3:  3](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RECRCE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_ecrc_err & pedc__radm_trgt1_eot. */
        uint64_t rpoison               : 1;  /**< [  4:  4](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RPOISON].
                                                                 Internal:
                                                                 pedc__radm_trgt1_poisoned & pedc__radm_trgt1_hv. */
        uint64_t rcemrc                : 1;  /**< [  5:  5](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RCEMRC].
                                                                 Internal:
                                                                 pedc_radm_correctable_err. */
        uint64_t rnfemrc               : 1;  /**< [  6:  6](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RNFEMRC].
                                                                 Internal:
                                                                 pedc_radm_nonfatal_err. */
        uint64_t rfemrc                : 1;  /**< [  7:  7](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RFEMRC].
                                                                 Internal:
                                                                 pedc_radm_fatal_err. */
        uint64_t rpmerc                : 1;  /**< [  8:  8](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RPMERC].
                                                                 Internal:
                                                                 pedc_radm_pm_pme. */
        uint64_t rptamrc               : 1;  /**< [  9:  9](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RPTAMRC].
                                                                 Internal:
                                                                 pedc_radm_pm_to_ack. */
        uint64_t rumep                 : 1;  /**< [ 10: 10](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RUMEP].
                                                                 Internal:
                                                                 pedc_radm_msg_unlock. */
        uint64_t rvdm                  : 1;  /**< [ 11: 11](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RVDM].
                                                                 Internal:
                                                                 pedc_radm_vendor_msg. */
        uint64_t acto                  : 1;  /**< [ 12: 12](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[ACTO].
                                                                 Internal:
                                                                 pedc_radm_cpl_timeout. */
        uint64_t rte                   : 1;  /**< [ 13: 13](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RTE].
                                                                 Internal:
                                                                 xdlh_replay_timeout_err. */
        uint64_t mre                   : 1;  /**< [ 14: 14](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[MRE].
                                                                 Internal:
                                                                 xdlh_replay_num_rlover_err. */
        uint64_t rdwdle                : 1;  /**< [ 15: 15](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RDWDLE].
                                                                 Internal:
                                                                 rdlh_bad_dllp_err. */
        uint64_t rtwdle                : 1;  /**< [ 16: 16](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RTWDLE].
                                                                 Internal:
                                                                 rdlh_bad_tlp_err. */
        uint64_t dpeoosd               : 1;  /**< [ 17: 17](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[DPEOOSD].
                                                                 Internal:
                                                                 rdlh_prot_err. */
        uint64_t fcpvwt                : 1;  /**< [ 18: 18](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[FCPVWT].
                                                                 Internal:
                                                                 rtlh_fc_prot_err. */
        uint64_t rpe                   : 1;  /**< [ 19: 19](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RPE].
                                                                 Internal:
                                                                 rmlh_rcvd_err. */
        uint64_t fcuv                  : 1;  /**< [ 20: 20](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[FCUV].
                                                                 Internal:
                                                                 (opt. checks) int_xadm_fc_prot_err. */
        uint64_t rqo                   : 1;  /**< [ 21: 21](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RQO].
                                                                 Internal:
                                                                 radm_qoverflow. */
        uint64_t rauc                  : 1;  /**< [ 22: 22](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RAUC].
                                                                 Internal:
                                                                 radm_unexp_cpl_err. */
        uint64_t racur                 : 1;  /**< [ 23: 23](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RACUR].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ur. */
        uint64_t racca                 : 1;  /**< [ 24: 24](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RACCA].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ca. */
        uint64_t caar                  : 1;  /**< [ 25: 25](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[CAAR]. */
        uint64_t rarwdns               : 1;  /**< [ 26: 26](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RARWDNS].
                                                                 Internal:
                                                                 radm_rcvd_ur_req. */
        uint64_t ramtlp                : 1;  /**< [ 27: 27](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RAMTLP].
                                                                 Internal:
                                                                 radm_mlf_tlp_err. */
        uint64_t racpp                 : 1;  /**< [ 28: 28](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RACPP].
                                                                 Internal:
                                                                 radm_rcvd_cpl_poisoned. */
        uint64_t rawwpp                : 1;  /**< [ 29: 29](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RAWWPP].
                                                                 Internal:
                                                                 radm_rcvd_wreq_poisoned. */
        uint64_t ecrc_e                : 1;  /**< [ 30: 30](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[ECRC_E]. */
        uint64_t lofp                  : 1;  /**< [ 31: 31](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[LOFP]. */
        uint64_t bmd_e                 : 1;  /**< [ 32: 32](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[BMD_E]. */
        uint64_t p_d0_sbe              : 1;  /**< [ 33: 33](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[P_D0_SBE]. */
        uint64_t p_d0_dbe              : 1;  /**< [ 34: 34](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[P_D0_DBE]. */
        uint64_t p_d1_sbe              : 1;  /**< [ 35: 35](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[P_D1_SBE]. */
        uint64_t p_d1_dbe              : 1;  /**< [ 36: 36](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[P_D1_DBE]. */
        uint64_t p_c_sbe               : 1;  /**< [ 37: 37](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[P_C_SBE]. */
        uint64_t p_c_dbe               : 1;  /**< [ 38: 38](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[P_C_DBE]. */
        uint64_t n_d0_sbe              : 1;  /**< [ 39: 39](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[N_D0_SBE]. */
        uint64_t n_d0_dbe              : 1;  /**< [ 40: 40](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[N_D0_DBE]. */
        uint64_t n_d1_sbe              : 1;  /**< [ 41: 41](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[N_D1_SBE]. */
        uint64_t n_d1_dbe              : 1;  /**< [ 42: 42](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[N_D1_DBE]. */
        uint64_t n_c_sbe               : 1;  /**< [ 43: 43](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[N_C_SBE]. */
        uint64_t n_c_dbe               : 1;  /**< [ 44: 44](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[N_C_DBE]. */
        uint64_t c_d0_sbe              : 1;  /**< [ 45: 45](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[C_D0_SBE]. */
        uint64_t c_d0_dbe              : 1;  /**< [ 46: 46](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[C_D0_DBE]. */
        uint64_t c_d1_sbe              : 1;  /**< [ 47: 47](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[C_D1_SBE]. */
        uint64_t c_d1_dbe              : 1;  /**< [ 48: 48](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[C_D1_DBE]. */
        uint64_t c_c_sbe               : 1;  /**< [ 49: 49](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[C_C_SBE]. */
        uint64_t c_c_dbe               : 1;  /**< [ 50: 50](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[C_C_DBE]. */
        uint64_t m2s_c_sbe             : 1;  /**< [ 51: 51](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[M2S_C_SBE]. */
        uint64_t m2s_c_dbe             : 1;  /**< [ 52: 52](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[M2S_C_DBE]. */
        uint64_t m2s_d_sbe             : 1;  /**< [ 53: 53](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[M2S_D_SBE]. */
        uint64_t m2s_d_dbe             : 1;  /**< [ 54: 54](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[M2S_D_DBE]. */
        uint64_t rasdp                 : 1;  /**< [ 55: 55](R/W1S/H) Reads or sets PEM(0..3)_DBG_INFO[RASDP]. */
        uint64_t reserved_56_63        : 8;
#endif /* Word 0 - End */
    } cn83xx;
    struct bdk_pemx_dbg_info_w1s_cn88xxp2
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_58_63        : 6;
        uint64_t m2s_pe                : 1;  /**< [ 57: 57](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[M2S_PE]. */
        uint64_t qhdr_b1_dbe           : 1;  /**< [ 56: 56](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[QHDR_B1_DBE]. */
        uint64_t qhdr_b1_sbe           : 1;  /**< [ 55: 55](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[QHDR_B1_SBE]. */
        uint64_t qhdr_b0_dbe           : 1;  /**< [ 54: 54](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[QHDR_B0_DBE]. */
        uint64_t qhdr_b0_sbe           : 1;  /**< [ 53: 53](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[QHDR_B0_SBE]. */
        uint64_t rtry_dbe              : 1;  /**< [ 52: 52](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RTRY_DBE]. */
        uint64_t rtry_sbe              : 1;  /**< [ 51: 51](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RTRY_SBE]. */
        uint64_t c_c_dbe               : 1;  /**< [ 50: 50](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[C_C_DBE]. */
        uint64_t c_c_sbe               : 1;  /**< [ 49: 49](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[C_C_SBE]. */
        uint64_t c_d1_dbe              : 1;  /**< [ 48: 48](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[C_D1_DBE]. */
        uint64_t c_d1_sbe              : 1;  /**< [ 47: 47](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[C_D1_SBE]. */
        uint64_t c_d0_dbe              : 1;  /**< [ 46: 46](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[C_D0_DBE]. */
        uint64_t c_d0_sbe              : 1;  /**< [ 45: 45](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[C_D0_SBE]. */
        uint64_t n_c_dbe               : 1;  /**< [ 44: 44](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[N_C_DBE]. */
        uint64_t n_c_sbe               : 1;  /**< [ 43: 43](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[N_C_SBE]. */
        uint64_t n_d1_dbe              : 1;  /**< [ 42: 42](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[N_D1_DBE]. */
        uint64_t n_d1_sbe              : 1;  /**< [ 41: 41](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[N_D1_SBE]. */
        uint64_t n_d0_dbe              : 1;  /**< [ 40: 40](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[N_D0_DBE]. */
        uint64_t n_d0_sbe              : 1;  /**< [ 39: 39](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[N_D0_SBE]. */
        uint64_t p_c_dbe               : 1;  /**< [ 38: 38](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[P_C_DBE]. */
        uint64_t p_c_sbe               : 1;  /**< [ 37: 37](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[P_C_SBE]. */
        uint64_t p_d1_dbe              : 1;  /**< [ 36: 36](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[P_D1_DBE]. */
        uint64_t p_d1_sbe              : 1;  /**< [ 35: 35](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[P_D1_SBE]. */
        uint64_t p_d0_dbe              : 1;  /**< [ 34: 34](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[P_D0_DBE]. */
        uint64_t p_d0_sbe              : 1;  /**< [ 33: 33](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[P_D0_SBE]. */
        uint64_t datq_pe               : 1;  /**< [ 32: 32](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[DATQ_PE]. */
        uint64_t lofp                  : 1;  /**< [ 31: 31](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[LOFP]. */
        uint64_t ecrc_e                : 1;  /**< [ 30: 30](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[ECRC_E]. */
        uint64_t rawwpp                : 1;  /**< [ 29: 29](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RAWWPP].
                                                                 Internal:
                                                                 radm_rcvd_wreq_poisoned. */
        uint64_t racpp                 : 1;  /**< [ 28: 28](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RACPP].
                                                                 Internal:
                                                                 radm_rcvd_cpl_poisoned. */
        uint64_t ramtlp                : 1;  /**< [ 27: 27](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RAMTLP].
                                                                 Internal:
                                                                 radm_mlf_tlp_err. */
        uint64_t rarwdns               : 1;  /**< [ 26: 26](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RARWDNS].
                                                                 Internal:
                                                                 radm_rcvd_ur_req. */
        uint64_t caar                  : 1;  /**< [ 25: 25](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[CAAR]. */
        uint64_t racca                 : 1;  /**< [ 24: 24](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RACCA].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ca. */
        uint64_t racur                 : 1;  /**< [ 23: 23](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RACUR].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ur. */
        uint64_t rauc                  : 1;  /**< [ 22: 22](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RAUC].
                                                                 Internal:
                                                                 radm_unexp_cpl_err. */
        uint64_t rqo                   : 1;  /**< [ 21: 21](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RQO].
                                                                 Internal:
                                                                 radm_qoverflow. */
        uint64_t fcuv                  : 1;  /**< [ 20: 20](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[FCUV].
                                                                 Internal:
                                                                 (opt. checks) int_xadm_fc_prot_err. */
        uint64_t rpe                   : 1;  /**< [ 19: 19](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RPE].
                                                                 Internal:
                                                                 rmlh_rcvd_err. */
        uint64_t fcpvwt                : 1;  /**< [ 18: 18](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[FCPVWT].
                                                                 Internal:
                                                                 rtlh_fc_prot_err. */
        uint64_t dpeoosd               : 1;  /**< [ 17: 17](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[DPEOOSD].
                                                                 Internal:
                                                                 rdlh_prot_err. */
        uint64_t rtwdle                : 1;  /**< [ 16: 16](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RTWDLE].
                                                                 Internal:
                                                                 rdlh_bad_tlp_err. */
        uint64_t rdwdle                : 1;  /**< [ 15: 15](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RDWDLE].
                                                                 Internal:
                                                                 rdlh_bad_dllp_err. */
        uint64_t mre                   : 1;  /**< [ 14: 14](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[MRE].
                                                                 Internal:
                                                                 xdlh_replay_num_rlover_err. */
        uint64_t rte                   : 1;  /**< [ 13: 13](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RTE].
                                                                 Internal:
                                                                 xdlh_replay_timeout_err. */
        uint64_t acto                  : 1;  /**< [ 12: 12](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[ACTO].
                                                                 Internal:
                                                                 pedc_radm_cpl_timeout. */
        uint64_t rvdm                  : 1;  /**< [ 11: 11](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RVDM].
                                                                 Internal:
                                                                 pedc_radm_vendor_msg. */
        uint64_t reserved_10           : 1;
        uint64_t rptamrc               : 1;  /**< [  9:  9](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RPTAMRC].
                                                                 Internal:
                                                                 pedc_radm_pm_to_ack. */
        uint64_t rpmerc                : 1;  /**< [  8:  8](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RPMERC].
                                                                 Internal:
                                                                 pedc_radm_pm_pme. */
        uint64_t rfemrc                : 1;  /**< [  7:  7](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RFEMRC].
                                                                 Internal:
                                                                 pedc_radm_fatal_err. */
        uint64_t rnfemrc               : 1;  /**< [  6:  6](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RNFEMRC].
                                                                 Internal:
                                                                 pedc_radm_nonfatal_err. */
        uint64_t rcemrc                : 1;  /**< [  5:  5](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RCEMRC].
                                                                 Internal:
                                                                 pedc_radm_correctable_err. */
        uint64_t rpoison               : 1;  /**< [  4:  4](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RPOISON].
                                                                 Internal:
                                                                 pedc__radm_trgt1_poisoned & pedc__radm_trgt1_hv. */
        uint64_t recrce                : 1;  /**< [  3:  3](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RECRCE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_ecrc_err & pedc__radm_trgt1_eot. */
        uint64_t rtlplle               : 1;  /**< [  2:  2](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RTLPLLE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_dllp_abort &
                                                                 pedc__radm_trgt1_eot. */
        uint64_t rtlpmal               : 1;  /**< [  1:  1](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RTLPMAL].
                                                                 Internal:
                                                                 pedc_radm_trgt1_tlp_abort & pedc__radm_trgt1_eot. */
        uint64_t spoison               : 1;  /**< [  0:  0](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[SPOISON].
                                                                 Internal:
                                                                 peai__client0_tlp_ep & peai__client0_tlp_hv or
                                                                 peai__client1_tlp_ep & peai__client1_tlp_hv (atomic_op). */
#else /* Word 0 - Little Endian */
        uint64_t spoison               : 1;  /**< [  0:  0](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[SPOISON].
                                                                 Internal:
                                                                 peai__client0_tlp_ep & peai__client0_tlp_hv or
                                                                 peai__client1_tlp_ep & peai__client1_tlp_hv (atomic_op). */
        uint64_t rtlpmal               : 1;  /**< [  1:  1](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RTLPMAL].
                                                                 Internal:
                                                                 pedc_radm_trgt1_tlp_abort & pedc__radm_trgt1_eot. */
        uint64_t rtlplle               : 1;  /**< [  2:  2](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RTLPLLE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_dllp_abort &
                                                                 pedc__radm_trgt1_eot. */
        uint64_t recrce                : 1;  /**< [  3:  3](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RECRCE].
                                                                 Internal:
                                                                 pedc_radm_trgt1_ecrc_err & pedc__radm_trgt1_eot. */
        uint64_t rpoison               : 1;  /**< [  4:  4](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RPOISON].
                                                                 Internal:
                                                                 pedc__radm_trgt1_poisoned & pedc__radm_trgt1_hv. */
        uint64_t rcemrc                : 1;  /**< [  5:  5](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RCEMRC].
                                                                 Internal:
                                                                 pedc_radm_correctable_err. */
        uint64_t rnfemrc               : 1;  /**< [  6:  6](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RNFEMRC].
                                                                 Internal:
                                                                 pedc_radm_nonfatal_err. */
        uint64_t rfemrc                : 1;  /**< [  7:  7](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RFEMRC].
                                                                 Internal:
                                                                 pedc_radm_fatal_err. */
        uint64_t rpmerc                : 1;  /**< [  8:  8](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RPMERC].
                                                                 Internal:
                                                                 pedc_radm_pm_pme. */
        uint64_t rptamrc               : 1;  /**< [  9:  9](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RPTAMRC].
                                                                 Internal:
                                                                 pedc_radm_pm_to_ack. */
        uint64_t reserved_10           : 1;
        uint64_t rvdm                  : 1;  /**< [ 11: 11](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RVDM].
                                                                 Internal:
                                                                 pedc_radm_vendor_msg. */
        uint64_t acto                  : 1;  /**< [ 12: 12](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[ACTO].
                                                                 Internal:
                                                                 pedc_radm_cpl_timeout. */
        uint64_t rte                   : 1;  /**< [ 13: 13](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RTE].
                                                                 Internal:
                                                                 xdlh_replay_timeout_err. */
        uint64_t mre                   : 1;  /**< [ 14: 14](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[MRE].
                                                                 Internal:
                                                                 xdlh_replay_num_rlover_err. */
        uint64_t rdwdle                : 1;  /**< [ 15: 15](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RDWDLE].
                                                                 Internal:
                                                                 rdlh_bad_dllp_err. */
        uint64_t rtwdle                : 1;  /**< [ 16: 16](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RTWDLE].
                                                                 Internal:
                                                                 rdlh_bad_tlp_err. */
        uint64_t dpeoosd               : 1;  /**< [ 17: 17](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[DPEOOSD].
                                                                 Internal:
                                                                 rdlh_prot_err. */
        uint64_t fcpvwt                : 1;  /**< [ 18: 18](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[FCPVWT].
                                                                 Internal:
                                                                 rtlh_fc_prot_err. */
        uint64_t rpe                   : 1;  /**< [ 19: 19](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RPE].
                                                                 Internal:
                                                                 rmlh_rcvd_err. */
        uint64_t fcuv                  : 1;  /**< [ 20: 20](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[FCUV].
                                                                 Internal:
                                                                 (opt. checks) int_xadm_fc_prot_err. */
        uint64_t rqo                   : 1;  /**< [ 21: 21](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RQO].
                                                                 Internal:
                                                                 radm_qoverflow. */
        uint64_t rauc                  : 1;  /**< [ 22: 22](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RAUC].
                                                                 Internal:
                                                                 radm_unexp_cpl_err. */
        uint64_t racur                 : 1;  /**< [ 23: 23](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RACUR].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ur. */
        uint64_t racca                 : 1;  /**< [ 24: 24](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RACCA].
                                                                 Internal:
                                                                 radm_rcvd_cpl_ca. */
        uint64_t caar                  : 1;  /**< [ 25: 25](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[CAAR]. */
        uint64_t rarwdns               : 1;  /**< [ 26: 26](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RARWDNS].
                                                                 Internal:
                                                                 radm_rcvd_ur_req. */
        uint64_t ramtlp                : 1;  /**< [ 27: 27](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RAMTLP].
                                                                 Internal:
                                                                 radm_mlf_tlp_err. */
        uint64_t racpp                 : 1;  /**< [ 28: 28](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RACPP].
                                                                 Internal:
                                                                 radm_rcvd_cpl_poisoned. */
        uint64_t rawwpp                : 1;  /**< [ 29: 29](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RAWWPP].
                                                                 Internal:
                                                                 radm_rcvd_wreq_poisoned. */
        uint64_t ecrc_e                : 1;  /**< [ 30: 30](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[ECRC_E]. */
        uint64_t lofp                  : 1;  /**< [ 31: 31](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[LOFP]. */
        uint64_t datq_pe               : 1;  /**< [ 32: 32](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[DATQ_PE]. */
        uint64_t p_d0_sbe              : 1;  /**< [ 33: 33](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[P_D0_SBE]. */
        uint64_t p_d0_dbe              : 1;  /**< [ 34: 34](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[P_D0_DBE]. */
        uint64_t p_d1_sbe              : 1;  /**< [ 35: 35](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[P_D1_SBE]. */
        uint64_t p_d1_dbe              : 1;  /**< [ 36: 36](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[P_D1_DBE]. */
        uint64_t p_c_sbe               : 1;  /**< [ 37: 37](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[P_C_SBE]. */
        uint64_t p_c_dbe               : 1;  /**< [ 38: 38](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[P_C_DBE]. */
        uint64_t n_d0_sbe              : 1;  /**< [ 39: 39](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[N_D0_SBE]. */
        uint64_t n_d0_dbe              : 1;  /**< [ 40: 40](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[N_D0_DBE]. */
        uint64_t n_d1_sbe              : 1;  /**< [ 41: 41](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[N_D1_SBE]. */
        uint64_t n_d1_dbe              : 1;  /**< [ 42: 42](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[N_D1_DBE]. */
        uint64_t n_c_sbe               : 1;  /**< [ 43: 43](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[N_C_SBE]. */
        uint64_t n_c_dbe               : 1;  /**< [ 44: 44](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[N_C_DBE]. */
        uint64_t c_d0_sbe              : 1;  /**< [ 45: 45](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[C_D0_SBE]. */
        uint64_t c_d0_dbe              : 1;  /**< [ 46: 46](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[C_D0_DBE]. */
        uint64_t c_d1_sbe              : 1;  /**< [ 47: 47](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[C_D1_SBE]. */
        uint64_t c_d1_dbe              : 1;  /**< [ 48: 48](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[C_D1_DBE]. */
        uint64_t c_c_sbe               : 1;  /**< [ 49: 49](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[C_C_SBE]. */
        uint64_t c_c_dbe               : 1;  /**< [ 50: 50](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[C_C_DBE]. */
        uint64_t rtry_sbe              : 1;  /**< [ 51: 51](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RTRY_SBE]. */
        uint64_t rtry_dbe              : 1;  /**< [ 52: 52](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[RTRY_DBE]. */
        uint64_t qhdr_b0_sbe           : 1;  /**< [ 53: 53](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[QHDR_B0_SBE]. */
        uint64_t qhdr_b0_dbe           : 1;  /**< [ 54: 54](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[QHDR_B0_DBE]. */
        uint64_t qhdr_b1_sbe           : 1;  /**< [ 55: 55](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[QHDR_B1_SBE]. */
        uint64_t qhdr_b1_dbe           : 1;  /**< [ 56: 56](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[QHDR_B1_DBE]. */
        uint64_t m2s_pe                : 1;  /**< [ 57: 57](R/W1S/H) Reads or sets PEM(0..5)_DBG_INFO[M2S_PE]. */
        uint64_t reserved_58_63        : 6;
#endif /* Word 0 - End */
    } cn88xxp2;
};
typedef union bdk_pemx_dbg_info_w1s bdk_pemx_dbg_info_w1s_t;

static inline uint64_t BDK_PEMX_DBG_INFO_W1S(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_DBG_INFO_W1S(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN81XX) && (a<=2))
        return 0x87e0c0000450ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN83XX) && (a<=3))
        return 0x87e0c0000450ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN88XX) && (a<=5))
        return 0x87e0c0000450ll + 0x1000000ll * ((a) & 0x7);
    __bdk_csr_fatal("PEMX_DBG_INFO_W1S", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_DBG_INFO_W1S(a) bdk_pemx_dbg_info_w1s_t
#define bustype_BDK_PEMX_DBG_INFO_W1S(a) BDK_CSR_TYPE_RSL
#define basename_BDK_PEMX_DBG_INFO_W1S(a) "PEMX_DBG_INFO_W1S"
#define device_bar_BDK_PEMX_DBG_INFO_W1S(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_DBG_INFO_W1S(a) (a)
#define arguments_BDK_PEMX_DBG_INFO_W1S(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_debug
 *
 * PEM Debug Register
 * This register contains status of level interrupts for debugging purposes.
 *
 * This register is not accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on cold reset.
 */
union bdk_pemx_debug
{
    uint64_t u;
    struct bdk_pemx_debug_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_40_63        : 24;
        uint64_t n_tlp_cnt             : 8;  /**< [ 39: 32](RO/H) The current count (depth) of the outbound NP TLP FIFO.
                                                                 The value represents the number of used credits out of a total of 32. */
        uint64_t reserved_31           : 1;
        uint64_t c_tlp_cnt             : 11; /**< [ 30: 20](RO/H) The current count (depth) of the outbound C TLP FIFO.
                                                                 The value represents the number of used credits out of a total of 244. */
        uint64_t reserved_19           : 1;
        uint64_t p_tlp_cnt             : 11; /**< [ 18:  8](RO/H) The current count (depth) of the outbound P TLP FIFO.
                                                                 The value represents the number of used credits out of a total of 244. */
        uint64_t inv_m2s_par           : 1;  /**< [  7:  7](R/W) Invert the generated parity to be written into the M2S FIFO
                                                                 to force a parity error when it is later read. */
        uint64_t intval                : 7;  /**< [  6:  0](RO/H) Status of INTX, PMEI, and AERI interrupts. */
#else /* Word 0 - Little Endian */
        uint64_t intval                : 7;  /**< [  6:  0](RO/H) Status of INTX, PMEI, and AERI interrupts. */
        uint64_t inv_m2s_par           : 1;  /**< [  7:  7](R/W) Invert the generated parity to be written into the M2S FIFO
                                                                 to force a parity error when it is later read. */
        uint64_t p_tlp_cnt             : 11; /**< [ 18:  8](RO/H) The current count (depth) of the outbound P TLP FIFO.
                                                                 The value represents the number of used credits out of a total of 244. */
        uint64_t reserved_19           : 1;
        uint64_t c_tlp_cnt             : 11; /**< [ 30: 20](RO/H) The current count (depth) of the outbound C TLP FIFO.
                                                                 The value represents the number of used credits out of a total of 244. */
        uint64_t reserved_31           : 1;
        uint64_t n_tlp_cnt             : 8;  /**< [ 39: 32](RO/H) The current count (depth) of the outbound NP TLP FIFO.
                                                                 The value represents the number of used credits out of a total of 32. */
        uint64_t reserved_40_63        : 24;
#endif /* Word 0 - End */
    } s;
    struct bdk_pemx_debug_cn88xxp1
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_7_63         : 57;
        uint64_t intval                : 7;  /**< [  6:  0](RO/H) Status of INTX, PMEI, and AERI interrupts. */
#else /* Word 0 - Little Endian */
        uint64_t intval                : 7;  /**< [  6:  0](RO/H) Status of INTX, PMEI, and AERI interrupts. */
        uint64_t reserved_7_63         : 57;
#endif /* Word 0 - End */
    } cn88xxp1;
    struct bdk_pemx_debug_cn9
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_6_63         : 58;
        uint64_t intval                : 6;  /**< [  5:  0](RO/H) Status of INTX, PMEI, and AERI interrupts. */
#else /* Word 0 - Little Endian */
        uint64_t intval                : 6;  /**< [  5:  0](RO/H) Status of INTX, PMEI, and AERI interrupts. */
        uint64_t reserved_6_63         : 58;
#endif /* Word 0 - End */
    } cn9;
    struct bdk_pemx_debug_cn81xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_8_63         : 56;
        uint64_t inv_m2s_par           : 1;  /**< [  7:  7](R/W) Invert the generated parity to be written into the M2S FIFO
                                                                 to force a parity error when it is later read. */
        uint64_t reserved_6            : 1;
        uint64_t intval                : 6;  /**< [  5:  0](RO/H) Status of INTX, HP_PMEI, and AERI interrupts. */
#else /* Word 0 - Little Endian */
        uint64_t intval                : 6;  /**< [  5:  0](RO/H) Status of INTX, HP_PMEI, and AERI interrupts. */
        uint64_t reserved_6            : 1;
        uint64_t inv_m2s_par           : 1;  /**< [  7:  7](R/W) Invert the generated parity to be written into the M2S FIFO
                                                                 to force a parity error when it is later read. */
        uint64_t reserved_8_63         : 56;
#endif /* Word 0 - End */
    } cn81xx;
    struct bdk_pemx_debug_cn83xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_40_63        : 24;
        uint64_t n_tlp_cnt             : 8;  /**< [ 39: 32](RO/H) The current count (depth) of the outbound NP TLP FIFO.
                                                                 The value represents the number of used credits out of a total of 32. */
        uint64_t reserved_31           : 1;
        uint64_t c_tlp_cnt             : 11; /**< [ 30: 20](RO/H) The current count (depth) of the outbound C TLP FIFO.
                                                                 The value represents the number of used credits out of a total of 244. */
        uint64_t reserved_19           : 1;
        uint64_t p_tlp_cnt             : 11; /**< [ 18:  8](RO/H) The current count (depth) of the outbound P TLP FIFO.
                                                                 The value represents the number of used credits out of a total of 244. */
        uint64_t reserved_6_7          : 2;
        uint64_t intval                : 6;  /**< [  5:  0](RO/H) Status of INTX, PMEI, and AERI interrupts. */
#else /* Word 0 - Little Endian */
        uint64_t intval                : 6;  /**< [  5:  0](RO/H) Status of INTX, PMEI, and AERI interrupts. */
        uint64_t reserved_6_7          : 2;
        uint64_t p_tlp_cnt             : 11; /**< [ 18:  8](RO/H) The current count (depth) of the outbound P TLP FIFO.
                                                                 The value represents the number of used credits out of a total of 244. */
        uint64_t reserved_19           : 1;
        uint64_t c_tlp_cnt             : 11; /**< [ 30: 20](RO/H) The current count (depth) of the outbound C TLP FIFO.
                                                                 The value represents the number of used credits out of a total of 244. */
        uint64_t reserved_31           : 1;
        uint64_t n_tlp_cnt             : 8;  /**< [ 39: 32](RO/H) The current count (depth) of the outbound NP TLP FIFO.
                                                                 The value represents the number of used credits out of a total of 32. */
        uint64_t reserved_40_63        : 24;
#endif /* Word 0 - End */
    } cn83xx;
    struct bdk_pemx_debug_cn88xxp2
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_8_63         : 56;
        uint64_t inv_m2s_par           : 1;  /**< [  7:  7](R/W) Invert the generated parity to be written into the M2S FIFO
                                                                 to force a parity error when it is later read. */
        uint64_t intval                : 7;  /**< [  6:  0](RO/H) Status of INTX, PMEI, and AERI interrupts. */
#else /* Word 0 - Little Endian */
        uint64_t intval                : 7;  /**< [  6:  0](RO/H) Status of INTX, PMEI, and AERI interrupts. */
        uint64_t inv_m2s_par           : 1;  /**< [  7:  7](R/W) Invert the generated parity to be written into the M2S FIFO
                                                                 to force a parity error when it is later read. */
        uint64_t reserved_8_63         : 56;
#endif /* Word 0 - End */
    } cn88xxp2;
};
typedef union bdk_pemx_debug bdk_pemx_debug_t;

static inline uint64_t BDK_PEMX_DEBUG(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_DEBUG(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN81XX) && (a<=2))
        return 0x87e0c0000480ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN83XX) && (a<=3))
        return 0x87e0c0000480ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN88XX) && (a<=5))
        return 0x87e0c0000480ll + 0x1000000ll * ((a) & 0x7);
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e0000000100ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_DEBUG", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_DEBUG(a) bdk_pemx_debug_t
#define bustype_BDK_PEMX_DEBUG(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_DEBUG(a) "PEMX_DEBUG"
#define device_bar_BDK_PEMX_DEBUG(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_DEBUG(a) (a)
#define arguments_BDK_PEMX_DEBUG(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_diag_status
 *
 * PEM Diagnostic Status Register
 * This register contains selection control for the core diagnostic bus.
 *
 * This register is accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on MAC reset.
 */
union bdk_pemx_diag_status
{
    uint64_t u;
    struct bdk_pemx_diag_status_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_0_63         : 64;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0_63         : 64;
#endif /* Word 0 - End */
    } s;
    struct bdk_pemx_diag_status_cn9
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_10_63        : 54;
        uint64_t ltssm                 : 6;  /**< [  9:  4](RO/H) Current  smlh_ltssm_state. */
        uint64_t pwrdwn                : 4;  /**< [  3:  0](RO/H) Current mac_phy_powerdown state.
                                                                 0x0 = D0.
                                                                 0x1 = D1.
                                                                 0x2 = D2.
                                                                 0x3 = D3.
                                                                 0x4 - 0x7: Reserved. */
#else /* Word 0 - Little Endian */
        uint64_t pwrdwn                : 4;  /**< [  3:  0](RO/H) Current mac_phy_powerdown state.
                                                                 0x0 = D0.
                                                                 0x1 = D1.
                                                                 0x2 = D2.
                                                                 0x3 = D3.
                                                                 0x4 - 0x7: Reserved. */
        uint64_t ltssm                 : 6;  /**< [  9:  4](RO/H) Current  smlh_ltssm_state. */
        uint64_t reserved_10_63        : 54;
#endif /* Word 0 - End */
    } cn9;
    struct bdk_pemx_diag_status_cn81xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_9_63         : 55;
        uint64_t pwrdwn                : 3;  /**< [  8:  6](RO/H) Current mac_phy_powerdown state. */
        uint64_t pm_dst                : 3;  /**< [  5:  3](RO/H) Current power management DSTATE. */
        uint64_t pm_stat               : 1;  /**< [  2:  2](RO) Power management status. */
        uint64_t pm_en                 : 1;  /**< [  1:  1](RO) Power management event enable. */
        uint64_t aux_en                : 1;  /**< [  0:  0](RO) Auxiliary power enable. Always read as zero as auxiliary power is not supported. */
#else /* Word 0 - Little Endian */
        uint64_t aux_en                : 1;  /**< [  0:  0](RO) Auxiliary power enable. Always read as zero as auxiliary power is not supported. */
        uint64_t pm_en                 : 1;  /**< [  1:  1](RO) Power management event enable. */
        uint64_t pm_stat               : 1;  /**< [  2:  2](RO) Power management status. */
        uint64_t pm_dst                : 3;  /**< [  5:  3](RO/H) Current power management DSTATE. */
        uint64_t pwrdwn                : 3;  /**< [  8:  6](RO/H) Current mac_phy_powerdown state. */
        uint64_t reserved_9_63         : 55;
#endif /* Word 0 - End */
    } cn81xx;
    /* struct bdk_pemx_diag_status_cn81xx cn88xx; */
    struct bdk_pemx_diag_status_cn83xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_9_63         : 55;
        uint64_t pwrdwn                : 3;  /**< [  8:  6](RO/H) Current mac_phy_powerdown state. */
        uint64_t pm_dst                : 3;  /**< [  5:  3](RO/H) Current power management DSTATE. */
        uint64_t pm_stat               : 1;  /**< [  2:  2](RO/H) Power management status. */
        uint64_t pm_en                 : 1;  /**< [  1:  1](RO/H) Power management event enable. */
        uint64_t aux_en                : 1;  /**< [  0:  0](RO/H) Auxiliary power enable. */
#else /* Word 0 - Little Endian */
        uint64_t aux_en                : 1;  /**< [  0:  0](RO/H) Auxiliary power enable. */
        uint64_t pm_en                 : 1;  /**< [  1:  1](RO/H) Power management event enable. */
        uint64_t pm_stat               : 1;  /**< [  2:  2](RO/H) Power management status. */
        uint64_t pm_dst                : 3;  /**< [  5:  3](RO/H) Current power management DSTATE. */
        uint64_t pwrdwn                : 3;  /**< [  8:  6](RO/H) Current mac_phy_powerdown state. */
        uint64_t reserved_9_63         : 55;
#endif /* Word 0 - End */
    } cn83xx;
};
typedef union bdk_pemx_diag_status bdk_pemx_diag_status_t;

static inline uint64_t BDK_PEMX_DIAG_STATUS(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_DIAG_STATUS(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN81XX) && (a<=2))
        return 0x87e0c0000020ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN83XX) && (a<=3))
        return 0x87e0c0000020ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN88XX) && (a<=5))
        return 0x87e0c0000020ll + 0x1000000ll * ((a) & 0x7);
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e0000000010ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_DIAG_STATUS", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_DIAG_STATUS(a) bdk_pemx_diag_status_t
#define bustype_BDK_PEMX_DIAG_STATUS(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_DIAG_STATUS(a) "PEMX_DIAG_STATUS"
#define device_bar_BDK_PEMX_DIAG_STATUS(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_DIAG_STATUS(a) (a)
#define arguments_BDK_PEMX_DIAG_STATUS(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_dis_port
 *
 * PEM Disable Port Register
 * This register controls whether traffic is allowed to be sent out the PCIe link.
 *
 * This register is accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on PEM domain reset.
 */
union bdk_pemx_dis_port
{
    uint64_t u;
    struct bdk_pemx_dis_port_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_1_63         : 63;
        uint64_t dis_port              : 1;  /**< [  0:  0](R/W1C/H) When set, outbound read and writes are disabled (dropped) and reads will
                                                                 return completion with fault over NCBI or EBUS.  Software must clear this bit after
                                                                 power-on reset to start normal activity.  Further, this bit will be set by
                                                                 hardware when either MAC reset or core reset completes an assertion phase.
                                                                 Writing a one to this location clears the bit and will allow outbound operations
                                                                 to be sent to the MAC at the beginning of the next transfer. This bit cannot
                                                                 be set while PEM()_ON[PEMOOR] is set. */
#else /* Word 0 - Little Endian */
        uint64_t dis_port              : 1;  /**< [  0:  0](R/W1C/H) When set, outbound read and writes are disabled (dropped) and reads will
                                                                 return completion with fault over NCBI or EBUS.  Software must clear this bit after
                                                                 power-on reset to start normal activity.  Further, this bit will be set by
                                                                 hardware when either MAC reset or core reset completes an assertion phase.
                                                                 Writing a one to this location clears the bit and will allow outbound operations
                                                                 to be sent to the MAC at the beginning of the next transfer. This bit cannot
                                                                 be set while PEM()_ON[PEMOOR] is set. */
        uint64_t reserved_1_63         : 63;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_dis_port_s cn; */
};
typedef union bdk_pemx_dis_port bdk_pemx_dis_port_t;

static inline uint64_t BDK_PEMX_DIS_PORT(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_DIS_PORT(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e0000000048ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_DIS_PORT", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_DIS_PORT(a) bdk_pemx_dis_port_t
#define bustype_BDK_PEMX_DIS_PORT(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_DIS_PORT(a) "PEMX_DIS_PORT"
#define device_bar_BDK_PEMX_DIS_PORT(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_DIS_PORT(a) (a)
#define arguments_BDK_PEMX_DIS_PORT(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_ebi_tlp_credits
 *
 * PEM EBUS TLP Credits Register
 * This register specifies the number of credits for use in moving TLPs. When this register is
 * written, the credit values are reset to the register value. This register is for diagnostic
 * use only, and should only be written when PEM()_CTL_STATUS[LNK_ENB] is clear.
 *
 * This register is accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on MAC reset.
 */
union bdk_pemx_ebi_tlp_credits
{
    uint64_t u;
    struct bdk_pemx_ebi_tlp_credits_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_32_63        : 32;
        uint64_t ebi_cpl               : 11; /**< [ 31: 21](R/W) TLP 32 B credits for completion TLPs in the PEMs inbound EBUS buffers.
                                                                 Legal values are 0x21 to 0x100. */
        uint64_t ebi_np                : 10; /**< [ 20: 11](R/W) TLP headers for non-posted TLPs in the PEMs inbound EBUS buffers.
                                                                 Legal values are 0x1 to 0x20. */
        uint64_t ebi_p                 : 11; /**< [ 10:  0](R/W) TLP 32 B credits for posted TLPs in the PEMs inbound EBUS buffers.
                                                                 Legal values are 0x21 to 0x100. */
#else /* Word 0 - Little Endian */
        uint64_t ebi_p                 : 11; /**< [ 10:  0](R/W) TLP 32 B credits for posted TLPs in the PEMs inbound EBUS buffers.
                                                                 Legal values are 0x21 to 0x100. */
        uint64_t ebi_np                : 10; /**< [ 20: 11](R/W) TLP headers for non-posted TLPs in the PEMs inbound EBUS buffers.
                                                                 Legal values are 0x1 to 0x20. */
        uint64_t ebi_cpl               : 11; /**< [ 31: 21](R/W) TLP 32 B credits for completion TLPs in the PEMs inbound EBUS buffers.
                                                                 Legal values are 0x21 to 0x100. */
        uint64_t reserved_32_63        : 32;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_ebi_tlp_credits_s cn; */
};
typedef union bdk_pemx_ebi_tlp_credits bdk_pemx_ebi_tlp_credits_t;

static inline uint64_t BDK_PEMX_EBI_TLP_CREDITS(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_EBI_TLP_CREDITS(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e0000000028ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_EBI_TLP_CREDITS", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_EBI_TLP_CREDITS(a) bdk_pemx_ebi_tlp_credits_t
#define bustype_BDK_PEMX_EBI_TLP_CREDITS(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_EBI_TLP_CREDITS(a) "PEMX_EBI_TLP_CREDITS"
#define device_bar_BDK_PEMX_EBI_TLP_CREDITS(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_EBI_TLP_CREDITS(a) (a)
#define arguments_BDK_PEMX_EBI_TLP_CREDITS(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_ebo_fifo_status
 *
 * PEM EBO Offloading FIFO Status Register
 * This register contains status about the PEM EBO offloading FIFOs.
 *
 * This register is not accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on PEM domain reset.
 */
union bdk_pemx_ebo_fifo_status
{
    uint64_t u;
    struct bdk_pemx_ebo_fifo_status_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_54_63        : 10;
        uint64_t c_cmd_volume          : 6;  /**< [ 53: 48](RO/H) Reports the number of valid EBO completion data beats currently held in the
                                                                 EBO completion buffer. Each entry represents a beat of the EBO bus related to a
                                                                 completion operation and the value read can range from 0x0 to a maximum of 0x20
                                                                 which would represent completely full. For diagnostic use only. */
        uint64_t reserved_46_47        : 2;
        uint64_t n_cmd_volume          : 6;  /**< [ 45: 40](RO/H) Reports the number of valid entries currently held in the EBO non-posted
                                                                 offloading FIFO. Each entry represents a beat of the EBO bus related to a
                                                                 Non-Posted operation and the value read can range from 0x0 to a maximum of 0x20
                                                                 which would represent completely full.
                                                                 For diagnostic use only. */
        uint64_t reserved_38_39        : 2;
        uint64_t p_cmd_volume          : 6;  /**< [ 37: 32](RO/H) Reports the number of valid entries currently held in the EBO posted offloading
                                                                 FIFO. Each entry represents a beat of the EBO bus related to a memory store and
                                                                 the value read can range from 0x0 to a maximum of 0x20 which would represent
                                                                 completely full.
                                                                 For diagnostic use only. */
        uint64_t c_data_volume         : 8;  /**< [ 31: 24](RO/H) Reports the number of valid EBO completion data beats currently held in the
                                                                 EBO completion buffer. Each entry represents a beat of the EBO bus related to a
                                                                 completion operation and the value read can range from 0x0 to a maximum of 0x40
                                                                 which would represent completely full. For diagnostic use only.

                                                                 Internal:
                                                                 Maximum is 32 for 512b EBUS, 64 for 256b EBUS, 128 for 128b EBUS. */
        uint64_t reserved_20_23        : 4;
        uint64_t n_data_volume         : 8;  /**< [ 19: 12](RO/H) Reports the number of valid entries currently held in the EBO non-posted
                                                                 offloading FIFO. Each entry represents a beat of the EBO bus related to a
                                                                 Non-Posted operation and the value read can range from 0x0 to a maximum of 0x40
                                                                 which would represent completely full.
                                                                 For diagnostic use only.

                                                                 Internal:
                                                                 Maximum is 32 for 512b EBUS, 64 for 256b EBUS, 128 for 128b EBUS. */
        uint64_t reserved_8_11         : 4;
        uint64_t p_data_volume         : 8;  /**< [  7:  0](RO/H) Reports the number of valid entries currently held in the EBO posted offloading
                                                                 FIFO. Each entry represents a beat of the EBO bus related to a memory store and
                                                                 the value read can range from 0x0 to a maximum of 0x40 which would represent
                                                                 completely full.
                                                                 For diagnostic use only.

                                                                 Internal:
                                                                 Maximum is 32 for 512b EBUS, 64 for 256b EBUS, 128 for 128b EBUS. */
#else /* Word 0 - Little Endian */
        uint64_t p_data_volume         : 8;  /**< [  7:  0](RO/H) Reports the number of valid entries currently held in the EBO posted offloading
                                                                 FIFO. Each entry represents a beat of the EBO bus related to a memory store and
                                                                 the value read can range from 0x0 to a maximum of 0x40 which would represent
                                                                 completely full.
                                                                 For diagnostic use only.

                                                                 Internal:
                                                                 Maximum is 32 for 512b EBUS, 64 for 256b EBUS, 128 for 128b EBUS. */
        uint64_t reserved_8_11         : 4;
        uint64_t n_data_volume         : 8;  /**< [ 19: 12](RO/H) Reports the number of valid entries currently held in the EBO non-posted
                                                                 offloading FIFO. Each entry represents a beat of the EBO bus related to a
                                                                 Non-Posted operation and the value read can range from 0x0 to a maximum of 0x40
                                                                 which would represent completely full.
                                                                 For diagnostic use only.

                                                                 Internal:
                                                                 Maximum is 32 for 512b EBUS, 64 for 256b EBUS, 128 for 128b EBUS. */
        uint64_t reserved_20_23        : 4;
        uint64_t c_data_volume         : 8;  /**< [ 31: 24](RO/H) Reports the number of valid EBO completion data beats currently held in the
                                                                 EBO completion buffer. Each entry represents a beat of the EBO bus related to a
                                                                 completion operation and the value read can range from 0x0 to a maximum of 0x40
                                                                 which would represent completely full. For diagnostic use only.

                                                                 Internal:
                                                                 Maximum is 32 for 512b EBUS, 64 for 256b EBUS, 128 for 128b EBUS. */
        uint64_t p_cmd_volume          : 6;  /**< [ 37: 32](RO/H) Reports the number of valid entries currently held in the EBO posted offloading
                                                                 FIFO. Each entry represents a beat of the EBO bus related to a memory store and
                                                                 the value read can range from 0x0 to a maximum of 0x20 which would represent
                                                                 completely full.
                                                                 For diagnostic use only. */
        uint64_t reserved_38_39        : 2;
        uint64_t n_cmd_volume          : 6;  /**< [ 45: 40](RO/H) Reports the number of valid entries currently held in the EBO non-posted
                                                                 offloading FIFO. Each entry represents a beat of the EBO bus related to a
                                                                 Non-Posted operation and the value read can range from 0x0 to a maximum of 0x20
                                                                 which would represent completely full.
                                                                 For diagnostic use only. */
        uint64_t reserved_46_47        : 2;
        uint64_t c_cmd_volume          : 6;  /**< [ 53: 48](RO/H) Reports the number of valid EBO completion data beats currently held in the
                                                                 EBO completion buffer. Each entry represents a beat of the EBO bus related to a
                                                                 completion operation and the value read can range from 0x0 to a maximum of 0x20
                                                                 which would represent completely full. For diagnostic use only. */
        uint64_t reserved_54_63        : 10;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_ebo_fifo_status_s cn; */
};
typedef union bdk_pemx_ebo_fifo_status bdk_pemx_ebo_fifo_status_t;

static inline uint64_t BDK_PEMX_EBO_FIFO_STATUS(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_EBO_FIFO_STATUS(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e0000000130ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_EBO_FIFO_STATUS", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_EBO_FIFO_STATUS(a) bdk_pemx_ebo_fifo_status_t
#define bustype_BDK_PEMX_EBO_FIFO_STATUS(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_EBO_FIFO_STATUS(a) "PEMX_EBO_FIFO_STATUS"
#define device_bar_BDK_PEMX_EBO_FIFO_STATUS(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_EBO_FIFO_STATUS(a) (a)
#define arguments_BDK_PEMX_EBO_FIFO_STATUS(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_ebus_ctl
 *
 * PEM EBUS Control Register
 * This register contains EBUS related control bits.
 *
 * This register is accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on PEM domain reset.
 */
union bdk_pemx_ebus_ctl
{
    uint64_t u;
    struct bdk_pemx_ebus_ctl_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_33_63        : 31;
        uint64_t ebo_stf               : 1;  /**< [ 32: 32](R/W) If set, force store and forward mode for offloading FIFOs on outbound EBUS.
                                                                 This might be useful in a system with an EBUS which cannot keep up with
                                                                 the PCIe link bandwidth (e.g. 128B EBUS or many idle cycles on EBUS) where
                                                                 idle cycles introduced in the packet stream could interfere with NCBO
                                                                 performance. In general it should not be set. */
        uint64_t reserved_16_31        : 16;
        uint64_t clken_force           : 1;  /**< [ 15: 15](R/W) Force clock enable on inbound EBUS to be always asserted. For diagnostic use only. */
        uint64_t erom_sel              : 1;  /**< [ 14: 14](R/W) If set, inbound PF EROM BAR accesses are directed to EBUS instead of NCB. This
                                                                 must be clear when the PEM is configured for RC mode.

                                                                 For CNXXXX this bit must be clear. */
        uint64_t vf_bar2_sel           : 1;  /**< [ 13: 13](RO) If set, inbound VF BAR2 accesses are directed to EBUS instead of NCB. This bit is
                                                                 hard-coded to 1. */
        uint64_t vf_bar4_sel           : 1;  /**< [ 12: 12](RO) If set, inbound VF BAR4 accesses are directed to EBUS instead of NCB. This bit is
                                                                 hard-coded to 1. */
        uint64_t vf_bar0_sel           : 1;  /**< [ 11: 11](RO) If set, inbound VF BAR0 accesses are directed to EBUS instead of NCB. This bit is
                                                                 hard-coded to 1. */
        uint64_t pf_bar2_sel           : 1;  /**< [ 10: 10](R/W) If set, inbound PF BAR2 accesses are directed to EBUS instead of NCB. In RC mode,
                                                                 registers PEM()_P2N_BAR2_START / PEM()_BAR_CTL[BAR2_SIZ] are used to determine a BAR2 hit
                                                                 rather than standard PCIe config registers.

                                                                 For CNXXXX this bit must be clear. */
        uint64_t pf_bar4_sel           : 1;  /**< [  9:  9](R/W) If set, inbound PF BAR4 accesses are directed to EBUS instead of NCB. In RC mode,
                                                                 registers PEM()_P2N_BAR4_START / PEM()_BAR_CTL[BAR4_SIZ] are used to determine a BAR4 hit
                                                                 rather than standard PCIe config registers.

                                                                 For CNXXXX this bit must be clear. */
        uint64_t pf_bar0_sel           : 1;  /**< [  8:  8](R/W) If set, inbound PF BAR0 accesses are directed to EBUS instead of NCB. In RC mode,
                                                                 registers PEM()_P2N_BAR0_START / PEM()_BAR_CTL[BAR0_SIZ] are used to determine a BAR0 hit
                                                                 rather than standard PCIe config registers.

                                                                 For CNXXXX this bit must be set. */
        uint64_t reserved_6_7          : 2;
        uint64_t ntlp_ro_dis           : 1;  /**< [  5:  5](R/W) Relaxed ordering disable for non-posted TLPs. Forces relaxed ordering bit off
                                                                 when incoming non-posted TLPs arrive targeting EBUS. */
        uint64_t inv_par               : 1;  /**< [  4:  4](R/W) When set, causes the parity bit on inbound EBUS to be inverted. This bit is for
                                                                 debug only. */
        uint64_t atomic_dis            : 1;  /**< [  3:  3](R/W) If set, incoming atomics targeting EBUS are discarded and a completion with
                                                                 status of unsupported request is returned to the sender.

                                                                 This bit must be set. */
        uint64_t ctlp_ro_dis           : 1;  /**< [  2:  2](R/W) Relaxed ordering disable for completion TLPs. Forces relaxed ordering bit off
                                                                 when incoming completion TLPs arrive targeting EBUS. */
        uint64_t ptlp_ro_dis           : 1;  /**< [  1:  1](R/W) Relaxed ordering disable for posted TLPs. Forces relaxed ordering bit off when
                                                                 incoming posted TLPs arrive targeting EBUS. */
        uint64_t vdm_dis               : 1;  /**< [  0:  0](R/W) If set, incoming vendor defined messages from PCIe will be discarded rather than
                                                                 forwarded on EBUS.

                                                                 For CNXXXX this bit must be set. */
#else /* Word 0 - Little Endian */
        uint64_t vdm_dis               : 1;  /**< [  0:  0](R/W) If set, incoming vendor defined messages from PCIe will be discarded rather than
                                                                 forwarded on EBUS.

                                                                 For CNXXXX this bit must be set. */
        uint64_t ptlp_ro_dis           : 1;  /**< [  1:  1](R/W) Relaxed ordering disable for posted TLPs. Forces relaxed ordering bit off when
                                                                 incoming posted TLPs arrive targeting EBUS. */
        uint64_t ctlp_ro_dis           : 1;  /**< [  2:  2](R/W) Relaxed ordering disable for completion TLPs. Forces relaxed ordering bit off
                                                                 when incoming completion TLPs arrive targeting EBUS. */
        uint64_t atomic_dis            : 1;  /**< [  3:  3](R/W) If set, incoming atomics targeting EBUS are discarded and a completion with
                                                                 status of unsupported request is returned to the sender.

                                                                 This bit must be set. */
        uint64_t inv_par               : 1;  /**< [  4:  4](R/W) When set, causes the parity bit on inbound EBUS to be inverted. This bit is for
                                                                 debug only. */
        uint64_t ntlp_ro_dis           : 1;  /**< [  5:  5](R/W) Relaxed ordering disable for non-posted TLPs. Forces relaxed ordering bit off
                                                                 when incoming non-posted TLPs arrive targeting EBUS. */
        uint64_t reserved_6_7          : 2;
        uint64_t pf_bar0_sel           : 1;  /**< [  8:  8](R/W) If set, inbound PF BAR0 accesses are directed to EBUS instead of NCB. In RC mode,
                                                                 registers PEM()_P2N_BAR0_START / PEM()_BAR_CTL[BAR0_SIZ] are used to determine a BAR0 hit
                                                                 rather than standard PCIe config registers.

                                                                 For CNXXXX this bit must be set. */
        uint64_t pf_bar4_sel           : 1;  /**< [  9:  9](R/W) If set, inbound PF BAR4 accesses are directed to EBUS instead of NCB. In RC mode,
                                                                 registers PEM()_P2N_BAR4_START / PEM()_BAR_CTL[BAR4_SIZ] are used to determine a BAR4 hit
                                                                 rather than standard PCIe config registers.

                                                                 For CNXXXX this bit must be clear. */
        uint64_t pf_bar2_sel           : 1;  /**< [ 10: 10](R/W) If set, inbound PF BAR2 accesses are directed to EBUS instead of NCB. In RC mode,
                                                                 registers PEM()_P2N_BAR2_START / PEM()_BAR_CTL[BAR2_SIZ] are used to determine a BAR2 hit
                                                                 rather than standard PCIe config registers.

                                                                 For CNXXXX this bit must be clear. */
        uint64_t vf_bar0_sel           : 1;  /**< [ 11: 11](RO) If set, inbound VF BAR0 accesses are directed to EBUS instead of NCB. This bit is
                                                                 hard-coded to 1. */
        uint64_t vf_bar4_sel           : 1;  /**< [ 12: 12](RO) If set, inbound VF BAR4 accesses are directed to EBUS instead of NCB. This bit is
                                                                 hard-coded to 1. */
        uint64_t vf_bar2_sel           : 1;  /**< [ 13: 13](RO) If set, inbound VF BAR2 accesses are directed to EBUS instead of NCB. This bit is
                                                                 hard-coded to 1. */
        uint64_t erom_sel              : 1;  /**< [ 14: 14](R/W) If set, inbound PF EROM BAR accesses are directed to EBUS instead of NCB. This
                                                                 must be clear when the PEM is configured for RC mode.

                                                                 For CNXXXX this bit must be clear. */
        uint64_t clken_force           : 1;  /**< [ 15: 15](R/W) Force clock enable on inbound EBUS to be always asserted. For diagnostic use only. */
        uint64_t reserved_16_31        : 16;
        uint64_t ebo_stf               : 1;  /**< [ 32: 32](R/W) If set, force store and forward mode for offloading FIFOs on outbound EBUS.
                                                                 This might be useful in a system with an EBUS which cannot keep up with
                                                                 the PCIe link bandwidth (e.g. 128B EBUS or many idle cycles on EBUS) where
                                                                 idle cycles introduced in the packet stream could interfere with NCBO
                                                                 performance. In general it should not be set. */
        uint64_t reserved_33_63        : 31;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_ebus_ctl_s cn; */
};
typedef union bdk_pemx_ebus_ctl bdk_pemx_ebus_ctl_t;

static inline uint64_t BDK_PEMX_EBUS_CTL(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_EBUS_CTL(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e0000000078ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_EBUS_CTL", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_EBUS_CTL(a) bdk_pemx_ebus_ctl_t
#define bustype_BDK_PEMX_EBUS_CTL(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_EBUS_CTL(a) "PEMX_EBUS_CTL"
#define device_bar_BDK_PEMX_EBUS_CTL(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_EBUS_CTL(a) (a)
#define arguments_BDK_PEMX_EBUS_CTL(a) (a),-1,-1,-1

/**
 * Register (RSL) pem#_ecc_ena
 *
 * PEM ECC Enable Register
 * Contains enables for TLP FIFO ECC RAMs.
 */
union bdk_pemx_ecc_ena
{
    uint64_t u;
    struct bdk_pemx_ecc_ena_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_35_63        : 29;
        uint64_t qhdr_b1_ena           : 1;  /**< [ 34: 34](R/W) ECC enable for Core's Q HDR Bank1 RAM. */
        uint64_t qhdr_b0_ena           : 1;  /**< [ 33: 33](R/W) ECC enable for Core's Q HDR Bank0 RAM. */
        uint64_t rtry_ena              : 1;  /**< [ 32: 32](R/W) ECC enable for Core's RETRY RA. */
        uint64_t reserved_11_31        : 21;
        uint64_t m2s_c_ena             : 1;  /**< [ 10: 10](R/W) ECC enable for M2S Control FIFO. */
        uint64_t m2s_d_ena             : 1;  /**< [  9:  9](R/W) ECC enable for M2S Data FIFO. */
        uint64_t c_c_ena               : 1;  /**< [  8:  8](R/W) ECC enable for TLP CPL control FIFO. */
        uint64_t c_d1_ena              : 1;  /**< [  7:  7](R/W) ECC enable for TLP CPL data1 FIFO. */
        uint64_t c_d0_ena              : 1;  /**< [  6:  6](R/W) ECC enable for TLP CPL data0 FIFO. */
        uint64_t n_c_ena               : 1;  /**< [  5:  5](R/W) ECC enable for TLP NP control FIFO. */
        uint64_t n_d1_ena              : 1;  /**< [  4:  4](R/W) ECC enable for TLP NP data1 FIFO. */
        uint64_t n_d0_ena              : 1;  /**< [  3:  3](R/W) ECC enable for TLP NP data0 FIFO. */
        uint64_t p_c_ena               : 1;  /**< [  2:  2](R/W) ECC enable for TLP posted control FIFO. */
        uint64_t p_d1_ena              : 1;  /**< [  1:  1](R/W) ECC enable for TLP posted data1 FIFO. */
        uint64_t p_d0_ena              : 1;  /**< [  0:  0](R/W) ECC enable for TLP posted data0 FIFO. */
#else /* Word 0 - Little Endian */
        uint64_t p_d0_ena              : 1;  /**< [  0:  0](R/W) ECC enable for TLP posted data0 FIFO. */
        uint64_t p_d1_ena              : 1;  /**< [  1:  1](R/W) ECC enable for TLP posted data1 FIFO. */
        uint64_t p_c_ena               : 1;  /**< [  2:  2](R/W) ECC enable for TLP posted control FIFO. */
        uint64_t n_d0_ena              : 1;  /**< [  3:  3](R/W) ECC enable for TLP NP data0 FIFO. */
        uint64_t n_d1_ena              : 1;  /**< [  4:  4](R/W) ECC enable for TLP NP data1 FIFO. */
        uint64_t n_c_ena               : 1;  /**< [  5:  5](R/W) ECC enable for TLP NP control FIFO. */
        uint64_t c_d0_ena              : 1;  /**< [  6:  6](R/W) ECC enable for TLP CPL data0 FIFO. */
        uint64_t c_d1_ena              : 1;  /**< [  7:  7](R/W) ECC enable for TLP CPL data1 FIFO. */
        uint64_t c_c_ena               : 1;  /**< [  8:  8](R/W) ECC enable for TLP CPL control FIFO. */
        uint64_t m2s_d_ena             : 1;  /**< [  9:  9](R/W) ECC enable for M2S Data FIFO. */
        uint64_t m2s_c_ena             : 1;  /**< [ 10: 10](R/W) ECC enable for M2S Control FIFO. */
        uint64_t reserved_11_31        : 21;
        uint64_t rtry_ena              : 1;  /**< [ 32: 32](R/W) ECC enable for Core's RETRY RA. */
        uint64_t qhdr_b0_ena           : 1;  /**< [ 33: 33](R/W) ECC enable for Core's Q HDR Bank0 RAM. */
        uint64_t qhdr_b1_ena           : 1;  /**< [ 34: 34](R/W) ECC enable for Core's Q HDR Bank1 RAM. */
        uint64_t reserved_35_63        : 29;
#endif /* Word 0 - End */
    } s;
    struct bdk_pemx_ecc_ena_cn81xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_35_63        : 29;
        uint64_t qhdr_b1_ena           : 1;  /**< [ 34: 34](R/W) ECC enable for Core's Q HDR Bank1 RAM. */
        uint64_t qhdr_b0_ena           : 1;  /**< [ 33: 33](R/W) ECC enable for Core's Q HDR Bank0 RAM. */
        uint64_t rtry_ena              : 1;  /**< [ 32: 32](R/W) ECC enable for Core's RETRY RA. */
        uint64_t reserved_9_31         : 23;
        uint64_t c_c_ena               : 1;  /**< [  8:  8](R/W) ECC enable for TLP CPL control FIFO. */
        uint64_t c_d1_ena              : 1;  /**< [  7:  7](R/W) ECC enable for TLP CPL data1 FIFO. */
        uint64_t c_d0_ena              : 1;  /**< [  6:  6](R/W) ECC enable for TLP CPL data0 FIFO. */
        uint64_t n_c_ena               : 1;  /**< [  5:  5](R/W) ECC enable for TLP NP control FIFO. */
        uint64_t n_d1_ena              : 1;  /**< [  4:  4](R/W) ECC enable for TLP NP data1 FIFO. */
        uint64_t n_d0_ena              : 1;  /**< [  3:  3](R/W) ECC enable for TLP NP data0 FIFO. */
        uint64_t p_c_ena               : 1;  /**< [  2:  2](R/W) ECC enable for TLP posted control FIFO. */
        uint64_t p_d1_ena              : 1;  /**< [  1:  1](R/W) ECC enable for TLP posted data1 FIFO. */
        uint64_t p_d0_ena              : 1;  /**< [  0:  0](R/W) ECC enable for TLP posted data0 FIFO. */
#else /* Word 0 - Little Endian */
        uint64_t p_d0_ena              : 1;  /**< [  0:  0](R/W) ECC enable for TLP posted data0 FIFO. */
        uint64_t p_d1_ena              : 1;  /**< [  1:  1](R/W) ECC enable for TLP posted data1 FIFO. */
        uint64_t p_c_ena               : 1;  /**< [  2:  2](R/W) ECC enable for TLP posted control FIFO. */
        uint64_t n_d0_ena              : 1;  /**< [  3:  3](R/W) ECC enable for TLP NP data0 FIFO. */
        uint64_t n_d1_ena              : 1;  /**< [  4:  4](R/W) ECC enable for TLP NP data1 FIFO. */
        uint64_t n_c_ena               : 1;  /**< [  5:  5](R/W) ECC enable for TLP NP control FIFO. */
        uint64_t c_d0_ena              : 1;  /**< [  6:  6](R/W) ECC enable for TLP CPL data0 FIFO. */
        uint64_t c_d1_ena              : 1;  /**< [  7:  7](R/W) ECC enable for TLP CPL data1 FIFO. */
        uint64_t c_c_ena               : 1;  /**< [  8:  8](R/W) ECC enable for TLP CPL control FIFO. */
        uint64_t reserved_9_31         : 23;
        uint64_t rtry_ena              : 1;  /**< [ 32: 32](R/W) ECC enable for Core's RETRY RA. */
        uint64_t qhdr_b0_ena           : 1;  /**< [ 33: 33](R/W) ECC enable for Core's Q HDR Bank0 RAM. */
        uint64_t qhdr_b1_ena           : 1;  /**< [ 34: 34](R/W) ECC enable for Core's Q HDR Bank1 RAM. */
        uint64_t reserved_35_63        : 29;
#endif /* Word 0 - End */
    } cn81xx;
    /* struct bdk_pemx_ecc_ena_cn81xx cn88xx; */
    struct bdk_pemx_ecc_ena_cn83xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_11_63        : 53;
        uint64_t m2s_c_ena             : 1;  /**< [ 10: 10](R/W) ECC enable for M2S Control FIFO. */
        uint64_t m2s_d_ena             : 1;  /**< [  9:  9](R/W) ECC enable for M2S Data FIFO. */
        uint64_t c_c_ena               : 1;  /**< [  8:  8](R/W) ECC enable for TLP CPL control FIFO. */
        uint64_t c_d1_ena              : 1;  /**< [  7:  7](R/W) ECC enable for TLP CPL data1 FIFO. */
        uint64_t c_d0_ena              : 1;  /**< [  6:  6](R/W) ECC enable for TLP CPL data0 FIFO. */
        uint64_t n_c_ena               : 1;  /**< [  5:  5](R/W) ECC enable for TLP NP control FIFO. */
        uint64_t n_d1_ena              : 1;  /**< [  4:  4](R/W) ECC enable for TLP NP data1 FIFO. */
        uint64_t n_d0_ena              : 1;  /**< [  3:  3](R/W) ECC enable for TLP NP data0 FIFO. */
        uint64_t p_c_ena               : 1;  /**< [  2:  2](R/W) ECC enable for TLP posted control FIFO. */
        uint64_t p_d1_ena              : 1;  /**< [  1:  1](R/W) ECC enable for TLP posted data1 FIFO. */
        uint64_t p_d0_ena              : 1;  /**< [  0:  0](R/W) ECC enable for TLP posted data0 FIFO. */
#else /* Word 0 - Little Endian */
        uint64_t p_d0_ena              : 1;  /**< [  0:  0](R/W) ECC enable for TLP posted data0 FIFO. */
        uint64_t p_d1_ena              : 1;  /**< [  1:  1](R/W) ECC enable for TLP posted data1 FIFO. */
        uint64_t p_c_ena               : 1;  /**< [  2:  2](R/W) ECC enable for TLP posted control FIFO. */
        uint64_t n_d0_ena              : 1;  /**< [  3:  3](R/W) ECC enable for TLP NP data0 FIFO. */
        uint64_t n_d1_ena              : 1;  /**< [  4:  4](R/W) ECC enable for TLP NP data1 FIFO. */
        uint64_t n_c_ena               : 1;  /**< [  5:  5](R/W) ECC enable for TLP NP control FIFO. */
        uint64_t c_d0_ena              : 1;  /**< [  6:  6](R/W) ECC enable for TLP CPL data0 FIFO. */
        uint64_t c_d1_ena              : 1;  /**< [  7:  7](R/W) ECC enable for TLP CPL data1 FIFO. */
        uint64_t c_c_ena               : 1;  /**< [  8:  8](R/W) ECC enable for TLP CPL control FIFO. */
        uint64_t m2s_d_ena             : 1;  /**< [  9:  9](R/W) ECC enable for M2S Data FIFO. */
        uint64_t m2s_c_ena             : 1;  /**< [ 10: 10](R/W) ECC enable for M2S Control FIFO. */
        uint64_t reserved_11_63        : 53;
#endif /* Word 0 - End */
    } cn83xx;
};
typedef union bdk_pemx_ecc_ena bdk_pemx_ecc_ena_t;

static inline uint64_t BDK_PEMX_ECC_ENA(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_ECC_ENA(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN81XX) && (a<=2))
        return 0x87e0c0000470ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN83XX) && (a<=3))
        return 0x87e0c0000470ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN88XX) && (a<=5))
        return 0x87e0c0000470ll + 0x1000000ll * ((a) & 0x7);
    __bdk_csr_fatal("PEMX_ECC_ENA", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_ECC_ENA(a) bdk_pemx_ecc_ena_t
#define bustype_BDK_PEMX_ECC_ENA(a) BDK_CSR_TYPE_RSL
#define basename_BDK_PEMX_ECC_ENA(a) "PEMX_ECC_ENA"
#define device_bar_BDK_PEMX_ECC_ENA(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_ECC_ENA(a) (a)
#define arguments_BDK_PEMX_ECC_ENA(a) (a),-1,-1,-1

/**
 * Register (RSL) pem#_ecc_synd_ctrl
 *
 * PEM ECC Syndrome Control Register
 * This register contains syndrome control for TLP FIFO ECC RAMs.
 */
union bdk_pemx_ecc_synd_ctrl
{
    uint64_t u;
    struct bdk_pemx_ecc_synd_ctrl_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_38_63        : 26;
        uint64_t qhdr_b1_syn           : 2;  /**< [ 37: 36](R/W) Syndrome flip bits for Core's Q HDR Bank1 RAM. */
        uint64_t qhdr_b0_syn           : 2;  /**< [ 35: 34](R/W) Syndrome flip bits for Core's Q HDR Bank0 RAM. */
        uint64_t rtry_syn              : 2;  /**< [ 33: 32](R/W) Syndrome flip bits for Core's RETRY RAM. */
        uint64_t reserved_22_31        : 10;
        uint64_t m2s_c_syn             : 2;  /**< [ 21: 20](R/W) Syndrome flip bits for M2S Control FIFO. */
        uint64_t m2s_d_syn             : 2;  /**< [ 19: 18](R/W) Syndrome flip bits for M2S Data FIFO. */
        uint64_t c_c_syn               : 2;  /**< [ 17: 16](R/W) Syndrome flip bits for TLP CPL control FIFO. */
        uint64_t c_d1_syn              : 2;  /**< [ 15: 14](R/W) Syndrome flip bits for TLP CPL data1 FIFO. */
        uint64_t c_d0_syn              : 2;  /**< [ 13: 12](R/W) Syndrome flip bits for TLP CPL data0 FIFO. */
        uint64_t n_c_syn               : 2;  /**< [ 11: 10](R/W) Syndrome flip bits for TLP NP control FIFO. */
        uint64_t n_d1_syn              : 2;  /**< [  9:  8](R/W) Syndrome flip bits for TLP NP data1 FIFO. */
        uint64_t n_d0_syn              : 2;  /**< [  7:  6](R/W) Syndrome flip bits for TLP NP data0 FIFO. */
        uint64_t p_c_syn               : 2;  /**< [  5:  4](R/W) Syndrome flip bits for TLP posted control FIFO. */
        uint64_t p_d1_syn              : 2;  /**< [  3:  2](R/W) Syndrome flip bits for TLP posted data1 FIFO. */
        uint64_t p_d0_syn              : 2;  /**< [  1:  0](R/W) Syndrome flip bits for TLP posted data0 FIFO. */
#else /* Word 0 - Little Endian */
        uint64_t p_d0_syn              : 2;  /**< [  1:  0](R/W) Syndrome flip bits for TLP posted data0 FIFO. */
        uint64_t p_d1_syn              : 2;  /**< [  3:  2](R/W) Syndrome flip bits for TLP posted data1 FIFO. */
        uint64_t p_c_syn               : 2;  /**< [  5:  4](R/W) Syndrome flip bits for TLP posted control FIFO. */
        uint64_t n_d0_syn              : 2;  /**< [  7:  6](R/W) Syndrome flip bits for TLP NP data0 FIFO. */
        uint64_t n_d1_syn              : 2;  /**< [  9:  8](R/W) Syndrome flip bits for TLP NP data1 FIFO. */
        uint64_t n_c_syn               : 2;  /**< [ 11: 10](R/W) Syndrome flip bits for TLP NP control FIFO. */
        uint64_t c_d0_syn              : 2;  /**< [ 13: 12](R/W) Syndrome flip bits for TLP CPL data0 FIFO. */
        uint64_t c_d1_syn              : 2;  /**< [ 15: 14](R/W) Syndrome flip bits for TLP CPL data1 FIFO. */
        uint64_t c_c_syn               : 2;  /**< [ 17: 16](R/W) Syndrome flip bits for TLP CPL control FIFO. */
        uint64_t m2s_d_syn             : 2;  /**< [ 19: 18](R/W) Syndrome flip bits for M2S Data FIFO. */
        uint64_t m2s_c_syn             : 2;  /**< [ 21: 20](R/W) Syndrome flip bits for M2S Control FIFO. */
        uint64_t reserved_22_31        : 10;
        uint64_t rtry_syn              : 2;  /**< [ 33: 32](R/W) Syndrome flip bits for Core's RETRY RAM. */
        uint64_t qhdr_b0_syn           : 2;  /**< [ 35: 34](R/W) Syndrome flip bits for Core's Q HDR Bank0 RAM. */
        uint64_t qhdr_b1_syn           : 2;  /**< [ 37: 36](R/W) Syndrome flip bits for Core's Q HDR Bank1 RAM. */
        uint64_t reserved_38_63        : 26;
#endif /* Word 0 - End */
    } s;
    struct bdk_pemx_ecc_synd_ctrl_cn81xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_38_63        : 26;
        uint64_t qhdr_b1_syn           : 2;  /**< [ 37: 36](R/W) Syndrome flip bits for Core's Q HDR Bank1 RAM. */
        uint64_t qhdr_b0_syn           : 2;  /**< [ 35: 34](R/W) Syndrome flip bits for Core's Q HDR Bank0 RAM. */
        uint64_t rtry_syn              : 2;  /**< [ 33: 32](R/W) Syndrome flip bits for Core's RETRY RAM. */
        uint64_t reserved_18_31        : 14;
        uint64_t c_c_syn               : 2;  /**< [ 17: 16](R/W) Syndrome flip bits for TLP CPL control FIFO. */
        uint64_t c_d1_syn              : 2;  /**< [ 15: 14](R/W) Syndrome flip bits for TLP CPL data1 FIFO. */
        uint64_t c_d0_syn              : 2;  /**< [ 13: 12](R/W) Syndrome flip bits for TLP CPL data0 FIFO. */
        uint64_t n_c_syn               : 2;  /**< [ 11: 10](R/W) Syndrome flip bits for TLP NP control FIFO. */
        uint64_t n_d1_syn              : 2;  /**< [  9:  8](R/W) Syndrome flip bits for TLP NP data1 FIFO. */
        uint64_t n_d0_syn              : 2;  /**< [  7:  6](R/W) Syndrome flip bits for TLP NP data0 FIFO. */
        uint64_t p_c_syn               : 2;  /**< [  5:  4](R/W) Syndrome flip bits for TLP posted control FIFO. */
        uint64_t p_d1_syn              : 2;  /**< [  3:  2](R/W) Syndrome flip bits for TLP posted data1 FIFO. */
        uint64_t p_d0_syn              : 2;  /**< [  1:  0](R/W) Syndrome flip bits for TLP posted data0 FIFO. */
#else /* Word 0 - Little Endian */
        uint64_t p_d0_syn              : 2;  /**< [  1:  0](R/W) Syndrome flip bits for TLP posted data0 FIFO. */
        uint64_t p_d1_syn              : 2;  /**< [  3:  2](R/W) Syndrome flip bits for TLP posted data1 FIFO. */
        uint64_t p_c_syn               : 2;  /**< [  5:  4](R/W) Syndrome flip bits for TLP posted control FIFO. */
        uint64_t n_d0_syn              : 2;  /**< [  7:  6](R/W) Syndrome flip bits for TLP NP data0 FIFO. */
        uint64_t n_d1_syn              : 2;  /**< [  9:  8](R/W) Syndrome flip bits for TLP NP data1 FIFO. */
        uint64_t n_c_syn               : 2;  /**< [ 11: 10](R/W) Syndrome flip bits for TLP NP control FIFO. */
        uint64_t c_d0_syn              : 2;  /**< [ 13: 12](R/W) Syndrome flip bits for TLP CPL data0 FIFO. */
        uint64_t c_d1_syn              : 2;  /**< [ 15: 14](R/W) Syndrome flip bits for TLP CPL data1 FIFO. */
        uint64_t c_c_syn               : 2;  /**< [ 17: 16](R/W) Syndrome flip bits for TLP CPL control FIFO. */
        uint64_t reserved_18_31        : 14;
        uint64_t rtry_syn              : 2;  /**< [ 33: 32](R/W) Syndrome flip bits for Core's RETRY RAM. */
        uint64_t qhdr_b0_syn           : 2;  /**< [ 35: 34](R/W) Syndrome flip bits for Core's Q HDR Bank0 RAM. */
        uint64_t qhdr_b1_syn           : 2;  /**< [ 37: 36](R/W) Syndrome flip bits for Core's Q HDR Bank1 RAM. */
        uint64_t reserved_38_63        : 26;
#endif /* Word 0 - End */
    } cn81xx;
    /* struct bdk_pemx_ecc_synd_ctrl_cn81xx cn88xx; */
    struct bdk_pemx_ecc_synd_ctrl_cn83xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_22_63        : 42;
        uint64_t m2s_c_syn             : 2;  /**< [ 21: 20](R/W) Syndrome flip bits for M2S Control FIFO. */
        uint64_t m2s_d_syn             : 2;  /**< [ 19: 18](R/W) Syndrome flip bits for M2S Data FIFO. */
        uint64_t c_c_syn               : 2;  /**< [ 17: 16](R/W) Syndrome flip bits for TLP CPL control FIFO. */
        uint64_t c_d1_syn              : 2;  /**< [ 15: 14](R/W) Syndrome flip bits for TLP CPL data1 FIFO. */
        uint64_t c_d0_syn              : 2;  /**< [ 13: 12](R/W) Syndrome flip bits for TLP CPL data0 FIFO. */
        uint64_t n_c_syn               : 2;  /**< [ 11: 10](R/W) Syndrome flip bits for TLP NP control FIFO. */
        uint64_t n_d1_syn              : 2;  /**< [  9:  8](R/W) Syndrome flip bits for TLP NP data1 FIFO. */
        uint64_t n_d0_syn              : 2;  /**< [  7:  6](R/W) Syndrome flip bits for TLP NP data0 FIFO. */
        uint64_t p_c_syn               : 2;  /**< [  5:  4](R/W) Syndrome flip bits for TLP posted control FIFO. */
        uint64_t p_d1_syn              : 2;  /**< [  3:  2](R/W) Syndrome flip bits for TLP posted data1 FIFO. */
        uint64_t p_d0_syn              : 2;  /**< [  1:  0](R/W) Syndrome flip bits for TLP posted data0 FIFO. */
#else /* Word 0 - Little Endian */
        uint64_t p_d0_syn              : 2;  /**< [  1:  0](R/W) Syndrome flip bits for TLP posted data0 FIFO. */
        uint64_t p_d1_syn              : 2;  /**< [  3:  2](R/W) Syndrome flip bits for TLP posted data1 FIFO. */
        uint64_t p_c_syn               : 2;  /**< [  5:  4](R/W) Syndrome flip bits for TLP posted control FIFO. */
        uint64_t n_d0_syn              : 2;  /**< [  7:  6](R/W) Syndrome flip bits for TLP NP data0 FIFO. */
        uint64_t n_d1_syn              : 2;  /**< [  9:  8](R/W) Syndrome flip bits for TLP NP data1 FIFO. */
        uint64_t n_c_syn               : 2;  /**< [ 11: 10](R/W) Syndrome flip bits for TLP NP control FIFO. */
        uint64_t c_d0_syn              : 2;  /**< [ 13: 12](R/W) Syndrome flip bits for TLP CPL data0 FIFO. */
        uint64_t c_d1_syn              : 2;  /**< [ 15: 14](R/W) Syndrome flip bits for TLP CPL data1 FIFO. */
        uint64_t c_c_syn               : 2;  /**< [ 17: 16](R/W) Syndrome flip bits for TLP CPL control FIFO. */
        uint64_t m2s_d_syn             : 2;  /**< [ 19: 18](R/W) Syndrome flip bits for M2S Data FIFO. */
        uint64_t m2s_c_syn             : 2;  /**< [ 21: 20](R/W) Syndrome flip bits for M2S Control FIFO. */
        uint64_t reserved_22_63        : 42;
#endif /* Word 0 - End */
    } cn83xx;
};
typedef union bdk_pemx_ecc_synd_ctrl bdk_pemx_ecc_synd_ctrl_t;

static inline uint64_t BDK_PEMX_ECC_SYND_CTRL(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_ECC_SYND_CTRL(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN81XX) && (a<=2))
        return 0x87e0c0000478ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN83XX) && (a<=3))
        return 0x87e0c0000478ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN88XX) && (a<=5))
        return 0x87e0c0000478ll + 0x1000000ll * ((a) & 0x7);
    __bdk_csr_fatal("PEMX_ECC_SYND_CTRL", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_ECC_SYND_CTRL(a) bdk_pemx_ecc_synd_ctrl_t
#define bustype_BDK_PEMX_ECC_SYND_CTRL(a) BDK_CSR_TYPE_RSL
#define basename_BDK_PEMX_ECC_SYND_CTRL(a) "PEMX_ECC_SYND_CTRL"
#define device_bar_BDK_PEMX_ECC_SYND_CTRL(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_ECC_SYND_CTRL(a) (a)
#define arguments_BDK_PEMX_ECC_SYND_CTRL(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_eco
 *
 * INTERNAL: PEM ECO Register
 *
 * This register is not accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on MAC reset.
 */
union bdk_pemx_eco
{
    uint64_t u;
    struct bdk_pemx_eco_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_8_63         : 56;
        uint64_t eco_rw                : 8;  /**< [  7:  0](R/W) Internal:
                                                                 Reserved for ECO usage. */
#else /* Word 0 - Little Endian */
        uint64_t eco_rw                : 8;  /**< [  7:  0](R/W) Internal:
                                                                 Reserved for ECO usage. */
        uint64_t reserved_8_63         : 56;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_eco_s cn; */
};
typedef union bdk_pemx_eco bdk_pemx_eco_t;

static inline uint64_t BDK_PEMX_ECO(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_ECO(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN83XX) && (a<=3))
        return 0x87e0c0000010ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e0000000008ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_ECO", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_ECO(a) bdk_pemx_eco_t
#define bustype_BDK_PEMX_ECO(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_ECO(a) "PEMX_ECO"
#define device_bar_BDK_PEMX_ECO(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_ECO(a) (a)
#define arguments_BDK_PEMX_ECO(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_end_merge
 *
 * PEM End Merge Register
 * Any access (read or write) to this register over NCBO will create a merging barrier
 * for both the write and read streams within PEM outbound pipelines such that no NCBO
 * reads or writes received after this register's access will merge with any NCBO accesses
 * that occurred prior to this register's access.  Note that RSL accesses to this register
 * will have no effect on merging.
 *
 * This register is not accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on PEM domain reset.
 */
union bdk_pemx_end_merge
{
    uint64_t u;
    struct bdk_pemx_end_merge_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_0_63         : 64;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0_63         : 64;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_end_merge_s cn; */
};
typedef union bdk_pemx_end_merge bdk_pemx_end_merge_t;

static inline uint64_t BDK_PEMX_END_MERGE(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_END_MERGE(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e0000000178ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_END_MERGE", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_END_MERGE(a) bdk_pemx_end_merge_t
#define bustype_BDK_PEMX_END_MERGE(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_END_MERGE(a) "PEMX_END_MERGE"
#define device_bar_BDK_PEMX_END_MERGE(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_END_MERGE(a) (a)
#define arguments_BDK_PEMX_END_MERGE(a) (a),-1,-1,-1

/**
 * Register (RSL) pem#_erom#
 *
 * PEM Expansion ROM Registers
 * This register accesses the external EEPROM.
 */
union bdk_pemx_eromx
{
    uint64_t u;
    struct bdk_pemx_eromx_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t erom                  : 64; /**< [ 63:  0](R/W/H) PCIe express read transactions to BAR3 (through PCIEEP()_CFG012) will appear as
                                                                 8-byte RSL reads to this register.

                                                                 Although 512 KB is advertised from PCIEEP()_CFG012, only the first 448 KB is
                                                                 actually accessible, and reads above 448 KB will return zeros, writes are NOP.

                                                                 Accessible through PEM2 if EP PEM0 is an RC, otherwise accessible through PEM0.
                                                                 Access from a PEM that doesn't own the EEPROM will return fault. */
#else /* Word 0 - Little Endian */
        uint64_t erom                  : 64; /**< [ 63:  0](R/W/H) PCIe express read transactions to BAR3 (through PCIEEP()_CFG012) will appear as
                                                                 8-byte RSL reads to this register.

                                                                 Although 512 KB is advertised from PCIEEP()_CFG012, only the first 448 KB is
                                                                 actually accessible, and reads above 448 KB will return zeros, writes are NOP.

                                                                 Accessible through PEM2 if EP PEM0 is an RC, otherwise accessible through PEM0.
                                                                 Access from a PEM that doesn't own the EEPROM will return fault. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_eromx_s cn; */
};
typedef union bdk_pemx_eromx bdk_pemx_eromx_t;

static inline uint64_t BDK_PEMX_EROMX(unsigned long a, unsigned long b) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_EROMX(unsigned long a, unsigned long b)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN83XX) && ((a<=3) && (b<=65535)))
        return 0x87e0c0080000ll + 0x1000000ll * ((a) & 0x3) + 8ll * ((b) & 0xffff);
    __bdk_csr_fatal("PEMX_EROMX", 2, a, b, 0, 0);
}

#define typedef_BDK_PEMX_EROMX(a,b) bdk_pemx_eromx_t
#define bustype_BDK_PEMX_EROMX(a,b) BDK_CSR_TYPE_RSL
#define basename_BDK_PEMX_EROMX(a,b) "PEMX_EROMX"
#define device_bar_BDK_PEMX_EROMX(a,b) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_EROMX(a,b) (a)
#define arguments_BDK_PEMX_EROMX(a,b) (a),(b),-1,-1

/**
 * Register (NCB) pem#_erom_bar_addr
 *
 * PEM EROM BAR Address Register
 * This register configures PEM EROM BAR accesses targeted at NCBI.
 * Fields in this register are only used when PEM()_EBUS_CTL[EROM_SEL]
 * is clear and the PEM is configured for EP mode.
 *
 * This register is not accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on PEM domain reset.
 */
union bdk_pemx_erom_bar_addr
{
    uint64_t u;
    struct bdk_pemx_erom_bar_addr_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t wvirt                 : 1;  /**< [ 63: 63](R/W) Virtual:
                                                                   0 = [RD_ADDR] is a physical addresses.
                                                                   1 = [RD_ADDR] is a virtual address. */
        uint64_t pspi_en               : 1;  /**< [ 62: 62](R/W) If PEM()_EBUS_CTL[EROM_SEL] is clear, PEM is configured for EP mode, and
                                                                 [PSPI_EN] is set, this bit directs EROM BAR hits to a private bus connected
                                                                 to the PSPI interface in MIO rather than NCB. */
        uint64_t reserved_53_61        : 9;
        uint64_t rd_addr               : 37; /**< [ 52: 16](R/W) Base address for PEM EROM BAR transactions that is appended to the offset. This
                                                                 field is only used when PEM()_EBUS_CTL[EROM_SEL] is clear, and PEM is configured for EP mode. */
        uint64_t reserved_0_15         : 16;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0_15         : 16;
        uint64_t rd_addr               : 37; /**< [ 52: 16](R/W) Base address for PEM EROM BAR transactions that is appended to the offset. This
                                                                 field is only used when PEM()_EBUS_CTL[EROM_SEL] is clear, and PEM is configured for EP mode. */
        uint64_t reserved_53_61        : 9;
        uint64_t pspi_en               : 1;  /**< [ 62: 62](R/W) If PEM()_EBUS_CTL[EROM_SEL] is clear, PEM is configured for EP mode, and
                                                                 [PSPI_EN] is set, this bit directs EROM BAR hits to a private bus connected
                                                                 to the PSPI interface in MIO rather than NCB. */
        uint64_t wvirt                 : 1;  /**< [ 63: 63](R/W) Virtual:
                                                                   0 = [RD_ADDR] is a physical addresses.
                                                                   1 = [RD_ADDR] is a virtual address. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_erom_bar_addr_s cn; */
};
typedef union bdk_pemx_erom_bar_addr bdk_pemx_erom_bar_addr_t;

static inline uint64_t BDK_PEMX_EROM_BAR_ADDR(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_EROM_BAR_ADDR(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e0000000150ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_EROM_BAR_ADDR", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_EROM_BAR_ADDR(a) bdk_pemx_erom_bar_addr_t
#define bustype_BDK_PEMX_EROM_BAR_ADDR(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_EROM_BAR_ADDR(a) "PEMX_EROM_BAR_ADDR"
#define device_bar_BDK_PEMX_EROM_BAR_ADDR(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_EROM_BAR_ADDR(a) (a)
#define arguments_BDK_PEMX_EROM_BAR_ADDR(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_flr_ctl
 *
 * PEM FLR Control Register
 * This register provides function level reset controls.
 *
 * This register is not accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on MAC cold reset.
 */
union bdk_pemx_flr_ctl
{
    uint64_t u;
    struct bdk_pemx_flr_ctl_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_6_63         : 58;
        uint64_t chge                  : 1;  /**< [  5:  5](R/W) When set, the default 25 ms expiration of the function level reset
                                                                 global counter can be changed. */
        uint64_t inc                   : 1;  /**< [  4:  4](R/W) When [CHGE] is set, this bit determines if the 25 ms expiration of the function
                                                                 level reset global counter will be increased (set) or decreased (not set). */
        uint64_t delta                 : 2;  /**< [  3:  2](R/W) When [CHGE] is set, this field determines the delta time to increase/decrease
                                                                 the 25 ms expiration of the function level reset global counter.
                                                                 0x0 = 1 ms.
                                                                 0x1 = 2 ms.
                                                                 0x2 = 4 ms.
                                                                 0x3 = 8 ms. */
        uint64_t timer_ctl             : 2;  /**< [  1:  0](R/W) Each FLR indication can be cleared within 66-99 ms by use of a timer. Controls how
                                                                 FLR indication is cleared:
                                                                 0x0 = PEM()_FLR_REQ* can be used to clear the FLR indication, if not written before
                                                                 timer expires, the timer will auto-clear FLR.
                                                                 0x1 = PEM()_FLR_REQ* must be used to clear the FLR indication, timers are not used.
                                                                 0x2 = Only timers are used, PEM()_FLR_REQ* is ignored.
                                                                 0x3 = Reserved. */
#else /* Word 0 - Little Endian */
        uint64_t timer_ctl             : 2;  /**< [  1:  0](R/W) Each FLR indication can be cleared within 66-99 ms by use of a timer. Controls how
                                                                 FLR indication is cleared:
                                                                 0x0 = PEM()_FLR_REQ* can be used to clear the FLR indication, if not written before
                                                                 timer expires, the timer will auto-clear FLR.
                                                                 0x1 = PEM()_FLR_REQ* must be used to clear the FLR indication, timers are not used.
                                                                 0x2 = Only timers are used, PEM()_FLR_REQ* is ignored.
                                                                 0x3 = Reserved. */
        uint64_t delta                 : 2;  /**< [  3:  2](R/W) When [CHGE] is set, this field determines the delta time to increase/decrease
                                                                 the 25 ms expiration of the function level reset global counter.
                                                                 0x0 = 1 ms.
                                                                 0x1 = 2 ms.
                                                                 0x2 = 4 ms.
                                                                 0x3 = 8 ms. */
        uint64_t inc                   : 1;  /**< [  4:  4](R/W) When [CHGE] is set, this bit determines if the 25 ms expiration of the function
                                                                 level reset global counter will be increased (set) or decreased (not set). */
        uint64_t chge                  : 1;  /**< [  5:  5](R/W) When set, the default 25 ms expiration of the function level reset
                                                                 global counter can be changed. */
        uint64_t reserved_6_63         : 58;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_flr_ctl_s cn; */
};
typedef union bdk_pemx_flr_ctl bdk_pemx_flr_ctl_t;

static inline uint64_t BDK_PEMX_FLR_CTL(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_FLR_CTL(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e0000000068ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_FLR_CTL", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_FLR_CTL(a) bdk_pemx_flr_ctl_t
#define bustype_BDK_PEMX_FLR_CTL(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_FLR_CTL(a) "PEMX_FLR_CTL"
#define device_bar_BDK_PEMX_FLR_CTL(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_FLR_CTL(a) (a)
#define arguments_BDK_PEMX_FLR_CTL(a) (a),-1,-1,-1

/**
 * Register (RSL) pem#_flr_glblcnt_ctl
 *
 * PEM FLR Global Count Control Register
 * Function level reset global counter control.
 */
union bdk_pemx_flr_glblcnt_ctl
{
    uint64_t u;
    struct bdk_pemx_flr_glblcnt_ctl_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_4_63         : 60;
        uint64_t chge                  : 1;  /**< [  3:  3](R/W) When set, the default 25ms expiration of the function level reset
                                                                 global counter can be changed. */
        uint64_t inc                   : 1;  /**< [  2:  2](R/W) When CHGE is set, this bit determines if the 25ms expiration of the function
                                                                 level reset global counter will be increased (set) or decreased (not set). */
        uint64_t delta                 : 2;  /**< [  1:  0](R/W) When CHGE is set, this field determines the delta time to increase/decrease
                                                                 the 25 ms expiration of the function level reset global counter.
                                                                 0x0 = 1 ms.
                                                                 0x1 = 2 ms.
                                                                 0x2 = 4 ms.
                                                                 0x3 = 8 ms. */
#else /* Word 0 - Little Endian */
        uint64_t delta                 : 2;  /**< [  1:  0](R/W) When CHGE is set, this field determines the delta time to increase/decrease
                                                                 the 25 ms expiration of the function level reset global counter.
                                                                 0x0 = 1 ms.
                                                                 0x1 = 2 ms.
                                                                 0x2 = 4 ms.
                                                                 0x3 = 8 ms. */
        uint64_t inc                   : 1;  /**< [  2:  2](R/W) When CHGE is set, this bit determines if the 25ms expiration of the function
                                                                 level reset global counter will be increased (set) or decreased (not set). */
        uint64_t chge                  : 1;  /**< [  3:  3](R/W) When set, the default 25ms expiration of the function level reset
                                                                 global counter can be changed. */
        uint64_t reserved_4_63         : 60;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_flr_glblcnt_ctl_s cn; */
};
typedef union bdk_pemx_flr_glblcnt_ctl bdk_pemx_flr_glblcnt_ctl_t;

static inline uint64_t BDK_PEMX_FLR_GLBLCNT_CTL(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_FLR_GLBLCNT_CTL(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN83XX) && (a<=3))
        return 0x87e0c0000210ll + 0x1000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_FLR_GLBLCNT_CTL", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_FLR_GLBLCNT_CTL(a) bdk_pemx_flr_glblcnt_ctl_t
#define bustype_BDK_PEMX_FLR_GLBLCNT_CTL(a) BDK_CSR_TYPE_RSL
#define basename_BDK_PEMX_FLR_GLBLCNT_CTL(a) "PEMX_FLR_GLBLCNT_CTL"
#define device_bar_BDK_PEMX_FLR_GLBLCNT_CTL(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_FLR_GLBLCNT_CTL(a) (a)
#define arguments_BDK_PEMX_FLR_GLBLCNT_CTL(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_flr_pf#_stopreq
 *
 * PEM PF Stop Request Register
 * PF function level reset stop outbound requests register.
 * Hardware automatically sets the STOPREQ bit for the PF when it enters a
 * function level reset (FLR).  Software is responsible for clearing the STOPREQ
 * bit but must not do so prior to hardware taking down the FLR, which could be
 * as long as 100 ms.  It may be appropriate for software to wait longer before clearing
 * STOPREQ, software may need to drain deep DPI queues for example.
 * Whenever PEM receives a PF or child VF request mastered by {ProductLine} over NCBO/EBUS
 * (i.e. P or NP), when STOPREQ is set for the function, PEM will discard the outgoing request
 * before sending it to the PCIe core.  If a NP, PEM will schedule an immediate completion
 * with error for the request - no timeout is required. STOPREQ mimics the behavior of
 * PCIEEP_CMD[ME] for outbound requests that will master the PCIe bus (P and NP).
 *
 * STOPREQ has no effect on NCBI/incoming EBUS traffic.
 *
 * STOPREQ will have no effect on completions returned by CNXXXX over NCBO/EBUS.
 *
 * When a PEM()_FLR_PF()_STOPREQ is set, none of the associated
 * PEM()_FLR_VF()_STOPREQ[VF_STOPREQ] will be set.
 *
 * STOPREQ is reset when the MAC is reset, and is not reset after a chip soft reset.
 *
 * This register is not accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on MAC reset.
 */
union bdk_pemx_flr_pfx_stopreq
{
    uint64_t u;
    struct bdk_pemx_flr_pfx_stopreq_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_1_63         : 63;
        uint64_t pf_stopreq            : 1;  /**< [  0:  0](R/W1C/H) PF STOPREQ bit. */
#else /* Word 0 - Little Endian */
        uint64_t pf_stopreq            : 1;  /**< [  0:  0](R/W1C/H) PF STOPREQ bit. */
        uint64_t reserved_1_63         : 63;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_flr_pfx_stopreq_s cn; */
};
typedef union bdk_pemx_flr_pfx_stopreq bdk_pemx_flr_pfx_stopreq_t;

static inline uint64_t BDK_PEMX_FLR_PFX_STOPREQ(unsigned long a, unsigned long b) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_FLR_PFX_STOPREQ(unsigned long a, unsigned long b)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && ((a<=3) && (b<=15)))
        return 0x8e0000000c00ll + 0x1000000000ll * ((a) & 0x3) + 8ll * ((b) & 0xf);
    __bdk_csr_fatal("PEMX_FLR_PFX_STOPREQ", 2, a, b, 0, 0);
}

#define typedef_BDK_PEMX_FLR_PFX_STOPREQ(a,b) bdk_pemx_flr_pfx_stopreq_t
#define bustype_BDK_PEMX_FLR_PFX_STOPREQ(a,b) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_FLR_PFX_STOPREQ(a,b) "PEMX_FLR_PFX_STOPREQ"
#define device_bar_BDK_PEMX_FLR_PFX_STOPREQ(a,b) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_FLR_PFX_STOPREQ(a,b) (a)
#define arguments_BDK_PEMX_FLR_PFX_STOPREQ(a,b) (a),(b),-1,-1

/**
 * Register (RSL) pem#_flr_pf0_vf_stopreq
 *
 * PEM PF0 Virtual Function Stop Request Lower Register
 * PF0 virtual function level reset stop outbound requests register.
 * Hardware automatically sets the STOPREQ bit for the VF when it enters a
 * function level reset (FLR).  Software is responsible for clearing the STOPREQ
 * bit but must not do so prior to hardware taking down the FLR, which could be
 * as long as 100 ms.  It may be appropriate for software to wait longer before clearing
 * STOPREQ, software may need to drain deep DPI queues for example.
 *
 * Whenever PEM receives a request mastered by {ProductLine} over S2M (i.e. P or NP),
 * when STOPREQ is set for the function, PEM will discard the outgoing request
 * before sending it to the PCIe core.  If a NP, PEM will schedule an immediate
 * SWI_RSP_ERROR completion for the request - no timeout is required.
 * In both cases, the PEM()_INT_SUM[BMD_E] bit will be set and a error
 * interrupt is generated.
 *
 * STOPREQ mimics the behavior of PCIEEPVF()_CFG001.ME for outbound requests that will
 * master the PCIe bus (P and NP).
 *
 * Note that STOPREQ will have no effect on completions returned by {ProductLine} over the S2M.
 *
 * Note that STOPREQ will have no effect on M2S traffic.
 */
union bdk_pemx_flr_pf0_vf_stopreq
{
    uint64_t u;
    struct bdk_pemx_flr_pf0_vf_stopreq_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t vf_stopreq_lo         : 64; /**< [ 63:  0](R/W1C/H) STOPREQ for the 64 VFs in PF0. */
#else /* Word 0 - Little Endian */
        uint64_t vf_stopreq_lo         : 64; /**< [ 63:  0](R/W1C/H) STOPREQ for the 64 VFs in PF0. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_flr_pf0_vf_stopreq_s cn; */
};
typedef union bdk_pemx_flr_pf0_vf_stopreq bdk_pemx_flr_pf0_vf_stopreq_t;

static inline uint64_t BDK_PEMX_FLR_PF0_VF_STOPREQ(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_FLR_PF0_VF_STOPREQ(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN83XX) && (a<=3))
        return 0x87e0c0000220ll + 0x1000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_FLR_PF0_VF_STOPREQ", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_FLR_PF0_VF_STOPREQ(a) bdk_pemx_flr_pf0_vf_stopreq_t
#define bustype_BDK_PEMX_FLR_PF0_VF_STOPREQ(a) BDK_CSR_TYPE_RSL
#define basename_BDK_PEMX_FLR_PF0_VF_STOPREQ(a) "PEMX_FLR_PF0_VF_STOPREQ"
#define device_bar_BDK_PEMX_FLR_PF0_VF_STOPREQ(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_FLR_PF0_VF_STOPREQ(a) (a)
#define arguments_BDK_PEMX_FLR_PF0_VF_STOPREQ(a) (a),-1,-1,-1

/**
 * Register (RSL) pem#_flr_pf_stopreq
 *
 * PEM PF Stop Request Register
 * PF function level reset stop outbound requests register.
 * Hardware automatically sets the STOPREQ bit for the PF when it enters a
 * function level reset (FLR).  Software is responsible for clearing the STOPREQ
 * bit but must not do so prior to hardware taking down the FLR, which could be
 * as long as 100 ms.  It may be appropriate for software to wait longer before clearing
 * STOPREQ, software may need to drain deep DPI queues for example.
 * Whenever PEM receives a PF or child VF request mastered by {ProductLine} over S2M (i.e. P or
 * NP),
 * when STOPREQ is set for the function, PEM will discard the outgoing request
 * before sending it to the PCIe core.  If a NP, PEM will schedule an immediate
 * SWI_RSP_ERROR completion for the request - no timeout is required.
 * In both cases, the PEM(0..3)_INT_SUM[PBMD_E] bit will be set and a error
 * interrupt is generated.
 * STOPREQ mimics the behavior of PCIEEP()_CFG001.ME for outbound requests that will
 * master the PCIe bus (P and NP).
 *
 * STOPREQ has no effect on M2S traffic.
 *
 * STOPREQ will have no effect on completions returned by CNXXXX over the S2M.
 *
 * When a PF()_STOPREQ is set, none of the associated
 * PEM()_FLR_PF0_VF_STOPREQ[VF_STOPREQ] will be set.
 *
 * STOPREQ is reset when the MAC is reset, and is not reset after a chip soft reset.
 */
union bdk_pemx_flr_pf_stopreq
{
    uint64_t u;
    struct bdk_pemx_flr_pf_stopreq_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_1_63         : 63;
        uint64_t pf0_stopreq           : 1;  /**< [  0:  0](R/W1C/H) PF0 STOPREQ bit. */
#else /* Word 0 - Little Endian */
        uint64_t pf0_stopreq           : 1;  /**< [  0:  0](R/W1C/H) PF0 STOPREQ bit. */
        uint64_t reserved_1_63         : 63;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_flr_pf_stopreq_s cn; */
};
typedef union bdk_pemx_flr_pf_stopreq bdk_pemx_flr_pf_stopreq_t;

static inline uint64_t BDK_PEMX_FLR_PF_STOPREQ(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_FLR_PF_STOPREQ(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN83XX) && (a<=3))
        return 0x87e0c0000218ll + 0x1000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_FLR_PF_STOPREQ", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_FLR_PF_STOPREQ(a) bdk_pemx_flr_pf_stopreq_t
#define bustype_BDK_PEMX_FLR_PF_STOPREQ(a) BDK_CSR_TYPE_RSL
#define basename_BDK_PEMX_FLR_PF_STOPREQ(a) "PEMX_FLR_PF_STOPREQ"
#define device_bar_BDK_PEMX_FLR_PF_STOPREQ(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_FLR_PF_STOPREQ(a) (a)
#define arguments_BDK_PEMX_FLR_PF_STOPREQ(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_flr_stopreq_ctl
 *
 * PEM FLR Global Count Control Register
 * Function level reset STOPREQ control register.
 *
 * This register is not accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on MAC cold reset.
 */
union bdk_pemx_flr_stopreq_ctl
{
    uint64_t u;
    struct bdk_pemx_flr_stopreq_ctl_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_1_63         : 63;
        uint64_t stopreqclr            : 1;  /**< [  0:  0](R/W) When [STOPREQCLR] is clear, only software (and reset) can clear
                                                                 PEM()_FLR_PF_STOPREQ[STOPREQ] and PEM()_FLR_PF0_VF_STOPREQ[STOPREQ]
                                                                 bits. When STOPREQCLR is set, PEM hardware
                                                                 also clears the STOPREQ bit when PEM completes an FLR to the PCIe core. In the
                                                                 case of a VF, only one STOPREQ bit gets cleared upon each FLR ack when
                                                                 STOPREQCLR mode bit is set. The srst will assert upon a PF
                                                                 FLR, and srst could be used to reset all STOPREQ bits regardless of
                                                                 STOPREQCLR. Otherwise (e.g. {ProductLine}), where a PF FLR does not
                                                                 assert srst. */
#else /* Word 0 - Little Endian */
        uint64_t stopreqclr            : 1;  /**< [  0:  0](R/W) When [STOPREQCLR] is clear, only software (and reset) can clear
                                                                 PEM()_FLR_PF_STOPREQ[STOPREQ] and PEM()_FLR_PF0_VF_STOPREQ[STOPREQ]
                                                                 bits. When STOPREQCLR is set, PEM hardware
                                                                 also clears the STOPREQ bit when PEM completes an FLR to the PCIe core. In the
                                                                 case of a VF, only one STOPREQ bit gets cleared upon each FLR ack when
                                                                 STOPREQCLR mode bit is set. The srst will assert upon a PF
                                                                 FLR, and srst could be used to reset all STOPREQ bits regardless of
                                                                 STOPREQCLR. Otherwise (e.g. {ProductLine}), where a PF FLR does not
                                                                 assert srst. */
        uint64_t reserved_1_63         : 63;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_flr_stopreq_ctl_s cn8; */
    struct bdk_pemx_flr_stopreq_ctl_cn9
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_1_63         : 63;
        uint64_t stopreqclr            : 1;  /**< [  0:  0](R/W) Stop request clear behavior.

                                                                 0 = Only software (and reset) can clear PEM()_FLR_PF()_STOPREQ[PF_STOPREQ] and
                                                                 PEM()_FLR_VF()_STOPREQ[VF_STOPREQ] bits.

                                                                 1 = PEM hardware also clears the STOPREQ bit when PEM completes an FLR to the
                                                                 PCIe core. In the case of a VF, only one STOPREQ bit gets cleared upon each FLR
                                                                 ack when [STOPREQCLR] is set.

                                                                 The srst will assert upon a PF FLR, and srst could be used to reset all STOPREQ
                                                                 bits regardless of [STOPREQCLR]. Otherwise, a PF FLR does not assert srst. */
#else /* Word 0 - Little Endian */
        uint64_t stopreqclr            : 1;  /**< [  0:  0](R/W) Stop request clear behavior.

                                                                 0 = Only software (and reset) can clear PEM()_FLR_PF()_STOPREQ[PF_STOPREQ] and
                                                                 PEM()_FLR_VF()_STOPREQ[VF_STOPREQ] bits.

                                                                 1 = PEM hardware also clears the STOPREQ bit when PEM completes an FLR to the
                                                                 PCIe core. In the case of a VF, only one STOPREQ bit gets cleared upon each FLR
                                                                 ack when [STOPREQCLR] is set.

                                                                 The srst will assert upon a PF FLR, and srst could be used to reset all STOPREQ
                                                                 bits regardless of [STOPREQCLR]. Otherwise, a PF FLR does not assert srst. */
        uint64_t reserved_1_63         : 63;
#endif /* Word 0 - End */
    } cn9;
};
typedef union bdk_pemx_flr_stopreq_ctl bdk_pemx_flr_stopreq_ctl_t;

static inline uint64_t BDK_PEMX_FLR_STOPREQ_CTL(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_FLR_STOPREQ_CTL(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN83XX) && (a<=3))
        return 0x87e0c0000238ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e0000000070ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_FLR_STOPREQ_CTL", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_FLR_STOPREQ_CTL(a) bdk_pemx_flr_stopreq_ctl_t
#define bustype_BDK_PEMX_FLR_STOPREQ_CTL(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_FLR_STOPREQ_CTL(a) "PEMX_FLR_STOPREQ_CTL"
#define device_bar_BDK_PEMX_FLR_STOPREQ_CTL(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_FLR_STOPREQ_CTL(a) (a)
#define arguments_BDK_PEMX_FLR_STOPREQ_CTL(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_flr_vf#_stopreq
 *
 * PEM VF Stop Request Register
 * VFI 0-239 virtual function level reset stop outbound requests register.
 * Hardware automatically sets the STOPREQ bit for the VF when it enters a
 * function level reset (FLR).  Software is responsible for clearing the STOPREQ
 * bit but must not do so prior to hardware taking down the FLR, which could be
 * as long as 100 ms.  It may be appropriate for software to wait longer before clearing
 * STOPREQ, software may need to drain deep DPI queues for example.
 *
 * Whenever PEM receives a request mastered by {ProductLine} over NCBO/EBUS (i.e. P or NP),
 * when STOPREQ is set for the function, PEM will discard the outgoing request
 * before sending it to the PCIe core.  If a NP, PEM will schedule an immediate
 * cpl w/error for the request - no timeout is required.
 * In both cases, the PEM()_DBG_INFO[BMD_E] bit will be set.
 *
 * The index into this array is referred to as a "VFI" and will need to be calculated
 * by software based on the number of VFs assigned to each PF.  {PF0,VF0} is VFI0 and
 * for this VF, bit [0] would be used.  {PF1,VF0} is PCIEEP_SRIOV_VFS[IVF] for PF0.
 * In general, {PFx,VFy} is determined by SUM(PF0..PF(x-1))(PCIEEP_SRIOV_VFS[IVF]) + y.
 *
 * STOPREQ mimics the behavior of PCIEEPVF_CMD[ME] for outbound requests that will
 * master the PCIe bus (P and NP).
 *
 * Note that STOPREQ will have no effect on completions returned by {ProductLine} over the NCBO/EBUS.
 *
 * Note that STOPREQ will have no effect on NCBI or incoming EBUS traffic.
 *
 * This register is not accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on MAC reset.
 */
union bdk_pemx_flr_vfx_stopreq
{
    uint64_t u;
    struct bdk_pemx_flr_vfx_stopreq_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t vf_stopreq            : 64; /**< [ 63:  0](R/W1C/H) STOPREQ for the pool of 240 VFs in shared by the 16 PFs.
                                                                 Each bit corresponds to one of the NVF virtual functions. */
#else /* Word 0 - Little Endian */
        uint64_t vf_stopreq            : 64; /**< [ 63:  0](R/W1C/H) STOPREQ for the pool of 240 VFs in shared by the 16 PFs.
                                                                 Each bit corresponds to one of the NVF virtual functions. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_flr_vfx_stopreq_s cn; */
};
typedef union bdk_pemx_flr_vfx_stopreq bdk_pemx_flr_vfx_stopreq_t;

static inline uint64_t BDK_PEMX_FLR_VFX_STOPREQ(unsigned long a, unsigned long b) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_FLR_VFX_STOPREQ(unsigned long a, unsigned long b)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && ((a<=3) && (b<=3)))
        return 0x8e0000000e00ll + 0x1000000000ll * ((a) & 0x3) + 8ll * ((b) & 0x3);
    __bdk_csr_fatal("PEMX_FLR_VFX_STOPREQ", 2, a, b, 0, 0);
}

#define typedef_BDK_PEMX_FLR_VFX_STOPREQ(a,b) bdk_pemx_flr_vfx_stopreq_t
#define bustype_BDK_PEMX_FLR_VFX_STOPREQ(a,b) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_FLR_VFX_STOPREQ(a,b) "PEMX_FLR_VFX_STOPREQ"
#define device_bar_BDK_PEMX_FLR_VFX_STOPREQ(a,b) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_FLR_VFX_STOPREQ(a,b) (a)
#define arguments_BDK_PEMX_FLR_VFX_STOPREQ(a,b) (a),(b),-1,-1

/**
 * Register (RSL) pem#_flr_zombie_ctl
 *
 * PEM FLR Global Count Control Register
 * Function level reset global zombie counter control register.
 */
union bdk_pemx_flr_zombie_ctl
{
    uint64_t u;
    struct bdk_pemx_flr_zombie_ctl_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_10_63        : 54;
        uint64_t exp                   : 10; /**< [  9:  0](R/W) The expiration value for the inbound shared global zombie counter. The global zombie
                                                                 counter
                                                                 continuously counts the number of cycles where the PCIe core was allowed to send
                                                                 either a posted request or a completion to the PEM.  When the global zombie counter
                                                                 reaches expiration (EXP), it resets to zero and all the nonzero per PCIe tag zombie
                                                                 counters are decremented. When a per PCIe tag zombie counter decrements to zero, a
                                                                 SWI_RSP_ERROR is
                                                                 sent to the M2S bus and its associated PCIe tag is returned to the pool.
                                                                 This field allows software programmability control of the zombie counter expiration. */
#else /* Word 0 - Little Endian */
        uint64_t exp                   : 10; /**< [  9:  0](R/W) The expiration value for the inbound shared global zombie counter. The global zombie
                                                                 counter
                                                                 continuously counts the number of cycles where the PCIe core was allowed to send
                                                                 either a posted request or a completion to the PEM.  When the global zombie counter
                                                                 reaches expiration (EXP), it resets to zero and all the nonzero per PCIe tag zombie
                                                                 counters are decremented. When a per PCIe tag zombie counter decrements to zero, a
                                                                 SWI_RSP_ERROR is
                                                                 sent to the M2S bus and its associated PCIe tag is returned to the pool.
                                                                 This field allows software programmability control of the zombie counter expiration. */
        uint64_t reserved_10_63        : 54;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_flr_zombie_ctl_s cn; */
};
typedef union bdk_pemx_flr_zombie_ctl bdk_pemx_flr_zombie_ctl_t;

static inline uint64_t BDK_PEMX_FLR_ZOMBIE_CTL(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_FLR_ZOMBIE_CTL(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN83XX) && (a<=3))
        return 0x87e0c0000230ll + 0x1000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_FLR_ZOMBIE_CTL", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_FLR_ZOMBIE_CTL(a) bdk_pemx_flr_zombie_ctl_t
#define bustype_BDK_PEMX_FLR_ZOMBIE_CTL(a) BDK_CSR_TYPE_RSL
#define basename_BDK_PEMX_FLR_ZOMBIE_CTL(a) "PEMX_FLR_ZOMBIE_CTL"
#define device_bar_BDK_PEMX_FLR_ZOMBIE_CTL(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_FLR_ZOMBIE_CTL(a) (a)
#define arguments_BDK_PEMX_FLR_ZOMBIE_CTL(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_ib_merge_timer_ctl
 *
 * PEM NCBI Merge Timer Control Register
 * This register controls the merging timer for inbound NCB writes.
 *
 * This register is not accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on PEM domain reset.
 */
union bdk_pemx_ib_merge_timer_ctl
{
    uint64_t u;
    struct bdk_pemx_ib_merge_timer_ctl_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_11_63        : 53;
        uint64_t wmerge_dis            : 1;  /**< [ 10: 10](R/W) For diagnostic use only.  If set, will disable inbound write merging. */
        uint64_t wmerge_total_timer    : 10; /**< [  9:  0](R/W) Write merge encapsulation timer. When PEM accepts a NCBI write which begins
                                                                 a write merging process, [WMERGE_TOTAL_TIMER] specifies the maximum wait, in
                                                                 coprocessor-clock cycles, to merge additional write operations into one larger
                                                                 write. The values for this field range from 1 to 1023, with 0x0 used for
                                                                 diagnostics only and treated as never expire.

                                                                 Internal:
                                                                 If, during diagnostics, a timer value of 0x0 causes final transactions to be
                                                                 stuck within the pipeline, those transactions can be released by changing the
                                                                 timer to a non-zero value. */
#else /* Word 0 - Little Endian */
        uint64_t wmerge_total_timer    : 10; /**< [  9:  0](R/W) Write merge encapsulation timer. When PEM accepts a NCBI write which begins
                                                                 a write merging process, [WMERGE_TOTAL_TIMER] specifies the maximum wait, in
                                                                 coprocessor-clock cycles, to merge additional write operations into one larger
                                                                 write. The values for this field range from 1 to 1023, with 0x0 used for
                                                                 diagnostics only and treated as never expire.

                                                                 Internal:
                                                                 If, during diagnostics, a timer value of 0x0 causes final transactions to be
                                                                 stuck within the pipeline, those transactions can be released by changing the
                                                                 timer to a non-zero value. */
        uint64_t wmerge_dis            : 1;  /**< [ 10: 10](R/W) For diagnostic use only.  If set, will disable inbound write merging. */
        uint64_t reserved_11_63        : 53;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_ib_merge_timer_ctl_s cn; */
};
typedef union bdk_pemx_ib_merge_timer_ctl bdk_pemx_ib_merge_timer_ctl_t;

static inline uint64_t BDK_PEMX_IB_MERGE_TIMER_CTL(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_IB_MERGE_TIMER_CTL(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e00000001b0ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_IB_MERGE_TIMER_CTL", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_IB_MERGE_TIMER_CTL(a) bdk_pemx_ib_merge_timer_ctl_t
#define bustype_BDK_PEMX_IB_MERGE_TIMER_CTL(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_IB_MERGE_TIMER_CTL(a) "PEMX_IB_MERGE_TIMER_CTL"
#define device_bar_BDK_PEMX_IB_MERGE_TIMER_CTL(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_IB_MERGE_TIMER_CTL(a) (a)
#define arguments_BDK_PEMX_IB_MERGE_TIMER_CTL(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_ib_wmerge_merged_pc
 *
 * PEM Inbound Merge Writes Merged Performance Counter Register
 * This register reports how many writes merged within the inbound write merge unit.
 *
 * This register is not accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on PEM domain reset.
 */
union bdk_pemx_ib_wmerge_merged_pc
{
    uint64_t u;
    struct bdk_pemx_ib_wmerge_merged_pc_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t wmerge_merged         : 64; /**< [ 63:  0](R/W/H) Each NCBI write operation mapped to MEM that merges with a previous
                                                                 write will increment this count. */
#else /* Word 0 - Little Endian */
        uint64_t wmerge_merged         : 64; /**< [ 63:  0](R/W/H) Each NCBI write operation mapped to MEM that merges with a previous
                                                                 write will increment this count. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_ib_wmerge_merged_pc_s cn; */
};
typedef union bdk_pemx_ib_wmerge_merged_pc bdk_pemx_ib_wmerge_merged_pc_t;

static inline uint64_t BDK_PEMX_IB_WMERGE_MERGED_PC(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_IB_WMERGE_MERGED_PC(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e00000001c0ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_IB_WMERGE_MERGED_PC", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_IB_WMERGE_MERGED_PC(a) bdk_pemx_ib_wmerge_merged_pc_t
#define bustype_BDK_PEMX_IB_WMERGE_MERGED_PC(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_IB_WMERGE_MERGED_PC(a) "PEMX_IB_WMERGE_MERGED_PC"
#define device_bar_BDK_PEMX_IB_WMERGE_MERGED_PC(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_IB_WMERGE_MERGED_PC(a) (a)
#define arguments_BDK_PEMX_IB_WMERGE_MERGED_PC(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_ib_wmerge_received_pc
 *
 * PEM Inbound Merge Writes Received Performance Counter Register
 * This register reports the number of writes that enter the inbound write merge unit.
 *
 * This register is not accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on PEM domain reset.
 */
union bdk_pemx_ib_wmerge_received_pc
{
    uint64_t u;
    struct bdk_pemx_ib_wmerge_received_pc_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t wmerge_writes         : 64; /**< [ 63:  0](R/W/H) Each NCBI write operation mapped to MEM type will increment this count. */
#else /* Word 0 - Little Endian */
        uint64_t wmerge_writes         : 64; /**< [ 63:  0](R/W/H) Each NCBI write operation mapped to MEM type will increment this count. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_ib_wmerge_received_pc_s cn; */
};
typedef union bdk_pemx_ib_wmerge_received_pc bdk_pemx_ib_wmerge_received_pc_t;

static inline uint64_t BDK_PEMX_IB_WMERGE_RECEIVED_PC(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_IB_WMERGE_RECEIVED_PC(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e00000001b8ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_IB_WMERGE_RECEIVED_PC", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_IB_WMERGE_RECEIVED_PC(a) bdk_pemx_ib_wmerge_received_pc_t
#define bustype_BDK_PEMX_IB_WMERGE_RECEIVED_PC(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_IB_WMERGE_RECEIVED_PC(a) "PEMX_IB_WMERGE_RECEIVED_PC"
#define device_bar_BDK_PEMX_IB_WMERGE_RECEIVED_PC(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_IB_WMERGE_RECEIVED_PC(a) (a)
#define arguments_BDK_PEMX_IB_WMERGE_RECEIVED_PC(a) (a),-1,-1,-1

/**
 * Register (RSL) pem#_inb_read_credits
 *
 * PEM In-flight Read Credits Register
 * This register contains the number of in-flight read operations from PCIe core to SLI.
 */
union bdk_pemx_inb_read_credits
{
    uint64_t u;
    struct bdk_pemx_inb_read_credits_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_7_63         : 57;
        uint64_t num                   : 7;  /**< [  6:  0](R/W) The number of reads that may be in flight from the PCIe core to the SLI. Minimum number is
                                                                 6; maximum number is 64. */
#else /* Word 0 - Little Endian */
        uint64_t num                   : 7;  /**< [  6:  0](R/W) The number of reads that may be in flight from the PCIe core to the SLI. Minimum number is
                                                                 6; maximum number is 64. */
        uint64_t reserved_7_63         : 57;
#endif /* Word 0 - End */
    } s;
    struct bdk_pemx_inb_read_credits_cn88xxp1
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_7_63         : 57;
        uint64_t num                   : 7;  /**< [  6:  0](R/W) The number of reads that may be in flight from the PCIe core to the SLI. Minimum number is
                                                                 2; maximum number is 64. */
#else /* Word 0 - Little Endian */
        uint64_t num                   : 7;  /**< [  6:  0](R/W) The number of reads that may be in flight from the PCIe core to the SLI. Minimum number is
                                                                 2; maximum number is 64. */
        uint64_t reserved_7_63         : 57;
#endif /* Word 0 - End */
    } cn88xxp1;
    /* struct bdk_pemx_inb_read_credits_s cn81xx; */
    /* struct bdk_pemx_inb_read_credits_s cn83xx; */
    /* struct bdk_pemx_inb_read_credits_s cn88xxp2; */
};
typedef union bdk_pemx_inb_read_credits bdk_pemx_inb_read_credits_t;

static inline uint64_t BDK_PEMX_INB_READ_CREDITS(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_INB_READ_CREDITS(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN81XX) && (a<=2))
        return 0x87e0c00000b8ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN83XX) && (a<=3))
        return 0x87e0c00000b8ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN88XX) && (a<=5))
        return 0x87e0c00000b8ll + 0x1000000ll * ((a) & 0x7);
    __bdk_csr_fatal("PEMX_INB_READ_CREDITS", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_INB_READ_CREDITS(a) bdk_pemx_inb_read_credits_t
#define bustype_BDK_PEMX_INB_READ_CREDITS(a) BDK_CSR_TYPE_RSL
#define basename_BDK_PEMX_INB_READ_CREDITS(a) "PEMX_INB_READ_CREDITS"
#define device_bar_BDK_PEMX_INB_READ_CREDITS(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_INB_READ_CREDITS(a) (a)
#define arguments_BDK_PEMX_INB_READ_CREDITS(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_int_ena_w1c
 *
 * PEM Interrupt Enable Clear Register
 * This register clears interrupt enable bits.
 */
union bdk_pemx_int_ena_w1c
{
    uint64_t u;
    struct bdk_pemx_int_ena_w1c_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_16_63        : 48;
        uint64_t ptm_rdy_val           : 1;  /**< [ 15: 15](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[PTM_RDY_VAL]. */
        uint64_t reserved_0_14         : 15;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0_14         : 15;
        uint64_t ptm_rdy_val           : 1;  /**< [ 15: 15](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[PTM_RDY_VAL]. */
        uint64_t reserved_16_63        : 48;
#endif /* Word 0 - End */
    } s;
    struct bdk_pemx_int_ena_w1c_cn9
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_16_63        : 48;
        uint64_t ptm_rdy_val           : 1;  /**< [ 15: 15](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[PTM_RDY_VAL]. */
        uint64_t un_b0                 : 1;  /**< [ 14: 14](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[UN_B0]. */
        uint64_t up_b0                 : 1;  /**< [ 13: 13](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[UP_B0]. */
        uint64_t surp_down             : 1;  /**< [ 12: 12](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[SURP_DOWN]. */
        uint64_t cfg_inf               : 1;  /**< [ 11: 11](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[CFG_INF]. */
        uint64_t crs_dr                : 1;  /**< [ 10: 10](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[CRS_DR]. */
        uint64_t crs_er                : 1;  /**< [  9:  9](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[CRS_ER]. */
        uint64_t rdlk                  : 1;  /**< [  8:  8](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[RDLK]. */
        uint64_t un_bx                 : 1;  /**< [  7:  7](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[UN_BX]. */
        uint64_t un_b2                 : 1;  /**< [  6:  6](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[UN_B2]. */
        uint64_t un_b4                 : 1;  /**< [  5:  5](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[UN_B4]. */
        uint64_t up_bx                 : 1;  /**< [  4:  4](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[UP_BX]. */
        uint64_t up_b2                 : 1;  /**< [  3:  3](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[UP_B2]. */
        uint64_t up_b4                 : 1;  /**< [  2:  2](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[UP_B4]. */
        uint64_t up_b3                 : 1;  /**< [  1:  1](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[UP_B3]. */
        uint64_t se                    : 1;  /**< [  0:  0](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[SE].
                                                                 Internal:
                                                                 cfg_sys_err_rc. */
#else /* Word 0 - Little Endian */
        uint64_t se                    : 1;  /**< [  0:  0](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[SE].
                                                                 Internal:
                                                                 cfg_sys_err_rc. */
        uint64_t up_b3                 : 1;  /**< [  1:  1](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[UP_B3]. */
        uint64_t up_b4                 : 1;  /**< [  2:  2](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[UP_B4]. */
        uint64_t up_b2                 : 1;  /**< [  3:  3](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[UP_B2]. */
        uint64_t up_bx                 : 1;  /**< [  4:  4](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[UP_BX]. */
        uint64_t un_b4                 : 1;  /**< [  5:  5](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[UN_B4]. */
        uint64_t un_b2                 : 1;  /**< [  6:  6](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[UN_B2]. */
        uint64_t un_bx                 : 1;  /**< [  7:  7](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[UN_BX]. */
        uint64_t rdlk                  : 1;  /**< [  8:  8](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[RDLK]. */
        uint64_t crs_er                : 1;  /**< [  9:  9](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[CRS_ER]. */
        uint64_t crs_dr                : 1;  /**< [ 10: 10](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[CRS_DR]. */
        uint64_t cfg_inf               : 1;  /**< [ 11: 11](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[CFG_INF]. */
        uint64_t surp_down             : 1;  /**< [ 12: 12](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[SURP_DOWN]. */
        uint64_t up_b0                 : 1;  /**< [ 13: 13](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[UP_B0]. */
        uint64_t un_b0                 : 1;  /**< [ 14: 14](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[UN_B0]. */
        uint64_t ptm_rdy_val           : 1;  /**< [ 15: 15](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[PTM_RDY_VAL]. */
        uint64_t reserved_16_63        : 48;
#endif /* Word 0 - End */
    } cn9;
    struct bdk_pemx_int_ena_w1c_cn81xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_14_63        : 50;
        uint64_t crs_dr                : 1;  /**< [ 13: 13](R/W1C/H) Reads or clears enable for PEM(0..2)_INT_SUM[CRS_DR]. */
        uint64_t crs_er                : 1;  /**< [ 12: 12](R/W1C/H) Reads or clears enable for PEM(0..2)_INT_SUM[CRS_ER]. */
        uint64_t rdlk                  : 1;  /**< [ 11: 11](R/W1C/H) Reads or clears enable for PEM(0..2)_INT_SUM[RDLK]. */
        uint64_t reserved_10           : 1;
        uint64_t un_bx                 : 1;  /**< [  9:  9](R/W1C/H) Reads or clears enable for PEM(0..2)_INT_SUM[UN_BX]. */
        uint64_t un_b2                 : 1;  /**< [  8:  8](R/W1C/H) Reads or clears enable for PEM(0..2)_INT_SUM[UN_B2]. */
        uint64_t un_b1                 : 1;  /**< [  7:  7](R/W1C/H) Reads or clears enable for PEM(0..2)_INT_SUM[UN_B1]. */
        uint64_t up_bx                 : 1;  /**< [  6:  6](R/W1C/H) Reads or clears enable for PEM(0..2)_INT_SUM[UP_BX]. */
        uint64_t up_b2                 : 1;  /**< [  5:  5](R/W1C/H) Reads or clears enable for PEM(0..2)_INT_SUM[UP_B2]. */
        uint64_t up_b1                 : 1;  /**< [  4:  4](R/W1C/H) Reads or clears enable for PEM(0..2)_INT_SUM[UP_B1]. */
        uint64_t reserved_2_3          : 2;
        uint64_t se                    : 1;  /**< [  1:  1](R/W1C/H) Reads or clears enable for PEM(0..2)_INT_SUM[SE].
                                                                 Internal:
                                                                 cfg_sys_err_rc. */
        uint64_t reserved_0            : 1;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0            : 1;
        uint64_t se                    : 1;  /**< [  1:  1](R/W1C/H) Reads or clears enable for PEM(0..2)_INT_SUM[SE].
                                                                 Internal:
                                                                 cfg_sys_err_rc. */
        uint64_t reserved_2_3          : 2;
        uint64_t up_b1                 : 1;  /**< [  4:  4](R/W1C/H) Reads or clears enable for PEM(0..2)_INT_SUM[UP_B1]. */
        uint64_t up_b2                 : 1;  /**< [  5:  5](R/W1C/H) Reads or clears enable for PEM(0..2)_INT_SUM[UP_B2]. */
        uint64_t up_bx                 : 1;  /**< [  6:  6](R/W1C/H) Reads or clears enable for PEM(0..2)_INT_SUM[UP_BX]. */
        uint64_t un_b1                 : 1;  /**< [  7:  7](R/W1C/H) Reads or clears enable for PEM(0..2)_INT_SUM[UN_B1]. */
        uint64_t un_b2                 : 1;  /**< [  8:  8](R/W1C/H) Reads or clears enable for PEM(0..2)_INT_SUM[UN_B2]. */
        uint64_t un_bx                 : 1;  /**< [  9:  9](R/W1C/H) Reads or clears enable for PEM(0..2)_INT_SUM[UN_BX]. */
        uint64_t reserved_10           : 1;
        uint64_t rdlk                  : 1;  /**< [ 11: 11](R/W1C/H) Reads or clears enable for PEM(0..2)_INT_SUM[RDLK]. */
        uint64_t crs_er                : 1;  /**< [ 12: 12](R/W1C/H) Reads or clears enable for PEM(0..2)_INT_SUM[CRS_ER]. */
        uint64_t crs_dr                : 1;  /**< [ 13: 13](R/W1C/H) Reads or clears enable for PEM(0..2)_INT_SUM[CRS_DR]. */
        uint64_t reserved_14_63        : 50;
#endif /* Word 0 - End */
    } cn81xx;
    struct bdk_pemx_int_ena_w1c_cn88xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_14_63        : 50;
        uint64_t crs_dr                : 1;  /**< [ 13: 13](R/W1C/H) Reads or clears enable for PEM(0..5)_INT_SUM[CRS_DR]. */
        uint64_t crs_er                : 1;  /**< [ 12: 12](R/W1C/H) Reads or clears enable for PEM(0..5)_INT_SUM[CRS_ER]. */
        uint64_t rdlk                  : 1;  /**< [ 11: 11](R/W1C/H) Reads or clears enable for PEM(0..5)_INT_SUM[RDLK]. */
        uint64_t reserved_10           : 1;
        uint64_t un_bx                 : 1;  /**< [  9:  9](R/W1C/H) Reads or clears enable for PEM(0..5)_INT_SUM[UN_BX]. */
        uint64_t un_b2                 : 1;  /**< [  8:  8](R/W1C/H) Reads or clears enable for PEM(0..5)_INT_SUM[UN_B2]. */
        uint64_t un_b1                 : 1;  /**< [  7:  7](R/W1C/H) Reads or clears enable for PEM(0..5)_INT_SUM[UN_B1]. */
        uint64_t up_bx                 : 1;  /**< [  6:  6](R/W1C/H) Reads or clears enable for PEM(0..5)_INT_SUM[UP_BX]. */
        uint64_t up_b2                 : 1;  /**< [  5:  5](R/W1C/H) Reads or clears enable for PEM(0..5)_INT_SUM[UP_B2]. */
        uint64_t up_b1                 : 1;  /**< [  4:  4](R/W1C/H) Reads or clears enable for PEM(0..5)_INT_SUM[UP_B1]. */
        uint64_t reserved_2_3          : 2;
        uint64_t se                    : 1;  /**< [  1:  1](R/W1C/H) Reads or clears enable for PEM(0..5)_INT_SUM[SE].
                                                                 Internal:
                                                                 cfg_sys_err_rc. */
        uint64_t reserved_0            : 1;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0            : 1;
        uint64_t se                    : 1;  /**< [  1:  1](R/W1C/H) Reads or clears enable for PEM(0..5)_INT_SUM[SE].
                                                                 Internal:
                                                                 cfg_sys_err_rc. */
        uint64_t reserved_2_3          : 2;
        uint64_t up_b1                 : 1;  /**< [  4:  4](R/W1C/H) Reads or clears enable for PEM(0..5)_INT_SUM[UP_B1]. */
        uint64_t up_b2                 : 1;  /**< [  5:  5](R/W1C/H) Reads or clears enable for PEM(0..5)_INT_SUM[UP_B2]. */
        uint64_t up_bx                 : 1;  /**< [  6:  6](R/W1C/H) Reads or clears enable for PEM(0..5)_INT_SUM[UP_BX]. */
        uint64_t un_b1                 : 1;  /**< [  7:  7](R/W1C/H) Reads or clears enable for PEM(0..5)_INT_SUM[UN_B1]. */
        uint64_t un_b2                 : 1;  /**< [  8:  8](R/W1C/H) Reads or clears enable for PEM(0..5)_INT_SUM[UN_B2]. */
        uint64_t un_bx                 : 1;  /**< [  9:  9](R/W1C/H) Reads or clears enable for PEM(0..5)_INT_SUM[UN_BX]. */
        uint64_t reserved_10           : 1;
        uint64_t rdlk                  : 1;  /**< [ 11: 11](R/W1C/H) Reads or clears enable for PEM(0..5)_INT_SUM[RDLK]. */
        uint64_t crs_er                : 1;  /**< [ 12: 12](R/W1C/H) Reads or clears enable for PEM(0..5)_INT_SUM[CRS_ER]. */
        uint64_t crs_dr                : 1;  /**< [ 13: 13](R/W1C/H) Reads or clears enable for PEM(0..5)_INT_SUM[CRS_DR]. */
        uint64_t reserved_14_63        : 50;
#endif /* Word 0 - End */
    } cn88xx;
    struct bdk_pemx_int_ena_w1c_cn83xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_15_63        : 49;
        uint64_t surp_down             : 1;  /**< [ 14: 14](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[SURP_DOWN]. */
        uint64_t crs_dr                : 1;  /**< [ 13: 13](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[CRS_DR]. */
        uint64_t crs_er                : 1;  /**< [ 12: 12](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[CRS_ER]. */
        uint64_t rdlk                  : 1;  /**< [ 11: 11](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[RDLK]. */
        uint64_t reserved_10           : 1;
        uint64_t un_bx                 : 1;  /**< [  9:  9](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[UN_BX]. */
        uint64_t un_b2                 : 1;  /**< [  8:  8](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[UN_B2]. */
        uint64_t un_b1                 : 1;  /**< [  7:  7](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[UN_B1]. */
        uint64_t up_bx                 : 1;  /**< [  6:  6](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[UP_BX]. */
        uint64_t up_b2                 : 1;  /**< [  5:  5](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[UP_B2]. */
        uint64_t up_b1                 : 1;  /**< [  4:  4](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[UP_B1]. */
        uint64_t up_b3                 : 1;  /**< [  3:  3](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[UP_B3]. */
        uint64_t reserved_2            : 1;
        uint64_t se                    : 1;  /**< [  1:  1](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[SE].
                                                                 Internal:
                                                                 cfg_sys_err_rc. */
        uint64_t reserved_0            : 1;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0            : 1;
        uint64_t se                    : 1;  /**< [  1:  1](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[SE].
                                                                 Internal:
                                                                 cfg_sys_err_rc. */
        uint64_t reserved_2            : 1;
        uint64_t up_b3                 : 1;  /**< [  3:  3](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[UP_B3]. */
        uint64_t up_b1                 : 1;  /**< [  4:  4](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[UP_B1]. */
        uint64_t up_b2                 : 1;  /**< [  5:  5](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[UP_B2]. */
        uint64_t up_bx                 : 1;  /**< [  6:  6](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[UP_BX]. */
        uint64_t un_b1                 : 1;  /**< [  7:  7](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[UN_B1]. */
        uint64_t un_b2                 : 1;  /**< [  8:  8](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[UN_B2]. */
        uint64_t un_bx                 : 1;  /**< [  9:  9](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[UN_BX]. */
        uint64_t reserved_10           : 1;
        uint64_t rdlk                  : 1;  /**< [ 11: 11](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[RDLK]. */
        uint64_t crs_er                : 1;  /**< [ 12: 12](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[CRS_ER]. */
        uint64_t crs_dr                : 1;  /**< [ 13: 13](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[CRS_DR]. */
        uint64_t surp_down             : 1;  /**< [ 14: 14](R/W1C/H) Reads or clears enable for PEM(0..3)_INT_SUM[SURP_DOWN]. */
        uint64_t reserved_15_63        : 49;
#endif /* Word 0 - End */
    } cn83xx;
};
typedef union bdk_pemx_int_ena_w1c bdk_pemx_int_ena_w1c_t;

static inline uint64_t BDK_PEMX_INT_ENA_W1C(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_INT_ENA_W1C(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN81XX) && (a<=2))
        return 0x87e0c0000438ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN83XX) && (a<=3))
        return 0x87e0c0000438ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN88XX) && (a<=5))
        return 0x87e0c0000438ll + 0x1000000ll * ((a) & 0x7);
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e00000000e8ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_INT_ENA_W1C", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_INT_ENA_W1C(a) bdk_pemx_int_ena_w1c_t
#define bustype_BDK_PEMX_INT_ENA_W1C(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_INT_ENA_W1C(a) "PEMX_INT_ENA_W1C"
#define device_bar_BDK_PEMX_INT_ENA_W1C(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_INT_ENA_W1C(a) (a)
#define arguments_BDK_PEMX_INT_ENA_W1C(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_int_ena_w1s
 *
 * PEM Interrupt Enable Set Register
 * This register sets interrupt enable bits.
 */
union bdk_pemx_int_ena_w1s
{
    uint64_t u;
    struct bdk_pemx_int_ena_w1s_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_16_63        : 48;
        uint64_t ptm_rdy_val           : 1;  /**< [ 15: 15](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[PTM_RDY_VAL]. */
        uint64_t reserved_0_14         : 15;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0_14         : 15;
        uint64_t ptm_rdy_val           : 1;  /**< [ 15: 15](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[PTM_RDY_VAL]. */
        uint64_t reserved_16_63        : 48;
#endif /* Word 0 - End */
    } s;
    struct bdk_pemx_int_ena_w1s_cn9
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_16_63        : 48;
        uint64_t ptm_rdy_val           : 1;  /**< [ 15: 15](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[PTM_RDY_VAL]. */
        uint64_t un_b0                 : 1;  /**< [ 14: 14](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[UN_B0]. */
        uint64_t up_b0                 : 1;  /**< [ 13: 13](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[UP_B0]. */
        uint64_t surp_down             : 1;  /**< [ 12: 12](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[SURP_DOWN]. */
        uint64_t cfg_inf               : 1;  /**< [ 11: 11](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[CFG_INF]. */
        uint64_t crs_dr                : 1;  /**< [ 10: 10](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[CRS_DR]. */
        uint64_t crs_er                : 1;  /**< [  9:  9](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[CRS_ER]. */
        uint64_t rdlk                  : 1;  /**< [  8:  8](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[RDLK]. */
        uint64_t un_bx                 : 1;  /**< [  7:  7](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[UN_BX]. */
        uint64_t un_b2                 : 1;  /**< [  6:  6](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[UN_B2]. */
        uint64_t un_b4                 : 1;  /**< [  5:  5](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[UN_B4]. */
        uint64_t up_bx                 : 1;  /**< [  4:  4](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[UP_BX]. */
        uint64_t up_b2                 : 1;  /**< [  3:  3](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[UP_B2]. */
        uint64_t up_b4                 : 1;  /**< [  2:  2](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[UP_B4]. */
        uint64_t up_b3                 : 1;  /**< [  1:  1](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[UP_B3]. */
        uint64_t se                    : 1;  /**< [  0:  0](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[SE].
                                                                 Internal:
                                                                 cfg_sys_err_rc. */
#else /* Word 0 - Little Endian */
        uint64_t se                    : 1;  /**< [  0:  0](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[SE].
                                                                 Internal:
                                                                 cfg_sys_err_rc. */
        uint64_t up_b3                 : 1;  /**< [  1:  1](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[UP_B3]. */
        uint64_t up_b4                 : 1;  /**< [  2:  2](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[UP_B4]. */
        uint64_t up_b2                 : 1;  /**< [  3:  3](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[UP_B2]. */
        uint64_t up_bx                 : 1;  /**< [  4:  4](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[UP_BX]. */
        uint64_t un_b4                 : 1;  /**< [  5:  5](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[UN_B4]. */
        uint64_t un_b2                 : 1;  /**< [  6:  6](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[UN_B2]. */
        uint64_t un_bx                 : 1;  /**< [  7:  7](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[UN_BX]. */
        uint64_t rdlk                  : 1;  /**< [  8:  8](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[RDLK]. */
        uint64_t crs_er                : 1;  /**< [  9:  9](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[CRS_ER]. */
        uint64_t crs_dr                : 1;  /**< [ 10: 10](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[CRS_DR]. */
        uint64_t cfg_inf               : 1;  /**< [ 11: 11](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[CFG_INF]. */
        uint64_t surp_down             : 1;  /**< [ 12: 12](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[SURP_DOWN]. */
        uint64_t up_b0                 : 1;  /**< [ 13: 13](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[UP_B0]. */
        uint64_t un_b0                 : 1;  /**< [ 14: 14](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[UN_B0]. */
        uint64_t ptm_rdy_val           : 1;  /**< [ 15: 15](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[PTM_RDY_VAL]. */
        uint64_t reserved_16_63        : 48;
#endif /* Word 0 - End */
    } cn9;
    struct bdk_pemx_int_ena_w1s_cn81xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_14_63        : 50;
        uint64_t crs_dr                : 1;  /**< [ 13: 13](R/W1S/H) Reads or sets enable for PEM(0..2)_INT_SUM[CRS_DR]. */
        uint64_t crs_er                : 1;  /**< [ 12: 12](R/W1S/H) Reads or sets enable for PEM(0..2)_INT_SUM[CRS_ER]. */
        uint64_t rdlk                  : 1;  /**< [ 11: 11](R/W1S/H) Reads or sets enable for PEM(0..2)_INT_SUM[RDLK]. */
        uint64_t reserved_10           : 1;
        uint64_t un_bx                 : 1;  /**< [  9:  9](R/W1S/H) Reads or sets enable for PEM(0..2)_INT_SUM[UN_BX]. */
        uint64_t un_b2                 : 1;  /**< [  8:  8](R/W1S/H) Reads or sets enable for PEM(0..2)_INT_SUM[UN_B2]. */
        uint64_t un_b1                 : 1;  /**< [  7:  7](R/W1S/H) Reads or sets enable for PEM(0..2)_INT_SUM[UN_B1]. */
        uint64_t up_bx                 : 1;  /**< [  6:  6](R/W1S/H) Reads or sets enable for PEM(0..2)_INT_SUM[UP_BX]. */
        uint64_t up_b2                 : 1;  /**< [  5:  5](R/W1S/H) Reads or sets enable for PEM(0..2)_INT_SUM[UP_B2]. */
        uint64_t up_b1                 : 1;  /**< [  4:  4](R/W1S/H) Reads or sets enable for PEM(0..2)_INT_SUM[UP_B1]. */
        uint64_t reserved_2_3          : 2;
        uint64_t se                    : 1;  /**< [  1:  1](R/W1S/H) Reads or sets enable for PEM(0..2)_INT_SUM[SE].
                                                                 Internal:
                                                                 cfg_sys_err_rc. */
        uint64_t reserved_0            : 1;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0            : 1;
        uint64_t se                    : 1;  /**< [  1:  1](R/W1S/H) Reads or sets enable for PEM(0..2)_INT_SUM[SE].
                                                                 Internal:
                                                                 cfg_sys_err_rc. */
        uint64_t reserved_2_3          : 2;
        uint64_t up_b1                 : 1;  /**< [  4:  4](R/W1S/H) Reads or sets enable for PEM(0..2)_INT_SUM[UP_B1]. */
        uint64_t up_b2                 : 1;  /**< [  5:  5](R/W1S/H) Reads or sets enable for PEM(0..2)_INT_SUM[UP_B2]. */
        uint64_t up_bx                 : 1;  /**< [  6:  6](R/W1S/H) Reads or sets enable for PEM(0..2)_INT_SUM[UP_BX]. */
        uint64_t un_b1                 : 1;  /**< [  7:  7](R/W1S/H) Reads or sets enable for PEM(0..2)_INT_SUM[UN_B1]. */
        uint64_t un_b2                 : 1;  /**< [  8:  8](R/W1S/H) Reads or sets enable for PEM(0..2)_INT_SUM[UN_B2]. */
        uint64_t un_bx                 : 1;  /**< [  9:  9](R/W1S/H) Reads or sets enable for PEM(0..2)_INT_SUM[UN_BX]. */
        uint64_t reserved_10           : 1;
        uint64_t rdlk                  : 1;  /**< [ 11: 11](R/W1S/H) Reads or sets enable for PEM(0..2)_INT_SUM[RDLK]. */
        uint64_t crs_er                : 1;  /**< [ 12: 12](R/W1S/H) Reads or sets enable for PEM(0..2)_INT_SUM[CRS_ER]. */
        uint64_t crs_dr                : 1;  /**< [ 13: 13](R/W1S/H) Reads or sets enable for PEM(0..2)_INT_SUM[CRS_DR]. */
        uint64_t reserved_14_63        : 50;
#endif /* Word 0 - End */
    } cn81xx;
    struct bdk_pemx_int_ena_w1s_cn88xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_14_63        : 50;
        uint64_t crs_dr                : 1;  /**< [ 13: 13](R/W1S/H) Reads or sets enable for PEM(0..5)_INT_SUM[CRS_DR]. */
        uint64_t crs_er                : 1;  /**< [ 12: 12](R/W1S/H) Reads or sets enable for PEM(0..5)_INT_SUM[CRS_ER]. */
        uint64_t rdlk                  : 1;  /**< [ 11: 11](R/W1S/H) Reads or sets enable for PEM(0..5)_INT_SUM[RDLK]. */
        uint64_t reserved_10           : 1;
        uint64_t un_bx                 : 1;  /**< [  9:  9](R/W1S/H) Reads or sets enable for PEM(0..5)_INT_SUM[UN_BX]. */
        uint64_t un_b2                 : 1;  /**< [  8:  8](R/W1S/H) Reads or sets enable for PEM(0..5)_INT_SUM[UN_B2]. */
        uint64_t un_b1                 : 1;  /**< [  7:  7](R/W1S/H) Reads or sets enable for PEM(0..5)_INT_SUM[UN_B1]. */
        uint64_t up_bx                 : 1;  /**< [  6:  6](R/W1S/H) Reads or sets enable for PEM(0..5)_INT_SUM[UP_BX]. */
        uint64_t up_b2                 : 1;  /**< [  5:  5](R/W1S/H) Reads or sets enable for PEM(0..5)_INT_SUM[UP_B2]. */
        uint64_t up_b1                 : 1;  /**< [  4:  4](R/W1S/H) Reads or sets enable for PEM(0..5)_INT_SUM[UP_B1]. */
        uint64_t reserved_2_3          : 2;
        uint64_t se                    : 1;  /**< [  1:  1](R/W1S/H) Reads or sets enable for PEM(0..5)_INT_SUM[SE].
                                                                 Internal:
                                                                 cfg_sys_err_rc. */
        uint64_t reserved_0            : 1;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0            : 1;
        uint64_t se                    : 1;  /**< [  1:  1](R/W1S/H) Reads or sets enable for PEM(0..5)_INT_SUM[SE].
                                                                 Internal:
                                                                 cfg_sys_err_rc. */
        uint64_t reserved_2_3          : 2;
        uint64_t up_b1                 : 1;  /**< [  4:  4](R/W1S/H) Reads or sets enable for PEM(0..5)_INT_SUM[UP_B1]. */
        uint64_t up_b2                 : 1;  /**< [  5:  5](R/W1S/H) Reads or sets enable for PEM(0..5)_INT_SUM[UP_B2]. */
        uint64_t up_bx                 : 1;  /**< [  6:  6](R/W1S/H) Reads or sets enable for PEM(0..5)_INT_SUM[UP_BX]. */
        uint64_t un_b1                 : 1;  /**< [  7:  7](R/W1S/H) Reads or sets enable for PEM(0..5)_INT_SUM[UN_B1]. */
        uint64_t un_b2                 : 1;  /**< [  8:  8](R/W1S/H) Reads or sets enable for PEM(0..5)_INT_SUM[UN_B2]. */
        uint64_t un_bx                 : 1;  /**< [  9:  9](R/W1S/H) Reads or sets enable for PEM(0..5)_INT_SUM[UN_BX]. */
        uint64_t reserved_10           : 1;
        uint64_t rdlk                  : 1;  /**< [ 11: 11](R/W1S/H) Reads or sets enable for PEM(0..5)_INT_SUM[RDLK]. */
        uint64_t crs_er                : 1;  /**< [ 12: 12](R/W1S/H) Reads or sets enable for PEM(0..5)_INT_SUM[CRS_ER]. */
        uint64_t crs_dr                : 1;  /**< [ 13: 13](R/W1S/H) Reads or sets enable for PEM(0..5)_INT_SUM[CRS_DR]. */
        uint64_t reserved_14_63        : 50;
#endif /* Word 0 - End */
    } cn88xx;
    struct bdk_pemx_int_ena_w1s_cn83xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_15_63        : 49;
        uint64_t surp_down             : 1;  /**< [ 14: 14](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[SURP_DOWN]. */
        uint64_t crs_dr                : 1;  /**< [ 13: 13](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[CRS_DR]. */
        uint64_t crs_er                : 1;  /**< [ 12: 12](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[CRS_ER]. */
        uint64_t rdlk                  : 1;  /**< [ 11: 11](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[RDLK]. */
        uint64_t reserved_10           : 1;
        uint64_t un_bx                 : 1;  /**< [  9:  9](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[UN_BX]. */
        uint64_t un_b2                 : 1;  /**< [  8:  8](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[UN_B2]. */
        uint64_t un_b1                 : 1;  /**< [  7:  7](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[UN_B1]. */
        uint64_t up_bx                 : 1;  /**< [  6:  6](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[UP_BX]. */
        uint64_t up_b2                 : 1;  /**< [  5:  5](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[UP_B2]. */
        uint64_t up_b1                 : 1;  /**< [  4:  4](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[UP_B1]. */
        uint64_t up_b3                 : 1;  /**< [  3:  3](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[UP_B3]. */
        uint64_t reserved_2            : 1;
        uint64_t se                    : 1;  /**< [  1:  1](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[SE].
                                                                 Internal:
                                                                 cfg_sys_err_rc. */
        uint64_t reserved_0            : 1;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0            : 1;
        uint64_t se                    : 1;  /**< [  1:  1](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[SE].
                                                                 Internal:
                                                                 cfg_sys_err_rc. */
        uint64_t reserved_2            : 1;
        uint64_t up_b3                 : 1;  /**< [  3:  3](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[UP_B3]. */
        uint64_t up_b1                 : 1;  /**< [  4:  4](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[UP_B1]. */
        uint64_t up_b2                 : 1;  /**< [  5:  5](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[UP_B2]. */
        uint64_t up_bx                 : 1;  /**< [  6:  6](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[UP_BX]. */
        uint64_t un_b1                 : 1;  /**< [  7:  7](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[UN_B1]. */
        uint64_t un_b2                 : 1;  /**< [  8:  8](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[UN_B2]. */
        uint64_t un_bx                 : 1;  /**< [  9:  9](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[UN_BX]. */
        uint64_t reserved_10           : 1;
        uint64_t rdlk                  : 1;  /**< [ 11: 11](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[RDLK]. */
        uint64_t crs_er                : 1;  /**< [ 12: 12](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[CRS_ER]. */
        uint64_t crs_dr                : 1;  /**< [ 13: 13](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[CRS_DR]. */
        uint64_t surp_down             : 1;  /**< [ 14: 14](R/W1S/H) Reads or sets enable for PEM(0..3)_INT_SUM[SURP_DOWN]. */
        uint64_t reserved_15_63        : 49;
#endif /* Word 0 - End */
    } cn83xx;
};
typedef union bdk_pemx_int_ena_w1s bdk_pemx_int_ena_w1s_t;

static inline uint64_t BDK_PEMX_INT_ENA_W1S(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_INT_ENA_W1S(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN81XX) && (a<=2))
        return 0x87e0c0000440ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN83XX) && (a<=3))
        return 0x87e0c0000440ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN88XX) && (a<=5))
        return 0x87e0c0000440ll + 0x1000000ll * ((a) & 0x7);
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e00000000f0ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_INT_ENA_W1S", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_INT_ENA_W1S(a) bdk_pemx_int_ena_w1s_t
#define bustype_BDK_PEMX_INT_ENA_W1S(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_INT_ENA_W1S(a) "PEMX_INT_ENA_W1S"
#define device_bar_BDK_PEMX_INT_ENA_W1S(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_INT_ENA_W1S(a) (a)
#define arguments_BDK_PEMX_INT_ENA_W1S(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_int_sum
 *
 * PEM Interrupt Summary Register
 * This register contains the different interrupt summary bits of the PEM.
 *
 * This register is not accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on PEM domain reset.
 */
union bdk_pemx_int_sum
{
    uint64_t u;
    struct bdk_pemx_int_sum_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_16_63        : 48;
        uint64_t ptm_rdy_val           : 1;  /**< [ 15: 15](R/W1C/H) PTM Root is ready to have to context validated.

                                                                 The Mac PTM logic does not have a permenantly valid context.
                                                                 Currently the core invalidates the responder context on two conditions
                                                                 * aux_clk_active (is asserted when  link in L1 states)
                                                                 * Link speed changes

                                                                 To clear this interrupt, The host programs PCIERC_PTM_RES_LOCAL_MSB and
                                                                 PCIERC_PTM_RES_LOCAL_LSB and then sets the context valid bit
                                                                 (PCIERC_PTM_RES_CTL[PRES_CTX_VLD]). */
        uint64_t reserved_0_14         : 15;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0_14         : 15;
        uint64_t ptm_rdy_val           : 1;  /**< [ 15: 15](R/W1C/H) PTM Root is ready to have to context validated.

                                                                 The Mac PTM logic does not have a permenantly valid context.
                                                                 Currently the core invalidates the responder context on two conditions
                                                                 * aux_clk_active (is asserted when  link in L1 states)
                                                                 * Link speed changes

                                                                 To clear this interrupt, The host programs PCIERC_PTM_RES_LOCAL_MSB and
                                                                 PCIERC_PTM_RES_LOCAL_LSB and then sets the context valid bit
                                                                 (PCIERC_PTM_RES_CTL[PRES_CTX_VLD]). */
        uint64_t reserved_16_63        : 48;
#endif /* Word 0 - End */
    } s;
    struct bdk_pemx_int_sum_cn9
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_16_63        : 48;
        uint64_t ptm_rdy_val           : 1;  /**< [ 15: 15](R/W1C/H) PTM Root is ready to have to context validated.

                                                                 The Mac PTM logic does not have a permenantly valid context.
                                                                 Currently the core invalidates the responder context on two conditions
                                                                 * aux_clk_active (is asserted when  link in L1 states)
                                                                 * Link speed changes

                                                                 To clear this interrupt, The host programs PCIERC_PTM_RES_LOCAL_MSB and
                                                                 PCIERC_PTM_RES_LOCAL_LSB and then sets the context valid bit
                                                                 (PCIERC_PTM_RES_CTL[PRES_CTX_VLD]). */
        uint64_t un_b0                 : 1;  /**< [ 14: 14](R/W1C/H) Received N-TLP for BAR0 when BAR0 is disabled. */
        uint64_t up_b0                 : 1;  /**< [ 13: 13](R/W1C/H) Received P-TLP for BAR0 when BAR0 is disabled. */
        uint64_t surp_down             : 1;  /**< [ 12: 12](R/W1C/H) Indicates that a surprise down event is occuring in the controller. */
        uint64_t cfg_inf               : 1;  /**< [ 11: 11](R/W1C/H) AP cores sent a second config read while a current config read was still inflight */
        uint64_t crs_dr                : 1;  /**< [ 10: 10](R/W1C/H) Had a CRS timeout when retries were disabled. */
        uint64_t crs_er                : 1;  /**< [  9:  9](R/W1C/H) Had a CRS timeout when retries were enabled. */
        uint64_t rdlk                  : 1;  /**< [  8:  8](R/W1C/H) Received read lock TLP. */
        uint64_t un_bx                 : 1;  /**< [  7:  7](R/W1C/H) Received N-TLP for unknown BAR. */
        uint64_t un_b2                 : 1;  /**< [  6:  6](R/W1C/H) Received N-TLP for BAR2 when BAR2 is disabled. */
        uint64_t un_b4                 : 1;  /**< [  5:  5](R/W1C/H) Received N-TLP for BAR4 when BAR4 index valid is not set. */
        uint64_t up_bx                 : 1;  /**< [  4:  4](R/W1C/H) Received P-TLP for an unknown BAR. */
        uint64_t up_b2                 : 1;  /**< [  3:  3](R/W1C/H) Received P-TLP for BAR2 when BAR2 is disabled. */
        uint64_t up_b4                 : 1;  /**< [  2:  2](R/W1C/H) Received P-TLP for BAR4 when BAR4 index valid is not set. */
        uint64_t up_b3                 : 1;  /**< [  1:  1](R/W1C/H) Received P-TLP for Expansion ROM. */
        uint64_t se                    : 1;  /**< [  0:  0](R/W1C/H) System error, RC mode only.
                                                                 Internal:
                                                                 cfg_sys_err_rc. */
#else /* Word 0 - Little Endian */
        uint64_t se                    : 1;  /**< [  0:  0](R/W1C/H) System error, RC mode only.
                                                                 Internal:
                                                                 cfg_sys_err_rc. */
        uint64_t up_b3                 : 1;  /**< [  1:  1](R/W1C/H) Received P-TLP for Expansion ROM. */
        uint64_t up_b4                 : 1;  /**< [  2:  2](R/W1C/H) Received P-TLP for BAR4 when BAR4 index valid is not set. */
        uint64_t up_b2                 : 1;  /**< [  3:  3](R/W1C/H) Received P-TLP for BAR2 when BAR2 is disabled. */
        uint64_t up_bx                 : 1;  /**< [  4:  4](R/W1C/H) Received P-TLP for an unknown BAR. */
        uint64_t un_b4                 : 1;  /**< [  5:  5](R/W1C/H) Received N-TLP for BAR4 when BAR4 index valid is not set. */
        uint64_t un_b2                 : 1;  /**< [  6:  6](R/W1C/H) Received N-TLP for BAR2 when BAR2 is disabled. */
        uint64_t un_bx                 : 1;  /**< [  7:  7](R/W1C/H) Received N-TLP for unknown BAR. */
        uint64_t rdlk                  : 1;  /**< [  8:  8](R/W1C/H) Received read lock TLP. */
        uint64_t crs_er                : 1;  /**< [  9:  9](R/W1C/H) Had a CRS timeout when retries were enabled. */
        uint64_t crs_dr                : 1;  /**< [ 10: 10](R/W1C/H) Had a CRS timeout when retries were disabled. */
        uint64_t cfg_inf               : 1;  /**< [ 11: 11](R/W1C/H) AP cores sent a second config read while a current config read was still inflight */
        uint64_t surp_down             : 1;  /**< [ 12: 12](R/W1C/H) Indicates that a surprise down event is occuring in the controller. */
        uint64_t up_b0                 : 1;  /**< [ 13: 13](R/W1C/H) Received P-TLP for BAR0 when BAR0 is disabled. */
        uint64_t un_b0                 : 1;  /**< [ 14: 14](R/W1C/H) Received N-TLP for BAR0 when BAR0 is disabled. */
        uint64_t ptm_rdy_val           : 1;  /**< [ 15: 15](R/W1C/H) PTM Root is ready to have to context validated.

                                                                 The Mac PTM logic does not have a permenantly valid context.
                                                                 Currently the core invalidates the responder context on two conditions
                                                                 * aux_clk_active (is asserted when  link in L1 states)
                                                                 * Link speed changes

                                                                 To clear this interrupt, The host programs PCIERC_PTM_RES_LOCAL_MSB and
                                                                 PCIERC_PTM_RES_LOCAL_LSB and then sets the context valid bit
                                                                 (PCIERC_PTM_RES_CTL[PRES_CTX_VLD]). */
        uint64_t reserved_16_63        : 48;
#endif /* Word 0 - End */
    } cn9;
    struct bdk_pemx_int_sum_cn81xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_14_63        : 50;
        uint64_t crs_dr                : 1;  /**< [ 13: 13](R/W1C/H) Had a CRS timeout when retries were disabled. */
        uint64_t crs_er                : 1;  /**< [ 12: 12](R/W1C/H) Had a CRS timeout when retries were enabled. */
        uint64_t rdlk                  : 1;  /**< [ 11: 11](R/W1C/H) Received read lock TLP. */
        uint64_t reserved_10           : 1;
        uint64_t un_bx                 : 1;  /**< [  9:  9](R/W1C/H) Received N-TLP for unknown BAR. */
        uint64_t un_b2                 : 1;  /**< [  8:  8](R/W1C/H) Received N-TLP for BAR2 when BAR2 is disabled. */
        uint64_t un_b1                 : 1;  /**< [  7:  7](R/W1C/H) Received N-TLP for BAR1 when BAR1 index valid is not set. */
        uint64_t up_bx                 : 1;  /**< [  6:  6](R/W1C/H) Received P-TLP for an unknown BAR. */
        uint64_t up_b2                 : 1;  /**< [  5:  5](R/W1C/H) Received P-TLP for BAR2 when BAR2 is disabled. */
        uint64_t up_b1                 : 1;  /**< [  4:  4](R/W1C/H) Received P-TLP for BAR1 when BAR1 index valid is not set. */
        uint64_t reserved_2_3          : 2;
        uint64_t se                    : 1;  /**< [  1:  1](R/W1C/H) System error, RC mode only.
                                                                 Internal:
                                                                 cfg_sys_err_rc. */
        uint64_t reserved_0            : 1;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0            : 1;
        uint64_t se                    : 1;  /**< [  1:  1](R/W1C/H) System error, RC mode only.
                                                                 Internal:
                                                                 cfg_sys_err_rc. */
        uint64_t reserved_2_3          : 2;
        uint64_t up_b1                 : 1;  /**< [  4:  4](R/W1C/H) Received P-TLP for BAR1 when BAR1 index valid is not set. */
        uint64_t up_b2                 : 1;  /**< [  5:  5](R/W1C/H) Received P-TLP for BAR2 when BAR2 is disabled. */
        uint64_t up_bx                 : 1;  /**< [  6:  6](R/W1C/H) Received P-TLP for an unknown BAR. */
        uint64_t un_b1                 : 1;  /**< [  7:  7](R/W1C/H) Received N-TLP for BAR1 when BAR1 index valid is not set. */
        uint64_t un_b2                 : 1;  /**< [  8:  8](R/W1C/H) Received N-TLP for BAR2 when BAR2 is disabled. */
        uint64_t un_bx                 : 1;  /**< [  9:  9](R/W1C/H) Received N-TLP for unknown BAR. */
        uint64_t reserved_10           : 1;
        uint64_t rdlk                  : 1;  /**< [ 11: 11](R/W1C/H) Received read lock TLP. */
        uint64_t crs_er                : 1;  /**< [ 12: 12](R/W1C/H) Had a CRS timeout when retries were enabled. */
        uint64_t crs_dr                : 1;  /**< [ 13: 13](R/W1C/H) Had a CRS timeout when retries were disabled. */
        uint64_t reserved_14_63        : 50;
#endif /* Word 0 - End */
    } cn81xx;
    /* struct bdk_pemx_int_sum_cn81xx cn88xx; */
    struct bdk_pemx_int_sum_cn83xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_15_63        : 49;
        uint64_t surp_down             : 1;  /**< [ 14: 14](R/W1C/H) Indicates that a surprise down event is occuring in the controller. */
        uint64_t crs_dr                : 1;  /**< [ 13: 13](R/W1C/H) Had a CRS timeout when retries were disabled. */
        uint64_t crs_er                : 1;  /**< [ 12: 12](R/W1C/H) Had a CRS timeout when retries were enabled. */
        uint64_t rdlk                  : 1;  /**< [ 11: 11](R/W1C/H) Received read lock TLP. */
        uint64_t reserved_10           : 1;
        uint64_t un_bx                 : 1;  /**< [  9:  9](R/W1C/H) Received N-TLP for unknown BAR. */
        uint64_t un_b2                 : 1;  /**< [  8:  8](R/W1C/H) Received N-TLP for BAR2 when BAR2 is disabled. */
        uint64_t un_b1                 : 1;  /**< [  7:  7](R/W1C/H) Received N-TLP for BAR1 when BAR1 index valid is not set. */
        uint64_t up_bx                 : 1;  /**< [  6:  6](R/W1C/H) Received P-TLP for an unknown BAR. */
        uint64_t up_b2                 : 1;  /**< [  5:  5](R/W1C/H) Received P-TLP for BAR2 when BAR2 is disabled. */
        uint64_t up_b1                 : 1;  /**< [  4:  4](R/W1C/H) Received P-TLP for BAR1 when BAR1 index valid is not set. */
        uint64_t up_b3                 : 1;  /**< [  3:  3](R/W1C/H) Received P-TLP for Expansion ROM (BAR3 EP Mode). */
        uint64_t reserved_2            : 1;
        uint64_t se                    : 1;  /**< [  1:  1](R/W1C/H) System error, RC mode only.
                                                                 Internal:
                                                                 cfg_sys_err_rc. */
        uint64_t reserved_0            : 1;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0            : 1;
        uint64_t se                    : 1;  /**< [  1:  1](R/W1C/H) System error, RC mode only.
                                                                 Internal:
                                                                 cfg_sys_err_rc. */
        uint64_t reserved_2            : 1;
        uint64_t up_b3                 : 1;  /**< [  3:  3](R/W1C/H) Received P-TLP for Expansion ROM (BAR3 EP Mode). */
        uint64_t up_b1                 : 1;  /**< [  4:  4](R/W1C/H) Received P-TLP for BAR1 when BAR1 index valid is not set. */
        uint64_t up_b2                 : 1;  /**< [  5:  5](R/W1C/H) Received P-TLP for BAR2 when BAR2 is disabled. */
        uint64_t up_bx                 : 1;  /**< [  6:  6](R/W1C/H) Received P-TLP for an unknown BAR. */
        uint64_t un_b1                 : 1;  /**< [  7:  7](R/W1C/H) Received N-TLP for BAR1 when BAR1 index valid is not set. */
        uint64_t un_b2                 : 1;  /**< [  8:  8](R/W1C/H) Received N-TLP for BAR2 when BAR2 is disabled. */
        uint64_t un_bx                 : 1;  /**< [  9:  9](R/W1C/H) Received N-TLP for unknown BAR. */
        uint64_t reserved_10           : 1;
        uint64_t rdlk                  : 1;  /**< [ 11: 11](R/W1C/H) Received read lock TLP. */
        uint64_t crs_er                : 1;  /**< [ 12: 12](R/W1C/H) Had a CRS timeout when retries were enabled. */
        uint64_t crs_dr                : 1;  /**< [ 13: 13](R/W1C/H) Had a CRS timeout when retries were disabled. */
        uint64_t surp_down             : 1;  /**< [ 14: 14](R/W1C/H) Indicates that a surprise down event is occuring in the controller. */
        uint64_t reserved_15_63        : 49;
#endif /* Word 0 - End */
    } cn83xx;
};
typedef union bdk_pemx_int_sum bdk_pemx_int_sum_t;

static inline uint64_t BDK_PEMX_INT_SUM(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_INT_SUM(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN81XX) && (a<=2))
        return 0x87e0c0000428ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN83XX) && (a<=3))
        return 0x87e0c0000428ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN88XX) && (a<=5))
        return 0x87e0c0000428ll + 0x1000000ll * ((a) & 0x7);
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e00000000d8ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_INT_SUM", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_INT_SUM(a) bdk_pemx_int_sum_t
#define bustype_BDK_PEMX_INT_SUM(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_INT_SUM(a) "PEMX_INT_SUM"
#define device_bar_BDK_PEMX_INT_SUM(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_INT_SUM(a) (a)
#define arguments_BDK_PEMX_INT_SUM(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_int_sum_w1s
 *
 * PEM Interrupt Summary Register
 * This register sets interrupt bits.
 */
union bdk_pemx_int_sum_w1s
{
    uint64_t u;
    struct bdk_pemx_int_sum_w1s_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_16_63        : 48;
        uint64_t ptm_rdy_val           : 1;  /**< [ 15: 15](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[PTM_RDY_VAL]. */
        uint64_t reserved_0_14         : 15;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0_14         : 15;
        uint64_t ptm_rdy_val           : 1;  /**< [ 15: 15](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[PTM_RDY_VAL]. */
        uint64_t reserved_16_63        : 48;
#endif /* Word 0 - End */
    } s;
    struct bdk_pemx_int_sum_w1s_cn9
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_16_63        : 48;
        uint64_t ptm_rdy_val           : 1;  /**< [ 15: 15](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[PTM_RDY_VAL]. */
        uint64_t un_b0                 : 1;  /**< [ 14: 14](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[UN_B0]. */
        uint64_t up_b0                 : 1;  /**< [ 13: 13](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[UP_B0]. */
        uint64_t surp_down             : 1;  /**< [ 12: 12](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[SURP_DOWN]. */
        uint64_t cfg_inf               : 1;  /**< [ 11: 11](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[CFG_INF]. */
        uint64_t crs_dr                : 1;  /**< [ 10: 10](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[CRS_DR]. */
        uint64_t crs_er                : 1;  /**< [  9:  9](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[CRS_ER]. */
        uint64_t rdlk                  : 1;  /**< [  8:  8](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[RDLK]. */
        uint64_t un_bx                 : 1;  /**< [  7:  7](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[UN_BX]. */
        uint64_t un_b2                 : 1;  /**< [  6:  6](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[UN_B2]. */
        uint64_t un_b4                 : 1;  /**< [  5:  5](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[UN_B4]. */
        uint64_t up_bx                 : 1;  /**< [  4:  4](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[UP_BX]. */
        uint64_t up_b2                 : 1;  /**< [  3:  3](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[UP_B2]. */
        uint64_t up_b4                 : 1;  /**< [  2:  2](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[UP_B4]. */
        uint64_t up_b3                 : 1;  /**< [  1:  1](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[UP_B3]. */
        uint64_t se                    : 1;  /**< [  0:  0](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[SE].
                                                                 Internal:
                                                                 cfg_sys_err_rc. */
#else /* Word 0 - Little Endian */
        uint64_t se                    : 1;  /**< [  0:  0](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[SE].
                                                                 Internal:
                                                                 cfg_sys_err_rc. */
        uint64_t up_b3                 : 1;  /**< [  1:  1](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[UP_B3]. */
        uint64_t up_b4                 : 1;  /**< [  2:  2](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[UP_B4]. */
        uint64_t up_b2                 : 1;  /**< [  3:  3](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[UP_B2]. */
        uint64_t up_bx                 : 1;  /**< [  4:  4](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[UP_BX]. */
        uint64_t un_b4                 : 1;  /**< [  5:  5](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[UN_B4]. */
        uint64_t un_b2                 : 1;  /**< [  6:  6](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[UN_B2]. */
        uint64_t un_bx                 : 1;  /**< [  7:  7](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[UN_BX]. */
        uint64_t rdlk                  : 1;  /**< [  8:  8](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[RDLK]. */
        uint64_t crs_er                : 1;  /**< [  9:  9](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[CRS_ER]. */
        uint64_t crs_dr                : 1;  /**< [ 10: 10](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[CRS_DR]. */
        uint64_t cfg_inf               : 1;  /**< [ 11: 11](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[CFG_INF]. */
        uint64_t surp_down             : 1;  /**< [ 12: 12](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[SURP_DOWN]. */
        uint64_t up_b0                 : 1;  /**< [ 13: 13](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[UP_B0]. */
        uint64_t un_b0                 : 1;  /**< [ 14: 14](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[UN_B0]. */
        uint64_t ptm_rdy_val           : 1;  /**< [ 15: 15](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[PTM_RDY_VAL]. */
        uint64_t reserved_16_63        : 48;
#endif /* Word 0 - End */
    } cn9;
    struct bdk_pemx_int_sum_w1s_cn81xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_14_63        : 50;
        uint64_t crs_dr                : 1;  /**< [ 13: 13](R/W1S/H) Reads or sets PEM(0..2)_INT_SUM[CRS_DR]. */
        uint64_t crs_er                : 1;  /**< [ 12: 12](R/W1S/H) Reads or sets PEM(0..2)_INT_SUM[CRS_ER]. */
        uint64_t rdlk                  : 1;  /**< [ 11: 11](R/W1S/H) Reads or sets PEM(0..2)_INT_SUM[RDLK]. */
        uint64_t reserved_10           : 1;
        uint64_t un_bx                 : 1;  /**< [  9:  9](R/W1S/H) Reads or sets PEM(0..2)_INT_SUM[UN_BX]. */
        uint64_t un_b2                 : 1;  /**< [  8:  8](R/W1S/H) Reads or sets PEM(0..2)_INT_SUM[UN_B2]. */
        uint64_t un_b1                 : 1;  /**< [  7:  7](R/W1S/H) Reads or sets PEM(0..2)_INT_SUM[UN_B1]. */
        uint64_t up_bx                 : 1;  /**< [  6:  6](R/W1S/H) Reads or sets PEM(0..2)_INT_SUM[UP_BX]. */
        uint64_t up_b2                 : 1;  /**< [  5:  5](R/W1S/H) Reads or sets PEM(0..2)_INT_SUM[UP_B2]. */
        uint64_t up_b1                 : 1;  /**< [  4:  4](R/W1S/H) Reads or sets PEM(0..2)_INT_SUM[UP_B1]. */
        uint64_t reserved_2_3          : 2;
        uint64_t se                    : 1;  /**< [  1:  1](R/W1S/H) Reads or sets PEM(0..2)_INT_SUM[SE].
                                                                 Internal:
                                                                 cfg_sys_err_rc. */
        uint64_t reserved_0            : 1;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0            : 1;
        uint64_t se                    : 1;  /**< [  1:  1](R/W1S/H) Reads or sets PEM(0..2)_INT_SUM[SE].
                                                                 Internal:
                                                                 cfg_sys_err_rc. */
        uint64_t reserved_2_3          : 2;
        uint64_t up_b1                 : 1;  /**< [  4:  4](R/W1S/H) Reads or sets PEM(0..2)_INT_SUM[UP_B1]. */
        uint64_t up_b2                 : 1;  /**< [  5:  5](R/W1S/H) Reads or sets PEM(0..2)_INT_SUM[UP_B2]. */
        uint64_t up_bx                 : 1;  /**< [  6:  6](R/W1S/H) Reads or sets PEM(0..2)_INT_SUM[UP_BX]. */
        uint64_t un_b1                 : 1;  /**< [  7:  7](R/W1S/H) Reads or sets PEM(0..2)_INT_SUM[UN_B1]. */
        uint64_t un_b2                 : 1;  /**< [  8:  8](R/W1S/H) Reads or sets PEM(0..2)_INT_SUM[UN_B2]. */
        uint64_t un_bx                 : 1;  /**< [  9:  9](R/W1S/H) Reads or sets PEM(0..2)_INT_SUM[UN_BX]. */
        uint64_t reserved_10           : 1;
        uint64_t rdlk                  : 1;  /**< [ 11: 11](R/W1S/H) Reads or sets PEM(0..2)_INT_SUM[RDLK]. */
        uint64_t crs_er                : 1;  /**< [ 12: 12](R/W1S/H) Reads or sets PEM(0..2)_INT_SUM[CRS_ER]. */
        uint64_t crs_dr                : 1;  /**< [ 13: 13](R/W1S/H) Reads or sets PEM(0..2)_INT_SUM[CRS_DR]. */
        uint64_t reserved_14_63        : 50;
#endif /* Word 0 - End */
    } cn81xx;
    struct bdk_pemx_int_sum_w1s_cn88xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_14_63        : 50;
        uint64_t crs_dr                : 1;  /**< [ 13: 13](R/W1S/H) Reads or sets PEM(0..5)_INT_SUM[CRS_DR]. */
        uint64_t crs_er                : 1;  /**< [ 12: 12](R/W1S/H) Reads or sets PEM(0..5)_INT_SUM[CRS_ER]. */
        uint64_t rdlk                  : 1;  /**< [ 11: 11](R/W1S/H) Reads or sets PEM(0..5)_INT_SUM[RDLK]. */
        uint64_t reserved_10           : 1;
        uint64_t un_bx                 : 1;  /**< [  9:  9](R/W1S/H) Reads or sets PEM(0..5)_INT_SUM[UN_BX]. */
        uint64_t un_b2                 : 1;  /**< [  8:  8](R/W1S/H) Reads or sets PEM(0..5)_INT_SUM[UN_B2]. */
        uint64_t un_b1                 : 1;  /**< [  7:  7](R/W1S/H) Reads or sets PEM(0..5)_INT_SUM[UN_B1]. */
        uint64_t up_bx                 : 1;  /**< [  6:  6](R/W1S/H) Reads or sets PEM(0..5)_INT_SUM[UP_BX]. */
        uint64_t up_b2                 : 1;  /**< [  5:  5](R/W1S/H) Reads or sets PEM(0..5)_INT_SUM[UP_B2]. */
        uint64_t up_b1                 : 1;  /**< [  4:  4](R/W1S/H) Reads or sets PEM(0..5)_INT_SUM[UP_B1]. */
        uint64_t reserved_2_3          : 2;
        uint64_t se                    : 1;  /**< [  1:  1](R/W1S/H) Reads or sets PEM(0..5)_INT_SUM[SE].
                                                                 Internal:
                                                                 cfg_sys_err_rc. */
        uint64_t reserved_0            : 1;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0            : 1;
        uint64_t se                    : 1;  /**< [  1:  1](R/W1S/H) Reads or sets PEM(0..5)_INT_SUM[SE].
                                                                 Internal:
                                                                 cfg_sys_err_rc. */
        uint64_t reserved_2_3          : 2;
        uint64_t up_b1                 : 1;  /**< [  4:  4](R/W1S/H) Reads or sets PEM(0..5)_INT_SUM[UP_B1]. */
        uint64_t up_b2                 : 1;  /**< [  5:  5](R/W1S/H) Reads or sets PEM(0..5)_INT_SUM[UP_B2]. */
        uint64_t up_bx                 : 1;  /**< [  6:  6](R/W1S/H) Reads or sets PEM(0..5)_INT_SUM[UP_BX]. */
        uint64_t un_b1                 : 1;  /**< [  7:  7](R/W1S/H) Reads or sets PEM(0..5)_INT_SUM[UN_B1]. */
        uint64_t un_b2                 : 1;  /**< [  8:  8](R/W1S/H) Reads or sets PEM(0..5)_INT_SUM[UN_B2]. */
        uint64_t un_bx                 : 1;  /**< [  9:  9](R/W1S/H) Reads or sets PEM(0..5)_INT_SUM[UN_BX]. */
        uint64_t reserved_10           : 1;
        uint64_t rdlk                  : 1;  /**< [ 11: 11](R/W1S/H) Reads or sets PEM(0..5)_INT_SUM[RDLK]. */
        uint64_t crs_er                : 1;  /**< [ 12: 12](R/W1S/H) Reads or sets PEM(0..5)_INT_SUM[CRS_ER]. */
        uint64_t crs_dr                : 1;  /**< [ 13: 13](R/W1S/H) Reads or sets PEM(0..5)_INT_SUM[CRS_DR]. */
        uint64_t reserved_14_63        : 50;
#endif /* Word 0 - End */
    } cn88xx;
    struct bdk_pemx_int_sum_w1s_cn83xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_15_63        : 49;
        uint64_t surp_down             : 1;  /**< [ 14: 14](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[SURP_DOWN]. */
        uint64_t crs_dr                : 1;  /**< [ 13: 13](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[CRS_DR]. */
        uint64_t crs_er                : 1;  /**< [ 12: 12](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[CRS_ER]. */
        uint64_t rdlk                  : 1;  /**< [ 11: 11](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[RDLK]. */
        uint64_t reserved_10           : 1;
        uint64_t un_bx                 : 1;  /**< [  9:  9](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[UN_BX]. */
        uint64_t un_b2                 : 1;  /**< [  8:  8](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[UN_B2]. */
        uint64_t un_b1                 : 1;  /**< [  7:  7](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[UN_B1]. */
        uint64_t up_bx                 : 1;  /**< [  6:  6](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[UP_BX]. */
        uint64_t up_b2                 : 1;  /**< [  5:  5](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[UP_B2]. */
        uint64_t up_b1                 : 1;  /**< [  4:  4](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[UP_B1]. */
        uint64_t up_b3                 : 1;  /**< [  3:  3](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[UP_B3]. */
        uint64_t reserved_2            : 1;
        uint64_t se                    : 1;  /**< [  1:  1](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[SE].
                                                                 Internal:
                                                                 cfg_sys_err_rc. */
        uint64_t reserved_0            : 1;
#else /* Word 0 - Little Endian */
        uint64_t reserved_0            : 1;
        uint64_t se                    : 1;  /**< [  1:  1](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[SE].
                                                                 Internal:
                                                                 cfg_sys_err_rc. */
        uint64_t reserved_2            : 1;
        uint64_t up_b3                 : 1;  /**< [  3:  3](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[UP_B3]. */
        uint64_t up_b1                 : 1;  /**< [  4:  4](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[UP_B1]. */
        uint64_t up_b2                 : 1;  /**< [  5:  5](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[UP_B2]. */
        uint64_t up_bx                 : 1;  /**< [  6:  6](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[UP_BX]. */
        uint64_t un_b1                 : 1;  /**< [  7:  7](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[UN_B1]. */
        uint64_t un_b2                 : 1;  /**< [  8:  8](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[UN_B2]. */
        uint64_t un_bx                 : 1;  /**< [  9:  9](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[UN_BX]. */
        uint64_t reserved_10           : 1;
        uint64_t rdlk                  : 1;  /**< [ 11: 11](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[RDLK]. */
        uint64_t crs_er                : 1;  /**< [ 12: 12](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[CRS_ER]. */
        uint64_t crs_dr                : 1;  /**< [ 13: 13](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[CRS_DR]. */
        uint64_t surp_down             : 1;  /**< [ 14: 14](R/W1S/H) Reads or sets PEM(0..3)_INT_SUM[SURP_DOWN]. */
        uint64_t reserved_15_63        : 49;
#endif /* Word 0 - End */
    } cn83xx;
};
typedef union bdk_pemx_int_sum_w1s bdk_pemx_int_sum_w1s_t;

static inline uint64_t BDK_PEMX_INT_SUM_W1S(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_INT_SUM_W1S(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN81XX) && (a<=2))
        return 0x87e0c0000430ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN83XX) && (a<=3))
        return 0x87e0c0000430ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN88XX) && (a<=5))
        return 0x87e0c0000430ll + 0x1000000ll * ((a) & 0x7);
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e00000000e0ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_INT_SUM_W1S", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_INT_SUM_W1S(a) bdk_pemx_int_sum_w1s_t
#define bustype_BDK_PEMX_INT_SUM_W1S(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_INT_SUM_W1S(a) "PEMX_INT_SUM_W1S"
#define device_bar_BDK_PEMX_INT_SUM_W1S(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_INT_SUM_W1S(a) (a)
#define arguments_BDK_PEMX_INT_SUM_W1S(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_latency_pc
 *
 * PEM Latency Count Register
 * This register contains read latency count for debugging purposes.
 *
 * This register is not accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on PEM domain reset.
 */
union bdk_pemx_latency_pc
{
    uint64_t u;
    struct bdk_pemx_latency_pc_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t latency               : 64; /**< [ 63:  0](RO/H) Total read latency count in units of coprocessor-clocks measured from
                                                                 SLI read request until first data is returned from remote memory aggregated
                                                                 across all non-masked SWI tags. */
#else /* Word 0 - Little Endian */
        uint64_t latency               : 64; /**< [ 63:  0](RO/H) Total read latency count in units of coprocessor-clocks measured from
                                                                 SLI read request until first data is returned from remote memory aggregated
                                                                 across all non-masked SWI tags. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_latency_pc_s cn8; */
    struct bdk_pemx_latency_pc_cn9
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t latency               : 64; /**< [ 63:  0](R/W/H) Total read latency count in 10 ns units measured from an internal point in PEM
                                                                 after coming from either NCBO (but prior to any merging logic) or EBO, to an
                                                                 internal point in PEM where the corresponding completion is sent to the NCBI
                                                                 or EBI interface logic. PEM()_LATENCY_PC_CTL[EBO_SEL] controls which
                                                                 outbound bus has its reads latency tracked.  This register can only be written
                                                                 by software when PEM()_LATENCY_PC_CTL[ACTIVE] is clear. */
#else /* Word 0 - Little Endian */
        uint64_t latency               : 64; /**< [ 63:  0](R/W/H) Total read latency count in 10 ns units measured from an internal point in PEM
                                                                 after coming from either NCBO (but prior to any merging logic) or EBO, to an
                                                                 internal point in PEM where the corresponding completion is sent to the NCBI
                                                                 or EBI interface logic. PEM()_LATENCY_PC_CTL[EBO_SEL] controls which
                                                                 outbound bus has its reads latency tracked.  This register can only be written
                                                                 by software when PEM()_LATENCY_PC_CTL[ACTIVE] is clear. */
#endif /* Word 0 - End */
    } cn9;
};
typedef union bdk_pemx_latency_pc bdk_pemx_latency_pc_t;

static inline uint64_t BDK_PEMX_LATENCY_PC(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_LATENCY_PC(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN83XX) && (a<=3))
        return 0x87e0c0000490ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e0000000108ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_LATENCY_PC", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_LATENCY_PC(a) bdk_pemx_latency_pc_t
#define bustype_BDK_PEMX_LATENCY_PC(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_LATENCY_PC(a) "PEMX_LATENCY_PC"
#define device_bar_BDK_PEMX_LATENCY_PC(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_LATENCY_PC(a) (a)
#define arguments_BDK_PEMX_LATENCY_PC(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_latency_pc_ctl
 *
 * PEM Latency Control Register
 * This register controls read latency monitoring for debugging purposes.
 *
 * This register is not accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on PEM domain reset.
 */
union bdk_pemx_latency_pc_ctl
{
    uint64_t u;
    struct bdk_pemx_latency_pc_ctl_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_3_63         : 61;
        uint64_t ebo_sel               : 1;  /**< [  2:  2](R/W) If set, latency will be measured on EBO reads instead of NCBO reads. */
        uint64_t complete              : 1;  /**< [  1:  1](RO/H) When software causes a rising edge on [ACTIVE], hardware will clear this
                                                                 bit. Later, when software clears [ACTIVE], hardware will wait for all
                                                                 outstanding reads to get their first data returned and then set this bit to
                                                                 indicate that measurement operations are completed. */
        uint64_t active                : 1;  /**< [  0:  0](R/W) When a software write causes a rising edge on this bit, PEM will begin a
                                                                 measurement which will include PEM clearing PEM()_LATENCY_PC and PEM()_READS_PC
                                                                 to reset all counting as well as PEM clearing PEM()_LATENCY_CTL[COMPLETE]. Only
                                                                 SLI SWI reads that occur after this rising edge will be considered. When
                                                                 software wants to halt measurement, it can clear this bit which will block
                                                                 further reads from being considered. When software reads
                                                                 PEM()_LATENCY_CTL[COMPLETE] as set, it can know that all measurement is
                                                                 completed and PEM()_LATENCY_PC and PEM()_READS_PC reflect a completely accurate
                                                                 and stable set of values. */
#else /* Word 0 - Little Endian */
        uint64_t active                : 1;  /**< [  0:  0](R/W) When a software write causes a rising edge on this bit, PEM will begin a
                                                                 measurement which will include PEM clearing PEM()_LATENCY_PC and PEM()_READS_PC
                                                                 to reset all counting as well as PEM clearing PEM()_LATENCY_CTL[COMPLETE]. Only
                                                                 SLI SWI reads that occur after this rising edge will be considered. When
                                                                 software wants to halt measurement, it can clear this bit which will block
                                                                 further reads from being considered. When software reads
                                                                 PEM()_LATENCY_CTL[COMPLETE] as set, it can know that all measurement is
                                                                 completed and PEM()_LATENCY_PC and PEM()_READS_PC reflect a completely accurate
                                                                 and stable set of values. */
        uint64_t complete              : 1;  /**< [  1:  1](RO/H) When software causes a rising edge on [ACTIVE], hardware will clear this
                                                                 bit. Later, when software clears [ACTIVE], hardware will wait for all
                                                                 outstanding reads to get their first data returned and then set this bit to
                                                                 indicate that measurement operations are completed. */
        uint64_t ebo_sel               : 1;  /**< [  2:  2](R/W) If set, latency will be measured on EBO reads instead of NCBO reads. */
        uint64_t reserved_3_63         : 61;
#endif /* Word 0 - End */
    } s;
    struct bdk_pemx_latency_pc_ctl_cn8
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_2_63         : 62;
        uint64_t complete              : 1;  /**< [  1:  1](RO/H) When software causes a rising edge on [ACTIVE], hardware will clear this
                                                                 bit. Later, when software clears [ACTIVE], hardware will wait for all
                                                                 outstanding reads to get their first data returned and then set this bit to
                                                                 indicate that measurement operations are completed. */
        uint64_t active                : 1;  /**< [  0:  0](R/W) When a software write causes a rising edge on this bit, PEM will begin a
                                                                 measurement which will include PEM clearing PEM()_LATENCY_PC and PEM()_READS_PC
                                                                 to reset all counting as well as PEM clearing PEM()_LATENCY_CTL[COMPLETE]. Only
                                                                 SLI SWI reads that occur after this rising edge will be considered. When
                                                                 software wants to halt measurement, it can clear this bit which will block
                                                                 further reads from being considered. When software reads
                                                                 PEM()_LATENCY_CTL[COMPLETE] as set, it can know that all measurement is
                                                                 completed and PEM()_LATENCY_PC and PEM()_READS_PC reflect a completely accurate
                                                                 and stable set of values. */
#else /* Word 0 - Little Endian */
        uint64_t active                : 1;  /**< [  0:  0](R/W) When a software write causes a rising edge on this bit, PEM will begin a
                                                                 measurement which will include PEM clearing PEM()_LATENCY_PC and PEM()_READS_PC
                                                                 to reset all counting as well as PEM clearing PEM()_LATENCY_CTL[COMPLETE]. Only
                                                                 SLI SWI reads that occur after this rising edge will be considered. When
                                                                 software wants to halt measurement, it can clear this bit which will block
                                                                 further reads from being considered. When software reads
                                                                 PEM()_LATENCY_CTL[COMPLETE] as set, it can know that all measurement is
                                                                 completed and PEM()_LATENCY_PC and PEM()_READS_PC reflect a completely accurate
                                                                 and stable set of values. */
        uint64_t complete              : 1;  /**< [  1:  1](RO/H) When software causes a rising edge on [ACTIVE], hardware will clear this
                                                                 bit. Later, when software clears [ACTIVE], hardware will wait for all
                                                                 outstanding reads to get their first data returned and then set this bit to
                                                                 indicate that measurement operations are completed. */
        uint64_t reserved_2_63         : 62;
#endif /* Word 0 - End */
    } cn8;
    struct bdk_pemx_latency_pc_ctl_cn9
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_3_63         : 61;
        uint64_t ebo_sel               : 1;  /**< [  2:  2](R/W) If set, latency will be measured on EBO reads instead of NCBO reads. */
        uint64_t complete              : 1;  /**< [  1:  1](RO/H) When software causes a rising edge on [ACTIVE], hardware will clear this
                                                                 bit. Later, when software clears [ACTIVE], hardware will wait for all
                                                                 outstanding reads to get their first data returned and then set this bit to
                                                                 indicate that measurement operations are completed. */
        uint64_t active                : 1;  /**< [  0:  0](R/W) When a software write causes a rising edge on [ACTIVE], PEM will begin a
                                                                 measurement using existing values for PEM()_LATENCY_PC and PEM()_READS_PC
                                                                 as well as clear [COMPLETE]. Only NCBO reads that occur
                                                                 after this rising edge will be added into the results. When software wants
                                                                 to halt measurement, it can clear this bit which will block further reads
                                                                 from being considered. When software reads [COMPLETE] as set,
                                                                 it can know that all measurement is completed and PEM()_LATENCY_PC and
                                                                 PEM()_READS_PC reflect a completely accurate and stable set of values.

                                                                 Note that [ACTIVE] does not need to be cleared in order to read
                                                                 PEM()_LATENCY_PC and PEM()_READS_PC to calcuate average latency during active
                                                                 processing, but there will be some small error.

                                                                 Note that because software can write PEM()_LATENCY_PC and PEM()_READS_PC,
                                                                 PEM will not clear these values when a software write causes a rising edge on
                                                                 [ACTIVE].  Instead, software must initialize these two registers (probably
                                                                 both to 0) prior to starting a measurement. */
#else /* Word 0 - Little Endian */
        uint64_t active                : 1;  /**< [  0:  0](R/W) When a software write causes a rising edge on [ACTIVE], PEM will begin a
                                                                 measurement using existing values for PEM()_LATENCY_PC and PEM()_READS_PC
                                                                 as well as clear [COMPLETE]. Only NCBO reads that occur
                                                                 after this rising edge will be added into the results. When software wants
                                                                 to halt measurement, it can clear this bit which will block further reads
                                                                 from being considered. When software reads [COMPLETE] as set,
                                                                 it can know that all measurement is completed and PEM()_LATENCY_PC and
                                                                 PEM()_READS_PC reflect a completely accurate and stable set of values.

                                                                 Note that [ACTIVE] does not need to be cleared in order to read
                                                                 PEM()_LATENCY_PC and PEM()_READS_PC to calcuate average latency during active
                                                                 processing, but there will be some small error.

                                                                 Note that because software can write PEM()_LATENCY_PC and PEM()_READS_PC,
                                                                 PEM will not clear these values when a software write causes a rising edge on
                                                                 [ACTIVE].  Instead, software must initialize these two registers (probably
                                                                 both to 0) prior to starting a measurement. */
        uint64_t complete              : 1;  /**< [  1:  1](RO/H) When software causes a rising edge on [ACTIVE], hardware will clear this
                                                                 bit. Later, when software clears [ACTIVE], hardware will wait for all
                                                                 outstanding reads to get their first data returned and then set this bit to
                                                                 indicate that measurement operations are completed. */
        uint64_t ebo_sel               : 1;  /**< [  2:  2](R/W) If set, latency will be measured on EBO reads instead of NCBO reads. */
        uint64_t reserved_3_63         : 61;
#endif /* Word 0 - End */
    } cn9;
};
typedef union bdk_pemx_latency_pc_ctl bdk_pemx_latency_pc_ctl_t;

static inline uint64_t BDK_PEMX_LATENCY_PC_CTL(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_LATENCY_PC_CTL(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN83XX) && (a<=3))
        return 0x87e0c00004c0ll + 0x1000000ll * ((a) & 0x3);
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e0000000118ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_LATENCY_PC_CTL", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_LATENCY_PC_CTL(a) bdk_pemx_latency_pc_ctl_t
#define bustype_BDK_PEMX_LATENCY_PC_CTL(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_LATENCY_PC_CTL(a) "PEMX_LATENCY_PC_CTL"
#define device_bar_BDK_PEMX_LATENCY_PC_CTL(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_LATENCY_PC_CTL(a) (a)
#define arguments_BDK_PEMX_LATENCY_PC_CTL(a) (a),-1,-1,-1

/**
 * Register (RSL) pem#_latency_pc_mask#
 *
 * PEM Latency Counts Low Register
 * This register contains read latency masking for debugging purposes.
 */
union bdk_pemx_latency_pc_maskx
{
    uint64_t u;
    struct bdk_pemx_latency_pc_maskx_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t mask                  : 64; /**< [ 63:  0](R/W) Each bit of MASK corresponds to one SWI tag value. PEM()_LATENCY_PC_MASK(0)
                                                                 corresponds to SWI tags [63:0], PEM()_LATENCY_PC_MASK(1) corresponds to
                                                                 SWI tags [127:64].  If a bit of [MASK] is set, then its SWI tag will NOT be
                                                                 included in the values reported in PEM()_LATENCY_PC and PEM()_READS_PC. */
#else /* Word 0 - Little Endian */
        uint64_t mask                  : 64; /**< [ 63:  0](R/W) Each bit of MASK corresponds to one SWI tag value. PEM()_LATENCY_PC_MASK(0)
                                                                 corresponds to SWI tags [63:0], PEM()_LATENCY_PC_MASK(1) corresponds to
                                                                 SWI tags [127:64].  If a bit of [MASK] is set, then its SWI tag will NOT be
                                                                 included in the values reported in PEM()_LATENCY_PC and PEM()_READS_PC. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_latency_pc_maskx_s cn; */
};
typedef union bdk_pemx_latency_pc_maskx bdk_pemx_latency_pc_maskx_t;

static inline uint64_t BDK_PEMX_LATENCY_PC_MASKX(unsigned long a, unsigned long b) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_LATENCY_PC_MASKX(unsigned long a, unsigned long b)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN83XX) && ((a<=3) && (b<=1)))
        return 0x87e0c00004a0ll + 0x1000000ll * ((a) & 0x3) + 0x100ll * ((b) & 0x1);
    __bdk_csr_fatal("PEMX_LATENCY_PC_MASKX", 2, a, b, 0, 0);
}

#define typedef_BDK_PEMX_LATENCY_PC_MASKX(a,b) bdk_pemx_latency_pc_maskx_t
#define bustype_BDK_PEMX_LATENCY_PC_MASKX(a,b) BDK_CSR_TYPE_RSL
#define basename_BDK_PEMX_LATENCY_PC_MASKX(a,b) "PEMX_LATENCY_PC_MASKX"
#define device_bar_BDK_PEMX_LATENCY_PC_MASKX(a,b) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_LATENCY_PC_MASKX(a,b) (a)
#define arguments_BDK_PEMX_LATENCY_PC_MASKX(a,b) (a),(b),-1,-1

/**
 * Register (NCB) pem#_ltr_latency
 *
 * PEM Latency Tolerance Reporting Register
 * This register contains the current LTR values reported and in-use
 * by the downstream device.
 *
 * This register is not accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on MAC reset.
 */
union bdk_pemx_ltr_latency
{
    uint64_t u;
    struct bdk_pemx_ltr_latency_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_32_63        : 32;
        uint64_t latency               : 32; /**< [ 31:  0](RO/H) Reflects the captured LTR values from received LTR message in RC mode. */
#else /* Word 0 - Little Endian */
        uint64_t latency               : 32; /**< [ 31:  0](RO/H) Reflects the captured LTR values from received LTR message in RC mode. */
        uint64_t reserved_32_63        : 32;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_ltr_latency_s cn; */
};
typedef union bdk_pemx_ltr_latency bdk_pemx_ltr_latency_t;

static inline uint64_t BDK_PEMX_LTR_LATENCY(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_LTR_LATENCY(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e00000000b0ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_LTR_LATENCY", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_LTR_LATENCY(a) bdk_pemx_ltr_latency_t
#define bustype_BDK_PEMX_LTR_LATENCY(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_LTR_LATENCY(a) "PEMX_LTR_LATENCY"
#define device_bar_BDK_PEMX_LTR_LATENCY(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_LTR_LATENCY(a) (a)
#define arguments_BDK_PEMX_LTR_LATENCY(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_ltr_val#
 *
 * PEM Latency Tolerance Reporting Register
 * This register contains the values to put into the latency tolerance reporting (LTM) message
 * when triggered by hardware.  EP Mode.
 *
 * This register is accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on MAC reset.
 */
union bdk_pemx_ltr_valx
{
    uint64_t u;
    struct bdk_pemx_ltr_valx_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_32_63        : 32;
        uint64_t ns_lat                : 16; /**< [ 31: 16](R/W) No-snoop latency value to put into LTM message when triggered by hardware. */
        uint64_t snoop_lat             : 16; /**< [ 15:  0](R/W) Snoop latency value to put into LTM message when triggered by hardware. */
#else /* Word 0 - Little Endian */
        uint64_t snoop_lat             : 16; /**< [ 15:  0](R/W) Snoop latency value to put into LTM message when triggered by hardware. */
        uint64_t ns_lat                : 16; /**< [ 31: 16](R/W) No-snoop latency value to put into LTM message when triggered by hardware. */
        uint64_t reserved_32_63        : 32;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_ltr_valx_s cn; */
};
typedef union bdk_pemx_ltr_valx bdk_pemx_ltr_valx_t;

static inline uint64_t BDK_PEMX_LTR_VALX(unsigned long a, unsigned long b) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_LTR_VALX(unsigned long a, unsigned long b)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && ((a<=3) && (b<=1)))
        return 0x8e00000000a0ll + 0x1000000000ll * ((a) & 0x3) + 8ll * ((b) & 0x1);
    __bdk_csr_fatal("PEMX_LTR_VALX", 2, a, b, 0, 0);
}

#define typedef_BDK_PEMX_LTR_VALX(a,b) bdk_pemx_ltr_valx_t
#define bustype_BDK_PEMX_LTR_VALX(a,b) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_LTR_VALX(a,b) "PEMX_LTR_VALX"
#define device_bar_BDK_PEMX_LTR_VALX(a,b) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_LTR_VALX(a,b) (a)
#define arguments_BDK_PEMX_LTR_VALX(a,b) (a),(b),-1,-1

/**
 * Register (NCB) pem#_mac_lane#_eq
 *
 * PEM MAC Lane RX/TX Equalization Info Register
 * This register specifies the per lane RX/TX Equalization values advertised
 * by the link partner.
 *
 * This register is accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on MAC reset.
 */
union bdk_pemx_mac_lanex_eq
{
    uint64_t u;
    struct bdk_pemx_mac_lanex_eq_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_50_63        : 14;
        uint64_t pset_coef             : 18; /**< [ 49: 32](RO/H) Presets and coefficients chosen by the PEM. */
        uint64_t reserved_15_31        : 17;
        uint64_t rxphint               : 3;  /**< [ 14: 12](RO/H) Represents the RX equalization preset hint
                                                                 for the receiver. */
        uint64_t lf                    : 6;  /**< [ 11:  6](RO/H) Represents the low frequency value of the remote transmitter
                                                                 captured in Recovery.Equalization Phase 1. */
        uint64_t fs                    : 6;  /**< [  5:  0](RO/H) Represents the full swing value of the remote transmitter
                                                                 captured in Recovery.Equalization Phase 1. */
#else /* Word 0 - Little Endian */
        uint64_t fs                    : 6;  /**< [  5:  0](RO/H) Represents the full swing value of the remote transmitter
                                                                 captured in Recovery.Equalization Phase 1. */
        uint64_t lf                    : 6;  /**< [ 11:  6](RO/H) Represents the low frequency value of the remote transmitter
                                                                 captured in Recovery.Equalization Phase 1. */
        uint64_t rxphint               : 3;  /**< [ 14: 12](RO/H) Represents the RX equalization preset hint
                                                                 for the receiver. */
        uint64_t reserved_15_31        : 17;
        uint64_t pset_coef             : 18; /**< [ 49: 32](RO/H) Presets and coefficients chosen by the PEM. */
        uint64_t reserved_50_63        : 14;
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_mac_lanex_eq_s cn; */
};
typedef union bdk_pemx_mac_lanex_eq bdk_pemx_mac_lanex_eq_t;

static inline uint64_t BDK_PEMX_MAC_LANEX_EQ(unsigned long a, unsigned long b) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_MAC_LANEX_EQ(unsigned long a, unsigned long b)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && ((a<=3) && (b<=15)))
        return 0x8e0000000780ll + 0x1000000000ll * ((a) & 0x3) + 8ll * ((b) & 0xf);
    __bdk_csr_fatal("PEMX_MAC_LANEX_EQ", 2, a, b, 0, 0);
}

#define typedef_BDK_PEMX_MAC_LANEX_EQ(a,b) bdk_pemx_mac_lanex_eq_t
#define bustype_BDK_PEMX_MAC_LANEX_EQ(a,b) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_MAC_LANEX_EQ(a,b) "PEMX_MAC_LANEX_EQ"
#define device_bar_BDK_PEMX_MAC_LANEX_EQ(a,b) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_MAC_LANEX_EQ(a,b) (a)
#define arguments_BDK_PEMX_MAC_LANEX_EQ(a,b) (a),(b),-1,-1

/**
 * Register (NCB) pem#_merge_timer_ctl
 *
 * PEM Merge Timer Control Register
 * This register controls merging timers and overrides for maximum merging size
 * for outbound reads, writes, and completions.
 *
 * This register is not accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on PEM domain reset.
 */
union bdk_pemx_merge_timer_ctl
{
    uint64_t u;
    struct bdk_pemx_merge_timer_ctl_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t cmerge_dis            : 1;  /**< [ 63: 63](R/W) For diagnostic use only.  If set, will disable outbound completion merging. */
        uint64_t cmerge_mps_limit      : 3;  /**< [ 62: 60](R/W) Completion merge maximum payload size limit value. Software can use this value
                                                                 to reduce the maximum size of a merged completion operation to a level below the
                                                                 MPS value coming from the PCIe core. A value of 0x0 limits to 128 bytes with
                                                                 each increase in value doubling the limit. The hardware is controlled by the
                                                                 lower of [CMERGE_MPS_LIMIT] and the MPS value coming from the PCIe core. Resets
                                                                 to a value guaranteed to be at least as large as any legal value for MPS coming
                                                                 from the PCIe core. */
        uint64_t cmerge_total_timer    : 7;  /**< [ 59: 53](R/W) Completion merge encapsulation timer. When PEM accepts an outbound completion
                                                                 which begins a completion merging process, [CMERGE_TOTAL_TIMER] specifies the
                                                                 maximum wait, in units of (coprocessor-clock cycles * 64), to merge additional
                                                                 completion transfers into one larger overall completion. The values for this
                                                                 field range from 1 to 127, with 0x0 used for diagnostics only and treated as
                                                                 never expire. This translates into a range of 64 to 8128 in units of
                                                                 co-processor-clock cycles.

                                                                 Internal:
                                                                 If, during diagnostics, a timer value of 0x0 causes final transactions to be
                                                                 stuck within the pipeline, those transactions can be released by changing the
                                                                 timer to a non-zero value. */
        uint64_t cmerge_segment_timer  : 7;  /**< [ 52: 46](R/W) Completion merge segment timer. The maximum wait, in coprocessor-clock cycles,
                                                                 to wait between each segment of the overall merge operation. Each iterative
                                                                 completion transfer added to the overall merge restarts this timer. The values
                                                                 for this field range from 1 to 127, with 0x0 used for diagnostics only and
                                                                 treated as never expire. This translates into a range of 64 to 8128 in units of
                                                                 co-processor-clock cycles.

                                                                 Internal:
                                                                 If, during diagnostics, a timer value of 0x0 causes final transactions to be
                                                                 stuck within the pipeline, those transactions can be released by changing the
                                                                 timer to a non-zero value. */
        uint64_t wmerge_mps_limit      : 3;  /**< [ 45: 43](R/W) Write merge maximum payload size limit value. Software can use this value to
                                                                 reduce the maximum size of a merged write operation to a level below the MPS
                                                                 value coming from the PCIe core. A value of 0 limits to 128 bytes with each
                                                                 increase in value doubling the limit. The hardware will be controlled by the
                                                                 LOWER of [WMERGE_MPS_LIMIT] and the MPS value coming from the PCIe core. Resets
                                                                 to a value guaranteed to be at least as large as any legal value for MPS coming
                                                                 from the PCIe core. */
        uint64_t wmerge_total_timer    : 10; /**< [ 42: 33](R/W) Write merge encapsulation timer. When PEM accepts an outbound write which begins
                                                                 a write merging process, [WMERGE_TOTAL_TIMER] specifies the maximum wait, in
                                                                 coprocessor-clock cycles, to merge additional write operations into one larger
                                                                 write. The values for this field range from 1 to 1023, with 0x0 used for
                                                                 diagnostics only and treated as never expire.

                                                                 Internal:
                                                                 If, during diagnostics, a timer value of 0x0 causes final transactions to be
                                                                 stuck within the pipeline, those transactions can be released by changing the
                                                                 timer to a non-zero value. */
        uint64_t wmerge_segment_timer  : 10; /**< [ 32: 23](R/W) Write merge segment timer. The maximum wait,
                                                                 in coprocessor-clock cycles, to wait between each segment of the overall merge
                                                                 operation.  Each iterative write operation added to the overall merge restarts this
                                                                 timer.  The values for this field range from 1 to 1023, with 0x0 used for
                                                                 diagnostics only and treated as never expire.

                                                                 Internal:
                                                                 If, during diagnostics, a timer value of 0x0 causes final transactions to be
                                                                 stuck within the pipeline, those transactions can be released by changing the
                                                                 timer to a non-zero value. */
        uint64_t rmerge_mrrs_limit     : 3;  /**< [ 22: 20](R/W) Read merge maximum read request size limit value. Software can use this value to
                                                                 reduce the maximum size of a merged read operation to a level below the MRRS
                                                                 value coming from the PCIe core. A value of 0x0 limits to 128 bytes with each
                                                                 increase in value doubling the limit. The hardware will be controlled by the
                                                                 LOWER of [RMERGE_MRRS_LIMIT] and the MRRS value coming from the PCIe
                                                                 core. Resets to a value guaranteed to be at least as large as any legal value
                                                                 for MRRS coming from the PCIe core. */
        uint64_t rmerge_total_timer    : 10; /**< [ 19: 10](R/W) Read merge encapsulation timer. When PEM accepts an outbound read which begins a
                                                                 read merging process, [RMERGE_TOTAL_TIMER] specifies the maximum wait, in
                                                                 coprocessor-clock cycles, to merge additional read operations into one larger
                                                                 read. The values for this field range from 1 to 1023, with 0x0 used for
                                                                 diagnostics only and treated as never expire.

                                                                 Internal:
                                                                 If, during diagnostics, a timer value of 0x0 causes final transactions to be
                                                                 stuck within the pipeline, those transactions can be released by changing the
                                                                 timer to a non-zero value. */
        uint64_t rmerge_segment_timer  : 10; /**< [  9:  0](R/W) Read merge segment timer. specifies the maximum wait, in coprocessor-clock
                                                                 cycles, to wait between each segment of the overall merge operation. Each
                                                                 iterative read operation added to the overall merge restarts this timer. The
                                                                 values for this field range from 1 to 1023, with 0x0 used for diagnostics only
                                                                 and treated as never expire.

                                                                 Internal:
                                                                 If, during diagnostics, a timer value of 0x0 causes final transactions to be
                                                                 stuck within the pipeline, those transactions can be released by changing the
                                                                 timer to a non-zero value. */
#else /* Word 0 - Little Endian */
        uint64_t rmerge_segment_timer  : 10; /**< [  9:  0](R/W) Read merge segment timer. specifies the maximum wait, in coprocessor-clock
                                                                 cycles, to wait between each segment of the overall merge operation. Each
                                                                 iterative read operation added to the overall merge restarts this timer. The
                                                                 values for this field range from 1 to 1023, with 0x0 used for diagnostics only
                                                                 and treated as never expire.

                                                                 Internal:
                                                                 If, during diagnostics, a timer value of 0x0 causes final transactions to be
                                                                 stuck within the pipeline, those transactions can be released by changing the
                                                                 timer to a non-zero value. */
        uint64_t rmerge_total_timer    : 10; /**< [ 19: 10](R/W) Read merge encapsulation timer. When PEM accepts an outbound read which begins a
                                                                 read merging process, [RMERGE_TOTAL_TIMER] specifies the maximum wait, in
                                                                 coprocessor-clock cycles, to merge additional read operations into one larger
                                                                 read. The values for this field range from 1 to 1023, with 0x0 used for
                                                                 diagnostics only and treated as never expire.

                                                                 Internal:
                                                                 If, during diagnostics, a timer value of 0x0 causes final transactions to be
                                                                 stuck within the pipeline, those transactions can be released by changing the
                                                                 timer to a non-zero value. */
        uint64_t rmerge_mrrs_limit     : 3;  /**< [ 22: 20](R/W) Read merge maximum read request size limit value. Software can use this value to
                                                                 reduce the maximum size of a merged read operation to a level below the MRRS
                                                                 value coming from the PCIe core. A value of 0x0 limits to 128 bytes with each
                                                                 increase in value doubling the limit. The hardware will be controlled by the
                                                                 LOWER of [RMERGE_MRRS_LIMIT] and the MRRS value coming from the PCIe
                                                                 core. Resets to a value guaranteed to be at least as large as any legal value
                                                                 for MRRS coming from the PCIe core. */
        uint64_t wmerge_segment_timer  : 10; /**< [ 32: 23](R/W) Write merge segment timer. The maximum wait,
                                                                 in coprocessor-clock cycles, to wait between each segment of the overall merge
                                                                 operation.  Each iterative write operation added to the overall merge restarts this
                                                                 timer.  The values for this field range from 1 to 1023, with 0x0 used for
                                                                 diagnostics only and treated as never expire.

                                                                 Internal:
                                                                 If, during diagnostics, a timer value of 0x0 causes final transactions to be
                                                                 stuck within the pipeline, those transactions can be released by changing the
                                                                 timer to a non-zero value. */
        uint64_t wmerge_total_timer    : 10; /**< [ 42: 33](R/W) Write merge encapsulation timer. When PEM accepts an outbound write which begins
                                                                 a write merging process, [WMERGE_TOTAL_TIMER] specifies the maximum wait, in
                                                                 coprocessor-clock cycles, to merge additional write operations into one larger
                                                                 write. The values for this field range from 1 to 1023, with 0x0 used for
                                                                 diagnostics only and treated as never expire.

                                                                 Internal:
                                                                 If, during diagnostics, a timer value of 0x0 causes final transactions to be
                                                                 stuck within the pipeline, those transactions can be released by changing the
                                                                 timer to a non-zero value. */
        uint64_t wmerge_mps_limit      : 3;  /**< [ 45: 43](R/W) Write merge maximum payload size limit value. Software can use this value to
                                                                 reduce the maximum size of a merged write operation to a level below the MPS
                                                                 value coming from the PCIe core. A value of 0 limits to 128 bytes with each
                                                                 increase in value doubling the limit. The hardware will be controlled by the
                                                                 LOWER of [WMERGE_MPS_LIMIT] and the MPS value coming from the PCIe core. Resets
                                                                 to a value guaranteed to be at least as large as any legal value for MPS coming
                                                                 from the PCIe core. */
        uint64_t cmerge_segment_timer  : 7;  /**< [ 52: 46](R/W) Completion merge segment timer. The maximum wait, in coprocessor-clock cycles,
                                                                 to wait between each segment of the overall merge operation. Each iterative
                                                                 completion transfer added to the overall merge restarts this timer. The values
                                                                 for this field range from 1 to 127, with 0x0 used for diagnostics only and
                                                                 treated as never expire. This translates into a range of 64 to 8128 in units of
                                                                 co-processor-clock cycles.

                                                                 Internal:
                                                                 If, during diagnostics, a timer value of 0x0 causes final transactions to be
                                                                 stuck within the pipeline, those transactions can be released by changing the
                                                                 timer to a non-zero value. */
        uint64_t cmerge_total_timer    : 7;  /**< [ 59: 53](R/W) Completion merge encapsulation timer. When PEM accepts an outbound completion
                                                                 which begins a completion merging process, [CMERGE_TOTAL_TIMER] specifies the
                                                                 maximum wait, in units of (coprocessor-clock cycles * 64), to merge additional
                                                                 completion transfers into one larger overall completion. The values for this
                                                                 field range from 1 to 127, with 0x0 used for diagnostics only and treated as
                                                                 never expire. This translates into a range of 64 to 8128 in units of
                                                                 co-processor-clock cycles.

                                                                 Internal:
                                                                 If, during diagnostics, a timer value of 0x0 causes final transactions to be
                                                                 stuck within the pipeline, those transactions can be released by changing the
                                                                 timer to a non-zero value. */
        uint64_t cmerge_mps_limit      : 3;  /**< [ 62: 60](R/W) Completion merge maximum payload size limit value. Software can use this value
                                                                 to reduce the maximum size of a merged completion operation to a level below the
                                                                 MPS value coming from the PCIe core. A value of 0x0 limits to 128 bytes with
                                                                 each increase in value doubling the limit. The hardware is controlled by the
                                                                 lower of [CMERGE_MPS_LIMIT] and the MPS value coming from the PCIe core. Resets
                                                                 to a value guaranteed to be at least as large as any legal value for MPS coming
                                                                 from the PCIe core. */
        uint64_t cmerge_dis            : 1;  /**< [ 63: 63](R/W) For diagnostic use only.  If set, will disable outbound completion merging. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_merge_timer_ctl_s cn; */
};
typedef union bdk_pemx_merge_timer_ctl bdk_pemx_merge_timer_ctl_t;

static inline uint64_t BDK_PEMX_MERGE_TIMER_CTL(unsigned long a) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_MERGE_TIMER_CTL(unsigned long a)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && (a<=3))
        return 0x8e0000000170ll + 0x1000000000ll * ((a) & 0x3);
    __bdk_csr_fatal("PEMX_MERGE_TIMER_CTL", 1, a, 0, 0, 0);
}

#define typedef_BDK_PEMX_MERGE_TIMER_CTL(a) bdk_pemx_merge_timer_ctl_t
#define bustype_BDK_PEMX_MERGE_TIMER_CTL(a) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_MERGE_TIMER_CTL(a) "PEMX_MERGE_TIMER_CTL"
#define device_bar_BDK_PEMX_MERGE_TIMER_CTL(a) 0x0 /* PF_BAR0 */
#define busnum_BDK_PEMX_MERGE_TIMER_CTL(a) (a)
#define arguments_BDK_PEMX_MERGE_TIMER_CTL(a) (a),-1,-1,-1

/**
 * Register (NCB) pem#_msix_pba#
 *
 * PEM MSI-X Pending Bit Array Registers
 * This register is the MSI-X PBA table, the bit number is indexed by the PEM_INT_VEC_E enumeration.
 *
 * This register is not accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on PEM domain reset.
 */
union bdk_pemx_msix_pbax
{
    uint64_t u;
    struct bdk_pemx_msix_pbax_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t pend                  : 64; /**< [ 63:  0](RO/H) Pending message for the associated PEM_MSIX_VEC()_CTL, enumerated by PEM_INT_VEC_E. Bits
                                                                 that have no associated PEM_INT_VEC_E are zero. */
#else /* Word 0 - Little Endian */
        uint64_t pend                  : 64; /**< [ 63:  0](RO/H) Pending message for the associated PEM_MSIX_VEC()_CTL, enumerated by PEM_INT_VEC_E. Bits
                                                                 that have no associated PEM_INT_VEC_E are zero. */
#endif /* Word 0 - End */
    } s;
    /* struct bdk_pemx_msix_pbax_s cn; */
};
typedef union bdk_pemx_msix_pbax bdk_pemx_msix_pbax_t;

static inline uint64_t BDK_PEMX_MSIX_PBAX(unsigned long a, unsigned long b) __attribute__ ((pure, always_inline));
static inline uint64_t BDK_PEMX_MSIX_PBAX(unsigned long a, unsigned long b)
{
    if (CAVIUM_IS_MODEL(CAVIUM_CN81XX) && ((a<=2) && (b==0)))
        return 0x87e0c0ff0000ll + 0x1000000ll * ((a) & 0x3) + 8ll * ((b) & 0x0);
    if (CAVIUM_IS_MODEL(CAVIUM_CN83XX) && ((a<=3) && (b==0)))
        return 0x87e0c0ff0000ll + 0x1000000ll * ((a) & 0x3) + 8ll * ((b) & 0x0);
    if (CAVIUM_IS_MODEL(CAVIUM_CN88XX) && ((a<=5) && (b==0)))
        return 0x87e0c0ff0000ll + 0x1000000ll * ((a) & 0x7) + 8ll * ((b) & 0x0);
    if (CAVIUM_IS_MODEL(CAVIUM_CN9XXX) && ((a<=3) && (b==0)))
        return 0x8e0f000f0000ll + 0x1000000000ll * ((a) & 0x3) + 8ll * ((b) & 0x0);
    __bdk_csr_fatal("PEMX_MSIX_PBAX", 2, a, b, 0, 0);
}

#define typedef_BDK_PEMX_MSIX_PBAX(a,b) bdk_pemx_msix_pbax_t
#define bustype_BDK_PEMX_MSIX_PBAX(a,b) BDK_CSR_TYPE_NCB
#define basename_BDK_PEMX_MSIX_PBAX(a,b) "PEMX_MSIX_PBAX"
#define device_bar_BDK_PEMX_MSIX_PBAX(a,b) 0x4 /* PF_BAR4 */
#define busnum_BDK_PEMX_MSIX_PBAX(a,b) (a)
#define arguments_BDK_PEMX_MSIX_PBAX(a,b) (a),(b),-1,-1

/**
 * Register (NCB) pem#_msix_vec#_addr
 *
 * PEM MSI-X Vector Table Address Registers
 * This register is the MSI-X vector table, indexed by the PEM_INT_VEC_E enumeration.
 *
 * This register is not accessible through ROM scripts; see SCR_WRITE32_S[ADDR].
 *
 * This register is reset on PEM domain reset.
 */
union bdk_pemx_msix_vecx_addr
{
    uint64_t u;
    struct bdk_pemx_msix_vecx_addr_s
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_53_63        : 11;
        uint64_t addr                  : 51; /**< [ 52:  2](R/W) IOVA to use for MSI-X delivery of this vector. */
        uint64_t reserved_1            : 1;
        uint64_t secvec                : 1;  /**< [  0:  0](SR/W) Secure vector.
                                                                 0 = This vector may be read or written by either secure or nonsecure states.
                                                                 1 = This vector's PEM()_MSIX_VEC()_ADDR, PEM()_MSIX_VEC()_CTL, and
                                                                 corresponding bit of PEM()_MSIX_PBA() are RAZ/WI and does not cause a fault when accessed
                                                                 by the nonsecure world.

                                                                 If PCCPF_PEM(0..5)_VSEC_SCTL[MSIX_SEC] (for documentation, see
                                                                 PCCPF_XXX_VSEC_SCTL[MSIX_SEC]) is
                                                                 set, all vectors are secure and function as if [SECVEC] was set. */
#else /* Word 0 - Little Endian */
        uint64_t secvec                : 1;  /**< [  0:  0](SR/W) Secure vector.
                                                                 0 = This vector may be read or written by either secure or nonsecure states.
                                                                 1 = This vector's PEM()_MSIX_VEC()_ADDR, PEM()_MSIX_VEC()_CTL, and
                                                                 corresponding bit of PEM()_MSIX_PBA() are RAZ/WI and does not cause a fault when accessed
                                                                 by the nonsecure world.

                                                                 If PCCPF_PEM(0..5)_VSEC_SCTL[MSIX_SEC] (for documentation, see
                                                                 PCCPF_XXX_VSEC_SCTL[MSIX_SEC]) is
                                                                 set, all vectors are secure and function as if [SECVEC] was set. */
        uint64_t reserved_1            : 1;
        uint64_t addr                  : 51; /**< [ 52:  2](R/W) IOVA to use for MSI-X delivery of this vector. */
        uint64_t reserved_53_63        : 11;
#endif /* Word 0 - End */
    } s;
    struct bdk_pemx_msix_vecx_addr_cn9
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_53_63        : 11;
        uint64_t addr                  : 51; /**< [ 52:  2](R/W) IOVA to use for MSI-X delivery of this vector. */
        uint64_t reserved_1            : 1;
        uint64_t secvec                : 1;  /**< [  0:  0](SR/W) Secure vector.
                                                                 0 = This vector may be read or written by either secure or nonsecure states.
                                                                 1 = This vector's PEM()_MSIX_VEC()_ADDR, PEM()_MSIX_VEC()_CTL, and
                                                                 corresponding bit of PEM()_MSIX_PBA() are RAZ/WI and does not cause a fault when accessed
                                                                 by the nonsecure world.

                                                                 If PCCPF_PEM()_VSEC_SCTL[MSIX_SEC] (for documentation, see
                                                                 PCCPF_XXX_VSEC_SCTL[MSIX_SEC]) is
                                                                 set, all vectors are secure and function as if [SECVEC] was set. */
#else /* Word 0 - Little Endian */
        uint64_t secvec                : 1;  /**< [  0:  0](SR/W) Secure vector.
                                                                 0 = This vector may be read or written by either secure or nonsecure states.
                                                                 1 = This vector's PEM()_MSIX_VEC()_ADDR, PEM()_MSIX_VEC()_CTL, and
                                                                 corresponding bit of PEM()_MSIX_PBA() are RAZ/WI and does not cause a fault when accessed
                                                                 by the nonsecure world.

                                                                 If PCCPF_PEM()_VSEC_SCTL[MSIX_SEC] (for documentation, see
                                                                 PCCPF_XXX_VSEC_SCTL[MSIX_SEC]) is
                                                                 set, all vectors are secure and function as if [SECVEC] was set. */
        uint64_t reserved_1            : 1;
        uint64_t addr                  : 51; /**< [ 52:  2](R/W) IOVA to use for MSI-X delivery of this vector. */
        uint64_t reserved_53_63        : 11;
#endif /* Word 0 - End */
    } cn9;
    struct bdk_pemx_msix_vecx_addr_cn81xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_49_63        : 15;
        uint64_t addr                  : 47; /**< [ 48:  2](R/W) IOVA to use for MSI-X delivery of this vector. */
        uint64_t reserved_1            : 1;
        uint64_t secvec                : 1;  /**< [  0:  0](SR/W) Secure vector.
                                                                 0 = This vector may be read or written by either secure or nonsecure states.
                                                                 1 = This vector's PEM()_MSIX_VEC()_ADDR, PEM()_MSIX_VEC()_CTL, and
                                                                 corresponding bit of PEM()_MSIX_PBA() are RAZ/WI and does not cause a fault when accessed
                                                                 by the nonsecure world.

                                                                 If PCCPF_PEM(0..2)_VSEC_SCTL[MSIX_SEC] (for documentation, see
                                                                 PCCPF_XXX_VSEC_SCTL[MSIX_SEC]) is
                                                                 set, all vectors are secure and function as if [SECVEC] was set. */
#else /* Word 0 - Little Endian */
        uint64_t secvec                : 1;  /**< [  0:  0](SR/W) Secure vector.
                                                                 0 = This vector may be read or written by either secure or nonsecure states.
                                                                 1 = This vector's PEM()_MSIX_VEC()_ADDR, PEM()_MSIX_VEC()_CTL, and
                                                                 corresponding bit of PEM()_MSIX_PBA() are RAZ/WI and does not cause a fault when accessed
                                                                 by the nonsecure world.

                                                                 If PCCPF_PEM(0..2)_VSEC_SCTL[MSIX_SEC] (for documentation, see
                                                                 PCCPF_XXX_VSEC_SCTL[MSIX_SEC]) is
                                                                 set, all vectors are secure and function as if [SECVEC] was set. */
        uint64_t reserved_1            : 1;
        uint64_t addr                  : 47; /**< [ 48:  2](R/W) IOVA to use for MSI-X delivery of this vector. */
        uint64_t reserved_49_63        : 15;
#endif /* Word 0 - End */
    } cn81xx;
    struct bdk_pemx_msix_vecx_addr_cn88xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_49_63        : 15;
        uint64_t addr                  : 47; /**< [ 48:  2](R/W) IOVA to use for MSI-X delivery of this vector. */
        uint64_t reserved_1            : 1;
        uint64_t secvec                : 1;  /**< [  0:  0](SR/W) Secure vector.
                                                                 0 = This vector may be read or written by either secure or nonsecure states.
                                                                 1 = This vector's PEM()_MSIX_VEC()_ADDR, PEM()_MSIX_VEC()_CTL, and
                                                                 corresponding bit of PEM()_MSIX_PBA() are RAZ/WI and does not cause a fault when accessed
                                                                 by the nonsecure world.

                                                                 If PCCPF_PEM(0..5)_VSEC_SCTL[MSIX_SEC] (for documentation, see
                                                                 PCCPF_XXX_VSEC_SCTL[MSIX_SEC]) is
                                                                 set, all vectors are secure and function as if [SECVEC] was set. */
#else /* Word 0 - Little Endian */
        uint64_t secvec                : 1;  /**< [  0:  0](SR/W) Secure vector.
                                                                 0 = This vector may be read or written by either secure or nonsecure states.
                                                                 1 = This vector's PEM()_MSIX_VEC()_ADDR, PEM()_MSIX_VEC()_CTL, and
                                                                 corresponding bit of PEM()_MSIX_PBA() are RAZ/WI and does not cause a fault when accessed
                                                                 by the nonsecure world.

                                                                 If PCCPF_PEM(0..5)_VSEC_SCTL[MSIX_SEC] (for documentation, see
                                                                 PCCPF_XXX_VSEC_SCTL[MSIX_SEC]) is
                                                                 set, all vectors are secure and function as if [SECVEC] was set. */
        uint64_t reserved_1            : 1;
        uint64_t addr                  : 47; /**< [ 48:  2](R/W) IOVA to use for MSI-X delivery of this vector. */
        uint64_t reserved_49_63        : 15;
#endif /* Word 0 - End */
    } cn88xx;
    struct bdk_pemx_msix_vecx_addr_cn83xx
    {
#if __BYTE_ORDER == __BIG_ENDIAN /* Word 0 - Big Endian */
        uint64_t reserved_49_63        : 15;
        uint64_t addr                  : 47; /**< [ 48:  2](R/W) IOVA to use for MSI-X delivery of this vector. */
        uint64_t reserved_1            : 1;
        uint64_t secvec                : 1;  /**< [  0:  0](SR/W) Secure vector.
                                                                 0 = This vector may be read or written by either secure or nonsecure states.
                                                                 1 = This vector's PEM()_MSIX_VEC()_ADDR, PEM()_MSIX_VEC()_CTL, and
                                                                 corresponding bit of PEM()_MSIX_PBA() are RAZ/WI and does not cause a fault when accessed
                                                                 by the nonsecure world.

                                                                 If PCCPF_PEM(0..3)_VSEC_SCTL[MSIX_SEC] (for documentation, see
                                                    