/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.pki;

import gnu.crypto.pki.X500Name;
import java.io.IOException;
import java.security.Principal;
import java.security.cert.CRL;
import java.security.cert.CRLSelector;
import java.security.cert.X509CRL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public class X509CRLSelectorImpl
implements CRLSelector {
    private Set issuerNames = new HashSet();

    public void addIssuerName(byte[] issuerName) throws IOException {
        this.issuerNames.add(new X500Name(issuerName));
    }

    public void addIssuerName(String issuerName) {
        this.issuerNames.add(new X500Name(issuerName));
    }

    public void addIssuerName(Principal issuerName) throws IOException {
        if (issuerName instanceof X500Name) {
            this.issuerNames.add(issuerName);
        } else if (issuerName instanceof X500Principal) {
            this.issuerNames.add(new X500Name(((X500Principal)issuerName).getEncoded()));
        } else {
            this.issuerNames.add(new X500Name(issuerName.getName()));
        }
    }

    public Collection getIssuerNames() {
        return Collections.unmodifiableSet(this.issuerNames);
    }

    public Object clone() {
        X509CRLSelectorImpl copy = new X509CRLSelectorImpl();
        copy.issuerNames.addAll(this.issuerNames);
        return copy;
    }

    public boolean match(CRL crl) {
        if (!(crl instanceof X509CRL)) {
            return false;
        }
        try {
            Principal p = ((X509CRL)crl).getIssuerDN();
            X500Name thisName = null;
            thisName = p instanceof X500Name ? (X500Name)p : (p instanceof X500Principal ? new X500Name(((X500Principal)p).getEncoded()) : new X500Name(p.getName()));
            Iterator it = this.issuerNames.iterator();
            while (it.hasNext()) {
                X500Name name = (X500Name)it.next();
                if (!thisName.equals(name)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

