#!/bin/sh
# Create directories for each category in a GNATS categories file. 
# Copyright (C) 1993, 1994, 1995 Free Software Foundation, Inc.
# Contributed by Brendan Kehoe (brendan@cygnus.com) and
# Tim Wicinski (wicinski@barn.com).
#
# This file is part of GNU GNATS.
#
# GNU GNATS is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# GNU GNATS is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GNU GNATS; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

prog=mkcat
USAGE="Usage: $prog [--help] [--database=databasename]"

# process command line options
while [ $# -gt 0 ]; do
  case "$1" in
    -d | --database)
      if [ $# -eq 1 ]; then echo "$USAGE"; exit 1; fi
      shift ; GNATSDB="$1" ; export GNATSDB ;;
    --database=*) GNATSDB="`echo $1 | sed 's/^[-a-z]*=//'`" ; export GNATSDB ;;
    -*)  echo "$USAGE" ; exit 1 ;;
  esac
  shift
done


GNATS_DB_DIR="`query-pr --print-directory-for-database`"

# verify gnats root
if [ ! -d ${GNATS_DB_DIR} ] ; then
   echo "$prog: No directory $GNATS_DB_DIR"
   exit 1
fi

query-pr --list-categories | awk -F: '{print $1}' | while read i
do
    if test -d "$GNATS_DB_DIR/$i"; then
	true
    else
	mkdir "$GNATS_DB_DIR/$i"
        echo "Category \`$GNATS_DB_DIR/$i' created."
    fi
done

exit 0
