/*
 * File automatically generated by
 * gengen 1.2 by Lorenzo Bettini 
 * http://www.gnu.org/software/gengen
 */

#include "custom_getopt_gen.h"

void
custom_getopt_gen_gen_class::generate_custom_getopt_gen(ostream &stream, unsigned int indent)
{
  string indent_str (indent, ' ');
  indent = 0;

  stream << "/*";
  stream << "\n";
  stream << indent_str;
  stream << " * Extracted from the glibc source tree, version 2.3.6";
  stream << "\n";
  stream << indent_str;
  stream << " *";
  stream << "\n";
  stream << indent_str;
  stream << " * Licensed under the GPL as per the whole glibc source tree.";
  stream << "\n";
  stream << indent_str;
  stream << " *";
  stream << "\n";
  stream << indent_str;
  stream << " * This file was modified so that getopt_long can be called";
  stream << "\n";
  stream << indent_str;
  stream << " * many times without risking previous memory to be spoiled.";
  stream << "\n";
  stream << indent_str;
  stream << " *";
  stream << "\n";
  stream << indent_str;
  stream << " * Modified by Andre Noll and Lorenzo Bettini for use in";
  stream << "\n";
  stream << indent_str;
  stream << " * GNU gengetopt generated files.";
  stream << "\n";
  stream << indent_str;
  stream << " *";
  stream << "\n";
  stream << indent_str;
  stream << " */";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "/* ";
  stream << "\n";
  stream << indent_str;
  stream << " * we must include anything we need since this file is not thought to be";
  stream << "\n";
  stream << indent_str;
  stream << " * inserted in a file already using getopt.h";
  stream << "\n";
  stream << indent_str;
  stream << " *";
  stream << "\n";
  stream << indent_str;
  stream << " * Lorenzo";
  stream << "\n";
  stream << indent_str;
  stream << " */";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "struct option";
  stream << "\n";
  stream << indent_str;
  stream << "{";
  stream << "\n";
  stream << indent_str;
  stream << "  const char *name;";
  stream << "\n";
  stream << indent_str;
  stream << "  /* has_arg can't be an enum because some compilers complain about";
  stream << "\n";
  stream << indent_str;
  stream << "     type mismatches in all the code that assumes it is an int.  */";
  stream << "\n";
  stream << indent_str;
  stream << "  int has_arg;";
  stream << "\n";
  stream << indent_str;
  stream << "  int *flag;";
  stream << "\n";
  stream << indent_str;
  stream << "  int val;";
  stream << "\n";
  stream << indent_str;
  stream << "};";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "/* For communication from `getopt' to the caller.";
  stream << "\n";
  stream << indent_str;
  stream << "   When `getopt' finds an option that takes an argument,";
  stream << "\n";
  stream << indent_str;
  stream << "   the argument value is returned here.";
  stream << "\n";
  stream << indent_str;
  stream << "   Also, when `ordering' is RETURN_IN_ORDER,";
  stream << "\n";
  stream << indent_str;
  stream << "   each non-option ARGV-element is returned here.  */";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "static char *optarg;";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "/* Index in ARGV of the next element to be scanned.";
  stream << "\n";
  stream << indent_str;
  stream << "   This is used for communication to and from the caller";
  stream << "\n";
  stream << indent_str;
  stream << "   and for communication between successive calls to `getopt'.";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "   On entry to `getopt', zero means this is the first call; initialize.";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "   When `getopt' returns -1, this is the index of the first of the";
  stream << "\n";
  stream << indent_str;
  stream << "   non-option elements that the caller should itself scan.";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "   Otherwise, `optind' communicates from one call to the next";
  stream << "\n";
  stream << indent_str;
  stream << "   how much of ARGV has been scanned so far.  */";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "static int optind;";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "/* Callers store zero here to inhibit the error message `getopt' prints";
  stream << "\n";
  stream << indent_str;
  stream << "   for unrecognized options.  */";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "static int opterr;";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "/* Set to an option character which was unrecognized.  */";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "static int optopt;";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "/* This version of `getopt' appears to the caller like standard Unix `getopt'";
  stream << "\n";
  stream << indent_str;
  stream << "   but it behaves differently for the user, since it allows the user";
  stream << "\n";
  stream << indent_str;
  stream << "   to intersperse the options with the other arguments.";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "   As `getopt' works, it permutes the elements of ARGV so that,";
  stream << "\n";
  stream << indent_str;
  stream << "   when it is done, all the options precede everything else.  Thus";
  stream << "\n";
  stream << indent_str;
  stream << "   all application programs are extended to handle flexible argument order.";
  stream << "\n";
  stream << indent_str;
  stream << "*/";
  stream << "\n";
  stream << indent_str;
  stream << "/*";
  stream << "\n";
  stream << indent_str;
  stream << "   If the field `flag' is not NULL, it points to a variable that is set";
  stream << "\n";
  stream << indent_str;
  stream << "   to the value given in the field `val' when the option is found, but";
  stream << "\n";
  stream << indent_str;
  stream << "   left unchanged if the option is not found.";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "   To have a long-named option do something other than set an `int' to";
  stream << "\n";
  stream << indent_str;
  stream << "   a compiled-in constant, such as set a value from `custom_optarg', set the";
  stream << "\n";
  stream << indent_str;
  stream << "   option's `flag' field to zero and its `val' field to a nonzero";
  stream << "\n";
  stream << indent_str;
  stream << "   value (the equivalent single-letter option character, if there is";
  stream << "\n";
  stream << indent_str;
  stream << "   one).  For long options that have a zero `flag' field, `getopt'";
  stream << "\n";
  stream << indent_str;
  stream << "   returns the contents of the `val' field.  */";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "/* Names for the values of the `has_arg' field of `struct option'.  */";
  stream << "\n";
  stream << indent_str;
  stream << "#ifndef no_argument";
  stream << "\n";
  stream << indent_str;
  stream << "#define no_argument		0";
  stream << "\n";
  stream << indent_str;
  stream << "#endif";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "#ifndef required_argument";
  stream << "\n";
  stream << indent_str;
  stream << "#define required_argument	1";
  stream << "\n";
  stream << indent_str;
  stream << "#endif";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "#ifndef optional_argument";
  stream << "\n";
  stream << indent_str;
  stream << "#define optional_argument	2";
  stream << "\n";
  stream << indent_str;
  stream << "#endif";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "struct custom_getopt_data {";
  stream << "\n";
  stream << indent_str;
  stream << "	/*";
  stream << "\n";
  stream << indent_str;
  stream << "	 * These have exactly the same meaning as the corresponding global variables,";
  stream << "\n";
  stream << indent_str;
  stream << "	 * except that they are used for the reentrant versions of getopt.";
  stream << "\n";
  stream << indent_str;
  stream << "	 */";
  stream << "\n";
  stream << indent_str;
  stream << "	int custom_optind;";
  stream << "\n";
  stream << indent_str;
  stream << "	int custom_opterr;";
  stream << "\n";
  stream << indent_str;
  stream << "	int custom_optopt;";
  stream << "\n";
  stream << indent_str;
  stream << "	char *custom_optarg;";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "	/* True if the internal members have been initialized.  */";
  stream << "\n";
  stream << indent_str;
  stream << "	int initialized;";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "	/*";
  stream << "\n";
  stream << indent_str;
  stream << "	 * The next char to be scanned in the option-element in which the last option";
  stream << "\n";
  stream << indent_str;
  stream << "	 * character we returned was found.  This allows us to pick up the scan where";
  stream << "\n";
  stream << indent_str;
  stream << "	 * we left off.  If this is zero, or a null string, it means resume the scan by";
  stream << "\n";
  stream << indent_str;
  stream << "	 * advancing to the next ARGV-element.";
  stream << "\n";
  stream << indent_str;
  stream << "	 */";
  stream << "\n";
  stream << indent_str;
  stream << "	char *nextchar;";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "	/*";
  stream << "\n";
  stream << indent_str;
  stream << "	 * Describe the part of ARGV that contains non-options that have been skipped.";
  stream << "\n";
  stream << indent_str;
  stream << "	 * `first_nonopt' is the index in ARGV of the first of them; `last_nonopt' is";
  stream << "\n";
  stream << indent_str;
  stream << "	 * the index after the last of them.";
  stream << "\n";
  stream << indent_str;
  stream << "	 */";
  stream << "\n";
  stream << indent_str;
  stream << "	int first_nonopt;";
  stream << "\n";
  stream << indent_str;
  stream << "	int last_nonopt;";
  stream << "\n";
  stream << indent_str;
  stream << "};";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "/*";
  stream << "\n";
  stream << indent_str;
  stream << " * the variables optarg, optind, opterr and optopt are renamed with";
  stream << "\n";
  stream << indent_str;
  stream << " * the custom_ prefix so that they don't interfere with getopt ones.";
  stream << "\n";
  stream << indent_str;
  stream << " *";
  stream << "\n";
  stream << indent_str;
  stream << " * Moreover they're static so they are visible only from within the";
  stream << "\n";
  stream << indent_str;
  stream << " * file where this very file will be included.";
  stream << "\n";
  stream << indent_str;
  stream << " */";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "/*";
  stream << "\n";
  stream << indent_str;
  stream << " * For communication from `custom_getopt' to the caller.  When `custom_getopt' finds an";
  stream << "\n";
  stream << indent_str;
  stream << " * option that takes an argument, the argument value is returned here.";
  stream << "\n";
  stream << indent_str;
  stream << " */";
  stream << "\n";
  stream << indent_str;
  stream << "static char *custom_optarg;";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "/*";
  stream << "\n";
  stream << indent_str;
  stream << " * Index in ARGV of the next element to be scanned.  This is used for";
  stream << "\n";
  stream << indent_str;
  stream << " * communication to and from the caller and for communication between";
  stream << "\n";
  stream << indent_str;
  stream << " * successive calls to `custom_getopt'.";
  stream << "\n";
  stream << indent_str;
  stream << " *";
  stream << "\n";
  stream << indent_str;
  stream << " * On entry to `custom_getopt', 1 means this is the first call; initialize.";
  stream << "\n";
  stream << indent_str;
  stream << " *";
  stream << "\n";
  stream << indent_str;
  stream << " * When `custom_getopt' returns -1, this is the index of the first of the non-option";
  stream << "\n";
  stream << indent_str;
  stream << " * elements that the caller should itself scan.";
  stream << "\n";
  stream << indent_str;
  stream << " *";
  stream << "\n";
  stream << indent_str;
  stream << " * Otherwise, `custom_optind' communicates from one call to the next how much of ARGV";
  stream << "\n";
  stream << indent_str;
  stream << " * has been scanned so far.";
  stream << "\n";
  stream << indent_str;
  stream << " *";
  stream << "\n";
  stream << indent_str;
  stream << " * 1003.2 says this must be 1 before any call.";
  stream << "\n";
  stream << indent_str;
  stream << " */";
  stream << "\n";
  stream << indent_str;
  stream << "static int custom_optind = 1;";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "/*";
  stream << "\n";
  stream << indent_str;
  stream << " * Callers store zero here to inhibit the error message for unrecognized";
  stream << "\n";
  stream << indent_str;
  stream << " * options.";
  stream << "\n";
  stream << indent_str;
  stream << " */";
  stream << "\n";
  stream << indent_str;
  stream << "static int custom_opterr = 1;";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "/*";
  stream << "\n";
  stream << indent_str;
  stream << " * Set to an option character which was unrecognized.  This must be initialized";
  stream << "\n";
  stream << indent_str;
  stream << " * on some systems to avoid linking in the system's own getopt implementation.";
  stream << "\n";
  stream << indent_str;
  stream << " */";
  stream << "\n";
  stream << indent_str;
  stream << "static int custom_optopt = '?';";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "/*";
  stream << "\n";
  stream << indent_str;
  stream << " * Exchange two adjacent subsequences of ARGV.  One subsequence is elements";
  stream << "\n";
  stream << indent_str;
  stream << " * [first_nonopt,last_nonopt) which contains all the non-options that have been";
  stream << "\n";
  stream << indent_str;
  stream << " * skipped so far.  The other is elements [last_nonopt,custom_optind), which contains";
  stream << "\n";
  stream << indent_str;
  stream << " * all the options processed since those non-options were skipped.";
  stream << "\n";
  stream << indent_str;
  stream << " * `first_nonopt' and `last_nonopt' are relocated so that they describe the new";
  stream << "\n";
  stream << indent_str;
  stream << " * indices of the non-options in ARGV after they are moved.";
  stream << "\n";
  stream << indent_str;
  stream << " */";
  stream << "\n";
  stream << indent_str;
  stream << "static void exchange(char **argv, struct custom_getopt_data *d)";
  stream << "\n";
  stream << indent_str;
  stream << "{";
  stream << "\n";
  stream << indent_str;
  stream << "	int bottom = d->first_nonopt;";
  stream << "\n";
  stream << indent_str;
  stream << "	int middle = d->last_nonopt;";
  stream << "\n";
  stream << indent_str;
  stream << "	int top = d->custom_optind;";
  stream << "\n";
  stream << indent_str;
  stream << "	char *tem;";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "	/*";
  stream << "\n";
  stream << indent_str;
  stream << "	 * Exchange the shorter segment with the far end of the longer segment.";
  stream << "\n";
  stream << indent_str;
  stream << "	 * That puts the shorter segment into the right place.  It leaves the";
  stream << "\n";
  stream << indent_str;
  stream << "	 * longer segment in the right place overall, but it consists of two";
  stream << "\n";
  stream << indent_str;
  stream << "	 * parts that need to be swapped next.";
  stream << "\n";
  stream << indent_str;
  stream << "	 */";
  stream << "\n";
  stream << indent_str;
  stream << "	while (top > middle && middle > bottom) {";
  stream << "\n";
  stream << indent_str;
  stream << "		if (top - middle > middle - bottom) {";
  stream << "\n";
  stream << indent_str;
  stream << "			/* Bottom segment is the short one.  */";
  stream << "\n";
  stream << indent_str;
  stream << "			int len = middle - bottom;";
  stream << "\n";
  stream << indent_str;
  stream << "			int i;";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "			/* Swap it with the top part of the top segment.  */";
  stream << "\n";
  stream << indent_str;
  stream << "			for (i = 0; i < len; i++) {";
  stream << "\n";
  stream << indent_str;
  stream << "				tem = argv[bottom + i];";
  stream << "\n";
  stream << indent_str;
  stream << "				argv[bottom + i] =";
  stream << "\n";
  stream << indent_str;
  stream << "					argv[top - (middle - bottom) + i];";
  stream << "\n";
  stream << indent_str;
  stream << "				argv[top - (middle - bottom) + i] = tem;";
  stream << "\n";
  stream << indent_str;
  stream << "			}";
  stream << "\n";
  stream << indent_str;
  stream << "			/* Exclude the moved bottom segment from further swapping.  */";
  stream << "\n";
  stream << indent_str;
  stream << "			top -= len;";
  stream << "\n";
  stream << indent_str;
  stream << "		} else {";
  stream << "\n";
  stream << indent_str;
  stream << "			/* Top segment is the short one.  */";
  stream << "\n";
  stream << indent_str;
  stream << "			int len = top - middle;";
  stream << "\n";
  stream << indent_str;
  stream << "			int i;";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "			/* Swap it with the bottom part of the bottom segment.  */";
  stream << "\n";
  stream << indent_str;
  stream << "			for (i = 0; i < len; i++) {";
  stream << "\n";
  stream << indent_str;
  stream << "				tem = argv[bottom + i];";
  stream << "\n";
  stream << indent_str;
  stream << "				argv[bottom + i] = argv[middle + i];";
  stream << "\n";
  stream << indent_str;
  stream << "				argv[middle + i] = tem;";
  stream << "\n";
  stream << indent_str;
  stream << "			}";
  stream << "\n";
  stream << indent_str;
  stream << "			/* Exclude the moved top segment from further swapping.  */";
  stream << "\n";
  stream << indent_str;
  stream << "			bottom += len;";
  stream << "\n";
  stream << indent_str;
  stream << "		}";
  stream << "\n";
  stream << indent_str;
  stream << "	}";
  stream << "\n";
  stream << indent_str;
  stream << "	/* Update records for the slots the non-options now occupy.  */";
  stream << "\n";
  stream << indent_str;
  stream << "	d->first_nonopt += (d->custom_optind - d->last_nonopt);";
  stream << "\n";
  stream << indent_str;
  stream << "	d->last_nonopt = d->custom_optind;";
  stream << "\n";
  stream << indent_str;
  stream << "}";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "/* Initialize the internal data when the first call is made.  */";
  stream << "\n";
  stream << indent_str;
  stream << "static void custom_getopt_initialize(struct custom_getopt_data *d)";
  stream << "\n";
  stream << indent_str;
  stream << "{";
  stream << "\n";
  stream << indent_str;
  stream << "	/*";
  stream << "\n";
  stream << indent_str;
  stream << "	 * Start processing options with ARGV-element 1 (since ARGV-element 0";
  stream << "\n";
  stream << indent_str;
  stream << "	 * is the program name); the sequence of previously skipped non-option";
  stream << "\n";
  stream << indent_str;
  stream << "	 * ARGV-elements is empty.";
  stream << "\n";
  stream << indent_str;
  stream << "	 */";
  stream << "\n";
  stream << indent_str;
  stream << "	d->first_nonopt = d->last_nonopt = d->custom_optind;";
  stream << "\n";
  stream << indent_str;
  stream << "	d->nextchar = NULL;";
  stream << "\n";
  stream << indent_str;
  stream << "	d->initialized = 1;";
  stream << "\n";
  stream << indent_str;
  stream << "}";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "#define NONOPTION_P (argv[d->custom_optind][0] != '-' || argv[d->custom_optind][1] == '\\0')";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "/* return: zero: continue, nonzero: return given value to user */";
  stream << "\n";
  stream << indent_str;
  stream << "static int shuffle_argv(int argc, char *const *argv,const struct option *longopts,";
  stream << "\n";
  stream << indent_str;
  stream << "	struct custom_getopt_data *d)";
  stream << "\n";
  stream << indent_str;
  stream << "{";
  stream << "\n";
  stream << indent_str;
  stream << "	/*";
  stream << "\n";
  stream << indent_str;
  stream << "	 * Give FIRST_NONOPT & LAST_NONOPT rational values if CUSTOM_OPTIND has been";
  stream << "\n";
  stream << indent_str;
  stream << "	 * moved back by the user (who may also have changed the arguments).";
  stream << "\n";
  stream << indent_str;
  stream << "	 */";
  stream << "\n";
  stream << indent_str;
  stream << "	if (d->last_nonopt > d->custom_optind)";
  stream << "\n";
  stream << indent_str;
  stream << "		d->last_nonopt = d->custom_optind;";
  stream << "\n";
  stream << indent_str;
  stream << "	if (d->first_nonopt > d->custom_optind)";
  stream << "\n";
  stream << indent_str;
  stream << "		d->first_nonopt = d->custom_optind;";
  stream << "\n";
  stream << indent_str;
  stream << "	/*";
  stream << "\n";
  stream << indent_str;
  stream << "	 * If we have just processed some options following some";
  stream << "\n";
  stream << indent_str;
  stream << "	 * non-options, exchange them so that the options come first.";
  stream << "\n";
  stream << indent_str;
  stream << "	 */";
  stream << "\n";
  stream << indent_str;
  stream << "	if (d->first_nonopt != d->last_nonopt &&";
  stream << "\n";
  stream << indent_str;
  stream << "			d->last_nonopt != d->custom_optind)";
  stream << "\n";
  stream << indent_str;
  stream << "		exchange((char **) argv, d);";
  stream << "\n";
  stream << indent_str;
  stream << "	else if (d->last_nonopt != d->custom_optind)";
  stream << "\n";
  stream << indent_str;
  stream << "		d->first_nonopt = d->custom_optind;";
  stream << "\n";
  stream << indent_str;
  stream << "	/*";
  stream << "\n";
  stream << indent_str;
  stream << "	 * Skip any additional non-options and extend the range of";
  stream << "\n";
  stream << indent_str;
  stream << "	 * non-options previously skipped.";
  stream << "\n";
  stream << indent_str;
  stream << "	 */";
  stream << "\n";
  stream << indent_str;
  stream << "	while (d->custom_optind < argc && NONOPTION_P)";
  stream << "\n";
  stream << indent_str;
  stream << "		d->custom_optind++;";
  stream << "\n";
  stream << indent_str;
  stream << "	d->last_nonopt = d->custom_optind;";
  stream << "\n";
  stream << indent_str;
  stream << "	/*";
  stream << "\n";
  stream << indent_str;
  stream << "	 * The special ARGV-element `--' means premature end of options.  Skip";
  stream << "\n";
  stream << indent_str;
  stream << "	 * it like a null option, then exchange with previous non-options as if";
  stream << "\n";
  stream << indent_str;
  stream << "	 * it were an option, then skip everything else like a non-option.";
  stream << "\n";
  stream << indent_str;
  stream << "	 */";
  stream << "\n";
  stream << indent_str;
  stream << "	if (d->custom_optind != argc && !strcmp(argv[d->custom_optind], \"--\")) {";
  stream << "\n";
  stream << indent_str;
  stream << "		d->custom_optind++;";
  stream << "\n";
  stream << indent_str;
  stream << "		if (d->first_nonopt != d->last_nonopt";
  stream << "\n";
  stream << indent_str;
  stream << "				&& d->last_nonopt != d->custom_optind)";
  stream << "\n";
  stream << indent_str;
  stream << "			exchange((char **) argv, d);";
  stream << "\n";
  stream << indent_str;
  stream << "		else if (d->first_nonopt == d->last_nonopt)";
  stream << "\n";
  stream << indent_str;
  stream << "			d->first_nonopt = d->custom_optind;";
  stream << "\n";
  stream << indent_str;
  stream << "		d->last_nonopt = argc;";
  stream << "\n";
  stream << indent_str;
  stream << "		d->custom_optind = argc;";
  stream << "\n";
  stream << indent_str;
  stream << "	}";
  stream << "\n";
  stream << indent_str;
  stream << "	/*";
  stream << "\n";
  stream << indent_str;
  stream << "	 * If we have done all the ARGV-elements, stop the scan and back over";
  stream << "\n";
  stream << indent_str;
  stream << "	 * any non-options that we skipped and permuted.";
  stream << "\n";
  stream << indent_str;
  stream << "	 */";
  stream << "\n";
  stream << indent_str;
  stream << "	if (d->custom_optind == argc) {";
  stream << "\n";
  stream << indent_str;
  stream << "		/*";
  stream << "\n";
  stream << indent_str;
  stream << "		 * Set the next-arg-index to point at the non-options that we";
  stream << "\n";
  stream << indent_str;
  stream << "		 * previously skipped, so the caller will digest them.";
  stream << "\n";
  stream << indent_str;
  stream << "		 */";
  stream << "\n";
  stream << indent_str;
  stream << "		if (d->first_nonopt != d->last_nonopt)";
  stream << "\n";
  stream << indent_str;
  stream << "			d->custom_optind = d->first_nonopt;";
  stream << "\n";
  stream << indent_str;
  stream << "		return -1;";
  stream << "\n";
  stream << indent_str;
  stream << "	}";
  stream << "\n";
  stream << indent_str;
  stream << "	/*";
  stream << "\n";
  stream << indent_str;
  stream << "	 * If we have come to a non-option and did not permute it, either stop";
  stream << "\n";
  stream << indent_str;
  stream << "	 * the scan or describe it to the caller and pass it by.";
  stream << "\n";
  stream << indent_str;
  stream << "	 */";
  stream << "\n";
  stream << indent_str;
  stream << "	if (NONOPTION_P) {";
  stream << "\n";
  stream << indent_str;
  stream << "		d->custom_optarg = argv[d->custom_optind++];";
  stream << "\n";
  stream << indent_str;
  stream << "		return 1;";
  stream << "\n";
  stream << indent_str;
  stream << "	}";
  stream << "\n";
  stream << indent_str;
  stream << "	/*";
  stream << "\n";
  stream << indent_str;
  stream << "	 * We have found another option-ARGV-element. Skip the initial";
  stream << "\n";
  stream << indent_str;
  stream << "	 * punctuation.";
  stream << "\n";
  stream << indent_str;
  stream << "	 */";
  stream << "\n";
  stream << indent_str;
  stream << "	d->nextchar = (argv[d->custom_optind] + 1 + (longopts != NULL && argv[d->custom_optind][1] == '-'));";
  stream << "\n";
  stream << indent_str;
  stream << "	return 0;";
  stream << "\n";
  stream << indent_str;
  stream << "}";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "/*";
  stream << "\n";
  stream << indent_str;
  stream << " * Check whether the ARGV-element is a long option.";
  stream << "\n";
  stream << indent_str;
  stream << " *";
  stream << "\n";
  stream << indent_str;
  stream << " * If there's a long option \"fubar\" and the ARGV-element is \"-fu\", consider";
  stream << "\n";
  stream << indent_str;
  stream << " * that an abbreviation of the long option, just like \"--fu\", and not \"-f\" with";
  stream << "\n";
  stream << indent_str;
  stream << " * arg \"u\".";
  stream << "\n";
  stream << indent_str;
  stream << " *";
  stream << "\n";
  stream << indent_str;
  stream << " * This distinction seems to be the most useful approach.";
  stream << "\n";
  stream << indent_str;
  stream << " *";
  stream << "\n";
  stream << indent_str;
  stream << " */";
  stream << "\n";
  stream << indent_str;
  stream << "static int check_long_opt(int argc, char *const *argv, const char *optstring,";
  stream << "\n";
  stream << indent_str;
  stream << "		const struct option *longopts, int *longind,";
  stream << "\n";
  stream << indent_str;
  stream << "		int print_errors, struct custom_getopt_data *d)";
  stream << "\n";
  stream << indent_str;
  stream << "{";
  stream << "\n";
  stream << indent_str;
  stream << "	char *nameend;";
  stream << "\n";
  stream << indent_str;
  stream << "	const struct option *p;";
  stream << "\n";
  stream << indent_str;
  stream << "	const struct option *pfound = NULL;";
  stream << "\n";
  stream << indent_str;
  stream << "	int exact = 0;";
  stream << "\n";
  stream << indent_str;
  stream << "	int ambig = 0;";
  stream << "\n";
  stream << indent_str;
  stream << "	int indfound = -1;";
  stream << "\n";
  stream << indent_str;
  stream << "	int option_index;";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "	for (nameend = d->nextchar; *nameend && *nameend != '='; nameend++)";
  stream << "\n";
  stream << indent_str;
  stream << "		/* Do nothing.  */ ;";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "	/* Test all long options for either exact match or abbreviated matches */";
  stream << "\n";
  stream << indent_str;
  stream << "	for (p = longopts, option_index = 0; p->name; p++, option_index++)";
  stream << "\n";
  stream << indent_str;
  stream << "		if (!strncmp(p->name, d->nextchar, nameend - d->nextchar)) {";
  stream << "\n";
  stream << indent_str;
  stream << "			if ((unsigned int) (nameend - d->nextchar)";
  stream << "\n";
  stream << indent_str;
  stream << "					== (unsigned int) strlen(p->name)) {";
  stream << "\n";
  stream << indent_str;
  stream << "				/* Exact match found.  */";
  stream << "\n";
  stream << indent_str;
  stream << "				pfound = p;";
  stream << "\n";
  stream << indent_str;
  stream << "				indfound = option_index;";
  stream << "\n";
  stream << indent_str;
  stream << "				exact = 1;";
  stream << "\n";
  stream << indent_str;
  stream << "				break;";
  stream << "\n";
  stream << indent_str;
  stream << "			} else if (pfound == NULL) {";
  stream << "\n";
  stream << indent_str;
  stream << "				/* First nonexact match found.  */";
  stream << "\n";
  stream << indent_str;
  stream << "				pfound = p;";
  stream << "\n";
  stream << indent_str;
  stream << "				indfound = option_index;";
  stream << "\n";
  stream << indent_str;
  stream << "			} else if (pfound->has_arg != p->has_arg";
  stream << "\n";
  stream << indent_str;
  stream << "					|| pfound->flag != p->flag";
  stream << "\n";
  stream << indent_str;
  stream << "					|| pfound->val != p->val)";
  stream << "\n";
  stream << indent_str;
  stream << "				/* Second or later nonexact match found.  */";
  stream << "\n";
  stream << indent_str;
  stream << "				ambig = 1;";
  stream << "\n";
  stream << indent_str;
  stream << "		}";
  stream << "\n";
  stream << indent_str;
  stream << "	if (ambig && !exact) {";
  stream << "\n";
  stream << indent_str;
  stream << "		if (print_errors) {";
  stream << "\n";
  stream << indent_str;
  stream << "			fprintf(stderr,";
  stream << "\n";
  stream << indent_str;
  stream << "				\"%s: option `%s' is ambiguous\\n\",";
  stream << "\n";
  stream << indent_str;
  stream << "				argv[0], argv[d->custom_optind]);";
  stream << "\n";
  stream << indent_str;
  stream << "		}";
  stream << "\n";
  stream << indent_str;
  stream << "		d->nextchar += strlen(d->nextchar);";
  stream << "\n";
  stream << indent_str;
  stream << "		d->custom_optind++;";
  stream << "\n";
  stream << indent_str;
  stream << "		d->custom_optopt = 0;";
  stream << "\n";
  stream << indent_str;
  stream << "		return '?';";
  stream << "\n";
  stream << indent_str;
  stream << "	}";
  stream << "\n";
  stream << indent_str;
  stream << "	if (pfound) {";
  stream << "\n";
  stream << indent_str;
  stream << "		option_index = indfound;";
  stream << "\n";
  stream << indent_str;
  stream << "		d->custom_optind++;";
  stream << "\n";
  stream << indent_str;
  stream << "		if (*nameend) {";
  stream << "\n";
  stream << indent_str;
  stream << "			if (pfound->has_arg != no_argument)";
  stream << "\n";
  stream << indent_str;
  stream << "				d->custom_optarg = nameend + 1;";
  stream << "\n";
  stream << indent_str;
  stream << "			else {";
  stream << "\n";
  stream << indent_str;
  stream << "				if (print_errors) {";
  stream << "\n";
  stream << indent_str;
  stream << "					if (argv[d->custom_optind - 1][1] == '-') {";
  stream << "\n";
  stream << indent_str;
  stream << "						/* --option */";
  stream << "\n";
  stream << indent_str;
  stream << "						fprintf(stderr, \"%s: option `--%s' doesn't allow an argument\\n\",";
  stream << "\n";
  stream << indent_str;
  stream << "							argv[0], pfound->name);";
  stream << "\n";
  stream << indent_str;
  stream << "					} else {";
  stream << "\n";
  stream << indent_str;
  stream << "						/* +option or -option */";
  stream << "\n";
  stream << indent_str;
  stream << "						fprintf(stderr, \"%s: option `%c%s' doesn't allow an argument\\n\",";
  stream << "\n";
  stream << indent_str;
  stream << "							argv[0], argv[d->custom_optind - 1][0], pfound->name);";
  stream << "\n";
  stream << indent_str;
  stream << "					}";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "				}";
  stream << "\n";
  stream << indent_str;
  stream << "				d->nextchar += strlen(d->nextchar);";
  stream << "\n";
  stream << indent_str;
  stream << "				d->custom_optopt = pfound->val;";
  stream << "\n";
  stream << indent_str;
  stream << "				return '?';";
  stream << "\n";
  stream << indent_str;
  stream << "			}";
  stream << "\n";
  stream << indent_str;
  stream << "		} else if (pfound->has_arg == required_argument) {";
  stream << "\n";
  stream << indent_str;
  stream << "			if (d->custom_optind < argc)";
  stream << "\n";
  stream << indent_str;
  stream << "				d->custom_optarg = argv[d->custom_optind++];";
  stream << "\n";
  stream << indent_str;
  stream << "			else {";
  stream << "\n";
  stream << indent_str;
  stream << "				if (print_errors) {";
  stream << "\n";
  stream << indent_str;
  stream << "					fprintf(stderr,";
  stream << "\n";
  stream << indent_str;
  stream << "						\"%s: option `%s' requires an argument\\n\",";
  stream << "\n";
  stream << indent_str;
  stream << "						argv[0],";
  stream << "\n";
  stream << indent_str;
  stream << "						argv[d->custom_optind - 1]);";
  stream << "\n";
  stream << indent_str;
  stream << "				}";
  stream << "\n";
  stream << indent_str;
  stream << "				d->nextchar += strlen(d->nextchar);";
  stream << "\n";
  stream << indent_str;
  stream << "				d->custom_optopt = pfound->val;";
  stream << "\n";
  stream << indent_str;
  stream << "				return optstring[0] == ':' ? ':' : '?';";
  stream << "\n";
  stream << indent_str;
  stream << "			}";
  stream << "\n";
  stream << indent_str;
  stream << "		}";
  stream << "\n";
  stream << indent_str;
  stream << "		d->nextchar += strlen(d->nextchar);";
  stream << "\n";
  stream << indent_str;
  stream << "		if (longind != NULL)";
  stream << "\n";
  stream << indent_str;
  stream << "			*longind = option_index;";
  stream << "\n";
  stream << indent_str;
  stream << "		if (pfound->flag) {";
  stream << "\n";
  stream << indent_str;
  stream << "			*(pfound->flag) = pfound->val;";
  stream << "\n";
  stream << indent_str;
  stream << "			return 0;";
  stream << "\n";
  stream << indent_str;
  stream << "		}";
  stream << "\n";
  stream << indent_str;
  stream << "		return pfound->val;";
  stream << "\n";
  stream << indent_str;
  stream << "	}";
  stream << "\n";
  stream << indent_str;
  stream << "	/*";
  stream << "\n";
  stream << indent_str;
  stream << "	 * Can't find it as a long option.  If this is not getopt_long_only, or";
  stream << "\n";
  stream << indent_str;
  stream << "	 * the option starts with '--' or is not a valid short option, then";
  stream << "\n";
  stream << indent_str;
  stream << "	 * it's an error.  Otherwise interpret it as a short option.";
  stream << "\n";
  stream << indent_str;
  stream << "	 */";
  stream << "\n";
  stream << indent_str;
  stream << "	if (print_errors) {";
  stream << "\n";
  stream << indent_str;
  stream << "		if (argv[d->custom_optind][1] == '-') {";
  stream << "\n";
  stream << indent_str;
  stream << "			/* --option */";
  stream << "\n";
  stream << indent_str;
  stream << "			fprintf(stderr,";
  stream << "\n";
  stream << indent_str;
  stream << "				\"%s: unrecognized option `--%s'\\n\",";
  stream << "\n";
  stream << indent_str;
  stream << "				argv[0], d->nextchar);";
  stream << "\n";
  stream << indent_str;
  stream << "		} else {";
  stream << "\n";
  stream << indent_str;
  stream << "			/* +option or -option */";
  stream << "\n";
  stream << indent_str;
  stream << "			fprintf(stderr,";
  stream << "\n";
  stream << indent_str;
  stream << "				\"%s: unrecognized option `%c%s'\\n\",";
  stream << "\n";
  stream << indent_str;
  stream << "				argv[0], argv[d->custom_optind][0],";
  stream << "\n";
  stream << indent_str;
  stream << "				d->nextchar);";
  stream << "\n";
  stream << indent_str;
  stream << "		}";
  stream << "\n";
  stream << indent_str;
  stream << "	}";
  stream << "\n";
  stream << indent_str;
  stream << "	d->nextchar = (char *) \"\";";
  stream << "\n";
  stream << indent_str;
  stream << "	d->custom_optind++;";
  stream << "\n";
  stream << indent_str;
  stream << "	d->custom_optopt = 0;";
  stream << "\n";
  stream << indent_str;
  stream << "	return '?';";
  stream << "\n";
  stream << indent_str;
  stream << "}";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "static int check_short_opt(int argc, char *const *argv, const char *optstring,";
  stream << "\n";
  stream << indent_str;
  stream << "		int print_errors, struct custom_getopt_data *d)";
  stream << "\n";
  stream << indent_str;
  stream << "{";
  stream << "\n";
  stream << indent_str;
  stream << "	char c = *d->nextchar++;";
  stream << "\n";
  stream << indent_str;
  stream << "	const char *temp = strchr(optstring, c);";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "	/* Increment `custom_optind' when we start to process its last character.  */";
  stream << "\n";
  stream << indent_str;
  stream << "	if (*d->nextchar == '\\0')";
  stream << "\n";
  stream << indent_str;
  stream << "		++d->custom_optind;";
  stream << "\n";
  stream << indent_str;
  stream << "	if (!temp || c == ':') {";
  stream << "\n";
  stream << indent_str;
  stream << "		if (print_errors)";
  stream << "\n";
  stream << indent_str;
  stream << "			fprintf(stderr, \"%s: invalid option -- %c\\n\", argv[0], c);";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "		d->custom_optopt = c;";
  stream << "\n";
  stream << indent_str;
  stream << "		return '?';";
  stream << "\n";
  stream << indent_str;
  stream << "	}";
  stream << "\n";
  stream << indent_str;
  stream << "	if (temp[1] == ':') {";
  stream << "\n";
  stream << indent_str;
  stream << "		if (temp[2] == ':') {";
  stream << "\n";
  stream << indent_str;
  stream << "			/* This is an option that accepts an argument optionally.  */";
  stream << "\n";
  stream << indent_str;
  stream << "			if (*d->nextchar != '\\0') {";
  stream << "\n";
  stream << indent_str;
  stream << "				d->custom_optarg = d->nextchar;";
  stream << "\n";
  stream << indent_str;
  stream << "				d->custom_optind++;";
  stream << "\n";
  stream << indent_str;
  stream << "			} else";
  stream << "\n";
  stream << indent_str;
  stream << "				d->custom_optarg = NULL;";
  stream << "\n";
  stream << indent_str;
  stream << "			d->nextchar = NULL;";
  stream << "\n";
  stream << indent_str;
  stream << "		} else {";
  stream << "\n";
  stream << indent_str;
  stream << "			/* This is an option that requires an argument.  */";
  stream << "\n";
  stream << indent_str;
  stream << "			if (*d->nextchar != '\\0') {";
  stream << "\n";
  stream << indent_str;
  stream << "				d->custom_optarg = d->nextchar;";
  stream << "\n";
  stream << indent_str;
  stream << "				/*";
  stream << "\n";
  stream << indent_str;
  stream << "				 * If we end this ARGV-element by taking the";
  stream << "\n";
  stream << indent_str;
  stream << "				 * rest as an arg, we must advance to the next";
  stream << "\n";
  stream << indent_str;
  stream << "				 * element now.";
  stream << "\n";
  stream << indent_str;
  stream << "				 */";
  stream << "\n";
  stream << indent_str;
  stream << "				d->custom_optind++;";
  stream << "\n";
  stream << indent_str;
  stream << "			} else if (d->custom_optind == argc) {";
  stream << "\n";
  stream << indent_str;
  stream << "				if (print_errors) {";
  stream << "\n";
  stream << indent_str;
  stream << "					fprintf(stderr,";
  stream << "\n";
  stream << indent_str;
  stream << "						\"%s: option requires an argument -- %c\\n\",";
  stream << "\n";
  stream << indent_str;
  stream << "						argv[0], c);";
  stream << "\n";
  stream << indent_str;
  stream << "				}";
  stream << "\n";
  stream << indent_str;
  stream << "				d->custom_optopt = c;";
  stream << "\n";
  stream << indent_str;
  stream << "				if (optstring[0] == ':')";
  stream << "\n";
  stream << indent_str;
  stream << "					c = ':';";
  stream << "\n";
  stream << indent_str;
  stream << "				else";
  stream << "\n";
  stream << indent_str;
  stream << "					c = '?';";
  stream << "\n";
  stream << indent_str;
  stream << "			} else";
  stream << "\n";
  stream << indent_str;
  stream << "				/*";
  stream << "\n";
  stream << indent_str;
  stream << "				 * We already incremented `custom_optind' once;";
  stream << "\n";
  stream << indent_str;
  stream << "				 * increment it again when taking next ARGV-elt";
  stream << "\n";
  stream << indent_str;
  stream << "				 * as argument.";
  stream << "\n";
  stream << indent_str;
  stream << "				 */";
  stream << "\n";
  stream << indent_str;
  stream << "				d->custom_optarg = argv[d->custom_optind++];";
  stream << "\n";
  stream << indent_str;
  stream << "			d->nextchar = NULL;";
  stream << "\n";
  stream << indent_str;
  stream << "		}";
  stream << "\n";
  stream << indent_str;
  stream << "	}";
  stream << "\n";
  stream << indent_str;
  stream << "	return c;";
  stream << "\n";
  stream << indent_str;
  stream << "}";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "/*";
  stream << "\n";
  stream << indent_str;
  stream << " * Scan elements of ARGV for option characters given in OPTSTRING.";
  stream << "\n";
  stream << indent_str;
  stream << " *";
  stream << "\n";
  stream << indent_str;
  stream << " * If an element of ARGV starts with '-', and is not exactly \"-\" or \"--\",";
  stream << "\n";
  stream << indent_str;
  stream << " * then it is an option element.  The characters of this element";
  stream << "\n";
  stream << indent_str;
  stream << " * (aside from the initial '-') are option characters.  If `getopt'";
  stream << "\n";
  stream << indent_str;
  stream << " * is called repeatedly, it returns successively each of the option characters";
  stream << "\n";
  stream << indent_str;
  stream << " * from each of the option elements.";
  stream << "\n";
  stream << indent_str;
  stream << " *";
  stream << "\n";
  stream << indent_str;
  stream << " * If `getopt' finds another option character, it returns that character,";
  stream << "\n";
  stream << indent_str;
  stream << " * updating `custom_optind' and `nextchar' so that the next call to `getopt' can";
  stream << "\n";
  stream << indent_str;
  stream << " * resume the scan with the following option character or ARGV-element.";
  stream << "\n";
  stream << indent_str;
  stream << " *";
  stream << "\n";
  stream << indent_str;
  stream << " * If there are no more option characters, `getopt' returns -1.";
  stream << "\n";
  stream << indent_str;
  stream << " * Then `custom_optind' is the index in ARGV of the first ARGV-element";
  stream << "\n";
  stream << indent_str;
  stream << " * that is not an option.  (The ARGV-elements have been permuted";
  stream << "\n";
  stream << indent_str;
  stream << " * so that those that are not options now come last.)";
  stream << "\n";
  stream << indent_str;
  stream << " *";
  stream << "\n";
  stream << indent_str;
  stream << " * OPTSTRING is a string containing the legitimate option characters.";
  stream << "\n";
  stream << indent_str;
  stream << " * If an option character is seen that is not listed in OPTSTRING,";
  stream << "\n";
  stream << indent_str;
  stream << " * return '?' after printing an error message.  If you set `custom_opterr' to";
  stream << "\n";
  stream << indent_str;
  stream << " * zero, the error message is suppressed but we still return '?'.";
  stream << "\n";
  stream << indent_str;
  stream << " *";
  stream << "\n";
  stream << indent_str;
  stream << " * If a char in OPTSTRING is followed by a colon, that means it wants an arg,";
  stream << "\n";
  stream << indent_str;
  stream << " * so the following text in the same ARGV-element, or the text of the following";
  stream << "\n";
  stream << indent_str;
  stream << " * ARGV-element, is returned in `custom_optarg'.  Two colons mean an option that";
  stream << "\n";
  stream << indent_str;
  stream << " * wants an optional arg; if there is text in the current ARGV-element,";
  stream << "\n";
  stream << indent_str;
  stream << " * it is returned in `custom_optarg', otherwise `custom_optarg' is set to zero.";
  stream << "\n";
  stream << indent_str;
  stream << " *";
  stream << "\n";
  stream << indent_str;
  stream << " * If OPTSTRING starts with `-' or `+', it requests different methods of";
  stream << "\n";
  stream << indent_str;
  stream << " * handling the non-option ARGV-elements.";
  stream << "\n";
  stream << indent_str;
  stream << " * See the comments about RETURN_IN_ORDER and REQUIRE_ORDER, above.";
  stream << "\n";
  stream << indent_str;
  stream << " *";
  stream << "\n";
  stream << indent_str;
  stream << " * Long-named options begin with `--' instead of `-'.";
  stream << "\n";
  stream << indent_str;
  stream << " * Their names may be abbreviated as long as the abbreviation is unique";
  stream << "\n";
  stream << indent_str;
  stream << " * or is an exact match for some defined option.  If they have an";
  stream << "\n";
  stream << indent_str;
  stream << " * argument, it follows the option name in the same ARGV-element, separated";
  stream << "\n";
  stream << indent_str;
  stream << " * from the option name by a `=', or else the in next ARGV-element.";
  stream << "\n";
  stream << indent_str;
  stream << " * When `getopt' finds a long-named option, it returns 0 if that option's";
  stream << "\n";
  stream << indent_str;
  stream << " * `flag' field is nonzero, the value of the option's `val' field";
  stream << "\n";
  stream << indent_str;
  stream << " * if the `flag' field is zero.";
  stream << "\n";
  stream << indent_str;
  stream << " *";
  stream << "\n";
  stream << indent_str;
  stream << " * The elements of ARGV aren't really const, because we permute them.";
  stream << "\n";
  stream << indent_str;
  stream << " * But we pretend they're const in the prototype to be compatible";
  stream << "\n";
  stream << indent_str;
  stream << " * with other systems.";
  stream << "\n";
  stream << indent_str;
  stream << " *";
  stream << "\n";
  stream << indent_str;
  stream << " * LONGOPTS is a vector of `struct option' terminated by an";
  stream << "\n";
  stream << indent_str;
  stream << " * element containing a name which is zero.";
  stream << "\n";
  stream << indent_str;
  stream << " *";
  stream << "\n";
  stream << indent_str;
  stream << " * LONGIND returns the index in LONGOPT of the long-named option found.";
  stream << "\n";
  stream << indent_str;
  stream << " * It is only valid when a long-named option has been found by the most";
  stream << "\n";
  stream << indent_str;
  stream << " * recent call.";
  stream << "\n";
  stream << indent_str;
  stream << " *";
  stream << "\n";
  stream << indent_str;
  stream << " * Return the option character from OPTS just read.  Return -1 when there are";
  stream << "\n";
  stream << indent_str;
  stream << " * no more options.  For unrecognized options, or options missing arguments,";
  stream << "\n";
  stream << indent_str;
  stream << " * `custom_optopt' is set to the option letter, and '?' is returned.";
  stream << "\n";
  stream << indent_str;
  stream << " *";
  stream << "\n";
  stream << indent_str;
  stream << " * The OPTS string is a list of characters which are recognized option letters,";
  stream << "\n";
  stream << indent_str;
  stream << " * optionally followed by colons, specifying that that letter takes an";
  stream << "\n";
  stream << indent_str;
  stream << " * argument, to be placed in `custom_optarg'.";
  stream << "\n";
  stream << indent_str;
  stream << " *";
  stream << "\n";
  stream << indent_str;
  stream << " * If a letter in OPTS is followed by two colons, its argument is optional.";
  stream << "\n";
  stream << indent_str;
  stream << " * This behavior is specific to the GNU `getopt'.";
  stream << "\n";
  stream << indent_str;
  stream << " *";
  stream << "\n";
  stream << indent_str;
  stream << " * The argument `--' causes premature termination of argument scanning,";
  stream << "\n";
  stream << indent_str;
  stream << " * explicitly telling `getopt' that there are no more options.  If OPTS begins";
  stream << "\n";
  stream << indent_str;
  stream << " * with `--', then non-option arguments are treated as arguments to the option";
  stream << "\n";
  stream << indent_str;
  stream << " * '\\0'.  This behavior is specific to the GNU `getopt'.";
  stream << "\n";
  stream << indent_str;
  stream << " */";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "static int getopt_internal_r(int argc, char *const *argv, const char *optstring,";
  stream << "\n";
  stream << indent_str;
  stream << "		const struct option *longopts, int *longind,";
  stream << "\n";
  stream << indent_str;
  stream << "		struct custom_getopt_data *d)";
  stream << "\n";
  stream << indent_str;
  stream << "{";
  stream << "\n";
  stream << indent_str;
  stream << "	int ret, print_errors = d->custom_opterr;";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "	if (optstring[0] == ':')";
  stream << "\n";
  stream << indent_str;
  stream << "		print_errors = 0;";
  stream << "\n";
  stream << indent_str;
  stream << "	if (argc < 1)";
  stream << "\n";
  stream << indent_str;
  stream << "		return -1;";
  stream << "\n";
  stream << indent_str;
  stream << "	d->custom_optarg = NULL;";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "	/* ";
  stream << "\n";
  stream << indent_str;
  stream << "	 * This is a big difference with GNU getopt, since optind == 0";
  stream << "\n";
  stream << indent_str;
  stream << "	 * means initialization while here 1 means first call.";
  stream << "\n";
  stream << indent_str;
  stream << "	 */";
  stream << "\n";
  stream << indent_str;
  stream << "	if (d->custom_optind == 0 || !d->initialized) {";
  stream << "\n";
  stream << indent_str;
  stream << "		if (d->custom_optind == 0)";
  stream << "\n";
  stream << indent_str;
  stream << "			d->custom_optind = 1;	/* Don't scan ARGV[0], the program name.  */";
  stream << "\n";
  stream << indent_str;
  stream << "		custom_getopt_initialize(d);";
  stream << "\n";
  stream << indent_str;
  stream << "	}";
  stream << "\n";
  stream << indent_str;
  stream << "	if (d->nextchar == NULL || *d->nextchar == '\\0') {";
  stream << "\n";
  stream << indent_str;
  stream << "		ret = shuffle_argv(argc, argv, longopts, d);";
  stream << "\n";
  stream << indent_str;
  stream << "		if (ret)";
  stream << "\n";
  stream << indent_str;
  stream << "			return ret;";
  stream << "\n";
  stream << indent_str;
  stream << "	}";
  stream << "\n";
  stream << indent_str;
  stream << "	if (longopts && (argv[d->custom_optind][1] == '-' ))";
  stream << "\n";
  stream << indent_str;
  stream << "		return check_long_opt(argc, argv, optstring, longopts,";
  stream << "\n";
  stream << indent_str;
  stream << "			longind, print_errors, d);";
  stream << "\n";
  stream << indent_str;
  stream << "	return check_short_opt(argc, argv, optstring, print_errors, d);";
  stream << "\n";
  stream << indent_str;
  stream << "}";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "static int custom_getopt_internal(int argc, char *const *argv, const char *optstring,";
  stream << "\n";
  stream << indent_str;
  stream << "	const struct option *longopts, int *longind)";
  stream << "\n";
  stream << indent_str;
  stream << "{";
  stream << "\n";
  stream << indent_str;
  stream << "	int result;";
  stream << "\n";
  stream << indent_str;
  stream << "	/* Keep a global copy of all internal members of d */";
  stream << "\n";
  stream << indent_str;
  stream << "	static struct custom_getopt_data d;";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "	d.custom_optind = custom_optind;";
  stream << "\n";
  stream << indent_str;
  stream << "	d.custom_opterr = custom_opterr;";
  stream << "\n";
  stream << indent_str;
  stream << "	result = getopt_internal_r(argc, argv, optstring, longopts,";
  stream << "\n";
  stream << indent_str;
  stream << "		longind, &d);";
  stream << "\n";
  stream << indent_str;
  stream << "	custom_optind = d.custom_optind;";
  stream << "\n";
  stream << indent_str;
  stream << "	custom_optarg = d.custom_optarg;";
  stream << "\n";
  stream << indent_str;
  stream << "	custom_optopt = d.custom_optopt;";
  stream << "\n";
  stream << indent_str;
  stream << "	return result;";
  stream << "\n";
  stream << indent_str;
  stream << "}";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "static int custom_getopt_long (int argc, char *const *argv, const char *options,";
  stream << "\n";
  stream << indent_str;
  stream << "	const struct option *long_options, int *opt_index)";
  stream << "\n";
  stream << indent_str;
  stream << "{";
  stream << "\n";
  stream << indent_str;
  stream << "	return custom_getopt_internal(argc, argv, options, long_options,";
  stream << "\n";
  stream << indent_str;
  stream << "		opt_index);";
  stream << "\n";
  stream << indent_str;
  stream << "}";
  stream << "\n";
  stream << indent_str;
}
