/*
 * Copyright (C) 2003-2015 FreeIPMI Core Team
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef IPMI_SENSOR_AND_EVENT_CODE_TABLES_SPEC_H
#define IPMI_SENSOR_AND_EVENT_CODE_TABLES_SPEC_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>

/************************************************
 * Generic Event Reading Type Code Offsets      *
 ************************************************/

#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_THRESHOLD_LOWER_NON_CRITICAL_GOING_LOW     0x00
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_THRESHOLD_LOWER_NON_CRITICAL_GOING_HIGH    0x01
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_THRESHOLD_LOWER_CRITICAL_GOING_LOW         0x02
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_THRESHOLD_LOWER_CRITICAL_GOING_HIGH        0x03
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_THRESHOLD_LOWER_NON_RECOVERABLE_GOING_LOW  0x04
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_THRESHOLD_LOWER_NON_RECOVERABLE_GOING_HIGH 0x05
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_THRESHOLD_UPPER_NON_CRITICAL_GOING_LOW     0x06
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_THRESHOLD_UPPER_NON_CRITICAL_GOING_HIGH    0x07
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_THRESHOLD_UPPER_CRITICAL_GOING_LOW         0x08
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_THRESHOLD_UPPER_CRITICAL_GOING_HIGH        0x09
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_THRESHOLD_UPPER_NON_RECOVERABLE_GOING_LOW  0x0A
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_THRESHOLD_UPPER_NON_RECOVERABLE_GOING_HIGH 0x0B

#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_TRANSITION_STATE_TRANSITION_TO_IDLE   0x00
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_TRANSITION_STATE_TRANSITION_TO_ACTIVE 0x01
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_TRANSITION_STATE_TRANSITION_TO_BUSY   0x02

#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_STATE_DEASSERTED 0x00
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_STATE_ASSERTED   0x01

#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_PREDICTIVE_FAILURE_DEASSERTED 0x00
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_PREDICTIVE_FAILURE_ASSERTED   0x01

#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_LIMIT_NOT_EXCEEDED 0x00
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_LIMIT_EXCEEDED     0x01

#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_PERFORMANCE_MET  0x00
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_PERFORMANCE_LAGS 0x01

#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_TRANSITION_SEVERITY_TRANSITION_TO_OK                               0x00
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_TRANSITION_SEVERITY_TRANSITION_TO_NON_CRITICAL_FROM_OK             0x01
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_TRANSITION_SEVERITY_TRANSITION_TO_CRITICAL_FROM_LESS_SEVERE        0x02
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_TRANSITION_SEVERITY_TRANSITION_TO_NON_RECOVERABLE_FROM_LESS_SEVERE 0x03
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_TRANSITION_SEVERITY_TRANSITION_TO_NON_CRITICAL_FROM_MORE_SEVERE    0x04
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_TRANSITION_SEVERITY_TRANSITION_TO_CRITICAL_FROM_NON_RECOVERABLE    0x05
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_TRANSITION_SEVERITY_TRANSITION_TO_NON_RECOVERABLE                  0x06
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_TRANSITION_SEVERITY_MONITOR                                        0x07
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_TRANSITION_SEVERITY_INFORMATIONAL                                  0x08

#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_DEVICE_PRESENT_DEVICE_PRESENT 0x00
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_DEVICE_PRESENT_DEVICE_ABSENT  0x01

#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_DEVICE_ENABLED_DEVICE_DISABLED 0x00
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_DEVICE_ENABLED_DEVICE_ENABLED  0x01

#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_TRANSITION_AVAILABILITY_TRANSITION_TO_RUNNING    0x00
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_TRANSITION_AVAILABILITY_TRANSITION_TO_IN_TEST    0x01
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_TRANSITION_AVAILABILITY_TRANSITION_TO_POWER_OFF  0x02
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_TRANSITION_AVAILABILITY_TRANSITION_TO_ON_LINE    0x03
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_TRANSITION_AVAILABILITY_TRANSITION_TO_OFF_LINE   0x04
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_TRANSITION_AVAILABILITY_TRANSITION_TO_OFF_DUTY   0x05
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_TRANSITION_AVAILABILITY_TRANSITION_TO_DEGRADED   0x06
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_TRANSITION_AVAILABILITY_TRANSITION_TO_POWER_SAVE 0x07
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_TRANSITION_AVAILABILITY_INSTALL_ERROR            0x08

#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_REDUNDANCY_FULLY_REDUNDANT                                                0x00
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_REDUNDANCY_REDUNDANCY_LOST                                                0x01
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_REDUNDANCY_REDUNDANCY_DEGRADED                                            0x02
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_REDUNDANCY_NON_REDUNDANT_SUFFICIENT_RESOURCES_FROM_REDUNDANT              0x03
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_REDUNDANCY_NON_REDUNDANT_SUFFICIENT_RESOURCES_FROM_INSUFFICIENT_RESOURCES 0x04
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_REDUNDANCY_NON_REDUNDANT_INSUFFICIENT_RESOURCES                           0x05
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_REDUNDANCY_REDUNDANCY_DEGRADED_FROM_FULLY_REDUNDANT                       0x06
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_REDUNDANCY_REDUNDANCY_DEGRADED_FROM_NON_REDUNDANT                         0x07

#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_ACPI_POWER_STATE_D0_POWER_STATE 0x00
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_ACPI_POWER_STATE_D1_POWER_STATE 0x01
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_ACPI_POWER_STATE_D2_POWER_STATE 0x02
#define IPMI_GENERIC_EVENT_READING_TYPE_CODE_ACPI_POWER_STATE_D3_POWER_STATE 0x03
  
/*
 * String arrays for above
 */

extern const char * const ipmi_generic_event_reading_type_code_threshold[];
extern unsigned int ipmi_generic_event_reading_type_code_threshold_max_index;

extern const char * const ipmi_generic_event_reading_type_code_transition_state[];
extern unsigned int ipmi_generic_event_reading_type_code_transition_state_max_index;

extern const char * const ipmi_generic_event_reading_type_code_state[];
extern unsigned int ipmi_generic_event_reading_type_code_state_max_index;

extern const char * const ipmi_generic_event_reading_type_code_predictive_failure[];
extern unsigned int ipmi_generic_event_reading_type_code_predictive_failure_max_index;

extern const char * const ipmi_generic_event_reading_type_code_limit[];
extern unsigned int ipmi_generic_event_reading_type_code_limit_max_index;

extern const char * const ipmi_generic_event_reading_type_code_performance[];
extern unsigned int ipmi_generic_event_reading_type_code_performance_max_index;

extern const char * const ipmi_generic_event_reading_type_code_transition_severity[];
extern unsigned int ipmi_generic_event_reading_type_code_transition_severity_max_index;

extern const char * const ipmi_generic_event_reading_type_code_device_present[];
extern unsigned int ipmi_generic_event_reading_type_code_device_present_max_index;

extern const char * const ipmi_generic_event_reading_type_code_device_enabled[];
extern unsigned int ipmi_generic_event_reading_type_code_device_enabled_max_index;

extern const char * const ipmi_generic_event_reading_type_code_transition_availability[];
extern unsigned int ipmi_generic_event_reading_type_code_transition_availability_max_index;

extern const char * const ipmi_generic_event_reading_type_code_redundancy[];
extern unsigned int ipmi_generic_event_reading_type_code_redundancy_max_index;

extern const char * const ipmi_generic_event_reading_type_code_acpi_power_state[];
extern unsigned int ipmi_generic_event_reading_type_code_acpi_power_state_max_index;

/*
 * "short" arrays are same strings, but shortened to more reasonble lengths for output
 */
extern const char * const ipmi_generic_event_reading_type_code_threshold_short[];
extern unsigned int ipmi_generic_event_reading_type_code_threshold_short_max_index;

extern const char * const ipmi_generic_event_reading_type_code_transition_state_short[];
extern unsigned int ipmi_generic_event_reading_type_code_transition_state_short_max_index;

extern const char * const ipmi_generic_event_reading_type_code_state_short[];
extern unsigned int ipmi_generic_event_reading_type_code_state_short_max_index;

extern const char * const ipmi_generic_event_reading_type_code_predictive_failure_short[];
extern unsigned int ipmi_generic_event_reading_type_code_predictive_failure_short_max_index;

extern const char * const ipmi_generic_event_reading_type_code_limit_short[];
extern unsigned int ipmi_generic_event_reading_type_code_limit_short_max_index;

extern const char * const ipmi_generic_event_reading_type_code_performance_short[];
extern unsigned int ipmi_generic_event_reading_type_code_performance_short_max_index;

extern const char * const ipmi_generic_event_reading_type_code_transition_severity_short[];
extern unsigned int ipmi_generic_event_reading_type_code_transition_severity_short_max_index;

extern const char * const ipmi_generic_event_reading_type_code_device_present_short[];
extern unsigned int ipmi_generic_event_reading_type_code_device_present_short_max_index;

extern const char * const ipmi_generic_event_reading_type_code_device_enabled_short[];
extern unsigned int ipmi_generic_event_reading_type_code_device_enabled_short_max_index;

extern const char * const ipmi_generic_event_reading_type_code_transition_availability_short[];
extern unsigned int ipmi_generic_event_reading_type_code_transition_availability_short_max_index;

extern const char * const ipmi_generic_event_reading_type_code_redundancy_short[];
extern unsigned int ipmi_generic_event_reading_type_code_redundancy_short_max_index;

extern const char * const ipmi_generic_event_reading_type_code_acpi_power_state_short[];
extern unsigned int ipmi_generic_event_reading_type_code_acpi_power_state_short_max_index;

/************************************************
 * Sensor Type Code Offsets                     *
 ************************************************/

#define IPMI_SENSOR_TYPE_PHYSICAL_SECURITY_GENERAL_CHASSIS_INTRUSION 0x00
#define IPMI_SENSOR_TYPE_PHYSICAL_SECURITY_DRIVE_BAY_INTRUSION       0x01
#define IPMI_SENSOR_TYPE_PHYSICAL_SECURITY_IO_CARD_AREA_INTRUSION    0x02
#define IPMI_SENSOR_TYPE_PHYSICAL_SECURITY_PROCESSOR_AREA_INTRUSION  0x03
#define IPMI_SENSOR_TYPE_PHYSICAL_SECURITY_LAN_LEASH_LOST            0x04
#define IPMI_SENSOR_TYPE_PHYSICAL_SECURITY_UNAUTHORIZED_DOCK         0x05
#define IPMI_SENSOR_TYPE_PHYSICAL_SECURITY_FAN_AREA_INTRUSION        0x06

#define IPMI_SENSOR_TYPE_PLATFORM_SECURITY_VIOLATION_ATTEMPT_SECURE_MODE_VIOLATION_ATTEMPT                      0x00
#define IPMI_SENSOR_TYPE_PLATFORM_SECURITY_VIOLATION_ATTEMPT_PRE_BOOT_PASSWORD_VIOLATION_USER_PASSWORD          0x01
#define IPMI_SENSOR_TYPE_PLATFORM_SECURITY_VIOLATION_ATTEMPT_PRE_BOOT_PASSWORD_VIOLATION_ATTEMPT_SETUP_PASSWORD 0x02
#define IPMI_SENSOR_TYPE_PLATFORM_SECURITY_VIOLATION_ATTEMPT_PRE_BOOT_PASSWORD_VIOLATION_NETWORK_BOOT_PASSWORD  0x03
#define IPMI_SENSOR_TYPE_PLATFORM_SECURITY_VIOLATION_ATTEMPT_OTHER_PRE_BOOT_PASSWORD_VIOLATION                  0x04
#define IPMI_SENSOR_TYPE_PLATFORM_SECURITY_VIOLATION_ATTEMPT_OUT_OF_BAND_ACCESS_PASSWORD_VIOLATION              0x05
  
#define IPMI_SENSOR_TYPE_PROCESSOR_IERR                                          0x00
#define IPMI_SENSOR_TYPE_PROCESSOR_THERMAL_TRIP                                  0x01
#define IPMI_SENSOR_TYPE_PROCESSOR_FRB1_BIST_FAILURE                             0x02
#define IPMI_SENSOR_TYPE_PROCESSOR_FRB2_HANG_IN_POST_FAILURE                     0x03
#define IPMI_SENSOR_TYPE_PROCESSOR_FRB3_PROCESSOR_STARTUP_INITIALIZATION_FAILURE 0x04
#define IPMI_SENSOR_TYPE_PROCESSOR_CONFIGURATION_ERROR                           0x05
#define IPMI_SENSOR_TYPE_PROCESSOR_SMBIOS_UNCORRECTABLE_CPU_COMPLEX_ERROR        0x06
#define IPMI_SENSOR_TYPE_PROCESSOR_PROCESSOR_PRESENCE_DETECTED                   0x07
#define IPMI_SENSOR_TYPE_PROCESSOR_PROCESSOR_DISABLED                            0x08
#define IPMI_SENSOR_TYPE_PROCESSOR_TERMINATOR_PRESENCE_DETECTED                  0x09
#define IPMI_SENSOR_TYPE_PROCESSOR_PROCESSOR_AUTOMATICALLY_THROTTLED             0x0A
#define IPMI_SENSOR_TYPE_PROCESSOR_MACHINE_CHECK_EXCEPTION                       0x0B
#define IPMI_SENSOR_TYPE_PROCESSOR_CORRECTABLE_MACHINE_CHECK_ERROR               0x0C

#define IPMI_SENSOR_TYPE_POWER_SUPPLY_PRESENCE_DETECTED                           0x00
#define IPMI_SENSOR_TYPE_POWER_SUPPLY_POWER_SUPPLY_FAILURE_DETECTED               0x01
#define IPMI_SENSOR_TYPE_POWER_SUPPLY_PREDICTIVE_FAILURE                          0x02
#define IPMI_SENSOR_TYPE_POWER_SUPPLY_POWER_SUPPLY_INPUT_LOST_AC_DC               0x03
#define IPMI_SENSOR_TYPE_POWER_SUPPLY_POWER_SUPPLY_INPUT_LOST_OR_OUT_OF_RANGE     0x04
#define IPMI_SENSOR_TYPE_POWER_SUPPLY_POWER_SUPPLY_INPUT_OUT_OF_RANGE_BUT_PRESENT 0x05
#define IPMI_SENSOR_TYPE_POWER_SUPPLY_CONFIGURATION_ERROR                         0x06
#define IPMI_SENSOR_TYPE_POWER_SUPPLY_POWER_SUPPLY_INACTIVE                       0x07

#define IPMI_SENSOR_TYPE_POWER_SUPPLY_EVENT_DATA3_OFFSET_CONFIGURATION_ERROR_ERROR_TYPE_VENDOR_MISMATCH              0x00
#define IPMI_SENSOR_TYPE_POWER_SUPPLY_EVENT_DATA3_OFFSET_CONFIGURATION_ERROR_ERROR_TYPE_REVISION_MISMATCH            0x01
#define IPMI_SENSOR_TYPE_POWER_SUPPLY_EVENT_DATA3_OFFSET_CONFIGURATION_ERROR_ERROR_TYPE_PROCESSOR_MISSING            0x02
#define IPMI_SENSOR_TYPE_POWER_SUPPLY_EVENT_DATA3_OFFSET_CONFIGURATION_ERROR_ERROR_TYPE_POWER_SUPPLY_RATING_MISMATCH 0x03
#define IPMI_SENSOR_TYPE_POWER_SUPPLY_EVENT_DATA3_OFFSET_CONFIGURATION_ERROR_ERROR_TYPE_VOLTAGE_RATING_MISMATCH      0x04

#define IPMI_SENSOR_TYPE_POWER_UNIT_POWER_OFF_POWER_DOWN        0x00
#define IPMI_SENSOR_TYPE_POWER_UNIT_POWER_CYCLE                 0x01
#define IPMI_SENSOR_TYPE_POWER_UNIT_240VA_POWER_DOWN            0x02
#define IPMI_SENSOR_TYPE_POWER_UNIT_INTERLOCK_POWER_DOWN        0x03
#define IPMI_SENSOR_TYPE_POWER_UNIT_AC_LOST                     0x04
#define IPMI_SENSOR_TYPE_POWER_UNIT_SOFT_POWER_CONTROL_FAILURE  0x05
#define IPMI_SENSOR_TYPE_POWER_UNIT_POWER_UNIT_FAILURE_DETECTED 0x06
#define IPMI_SENSOR_TYPE_POWER_UNIT_PREDICTIVE_FAILURE          0x07

#define IPMI_SENSOR_TYPE_MEMORY_CORRECTABLE_MEMORY_ERROR                       0x00
#define IPMI_SENSOR_TYPE_MEMORY_UNCORRECTABLE_MEMORY_ERROR                     0x01
#define IPMI_SENSOR_TYPE_MEMORY_PARITY                                         0x02
#define IPMI_SENSOR_TYPE_MEMORY_MEMORY_SCRUB_FAILED                            0x03
#define IPMI_SENSOR_TYPE_MEMORY_MEMORY_DEVICE_DISABLED                         0x04
#define IPMI_SENSOR_TYPE_MEMORY_CORRECTABLE_MEMORY_ERROR_LOGGING_LIMIT_REACHED 0x05
#define IPMI_SENSOR_TYPE_MEMORY_PRESENCE_DETECTED                              0x06
#define IPMI_SENSOR_TYPE_MEMORY_CONFIGURATION_ERROR                            0x07
#define IPMI_SENSOR_TYPE_MEMORY_SPARE                                          0x08
#define IPMI_SENSOR_TYPE_MEMORY_MEMORY_AUTOMATICALLY_THROTTLED                 0x09
#define IPMI_SENSOR_TYPE_MEMORY_CRITICAL_OVERTEMPERATURE                       0x0A

#define IPMI_SENSOR_TYPE_DRIVE_SLOT_DRIVE_PRESENCE                             0x00
#define IPMI_SENSOR_TYPE_DRIVE_SLOT_DRIVE_FAULT                                0x01
#define IPMI_SENSOR_TYPE_DRIVE_SLOT_PREDICTIVE_FAILURE                         0x02
#define IPMI_SENSOR_TYPE_DRIVE_SLOT_HOT_SPARE                                  0x03
#define IPMI_SENSOR_TYPE_DRIVE_SLOT_CONSISTENCY_CHECK_PARITY_CHECK_IN_PROGRESS 0x04
#define IPMI_SENSOR_TYPE_DRIVE_SLOT_IN_CRITICAL_ARRAY                          0x05
#define IPMI_SENSOR_TYPE_DRIVE_SLOT_IN_FAILED_ARRAY                            0x06
#define IPMI_SENSOR_TYPE_DRIVE_SLOT_REBUILD_REMAP_IN_PROGRESS                  0x07
#define IPMI_SENSOR_TYPE_DRIVE_SLOT_REBUILD_REMAP_ABORTED                      0x08

#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_SYSTEM_FIRMWARE_ERROR    0x00
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_SYSTEM_FIRMWARE_HANG     0x01
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_SYSTEM_FIRMWARE_PROGRESS 0x02

#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_ERROR_UNSPECIFIED                                     0x00
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_ERROR_NO_SYSTEM_MEMORY                                0x01
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_ERROR_NO_USABLE_SYSTEM_MEMORY                         0x02
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_ERROR_UNRECOVERABLE_HARD_DISK_ATPI_IDE_DEVICE_FAILURE 0x03
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_ERROR_UNRECOVERABLE_SYSTEM_BOARD_FAILURE              0x04
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_ERROR_UNRECOVERABLE_DISKETTE_SUBSYSTEM_FAILURE        0x05
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_ERROR_UNRECOVERABLE_HARD_DISK_CONTROLLER_FAILURE      0x06
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_ERROR_UNRECOVERABLE_PS2_OR_USB_KEYBOARD_FAILURE       0x07
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_ERROR_REMOVABLE_BOOT_MEDIA_NOT_FOUND                  0x08
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_ERROR_UNRECOVERABLE_VIDEO_CONTROLLER_FAILURE          0x09
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_ERROR_NO_VIDEO_DEVICE_DETECTED                        0x0A
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_ERROR_FIRMWARE_ROM_CORRUPTION_DETECTED                0x0B
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_ERROR_CPU_VOLTAGE_MISMATCH                            0x0C
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_ERROR_CPU_SPEED_MATCHING_FAILURE                      0x0D

#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_HANG_UNSPECIFIED                                              0x00
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_HANG_MEMORY_INITIALIZATION                                    0x01
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_HANG_HARD_DISK_INITIALIZATION                                 0x02
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_HANG_SECONDARY_PROCESSORS_INITIALIZATION                      0x03
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_HANG_USER_AUTHENTICATION                                      0x04
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_HANG_USER_INITIATED_SYSTEM_SETUP                              0x05
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_HANG_USB_RESOURCE_CONFIGURATION                               0x06
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_HANG_PCI_RESOURCE_CONFIGURATION                               0x07
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_HANG_OPTION_ROM_INITIALIZATION                                0x08
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_HANG_VIDEO_INITIALIZATION                                     0x09
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_HANG_CACHE_INITIALIZATION                                     0x0A
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_HANG_SM_BUS_INITIALIZATION                                    0x0B
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_HANG_KEYBOARD_CONTROLLER_INITIALIZATION                       0x0C
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_HANG_EMBEDDED_CONTROLLER_MANAGEMENT_CONTROLLER_INITIALIZATION 0x0D
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_HANG_DOCKING_STATION_ATTACHMENT                               0x0E
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_HANG_ENABLING_DOCKING_STATION                                 0x0F
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_HANG_DOCKING_STATION_EJECTION                                 0x10
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_HANG_DISABLING_DOCKING_STATION                                0x11
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_HANG_CALLING_OPERATING_SYSTEM_WAKE_UP_VECTOR                  0x12
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_HANG_STARTING_OPERATING_SYSTEM_BOOT_PROCESS                   0x13
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_HANG_BASEBOARD_OR_MOTHERBOARD_INITIALIZATION                  0x14
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_HANG_RESERVED                                                 0x15
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_HANG_FLOPPY_INITIALIZATION                                    0x16
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_HANG_KEYBOARD_TEST                                            0x17
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_HANG_POINTING_DEVICE_TEST                                     0x18
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_HANG_PRIMARY_PROCESSOR_INITIALIZATION                         0x19

#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_PROGRESS_UNSPECIFIED                                              0x00
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_PROGRESS_MEMORY_INITIALIZATION                                    0x01
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_PROGRESS_HARD_DISK_INITIALIZATION                                 0x02
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_PROGRESS_SECONDARY_PROCESSORS_INITIALIZATION                      0x03
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_PROGRESS_USER_AUTHENTICATION                                      0x04
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_PROGRESS_USER_INITIATED_SYSTEM_SETUP                              0x05
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_PROGRESS_USB_RESOURCE_CONFIGURATION                               0x06
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_PROGRESS_PCI_RESOURCE_CONFIGURATION                               0x07
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_PROGRESS_OPTION_ROM_INITIALIZATION                                0x08
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_PROGRESS_VIDEO_INITIALIZATION                                     0x09
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_PROGRESS_CACHE_INITIALIZATION                                     0x0A
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_PROGRESS_SM_BUS_INITIALIZATION                                    0x0B
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_PROGRESS_KEYBOARD_CONTROLLER_INITIALIZATION                       0x0C
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_PROGRESS_EMBEDDED_CONTROLLER_MANAGEMENT_CONTROLLER_INITIALIZATION 0x0D
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_PROGRESS_DOCKING_STATION_ATTACHMENT                               0x0E
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_PROGRESS_ENABLING_DOCKING_STATION                                 0x0F
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_PROGRESS_DOCKING_STATION_EJECTION                                 0x10
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_PROGRESS_DISABLING_DOCKING_STATION                                0x11
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_PROGRESS_CALLING_OPERATING_SYSTEM_WAKE_UP_VECTOR                  0x12
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_PROGRESS_STARTING_OPERATING_SYSTEM_BOOT_PROCESS                   0x13
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_PROGRESS_BASEBOARD_OR_MOTHERBOARD_INITIALIZATION                  0x14
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_PROGRESS_RESERVED                                                 0x15
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_PROGRESS_FLOPPY_INITIALIZATION                                    0x16
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_PROGRESS_KEYBOARD_TEST                                            0x17
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_PROGRESS_POINTING_DEVICE_TEST                                     0x18
#define IPMI_SENSOR_TYPE_SYSTEM_FIRMWARE_PROGRESS_EVENT_DATA2_OFFSET_SYSTEM_FIRMWARE_PROGRESS_PRIMARY_PROCESSOR_INITIALIZATION                         0x19

#define IPMI_SENSOR_TYPE_EVENT_LOGGING_DISABLED_CORRECTABLE_MEMORY_ERROR_LOGGING_DISABLED        0x00
#define IPMI_SENSOR_TYPE_EVENT_LOGGING_DISABLED_EVENT_TYPE_LOGGING_DISABLED                      0x01
#define IPMI_SENSOR_TYPE_EVENT_LOGGING_DISABLED_LOG_AREA_RESET_CLEARED                           0x02
#define IPMI_SENSOR_TYPE_EVENT_LOGGING_DISABLED_ALL_EVENT_LOGGING_DISABLED                       0x03
#define IPMI_SENSOR_TYPE_EVENT_LOGGING_DISABLED_SEL_FULL                                         0x04
#define IPMI_SENSOR_TYPE_EVENT_LOGGING_DISABLED_SEL_ALMOST_FULL                                  0x05
#define IPMI_SENSOR_TYPE_EVENT_LOGGING_DISABLED_CORRECTABLE_MACHINE_CHECK_ERROR_LOGGING_DISABLED 0x06

#define IPMI_SENSOR_TYPE_EVENT_LOGGING_DISABLED_EVENT_DATA3_OFFSET_EVENT_TYPE_LOGGING_DISABLED_DEASSERTION_EVENT 0x0
#define IPMI_SENSOR_TYPE_EVENT_LOGGING_DISABLED_EVENT_DATA3_OFFSET_EVENT_TYPE_LOGGING_DISABLED_ASSERTION_EVENT   0x1

#define IPMI_SENSOR_TYPE_EVENT_LOGGING_DISABLED_EVENT_DATA3_OFFSET_EVENT_TYPE_LOGGING_DISABLED_LOGGING_HAS_BEEN_DISABLED_FOR_ALL_EVENTS_OF_A_GIVEN_TYPE 0x1

#define IPMI_SENSOR_TYPE_EVENT_LOGGING_DISABLED_EVENT_DATA3_OFFSET_CORRECTABLE_MACHINE_CHECK_ERROR_LOGGING_DISABLED_ENTITY_INSTANCE_NUMBER           0x0
#define IPMI_SENSOR_TYPE_EVENT_LOGGING_DISABLED_EVENT_DATA3_OFFSET_CORRECTABLE_MACHINE_CHECK_ERROR_LOGGING_DISABLED_VENDOR_SPECIFIC_PROCESSOR_NUMBER 0x1

#define IPMI_SENSOR_TYPE_WATCHDOG1_BIOS_WATCHDOG_RESET                       0x00
#define IPMI_SENSOR_TYPE_WATCHDOG1_OS_WATCHDOG_RESET                         0x01
#define IPMI_SENSOR_TYPE_WATCHDOG1_OS_WATCHDOG_SHUT_DOWN                     0x02
#define IPMI_SENSOR_TYPE_WATCHDOG1_OS_WATCHDOG_POWER_DOWN                    0x03
#define IPMI_SENSOR_TYPE_WATCHDOG1_OS_WATCHDOG_POWER_CYCLE                   0x04
#define IPMI_SENSOR_TYPE_WATCHDOG1_OS_WATCHDOG_NMI_DIAGNOSTIC_INTERRUPT      0x05
#define IPMI_SENSOR_TYPE_WATCHDOG1_OS_WATCHDOG_EXPIRED_STATUS_ONLY           0x06
#define IPMI_SENSOR_TYPE_WATCHDOG1_OS_WATCHDOG_PRE_TIMEOUT_INTERRUPT_NON_NMI 0x07

#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_SYSTEM_RECONFIGURED                  0x00
#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_OEM_SYSTEM_BOOT_EVENT                0x01
#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_UNDETERMINED_SYSTEM_HARDWARE_FAILURE 0x02
#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_ENTRY_ADDED_TO_AUXILIARY_LOG         0x03
#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_PEF_ACTION                           0x04
#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_TIMESTAMP_CLOCK_SYNCH                0x05

#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OFFSET_ENTRY_ADDED_TO_AUXILIARY_LOG_LOG_ENTRY_ACTION_ENTRY_ADDED                                                     0x0
#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OFFSET_ENTRY_ADDED_TO_AUXILIARY_LOG_LOG_ENTRY_ACTION_ENTRY_ADDED_BECAUSE_EVENT_DID_NOT_BE_MAP_TO_STANDARD_IPMI_EVENT 0x1
#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OFFSET_ENTRY_ADDED_TO_AUXILIARY_LOG_LOG_ENTRY_ACTION_ENTRY_ADDED_ALONG_WITH_ONE_OR_MORE_CORRESPONDING_SEL_ENTRIES    0x2
#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OFFSET_ENTRY_ADDED_TO_AUXILIARY_LOG_LOG_ENTRY_ACTION_LOG_CLEARED                                                     0x3
#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OFFSET_ENTRY_ADDED_TO_AUXILIARY_LOG_LOG_ENTRY_ACTION_LOG_DISABLED                                                    0x4
#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OFFSET_ENTRY_ADDED_TO_AUXILIARY_LOG_LOG_ENTRY_ACTION_LOG_ENABLED                                                     0x5

#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OFFSET_ENTRY_ADDED_TO_AUXILIARY_LOG_LOG_TYPE_MCA  0x0
#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OFFSET_ENTRY_ADDED_TO_AUXILIARY_LOG_LOG_TYPE_OEM1 0x1
#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OFFSET_ENTRY_ADDED_TO_AUXILIARY_LOG_LOG_TYPE_OEM2 0x2

#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OFFSET_PEF_ACTION_BITMASK_ALERT                0x01
#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OFFSET_PEF_ACTION_BITMASK_POWER_OFF            0x02
#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OFFSET_PEF_ACTION_BITMASK_RESET                0x04
#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OFFSET_PEF_ACTION_BITMASK_POWER_CYCLE          0x08
#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OFFSET_PEF_ACTION_BITMASK_OEM_ACTION           0x10
#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OFFSET_PEF_ACTION_BITMASK_DIAGNOSTIC_INTERRUPT 0x20

#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OFFSET_TIMESTAMP_CLOCK_SYNCH_EVENT_IS_FIRST_OF_PAIR  0x0
#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OFFSET_TIMESTAMP_CLOCK_SYNCH_EVENT_IS_SECOND_OF_PAIR 0x1

#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OFFSET_TIMESTAMP_CLOCK_SYNCH_SEL_TIMESTAMP_CLOCK_UPDATED 0x0
#define IPMI_SENSOR_TYPE_SYSTEM_EVENT_EVENT_DATA2_OFFSET_TIMESTAMP_CLOCK_SYNCH_SDR_TIMESTAMP_CLOCK_UPDATED 0x1

#define IPMI_SENSOR_TYPE_CRITICAL_INTERRUPT_FRONT_PANEL_NMI_DIAGNOSTIC_INTERRUPT 0x00
#define IPMI_SENSOR_TYPE_CRITICAL_INTERRUPT_BUS_TIMEOUT                          0x01
#define IPMI_SENSOR_TYPE_CRITICAL_INTERRUPT_IO_CHANNEL_CHECK_NMI                 0x02
#define IPMI_SENSOR_TYPE_CRITICAL_INTERRUPT_SOFTWARE_NMI                         0x03
#define IPMI_SENSOR_TYPE_CRITICAL_INTERRUPT_PCI_PERR                             0x04
#define IPMI_SENSOR_TYPE_CRITICAL_INTERRUPT_PCI_SERR                             0x05
#define IPMI_SENSOR_TYPE_CRITICAL_INTERRUPT_EISA_FAIL_SAFE_TIMEOUT               0x06
#define IPMI_SENSOR_TYPE_CRITICAL_INTERRUPT_BUS_CORRECTABLE_ERROR                0x07
#define IPMI_SENSOR_TYPE_CRITICAL_INTERRUPT_BUS_UNCORRECTABLE_ERROR              0x08
#define IPMI_SENSOR_TYPE_CRITICAL_INTERRUPT_FATAL_NMI                            0x09
#define IPMI_SENSOR_TYPE_CRITICAL_INTERRUPT_BUS_FATAL_ERROR                      0x0A
#define IPMI_SENSOR_TYPE_CRITICAL_INTERRUPT_BUS_DEGRADED                         0x0B

#define IPMI_SENSOR_TYPE_BUTTON_SWITCH_POWER_BUTTON_PRESSED       0x00
#define IPMI_SENSOR_TYPE_BUTTON_SWITCH_SLEEP_BUTTON_PRESSED       0x01
#define IPMI_SENSOR_TYPE_BUTTON_SWITCH_RESET_BUTTON_PRESSED       0x02
#define IPMI_SENSOR_TYPE_BUTTON_SWITCH_FRU_LATCH_OPEN             0x03
#define IPMI_SENSOR_TYPE_BUTTON_SWITCH_FRU_SERVICE_REQUEST_BUTTON 0x04

#define IPMI_SENSOR_TYPE_CHIP_SET_SOFT_POWER_CONTROL_FAILURE 0x00
#define IPMI_SENSOR_TYPE_CHIP_SET_THERMAL_TRIP               0x01

#define IPMI_SENSOR_TYPE_CHIP_EVENT_DATA2_S0_G0                  0x00
#define IPMI_SENSOR_TYPE_CHIP_EVENT_DATA2_S1                     0x01
#define IPMI_SENSOR_TYPE_CHIP_EVENT_DATA2_S2                     0x02
#define IPMI_SENSOR_TYPE_CHIP_EVENT_DATA2_S3                     0x03
#define IPMI_SENSOR_TYPE_CHIP_EVENT_DATA2_S4                     0x04
#define IPMI_SENSOR_TYPE_CHIP_EVENT_DATA2_S5_G2                  0x05
#define IPMI_SENSOR_TYPE_CHIP_EVENT_DATA2_S4_S5_SOFT_OFF         0x06
#define IPMI_SENSOR_TYPE_CHIP_EVENT_DATA2_G3                     0x07
#define IPMI_SENSOR_TYPE_CHIP_EVENT_DATA2_SLEEPING_S1_S2_S3      0x08
#define IPMI_SENSOR_TYPE_CHIP_EVENT_DATA2_G1_SLEEPING            0x09
#define IPMI_SENSOR_TYPE_CHIP_EVENT_DATA2_S5_ENTERED_BY_OVERRIDE 0x0A
#define IPMI_SENSOR_TYPE_CHIP_EVENT_DATA2_LEGACY_ON_STATE        0x0B
#define IPMI_SENSOR_TYPE_CHIP_EVENT_DATA2_LEGACY_OFF_STATE       0x0C

#define IPMI_SENSOR_TYPE_CHIP_EVENT_DATA3_S0_G0                  0x00
#define IPMI_SENSOR_TYPE_CHIP_EVENT_DATA3_S1                     0x01
#define IPMI_SENSOR_TYPE_CHIP_EVENT_DATA3_S2                     0x02
#define IPMI_SENSOR_TYPE_CHIP_EVENT_DATA3_S3                     0x03
#define IPMI_SENSOR_TYPE_CHIP_EVENT_DATA3_S4                     0x04
#define IPMI_SENSOR_TYPE_CHIP_EVENT_DATA3_S5_G2                  0x05
#define IPMI_SENSOR_TYPE_CHIP_EVENT_DATA3_S4_S5_SOFT_OFF         0x06
#define IPMI_SENSOR_TYPE_CHIP_EVENT_DATA3_G3                     0x07
#define IPMI_SENSOR_TYPE_CHIP_EVENT_DATA3_SLEEPING_S1_S2_S3      0x08
#define IPMI_SENSOR_TYPE_CHIP_EVENT_DATA3_G1_SLEEPING            0x09
#define IPMI_SENSOR_TYPE_CHIP_EVENT_DATA3_S5_ENTERED_BY_OVERRIDE 0x0A
#define IPMI_SENSOR_TYPE_CHIP_EVENT_DATA3_LEGACY_ON_STATE        0x0B
#define IPMI_SENSOR_TYPE_CHIP_EVENT_DATA3_LEGACY_OFF_STATE       0x0C
#define IPMI_SENSOR_TYPE_CHIP_EVENT_DATA3_UNKNOWN                0x0D

#define IPMI_SENSOR_TYPE_CABLE_INTERCONNECT_IS_CONNECTED        0x00
#define IPMI_SENSOR_TYPE_CABLE_INTERCONNECT_CONFIGURATION_ERROR 0x01

#define IPMI_SENSOR_TYPE_SYSTEM_BOOT_INITIATED_INITIATED_BY_POWER_UP                     0x00
#define IPMI_SENSOR_TYPE_SYSTEM_BOOT_INITIATED_INITIATED_BY_HARD_RESET                   0x01
#define IPMI_SENSOR_TYPE_SYSTEM_BOOT_INITIATED_INITIATED_BY_WARM_RESET                   0x02
#define IPMI_SENSOR_TYPE_SYSTEM_BOOT_INITIATED_USER_REQUESTED_PXE_BOOT                   0x03
#define IPMI_SENSOR_TYPE_SYSTEM_BOOT_INITIATED_AUTOMATIC_BOOT_TO_DIAGNOSTIC              0x04
#define IPMI_SENSOR_TYPE_SYSTEM_BOOT_INITIATED_OS_RUN_TIME_SOFTWARE_INITIATED_HARD_RESET 0x05
#define IPMI_SENSOR_TYPE_SYSTEM_BOOT_INITIATED_OS_RUN_TIME_SOFTWARE_INITIATED_WARM_RESET 0x06
#define IPMI_SENSOR_TYPE_SYSTEM_BOOT_INITIATED_SYSTEM_RESTART                            0x07

#define IPMI_SENSOR_TYPE_SYSTEM_BOOT_INITIATED_EVENT_DATA2_OFFSET_SYSTEM_RESTART_UNKNOWN                                                                     0x00
#define IPMI_SENSOR_TYPE_SYSTEM_BOOT_INITIATED_EVENT_DATA2_OFFSET_SYSTEM_RESTART_CHASSIS_CONTROL_COMMAND                                                     0x01
#define IPMI_SENSOR_TYPE_SYSTEM_BOOT_INITIATED_EVENT_DATA2_OFFSET_SYSTEM_RESTART_RESET_VIA_PUSHBUTTON                                                        0x02
#define IPMI_SENSOR_TYPE_SYSTEM_BOOT_INITIATED_EVENT_DATA2_OFFSET_SYSTEM_RESTART_POWER_UP_VIA_POWER_PUSHBUTTON                                               0x03
#define IPMI_SENSOR_TYPE_SYSTEM_BOOT_INITIATED_EVENT_DATA2_OFFSET_SYSTEM_RESTART_WATCHDOG_EXPIRATION                                                         0x04
#define IPMI_SENSOR_TYPE_SYSTEM_BOOT_INITIATED_EVENT_DATA2_OFFSET_SYSTEM_RESTART_OEM                                                                         0x05
#define IPMI_SENSOR_TYPE_SYSTEM_BOOT_INITIATED_EVENT_DATA2_OFFSET_SYSTEM_RESTART_AUTOMATIC_POWER_UP_DUE_TO_ALWAYS_RESTORE_POWER_RESTORE_POLICY               0x06
#define IPMI_SENSOR_TYPE_SYSTEM_BOOT_INITIATED_EVENT_DATA2_OFFSET_SYSTEM_RESTART_AUTOMATIC_POWER_UP_DUE_TO_RESTORE_PREVIOUS_POWER_STATE_POWER_RESTORE_POLICY 0x07
#define IPMI_SENSOR_TYPE_SYSTEM_BOOT_INITIATED_EVENT_DATA2_OFFSET_SYSTEM_RESTART_RESET_VIA_PEF                                                               0x08
#define IPMI_SENSOR_TYPE_SYSTEM_BOOT_INITIATED_EVENT_DATA2_OFFSET_SYSTEM_RESTART_POWER_CYCLE_VIA_PEF                                                         0x09
#define IPMI_SENSOR_TYPE_SYSTEM_BOOT_INITIATED_EVENT_DATA2_OFFSET_SYSTEM_RESTART_SOFT_RESET                                                                  0x0A
#define IPMI_SENSOR_TYPE_SYSTEM_BOOT_INITIATED_EVENT_DATA2_OFFSET_SYSTEM_RESTART_POWER_UP_VIA_RTC_WAKEUP                                                     0x0B

#define IPMI_SENSOR_TYPE_BOOT_ERROR_NO_BOOTABLE_MEDIA                                 0x00
#define IPMI_SENSOR_TYPE_BOOT_ERROR_NON_BOOTABLE_DISKETTE_LEFT_IN_DRIVE               0x01
#define IPMI_SENSOR_TYPE_BOOT_ERROR_PXE_SERVER_NOT_FOUND                              0x02
#define IPMI_SENSOR_TYPE_BOOT_ERROR_INVALID_BOOT_SECTOR                               0x03
#define IPMI_SENSOR_TYPE_BOOT_ERROR_TIMEOUT_WAITING_FOR_USER_SELECTION_OF_BOOT_SOURCE 0x04

#define IPMI_SENSOR_TYPE_OS_BOOT_A_BOOT_COMPLETED                          0x00
#define IPMI_SENSOR_TYPE_OS_BOOT_C_BOOT_COMPLETED                          0x01
#define IPMI_SENSOR_TYPE_OS_BOOT_PXE_BOOT_COMPLETED                        0x02
#define IPMI_SENSOR_TYPE_OS_BOOT_DIAGNOSTIC_BOOT_COMPLETED                 0x03
#define IPMI_SENSOR_TYPE_OS_BOOT_CD_ROM_BOOT_COMPLETED                     0x04
#define IPMI_SENSOR_TYPE_OS_BOOT_ROM_BOOT_COMPLETED                        0x05
#define IPMI_SENSOR_TYPE_OS_BOOT_BOOT_COMPLETED_BOOT_DEVICE_NOT_SPECIFIED  0x06
#define IPMI_SENSOR_TYPE_OS_BOOT_BASE_OS_HYPERVISOR_INSTALLATION_STARTED   0x07
#define IPMI_SENSOR_TYPE_OS_BOOT_BASE_OS_HYPERVISOR_INSTALLATION_COMPLETED 0x08
#define IPMI_SENSOR_TYPE_OS_BOOT_BASE_OS_HYPERVISOR_INSTALLATION_ABORTED   0x09
#define IPMI_SENSOR_TYPE_OS_BOOT_BASE_OS_HYPERVISOR_INSTALLATION_FAILED    0x0A

#define IPMI_SENSOR_TYPE_OS_CRITICAL_STOP_CRITICAL_STOP_DURING_OS_LOAD   0x00
#define IPMI_SENSOR_TYPE_OS_CRITICAL_STOP_RUN_TIME_CRITICAL_STOP         0x01
#define IPMI_SENSOR_TYPE_OS_CRITICAL_STOP_OS_GRACEFUL_STOP               0x02
#define IPMI_SENSOR_TYPE_OS_CRITICAL_STOP_OS_GRACEFUL_SHUTDOWN           0x03
#define IPMI_SENSOR_TYPE_OS_CRITICAL_STOP_SOFT_SHUTDOWN_INITIATED_BY_PEF 0x04
#define IPMI_SENSOR_TYPE_OS_CRITICAL_STOP_AGENT_NOT_RESPONDING           0x05

#define IPMI_SENSOR_TYPE_SLOT_CONNECTOR_FAULT_STATUS_ASSERTED                        0x00
#define IPMI_SENSOR_TYPE_SLOT_CONNECTOR_IDENTIFY_STATUS_ASSERTED                     0x01
#define IPMI_SENSOR_TYPE_SLOT_CONNECTOR_SLOT_CONNECTOR_DEVICE_INSTALLED_ATTACHED     0x02
#define IPMI_SENSOR_TYPE_SLOT_CONNECTOR_SLOT_CONNECTOR_READY_FOR_DEVICE_INSTALLATION 0x03
#define IPMI_SENSOR_TYPE_SLOT_CONNECTOR_SLOT_CONNECTOR_READY_FOR_DEVICE_REMOVAL      0x04
#define IPMI_SENSOR_TYPE_SLOT_CONNECTOR_SLOT_POWER_IS_OFF                            0x05
#define IPMI_SENSOR_TYPE_SLOT_CONNECTOR_SLOT_CONNECTOR_DEVICE_REMOVAL_REQUEST        0x06
#define IPMI_SENSOR_TYPE_SLOT_CONNECTOR_INTERLOCK_ASSERTED                           0x07
#define IPMI_SENSOR_TYPE_SLOT_CONNECTOR_SLOT_IS_DISABLED                             0x08
#define IPMI_SENSOR_TYPE_SLOT_CONNECTOR_SLOT_HOLDS_SPARE_DEVICE                      0x09

#define IPMI_SENSOR_TYPE_SLOT_CONNECTOR_EVENT_DATA2_PCI                                                           0x00
#define IPMI_SENSOR_TYPE_SLOT_CONNECTOR_EVENT_DATA2_DRIVE_ARRAY                                                   0x01
#define IPMI_SENSOR_TYPE_SLOT_CONNECTOR_EVENT_DATA2_EXTERNAL_PERIPHERAL_CONNECTOR                                 0x02
#define IPMI_SENSOR_TYPE_SLOT_CONNECTOR_EVENT_DATA2_DOCKING                                                       0x03
#define IPMI_SENSOR_TYPE_SLOT_CONNECTOR_EVENT_DATA2_OTHER_STANDARD_INTERNAL_EXPANSION_SLOT                        0x04
#define IPMI_SENSOR_TYPE_SLOT_CONNECTOR_EVENT_DATA2_SLOT_ASSOCIATED_WITH_ENTITY_SPECIFIED_BY_ENTITY_ID_FOR_SENSOR 0x05
#define IPMI_SENSOR_TYPE_SLOT_CONNECTOR_EVENT_DATA2_ADVANCEDTCA                                                   0x06
#define IPMI_SENSOR_TYPE_SLOT_CONNECTOR_EVENT_DATA2_DIMM_MEMORY_DEVICE                                            0x07
#define IPMI_SENSOR_TYPE_SLOT_CONNECTOR_EVENT_DATA2_FAN                                                           0x08
#define IPMI_SENSOR_TYPE_SLOT_CONNECTOR_EVENT_DATA2_PCI_EXPRESS                                                   0x09
#define IPMI_SENSOR_TYPE_SLOT_CONNECTOR_EVENT_DATA2_SCSI                                                          0x0A
#define IPMI_SENSOR_TYPE_SLOT_CONNECTOR_EVENT_DATA2_SATA_SAS                                                      0x0B
#define IPMI_SENSOR_TYPE_SLOT_CONNECTOR_EVENT_DATA2_USB                                                           0x0C

#define IPMI_SENSOR_TYPE_SYSTEM_ACPI_POWER_STATE_S0_G0                             0x00
#define IPMI_SENSOR_TYPE_SYSTEM_ACPI_POWER_STATE_S1                                0x01
#define IPMI_SENSOR_TYPE_SYSTEM_ACPI_POWER_STATE_S2                                0x02
#define IPMI_SENSOR_TYPE_SYSTEM_ACPI_POWER_STATE_S3                                0x03
#define IPMI_SENSOR_TYPE_SYSTEM_ACPI_POWER_STATE_S4                                0x04
#define IPMI_SENSOR_TYPE_SYSTEM_ACPI_POWER_STATE_S5_G2                             0x05
#define IPMI_SENSOR_TYPE_SYSTEM_ACPI_POWER_STATE_S4_S5_SOFT_OFF                    0x06
#define IPMI_SENSOR_TYPE_SYSTEM_ACPI_POWER_STATE_G3_MECHANICAL_OFF                 0x07
#define IPMI_SENSOR_TYPE_SYSTEM_ACPI_POWER_STATE_SLEEPING_IN_AN_S1_S2_OR_S3_STATES 0x08
#define IPMI_SENSOR_TYPE_SYSTEM_ACPI_POWER_STATE_G1_SLEEPING                       0x09
#define IPMI_SENSOR_TYPE_SYSTEM_ACPI_POWER_STATE_S5_ENTERED_BY_OVERRIDE            0x0A
#define IPMI_SENSOR_TYPE_SYSTEM_ACPI_POWER_STATE_LEGACY_ON_STATE                   0x0B
#define IPMI_SENSOR_TYPE_SYSTEM_ACPI_POWER_STATE_LEGACY_OFF_STATE                  0x0C
#define IPMI_SENSOR_TYPE_SYSTEM_ACPI_POWER_STATE_UNSPECIFIED                       0x0D
#define IPMI_SENSOR_TYPE_SYSTEM_ACPI_POWER_STATE_UNKNOWN                           0x0E

#define IPMI_SENSOR_TYPE_WATCHDOG2_TIMER_EXPIRED   0x00
#define IPMI_SENSOR_TYPE_WATCHDOG2_HARD_RESET      0x01
#define IPMI_SENSOR_TYPE_WATCHDOG2_POWER_DOWN      0x02
#define IPMI_SENSOR_TYPE_WATCHDOG2_POWER_CYCLE     0x03
#define IPMI_SENSOR_TYPE_WATCHDOG2_RESERVED1       0x04
#define IPMI_SENSOR_TYPE_WATCHDOG2_RESERVED2       0x05
#define IPMI_SENSOR_TYPE_WATCHDOG2_RESERVED3       0x06
#define IPMI_SENSOR_TYPE_WATCHDOG2_RESERVED4       0x07
#define IPMI_SENSOR_TYPE_WATCHDOG2_TIMER_INTERRUPT 0x08

#define IPMI_SENSOR_TYPE_WATCHDOG2_EVENT_DATA2_INTERRUPT_TYPE_NONE              0x0
#define IPMI_SENSOR_TYPE_WATCHDOG2_EVENT_DATA2_INTERRUPT_TYPE_SMI               0x1
#define IPMI_SENSOR_TYPE_WATCHDOG2_EVENT_DATA2_INTERRUPT_TYPE_NMI               0x2
#define IPMI_SENSOR_TYPE_WATCHDOG2_EVENT_DATA2_INTERRUPT_TYPE_MESSAGE_INTERRUPT 0x3
#define IPMI_SENSOR_TYPE_WATCHDOG2_EVENT_DATA2_INTERRUPT_TYPE_UNSPECIFIED       0xF

#define IPMI_SENSOR_TYPE_WATCHDOG2_EVENT_DATA2_TIMER_USE_AT_EXPIRATION_RESERVED    0x0
#define IPMI_SENSOR_TYPE_WATCHDOG2_EVENT_DATA2_TIMER_USE_AT_EXPIRATION_BIOS_FRB2   0x1
#define IPMI_SENSOR_TYPE_WATCHDOG2_EVENT_DATA2_TIMER_USE_AT_EXPIRATION_BIOS_POST   0x2
#define IPMI_SENSOR_TYPE_WATCHDOG2_EVENT_DATA2_TIMER_USE_AT_EXPIRATION_OS_LOAD     0x3
#define IPMI_SENSOR_TYPE_WATCHDOG2_EVENT_DATA2_TIMER_USE_AT_EXPIRATION_SMS_OS      0x4
#define IPMI_SENSOR_TYPE_WATCHDOG2_EVENT_DATA2_TIMER_USE_AT_EXPIRATION_OEM         0x5
#define IPMI_SENSOR_TYPE_WATCHDOG2_EVENT_DATA2_TIMER_USE_AT_EXPIRATION_UNSPECIFIED 0xF

#define IPMI_SENSOR_TYPE_PLATFORM_ALERT_PLATFORM_GENERATED_PAGE       0x00
#define IPMI_SENSOR_TYPE_PLATFORM_ALERT_PLATFORM_GENERATED_LAN_ALERT  0x01
#define IPMI_SENSOR_TYPE_PLATFORM_ALERT_PLATFORM_EVENT_TRAP_GENERATED 0x02
#define IPMI_SENSOR_TYPE_PLATFORM_ALERT_PLATFORM_GENERATED_SNMP_TRAP  0x03

#define IPMI_SENSOR_TYPE_ENTITY_PRESENCE_ENTITY_PRESENT  0x00
#define IPMI_SENSOR_TYPE_ENTITY_PRESENCE_ENTITY_ABSENT   0x01
#define IPMI_SENSOR_TYPE_ENTITY_PRESENCE_ENTITY_DISABLED 0x02

#define IPMI_SENSOR_TYPE_LAN_HEARTBEAT_LOST 0x00
#define IPMI_SENSOR_TYPE_LAN_HEARTBEAT      0x01

#define IPMI_SENSOR_TYPE_MANAGEMENT_SUBSYSTEM_HEALTH_SENSOR_ACCESS_DEGRADED_OR_UNAVAILABLE     0x00
#define IPMI_SENSOR_TYPE_MANAGEMENT_SUBSYSTEM_HEALTH_CONTROLLER_ACCESS_DEGRADED_OR_UNAVAILABLE 0x01
#define IPMI_SENSOR_TYPE_MANAGEMENT_SUBSYSTEM_HEALTH_MANAGEMENT_CONTROLLER_OFF_LINE            0x02
#define IPMI_SENSOR_TYPE_MANAGEMENT_SUBSYSTEM_HEALTH_MANAGEMENT_CONTROLLER_UNAVAILABLE         0x03
#define IPMI_SENSOR_TYPE_MANAGEMENT_SUBSYSTEM_HEALTH_SENSOR_FAILURE                            0x04
#define IPMI_SENSOR_TYPE_MANAGEMENT_SUBSYSTEM_HEALTH_FRU_FAILURE                               0x05

#define IPMI_SENSOR_TYPE_MANAGEMENT_SUBSYSTEM_HEALTH_EVENT_DATA2_OFFSET_FRU_FAILURE_DEVICE_IS_NOT_A_LOGICAL_FRU_DEVICE 0x0
#define IPMI_SENSOR_TYPE_MANAGEMENT_SUBSYSTEM_HEALTH_EVENT_DATA2_OFFSET_FRU_FAILURE_DEVICE_IS_LOGICAL_FRU_DEVICE       0x1

#define IPMI_SENSOR_TYPE_BATTERY_BATTERY_LOW               0x00
#define IPMI_SENSOR_TYPE_BATTERY_BATTERY_FAILED            0x01
#define IPMI_SENSOR_TYPE_BATTERY_BATTERY_PRESENCE_DETECTED 0x02

#define IPMI_SENSOR_TYPE_SESSION_AUDIT_SESSION_ACTIVATED            0x00
#define IPMI_SENSOR_TYPE_SESSION_AUDIT_SESSION_DEACTIVATED          0x01
#define IPMI_SENSOR_TYPE_SESSION_AUDIT_INVALID_USERNAME_OR_PASSWORD 0x02
#define IPMI_SENSOR_TYPE_SESSION_AUDIT_INVALID_PASSWORD_DISABLE     0x03

#define IPMI_SENSOR_TYPE_SESSION_AUDIT_EVENT_DATA3_OFFSET_SESSION_DEACTIVATED_DEACTIVATION_CAUSE_UNSPECIFIED           0x0
#define IPMI_SENSOR_TYPE_SESSION_AUDIT_EVENT_DATA3_OFFSET_SESSION_DEACTIVATED_DEACTIVATION_CAUSE_CLOSE_SESSION_COMMAND 0x1
#define IPMI_SENSOR_TYPE_SESSION_AUDIT_EVENT_DATA3_OFFSET_SESSION_DEACTIVATED_DEACTIVATION_CAUSE_TIMEOUT               0x2
#define IPMI_SENSOR_TYPE_SESSION_AUDIT_EVENT_DATA3_OFFSET_SESSION_DEACTIVATED_DEACTIVATION_CAUSE_CONFIGURATION_CHANGE  0x3

#define IPMI_SENSOR_TYPE_VERSION_CHANGE_HARDWARE_CHANGE_DETECTED_WITH_ASSOCIATED_ENTITY                        0x00
#define IPMI_SENSOR_TYPE_VERSION_CHANGE_FIRMWARE_OR_SOFTWARE_CHANGE_DETECTED_WITH_ASSOCIATED_ENTITY            0x01
#define IPMI_SENSOR_TYPE_VERSION_CHANGE_HARDWARE_INCOMPATABILITY_DETECTED_WITH_ASSOCIATED_ENTITY               0x02
#define IPMI_SENSOR_TYPE_VERSION_CHANGE_FIRMWARE_OR_SOFTWARE_INCOMPATABILITY_DETECTED_WITH_ASSOCIATED_ENTITY   0x03
#define IPMI_SENSOR_TYPE_VERSION_CHANGE_ENTITY_IS_OF_AN_INVALID_OR_UNSUPPORTED_HARDWARE_VERSION                0x04
#define IPMI_SENSOR_TYPE_VERSION_CHANGE_ENTITY_CONTAINS_AN_INVALID_OR_UNSUPPORTED_FIRMWARE_OR_SOFTWARE_VERSION 0x05
#define IPMI_SENSOR_TYPE_VERSION_CHANGE_HARDWARE_CHANGE_DETECTED_WITH_ASSOCIATED_ENTITY_WAS_SUCCESSFUL         0x06
#define IPMI_SENSOR_TYPE_VERSION_CHANGE_SOFTWARE_OR_FW_CHANGE_DETECTED_WITH_ASSOCIATED_ENTITY_WAS_SUCCESSFUL   0x07

#define IPMI_SENSOR_TYPE_VERSION_CHANGE_EVENT_DATA2_OFFSET_SOFTWARE_OR_FW_CHANGE_DETECTED_WITH_ASSOCIATED_ENTITY_WAS_SUCCESSFUL_UNSPECIFIED                                 0x00
#define IPMI_SENSOR_TYPE_VERSION_CHANGE_EVENT_DATA2_OFFSET_SOFTWARE_OR_FW_CHANGE_DETECTED_WITH_ASSOCIATED_ENTITY_WAS_SUCCESSFUL_MANAGEMENT_CONTROLLER_DEVICE_ID             0x01
#define IPMI_SENSOR_TYPE_VERSION_CHANGE_EVENT_DATA2_OFFSET_SOFTWARE_OR_FW_CHANGE_DETECTED_WITH_ASSOCIATED_ENTITY_WAS_SUCCESSFUL_MANAGEMENT_CONTROLLER_FIRMWARE_REVISION     0x02
#define IPMI_SENSOR_TYPE_VERSION_CHANGE_EVENT_DATA2_OFFSET_SOFTWARE_OR_FW_CHANGE_DETECTED_WITH_ASSOCIATED_ENTITY_WAS_SUCCESSFUL_MANAGEMENT_CONTROLLER_DEVICE_REVISION       0x03
#define IPMI_SENSOR_TYPE_VERSION_CHANGE_EVENT_DATA2_OFFSET_SOFTWARE_OR_FW_CHANGE_DETECTED_WITH_ASSOCIATED_ENTITY_WAS_SUCCESSFUL_MANAGEMENT_CONTROLLER_MANUFACTURER_ID       0x04
#define IPMI_SENSOR_TYPE_VERSION_CHANGE_EVENT_DATA2_OFFSET_SOFTWARE_OR_FW_CHANGE_DETECTED_WITH_ASSOCIATED_ENTITY_WAS_SUCCESSFUL_MANAGEMENT_CONTROLLER_IPMI_VERSION          0x05
#define IPMI_SENSOR_TYPE_VERSION_CHANGE_EVENT_DATA2_OFFSET_SOFTWARE_OR_FW_CHANGE_DETECTED_WITH_ASSOCIATED_ENTITY_WAS_SUCCESSFUL_MANAGEMENT_CONTROLLER_AUXILIARY_FIRMWARE_ID 0x06
#define IPMI_SENSOR_TYPE_VERSION_CHANGE_EVENT_DATA2_OFFSET_SOFTWARE_OR_FW_CHANGE_DETECTED_WITH_ASSOCIATED_ENTITY_WAS_SUCCESSFUL_MANAGEMENT_CONTROLLER_FIRMWARE_BOOT_BLOCK   0x07
#define IPMI_SENSOR_TYPE_VERSION_CHANGE_EVENT_DATA2_OFFSET_SOFTWARE_OR_FW_CHANGE_DETECTED_WITH_ASSOCIATED_ENTITY_WAS_SUCCESSFUL_OTHER_MANAGEMENT_CONTROLLER_FIRMWARE        0x08
#define IPMI_SENSOR_TYPE_VERSION_CHANGE_EVENT_DATA2_OFFSET_SOFTWARE_OR_FW_CHANGE_DETECTED_WITH_ASSOCIATED_ENTITY_WAS_SUCCESSFUL_SYSTEM_FIRMWARE_CHANGE                      0x09
#define IPMI_SENSOR_TYPE_VERSION_CHANGE_EVENT_DATA2_OFFSET_SOFTWARE_OR_FW_CHANGE_DETECTED_WITH_ASSOCIATED_ENTITY_WAS_SUCCESSFUL_SMBIOS_CHANGE                               0x0A
#define IPMI_SENSOR_TYPE_VERSION_CHANGE_EVENT_DATA2_OFFSET_SOFTWARE_OR_FW_CHANGE_DETECTED_WITH_ASSOCIATED_ENTITY_WAS_SUCCESSFUL_OPERATING_SYSTEM_CHANGE                     0x0B
#define IPMI_SENSOR_TYPE_VERSION_CHANGE_EVENT_DATA2_OFFSET_SOFTWARE_OR_FW_CHANGE_DETECTED_WITH_ASSOCIATED_ENTITY_WAS_SUCCESSFUL_OPERATING_SYSTEM_LOADER_CHANGE              0x0C
#define IPMI_SENSOR_TYPE_VERSION_CHANGE_EVENT_DATA2_OFFSET_SOFTWARE_OR_FW_CHANGE_DETECTED_WITH_ASSOCIATED_ENTITY_WAS_SUCCESSFUL_SERVICE_OR_DIAGNOSTIC_PARTITION_CHANGE      0x0D
#define IPMI_SENSOR_TYPE_VERSION_CHANGE_EVENT_DATA2_OFFSET_SOFTWARE_OR_FW_CHANGE_DETECTED_WITH_ASSOCIATED_ENTITY_WAS_SUCCESSFUL_MANAGEMENT_SOFTWARE_AGENT_CHANGE            0x0E
#define IPMI_SENSOR_TYPE_VERSION_CHANGE_EVENT_DATA2_OFFSET_SOFTWARE_OR_FW_CHANGE_DETECTED_WITH_ASSOCIATED_ENTITY_WAS_SUCCESSFUL_MANAGEMENT_SOFTWARE_APPLICATION_CHANGE      0x0F
#define IPMI_SENSOR_TYPE_VERSION_CHANGE_EVENT_DATA2_OFFSET_SOFTWARE_OR_FW_CHANGE_DETECTED_WITH_ASSOCIATED_ENTITY_WAS_SUCCESSFUL_MANAGEMENT_SOFTWARE_MIDDLEWARE_CHANGE       0x10
#define IPMI_SENSOR_TYPE_VERSION_CHANGE_EVENT_DATA2_OFFSET_SOFTWARE_OR_FW_CHANGE_DETECTED_WITH_ASSOCIATED_ENTITY_WAS_SUCCESSFUL_PROGRAMMABLE_HARDWARE_CHANGE                0x11
#define IPMI_SENSOR_TYPE_VERSION_CHANGE_EVENT_DATA2_OFFSET_SOFTWARE_OR_FW_CHANGE_DETECTED_WITH_ASSOCIATED_ENTITY_WAS_SUCCESSFUL_BOARD_FRU_MODULE_CHANGE                     0x12
#define IPMI_SENSOR_TYPE_VERSION_CHANGE_EVENT_DATA2_OFFSET_SOFTWARE_OR_FW_CHANGE_DETECTED_WITH_ASSOCIATED_ENTITY_WAS_SUCCESSFUL_BOARD_FRU_COMPONENT_CHANGE                  0x13
#define IPMI_SENSOR_TYPE_VERSION_CHANGE_EVENT_DATA2_OFFSET_SOFTWARE_OR_FW_CHANGE_DETECTED_WITH_ASSOCIATED_ENTITY_WAS_SUCCESSFUL_BOARD_FRU_REPLACED_WITH_EQUIVALENT_VERSION  0x14
#define IPMI_SENSOR_TYPE_VERSION_CHANGE_EVENT_DATA2_OFFSET_SOFTWARE_OR_FW_CHANGE_DETECTED_WITH_ASSOCIATED_ENTITY_WAS_SUCCESSFUL_BOARD_FRU_REPLACED_WITH_NEWER_VERSION       0x15
#define IPMI_SENSOR_TYPE_VERSION_CHANGE_EVENT_DATA2_OFFSET_SOFTWARE_OR_FW_CHANGE_DETECTED_WITH_ASSOCIATED_ENTITY_WAS_SUCCESSFUL_BOARD_FRU_REPLACED_WITH_OLDER_VERSION       0x16
#define IPMI_SENSOR_TYPE_VERSION_CHANGE_EVENT_DATA2_OFFSET_SOFTWARE_OR_FW_CHANGE_DETECTED_WITH_ASSOCIATED_ENTITY_WAS_SUCCESSFUL_BOARD_FRU_HARDWARE_CONFIGURATION_CHANGE     0x17

#define IPMI_SENSOR_TYPE_FRU_STATE_FRU_NOT_INSTALLED            0x00
#define IPMI_SENSOR_TYPE_FRU_STATE_FRU_INACTIVE                 0x01
#define IPMI_SENSOR_TYPE_FRU_STATE_FRU_ACTIVATION_REQUESTED     0x02
#define IPMI_SENSOR_TYPE_FRU_STATE_FRU_ACTIVATION_IN_PROGRESS   0x03
#define IPMI_SENSOR_TYPE_FRU_STATE_FRU_ACTIVE                   0x04
#define IPMI_SENSOR_TYPE_FRU_STATE_FRU_DEACTIVATION_REQUESTED   0x05
#define IPMI_SENSOR_TYPE_FRU_STATE_FRU_DEACTIVATION_IN_PROGRESS 0x06
#define IPMI_SENSOR_TYPE_FRU_STATE_FRU_COMMUNICATION_LOST       0x07

#define IPMI_SENSOR_TYPE_FRU_STATE_EVENT_DATA2_OFFSET_COMMUNICATION_LOST_CAUSE_OF_STATE_CHANGE_NORMAL_STATE_CHANGE                                           0x0
#define IPMI_SENSOR_TYPE_FRU_STATE_EVENT_DATA2_OFFSET_COMMUNICATION_LOST_CAUSE_OF_STATE_CHANGE_CHANGE_COMMAND_BY_SOFTWARE_EXTERNAL_TO_FRU                    0x1
#define IPMI_SENSOR_TYPE_FRU_STATE_EVENT_DATA2_OFFSET_COMMUNICATION_LOST_CAUSE_OF_STATE_CHANGE_STATE_CHANGE_DUE_TO_OPERATOR_CHANGING_A_HANDLE_LATCH          0x2
#define IPMI_SENSOR_TYPE_FRU_STATE_EVENT_DATA2_OFFSET_COMMUNICATION_LOST_CAUSE_OF_STATE_CHANGE_STATE_CHANGE_DUE_TO_OPERATOR_PRESSING_THE_HOTSWAP_PUSH_BUTTON 0x3
#define IPMI_SENSOR_TYPE_FRU_STATE_EVENT_DATA2_OFFSET_COMMUNICATION_LOST_CAUSE_OF_STATE_CHANGE_STATE_CHANGE_DUE_TO_FRU_PROGRAMMATIC_ACTION                   0x4
#define IPMI_SENSOR_TYPE_FRU_STATE_EVENT_DATA2_OFFSET_COMMUNICATION_LOST_CAUSE_OF_STATE_CHANGE_COMMUNICATION_LOST                                            0x5
#define IPMI_SENSOR_TYPE_FRU_STATE_EVENT_DATA2_OFFSET_COMMUNICATION_LOST_CAUSE_OF_STATE_CHANGE_COMMUNICATION_LOST_DUE_TO_LOCAL_FAILURE                       0x6
#define IPMI_SENSOR_TYPE_FRU_STATE_EVENT_DATA2_OFFSET_COMMUNICATION_LOST_CAUSE_OF_STATE_CHANGE_STATE_CHANGE_DUE_TO_UNEXPECTED_EXTRACTION                     0x7
#define IPMI_SENSOR_TYPE_FRU_STATE_EVENT_DATA2_OFFSET_COMMUNICATION_LOST_CAUSE_OF_STATE_CHANGE_STATE_CHANGE_DUE_TO_OPERATOR_INTERVENTION_UPDATE              0x8
#define IPMI_SENSOR_TYPE_FRU_STATE_EVENT_DATA2_OFFSET_COMMUNICATION_LOST_CAUSE_OF_STATE_CHANGE_UNABLE_TO_COMPUTE_IPMB_ADDRESS                                0x9
#define IPMI_SENSOR_TYPE_FRU_STATE_EVENT_DATA2_OFFSET_COMMUNICATION_LOST_CAUSE_OF_STATE_CHANGE_UNEXPECTED_DEACTIVATION                                       0xA
#define IPMI_SENSOR_TYPE_FRU_STATE_EVENT_DATA2_OFFSET_COMMUNICATION_LOST_CAUSE_OF_STATE_CHANGE_STATE_CHANGE_CAUSE_UNKNOWN                                    0xF

/*
 * String arrays for above
 */

extern const char * const ipmi_sensor_type_physical_security[];
extern unsigned int ipmi_sensor_type_physical_security_max_index;

extern const char * const ipmi_sensor_type_platform_security_violation_attempt[];
extern unsigned int ipmi_sensor_type_platform_security_violation_attempt_max_index;

extern const char * const ipmi_sensor_type_processor[];
extern unsigned int ipmi_sensor_type_processor_max_index;

extern const char * const ipmi_sensor_type_power_supply[];
extern unsigned int ipmi_sensor_type_power_supply_max_index;

extern const char * const ipmi_sensor_type_power_unit[];
extern unsigned int ipmi_sensor_type_power_unit_max_index;

extern const char * const ipmi_sensor_type_memory[];
extern unsigned int ipmi_sensor_type_memory_max_index;

extern const char * const ipmi_sensor_type_drive_slot[];
extern unsigned int ipmi_sensor_type_drive_slot_max_index;

extern const char * const ipmi_sensor_type_system_firmware_progress[];
extern unsigned int ipmi_sensor_type_system_firmware_progress_max_index;

extern const char * const ipmi_sensor_type_event_logging_disabled[];
extern unsigned int ipmi_sensor_type_event_logging_disabled_max_index;

extern const char * const ipmi_sensor_type_watchdog1[];
extern unsigned int ipmi_sensor_type_watchdog1_max_index;

extern const char * const ipmi_sensor_type_system_event[];
extern unsigned int ipmi_sensor_type_system_event_max_index;

extern const char * const ipmi_sensor_type_critical_interrupt[];
extern unsigned int ipmi_sensor_type_critical_interrupt_max_index;

extern const char * const ipmi_sensor_type_button_switch[];
extern unsigned int ipmi_sensor_type_button_switch_max_index;

extern const char * const ipmi_sensor_type_chip_set[];
extern unsigned int ipmi_sensor_type_chip_set_max_index;

extern const char * const ipmi_sensor_type_cable_interconnect[];
extern unsigned int ipmi_sensor_type_cable_interconnect_max_index;

extern const char * const ipmi_sensor_type_system_boot_initiated[];
extern unsigned int ipmi_sensor_type_system_boot_initiated_max_index;

extern const char * const ipmi_sensor_type_boot_error[];
extern unsigned int ipmi_sensor_type_boot_error_max_index;

extern const char * const ipmi_sensor_type_os_boot[];
extern unsigned int ipmi_sensor_type_os_boot_max_index;

extern const char * const ipmi_sensor_type_os_critical_stop[];
extern unsigned int ipmi_sensor_type_os_critical_stop_max_index;

extern const char * const ipmi_sensor_type_slot_connector[];
extern unsigned int ipmi_sensor_type_slot_connector_max_index;

extern const char * const ipmi_sensor_type_acpi_power_state[];
extern unsigned int ipmi_sensor_type_acpi_power_state_max_index;

extern const char * const ipmi_sensor_type_watchdog2[];
extern unsigned int ipmi_sensor_type_watchdog2_max_index;

extern const char * const ipmi_sensor_type_platform_alert[];
extern unsigned int ipmi_sensor_type_platform_alert_max_index;

extern const char * const ipmi_sensor_type_entity_presence[];
extern unsigned int ipmi_sensor_type_entity_presence_max_index;

extern const char * const ipmi_sensor_type_lan[];
extern unsigned int ipmi_sensor_type_lan_max_index;

extern const char * const ipmi_sensor_type_management_subsystem_health[];
extern unsigned int ipmi_sensor_type_management_subsystem_health_max_index;

extern const char * const ipmi_sensor_type_battery[];
extern unsigned int ipmi_sensor_type_battery_max_index;

extern const char * const ipmi_sensor_type_session_audit[];
extern unsigned int ipmi_sensor_type_session_audit_max_index;

extern const char * const ipmi_sensor_type_version_change[];
extern unsigned int ipmi_sensor_type_version_change_max_index;

extern const char * const ipmi_sensor_type_fru_state[];
extern unsigned int ipmi_sensor_type_fru_state_max_index;

/*
 * "short" arrays are same strings, but shortened to more reasonble lengths for output
 */
extern const char * const ipmi_sensor_type_physical_security_short[];
extern unsigned int ipmi_sensor_type_physical_security_short_max_index;

extern const char * const ipmi_sensor_type_platform_security_violation_attempt_short[];
extern unsigned int ipmi_sensor_type_platform_security_violation_attempt_short_max_index;

extern const char * const ipmi_sensor_type_processor_short[];
extern unsigned int ipmi_sensor_type_processor_short_max_index;

extern const char * const ipmi_sensor_type_power_supply_short[];
extern unsigned int ipmi_sensor_type_power_supply_short_max_index;

extern const char * const ipmi_sensor_type_power_unit_short[];
extern unsigned int ipmi_sensor_type_power_unit_short_max_index;

extern const char * const ipmi_sensor_type_memory_short[];
extern unsigned int ipmi_sensor_type_memory_short_max_index;

extern const char * const ipmi_sensor_type_drive_slot_short[];
extern unsigned int ipmi_sensor_type_drive_slot_short_max_index;

extern const char * const ipmi_sensor_type_system_firmware_progress_short[];
extern unsigned int ipmi_sensor_type_system_firmware_progress_short_max_index;

extern const char * const ipmi_sensor_type_event_logging_disabled_short[];
extern unsigned int ipmi_sensor_type_event_logging_disabled_short_max_index;

extern const char * const ipmi_sensor_type_watchdog1_short[];
extern unsigned int ipmi_sensor_type_watchdog1_short_max_index;

extern const char * const ipmi_sensor_type_system_event_short[];
extern unsigned int ipmi_sensor_type_system_event_short_max_index;

extern const char * const ipmi_sensor_type_critical_interrupt_short[];
extern unsigned int ipmi_sensor_type_critical_interrupt_short_max_index;

extern const char * const ipmi_sensor_type_button_switch_short[];
extern unsigned int ipmi_sensor_type_button_switch_short_max_index;

extern const char * const ipmi_sensor_type_chip_set_short[];
extern unsigned int ipmi_sensor_type_chip_set_short_max_index;

extern const char * const ipmi_sensor_type_cable_interconnect_short[];
extern unsigned int ipmi_sensor_type_cable_interconnect_short_max_index;

extern const char * const ipmi_sensor_type_system_boot_initiated_short[];
extern unsigned int ipmi_sensor_type_system_boot_initiated_short_max_index;

extern const char * const ipmi_sensor_type_boot_error_short[];
extern unsigned int ipmi_sensor_type_boot_error_short_max_index;

extern const char * const ipmi_sensor_type_os_boot_short[];
extern unsigned int ipmi_sensor_type_os_boot_short_max_index;

extern const char * const ipmi_sensor_type_os_critical_stop_short[];
extern unsigned int ipmi_sensor_type_os_critical_stop_short_max_index;

extern const char * const ipmi_sensor_type_slot_connector_short[];
extern unsigned int ipmi_sensor_type_slot_connector_short_max_index;

extern const char * const ipmi_sensor_type_acpi_power_state_short[];
extern unsigned int ipmi_sensor_type_acpi_power_state_short_max_index;

extern const char * const ipmi_sensor_type_watchdog2_short[];
extern unsigned int ipmi_sensor_type_watchdog2_short_max_index;

extern const char * const ipmi_sensor_type_platform_alert_short[];
extern unsigned int ipmi_sensor_type_platform_alert_short_max_index;

extern const char * const ipmi_sensor_type_entity_presence_short[];
extern unsigned int ipmi_sensor_type_entity_presence_short_max_index;

extern const char * const ipmi_sensor_type_lan_short[];
extern unsigned int ipmi_sensor_type_lan_short_max_index;

extern const char * const ipmi_sensor_type_management_subsystem_health_short[];
extern unsigned int ipmi_sensor_type_management_subsystem_health_short_max_index;

extern const char * const ipmi_sensor_type_battery_short[];
extern unsigned int ipmi_sensor_type_battery_short_max_index;

extern const char * const ipmi_sensor_type_session_audit_short[];
extern unsigned int ipmi_sensor_type_session_audit_short_max_index;

extern const char * const ipmi_sensor_type_version_change_short[];
extern unsigned int ipmi_sensor_type_version_change_short_max_index;

extern const char * const ipmi_sensor_type_fru_state_short[];
extern unsigned int ipmi_sensor_type_fru_state_short_max_index;

/*
 * event data 2
 */
extern const char * const ipmi_sensor_type_system_firmware_progress_event_data2_offset_system_firmware_error[];
extern unsigned int ipmi_sensor_type_system_firmware_progress_event_data2_offset_system_firmware_error_max_index;

extern const char * const ipmi_sensor_type_system_firmware_progress_event_data2_offset_system_firmware_hang[];
extern unsigned int ipmi_sensor_type_system_firmware_progress_event_data2_offset_system_firmware_hang_max_index;

extern const char * const ipmi_sensor_type_system_firmware_progress_event_data2_offset_system_firmware_progress[];
extern unsigned int ipmi_sensor_type_system_firmware_progress_event_data2_offset_system_firmware_progress_max_index;

extern const char * const ipmi_sensor_type_system_event_event_data2_offset_entry_added_to_auxiliary_log_log_entry_action[];
extern unsigned int ipmi_sensor_type_system_event_event_data2_offset_entry_added_to_auxiliary_log_log_entry_action_max_index;

extern const char * const ipmi_sensor_type_system_event_event_data2_offset_entry_added_to_auxiliary_log_log_type[];
extern unsigned int ipmi_sensor_type_system_event_event_data2_offset_entry_added_to_auxiliary_log_log_type_max_index;

extern const char * const ipmi_sensor_type_system_event_event_data2_offset_pef_action[];
extern unsigned int ipmi_sensor_type_system_event_event_data2_offset_pef_action_max_index;

extern const char * const ipmi_sensor_type_system_event_event_data2_offset_timestamp_clock_synch_first_second[];
extern unsigned int ipmi_sensor_type_system_event_event_data2_offset_timestamp_clock_synch_first_second_max_index;

extern const char * const ipmi_sensor_type_system_event_event_data2_offset_timestamp_clock_synch_timestamp_clock_type[];
extern unsigned int ipmi_sensor_type_system_event_event_data2_offset_timestamp_clock_synch_timestamp_clock_type_max_index;

extern const char * const ipmi_sensor_type_chip_set_event_data2_offset_soft_power_control_failure[];
extern unsigned int ipmi_sensor_type_chip_set_event_data2_offset_soft_power_control_failure_max_index;

extern const char * const ipmi_sensor_type_system_boot_initiated_event_data2_offset_system_restart_restart_cause[];
extern unsigned int ipmi_sensor_type_system_boot_initiated_event_data2_offset_system_restart_restart_cause_max_index;

extern const char * const ipmi_sensor_type_slot_connector_event_data2_offset_slot_holds_spare_device_slot_connector_type[];
extern unsigned int ipmi_sensor_type_slot_connector_event_data2_offset_slot_holds_spare_device_slot_connector_type_max_index;

extern const char * const ipmi_sensor_type_watchdog2_event_data2_interrupt_type[];
extern unsigned int ipmi_sensor_type_watchdog2_event_data2_interrupt_type_max_index;

extern const char * const ipmi_sensor_type_watchdog2_event_data2_timer_use_at_expiration[];
extern unsigned int ipmi_sensor_type_watchdog2_event_data2_timer_use_at_expiration_max_index;

extern const char * const ipmi_sensor_type_management_subsystem_health_event_data2_offset_fru_failure_logical_fru_device[];
extern unsigned int ipmi_sensor_type_management_subsystem_health_event_data2_offset_fru_failure_logical_fru_device_max_index;

extern const char * const ipmi_sensor_type_version_change_event_data2_offset_software_or_fw_change_detected_with_associated_entity_was_successful_version_change_type[];
extern unsigned int ipmi_sensor_type_version_change_event_data2_offset_software_or_fw_change_detected_with_associated_entity_was_successful_version_change_type_max_index;

extern const char * const ipmi_sensor_type_fru_state_event_data2_offset_communication_lost_cause_of_state_change[];
extern unsigned int ipmi_sensor_type_fru_state_event_data2_offset_communication_lost_cause_of_state_change_max_index;

/*
 * event data 2
 */

extern const char * const ipmi_sensor_type_power_supply_event_data3_offset_configuration_error_error_type[];
extern unsigned int ipmi_sensor_type_power_supply_event_data3_offset_configuration_error_error_type_max_index;

extern const char * const ipmi_sensor_type_event_logging_disabled_event_data3_offset_event_type_logging_disabled_assertion_event[];
extern unsigned int ipmi_sensor_type_event_logging_disabled_event_data3_offset_event_type_logging_disabled_assertion_event_max_index;

extern const char * const ipmi_sensor_type_event_logging_disabled_event_data3_offset_event_type_logging_disabled_logging_disabled_all_events[];
extern unsigned int ipmi_sensor_type_event_logging_disabled_event_data3_offset_event_type_logging_disabled_logging_disabled_all_events_max_index;

extern const char * const ipmi_sensor_type_chip_set_event_data3_offset_soft_power_control_failure[];
extern unsigned int ipmi_sensor_type_chip_set_event_data3_offset_soft_power_control_failure_max_index;

extern const char * const ipmi_sensor_type_session_audit_event_data3_offset_session_deactivated_deactivation_cause[];
extern unsigned int ipmi_sensor_type_session_audit_event_data3_offset_session_deactivated_deactivation_cause_max_index;

#ifdef __cplusplus
}
#endif

#endif /* IPMI_SENSOR_AND_EVENT_CODE_TABLES_SPEC_H */
