/*
 * Copyright (C) 2003-2014 FreeIPMI Core Team
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef IPMI_OEM_SPEC_H
#define IPMI_OEM_SPEC_H

#ifdef __cplusplus
extern "C" {
#endif

/******************************************* 
 * Dell                                    *
 *******************************************/
  
/*
 * Dell Poweredge R610
 * Dell Poweredge R710
 * Dell Poweredge R720
 *
 * Support of below varies by system.  Will be noted as appropriate.
 */

/* w/ IPMI_CMD_OEM_DELL_GET_EXTENDED_CONFIGURATION / IPMI_CMD_OEM_DELL_SET_EXTENDED_CONFIGURATION */
#define IPMI_OEM_DELL_TOKEN_ID_NIC_LINK_SETTING_GROUP             0x02
#define IPMI_OEM_DELL_TOKEN_ID_RAC_USER_PRIVILEGE                 0x04
#define IPMI_OEM_DELL_TOKEN_ID_SNMP_GROUP                         0x05
#define IPMI_OEM_DELL_TOKEN_ID_DNS_AND_DDNS_GROUP                 0x06
#define IPMI_OEM_DELL_TOKEN_ID_AD_CONFIGURATION                   0x07
#define IPMI_OEM_DELL_TOKEN_ID_EMAIL_ALERT_CONFIGURATION          0x08
#define IPMI_OEM_DELL_TOKEN_ID_SSL_CONFIGURATION                  0x09
#define IPMI_OEM_DELL_TOKEN_ID_SSH_CONFIGURATION                  0x0A
#define IPMI_OEM_DELL_TOKEN_ID_TELNET_CONFIGURATION               0x0B
#define IPMI_OEM_DELL_TOKEN_ID_WEB_SERVER_CONFIGURATION           0x0C
#define IPMI_OEM_DELL_TOKEN_ID_CR_CONFIGURATION                   0x0D
#define IPMI_OEM_DELL_TOKEN_ID_VM_CONFIGURATION                   0x0E
#define IPMI_OEM_DELL_TOKEN_ID_RAC_INFO                           0x0F
#define IPMI_OEM_DELL_TOKEN_ID_RAC_FW_UPDATE                      0x10
#define IPMI_OEM_DELL_TOKEN_ID_RAC_SERIAL_SHELL                   0x11
#define IPMI_OEM_DELL_TOKEN_ID_MISC                               0x12
#define IPMI_OEM_DELL_TOKEN_ID_OOB_SECURITY                       0x13
#define IPMI_OEM_DELL_TOKEN_ID_RAC_CONTROL                        0x14
#define IPMI_OEM_DELL_TOKEN_ID_RAC_LOG_FILES                      0x15
#define IPMI_OEM_DELL_TOKEN_ID_RAC_CERTIFICATE_FILES              0x16
#define IPMI_OEM_DELL_TOKEN_ID_RAC_SESSION_INFO                   0x17
#define IPMI_OEM_DELL_TOKEN_ID_RAC_TIME                           0x19
#define IPMI_OEM_DELL_TOKEN_ID_RAC_SSAD_CONFIGURATION             0x1B
#define IPMI_OEM_DELL_TOKEN_ID_RAC_USER_CERT_FILES                0x1C
#define IPMI_OEM_DELL_TOKEN_ID_RAC_LOCAL_CONFIGURATION            0x1D
#define IPMI_OEM_DELL_TOKEN_ID_RAC_VKVM_CONFIGURATION             0x1E
#define IPMI_OEM_DELL_TOKEN_ID_IPV6_EXTENDED_GROUP                0x20
#define IPMI_OEM_DELL_TOKEN_ID_IPV6_URL_GROUP                     0x23
#define IPMI_OEM_DELL_TOKEN_ID_ACTIVE_DIRECTORY_USER_DOMAIN_GROUP 0x24
#define IPMI_OEM_DELL_TOKEN_ID_SMART_CARD_GROUP                   0x25
#define IPMI_OEM_DELL_TOKEN_ID_VMEDIA_SHARING_VIA_CMC             0x27
/* achu: renamed in r720 docs, dunno why */
#define IPMI_OEM_DELL_TOKEN_ID_REMOTE_FILE_SHARE                  IPMI_OEM_DELL_TOKEN_ID_VMEDIA_SHARING_VIA_CMC
#define IPMI_OEM_DELL_TOKEN_ID_REMOTE_SYSLOG                      0x28
#define IPMI_OEM_DELL_TOKEN_ID_GENERIC_LDAP_GROUP                 0x29
#define IPMI_OEM_DELL_TOKEN_ID_LDAP_ROLE_GROUP                    0x2A
#define IPMI_OEM_DELL_TOKEN_ID_SSH_PK_GROUP                       0x2B
#define IPMI_OEM_DELL_TOKEN_ID_AD_SRV_LOOKUP_GROUP                0x2D
#define IPMI_OEM_DELL_TOKEN_ID_CLOSE_RAC_SESSION_INFO             0x2E
#define IPMI_OEM_DELL_TOKEN_ID_IPV4_STATIC_EXTENDED_GROUP         0x30
#define IPMI_OEM_DELL_TOKEN_ID_IPV6_STATIC_EXTENDED_GROUP         0x31
#define IPMI_OEM_DELL_TOKEN_ID_STATIC_DNS_DOMAIN_NAME_GROUP       0x32

#define IPMI_OEM_DELL_TOKEN_VERSION                  0x01

#define IPMI_OEM_DELL_TOKEN_DATA_MAX                 65536

#define IPMI_OEM_DELL_TOKEN_STRING_MAX               255

/* IPMI over LAN has a max payload length of 255 total.  So we round
 * down to some reasonable guestimate of what is good.
 */
#define IPMI_OEM_DELL_TOKEN_WRITE_MAX                128

#define IPMI_OEM_DELL_TOKEN_DATA_COMMON_HEADER_LEN   5

#define IPMI_OEM_DELL_EXTENDED_CONFIG_READ_ALL_BYTES 0xFF

#define IPMI_OEM_DELL_EXTENDED_CONFIG_IN_PROGRESS    0x00
#define IPMI_OEM_DELL_EXTENDED_CONFIG_LAST_TOKEN     0x01

/* w/ IPMI_OEM_DELL_TOKEN_ID_NIC_LINK_SETTING_GROUP
 *
 * dedicated nic full duplex - boolean
 * dedicated nic auto negotiation - boolean
 * dedicated nic 10b/100b/1000b - boolean (achu: uint8?)
 * nic selection - uint8
 * nic enable - boolean
 * ipv4 enable - boolean
 */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_NIC_LINK_SETTING_GROUP_DEDICATED_NIC_FULL_DUPLEX_MASK        0x0001
#define IPMI_OEM_DELL_EXTENDED_CONFIG_NIC_LINK_SETTING_GROUP_DEDICATED_NIC_AUTO_NEGOTIATION_MASK   0x0002
#define IPMI_OEM_DELL_EXTENDED_CONFIG_NIC_LINK_SETTING_GROUP_DEDICATED_NIC_BANDWIDTH_MASK          0x0004
#define IPMI_OEM_DELL_EXTENDED_CONFIG_NIC_LINK_SETTING_GROUP_NIC_SELECTION_MASK                    0x0008
#define IPMI_OEM_DELL_EXTENDED_CONFIG_NIC_LINK_SETTING_GROUP_NIC_ENABLE_MASK                       0x0010
#define IPMI_OEM_DELL_EXTENDED_CONFIG_NIC_LINK_SETTING_GROUP_IPV4_ENABLE_MASK                      0x0020

#define IPMI_OEM_DELL_EXTENDED_CONFIG_NIC_LINK_SETTING_GROUP_ALL_FIELD_MASK \
  (IPMI_OEM_DELL_EXTENDED_CONFIG_NIC_LINK_SETTING_GROUP_DEDICATED_NIC_FULL_DUPLEX_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_NIC_LINK_SETTING_GROUP_DEDICATED_NIC_AUTO_NEGOTIATION_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_NIC_LINK_SETTING_GROUP_DEDICATED_NIC_BANDWIDTH_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_NIC_LINK_SETTING_GROUP_NIC_SELECTION_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_NIC_LINK_SETTING_GROUP_NIC_ENABLE_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_NIC_LINK_SETTING_GROUP_IPV4_ENABLE_MASK)

/* w/ IPMI_OEM_DELL_TOKEN_ID_RAC_USER_PRIVILEGE
 *
 * rac style privilege - uint32
 */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_USER_PRIVILEGE_RAC_STYLE_PRIVILEGE_MASK                  0x0001

#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_USER_PRIVILEGE_ALL_FIELD_MASK \
  (IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_USER_PRIVILEGE_RAC_STYLE_PRIVILEGE_MASK)

/* w/ IPMI_OEM_DELL_TOKEN_ID_SNMP_GROUP
 *
 * snmp agent enable - boolean
 * community name for get string length - uint8
 * community name for get string - 0-31
 * community name for set string length - uint8
 * community name for set string - 0-31
 */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_SNMP_GROUP_SNMP_AGENT_ENABLE_MASK                            0x0001
#define IPMI_OEM_DELL_EXTENDED_CONFIG_SNMP_GROUP_COMMUNITY_NAME_FOR_GET_MASK                       0x0002
#define IPMI_OEM_DELL_EXTENDED_CONFIG_SNMP_GROUP_COMMUNITY_NAME_FOR_SET_MASK                       0x0004

#define IPMI_OEM_DELL_EXTENDED_CONFIG_SNMP_GROUP_ALL_FIELD_MASK \
  (IPMI_OEM_DELL_EXTENDED_CONFIG_SNMP_GROUP_SNMP_AGENT_ENABLE_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_SNMP_GROUP_COMMUNITY_NAME_FOR_GET_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_SNMP_GROUP_COMMUNITY_NAME_FOR_SET_MASK)

/* w/ IPMI_OEM_DELL_TOKEN_ID_DNS_AND_DDNS_GROUP
 *
 * dns dhcp enable - boolean
 * dnsserver1 - uint8 * 4
 * dnsserver2 - uint8 * 4
 * dnsregister rac - boolean
 * dns rac name string length - uint8
 * dns rac name string - 0-63 
 * dns domain name dhcp enable - boolean
 * dns domain name string length - uint8
 * dns domain name string - 0-255
 */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_DNS_AND_DDNS_GROUP_DNS_DHCP_ENABLE_MASK                      0x0001
#define IPMI_OEM_DELL_EXTENDED_CONFIG_DNS_AND_DDNS_GROUP_DNS_SERVER_1_MASK                         0x0002
#define IPMI_OEM_DELL_EXTENDED_CONFIG_DNS_AND_DDNS_GROUP_DNS_SERVER_2_MASK                         0x0004
#define IPMI_OEM_DELL_EXTENDED_CONFIG_DNS_AND_DDNS_GROUP_DNS_REGISTER_RAC_MASK                     0x0008
#define IPMI_OEM_DELL_EXTENDED_CONFIG_DNS_AND_DDNS_GROUP_DNS_RAC_NAME_MASK                         0x0010
#define IPMI_OEM_DELL_EXTENDED_CONFIG_DNS_AND_DDNS_GROUP_DNS_DOMAIN_NAME_DHCP_ENABLE_MASK          0x0020
#define IPMI_OEM_DELL_EXTENDED_CONFIG_DNS_AND_DDNS_GROUP_DNS_DOMAIN_NAME_MASK                      0x0040

#define IPMI_OEM_DELL_EXTENDED_CONFIG_DNS_AND_DDNS_GROUP_ALL_FIELD_MASK \
  (IPMI_OEM_DELL_EXTENDED_CONFIG_DNS_AND_DDNS_GROUP_DNS_DHCP_ENABLE_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_DNS_AND_DDNS_GROUP_DNS_SERVER_1_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_DNS_AND_DDNS_GROUP_DNS_SERVER_2_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_DNS_AND_DDNS_GROUP_DNS_REGISTER_RAC_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_DNS_AND_DDNS_GROUP_DNS_RAC_NAME_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_DNS_AND_DDNS_GROUP_DNS_DOMAIN_NAME_DHCP_ENABLE_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_DNS_AND_DDNS_GROUP_DNS_DOMAIN_NAME_MASK)

/* w/ IPMI_OEM_DELL_TOKEN_ID_AD_CONFIGURATION
 *
 * ad enable - boolean
 * ad timeout - uint32
 * ad root domain string length - uint8
 * ad root domain
 * ad rac domain string length - uint8
 * ad rac domain string - 0-255
 * ad rac name string length - uint8
 * ad rac name string - 0-255
 * ad type - uint8
 * scl state - uint8 (drac5)
 * crl state - uint8 (drac5)
 * ad sso enable - boolean
 * ad dc filter1 string length - uint8
 * ad dc filter1 string - 0-255   
 * ad dc filter2 string length - uint8
 * ad dc filter2 string - 0-255   
 * ad dc filter3 string length - uint8
 * ad dc filter3 string - 0-255   
 * ad gc filter1 string length - uint8
 * ad gc filter1 string - 0-255   
 * ad gc filter2 string length - uint8
 * ad gc filter2 string - 0-255   
 * ad gc filter3 string length - uint8
 * ad gc filter3 string - 0-255   
 * ad certificate validation enable - boolean
 */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_AD_CONFIGURATION_AD_ENABLE_FIELD_MASK                        0x0001
#define IPMI_OEM_DELL_EXTENDED_CONFIG_AD_CONFIGURATION_AD_TIMEOUT_FIELD_MASK                       0x0002
#define IPMI_OEM_DELL_EXTENDED_CONFIG_AD_CONFIGURATION_AD_ROOT_DOMAIN_FIELD_MASK                   0x0004
#define IPMI_OEM_DELL_EXTENDED_CONFIG_AD_CONFIGURATION_AD_RAC_DOMAIN_FIELD_MASK                    0x0008
#define IPMI_OEM_DELL_EXTENDED_CONFIG_AD_CONFIGURATION_AD_RAC_NAME_FIELD_MASK                      0x0010
#define IPMI_OEM_DELL_EXTENDED_CONFIG_AD_CONFIGURATION_AD_TYPE_FIELD_MASK                          0x0020
#define IPMI_OEM_DELL_EXTENDED_CONFIG_AD_CONFIGURATION_SCL_STATE_FIELD_MASK                        0x0040
#define IPMI_OEM_DELL_EXTENDED_CONFIG_AD_CONFIGURATION_CRL_STATE_FIELD_MASK                        0x0080
#define IPMI_OEM_DELL_EXTENDED_CONFIG_AD_CONFIGURATION_AD_SSO_ENABLE_FIELD_MASK                    0x0100
#define IPMI_OEM_DELL_EXTENDED_CONFIG_AD_CONFIGURATION_AD_DC_FILTER1_FIELD_MASK                    0x0200
#define IPMI_OEM_DELL_EXTENDED_CONFIG_AD_CONFIGURATION_AD_DC_FILTER2_FIELD_MASK                    0x0400
#define IPMI_OEM_DELL_EXTENDED_CONFIG_AD_CONFIGURATION_AD_DC_FILTER3_FIELD_MASK                    0x0800
#define IPMI_OEM_DELL_EXTENDED_CONFIG_AD_CONFIGURATION_AD_GC_FILTER1_FIELD_MASK                    0x1000
#define IPMI_OEM_DELL_EXTENDED_CONFIG_AD_CONFIGURATION_AD_GC_FILTER2_FIELD_MASK                    0x2000
#define IPMI_OEM_DELL_EXTENDED_CONFIG_AD_CONFIGURATION_AD_GC_FILTER3_FIELD_MASK                    0x4000
#define IPMI_OEM_DELL_EXTENDED_CONFIG_AD_CONFIGURATION_AD_CERTIFICATE_VALIDATION_ENABLE_FIELD_MASK 0x8000

#define IPMI_OEM_DELL_EXTENDED_CONFIG_AD_CONFIGURATION_ALL_FIELD_MASK   \
  (IPMI_OEM_DELL_EXTENDED_CONFIG_AD_CONFIGURATION_AD_ENABLE_FIELD_MASK  \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_AD_CONFIGURATION_AD_TIMEOUT_FIELD_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_AD_CONFIGURATION_AD_ROOT_DOMAIN_FIELD_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_AD_CONFIGURATION_AD_RAC_DOMAIN_FIELD_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_AD_CONFIGURATION_AD_RAC_NAME_FIELD_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_AD_CONFIGURATION_AD_TYPE_FIELD_MASK  \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_AD_CONFIGURATION_SCL_STATE_FIELD_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_AD_CONFIGURATION_CRL_STATE_FIELD_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_AD_CONFIGURATION_AD_SSO_ENABLE_FIELD_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_AD_CONFIGURATION_AD_DC_FILTER1_FIELD_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_AD_CONFIGURATION_AD_DC_FILTER2_FIELD_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_AD_CONFIGURATION_AD_DC_FILTER3_FIELD_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_AD_CONFIGURATION_AD_GC_FILTER1_FIELD_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_AD_CONFIGURATION_AD_GC_FILTER2_FIELD_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_AD_CONFIGURATION_AD_GC_FILTER3_FIELD_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_AD_CONFIGURATION_AD_CERTIFICATE_VALIDATION_ENABLE_FIELD_MASK)

#define IPMI_OEM_DELL_EXTENDED_CONFIG_AD_CONFIGURATION_TYPE_EXTENDED 1
#define IPMI_OEM_DELL_EXTENDED_CONFIG_AD_CONFIGURATION_TYPE_STANDARD 2

/* w/ IPMI_OEM_DELL_TOKEN_ID_EMAIL_ALERT_CONFIGURATION
 *
 * indexed 1-4
 *
 * email alert enable - boolean
 * email address string length - uint8
 * email address string - 0-63
 * email alert custon message string length - uint8
 * email alert custom message string - 0-31
 */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_EMAIL_ALERT_CONFIGURATION_EMAIL_ALERT_ENABLE_MASK     0x0001
#define IPMI_OEM_DELL_EXTENDED_CONFIG_EMAIL_ALERT_CONFIGURATION_EMAIL_ADDRESS_MASK          0x0002
#define IPMI_OEM_DELL_EXTENDED_CONFIG_EMAIL_ALERT_CONFIGURATION_EMAIL_ALERT_CUSTOM_MSG_MASK 0x0004

#define IPMI_OEM_DELL_EXTENDED_CONFIG_EMAIL_ALERT_CONFIGURATION_ALL_FIELD_MASK \
  (IPMI_OEM_DELL_EXTENDED_CONFIG_EMAIL_ALERT_CONFIGURATION_EMAIL_ALERT_ENABLE \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_EMAIL_ALERT_CONFIGURATION_EMAIL_ADDRESS \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_EMAIL_ALERT_CONFIGURATION_EMAIL_ALERT_CUSTOM_MSG)

/* w/ IPMI_OEM_DELL_TOKEN_ID_SSL_CONFIGURATION
 *
 * csr key size - uint32
 * csr common name string length - uint8
 * csr comomn name string - 0-255
 * csr organization name string length - uint8
 * csr organization name string - 0-255
 * csr organization unit string length - uint8
 * csr organization unit string - 0-255
 * csr locality name string length - uint8
 * csr locality name string - 0-255 
 * csr state name string length - uint8
 * csr state name string - 0-255
 * csr country code string length - uint8
 * csr country code string - 0-4 
 * csr email address string length - uint8
 * csr email address string - 0-255
 * csr data set type - uint8
 */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_SSL_CONFIGURATION_CSR_KEY_SIZE_MASK             0x0001
#define IPMI_OEM_DELL_EXTENDED_CONFIG_SSL_CONFIGURATION_CSR_COMMON_NAME_MASK          0x0002
#define IPMI_OEM_DELL_EXTENDED_CONFIG_SSL_CONFIGURATION_CSR_ORGANIZATION_NAME_MASK    0x0004
#define IPMI_OEM_DELL_EXTENDED_CONFIG_SSL_CONFIGURATION_CSR_ORGANIZATION_UNIT_MASK    0x0008
#define IPMI_OEM_DELL_EXTENDED_CONFIG_SSL_CONFIGURATION_CSR_LOCALITY_NAME_MASK        0x0010
#define IPMI_OEM_DELL_EXTENDED_CONFIG_SSL_CONFIGURATION_CSR_STATE_NAME_MASK           0x0020
#define IPMI_OEM_DELL_EXTENDED_CONFIG_SSL_CONFIGURATION_CSR_COUNTRY_CODE_MASK         0x0040
#define IPMI_OEM_DELL_EXTENDED_CONFIG_SSL_CONFIGURATION_CSR_EMAIL_ADDRESS_MASK        0x0080
#define IPMI_OEM_DELL_EXTENDED_CONFIG_SSL_CONFIGURATION_CSR_DATA_SET_TYPE_MASK        0x0100

#define IPMI_OEM_DELL_EXTENDED_CONFIG_SSL_CONFIGURATION_ALL_FIELD_MASK \
  (IPMI_OEM_DELL_EXTENDED_CONFIG_SSL_CONFIGURATION_CSR_KEY_SIZE_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_SSL_CONFIGURATION_CSR_COMMON_NAME_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_SSL_CONFIGURATION_CSR_ORGANIZATION_NAME_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_SSL_CONFIGURATION_CSR_ORGANIZATION_UNIT_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_SSL_CONFIGURATION_CSR_LOCALITY_NAME_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_SSL_CONFIGURATION_CSR_STATE_NAME_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_SSL_CONFIGURATION_CSR_COUNTRY_CODE_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_SSL_CONFIGURATION_CSR_EMAIL_ADDRESS_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_SSL_CONFIGURATION_CSR_DATA_SET_TYPE_MASK)

/* w/ IPMI_OEM_DELL_TOKEN_ID_SSH_CONFIGURATION
 *
 * ssh enable - boolean
 * max connections - uint8 (read only)
 * active connections - uint8 (read only)
 * idle timeout - uint32
 * port number - uint16
 */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_SSH_CONFIGURATION_ENABLE_FIELD_MASK             0x0001
#define IPMI_OEM_DELL_EXTENDED_CONFIG_SSH_CONFIGURATION_MAX_CONNECTIONS_FIELD_MASK    0x0002
#define IPMI_OEM_DELL_EXTENDED_CONFIG_SSH_CONFIGURATION_ACTIVE_CONNECTIONS_FIELD_MASK 0x0004
#define IPMI_OEM_DELL_EXTENDED_CONFIG_SSH_CONFIGURATION_IDLE_TIMEOUT_FIELD_MASK       0x0008
#define IPMI_OEM_DELL_EXTENDED_CONFIG_SSH_CONFIGURATION_PORT_NUMBER_FIELD_MASK        0x0010

#define IPMI_OEM_DELL_EXTENDED_CONFIG_SSH_CONFIGURATION_ALL_FIELD_MASK  \
  (IPMI_OEM_DELL_EXTENDED_CONFIG_SSH_CONFIGURATION_ENABLE_FIELD_MASK    \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_SSH_CONFIGURATION_MAX_CONNECTIONS_FIELD_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_SSH_CONFIGURATION_ACTIVE_CONNECTIONS_FIELD_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_SSH_CONFIGURATION_IDLE_TIMEOUT_FIELD_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_SSH_CONFIGURATION_PORT_NUMBER_FIELD_MASK)

/* w/ IPMI_OEM_DELL_TOKEN_ID_TELNET_CONFIGURATION
 *
 * ssh enable - boolean
 * max session - uint8 (read only)
 * active session - uint8 (read only)
 * session timeout - uint32
 * port number - uint16
 * 7fls backspace - boolean
 */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_TELNET_CONFIGURATION_ENABLE_FIELD_MASK          0x0001
#define IPMI_OEM_DELL_EXTENDED_CONFIG_TELNET_CONFIGURATION_MAX_SESSIONS_FIELD_MASK    0x0002
#define IPMI_OEM_DELL_EXTENDED_CONFIG_TELNET_CONFIGURATION_ACTIVE_SESSIONS_FIELD_MASK 0x0004
#define IPMI_OEM_DELL_EXTENDED_CONFIG_TELNET_CONFIGURATION_SESSION_TIMEOUT_FIELD_MASK 0x0008
#define IPMI_OEM_DELL_EXTENDED_CONFIG_TELNET_CONFIGURATION_PORT_NUMBER_FIELD_MASK     0x0010
#define IPMI_OEM_DELL_EXTENDED_CONFIG_TELNET_CONFIGURATION_7FLS_BACKSPACE_FIELD_MASK  0x0020

#define IPMI_OEM_DELL_EXTENDED_CONFIG_TELNET_CONFIGURATION_ALL_FIELD_MASK \
  (IPMI_OEM_DELL_EXTENDED_CONFIG_TELNET_CONFIGURATION_ENABLE_FIELD_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_TELNET_CONFIGURATION_MAX_SESSIONS_FIELD_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_TELNET_CONFIGURATION_ACTIVE_SESSIONS_FIELD_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_TELNET_CONFIGURATION_SESSION_TIMEOUT_FIELD_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_TELNET_CONFIGURATION_PORT_NUMBER_FIELD_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_TELNET_CONFIGURATION_7FLS_BACKSPACE_FIELD_MASK)

/* w/ IPMI_OEM_DELL_TOKEN_ID_WEB_SERVER_CONFIGURATION 
 *
 * web server enable - boolean
 * max sessions - uint8 (read only)
 * active session - uint8 (read only)
 * session timeout - uint32
 * http port num - uint16
 * https port num - uint16
 */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_WEB_SERVER_CONFIGURATION_ENABLE_FIELD_MASK            0x0001
#define IPMI_OEM_DELL_EXTENDED_CONFIG_WEB_SERVER_CONFIGURATION_MAX_SESSIONS_FIELD_MASK      0x0002
#define IPMI_OEM_DELL_EXTENDED_CONFIG_WEB_SERVER_CONFIGURATION_ACTIVE_SESSIONS_FIELD_MASK   0x0004
#define IPMI_OEM_DELL_EXTENDED_CONFIG_WEB_SERVER_CONFIGURATION_SESSION_TIMEOUT_FIELD_MASK   0x0008
#define IPMI_OEM_DELL_EXTENDED_CONFIG_WEB_SERVER_CONFIGURATION_HTTP_PORT_NUMBER_FIELD_MASK  0x0010
#define IPMI_OEM_DELL_EXTENDED_CONFIG_WEB_SERVER_CONFIGURATION_HTTPS_PORT_NUMBER_FIELD_MASK 0x0020

#define IPMI_OEM_DELL_EXTENDED_CONFIG_WEB_SERVER_CONFIGURATION_ALL_FIELD_MASK \
  (IPMI_OEM_DELL_EXTENDED_CONFIG_WEB_SERVER_CONFIGURATION_ENABLE_FIELD_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_WEB_SERVER_CONFIGURATION_MAX_SESSIONS_FIELD_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_WEB_SERVER_CONFIGURATION_ACTIVE_SESSIONS_FIELD_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_WEB_SERVER_CONFIGURATION_SESSION_TIMEOUT_FIELD_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_WEB_SERVER_CONFIGURATION_HTTP_PORT_NUMBER_FIELD_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_WEB_SERVER_CONFIGURATION_HTTPS_PORT_NUMBER_FIELD_MASK)

/* w/ IPMI_OEM_DELL_TOKEN_ID_CR_CONFIGURATION
 *
 * CR enable - boolean
 * max sessions - uint8
 * active sessions - uint8
 * km portnum - uint16
 * cr encryption - boolean
 * asr enable - boolean
 * video portnum - uint16
 * local server video - boolean
 * ie console use java - boolean
 * authorize multiple sessions - uint8 (drac5 only)
 */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_CR_CONFIGURATION_CR_ENABLE_MASK                   0x0001
#define IPMI_OEM_DELL_EXTENDED_CONFIG_CR_CONFIGURATION_MAX_SESSIONS_MASK                0x0002
#define IPMI_OEM_DELL_EXTENDED_CONFIG_CR_CONFIGURATION_ACTIVE_SESSIONS_MASK             0x0004
#define IPMI_OEM_DELL_EXTENDED_CONFIG_CR_CONFIGURATION_KM_PORT_NUMBER_MASK              0x0008
#define IPMI_OEM_DELL_EXTENDED_CONFIG_CR_CONFIGURATION_CR_ENCRYPTION_MASK               0x0010
#define IPMI_OEM_DELL_EXTENDED_CONFIG_CR_CONFIGURATION_ASR_ENABLE_MASK                  0x0020
#define IPMI_OEM_DELL_EXTENDED_CONFIG_CR_CONFIGURATION_VIDEO_PORT_NUMBER_MASK           0x0040
#define IPMI_OEM_DELL_EXTENDED_CONFIG_CR_CONFIGURATION_LOCAL_SERVER_VIDEO_MASK          0x0080
#define IPMI_OEM_DELL_EXTENDED_CONFIG_CR_CONFIGURATION_IE_CONSOLE_USE_JAVA_MASK         0x0100
#define IPMI_OEM_DELL_EXTENDED_CONFIG_CR_CONFIGURATION_AUTHORIZE_MULTIPLE_SESSIONS_MASK 0x0200

#define IPMI_OEM_DELL_EXTENDED_CONFIG_CR_CONFIGURATION_ALL_FIELD_MASK \
  (IPMI_OEM_DELL_EXTENDED_CONFIG_CR_CONFIGURATION_CR_ENABLE_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_CR_CONFIGURATION_MAX_SESSIONS_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_CR_CONFIGURATION_ACTIVE_SESSIONS_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_CR_CONFIGURATION_KM_PORT_NUMBER_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_CR_CONFIGURATION_CR_ENCRYPTION_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_CR_CONFIGURATION_ASR_ENABLE_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_CR_CONFIGURATION_VIDEO_PORT_NUMBER_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_CR_CONFIGURATION_LOCAL_SERVER_VIDEO_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_CR_CONFIGURATION_IE_CONSOLE_USE_JAVA_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_CR_CONFIGURATION_AUTHORIZE_MULTIPLE_SESSIONS_MASK)
  
/* w/ IPMI_OEM_DELL_TOKEN_ID_VM_CONFIGURATION
 *
 * vm enable - uint8 (achu: boolean??)
 * max sessions - uint8
 * active sessions - uint8
 * portnum - uint16
 * vm key enable - boolean
 * ssl port num - uint16
 * vm image type - uint8
 * vm image path string length - uint8
 * vm image path string - 0-255
 * vm image filename string length - uint8
 * vm image filename string - 0-255
 * vm auto-eject enable - boolean
 * vm floppy emul - boolean
 * sd card read write status - boolean (read only) 
 */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_VM_CONFIGURATION_VM_ENABLE_MASK                 0x0001
#define IPMI_OEM_DELL_EXTENDED_CONFIG_VM_CONFIGURATION_MAX_SESSIONS_MASK              0x0002
#define IPMI_OEM_DELL_EXTENDED_CONFIG_VM_CONFIGURATION_ACTIVE_SESSIONS_MASK           0x0004
#define IPMI_OEM_DELL_EXTENDED_CONFIG_VM_CONFIGURATION_PORT_NUMBER_MASK               0x0008
#define IPMI_OEM_DELL_EXTENDED_CONFIG_VM_CONFIGURATION_VM_KEY_ENABLE_MASK             0x0010
#define IPMI_OEM_DELL_EXTENDED_CONFIG_VM_CONFIGURATION_SSL_PORT_NUMBER_MASK           0x0020
#define IPMI_OEM_DELL_EXTENDED_CONFIG_VM_CONFIGURATION_VM_IMAGE_TYPE_MASK             0x0040
#define IPMI_OEM_DELL_EXTENDED_CONFIG_VM_CONFIGURATION_VM_IMAGE_PATH_MASK             0x0080
#define IPMI_OEM_DELL_EXTENDED_CONFIG_VM_CONFIGURATION_VM_IMAGE_FILENAME_MASK         0x0100
#define IPMI_OEM_DELL_EXTENDED_CONFIG_VM_CONFIGURATION_VM_AUTO_EJECT_ENABLE_MASK      0x0200
#define IPMI_OEM_DELL_EXTENDED_CONFIG_VM_CONFIGURATION_VM_FLOPPY_EMUL_MASK            0x0400
#define IPMI_OEM_DELL_EXTENDED_CONFIG_VM_CONFIGURATION_SD_CARD_READ_WRITE_STATUS_MASK 0x0800

#define IPMI_OEM_DELL_EXTENDED_CONFIG_VM_CONFIGURATION_ALL_FIELD_MASK \
  (IPMI_OEM_DELL_EXTENDED_CONFIG_VM_CONFIGURATION_VM_ENABLE_MASK      \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_VM_CONFIGURATION_MAX_SESSIONS_MASK	\
   | IPMI_OEM_DELL_EXTENDED_CONFIG_VM_CONFIGURATION_ACTIVE_SESSIONS_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_VM_CONFIGURATION_PORT_NUMBER_MASK	\
   | IPMI_OEM_DELL_EXTENDED_CONFIG_VM_CONFIGURATION_VM_KEY_ENABLE_MASK	\
   | IPMI_OEM_DELL_EXTENDED_CONFIG_VM_CONFIGURATION_SSL_PORT_NUMBER_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_VM_CONFIGURATION_VM_IMAGE_TYPE_MASK	\
   | IPMI_OEM_DELL_EXTENDED_CONFIG_VM_CONFIGURATION_VM_IMAGE_PATH_MASK	\
   | IPMI_OEM_DELL_EXTENDED_CONFIG_VM_CONFIGURATION_VM_IMAGE_FILENAME_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_VM_CONFIGURATION_VM_AUTO_EJECT_ENABLE_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_VM_CONFIGURATION_VM_FLOPPY_EMUL_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_VM_CONFIGURATION_SD_CARD_READ_WRITE_STATUS_MASK)

/* w/ IPMI_OEM_DELL_TOKEN_ID_RAC_INFO
 *
 * rac name string length - uint8
 * rac name string - 0-31
 * rac description string length - uint8
 * rac description string - 0-255
 * rac type string length - uint8
 * rac type string - 1-10
 * rac product info string length - uint8
 * rac product info string - 0-63
 * rac hw version string length - uint8
 * rac hw version string - 0-10
 */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_INFO_RAC_NAME_MASK         0x0001
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_INFO_RAC_DESCRIPTION_MASK  0x0002
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_INFO_RAC_TYPE_MASK         0x0004
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_INFO_RAC_PRODUCT_INFO_MASK 0x0008
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_INFO_RAC_HW_VERSION_MASK   0x0010

#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_INFO_ALL_FIELD_MASK \
  (IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_INFO_RAC_NAME_MASK	\
   | IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_INFO_RAC_DESCRIPTION_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_INFO_RAC_TYPE_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_INFO_RAC_PRODUCT_INFO_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_INFO_RAC_HW_VERSION_MASK)

/* w/ IPMI_OEM_DELL_TOKEN_ID_RAC_FW_UPDATE
 *
 * version string length - uint8
 * version string - 0-16
 * build number string length - uint8
 * build number string - 0-131
 * tftp fw update enable - boolean
 * tftp fw update ip address - uint8 * 4
 * tftp fw update path string length - uint8
 * tftp fw update path string - 0-255
 * last fw update time string length - uint8
 * last fw update time string - 0-32
 * tftp server address string length - uint8
 * tftp server address string - 0-39
 */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_FW_UPDATE_VERSION_MASK                   0x0001
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_FW_UPDATE_BUILD_NUMBER_MASK              0x0002
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_FW_UPDATE_TFTP_FW_UPDATE_ENABLE_MASK     0x0004
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_FW_UPDATE_TFTP_FW_UPDATE_IP_ADDRESS_MASK 0x0008
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_FW_UPDATE_TFTP_FW_UPDATE_PATH_MASK       0x0010
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_FW_UPDATE_LAST_FW_UPDATE_PATH_MASK       0x0020
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_FW_UPDATE_TFTP_SERVER_ADDRESS_MASK       0x0040

#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_FW_UPDATE_ALL_FIELD_MASK \
  (IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_FW_UPDATE_VERSION_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_FW_UPDATE_BUILD_NUMBER_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_FW_UPDATE_TFTP_FW_UPDATE_ENABLE_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_FW_UPDATE_TFTP_FW_UPDATE_IP_ADDRESS_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_FW_UPDATE_TFTP_FW_UPDATE_PATH_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_FW_UPDATE_LAST_FW_UPDATE_PATH_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_FW_UPDATE_TFTP_SERVER_ADDRESS_MASK)

/* w/ IPMI_OEM_DELL_TOKEN_ID_RAC_SERIAL_SHELL
 *
 * enable - boolean
 * shell type - uint8
 * com2 redirect enable - boolean
 * sessions timeout - uint32
 * baud rate - uint32
 * console no auth - boolean
 * escape key string length - uint8
 * escape key string - 0-31
 * history buffer size - uint32
 * login cmd string length - uint8 (achu: doc says uint32, doubt it)
 * login cmd string - 0-128
 */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SERIAL_SHELL_ENABLE_MASK               0x0001
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SERIAL_SHELL_SHELL_TYPE_MASK           0x0002
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SERIAL_SHELL_COM2_REDIRECT_ENABLE_MASK 0x0004
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SERIAL_SHELL_SESSION_TIMEOUT_MASK      0x0008
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SERIAL_SHELL_BAUD_RATE_MASK            0x0010
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SERIAL_SHELL_CONSOLE_NO_AUTH_MASK      0x0020
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SERIAL_SHELL_ESCAPE_KEY_MASK           0x0040
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SERIAL_SHELL_HISTORY_BUFFER_SIZE_MASK  0x0080
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SERIAL_SHELL_LOGIN_CMD_MASK            0x0100

#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SERIAL_SHELL_ALL_FIELD_MASK \
  (IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SERIAL_SHELL_ENABLE_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SERIAL_SHELL_SHELL_TYPE_MASK	\
   | IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SERIAL_SHELL_COM2_REDIRECT_ENABLE_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SERIAL_SHELL_SESSION_TIMEOUT_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SERIAL_SHELL_BAUD_RATE_MASK	\
   | IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SERIAL_SHELL_CONSOLE_NO_AUTH_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SERIAL_SHELL_ESCAPE_KEY_MASK	\
   | IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SERIAL_SHELL_HISTORY_BUFFER_SIZE_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SERIAL_SHELL_LOGIN_CMD_MASK)

/* w/ IPMI_OEM_DELL_TOKEN_ID_MISC
 *
 * remote racadm enable - boolean
 * smtp sever ip address - uint8 * 4 (obsolete) 
 * remote racadm max sessions - uint8
 * remote racadm session timeout - uint32
 * smtp server ipv4/ipv6/dns address string length
 * smtp server ipv4/ipv6/dns address string - 0-255
 * smtp alerting source email name string length - uint8
 * smtp alerting source email name string - 0-255
 * lc drive enable - boolean
 */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_MISC_REMOTE_RACADM_ENABLE_MASK            0x0001
#define IPMI_OEM_DELL_EXTENDED_CONFIG_MISC_SMTP_SERVER_IP_ADDRESS_MASK          0x0002
#define IPMI_OEM_DELL_EXTENDED_CONFIG_MISC_REMOTE_RACADM_MAX_SESSIONS_MASK      0x0004
#define IPMI_OEM_DELL_EXTENDED_CONFIG_MISC_REMOTE_RACADM_SESSION_TIMEOUT_MASK   0x0008
#define IPMI_OEM_DELL_EXTENDED_CONFIG_MISC_SMTP_SERVER_ADDRESS_MASK             0x0010
#define IPMI_OEM_DELL_EXTENDED_CONFIG_MISC_SMTP_ALERTING_SOURCE_EMAIL_NAME_MASK 0x0020
#define IPMI_OEM_DELL_EXTENDED_CONFIG_MISC_LC_DRIVE_ENABLE                      0x0040

#define IPMI_OEM_DELL_EXTENDED_CONFIG_MISC_ALL_FIELD_MASK \
  (IPMI_OEM_DELL_EXTENDED_CONFIG_MISC_REMOTE_RACADM_ENABLE_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_MISC_SMTP_SERVER_IP_ADDRESS_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_MISC_REMOTE_RACADM_MAX_SESSIONS_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_MISC_REMOTE_RACADM_SESSION_TIMEOUT_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_MISC_SMTP_SERVER_ADDRESS_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_MISC_SMTP_ALERTING_SOURCE_EMAIL_NAME_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_MISC_LC_DRIVE_ENABLE)

/* w/ IPMI_OEM_DELL_TOKEN_ID_OOB_SECURITY
 *
 * enforced client ip enable - boolean
 * enforced client ip address - uint8 * 4
 * enforced client ip mask - uint8 * 4
 * enforced ip block enable - boolean
 * enforced ip block failure count - uint8
 * enforce dip block failure window - uint32
 * enforced ip block penalty time - uint32
 */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_OOB_SECURITY_ENFORCED_CLIENT_IP_ENABLE_MASK        0x0001
#define IPMI_OEM_DELL_EXTENDED_CONFIG_OOB_SECURITY_ENFORCED_CLIENT_IP_ADDRESS_MASK       0x0002
#define IPMI_OEM_DELL_EXTENDED_CONFIG_OOB_SECURITY_ENFORCED_CLIENT_IP_MASK_MASK          0x0004
#define IPMI_OEM_DELL_EXTENDED_CONFIG_OOB_SECURITY_ENFORCED_IP_BLOCK_ENABLE_MASK         0x0008
#define IPMI_OEM_DELL_EXTENDED_CONFIG_OOB_SECURITY_ENFORCED_IP_BLOCK_FAILURE_COUNT_MASK  0x0010
#define IPMI_OEM_DELL_EXTENDED_CONFIG_OOB_SECURITY_ENFORCED_IP_BLOCK_FAILURE_WINDOW_MASK 0x0020
#define IPMI_OEM_DELL_EXTENDED_CONFIG_OOB_SECURITY_ENFORCED_IP_BLOCK_PENALTY_TIME_MASK   0x0040

#define IPMI_OEM_DELL_EXTENDED_CONFIG_OOB_SECURITY_ALL_FIELD_MASK \
  (IPMI_OEM_DELL_EXTENDED_CONFIG_OOB_SECURITY_ENFORCED_CLIENT_IP_ENABLE_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_OOB_SECURITY_ENFORCED_CLIENT_IP_ADDRESS_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_OOB_SECURITY_ENFORCED_CLIENT_IP_MASK_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_OOB_SECURITY_ENFORCED_IP_BLOCK_ENABLE_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_OOB_SECURITY_ENFORCED_IP_BLOCK_FAILURE_COUNT_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_OOB_SECURITY_ENFORCED_IP_BLOCK_FAILURE_WINDOW_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_OOB_SECURITY_ENFORCED_IP_BLOCK_PENALTY_TIME_MASK)

/* w/ IPMI_OEM_DELL_TOKEN_ID_RAC_CONTROL
 *
 * indexed ?-?
 *
 * control command - uint8
 */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_CONTROL_CONTROL_COMMAND_MASK 0x0001

#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_CONTROL_ALL_FIELD_MASK \
  (IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_CONTROL_CONTROL_COMMAND_MASK)

#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_CONTROL_CONTROL_COMMAND_RAC_HARD_RESET                               1
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_CONTROL_CONTROL_COMMAND_RAC_SOFT_RESET                               2
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_CONTROL_CONTROL_COMMAND_RAC_GRACEFUL_RESET                           3
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_CONTROL_CONTROL_COMMAND_RAC_RESET_CONFIG_TO_DEFAULT                  4
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_CONTROL_CONTROL_COMMAND_RAC_CLEAR_RACLOG                             5
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_CONTROL_CONTROL_COMMAND_RAC_CLEAR_COREDUMP                           6
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_CONTROL_CONTROL_COMMAND_RAC_START_FIRMWARE_UPDATE_PHASE1             7
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_CONTROL_CONTROL_COMMAND_RAC_START_FIRMWARE_UPDATE_PHASE2             8
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_CONTROL_CONTROL_COMMAND_RAC_TEST_EMAIL_ALERT                         9
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_CONTROL_CONTROL_COMMAND_RAC_GENERATES_CSR                           10
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_CONTROL_CONTROL_COMMAND_RAC_CLEAR_ASR_SCREEN                        11
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_CONTROL_CONTROL_COMMAND_RAC_VM_DISCONNECT                           12
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_CONTROL_CONTROL_COMMAND_RAC_RESET_RAC_CONFIG                        13
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_CONTROL_CONTROL_COMMAND_RAC_START_TFTP_FWUPDATE                     14
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_CONTROL_CONTROL_COMMAND_RAC_RESET_VM_KEYSIZE                        15
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_CONTROL_CONTROL_COMMAND_RAC_GENERATES_KMC_SELF_ASSIGNED_CERTIFICATE 16
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_CONTROL_CONTROL_COMMAND_RAC_GENERATES_KMC_CSR                       17
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_CONTROL_CONTROL_COMMAND_RAC_RESET_SSL_CERTIFICATE                   18

/* w/ IPMI_OEM_DELL_TOKEN_ID_RAC_LOG_FILES
 *
 * data - uint8
 */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_LOG_FILES_DATA_MASK 0x0001

#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_LOG_FILES_ALL_FIELD_MASK \
  (IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_LOG_FILES_DATA_MASK)

#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_LOG_FILES_RACLOG_FILE   1
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_LOG_FILES_COREDUMP_FILE 2
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_LOG_FILES_TRACELOG_FILE 3

/* w/ IPMI_OEM_DELL_TOKEN_ID_RAC_CERTIFICATE_FILES
 *
 * indexed ?-?
 *
 * data - uint8
 */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_CERTIFICATE_FILES_DATA_MASK 0x0001

#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_CERTIFICATE_FILES_ALL_FIELD_MASK \
  (IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_CERTIFICATE_FILES_DATA_MASK)

#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_CERTIFICATE_FILES_SERVER_CERTIFICATE_FILE                             1 /* r/w */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_CERTIFICATE_FILES_CA_CERTIFICATE_FILE                                 2 /* r/w */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_CERTIFICATE_FILES_CSR_FILE                                            3 /* r */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_CERTIFICATE_FILES_CSR_STATUS                                          4 /* r */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_CERTIFICATE_FILES_SERVER_CERTIFICATE_FORMATTED_VIEW                   5 /* r */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_CERTIFICATE_FILES_CA_CERTIFICATE_FORMATTED_VIEW                       6 /* r */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_CERTIFICATE_FILES_CA_CERTIFICATE_FILE_FOR_GENERIC_LDAP                7 /* r/w */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_CERTIFICATE_FILES_CA_CERTIFICATE_FILE_FOR_GENERIC_LDAP_FORMATTED_VIEW 8 /* r */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_CERTIFICATE_FILES_KERBEROS_KEYTAB_UPLOAD                              9 /* r */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_CERTIFICATE_FILES_KMS_SERVER_CERTIFICATE                              10 /* r/w */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_CERTIFICATE_FILES_KMS_CA_SERVER_CERTIFICATE                           11 /* r/w */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_CERTIFICATE_FILES_KMS_SERVER_CERTIFICATE_FORMATTED_VIEW               12 /* r */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_CERTIFICATE_FILES_KMS_CA_CERTIFICATE_FORMATTED_VIEW                   13 /* r */

/* w/ IPMI_OEM_DELL_TOKEN_ID_RAC_SESSION_INFO
 *
 * login time - uint32
 * client ipv4 - uint8 * 4
 * associated console - uint8
 * login user id string length - uint8
 * login user id string - 0-255
 * client ipv6/ipv4 address string length - uint8
 * client ipv5/ipv4 address string - 0-39
 * session id uint16
 */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SESSION_INFO_SESSION_TYPE_MASK       0x0001
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SESSION_INFO_LOGIN_TIME_MASK         0x0002
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SESSION_INFO_CLIENT_IPV4_MASK        0x0004
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SESSION_INFO_ASSOCIATED_CONSOLE_MASK 0x0008
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SESSION_INFO_LOGIN_USER_ID_MASK      0x0010
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SESSION_INFO_CLIENT_IP_ADDRESS_MASK  0x0020
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SESSION_INFO_SESSION_ID_MASK         0x0040

#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SESSION_INFO_ALL_FIELD_MASK \
  (IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SESSION_INFO_SESSION_TYPE_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SESSION_INFO_LOGIN_TIME_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SESSION_INFO_CLIENT_IPV4_MASK	\
   | IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SESSION_INFO_ASSOCIATED_CONSOLE_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SESSION_INFO_LOGIN_USER_ID_MASK	\
   | IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SESSION_INFO_CLIENT_IP_ADDRESS_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SESSION_INFO_SESSION_ID_MASK)

/* w/ IPMI_OEM_DELL_TOKEN_ID_RAC_TIME
 *
 * time zone - int32 (minutes west of greenwich)
 * daylight saving - uint8 (adjust minutes)
 */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_TIME_TIME_ZONE_MASK       0x0001
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_TIME_DAYLIGHT_SAVING_MASK 0x0002

#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_TIME_ALL_FIELD_MASK \
  (IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_TIME_TIME_ZONE_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_TIME_DAYLIGHT_SAVING_MASK)

/* w/ IPMI_OEM_DELL_TOKEN_ID_RAC_SSAD_CONFIGURATION
 *
 * ssad role group name string length - uint8
 * ssad role group name string - 0-255
 * ssad role group domain string length - uint8
 * ssad role group domain string - 0-255
 * ssad role group privilege - uint32
 */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SSAD_CONFIGURATION_SSAD_ROLE_GROUP_NAME_MASK      0x0001
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SSAD_CONFIGURATION_SSAD_ROLE_GROUP_DOMAIN_MASK    0x0002
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SSAD_CONFIGURATION_SSAD_ROLE_GROUP_PRIVILEGE_MASK 0x0004

#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SSAD_CONFIGURATION_ALL_FIELD_MASK \
  (IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SSAD_CONFIGURATION_SSAD_ROLE_GROUP_NAME_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SSAD_CONFIGURATION_SSAD_ROLE_GROUP_DOMAIN_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_SSAD_CONFIGURATION_SSAD_ROLE_GROUP_PRIVILEGE_MASK)

/* w/ IPMI_OEM_DELL_TOKEN_ID_RAC_USER_CERT_FILES
 *
 * data - uint8
 */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_USER_CERT_FILES_DATA_MASK 0x0001

#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_USER_CERT_FILES_ALL_FIELD_MASK \
  (IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_USER_CERT_FILES_DATA_MASK)

#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_USER_CERT_FILES_SERVER_CERTIFICATE_FILE 1 /* r/w */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_USER_CERT_FILES_CA_CERTIFICATE_FILE     2 /* r/w */
/* w/ IPMI_OEM_DELL_TOKEN_ID_RAC_LOCAL_CONFIGURATION
 *
 * bbb config disable - boolean
 * local config disable - boolean
 */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_LOCAL_CONFIGURATION_BBB_CONFIG_DISABLE_MASK   0x0001
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_LOCAL_CONFIGURATION_LOCAL_CONFIG_DISABLE_MASK 0x0002

#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_LOCAL_CONFIGURATION_ALL_FIELD_MASK \
  (IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_LOCAL_CONFIGURATION_BBB_CONFIG_DISABLE_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_LOCAL_CONFIGURATION_LOCAL_CONFIG_DISABLE_MASK)

/* w/ IPMI_OEM_DELL_TOKEN_ID_RAC_VKVM_CONFIGURATION
 *
 * cr local consred disable - boolean
 * cr post consred disable - boolean
 */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_VKVM_CONFIGURATION_CR_LOCAL_CONSRED_DISABLE_MASK 0x0001
#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_VKVM_CONFIGURATION_CR_POST_CONSRED_DISABLE_MASK  0x0002

#define IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_VKVM_CONFIGURATION_ALL_FIELD_MASK \
  (IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_VKVM_CONFIGURATION_CR_LOCAL_CONSRED_DISABLE_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_RAC_VKVM_CONFIGURATION_CR_POST_CONSRED_DISABLE_MASK)

/* w/ IPMI_OEM_DELL_TOKEN_ID_IPV6_EXTENDED_GROUP
 *
 * ipv6 enable - boolean
 * ipv6 addr string length - uint8
 * ipv6 addr string - 0-39
 * ipv6 gateway ip string length - uint8
 * ipv6 gateway ip string - 0-39
 * ipv6 prefix lenth - uint8
 * ipv6 auto config - boolean
 * ipv6 link local addr string length - uint8
 * ipv6 link locl address string - 0-39 (read only)
 * ipv6 addr2 string length - uint8
 * ipv6 addr2 string 0 0-39 (read only)
 * ipv6 auto dns - uin8 (achu: boolean??)
 * ipv6 dns server1 address string length - uint8
 * ipv6 dns server1 address string - 0-39
 * ipv6 dns server2 address string length - uint8
 * ipv6 dns server2 address string - 0-39
 * reserved - uint8
 * ipv6 addr2 prefix length - uint8 (read only)
 * ipv6 link local prefix length - uint8 (read only)
 * reserved - uint8 * 12
 * total number of extended ip - uint8 (read only)
 * ipv6 extended addr X prefix length - uint8 (read only)
 * ipv6 extended addr X string length - uint8 (read only)
 * ipv6 extended addr X string - 0-39
 * 
 * achu: doc says 1-13 extended address possible.  have to use index?
 * unclear.
 */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_EXTENDED_GROUP_IPV6_ENABLE_MASK                           0x0001
#define IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_EXTENDED_GROUP_IPV6_ADDRESS_MASK                          0x0002
#define IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_EXTENDED_GROUP_IPV6_GATEWAYY_IP_ADDRESS_MASK              0x0004
#define IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_EXTENDED_GROUP_IPV6_PREFIX_LENGTH_MASK                    0x0008
#define IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_EXTENDED_GROUP_IPV6_AUTO_CONFIG_MASK                      0x0010
#define IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_EXTENDED_GROUP_IPV6_LINK_LOCAL_ADDRESS_MASK               0x0020
#define IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_EXTENDED_GROUP_IPV6_ADDRESS2_MASK                         0x0040
#define IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_EXTENDED_GROUP_IPV6_AUTO_DNS_MASK                         0x0080
#define IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_EXTENDED_GROUP_IPV6_DNS_SERVER1_ADDRESS_MASK              0x0100
#define IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_EXTENDED_GROUP_IPV6_DNS_SERVER2_ADDRESS_MASK              0x0200
#define IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_EXTENDED_GROUP_IPV6_ADDRESS2_PREFIX_LENGTH_MASK           0x0400
#define IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_EXTENDED_GROUP_IPV6_LINK_LOCAL_PREFIX_LENGTH_MASK         0x0800
#define IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_EXTENDED_GROUP_IPV6_TOTAL_NUMBER_OF_EXTENDED_IP_MASK      0x1000
#define IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_EXTENDED_GROUP_IPV6_EXTENDED_ADDRESS_X_PREFIX_LENGTH_MASK 0x2000
#define IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_EXTENDED_GROUP_IPV6_EXTENDED_ADDRESS_X_MASK               0x4000

#define IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_EXTENDED_GROUP_ALL_FIELD_MASK \
  (IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_EXTENDED_GROUP_IPV6_ENABLE_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_EXTENDED_GROUP_IPV6_ADDRESS_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_EXTENDED_GROUP_IPV6_GATEWAYY_IP_ADDRESS_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_EXTENDED_GROUP_IPV6_PREFIX_LENGTH_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_EXTENDED_GROUP_IPV6_AUTO_CONFIG_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_EXTENDED_GROUP_IPV6_LINK_LOCAL_ADDRESS_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_EXTENDED_GROUP_IPV6_ADDRESS2_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_EXTENDED_GROUP_IPV6_AUTO_DNS_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_EXTENDED_GROUP_IPV6_DNS_SERVER1_ADDRESS_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_EXTENDED_GROUP_IPV6_DNS_SERVER2_ADDRESS_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_EXTENDED_GROUP_IPV6_ADDRESS2_PREFIX_LENGTH_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_EXTENDED_GROUP_IPV6_LINK_LOCAL_PREFIX_LENGTH_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_EXTENDED_GROUP_IPV6_TOTAL_NUMBER_OF_EXTENDED_IP_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_EXTENDED_GROUP_IPV6_EXTENDED_ADDRESS_X_PREFIX_LENGTH_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_EXTENDED_GROUP_IPV6_EXTENDED_ADDRESS_X_MASK)

/* w/ IPMI_OEM_DELL_TOKEN_ID_IPV6_URL_GROUP
 *
 * ldrac ipv6 url string length - uint8
 * ldrac ipv6 url string - 0-80
 */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_URL_GROUP_LDRAC_IPV6_URL_MASK 0x0001 

#define IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_URL_GROUP_ALL_FIELD_MASK \
  (IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_URL_GROUP_LDRAC_IPV6_URL_MASK)

/* w/ IPMI_OEM_DELL_TOKEN_ID_ACTIVE_DIRECTORY_USER_DOMAIN_GROUP
 *
 * indexed 1-40
 *
 * ad user domain name string length - uint8
 * ad user domain name string - 0-255
 */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_ACTIVE_DIRECTORY_USER_DOMAIN_GROUP_AD_USER_DOMAIN_NAME_MASK 0x0001

#define IPMI_OEM_DELL_EXTENDED_CONFIG_ACTIVE_DIRECTORY_USER_DOMAIN_GROUP_ALL_FIELD_MASK \
  (IPMI_OEM_DELL_EXTENDED_CONFIG_ACTIVE_DIRECTORY_USER_DOMAIN_GROUP_AD_USER_DOMAIN_NAME_MASK)

/* w/ IPMI_OEM_DELL_TOKEN_ID_SMART_CARD_GROUP
 *
 * scl state - uint8 (0,1,2)
 * crl state - uint8
 * 
 * used only by ldrac (achu: what is ldrac?)
 */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_SMART_CARD_GROUP_SCL_STATE_MASK 0x0001
#define IPMI_OEM_DELL_EXTENDED_CONFIG_SMART_CARD_GROUP_CRL_STATE_MASK 0x0002

#define IPMI_OEM_DELL_EXTENDED_CONFIG_SMART_CARD_GROUP_ALL_FIELD_MASK \
  (IPMI_OEM_DELL_EXTENDED_CONFIG_SMART_CARD_GROUP_SCL_STATE_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_SMART_CARD_GROUP_CRL_STATE_MASK)

/* w/ IPMI_OEM_DELL_TOKEN_ID_VMEDIA_SHARING_VIA_CMC
 *
 * status - boolean - 0 = disconnect, 1 = connect
 * image type - uint8 - 0 = use file extensions, 1 = floppy, 2 = cd
 * user name string length - uint8
 * user name string - 0-255
 * password string length - uint8
 * password string - 0-255
 * share and image name string length - uint16
 * share and image name string - 0-511
 */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_VMEDIA_SHARING_VIA_CMC_STATUS_MASK               0x0001
#define IPMI_OEM_DELL_EXTENDED_CONFIG_VMEDIA_SHARING_VIA_CMC_IMAGE_TYPE_MASK           0x0002
#define IPMI_OEM_DELL_EXTENDED_CONFIG_VMEDIA_SHARING_VIA_CMC_USER_NAME_MASK            0x0004
#define IPMI_OEM_DELL_EXTENDED_CONFIG_VMEDIA_SHARING_VIA_CMC_PASSWORD_MASK             0x0008
#define IPMI_OEM_DELL_EXTENDED_CONFIG_VMEDIA_SHARING_VIA_CMC_SHARE_AND_IMAGE_NAME_MASK 0x0010

#define IPMI_OEM_DELL_EXTENDED_CONFIG_VMEDIA_SHARING_VIA_CMC_ALL_FIELD_MASK \
  (IPMI_OEM_DELL_EXTENDED_CONFIG_VMEDIA_SHARING_VIA_CMC_STATUS_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_VMEDIA_SHARING_VIA_CMC_IMAGE_TYPE_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_VMEDIA_SHARING_VIA_CMC_USER_NAME_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_VMEDIA_SHARING_VIA_CMC_PASSWORD_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_VMEDIA_SHARING_VIA_CMC_SHARE_AND_IMAGE_NAME_MASK)

#define IPMI_OEM_DELL_EXTENDED_CONFIG_VMEDIA_SHARING_VIA_CMC_STATUS_DISCONNECT 0
#define IPMI_OEM_DELL_EXTENDED_CONFIG_VMEDIA_SHARING_VIA_CMC_STATUS_CONNECT    1

#define IPMI_OEM_DELL_EXTENDED_CONFIG_VMEDIA_SHARING_VIA_CMC_IMAGE_TYPE_USE_FILE_EXTENSIONS 0
#define IPMI_OEM_DELL_EXTENDED_CONFIG_VMEDIA_SHARING_VIA_CMC_IMAGE_TYPE_FLOPPY              1
#define IPMI_OEM_DELL_EXTENDED_CONFIG_VMEDIA_SHARING_VIA_CMC_IMAGE_TYPE_CD                  2

/* w/ IPMI_OEM_DELL_TOKEN_ID_REMOTE_SYSLOG
 *
 * remote syslog enable - boolean
 * syslog port number - uint16
 * remote syslog server1 string length - uint16
 * remote syslog server1 string - 0-256
 * remote syslog server2 string length - uint16
 * remote syslog server2 string - 0-256
 * remote syslog server3 string length - uint16
 * remote syslog server3 string - 0-256
 */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_REMOTE_SYSLOG_REMOTE_SYSLOG_ENABLE_MASK  0x0001
#define IPMI_OEM_DELL_EXTENDED_CONFIG_REMOTE_SYSLOG_SYSLOG_PORT_NUMBER_MASK    0x0002
#define IPMI_OEM_DELL_EXTENDED_CONFIG_REMOTE_SYSLOG_REMOTE_SYSLOG_SERVER1_MASK 0x0004
#define IPMI_OEM_DELL_EXTENDED_CONFIG_REMOTE_SYSLOG_REMOTE_SYSLOG_SERVER2_MASK 0x0008
#define IPMI_OEM_DELL_EXTENDED_CONFIG_REMOTE_SYSLOG_REMOTE_SYSLOG_SERVER3_MASK 0x0010

#define IPMI_OEM_DELL_EXTENDED_CONFIG_REMOTE_SYSLOG_ALL_FIELD_MASK \
  (IPMI_OEM_DELL_EXTENDED_CONFIG_REMOTE_SYSLOG_REMOTE_SYSLOG_ENABLE_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_REMOTE_SYSLOG_SYSLOG_PORT_NUMBER_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_REMOTE_SYSLOG_REMOTE_SYSLOG_SERVER1_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_REMOTE_SYSLOG_REMOTE_SYSLOG_SERVER2_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_REMOTE_SYSLOG_REMOTE_SYSLOG_SERVER3_MASK)

/* w/ IPMI_OEM_DELL_TOKEN_ID_GENERIC_LDAP_GROUP
 *
 * ldap enable - boolean
 * ldap server string length - uint16
 * ladp server string - 0-1023
 * ldap port - uint16
 * ldap base dn string length - uint8
 * ldap base dn string - 0-253
 * ldap user attribute string length - uint8
 * ldap user attribute string - 0-253
 * ldap group attribute string length - uint8
 * ldap group attribute string - 0-253
 * ldap group attribute ls dn - boolean (achu: ??)
 * ldap bind dn string length - uint8
 * ldap bind dn string - 0-253
 * ldap bind password string length - uint8
 * ldap bind password string - 0-253
 * ldap search filter string length - uint16
 * ldap search filter string - 0-1023
 * 
 */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_GENERIC_LDAP_GROUP_LDAP_ENABLE_MASK          0x0001
#define IPMI_OEM_DELL_EXTENDED_CONFIG_GENERIC_LDAP_GROUP_LDAP_SERVER_MASK          0x0002
#define IPMI_OEM_DELL_EXTENDED_CONFIG_GENERIC_LDAP_GROUP_LDAP_PORT_MASK            0x0004
#define IPMI_OEM_DELL_EXTENDED_CONFIG_GENERIC_LDAP_GROUP_LDAP_BASE_DN_MASK         0x0008
#define IPMI_OEM_DELL_EXTENDED_CONFIG_GENERIC_LDAP_GROUP_LDAP_USER_ATTRIBUTE_MASK  0x0010
#define IPMI_OEM_DELL_EXTENDED_CONFIG_GENERIC_LDAP_GROUP_LDAP_GROUP_ATTRIBUTE_MASK 0x0020
#define IPMI_OEM_DELL_EXTENDED_CONFIG_GENERIC_LDAP_GROUP_LDAP_ATTRIBUTE_LS_DN_MASK 0x0040
#define IPMI_OEM_DELL_EXTENDED_CONFIG_GENERIC_LDAP_GROUP_LDAP_BIND_DN_MASK         0x0080
#define IPMI_OEM_DELL_EXTENDED_CONFIG_GENERIC_LDAP_GROUP_LDAP_BIND_PASSWORD_MASK   0x0100
#define IPMI_OEM_DELL_EXTENDED_CONFIG_GENERIC_LDAP_GROUP_LDAP_SEARCH_FILTER_MASK   0x0200

#define IPMI_OEM_DELL_EXTENDED_CONFIG_GENERIC_LDAP_GROUP_ALL_FIELD_MASK \
  (IPMI_OEM_DELL_EXTENDED_CONFIG_GENERIC_LDAP_GROUP_LDAP_ENABLE_MASK	\
   | IPMI_OEM_DELL_EXTENDED_CONFIG_GENERIC_LDAP_GROUP_LDAP_SERVER_MASK	\
   | IPMI_OEM_DELL_EXTENDED_CONFIG_GENERIC_LDAP_GROUP_LDAP_PORT_MASK	\
   | IPMI_OEM_DELL_EXTENDED_CONFIG_GENERIC_LDAP_GROUP_LDAP_BASE_DN_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_GENERIC_LDAP_GROUP_LDAP_USER_ATTRIBUTE_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_GENERIC_LDAP_GROUP_LDAP_GROUP_ATTRIBUTE_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_GENERIC_LDAP_GROUP_LDAP_ATTRIBUTE_LS_DN_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_GENERIC_LDAP_GROUP_LDAP_BIND_DN_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_GENERIC_LDAP_GROUP_LDAP_BIND_PASSWORD_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_GENERIC_LDAP_GROUP_LDAP_SEARCH_FILTER_MASK)

/* w/ IPMI_OEM_DELL_TOKEN_ID_LDAP_ROLE_GROUP
 *
 * indexed 1-5
 *
 * ldap role group dn string length - uint16
 * ldap role group dn string - 0-1023
 * ldap role group privilege - uint32 (0x00000000 - 0x000001FF)
 */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_LDAP_ROLE_GROUP_LDAP_ROLE_GROUP_DN_MASK        0x0001
#define IPMI_OEM_DELL_EXTENDED_CONFIG_LDAP_ROLE_GROUP_LDAP_ROLE_GROUP_PRIVILEGE_MASK 0x0002

#define IPMI_OEM_DELL_EXTENDED_CONFIG_LDAP_ROLE_GROUP_ALL_FIELD_MASK \
  (IPMI_OEM_DELL_EXTENDED_CONFIG_LDAP_ROLE_GROUP_LDAP_ROLE_GROUP_DN_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_LDAP_ROLE_GROUP_LDAP_ROLE_GROUP_PRIVILEGE_MASK)

/* w/ IPMI_OEM_DELL_TOKEN_ID_SSH_PK_GROUP
 *
 * indexed 2-16
 *
 * pk key number delete - uint8 (range 1-4)
 * pk key text string1 length - uint16
 * pk key text string1 - 0-1023
 * pk key text string2 length - uint16
 * pk key text string2 - 0-1023
 * pk key text string3 length - uint16
 * pk key text string3 - 0-1023
 * pk key text string4 length - uint16
 * pk key text string4 - 0-1023
 */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_SSH_PK_GROUP_PK_KEY_NUMBER_DELETE_MASK 0x0001
#define IPMI_OEM_DELL_EXTENDED_CONFIG_SSH_PK_GROUP_PK_KEY_TEXT1_MASK         0x0002
#define IPMI_OEM_DELL_EXTENDED_CONFIG_SSH_PK_GROUP_PK_KEY_TEXT2_MASK         0x0004
#define IPMI_OEM_DELL_EXTENDED_CONFIG_SSH_PK_GROUP_PK_KEY_TEXT3_MASK         0x0008
#define IPMI_OEM_DELL_EXTENDED_CONFIG_SSH_PK_GROUP_PK_KEY_TEXT4_MASK         0x0010

#define IPMI_OEM_DELL_EXTENDED_CONFIG_SSH_PK_GROUP_ALL_FIELD_MASK \
  (IPMI_OEM_DELL_EXTENDED_CONFIG_SSH_PK_GROUP_PK_KEY_NUMBER_DELETE_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_SSH_PK_GROUP_PK_KEY_TEXT1_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_SSH_PK_GROUP_PK_KEY_TEXT2_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_SSH_PK_GROUP_PK_KEY_TEXT3_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_SSH_PK_GROUP_PK_KEY_TEXT4_MASK)

/* w/ IPMI_OEM_DELL_TOKEN_ID_AD_SRV_LOOKUP_GROUP
 *
 * addc srv lookup enable - uint8 (achu: boolean??)
 * addc srv lookup by userdomain - uint8 (achu: boolean??)
 * addc srv lookup domain name string length - uint8
 * addc srv lookup domain name string - 0-255
 * adgc srv lookup enable - uint8 (achu: boolean??)
 * adgc srv root domain string length - uint8
 * adgc srv root domain string - 0-255
 */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_AD_SRV_LOOKUP_GROUP_ADDC_SRV_LOOKUP_ENABLE        0x0001
#define IPMI_OEM_DELL_EXTENDED_CONFIG_AD_SRV_LOOKUP_GROUP_ADDC_SRV_LOOKUP_BY_USERDOMAIN 0x0002
#define IPMI_OEM_DELL_EXTENDED_CONFIG_AD_SRV_LOOKUP_GROUP_ADDC_SRV_LOOKUP_DOMAIN_NAME   0x0004
#define IPMI_OEM_DELL_EXTENDED_CONFIG_AD_SRV_LOOKUP_GROUP_ADGC_SRV_LOOKUP_ENABLE        0x0008
#define IPMI_OEM_DELL_EXTENDED_CONFIG_AD_SRV_LOOKUP_GROUP_ADGC_ROOT_DOMAIN              0x0010

#define IPMI_OEM_DELL_EXTENDED_CONFIG_AD_SRV_LOOKUP_GROUP_ALL_FIELD_MASK \
  (IPMI_OEM_DELL_EXTENDED_CONFIG_AD_SRV_LOOKUP_GROUP_ADDC_SRV_LOOKUP_ENABLE \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_AD_SRV_LOOKUP_GROUP_ADDC_SRV_LOOKUP_BY_USERDOMAIN \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_AD_SRV_LOOKUP_GROUP_ADDC_SRV_LOOKUP_DOMAIN_NAME \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_AD_SRV_LOOKUP_GROUP_ADGC_SRV_LOOKUP_ENABLE \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_AD_SRV_LOOKUP_GROUP_ADGC_ROOT_DOMAIN)

/* w/ IPMI_OEM_DELL_TOKEN_ID_CLOSE_RAC_SESSION_INFO
 *
 * session id - uint16
 * login user id string length - uint8
 * login user id string - 0-255
 */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_CLOSE_RAC_SESSION_INFO_SESSION_ID_MASK    0x0001
#define IPMI_OEM_DELL_EXTENDED_CONFIG_CLOSE_RAC_SESSION_INFO_LOGIN_USER_ID_MASK 0x0002

#define IPMI_OEM_DELL_EXTENDED_CONFIG_CLOSE_RAC_SESSION_INFO_ALL_FIELD_MASK \
  (IPMI_OEM_DELL_EXTENDED_CONFIG_CLOSE_RAC_SESSION_INFO_SESSION_ID_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_CLOSE_RAC_SESSION_INFO_LOGIN_USER_ID_MASK)

/* w/ IPMI_OEM_DELL_TOKEN_ID_IPV4_STATIC_EXTENDED_GROUP
 *
 * ipv4 static enable - boolean
 * ipv4 static dhcp enable - boolean
 * ipv4 static address - uint8 * 4
 * ipv4 static netmask - uint8 * 4
 * ipv4 static gateway ip address - uint8 * 4
 * ipv4 static auto dns - boolean
 * ipv4 static dns server1 address - uint8 * 4
 * ipv4 static dns server2 address - uint8 * 4
 */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_IPV4_STATIC_EXTENDED_GROUP_IPV4_STATIC_ENABLE_MASK              0x0001
#define IPMI_OEM_DELL_EXTENDED_CONFIG_IPV4_STATIC_EXTENDED_GROUP_IPV4_STATIC_DHCP_ENABLE_MASK         0x0002
#define IPMI_OEM_DELL_EXTENDED_CONFIG_IPV4_STATIC_EXTENDED_GROUP_IPV4_STATIC_ADDRESS_MASK             0x0004  
#define IPMI_OEM_DELL_EXTENDED_CONFIG_IPV4_STATIC_EXTENDED_GROUP_IPV4_STATIC_NETMASK_MASK             0x0008
#define IPMI_OEM_DELL_EXTENDED_CONFIG_IPV4_STATIC_EXTENDED_GROUP_IPV4_STATIC_GATEWAY_IP_ADDRESS_MASK  0x0010
#define IPMI_OEM_DELL_EXTENDED_CONFIG_IPV4_STATIC_EXTENDED_GROUP_IPV4_STATIC_AUTO_DNS_MASK            0x0020
#define IPMI_OEM_DELL_EXTENDED_CONFIG_IPV4_STATIC_EXTENDED_GROUP_IPV4_STATIC_DNS_SERVER1_ADDRESS_MASK 0x0040
#define IPMI_OEM_DELL_EXTENDED_CONFIG_IPV4_STATIC_EXTENDED_GROUP_IPV4_STATIC_DNS_SERVER2_ADDRESS_MASK 0x0080

#define IPMI_OEM_DELL_EXTENDED_CONFIG_IPV4_STATIC_EXTENDED_GROUP_ALL_FIELD_MASK \
  (IPMI_OEM_DELL_EXTENDED_CONFIG_IPV4_STATIC_EXTENDED_GROUP_IPV4_STATIC_ENABLE_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_IPV4_STATIC_EXTENDED_GROUP_IPV4_STATIC_DHCP_ENABLE_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_IPV4_STATIC_EXTENDED_GROUP_IPV4_STATIC_ADDRESS_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_IPV4_STATIC_EXTENDED_GROUP_IPV4_STATIC_NETMASK_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_IPV4_STATIC_EXTENDED_GROUP_IPV4_STATIC_GATEWAY_IP_ADDRESS_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_IPV4_STATIC_EXTENDED_GROUP_IPV4_STATIC_AUTO_DNS_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_IPV4_STATIC_EXTENDED_GROUP_IPV4_STATIC_DNS_SERVER1_ADDRESS_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_IPV4_STATIC_EXTENDED_GROUP_IPV4_STATIC_DNS_SERVER2_ADDRESS_MASK)

/* w/ IPMI_OEM_DELL_TOKEN_ID_IPV6_STATIC_EXTENDED_GROUP
 *
 * ipv6 static enable - boolean
 * ipv6 static auto config - boolean
 * ipv6 static address string length - uint8
 * ipv6 static address string - 0-39
 * ipv6 static gateway ip address string length - uint8
 * ipv6 static gateway ip address string - 0-39
 * ipv6 static prefix length - uint8
 * ipv6 static auto dns - uint8
 * ipv6 static dns server1 address string length - uint8
 * ipv6 static dns server1 address string - 0-39
 * ipv6 static dns server2 address string length - uint8
 * ipv6 static dns server2 address string - 0-39
 */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_STATIC_EXTENDED_GROUP_IPV6_STATIC_ENABLE_MASK                    0x0001
#define IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_STATIC_EXTENDED_GROUP_IPV6_STATIC_AUTO_CONFIG_MASK               0x0002
#define IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_STATIC_EXTENDED_GROUP_IPV6_STATIC_ADDRESS_STRING_MASK            0x0004
#define IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_STATIC_EXTENDED_GROUP_IPV6_STATIC_GATEWAY_IP_ADDRESS_STRING_MASK 0x0008
#define IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_STATIC_EXTENDED_GROUP_IPV6_STATIC_PREFIX_LENGTH_MASK             0x0010
#define IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_STATIC_EXTENDED_GROUP_IPV6_STATIC_AUTO_DNS_MASK                  0x0020
#define IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_STATIC_EXTENDED_GROUP_IPV6_STATIC_DNS_SERVER1_ADDRESS_MASK       0x0040
#define IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_STATIC_EXTENDED_GROUP_IPV6_STATIC_DNS_SERVER2_ADDRESS_MASK       0x0080

#define IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_STATIC_EXTENDED_GROUP_ALL_FIELD_MASK \
  (IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_STATIC_EXTENDED_GROUP_IPV6_STATIC_ENABLE_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_STATIC_EXTENDED_GROUP_IPV6_STATIC_AUTO_CONFIG_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_STATIC_EXTENDED_GROUP_IPV6_STATIC_ADDRESS_STRING_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_STATIC_EXTENDED_GROUP_IPV6_STATIC_GATEWAY_IP_ADDRESS_STRING_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_STATIC_EXTENDED_GROUP_IPV6_STATIC_PREFIX_LENGTH_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_STATIC_EXTENDED_GROUP_IPV6_STATIC_AUTO_DNS_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_STATIC_EXTENDED_GROUP_IPV6_STATIC_DNS_SERVER1_ADDRESS_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_IPV6_STATIC_EXTENDED_GROUP_IPV6_STATIC_DNS_SERVER2_ADDRESS_MASK)

/* w/ IPMI_OEM_DELL_TOKEN_ID_STATIC_DNS_DOMAIN_NAME_GROUP
 *
 * nic static enable - boolean
 * nic static domain name dhcp enable - boolean
 * nic static domain name string length - uint8
 * nic static domain name string - 0-255
 */
#define IPMI_OEM_DELL_EXTENDED_CONFIG_DNS_DOMAIN_NAME_GROUP_NIC_STATIC_ENABLE_MASK      0x0001
#define IPMI_OEM_DELL_EXTENDED_CONFIG_DNS_DOMAIN_NAME_GROUP_NIC_STATIC_DHCP_ENABLE_MASK 0x0002
#define IPMI_OEM_DELL_EXTENDED_CONFIG_DNS_DOMAIN_NAME_GROUP_NIC_STATIC_DOMAIN_NAME_MASK 0x0004

#define IPMI_OEM_DELL_EXTENDED_CONFIG_DNS_DOMAIN_NAME_GROUP_ALL_FIELD_MASK \
  (IPMI_OEM_DELL_EXTENDED_CONFIG_DNS_DOMAIN_NAME_GROUP_NIC_STATIC_ENABLE_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_DNS_DOMAIN_NAME_GROUP_NIC_STATIC_DHCP_ENABLE_MASK \
   | IPMI_OEM_DELL_EXTENDED_CONFIG_DNS_DOMAIN_NAME_GROUP_NIC_STATIC_DOMAIN_NAME_MASK)

/* w/ IPMI_CMD_OEM_DELL_RESET_TO_DEFAULTS */
#define IPMI_OEM_DELL_RESET_TO_DEFAULTS_GET_STATUS                  0x00
#define IPMI_OEM_DELL_RESET_TO_DEFAULTS_INITIATE_RESULT_TO_DEFAULTS 0xAA

#define IPMI_OEM_DELL_RESET_TO_DEFAULTS_IN_PROGRESS 0x00
#define IPMI_OEM_DELL_RESET_TO_DEFAULTS_COMPLETE    0x01

/* w/ IPMI_CMD_OEM_DELL_SET_NIC_SELECTION / IPMI_CMD_OEM_DELL_GET_NIC_SELECTION */
#define IPMI_OEM_DELL_NIC_SELECTION_SHARED                           0x00
#define IPMI_OEM_DELL_NIC_SELECTION_SHARED_WITH_FAILOVER_TO_NIC2     0x01
#define IPMI_OEM_DELL_NIC_SELECTION_DEDICATED                        0x02
#define IPMI_OEM_DELL_NIC_SELECTION_SHARED_WITH_FAILOVER_TO_ALL_NICS 0x03

/* w/ IPMI_CMD_OEM_DELL_QUERY_CHASSIS_IDENTIFY_STATUS */
#define IPMI_OEM_DELL_QUERY_CHASSIS_IDENTIFY_STATUS_OFF 0x00
#define IPMI_OEM_DELL_QUERY_CHASSIS_IDENTIFY_STATUS_ON  0x01

/* w/ IPMI_CMD_OEM_DELL_GET_ACTIVE_LOM_STATUS */
#define IPMI_OEM_DELL_GET_ACTIVE_LOM_STATUS_GET_STATUS  0x00
#define IPMI_OEM_DELL_GET_ACTIVE_LOM_STATUS_LINK_STATUS 0x01
#define IPMI_OEM_DELL_GET_ACTIVE_LOM_STATUS_LINK_SPEED  0x02
#define IPMI_OEM_DELL_GET_ACTIVE_LOM_STATUS_LINK_MODE   0x03

#define IPMI_OEM_DELL_LOM_STATUS_NO_ACTIVE_LOM 0x00
#define IPMI_OEM_DELL_LOM_STATUS_LOM_1         0x01
#define IPMI_OEM_DELL_LOM_STATUS_LOM_2         0x02
#define IPMI_OEM_DELL_LOM_STATUS_LOM_3         0x03
#define IPMI_OEM_DELL_LOM_STATUS_LOM_4         0x04
#define IPMI_OEM_DELL_LOM_STATUS_DEDICATED     0x05
#define IPMI_OEM_DELL_LOM_STATUS_UNKNOWN       0xFF

#define IPMI_OEM_DELL_LOM_LINK_STATUS_BITMASK 0x0F
#define IPMI_OEM_DELL_LOM_LINK_STATUS_SHIFT   0

#define IPMI_OEM_DELL_LOM_LINK_STATUS_NO_LINK      0
#define IPMI_OEM_DELL_LOM_LINK_STATUS_LINK_PRESENT 1

#define IPMI_OEM_DELL_LOM_LINK_SPEED_BITMASK 0x0F
#define IPMI_OEM_DELL_LOM_LINK_SPEED_SHIFT   0

#define IPMI_OEM_DELL_LOM_LINK_SPEED_10MBPS  0x00
#define IPMI_OEM_DELL_LOM_LINK_SPEED_100MBPS 0x01
#define IPMI_OEM_DELL_LOM_LINK_SPEED_1GBPS   0x02
#define IPMI_OEM_DELL_LOM_LINK_SPEED_UNKNOWN 0x0F

#define IPMI_OEM_DELL_LOM_LINK_MODE_BITMASK 0x0F
#define IPMI_OEM_DELL_LOM_LINK_MODE_SHIFT   0

#define IPMI_OEM_DELL_LOM_LINK_MODE_HALF_DUPLEX 0x00
#define IPMI_OEM_DELL_LOM_LINK_MODE_FULL_DUPLEX 0x01
#define IPMI_OEM_DELL_LOM_LINK_MODE_UNKNOWN     0x0F

/* w/ IPMI_CMD_OEM_DELL_RESET_POWER_CONSUMPTION_DATA */
#define IPMI_OEM_DELL_RESET_POWER_CONSUMPTION_DATA_CUMULATIVE 0x01
#define IPMI_OEM_DELL_RESET_POWER_CONSUMPTION_DATA_PEAK       0x02
#define IPMI_OEM_DELL_RESET_POWER_CONSUMPTION_DATA_ALL        0x04

/* w/ IPMI_CMD_OEM_DELL_POWER_SUPPLY_INFO */
#define IPMI_OEM_DELL_POWER_SUPPLY_INFO_AC 0x00
#define IPMI_OEM_DELL_POWER_SUPPLY_INFO_DC 0x01

/* w/ IPMI_CMD_OEM_DELL_POWER_CONSUMPTION */
#define IPMI_OEM_DELL_POWER_CONSUMPTION_ENTITY_INSTANCE_ALL 0x00

/* w/ IPMI_CMD_OEM_DELL_POWER_CAPACITY_STATUS */
#define IPMI_OEM_DELL_GET_POWER_CAPACITY_STATUS_BITMASK 0x01
#define IPMI_OEM_DELL_GET_POWER_CAPACITY_STATUS_SHIFT   0

#define IPMI_OEM_DELL_GET_POWER_CAPACITY_IS_SETTABLE_BITMASK 0x02
#define IPMI_OEM_DELL_GET_POWER_CAPACITY_IS_SETTABLE_SHIFT   1

#define IPMI_OEM_DELL_SET_POWER_CAPACITY_STATUS_ENABLE  0x01
#define IPMI_OEM_DELL_SET_POWER_CAPACITY_STATUS_DISABLE 0x00

/*
 * Dell Poweredge R720
 */

/* w/ IPMI_CMD_OEM_DELL_GET_BLADE_SLOT_ID */
#define IPMI_OEM_DELL_SLEEVE_BASED_BLADE_BITMASK 0x80
#define IPMI_OEM_DELL_SLEEVE_BASED_BLADE_SHIFT   7

#define IPMI_OEM_DELL_BLADE_SLOT_NUMBER_BITMASK 0x3F
#define IPMI_OEM_DELL_BLADE_SLOT_NUMBER_SHIFT   0

#define IPMI_OEM_DELL_SLEEVE_BASED_BLADE_YES 1
#define IPMI_OEM_DELL_SLEEVE_BASED_BLADE_NO  0

#define IPMI_OEM_DELL_SLEEVE_A_RANGE_MIN 1
#define IPMI_OEM_DELL_SLEEVE_A_RANGE_MAX 8

#define IPMI_OEM_DELL_SLEEVE_B_RANGE_MIN 17
#define IPMI_OEM_DELL_SLEEVE_B_RANGE_MAX 24

#define IPMI_OEM_DELL_SLEEVE_C_RANGE_MIN 9
#define IPMI_OEM_DELL_SLEEVE_C_RANGE_MAX 16

#define IPMI_OEM_DELL_SLEEVE_D_RANGE_MIN 25
#define IPMI_OEM_DELL_SLEEVE_D_RANGE_MAX 32

/* w/ IPMI_CMD_OEM_DELL_SET_NIC_SELECTION_FAILOVER
 * IPMI_CMD_OEM_DELL_GET_NIC_SELECTION_FAILOVER
 */
#define IPMI_OEM_DELL_NIC_SELECTION_FAILOVER_NIC_DEDICATED 0x01
#define IPMI_OEM_DELL_NIC_SELECTION_FAILOVER_NIC_LOM1      0x02
#define IPMI_OEM_DELL_NIC_SELECTION_FAILOVER_NIC_LOM2      0x03
#define IPMI_OEM_DELL_NIC_SELECTION_FAILOVER_NIC_LOM3      0x04
#define IPMI_OEM_DELL_NIC_SELECTION_FAILOVER_NIC_LOM4      0x05

#define IPMI_OEM_DELL_NIC_SELECTION_FAILOVER_FAILOVER_NONE      0x00
#define IPMI_OEM_DELL_NIC_SELECTION_FAILOVER_FAILOVER_LOM1      0x02
#define IPMI_OEM_DELL_NIC_SELECTION_FAILOVER_FAILOVER_LOM2      0x03
#define IPMI_OEM_DELL_NIC_SELECTION_FAILOVER_FAILOVER_LOM3      0x04
#define IPMI_OEM_DELL_NIC_SELECTION_FAILOVER_FAILOVER_LOM4      0x05
#define IPMI_OEM_DELL_NIC_SELECTION_FAILOVER_FAILOVER_ALL       0x06

/* w/ IPMI_CMD_OEM_DELL_POWER_MONITORING_OVER_A_SPECIFIED_AVERAGING_INTERVAL2
 * IPMI_CMD_OEM_DELL_POWER_MONITORING_AVERAGING_INTERVAL_RANGE2
 */
#define IPMI_OEM_DELL_POWER_MONITORING_SYSTEM_POWER                0x00
#define IPMI_OEM_DELL_POWER_MONITORING_CPU1_SUBSYSTEM              0x01
#define IPMI_OEM_DELL_POWER_MONITORING_CPU2_SUBSYSTEM              0x02
#define IPMI_OEM_DELL_POWER_MONITORING_CPU3_SUBSYSTEM              0x03
#define IPMI_OEM_DELL_POWER_MONITORING_CPU4_SUBSYSTEM              0x04
#define IPMI_OEM_DELL_POWER_MONITORING_MEMORY_POWER_OF_CPU_DOMAIN1 0x05
#define IPMI_OEM_DELL_POWER_MONITORING_MEMORY_POWER_OF_CPU_DOMAIN2 0x06
#define IPMI_OEM_DELL_POWER_MONITORING_MEMORY_POWER_OF_CPU_DOMAIN3 0x07
#define IPMI_OEM_DELL_POWER_MONITORING_MEMORY_POWER_OF_CPU_DOMAIN4 0x08
#define IPMI_OEM_DELL_POWER_MONITORING_DRIVES                      0x09
#define IPMI_OEM_DELL_POWER_MONITORING_FANS                        0x0A
#define IPMI_OEM_DELL_POWER_MONITORING_PCIE_ADD_IN_CARDS           0x0B
#define IPMI_OEM_DELL_POWER_MONITORING_GPU_CABLES                  0x0C

/* averaging interval 30-900s */
#define IPMI_OEM_DELL_POWER_MONITORING_RETURN_AVG_MIN_MAX_POWER    0x00
/* averaging interval 5-900s */
#define IPMI_OEM_DELL_POWER_MONITORING_RETURN_ONLY_AVG_POWER       0x01

#define IPMI_OEM_DELL_POWER_MONITORING_INTERVAL_MIN             5
#define IPMI_OEM_DELL_POWER_MONITORING_INTERVAL_MAX             900
#define IPMI_OEM_DELL_POWER_MONITORING_INTERVAL_AVG_MIN_MAX_MIN 30

/*
 * Dell Poweredge C410x
 */

/* w/ IPMI_CMD_OEM_DELL_SLOT_POWER_CONTROL */
#define IPMI_OEM_DELL_SLOT_POWER_CONTROL_SLOT_NUMBER_MIN 1
#define IPMI_OEM_DELL_SLOT_POWER_CONTROL_SLOT_NUMBER_MAX 16

/* w/ IPMI_CMD_OEM_DELL_PORT_MAP */
#define IPMI_OEM_DELL_PORT_MAP_GET_SET_BITMASK 0x80
#define IPMI_OEM_DELL_PORT_MAP_GET_SET_SHIFT   7

#define IPMI_OEM_DELL_PORT_MAP_GET 0
#define IPMI_OEM_DELL_PORT_MAP_SET 1

#define IPMI_OEM_DELL_PORT_MAP_CONTROL_TYPE_REQUEST_BITMASK 0x70
#define IPMI_OEM_DELL_PORT_MAP_CONTROL_TYPE_REQUEST_SHIFT   4

#define IPMI_OEM_DELL_PORT_MAP_CONTROL_TYPE_RESPONSE_BITMASK 0xF0
#define IPMI_OEM_DELL_PORT_MAP_CONTROL_TYPE_RESPONSE_SHIFT   4

#define IPMI_OEM_DELL_PORT_MAP_CONTROL_TYPE_JUMPER 1
#define IPMI_OEM_DELL_PORT_MAP_CONTROL_TYPE_BMC    2

#define IPMI_OEM_DELL_PORT_MAP_IPASS_MAPPING_1_BITMASK 0x08
#define IPMI_OEM_DELL_PORT_MAP_IPASS_MAPPING_1_SHIFT   3

#define IPMI_OEM_DELL_PORT_MAP_IPASS_MAPPING_2_BITMASK 0x04
#define IPMI_OEM_DELL_PORT_MAP_IPASS_MAPPING_2_SHIFT   2

#define IPMI_OEM_DELL_PORT_MAP_IPASS_MAPPING_3_BITMASK 0x02
#define IPMI_OEM_DELL_PORT_MAP_IPASS_MAPPING_3_SHIFT   1

#define IPMI_OEM_DELL_PORT_MAP_IPASS_MAPPING_4_BITMASK 0x01
#define IPMI_OEM_DELL_PORT_MAP_IPASS_MAPPING_4_SHIFT   0

#define IPMI_OEM_DELL_PORT_MAP_IPASS_MAPPING_1_2 1
#define IPMI_OEM_DELL_PORT_MAP_IPASS_MAPPING_1_4 0

#define IPMI_OEM_DELL_PORT_MAP_IPASS_MAPPING_MIN 1
#define IPMI_OEM_DELL_PORT_MAP_IPASS_MAPPING_MAX 16

#define IPMI_OEM_DELL_PORT_MAP_SLOT_MAPPING_1_BITMASK 0xF0
#define IPMI_OEM_DELL_PORT_MAP_SLOT_MAPPING_1_SHIFT   4

#define IPMI_OEM_DELL_PORT_MAP_SLOT_MAPPING_2_BITMASK 0x0F
#define IPMI_OEM_DELL_PORT_MAP_SLOT_MAPPING_2_SHIFT   0

#define IPMI_OEM_DELL_PORT_MAP_SLOT_MAPPING_1_8_NOT_SUPPORTED 0
#define IPMI_OEM_DELL_PORT_MAP_SLOT_MAPPING_1_2_OR_1_4        1
#define IPMI_OEM_DELL_PORT_MAP_SLOT_MAPPING_1_8               2

/******************************************* 
 * Fujitsu                                 *
 *******************************************/

/*
 * Fujitsu iRMC S1 / iRMC S2
 *
 * All of the below are from
 *
 * http://manuals.ts.fujitsu.com/file/4390/irmc_s2-en.pdf
 */

/* w/ IPMI_CMD_OEM_FUJITSU_POWER */
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_GET_POWER_ON_SOURCE    0x15
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_GET_POWER_OFF_SOURCE   0x16
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_SET_POWER_OFF_INHIBIT  0x1C
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_GET_POWER_OFF_INHIBIT  0x1D
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_SET_NEXT_POWER_ON_TIME 0x20

/* w/ IPMI_CMD_OEM_FUJITSU_COMMUNICATION */
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_SYSTEM_OS_SHUTDOWN_REQUEST           0x05
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_SYSTEM_OS_SHUTDOWN_REQUEST_AND_RESET 0x06
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_AGENT_CONNECT_STATUS                 0x08
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_SHUTDOWN_REQUEST_CANCELLED           0x09

/* w/ IPMI_CMD_OEM_FUJITSU_FAN_TEST */
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_WRITE_TO_SYSTEM_DISPLAY 0x02

/* w/ IPMI_CMD_OEM_FUJITSU_BIOS */
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_GET_BIOS_POST_STATE 0x09
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_GET_CPU_INFO        0x15

/* w/ IPMI_CMD_OEM_FUJITSU_SYSTEM */
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_GET_SYSTEM_STATUS                          0x10
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_GET_EEPROM_VERSION_INFO                    0x12
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_GET_SEL_ENTRY_LONG_TEXT                    0x43
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_GET_SEL_ENTRY_TEXT                         0x45
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_SET_IDENTIFY_LED                           0xB0
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_GET_IDENTIFY_LED                           0xB1
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_GET_ERROR_LED                              0xB3
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_RESET_NONVOLATILE_CFG_VARIABLES_TO_DEFAULT 0xDF
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_RESET_CONFIGSPACE_VARIABLES_TO_DEFAULT     0xE0

/* w/ IPMI_CMD_OEM_FUJITSU_GET_REMOTE_STORAGE_CONNECTION_OR_STATUS */
/* achu: making up names, not listed in documents */
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_REMOTE_STORAGE_CONNECTED 0x01
#define IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_REMOTE_STORAGE_STATUS    0x02

/* w/ IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_GET_POWER_ON_SOURCE */
#define IPMI_OEM_FUJITSU_POWER_ON_SOURCE_SOFTWARE_OR_COMMAND                                   0x00
#define IPMI_OEM_FUJITSU_POWER_ON_SOURCE_POWER_SWITCH                                          0x01
#define IPMI_OEM_FUJITSU_POWER_ON_SOURCE_AUTOMATIC_RESTART_AFTER_POWER_FAILURE                 0x02
#define IPMI_OEM_FUJITSU_POWER_ON_SOURCE_CLOCK_OR_TIMER                                        0x03
#define IPMI_OEM_FUJITSU_POWER_ON_SOURCE_AUTOMATIC_RESTART_AFTER_FAN_FAILURE_SHUTDOWN          0x04
#define IPMI_OEM_FUJITSU_POWER_ON_SOURCE_AUTOMATIC_RESTART_AFTER_CRITICAL_TEMPERATURE_SHUTDOWN 0x05
#define IPMI_OEM_FUJITSU_POWER_ON_SOURCE_REBOOT_AFTER_WATCHDOG_TIMEOUT                         0x08
#define IPMI_OEM_FUJITSU_POWER_ON_SOURCE_REMOTE_ON                                             0x09
#define IPMI_OEM_FUJITSU_POWER_ON_SOURCE_REBOOT_AFTER_A_CPU_ERROR                              0x0C
#define IPMI_OEM_FUJITSU_POWER_ON_SOURCE_REBOOT_BY_HARDWARE_RESET                              0x15
#define IPMI_OEM_FUJITSU_POWER_ON_SOURCE_REBOOT_AFTER_WARM_START                               0x16
#define IPMI_OEM_FUJITSU_POWER_ON_SOURCE_POWERED_ON_BY_A_PCI_BUS_POWER_MANAGEMENT_EVENT        0x1A
#define IPMI_OEM_FUJITSU_POWER_ON_SOURCE_POWERED_ON_BY_REMOTE_CONTROL_VIA_REMOTE_MANAGER       0x1D
#define IPMI_OEM_FUJITSU_POWER_ON_SOURCE_REBOOT_RESET_BY_REMOTE_CONTROL_VIA_REMOTE_MANAGER     0x1E

/* w/ IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_GET_POWER_OFF_SOURCE */
#define IPMI_OEM_FUJITSU_POWER_OFF_SOURCE_SOFTWARE                                         0x00
#define IPMI_OEM_FUJITSU_POWER_OFF_SOURCE_POWER_SWITCH                                     0x01
#define IPMI_OEM_FUJITSU_POWER_OFF_SOURCE_AC_POWER_FAIL                                    0x02
#define IPMI_OEM_FUJITSU_POWER_OFF_SOURCE_CLOCK_OR_TIMER                                   0x03
#define IPMI_OEM_FUJITSU_POWER_OFF_SOURCE_FAN_FAILURE                                      0x04
#define IPMI_OEM_FUJITSU_POWER_OFF_SOURCE_CRITICAL_TEMPERATURE                             0x05
#define IPMI_OEM_FUJITSU_POWER_OFF_SOURCE_FINAL_POWER_OFF_AFTER_REPEATED_WATCHDOG_TIMEOUTS 0x08
#define IPMI_OEM_FUJITSU_POWER_OFF_SOURCE_FINAL_POWER_OFF_AFTER_REPEATED_CPU_ERRORS        0x0C
#define IPMI_OEM_FUJITSU_POWER_OFF_SOURCE_POWERED_OFF_BY_REMOTE_CONTROL_VIA_REMOTE_MANAGER 0x1D

/* w/ IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_GET_SYSTEM_STATUS */
#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_SYSTEM_POWER_BITMASK 0x80
#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_SYSTEM_POWER_SHIFT   7

#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_SEL_ENTRIES_AVAILABLE_BITMASK  0x10
#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_SEL_ENTRIES_AVAILABLE_SHIFT    4

#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_WATCHDOG_ACTIVE_BITMASK 0x04
#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_WATCHDOG_ACTIVE_SHIFT   2

#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_AGENT_CONNECTED_BITMASK 0x02
#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_AGENT_CONNECTED_SHIFT   1

#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_POST_STATE_BITMASK 0x01
#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_POST_STATE_SHIFT   0

/* rename from "localize" */
/* Bit 7 */
#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_SIGNALING_LOCAL_LED_BITMASK 0x80
#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_SIGNALING_LOCAL_LED_SHIFT   7
/* Bit 6..4 currently undefined */

/* Bit 3..2 */
#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_SIGNALING_CSS_LED_BITMASK 0x0C
#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_SIGNALING_CSS_LED_SHIFT   2

/* Bit 1..0 */
#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_SIGNALING_GLOBAL_ERROR_LED_BITMASK 0x03
#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_SIGNALING_GLOBAL_ERROR_LED_SHIFT   0

#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_NOTIFICATIONS_SEL_MODIFIED_NEW_SEL_ENTRY_BITMASK 0x80
#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_NOTIFICATIONS_SEL_MODIFIED_NEW_SEL_ENTRY_SHIFT   7

#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_NOTIFICATIONS_SEL_MODIFIED_SEL_CLEARED_BITMASK 0x40
#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_NOTIFICATIONS_SEL_MODIFIED_SEL_CLEARED_SHIFT   6

#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_NOTIFICATIONS_SDR_MODIFIED_BITMASK  0x20
#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_NOTIFICATIONS_SDR_MODIFIED_SHIFT    5

#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_NOTIFICATIONS_NONVOLATILE_IPMI_VARIABLE_MODIFIED_BITMASK 0x10
#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_NOTIFICATIONS_NONVOLATILE_IPMI_VARIABLE_MODIFIED_SHIFT   4

#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_NOTIFICATIONS_CONFIGSPACE_MODIFIED_BITMASK 0x08
#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_NOTIFICATIONS_CONFIGSPACE_MODIFIED_SHIFT   3

#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_NOTIFICATIONS_NEW_OUTPUT_ON_LOCALVIEW_DISPLAY_BITMASK 0x01
#define IPMI_OEM_FUJITSU_SYSTEM_STATUS_NOTIFICATIONS_NEW_OUTPUT_ON_LOCALVIEW_DISPLAY_SHIFT   0

/* achu: not defined in Fujitsu docs.  "off" is confirmed to be
 * correct, but "on" and "blink" are being gussed based on ordering of
 * error leds in LED sections.
 */
#define IPMI_OEM_FUJITSU_CSS_LED_OFF   0x0
#define IPMI_OEM_FUJITSU_CSS_LED_ON    0x1
#define IPMI_OEM_FUJITSU_CSS_LED_BLINK 0x2

/* achu: not defined in Fujitsu docs.  "off" is confirmed to be
 * correct, but "on" and "blink" are being gussed based on ordering of
 * error leds in LED sections.
 */
#define IPMI_OEM_FUJITSU_GLOBAL_ERROR_LED_OFF   0x0
#define IPMI_OEM_FUJITSU_GLOBAL_ERROR_LED_ON    0x1
#define IPMI_OEM_FUJITSU_GLOBAL_ERROR_LED_BLINK 0x2

/* w/ IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_GET_EEPROM_VERSION_INFO */
#define IPMI_OEM_FUJITSU_EEPROM_NUMBER_MIN 0
#define IPMI_OEM_FUJITSU_EEPROM_NUMBER_MAX 1

#define IPMI_OEM_FUJITSU_EEPROM_CHECKSUM_OK    0x01
#define IPMI_OEM_FUJITSU_EEPROM_CHECKSUM_ERROR 0x00

/* w/ IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_GET_SEL_ENTRY_LONG_TEXT */
#define IPMI_OEM_FUJITSU_SEL_ENTRY_LONG_TEXT_IRMC_S1_MAX_READ_LENGTH 32
#define IPMI_OEM_FUJITSU_SEL_ENTRY_LONG_TEXT_IRMC_S2_MAX_READ_LENGTH 100

#define IPMI_OEM_FUJITSU_SEL_ENTRY_LONG_TEXT_IRMC_S1_MAX_DATA_LENGTH 80
#define IPMI_OEM_FUJITSU_SEL_ENTRY_LONG_TEXT_IRMC_S2_MAX_DATA_LENGTH 100

#define IPMI_OEM_FUJITSU_SEL_ENTRY_LONG_TEXT_MAX_READ_LENGTH 100
#define IPMI_OEM_FUJITSU_SEL_ENTRY_LONG_TEXT_MAX_DATA_LENGTH 100

/*
 * CSS (Customer Self Service)
 *
 * If the component is marked as CSS, the customer can replace it by
 * himself without a service technican (e.g. Memory DIMM etc.)  CSS is
 * combined with the severity information.
 */
#define IPMI_OEM_FUJITSU_CSS_BITMASK      0x80
#define IPMI_OEM_FUJITSU_CSS_SHIFT        7

/*
 * Severity of a decoded event. All events should have an assigned severity.
 */
#define IPMI_OEM_FUJITSU_SEVERITY_BITMASK 0x70
#define IPMI_OEM_FUJITSU_SEVERITY_SHIFT   4

#define IPMI_OEM_FUJITSU_CSS_COMPONENT    1
#define IPMI_OEM_FUJITSU_NO_CSS_COMPONENT 0

#define IPMI_OEM_FUJITSU_SEVERITY_INFORMATIONAL 0
#define IPMI_OEM_FUJITSU_SEVERITY_MINOR         1
#define IPMI_OEM_FUJITSU_SEVERITY_MAJOR         2
#define IPMI_OEM_FUJITSU_SEVERITY_CRITICAL      3

/* w/ IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_SET_IDENTIFY_LED / IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_GET_IDENTIFY_LED */
#define IPMI_OEM_FUJITSU_IDENTIFY_LED_ON  0x1
#define IPMI_OEM_FUJITSU_IDENTIFY_LED_OFF 0x0

#define IPMI_OEM_FUJITSU_IDENTIFY_LED_BITMASK 0x01
#define IPMI_OEM_FUJITSU_IDENTIFY_LED_SHIFT      0 

/* IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_GET_ERROR_LED */
#define IPMI_OEM_FUJITSU_ERROR_LED_CSS_OFF_GEL_OFF     0
#define IPMI_OEM_FUJITSU_ERROR_LED_CSS_OFF_GEL_ON      1
#define IPMI_OEM_FUJITSU_ERROR_LED_CSS_OFF_GEL_BLINK   2
#define IPMI_OEM_FUJITSU_ERROR_LED_CSS_ON_GEL_OFF      3
#define IPMI_OEM_FUJITSU_ERROR_LED_CSS_ON_GEL_ON       4
#define IPMI_OEM_FUJITSU_ERROR_LED_CSS_ON_GEL_BLINK    5
#define IPMI_OEM_FUJITSU_ERROR_LED_CSS_BLINK_GEL_OFF   6
#define IPMI_OEM_FUJITSU_ERROR_LED_CSS_BLINK_GEL_ON    7
#define IPMI_OEM_FUJITSU_ERROR_LED_CSS_BLINK_GEL_BLINK 8

/* w/ IPMI_OEM_FUJITSU_COMMAND_SPECIFIER_REMOTE_STORAGE_STATUS */
#define IPMI_OEM_FUJITSU_REMOTE_STORAGE_CONNECTION_MIN 0
#define IPMI_OEM_FUJITSU_REMOTE_STORAGE_CONNECTION_MAX 1

#define IPMI_OEM_FUJITSU_REMOTE_STORAGE_CONNECTED     0x01
#define IPMI_OEM_FUJITSU_REMOTE_STORAGE_NOT_CONNECTED 0x00

#define IPMI_OEM_FUJITSU_REMOTE_STORAGE_STATUS_INVALID_UNKNOWN                              0x00
#define IPMI_OEM_FUJITSU_REMOTE_STORAGE_STATUS_IDLE                                         0x01
#define IPMI_OEM_FUJITSU_REMOTE_STORAGE_STATUS_CONNECTION_ATTEMPT_PENDING                   0x02
#define IPMI_OEM_FUJITSU_REMOTE_STORAGE_STATUS_CONNECTED                                    0x03
#define IPMI_OEM_FUJITSU_REMOTE_STORAGE_STATUS_CONNECTION_ATTEMPTS_RETRIES_EXHAUSTED_FAILED 0x04
#define IPMI_OEM_FUJITSU_REMOTE_STORAGE_STATUS_CONNECTION_LOST                              0x05
#define IPMI_OEM_FUJITSU_REMOTE_STORAGE_STATUS_DISCONNECT_PENDING                           0x06

#define IPMI_OEM_FUJITSU_REMOTE_STORAGE_TYPE_INVALID_UNKNOWN     0x00
#define IPMI_OEM_FUJITSU_REMOTE_STORAGE_TYPE_STORAGE_SERVER_IPMI 0x01
#define IPMI_OEM_FUJITSU_REMOTE_STORAGE_TYPE_APPLET              0x02
#define IPMI_OEM_FUJITSU_REMOTE_STORAGE_TYPE_NONE_NOT_CONNECTED  0x03

/*******************************************
 * IBM                                     *
 *******************************************/

/*
 * IBM x3455/x3755
 */

/* w/ IPMI_CMD_OEM_IBM_GET_LED */

#define IPMI_OEM_IBM_LED_STATE_INACTIVE                  0x0

#define IPMI_OEM_IBM_LED_ACTIVE_BY_LED                   0x1
#define IPMI_OEM_IBM_LED_ACTIVE_BY_SENSOR                0x2
#define IPMI_OEM_IBM_LED_ACTIVE_BY_USER                  0x3
#define IPMI_OEM_IBM_LED_ACTIVE_BY_BIOS_OR_ADMINISTRATOR 0x4

#define IPMI_OEM_IBM_LED_X3455_LOCATION          0x1

#define IPMI_OEM_IBM_LED_X3755_CPU               0x0010
#define IPMI_OEM_IBM_LED_X3755_CPU1              0x0030
#define IPMI_OEM_IBM_LED_X3755_CPU2              0x0031
#define IPMI_OEM_IBM_LED_X3755_CPU3              0x0032
#define IPMI_OEM_IBM_LED_X3755_CPU4              0x0033

#define IPMI_OEM_IBM_LED_X3755_CPU1_BOARD        0x00B8
#define IPMI_OEM_IBM_LED_X3755_CPU2_BOARD        0x00B9
#define IPMI_OEM_IBM_LED_X3755_CPU3_BOARD        0x00BA
#define IPMI_OEM_IBM_LED_X3755_CPU4_BOARD        0x00BB

#define IPMI_OEM_IBM_LED_X3755_DIMM_1            0x0060
#define IPMI_OEM_IBM_LED_X3755_DIMM_2            0x0061
#define IPMI_OEM_IBM_LED_X3755_DIMM_3            0x0062 
#define IPMI_OEM_IBM_LED_X3755_DIMM_4            0x0063
#define IPMI_OEM_IBM_LED_X3755_DIMM_5            0x0064
#define IPMI_OEM_IBM_LED_X3755_DIMM_6            0x0065
#define IPMI_OEM_IBM_LED_X3755_DIMM_7            0x0066
#define IPMI_OEM_IBM_LED_X3755_DIMM_8            0x0067
#define IPMI_OEM_IBM_LED_X3755_DIMM_9            0x0068
#define IPMI_OEM_IBM_LED_X3755_DIMM_10           0x0069
#define IPMI_OEM_IBM_LED_X3755_DIMM_11           0x006A
#define IPMI_OEM_IBM_LED_X3755_DIMM_12           0x006B
#define IPMI_OEM_IBM_LED_X3755_DIMM_13           0x006C
#define IPMI_OEM_IBM_LED_X3755_DIMM_14           0x006D
#define IPMI_OEM_IBM_LED_X3755_DIMM_15           0x006E
#define IPMI_OEM_IBM_LED_X3755_DIMM_16           0x006F
#define IPMI_OEM_IBM_LED_X3755_DIMM_17           0x00C0
#define IPMI_OEM_IBM_LED_X3755_DIMM_18           0x00C1
#define IPMI_OEM_IBM_LED_X3755_DIMM_19           0x00C2
#define IPMI_OEM_IBM_LED_X3755_DIMM_20           0x00C3
#define IPMI_OEM_IBM_LED_X3755_DIMM_21           0x00C4
#define IPMI_OEM_IBM_LED_X3755_DIMM_22           0x00C5
#define IPMI_OEM_IBM_LED_X3755_DIMM_23           0x00C6
#define IPMI_OEM_IBM_LED_X3755_DIMM_24           0x00C7
#define IPMI_OEM_IBM_LED_X3755_DIMM_25           0x00C8
#define IPMI_OEM_IBM_LED_X3755_DIMM_26           0x00C9
#define IPMI_OEM_IBM_LED_X3755_DIMM_27           0x00CA
#define IPMI_OEM_IBM_LED_X3755_DIMM_28           0x00CB
#define IPMI_OEM_IBM_LED_X3755_DIMM_29           0x00CC
#define IPMI_OEM_IBM_LED_X3755_DIMM_30           0x00CD
#define IPMI_OEM_IBM_LED_X3755_DIMM_31           0x00CE
#define IPMI_OEM_IBM_LED_X3755_DIMM_32           0x00CF

#define IPMI_OEM_IBM_LED_X3755_FAN               0x0014
#define IPMI_OEM_IBM_LED_X3755_FAN_1             0x0050
#define IPMI_OEM_IBM_LED_X3755_FAN_2             0x0051
#define IPMI_OEM_IBM_LED_X3755_FAN_3             0x0052
#define IPMI_OEM_IBM_LED_X3755_FAN_4             0x0053
#define IPMI_OEM_IBM_LED_X3755_FAN_5             0x0054
#define IPMI_OEM_IBM_LED_X3755_FAN_6             0x0055
#define IPMI_OEM_IBM_LED_X3755_FAN_7             0x0056
#define IPMI_OEM_IBM_LED_X3755_FAN_8             0x0057

#define IPMI_OEM_IBM_LED_X3755_PCI               0x0020
#define IPMI_OEM_IBM_LED_X3755_PCI_1             0x0070
#define IPMI_OEM_IBM_LED_X3755_PCI_2             0x0071
#define IPMI_OEM_IBM_LED_X3755_PCI_3             0x0072
#define IPMI_OEM_IBM_LED_X3755_PCI_4             0x0073
#define IPMI_OEM_IBM_LED_X3755_PCI_5             0x0074
#define IPMI_OEM_IBM_LED_X3755_PCI_6             0x0075

#define IPMI_OEM_IBM_LED_X3755_SERVERAID_8K_BATT 0x00D0
#define IPMI_OEM_IBM_LED_X3755_SERVERAID_8K_ERR  0x00D1

#define IPMI_OEM_IBM_LED_X3755_ALERT             0x00D9
#define IPMI_OEM_IBM_LED_X3755_BK_BLUE           0x00D8
#define IPMI_OEM_IBM_LED_X3755_BOARD             0x000E
#define IPMI_OEM_IBM_LED_X3755_CNFG              0x0006
#define IPMI_OEM_IBM_LED_X3755_DASD              0x0013
#define IPMI_OEM_IBM_LED_X3755_FAULT             0x0000
#define IPMI_OEM_IBM_LED_X3755_HTX               0x00B0
#define IPMI_OEM_IBM_LED_X3755_INFO              0x0003
#define IPMI_OEM_IBM_LED_X3755_LOCATION          0x0001
#define IPMI_OEM_IBM_LED_X3755_MEM               0x0015
#define IPMI_OEM_IBM_LED_X3755_NMI               0x0019
#define IPMI_OEM_IBM_LED_X3755_OVERSPEC          0x001B
#define IPMI_OEM_IBM_LED_X3755_RAID              0x000F
#define IPMI_OEM_IBM_LED_X3755_SEER              0x000B
#define IPMI_OEM_IBM_LED_X3755_SP                0x001E
#define IPMI_OEM_IBM_LED_X3755_TEMP              0x001C
#define IPMI_OEM_IBM_LED_X3755_VRM               0x0011
 
#define IPMI_OEM_IBM_LED_X3755_UNKNOWN1          0x0040
#define IPMI_OEM_IBM_LED_X3755_UNKNOWN2          0x0041
#define IPMI_OEM_IBM_LED_X3755_UNKNOWN3          0x0047

/*******************************************
 * Intel                                   *
 *******************************************/

/*
 * Intel S5500WB/Penguin Computing Relion 700
 * Intel S2600JF/Appro 512X
 */

/* w/ IPMI_CMD_OEM_INTEL_RESTORE_CONFIGURATION */
#define IPMI_OEM_INTEL_RESTORE_CONFIGURATION_OPERATION_INITIATE_RESTORE   0xAA
#define IPMI_OEM_INTEL_RESTORE_CONFIGURATION_OPERATION_GET_RESTORE_STATUS 0x00

#define IPMI_OEM_INTEL_RESTORE_CONFIGURATION_RESTORE_PROGRESS_RESTORE_IN_PROGRESS 0x00
#define IPMI_OEM_INTEL_RESTORE_CONFIGURATION_RESTORE_PROGRESS_RESTORE_COMPLETED   0x01

/* w/ IPMI_CMD_OEM_INTEL_SET_SMTP_CONFIGURATION / IPMI_CMD_OEM_INTEL_GET_SMTP_CONFIGURATION */

#define IPMI_OEM_INTEL_SMTP_CONFIGURATION_PARAMETER_ENABLE_SMTP            0x00
/* MS byte first */
#define IPMI_OEM_INTEL_SMTP_CONFIGURATION_PARAMETER_SMTP_SERVER_ADDRESS    0x01
#define IPMI_OEM_INTEL_SMTP_CONFIGURATION_PARAMETER_SMTP_USER_NAME         0x02
/* write only */
#define IPMI_OEM_INTEL_SMTP_CONFIGURATION_PARAMETER_USER_PASSWORD          0x03
/* read only */
#define IPMI_OEM_INTEL_SMTP_CONFIGURATION_PARAMETER_NUMBER_OF_DESTINATIONS 0x04
/* max 2 blocks - doc says 64 bytes, but 2 blocks appears to be correct */
#define IPMI_OEM_INTEL_SMTP_CONFIGURATION_PARAMETER_EMAIL_ADDRESS          0x05
/* max 2 blocks */
#define IPMI_OEM_INTEL_SMTP_CONFIGURATION_PARAMETER_SUBJECT                0x06
/* max 4 blocks */
#define IPMI_OEM_INTEL_SMTP_CONFIGURATION_PARAMETER_MESSAGE_CONTENT        0x07
/* max 4 blocks according to doc, but according to firmware max 1 block when you write */
#define IPMI_OEM_INTEL_SMTP_CONFIGURATION_PARAMETER_SENDER_EMAIL_ADDRESS   0x08
/* max 2 blocks */
#define IPMI_OEM_INTEL_SMTP_CONFIGURATION_PARAMETER_SMTP_HOST_NAME         0x09

#define IPMI_OEM_INTEL_SMTP_STRING_BLOCK_LENGTH 16

#define IPMI_OEM_INTEL_SMTP_CONFIGURATION_PARAMETER_SMTP_USER_NAME_MAX_BLOCKS       1
/* XXX: document says max 20 bytes, but fails on second block, so we use 1 block */
#define IPMI_OEM_INTEL_SMTP_CONFIGURATION_PARAMETER_USER_PASSWORD_MAX_BLOCKS        1
#define IPMI_OEM_INTEL_SMTP_CONFIGURATION_PARAMETER_EMAIL_ADDRESS_MAX_BLOCKS        2
#define IPMI_OEM_INTEL_SMTP_CONFIGURATION_PARAMETER_SUBJECT_MAX_BLOCKS              2 
#define IPMI_OEM_INTEL_SMTP_CONFIGURATION_PARAMETER_MESSAGE_CONTENT_MAX_BLOCKS      4
/* XXX: document indicates 2 blocks, but firmware has errors on > 1 block, so we use 1 block */
#define IPMI_OEM_INTEL_SMTP_CONFIGURATION_PARAMETER_SENDER_EMAIL_ADDRESS_MAX_BLOCKS 1
/* XXX: document indicates 2 blocks, but firmware has errors on > 1 block, so we use 1 block */
#define IPMI_OEM_INTEL_SMTP_CONFIGURATION_PARAMETER_SMTP_HOST_NAME_MAX_BLOCKS       1 

#define IPMI_OEM_INTEL_SMTP_CONFIGURATION_PARAMETER_STRING_LENGTH_MAX               (4*IPMI_OEM_INTEL_SMTP_STRING_BLOCK_LENGTH)

#define IPMI_OEM_INTEL_SMTP_CONFIGURATION_PARAMETER_USER_PASSWORD_LENGTH_MAX        20

/* To avoid gcc warnings, add +1 in comparison */
#define IPMI_OEM_INTEL_SMTP_CONFIGURATION_PARAMETER_VALID(__value)	\
  (((__value + 1) >= (IPMI_OEM_INTEL_SMTP_CONFIGURATION_PARAMETER_ENABLE_SMTP + 1) \
    && (__value) <= IPMI_OEM_INTEL_SMTP_CONFIGURATION_PARAMETER_SMTP_HOST_NAME) ? 1 : 0)

#define IPMI_OEM_INTEL_SMTP_CONFIGURATION_NO_SET_SELECTOR   0x0
#define IPMI_OEM_INTEL_SMTP_CONFIGURATION_NO_BLOCK_SELECTOR 0x0

#define IPMI_OEM_INTEL_SMTP_ENABLE_BITMASK 0x01
#define IPMI_OEM_INTEL_SMTP_ENABLE_SHIFT   0

#define IPMI_OEM_INTEL_SMTP_ENABLE  0x1
#define IPMI_OEM_INTEL_SMTP_DISABLE 0x0

/*
 * Intel S2600JF/Appro 512X
 */

/* w/ IPMI_CMD_OEM_INTEL_SET_POWER_RESTORE_DELAY / IPMI_CMD_OEM_INTEL_GET_POWER_RESTORE_DELAY */
#define IPMI_OEM_INTEL_POWER_RESTORE_DELAY_MSB_MASK 0x07
#define IPMI_OEM_INTEL_POWER_RESTORE_DELAY_LSB_MASK 0xFF

#define IPMI_OEM_INTEL_POWER_RESTORE_DELAY_MAX 0x07FF

/* w/ IPMI_CMD_OEM_INTEL_GET_BMC_SERVICE_STATUS / IPMI_CMD_OEM_INTEL_CONTROL_BMC_SERVICES */

#define IPMI_OEM_INTEL_DISABLE_SERVICES 0x00
#define IPMI_OEM_INTEL_ENABLE_SERVICES  0x01

#define IPMI_OEM_INTEL_STANDARD_SERVICES_SSH  0x80
#define IPMI_OEM_INTEL_STANDARD_SERVICES_HTTP 0x20

/******************************************* 
 * Inventec                                *
 *******************************************/

/*
 * Inventec 5441/Dell Xanadu II
 * Inventec 5442/Dell Xanadu III
 */

/* achu: all named from doc except 'lan' configuration id, which I assumed names */

/* w/ IPMI_CMD_OEM_INVENTEC_GET_EXTENDED_CONFIGURATION / IPMI_OEM_INVENTEC_SET_EXTENDED_CONFIGURATION */

#define IPMI_OEM_INVENTEC_EXTENDED_CONFIGURATION_ID_NIC                      0x02
#define IPMI_OEM_INVENTEC_EXTENDED_CONFIGURATION_ID_SOL                      0x03
#define IPMI_OEM_INVENTEC_EXTENDED_CONFIGURATION_ID_SECURITY                 0x04
#define IPMI_OEM_INVENTEC_EXTENDED_CONFIGURATION_ID_ACCOUNT_STATUS           0x05
#define IPMI_OEM_INVENTEC_EXTENDED_CONFIGURATION_ID_DNS                      0x06
#define IPMI_OEM_INVENTEC_EXTENDED_CONFIGURATION_ID_WEB_SERVER_CONFIGURATION 0x0C
#define IPMI_OEM_INVENTEC_EXTENDED_CONFIGURATION_ID_FIRMWARE_LOG             0x0E
#define IPMI_OEM_INVENTEC_EXTENDED_CONFIGURATION_ID_FIRMWARE_INFORMATION     0x0F
#define IPMI_OEM_INVENTEC_EXTENDED_CONFIGURATION_ID_FIRMWARE_UPDATE          0x10
#define IPMI_OEM_INVENTEC_EXTENDED_CONFIGURATION_ID_POWER_MANAGEMENT         0x11

/* nic status - 1 byte, 0 = shared, 1 = dedicated
 */
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_NIC_MODE 0x01

/* sol idle timeout - 2 bytes, ls byte first, 0h = no timeout, default = 01h
 *
 * telnet/ssh redirect enable - 1 byte, 0 = disable, 1 = enabled 
 */
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_SOL_SOL_IDLE_TIMEOUT           0x01
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_SOL_TELNET_SSH_REDIRECT_ENABLE 0x02

/* service disabled - 1 byte, bitmask
 *                  - 0x01 = all service except IPMI are disabled
 *                           (takes precedence over other bits)
 *                  - 0x02 = KVM/Virtual Storage
 *                  - 0x04 = HTTP/HTTPS
 *                  - 0x08 = SSH/Telnet
 *
 * max authentication failures - 1 byte, 0 = disable
 *
 * lockout window - 2 bytes, in seconds, 0 = disable, default = 180
 *
 * lockout time - 2 bytes, in seconds, 0 = disable, default = 3600
 */
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_SECURITY_SERVICE_DISABLED            0x01
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_SECURITY_MAX_AUTHENTICATION_FAILURES 0x02
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_SECURITY_LOCKOUT_WINDOW              0x03
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_SECURITY_LOCKOUT_TIME                0x04

/* number of user - 1 byte, read only
 *
 * number of enabled user - 1 byte, read only
 *
 * user name - 1-17 bytes, read only
 *           - Inventec 5441/Xanadu II - reports stored as p-string, does not return p-string
 *           - Inventec 5442/Xanadu III - returns as p-string
 *
 * account status - 1 byte
 *                - 0x00 - status unspecified
 *                - 0x01 - enabled via set user password
 *                - 0x02 - disabled via set user password
 *                - 0x03 - user id is lockout
 */
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_ACCOUNT_STATUS_NUMBER_OF_USER         0x01
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_ACCOUNT_STATUS_NUMBER_OF_ENABLED_USER 0x02
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_ACCOUNT_STATUS_USER_NAME              0x03
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_ACCOUNT_STATUS_ACCOUNT_STATUS         0x04

/* DNS DHCP enable - 1 byte, 0 - false, 1 - true
 * - DNS server IP addresses should be assigned from DHCP server
 *
 * DNS Server1 - 4 bytes
 * - IP address for DNS server 1, read only if DNS DHCP Enable and DHCP are enabled
 *
 * DNS Server2 - 4 bytes
 * - IP address for DNS server 2, read only if DNS DHCP Enable and DHCP are enabled
 *
 * DNS Register BMC - 0 - false, 1 - true
 * - Enable registering the BMC host name on the DNS server
 *
 * DNS BMC Host Name - 1-64 bytes
 * - Specifies the DNS BMC host name, read only if DNS Register BMC is TRUE.
 * - Stored as P-string
 *
 * DNS Domain Name DHCP Enable - 1 byte
 * - DNS domain name should be assigned from DHCP
 *
 * DNS Domain Name - 1-256 bytes
 * - DNS domain name string, read only if DNS Domain Name DHCP Enable is TRUE
 * - Stored as P-string
 */
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_DNS_DNS_DHCP_ENABLE             0x01
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_DNS_DNS_SERVER1                 0x02
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_DNS_DNS_SERVER2                 0x03
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_DNS_DNS_REGISTER_BMC            0x04
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_DNS_DNS_BMC_HOST_NAME           0x05
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_DNS_DNS_DOMAIN_NAME_DHCP_ENABLE 0x06
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_DNS_DNS_DOMAIN_NAME             0x07

/* web server enabled - 1 byte, 0 = false, 1 = true (default)
 *
 * max web sessions - 1 byte, read only
 *
 * active web sessions - 1 byte, read only
 *
 * web server timeout - 4 bytes, in seconds, 0 = disable, range 60-1920, default 300
 *
 * http port num - 2 bytes, default 80
 *
 * https port num - 2 bytes, default 443
 */
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_WEB_SERVER_CONFIGURATION_WEB_SERVER_ENABLED  0x01
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_WEB_SERVER_CONFIGURATION_MAX_WEB_SESSIONS    0x02
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_WEB_SERVER_CONFIGURATION_ACTIVE_WEB_SESSIONS 0x03
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_WEB_SERVER_CONFIGURATION_WEB_SERVER_TIMEOUT  0x04
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_WEB_SERVER_CONFIGURATION_HTTP_PORT_NUM       0x05
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_WEB_SERVER_CONFIGURATION_HTTPS_PORT_NUM      0x06

/* entity - 1 byte (read only)
 *
 * firmware version - 1-16 bytes (read only)
 *
 * branch - 1-16 bytes (read only)
 *
 * build information - 1-16 bytes (read only)
 *
 * update date / time - 3 bytes, from 0:00 1/1/08, lsbyte first
 */
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_FIRMWARE_LOG_ENTITY            0x01
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_FIRMWARE_LOG_FIRMWARE_VERSION  0x02
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_FIRMWARE_LOG_BRANCH            0x03
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_FIRMWARE_LOG_BUILD_INFORMATION 0x04
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_FIRMWARE_LOG_UPDATE_DATE_TIME  0x05

/* name - 1-16 bytes (read only)
 *
 * description - 1-256 bytes (read only)
 *
 * entity - 1 byte (read only)
 *
 * product info - 1-64 bytes (read only)
 *
 * firmware version - 1-16 bytes (read only)
 *
 * branch - 1-16 bytes (read only)
 *
 * build information - 1-16 bytes (read only) 
 *
 */
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_NAME              0x01
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_DESCRIPTION       0x02
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_ENTITY            0x03
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_PRODUCT_INFO      0x04
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_FIRMWARE_VERSION  0x05
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_BRANCH            0x06
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_BUILD_INFORMATION 0x07

#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_NAME_LEN              16
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_DESCRIPTION_LEN       256
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_PRODUCT_INFO_LEN      64
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_FIRMWARE_VERSION_LEN  16
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_BRANCH_LEN            16
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_BUILD_INFORMATION_LEN 16

/* remote update enable - 1 byte, ??
 *
 * protocol - 1 byte, bitmask, 7:3 reserved, 2 : http, 1: ftp, 0: tftp (read only)
 *
 * uri - 1-256 bytes
 * note - first char should be a file or unit separator
 *
 * connection retry - 1 byte, 0 = no retries
 *
 * retry interval - 1 byte, in 5 second increments
 *
 * delay time - 1 byte, in seconds, 0h = immediate, ffh = random between 5 and 10
 */
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_FIRMWARE_UPDATE_REMOTE_UPDATE_ENABLE 0x01
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_FIRMWARE_UPDATE_PROTOCOL             0x02
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_FIRMWARE_UPDATE_URI                  0x03
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_FIRMWARE_UPDATE_CONNECTION_RETRY     0x04
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_FIRMWARE_UPDATE_RETRY_INTERVAL       0x05
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_FIRMWARE_UPDATE_DELAY_TIME           0x06

#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_FIRMWARE_UPDATE_RETRY_INTERVAL_INCREMENTS 5

#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_FIRMWARE_UPDATE_URI_LEN 256

/* power management enable - 1 byte, bit 7: 0 = disable, 1 = enable, reset reserved
 *
 * power staggery ac recovery - 1 byte, 0x00 = immediate power on
 * (default), 0x01 = auto, random between min and max below, 0x02 =
 * user defined, must be between min and max below
 *
 * power on delay - 2 bytes
 *
 * minimum power on delay - 2 bytes (read only)
 *
 * maximum power on delay - 2 bytes
 */
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_POWER_MANAGEMENT_POWER_MANAGEMENT_ENABLE      0x01
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_POWER_MANAGEMENT_POWER_STAGGERING_AC_RECOVERY 0x02
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_POWER_MANAGEMENT_POWER_ON_DELAY               0x03
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_POWER_MANAGEMENT_MINIMUM_POWER_ON_DELAY       0x04
#define IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_POWER_MANAGEMENT_MAXIMUM_POWER_ON_DELAY       0x05

#define IPMI_OEM_INVENTEC_EXTENDED_CONFIG_READ_ALL_BYTES     0xFF

/* w/ IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_NIC_MODE */
#define IPMI_OEM_INVENTEC_EXTENDED_CONFIG_NIC_MODE_SHARED    0x00
#define IPMI_OEM_INVENTEC_EXTENDED_CONFIG_NIC_MODE_DEDICATED 0x01

/* w/ IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_SECURITY_SERVICE_DISABLED */
#define IPMI_OEM_INVENTEC_EXTENDED_CONFIG_SECURITY_SERVICES_DISABLED_ENABLE_ALL                   0x00
#define IPMI_OEM_INVENTEC_EXTENDED_CONFIG_SECURITY_SERVICES_DISABLED_BITMASK_ALL                  0x01
#define IPMI_OEM_INVENTEC_EXTENDED_CONFIG_SECURITY_SERVICES_DISABLED_BITMASK_KVM_VIRTUAL_STORAGE  0x02
#define IPMI_OEM_INVENTEC_EXTENDED_CONFIG_SECURITY_SERVICES_DISABLED_BITMASK_HTTP_HTTPS           0x04
#define IPMI_OEM_INVENTEC_EXTENDED_CONFIG_SECURITY_SERVICES_DISABLED_BITMASK_SSH_TELNET           0x08

/* w/ IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_ACCOUNT_STATUS_ACCOUNT_STATUS */
#define IPMI_OEM_INVENTEC_EXTENDED_CONFIG_ACCOUNT_STATUS_UNSPECIFIED 0x00
#define IPMI_OEM_INVENTEC_EXTENDED_CONFIG_ACCOUNT_STATUS_ENABLED     0x01
#define IPMI_OEM_INVENTEC_EXTENDED_CONFIG_ACCOUNT_STATUS_DISABLED    0x02
#define IPMI_OEM_INVENTEC_EXTENDED_CONFIG_ACCOUNT_STATUS_LOCKOUT     0x03

/* w/ IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_DNS_DNS_BMC_HOST_NAME */
#define IPMI_OEM_INVENTEC_EXTENDED_CONFIG_DNS_DNS_BMC_HOST_NAME_MAX 64

/* IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_DNS_DNS_DOMAIN_NAME */
#define IPMI_OEM_INVENTEC_EXTENDED_CONFIG_DNS_DNS_DOMAIN_NAME_MAX   256

/* w/ IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_ENTITY */
#define IPMI_OEM_INVENTEC_EXTENDED_CONFIG_FIRMWARE_INFORMATION_ENTITY_BMC         0
#define IPMI_OEM_INVENTEC_EXTENDED_CONFIG_FIRMWARE_INFORMATION_ENTITY_SYSTEM_BIOS 1
#define IPMI_OEM_INVENTEC_EXTENDED_CONFIG_FIRMWARE_INFORMATION_ENTITY_PDB         2
#define IPMI_OEM_INVENTEC_EXTENDED_CONFIG_FIRMWARE_INFORMATION_ENTITY_FCB         3

/* w/ IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_FIRMWARE_UPDATE_PROTOCOL */
#define IPMI_OEM_INVENTEC_EXTENDED_CONFIG_FIRMWARE_UPDATE_PROTOCOL_BITMASK_TFTP  0x01
#define IPMI_OEM_INVENTEC_EXTENDED_CONFIG_FIRMWARE_UPDATE_PROTOCOL_BITMASK_FTP   0x02
#define IPMI_OEM_INVENTEC_EXTENDED_CONFIG_FIRMWARE_UPDATE_PROTOCOL_BITMASK_HTTP  0x04

/* w/ IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_FIRMWARE_UPDATE_DELAY_TIME */
#define IPMI_OEM_INVENTEC_EXTENDED_CONFIG_FIRMWARE_UPDATE_DELAY_TIME_RANDOM 0xFF

/* w/ IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_POWER_MANAGEMENT_POWER_MANAGEMENT_ENABLE */
/* DPNM = Dynamic Power Node Management */
#define IPMI_OEM_INVENTEC_EXTENDED_CONFIG_POWER_MANAGEMENT_ENABLE_DPNM_BITMASK 0x80
#define IPMI_OEM_INVENTEC_EXTENDED_CONFIG_POWER_MANAGEMENT_ENABLE_DPNM_SHIFT   7
#define IPMI_OEM_INVENTEC_EXTENDED_CONFIG_POWER_MANAGEMENT_ENABLE_DPNM_ENABLE  1
#define IPMI_OEM_INVENTEC_EXTENDED_CONFIG_POWER_MANAGEMENT_ENABLE_DPNM_DISABLE 0

/* w/ IPMI_OEM_INVENTEC_EXTENDED_ATTRIBUTE_ID_POWER_MANAGEMENT_POWER_STAGGERING_AC_RECOVERY */
#define IPMI_OEM_INVENTEC_EXTENDED_CONFIG_POWER_STAGGERING_AC_RECOVERY_IMMEDIATE    0x00
#define IPMI_OEM_INVENTEC_EXTENDED_CONFIG_POWER_STAGGERING_AC_RECOVERY_AUTO         0x01
#define IPMI_OEM_INVENTEC_EXTENDED_CONFIG_POWER_STAGGERING_AC_RECOVERY_USER_DEFINED 0x02

/* w/ IPMI_CMD_OEM_INVENTEC_UPDATE_FIRMARE */
#define IPMI_OEM_INVENTEC_UPDATE_FIRMWARE_INTERFACE_SYSTEM_INTERFACE 0x00
#define IPMI_OEM_INVENTEC_UPDATE_FIRMWARE_INTERFACE_NETWORKING       0x01
#define IPMI_OEM_INVENTEC_UPDATE_FIRMWARE_INTERFACE_USB              0x02

#define IPMI_OEM_INVENTEC_UPDATE_FIRMWARE_UPDATE_TYPE_BITMASK 0x80
#define IPMI_OEM_INVENTEC_UPDATE_FIRMWARE_UPDATE_TYPE_SHIFT   7

#define IPMI_OEM_INVENTEC_UPDATE_FIRMWARE_UPDATE_TYPE_FORCE_UPDATE  1
#define IPMI_OEM_INVENTEC_UPDATE_FIRMWARE_UPDATE_TYPE_NORMAL_UPDATE 0

#define IPMI_OEM_INVENTEC_UPDATE_FIRMWARE_OEM_DELL_CONFIG_PRESERVE   0x00
#define IPMI_OEM_INVENTEC_UPDATE_FIRMWARE_OEM_DELL_CONFIG_NOPRESERVE 0x01

/* w/ IPMI_CMD_OEM_INVENTEC_GET_UPDATE_STATUS */
#define IPMI_OEM_INVENTEC_GET_UPDATE_STATUS_TRANSMITTING_IMAGE          0x00
#define IPMI_OEM_INVENTEC_GET_UPDATE_STATUS_VALIDATING_IMAGE            0x01
#define IPMI_OEM_INVENTEC_GET_UPDATE_STATUS_PROGRAMMING                 0x02
#define IPMI_OEM_INVENTEC_GET_UPDATE_STATUS_READY_TO_ACCEPT_IMAGE       0x03
#define IPMI_OEM_INVENTEC_GET_UPDATE_STATUS_GENERAL_ERROR               0x80
#define IPMI_OEM_INVENTEC_GET_UPDATE_STATUS_CANNOT_ESTABLISH_CONNECTION 0x81
#define IPMI_OEM_INVENTEC_GET_UPDATE_STATUS_PATH_NOT_FOUND              0x82
#define IPMI_OEM_INVENTEC_GET_UPDATE_STATUS_TRANSMISSION_ABORT          0x83
#define IPMI_OEM_INVENTEC_GET_UPDATE_STATUS_CHECKSUM_ERROR              0x84
#define IPMI_OEM_INVENTEC_GET_UPDATE_STATUS_INCORRECT_PLATFORM          0x85
#define IPMI_OEM_INVENTEC_GET_UPDATE_STATUS_COMPLETED                   0xFF

/* w/ IPMI_CMD_OEM_INVENTEC_RESTORE_TO_DEFAULTS */
#define IPMI_OEM_INVENTEC_RESTORE_TO_DEFAULTS_RESTORE_FLAG_RESTORE_PARAMETERS_NOT_INCLUDED_BELOW 0x7
#define IPMI_OEM_INVENTEC_RESTORE_TO_DEFAULTS_RESTORE_FLAG_REMAINING_PARAMETERS_STAY_WHAT_IT_IS  0x0
#define IPMI_OEM_INVENTEC_RESTORE_TO_DEFAULTS_RESTORE_FLAG_SHIFT                                 5

#define IPMI_OEM_INVENTEC_RESTORE_TO_DEFAULTS_PEF_BITMASK                  0x10
#define IPMI_OEM_INVENTEC_RESTORE_TO_DEFAULTS_SERIAL_CONFIGURATION_BITMASK 0x08
#define IPMI_OEM_INVENTEC_RESTORE_TO_DEFAULTS_SOL_CONFIGURATION_BITMASK    0x04
#define IPMI_OEM_INVENTEC_RESTORE_TO_DEFAULTS_LAN_CONFIGURATION_BITMASK    0x02
#define IPMI_OEM_INVENTEC_RESTORE_TO_DEFAULTS_USER_ACCOUNTS_BITMASK        0x01

/* w/ IPMI_CMD_OEM_INVENTEC_GET_RESTORE_STATUS */
#define IPMI_OEM_INVENTEC_GET_RESTORE_STATUS_RESTORE_IN_PROGRESS 0x00
#define IPMI_OEM_INVENTEC_GET_RESTORE_STATUS_RESTORE_COMPLETE    0x01

/* w/ IPMI_CMD_OEM_INVENTEC_SET_ASSET_TAG */
#define IPMI_OEM_INVENTEC_ASSET_TAG_MAX 10

/******************************************* 
 * Quanta                                  *
 *******************************************/

/*
 * Quanta S99Q/Dell FS12-TY
 */

/* achu: all named from doc except 'lan' configuration id, which I assumed names */

/* w/ IPMI_CMD_OEM_QUANTA_GET_EXTENDED_CONFIGURATION / IPMI_OEM_QUANTA_SET_EXTENDED_CONFIGURATION */

#define IPMI_OEM_QUANTA_EXTENDED_CONFIGURATION_ID_NIC                      0x02
#define IPMI_OEM_QUANTA_EXTENDED_CONFIGURATION_ID_SOL                      0x03
#define IPMI_OEM_QUANTA_EXTENDED_CONFIGURATION_ID_SECURITY                 0x04
#define IPMI_OEM_QUANTA_EXTENDED_CONFIGURATION_ID_ACCOUNT_STATUS           0x05
#define IPMI_OEM_QUANTA_EXTENDED_CONFIGURATION_ID_DNS                      0x06
#define IPMI_OEM_QUANTA_EXTENDED_CONFIGURATION_ID_WEB_SERVER_CONFIGURATION 0x0C
#define IPMI_OEM_QUANTA_EXTENDED_CONFIGURATION_ID_FIRMWARE_LOG             0x0E
#define IPMI_OEM_QUANTA_EXTENDED_CONFIGURATION_ID_FIRMWARE_INFORMATION     0x0F
#define IPMI_OEM_QUANTA_EXTENDED_CONFIGURATION_ID_FIRMWARE_UPDATE          0x10
#define IPMI_OEM_QUANTA_EXTENDED_CONFIGURATION_ID_POWER_MANAGEMENT         0x11

/* nic status - 1 byte, 0 = shared, 1 = dedicated
 */
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_NIC_MODE 0x01

/* sol idle timeout - 2 bytes, ls byte first, 0h = no timeout, default = 01h
 *
 * telnet/ssh redirect enable - 1 byte, 0 = disable, 1 = enabled 
 */
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_SOL_SOL_IDLE_TIMEOUT           0x01
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_SOL_TELNET_SSH_REDIRECT_ENABLE 0x02

/* service disabled - 1 byte, bitmask
 *                  - 0x01 = all service except IPMI are disabled
 *                           (takes precedence over other bits)
 *                  - 0x02 = KVM/Virtual Storage
 *                  - 0x04 = HTTP/HTTPS
 *                  - 0x08 = SSH/Telnet
 */
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_SECURITY_SERVICE_DISABLED            0x01

/* number of user - 1 byte, read only
 *
 * number of enabled user - 1 byte, read only
 *
 * user name - 1-17 bytes, read only
 *           - Quanta 5441/Xanadu II - reports stored as p-string, does not return p-string
 *           - Quanta 5442/Xanadu III - returns as p-string
 *
 * account status - 1 byte
 *                - 0x00 - status unspecified
 *                - 0x01 - enabled via set user password
 *                - 0x02 - disabled via set user password
 *                - 0x03 - user id is lockout
 */
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_ACCOUNT_STATUS_NUMBER_OF_USER         0x01
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_ACCOUNT_STATUS_NUMBER_OF_ENABLED_USER 0x02
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_ACCOUNT_STATUS_USER_NAME              0x03
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_ACCOUNT_STATUS_ACCOUNT_STATUS         0x04

/* DNS DHCP enable - 1 byte, 0 - false, 1 - true
 * - DNS server IP addresses should be assigned from DHCP server
 *
 * DNS Server1 - 4 bytes
 * - IP address for DNS server 1, read only if DNS DHCP Enable and DHCP are enabled
 *
 * DNS Server2 - 4 bytes
 * - IP address for DNS server 2, read only if DNS DHCP Enable and DHCP are enabled
 *
 * DNS Register BMC - 0 - false, 1 - true
 * - Enable registering the BMC host name on the DNS server
 *
 * DNS BMC Host Name - 1-64 bytes
 * - Specifies the DNS BMC host name, read only if DNS Register BMC is TRUE.
 * - Stored as P-string
 *
 * DNS Domain Name DHCP Enable - 1 byte
 * - DNS domain name should be assigned from DHCP
 *
 * DNS Domain Name - 1-256 bytes
 * - DNS domain name string, read only if DNS Domain Name DHCP Enable is TRUE
 * - Stored as P-string
 */
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_DNS_DNS_DHCP_ENABLE             0x01
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_DNS_DNS_SERVER1                 0x02
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_DNS_DNS_SERVER2                 0x03
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_DNS_DNS_REGISTER_BMC            0x04
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_DNS_DNS_BMC_HOST_NAME           0x05
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_DNS_DNS_DOMAIN_NAME_DHCP_ENABLE 0x06
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_DNS_DNS_DOMAIN_NAME             0x07

/* web server enabled - 1 byte, 0 = false, 1 = true (default)
 *
 * max web sessions - 1 byte, read only
 *
 * active web sessions - 1 byte, read only
 *
 * web server timeout - 4 bytes, in seconds, 0 = disable, range 60-1920, default 300
 *
 * http port num - 2 bytes, default 80
 *
 * https port num - 2 bytes, default 443
 */
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_WEB_SERVER_CONFIGURATION_WEB_SERVER_ENABLED  0x01
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_WEB_SERVER_CONFIGURATION_MAX_WEB_SESSIONS    0x02
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_WEB_SERVER_CONFIGURATION_ACTIVE_WEB_SESSIONS 0x03
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_WEB_SERVER_CONFIGURATION_WEB_SERVER_TIMEOUT  0x04
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_WEB_SERVER_CONFIGURATION_HTTP_PORT_NUM       0x05
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_WEB_SERVER_CONFIGURATION_HTTPS_PORT_NUM      0x06

/* entity - 1 byte (read only)
 *
 * firmware version - 1-16 bytes (read only)
 *
 * branch - 1-16 bytes (read only)
 *
 * build information - 1-16 bytes (read only)
 *
 * update date / time - 3 bytes, from 0:00 1/1/08, lsbyte first
 */
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_FIRMWARE_LOG_ENTITY            0x01
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_FIRMWARE_LOG_FIRMWARE_VERSION  0x02
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_FIRMWARE_LOG_BRANCH            0x03
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_FIRMWARE_LOG_BUILD_INFORMATION 0x04
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_FIRMWARE_LOG_UPDATE_DATE_TIME  0x05

/* name - 1-16 bytes (read only)
 *
 * description - 1-256 bytes (read only)
 *
 * entity - 1 byte (read only)
 *
 * product info - 1-64 bytes (read only)
 *
 * firmware version - 1-16 bytes (read only)
 *
 * branch - 1-16 bytes (read only)
 *
 * build information - 1-16 bytes (read only) 
 *
 */
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_NAME              0x01
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_DESCRIPTION       0x02
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_ENTITY            0x03
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_PRODUCT_INFO      0x04
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_FIRMWARE_VERSION  0x05
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_BRANCH            0x06
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_BUILD_INFORMATION 0x07

#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_NAME_LEN              16
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_DESCRIPTION_LEN       256
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_PRODUCT_INFO_LEN      64
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_FIRMWARE_VERSION_LEN  16
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_BRANCH_LEN            16
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_BUILD_INFORMATION_LEN 16

/* remote update enable - 1 byte, ??
 *
 * protocol - 1 byte, bitmask, 7:3 reserved, 2 : http, 1: ftp, 0: tftp (read only)
 *
 * uri - 1-256 bytes
 * note - first char should be a file or unit separator
 *
 * connection retry - 1 byte, 0 = no retries
 *
 * retry interval - 1 byte, in 5 second increments
 *
 * delay time - 1 byte, in seconds, 0h = immediate, ffh = random between 5 and 10
 */
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_FIRMWARE_UPDATE_REMOTE_UPDATE_ENABLE 0x01
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_FIRMWARE_UPDATE_PROTOCOL             0x02
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_FIRMWARE_UPDATE_URI                  0x03
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_FIRMWARE_UPDATE_CONNECTION_RETRY     0x04
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_FIRMWARE_UPDATE_RETRY_INTERVAL       0x05
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_FIRMWARE_UPDATE_DELAY_TIME           0x06

#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_FIRMWARE_UPDATE_RETRY_INTERVAL_INCREMENTS 5

#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_FIRMWARE_UPDATE_URI_LEN 256

/* power management enable - 1 byte, bit 7: 0 = disable, 1 = enable, reset reserved
 *
 * power staggery ac recovery - 1 byte, 0x00 = immediate power on
 * (default), 0x01 = auto, random between min and max below, 0x02 =
 * user defined, must be between min and max below
 *
 * power on delay - 2 bytes
 *
 * minimum power on delay - 2 bytes (read only)
 *
 * maximum power on delay - 2 bytes
 */
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_POWER_MANAGEMENT_POWER_MANAGEMENT_ENABLE      0x01
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_POWER_MANAGEMENT_POWER_STAGGERING_AC_RECOVERY 0x02
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_POWER_MANAGEMENT_POWER_ON_DELAY               0x03
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_POWER_MANAGEMENT_MINIMUM_POWER_ON_DELAY       0x04
#define IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_POWER_MANAGEMENT_MAXIMUM_POWER_ON_DELAY       0x05

#define IPMI_OEM_QUANTA_EXTENDED_CONFIG_READ_ALL_BYTES     0xFF

/* w/ IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_NIC_MODE */
#define IPMI_OEM_QUANTA_EXTENDED_CONFIG_NIC_MODE_SHARED    0x00
#define IPMI_OEM_QUANTA_EXTENDED_CONFIG_NIC_MODE_DEDICATED 0x01

/* w/ IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_SECURITY_SERVICE_DISABLED */
#define IPMI_OEM_QUANTA_EXTENDED_CONFIG_SECURITY_SERVICES_DISABLED_ENABLE_ALL                   0x00
#define IPMI_OEM_QUANTA_EXTENDED_CONFIG_SECURITY_SERVICES_DISABLED_BITMASK_ALL                  0x01
#define IPMI_OEM_QUANTA_EXTENDED_CONFIG_SECURITY_SERVICES_DISABLED_BITMASK_KVM_VIRTUAL_STORAGE  0x02
#define IPMI_OEM_QUANTA_EXTENDED_CONFIG_SECURITY_SERVICES_DISABLED_BITMASK_HTTP_HTTPS           0x04
#define IPMI_OEM_QUANTA_EXTENDED_CONFIG_SECURITY_SERVICES_DISABLED_BITMASK_SSH_TELNET           0x08

/* w/ IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_ACCOUNT_STATUS_ACCOUNT_STATUS */
#define IPMI_OEM_QUANTA_EXTENDED_CONFIG_ACCOUNT_STATUS_UNSPECIFIED 0x00
#define IPMI_OEM_QUANTA_EXTENDED_CONFIG_ACCOUNT_STATUS_ENABLED     0x01
#define IPMI_OEM_QUANTA_EXTENDED_CONFIG_ACCOUNT_STATUS_DISABLED    0x02
#define IPMI_OEM_QUANTA_EXTENDED_CONFIG_ACCOUNT_STATUS_LOCKOUT     0x03

/* w/ IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_DNS_DNS_BMC_HOST_NAME */
#define IPMI_OEM_QUANTA_EXTENDED_CONFIG_DNS_DNS_BMC_HOST_NAME_MAX 64

/* IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_DNS_DNS_DOMAIN_NAME */
#define IPMI_OEM_QUANTA_EXTENDED_CONFIG_DNS_DNS_DOMAIN_NAME_MAX   256

/* w/ IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_ENTITY */
#define IPMI_OEM_QUANTA_EXTENDED_CONFIG_FIRMWARE_INFORMATION_ENTITY_BMC         0
#define IPMI_OEM_QUANTA_EXTENDED_CONFIG_FIRMWARE_INFORMATION_ENTITY_SYSTEM_BIOS 1
#define IPMI_OEM_QUANTA_EXTENDED_CONFIG_FIRMWARE_INFORMATION_ENTITY_PDB         2
#define IPMI_OEM_QUANTA_EXTENDED_CONFIG_FIRMWARE_INFORMATION_ENTITY_FCB         3

/* w/ IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_FIRMWARE_UPDATE_PROTOCOL */
#define IPMI_OEM_QUANTA_EXTENDED_CONFIG_FIRMWARE_UPDATE_PROTOCOL_BITMASK_TFTP  0x01
#define IPMI_OEM_QUANTA_EXTENDED_CONFIG_FIRMWARE_UPDATE_PROTOCOL_BITMASK_FTP   0x02
#define IPMI_OEM_QUANTA_EXTENDED_CONFIG_FIRMWARE_UPDATE_PROTOCOL_BITMASK_HTTP  0x04

/* w/ IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_FIRMWARE_UPDATE_DELAY_TIME */
#define IPMI_OEM_QUANTA_EXTENDED_CONFIG_FIRMWARE_UPDATE_DELAY_TIME_RANDOM 0xFF

/* w/ IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_POWER_MANAGEMENT_POWER_MANAGEMENT_ENABLE */
/* DPNM = Dynamic Power Node Management */
#define IPMI_OEM_QUANTA_EXTENDED_CONFIG_POWER_MANAGEMENT_ENABLE_DPNM_BITMASK 0x80
#define IPMI_OEM_QUANTA_EXTENDED_CONFIG_POWER_MANAGEMENT_ENABLE_DPNM_SHIFT   7
#define IPMI_OEM_QUANTA_EXTENDED_CONFIG_POWER_MANAGEMENT_ENABLE_DPNM_ENABLE  1
#define IPMI_OEM_QUANTA_EXTENDED_CONFIG_POWER_MANAGEMENT_ENABLE_DPNM_DISABLE 0

/* w/ IPMI_OEM_QUANTA_EXTENDED_ATTRIBUTE_ID_POWER_MANAGEMENT_POWER_STAGGERING_AC_RECOVERY */
#define IPMI_OEM_QUANTA_EXTENDED_CONFIG_POWER_STAGGERING_AC_RECOVERY_IMMEDIATE    0x00
#define IPMI_OEM_QUANTA_EXTENDED_CONFIG_POWER_STAGGERING_AC_RECOVERY_AUTO         0x01
#define IPMI_OEM_QUANTA_EXTENDED_CONFIG_POWER_STAGGERING_AC_RECOVERY_USER_DEFINED 0x02


/* w/ IPMI_CMD_OEM_QUANTA_RESET_TO_DEFAULTS */ 
#define IPMI_OEM_QUANTA_RESET_TO_DEFAULTS_RESTORE_FLAG_RESTORE_PARAMETERS_NOT_INCLUDED_BELOW 0x7
#define IPMI_OEM_QUANTA_RESET_TO_DEFAULTS_RESTORE_FLAG_REMAINING_PARAMETERS_STAY_WHAT_IT_IS  0x0
#define IPMI_OEM_QUANTA_RESET_TO_DEFAULTS_RESTORE_FLAG_SHIFT                                 5

#define IPMI_OEM_QUANTA_RESET_TO_DEFAULTS_PEF_BITMASK                  0x10
#define IPMI_OEM_QUANTA_RESET_TO_DEFAULTS_SERIAL_CONFIGURATION_BITMASK 0x08
#define IPMI_OEM_QUANTA_RESET_TO_DEFAULTS_SOL_CONFIGURATION_BITMASK    0x04
#define IPMI_OEM_QUANTA_RESET_TO_DEFAULTS_LAN_CONFIGURATION_BITMASK    0x02
#define IPMI_OEM_QUANTA_RESET_TO_DEFAULTS_USER_ACCOUNTS_BITMASK        0x01

/* w/ IPMI_CMD_OEM_QUANTA_GET_RESTORE_STATUS */
#define IPMI_OEM_QUANTA_GET_RESTORE_STATUS_RESTORE_IN_PROGRESS 0x00
#define IPMI_OEM_QUANTA_GET_RESTORE_STATUS_RESTORE_COMPLETE    0x01

/* w/ IPMI_CMD_OEM_QUANTA_GET_PROCESSOR_INFORMATION */
#define IPMI_OEM_QUANTA_PROCESSOR_TYPE_CELERON        0x00
#define IPMI_OEM_QUANTA_PROCESSOR_TYPE_PENTIUM_3      0x01
#define IPMI_OEM_QUANTA_PROCESSOR_TYPE_PENTIUM_4      0x02
#define IPMI_OEM_QUANTA_PROCESSOR_TYPE_XEON           0x03
#define IPMI_OEM_QUANTA_PROCESSOR_TYPE_PRESTONIA      0x04
#define IPMI_OEM_QUANTA_PROCESSOR_TYPE_NOCONA         0x05
#define IPMI_OEM_QUANTA_PROCESSOR_TYPE_OPTERON        0x06
#define IPMI_OEM_QUANTA_PROCESSOR_TYPE_DEMPSEY        0x07
#define IPMI_OEM_QUANTA_PROCESSOR_TYPE_CLOVERTOWN     0x08
#define IPMI_OEM_QUANTA_PROCESSOR_TYPE_TIGERTON       0x09
#define IPMI_OEM_QUANTA_PROCESSOR_TYPE_DUNNINGTON     0x0A
/* achu: listed as "Hapertown" in spec, assuming typo */
#define IPMI_OEM_QUANTA_PROCESSOR_TYPE_HARPERTOWN     0x0B
#define IPMI_OEM_QUANTA_PROCESSOR_TYPE_WOLFDALE_DP    0x0C
#define IPMI_OEM_QUANTA_PROCESSOR_TYPE_NEHALEM_EP     0x0D
#define IPMI_OEM_QUANTA_PROCESSOR_TYPE_WESTMERE_EP    0x0E
/* 0x0F-0xFE - Reserved */
#define IPMI_OEM_QUANTA_PROCESSOR_TYPE_NO_CPU_PRESENT 0xFF

/******************************************* 
 * Sun Microsystems                        *
 *******************************************/
  
/*
 * Sun 4140
 */

/* w/ IPMI_CMD_OEM_SUN_GET_LED / IPMI_CMD_OEM_SUN_SET_LED */
#define IPMI_OEM_SUN_LED_MODE_OFF     0
#define IPMI_OEM_SUN_LED_MODE_ON      1
#define IPMI_OEM_SUN_LED_MODE_STANDBY 2
#define IPMI_OEM_SUN_LED_MODE_SLOW    3
#define IPMI_OEM_SUN_LED_MODE_FAST    4

#define IPMI_OEM_SUN_LED_FORCE_GO_THRU_CONTROLLER     0
#define IPMI_OEM_SUN_LED_FORCE_DIRECTLY_ACCESS_DEVICE 1

/******************************************* 
 * Supermicro                              *
 *******************************************/
  
/*
 * Supermicro X8DTG
 */

/* w/ IPMI_CMD_OEM_SUPERMICRO_GENERIC_EXTENSION */
#define IPMI_OEM_SUPERMICRO_SUB_COMMAND_BMC_SERVICES 0xF0

/* w/ IPMI_OEM_SUPERMICRO_SUB_COMMAND_BMC_SERVICES */
#define IPMI_OEM_SUPERMICRO_BMC_SERVICES_ACTION_DISABLE  0x00
#define IPMI_OEM_SUPERMICRO_BMC_SERVICES_ACTION_ENABLE   0x01
#define IPMI_OEM_SUPERMICRO_BMC_SERVICES_ACTION_STATUS   0x02

#define IPMI_OEM_SUPERMICRO_BMC_SERVICES_STATUS_DISABLED 0x00
#define IPMI_OEM_SUPERMICRO_BMC_SERVICES_STATUS_ENABLED  0x01

/*
 * Supermicro X8DTU, X8STi, X9DRW
 */

#define IPMI_OEM_SUPERMICRO_GET_POWER_SUPPLY_STATUS_CHANNEL 0x07
#define IPMI_OEM_SUPERMICRO_GET_POWER_SUPPLY_STATUS_PS1     0x70
#define IPMI_OEM_SUPERMICRO_GET_POWER_SUPPLY_STATUS_PS2     0x72
#define IPMI_OEM_SUPERMICRO_GET_POWER_SUPPLY_STATUS_PS3     0x74
#define IPMI_OEM_SUPERMICRO_GET_POWER_SUPPLY_STATUS_MAGIC   0x0C
#define IPMI_OEM_SUPERMICRO_GET_POWER_SUPPLY_STATUS_GOOD    0x01
#define IPMI_OEM_SUPERMICRO_GET_POWER_SUPPLY_STATUS_BAD     0x00

#define IPMI_OEM_SUPERMICRO_GET_PMBUS_POWER_SUPPLY_STATUS_CHANNEL 0x07
#define IPMI_OEM_SUPERMICRO_GET_PMBUS_POWER_SUPPLY_STATUS_PS1     0x78
#define IPMI_OEM_SUPERMICRO_GET_PMBUS_POWER_SUPPLY_STATUS_PS2     0x7A
#define IPMI_OEM_SUPERMICRO_GET_PMBUS_POWER_SUPPLY_STATUS_PS3     0x7C
#define IPMI_OEM_SUPERMICRO_GET_PMBUS_POWER_SUPPLY_STATUS_MAGIC   0x78
#define IPMI_OEM_SUPERMICRO_GET_PMBUS_POWER_SUPPLY_STATUS_GOOD    0x01
#define IPMI_OEM_SUPERMICRO_GET_PMBUS_POWER_SUPPLY_STATUS_BAD     0x00

/*
 * Supermicro X10DRU-i+
 */

#define IPMI_OEM_SUPERMICRO_GET_POWER_SUPPLY_STATUS2_CHANNEL 0x07
#define IPMI_OEM_SUPERMICRO_GET_POWER_SUPPLY_STATUS2_PS1     0xB0
#define IPMI_OEM_SUPERMICRO_GET_POWER_SUPPLY_STATUS2_PS2     0xB2
#define IPMI_OEM_SUPERMICRO_GET_POWER_SUPPLY_STATUS2_MAGIC   0x79
/* achu: Both of these mean good ... yeah, makes no sense :P */
#define IPMI_OEM_SUPERMICRO_GET_POWER_SUPPLY_STATUS2_GOOD1   0x00
#define IPMI_OEM_SUPERMICRO_GET_POWER_SUPPLY_STATUS2_GOOD2   0x02

/******************************************* 
 * Wistron                                 *
 *******************************************/

/*
 * Wistron / Dell Poweredge C6220
 */

/* achu: all named from doc except 'lan' configuration id, which I assumed names */

/* w/ IPMI_CMD_OEM_WISTRON_GET_EXTENDED_CONFIGURATION / IPMI_OEM_WISTRON_SET_EXTENDED_CONFIGURATION */

#define IPMI_OEM_WISTRON_EXTENDED_CONFIGURATION_ID_NIC                      0x02
#define IPMI_OEM_WISTRON_EXTENDED_CONFIGURATION_ID_SOL                      0x03
#define IPMI_OEM_WISTRON_EXTENDED_CONFIGURATION_ID_SECURITY                 0x04
#define IPMI_OEM_WISTRON_EXTENDED_CONFIGURATION_ID_ACCOUNT_STATUS           0x05
#define IPMI_OEM_WISTRON_EXTENDED_CONFIGURATION_ID_DNS                      0x06
#define IPMI_OEM_WISTRON_EXTENDED_CONFIGURATION_ID_WEB_SERVER_CONFIGURATION 0x0C
#define IPMI_OEM_WISTRON_EXTENDED_CONFIGURATION_ID_FIRMWARE_LOG             0x0E
#define IPMI_OEM_WISTRON_EXTENDED_CONFIGURATION_ID_FIRMWARE_INFORMATION     0x0F
#define IPMI_OEM_WISTRON_EXTENDED_CONFIGURATION_ID_FIRMWARE_UPDATE          0x10
#define IPMI_OEM_WISTRON_EXTENDED_CONFIGURATION_ID_POWER_MANAGEMENT         0x11
#define IPMI_OEM_WISTRON_EXTENDED_CONFIGURATION_ID_IPV6_SETTING             0xC0
#define IPMI_OEM_WISTRON_EXTENDED_CONFIGURATION_ID_IPV6_TRAP_SETTING        0xC1

/* nic selection - 1 byte, 0 = shared, 1 = dedicated
 *
 * shared nic selection - 1 byte, 0 = reerved, 1 = nic1, ..., 4 = nic4
 * - for when nic selection is shared 
 */
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_NIC_SELECTION            0x01
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_NIC_SHARED_NIC_SELECTION 0x02

/* sol idle timeout - 2 bytes, ls byte first, 0h = no timeout, default = 01h
 *
 * telnet redirect function selection - 1 byte, 0 = disable, 1 = sol enabled , 2 = smash enabled
 *
 * ssh redirect function selection - 1 byte, 0 = disable, 1 = sol enabled , 2 = smash enabled
 */
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_SOL_SOL_IDLE_TIMEOUT                   0x01
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_SOL_TELNET_REDIRECT_FUNCTION_SELECTION 0x02
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_SOL_SSH_REDIRECT_FUNCTION_SELECTION    0x03

/* service disabled - 1 byte, bitmask
 *                  - 0x01 = all service except IPMI are disabled
 *                           (takes precedence over other bits)
 *                  - 0x02 = KVM/Virtual Storage
 *                  - 0x04 = HTTP/HTTPS
 *                  - 0x08 = SSH
 *                  - 0x10 = SNMP v2c agent
 *                  - 0x20 = telnet
 */
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_SECURITY_SERVICE_DISABLED            0x01

/* number of user - 1 byte, read only
 *
 * number of enabled user - 1 byte, read only
 *
 * user name - 1-17 bytes, read only
 *           - Wistron 5441/Xanadu II - reports stored as p-string, does not return p-string
 *           - Wistron 5442/Xanadu III - returns as p-string
 *
 * account status - 1 byte
 *                - 0x00 - status unspecified
 *                - 0x01 - enabled via set user password
 *                - 0x02 - disabled via set user password
 *                - 0x03 - user id is lockout
 */
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_ACCOUNT_STATUS_NUMBER_OF_USER         0x01
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_ACCOUNT_STATUS_NUMBER_OF_ENABLED_USER 0x02
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_ACCOUNT_STATUS_USER_NAME              0x03
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_ACCOUNT_STATUS_ACCOUNT_STATUS         0x04

/* DNS DHCP enable - 1 byte, 0 - false, 1 - true
 * - DNS server IP addresses should be assigned from DHCP server
 *
 * DNS Server1 - 4 bytes
 * - IP address for DNS server 1, read only if DNS DHCP Enable and DHCP are enabled
 *
 * DNS Server2 - 4 bytes
 * - IP address for DNS server 2, read only if DNS DHCP Enable and DHCP are enabled
 *
 * DNS Register BMC - 0 - false, 1 - true
 * - Enable registering the BMC host name on the DNS server
 *
 * DNS BMC Host Name - 1-64 bytes
 * - Specifies the DNS BMC host name, read only if DNS Register BMC is TRUE.
 * - Stored as P-string
 *
 * DNS Domain Name DHCP Enable - 1 byte
 * - DNS domain name should be assigned from DHCP
 *
 * DNS Domain Name - 1-256 bytes
 * - DNS domain name string, read only if DNS Domain Name DHCP Enable is TRUE
 * - Stored as P-string
 *
 * DNS Registration Delay - 1 byte (range 1-255)
 * - Delay BMC should take after the IPMI process is up and running.
   - Default 5 seconds.
 */
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_DNS_DNS_DHCP_ENABLE             0x01
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_DNS_DNS_SERVER1                 0x02
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_DNS_DNS_SERVER2                 0x03
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_DNS_DNS_REGISTER_BMC            0x04
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_DNS_DNS_BMC_HOST_NAME           0x05
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_DNS_DNS_DOMAIN_NAME_DHCP_ENABLE 0x06
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_DNS_DNS_DOMAIN_NAME             0x07
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_DNS_DNS_REGISTRATION_DELAY      0x08

/* web server enabled - 1 byte, 0 = false, 1 = true (default)
 *
 * max web sessions - 1 byte, read only
 *
 * active web sessions - 1 byte, read only
 *
 * web server timeout - 4 bytes, in seconds, 0 = disable, range 60-1920, default 300
 *
 * http port num - 2 bytes, default 80
 *
 * https port num - 2 bytes, default 443
 *
 * kvm port num - 2 bytes, default 7578
 *
 * telnet port num - 2 bytes, default 23
 *
 * ssh port num - 2 bytes, default 22 
 */
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_WEB_SERVER_CONFIGURATION_WEB_SERVER_ENABLED  0x01
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_WEB_SERVER_CONFIGURATION_MAX_WEB_SESSIONS    0x02
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_WEB_SERVER_CONFIGURATION_ACTIVE_WEB_SESSIONS 0x03
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_WEB_SERVER_CONFIGURATION_WEB_SERVER_TIMEOUT  0x04
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_WEB_SERVER_CONFIGURATION_HTTP_PORT_NUM       0x05
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_WEB_SERVER_CONFIGURATION_HTTPS_PORT_NUM      0x06
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_WEB_SERVER_CONFIGURATION_KVM_PORT_NUM        0x07
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_WEB_SERVER_CONFIGURATION_TELNET_PORT_NUM     0x08
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_WEB_SERVER_CONFIGURATION_SSH_PORT_NUM        0x09

/* entity - 1 byte (read only)
 *
 * firmware version - 1-16 bytes (read only)
 *
 * branch - 1-16 bytes (read only)
 *
 * build information - 1-16 bytes (read only)
 *
 * update date / time - 3 bytes, from 0:00 1/1/08, lsbyte first
 */
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_FIRMWARE_LOG_ENTITY            0x01
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_FIRMWARE_LOG_FIRMWARE_VERSION  0x02
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_FIRMWARE_LOG_BRANCH            0x03
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_FIRMWARE_LOG_BUILD_INFORMATION 0x04
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_FIRMWARE_LOG_UPDATE_DATE_TIME  0x05

/* name - 1-16 bytes (read only)
 *
 * description - 1-256 bytes (read only)
 *
 * entity - 1 byte (read only)
 *
 * product info - 1-64 bytes (read only)
 *
 * firmware version - 1-16 bytes (read only)
 *
 * branch - 1-16 bytes (read only)
 *
 * build information - 1-16 bytes (read only) 
 *
 * user default setting - 1 byte (write only)
 *
 */
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_NAME                 0x01
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_DESCRIPTION          0x02
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_ENTITY               0x03
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_PRODUCT_INFO         0x04
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_FIRMWARE_VERSION     0x05
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_BRANCH               0x06
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_BUILD_INFORMATION    0x07
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_USER_DEFAULT_SETTING 0x08

#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_NAME_LEN              16
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_DESCRIPTION_LEN       256
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_PRODUCT_INFO_LEN      64
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_FIRMWARE_VERSION_LEN  16
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_BRANCH_LEN            16
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_BUILD_INFORMATION_LEN 16

/* remote update enable - 1 byte, ??
 *
 * protocol - 1 byte, bitmask, 7:3 reserved, 2 : http, 1: ftp, 0: tftp (read only)
 *
 * uri - 1-256 bytes
 * note - first char should be a file or unit separator
 *
 * connection retry - 1 byte, 0 = no retries
 *
 * retry interval - 1 byte, in 5 second increments, defalut 01h
 *
 * delay time - 1 byte, in seconds, 0h = immediate, ffh = random between 5 and 10
 */
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_FIRMWARE_UPDATE_REMOTE_UPDATE_ENABLE 0x01
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_FIRMWARE_UPDATE_PROTOCOL             0x02
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_FIRMWARE_UPDATE_URI                  0x03
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_FIRMWARE_UPDATE_CONNECTION_RETRY     0x04
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_FIRMWARE_UPDATE_RETRY_INTERVAL       0x05
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_FIRMWARE_UPDATE_DELAY_TIME           0x06

#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_FIRMWARE_UPDATE_RETRY_INTERVAL_INCREMENTS 5

#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_FIRMWARE_UPDATE_URI_LEN 256

/* power staggery ac recovery - 1 byte, 0x00 = immediate power on
 * (default), 0x01 = auto, random between min and max below, 0x02 =
 * user defined, must be between min and max below
 *
 * power on delay - 2 bytes
 *
 * minimum power on delay - 2 bytes (read only)
 *
 * maximum power on delay - 2 bytes
 */
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_POWER_MANAGEMENT_POWER_STAGGERING_AC_RECOVERY 0x02
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_POWER_MANAGEMENT_POWER_ON_DELAY               0x03
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_POWER_MANAGEMENT_MINIMUM_POWER_ON_DELAY       0x04
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_POWER_MANAGEMENT_MAXIMUM_POWER_ON_DELAY       0x05

/* ipv6 enable - 1 byte, 0 = false, 1 = true
 *
 * ipv6 address - 1-40 bytes (read only if autoconfig is true)
 *
 * ipv6 gateway ip - 1-40 bytes
 *
 * ipv6 prefix length - 1 byte
 *
 * ipv6 autoconfig - 1 byte, 0 = false, 1 = true
 *
 * ipv6 link local address - 1-40 bytes (read only)
 *
 * ipv6 auto dns - 1 byte, 0 = false, 1 = true (can't set to 1 if autoconfig is false)
 *
 * ipv6 dns server 1 - 1-40 bytes (can't set if auto dns is true)
 *
 * ipv6 dns server 2 - 1-40 bytes (can't set if auto dns is true)
 */
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_IPV6_SETTING_IPV6_ENABLE             0x01
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_IPV6_SETTING_IPV6_ADDRESS            0x02 
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_IPV6_SETTING_IPV6_GATEWAY_IP_ADDRESS 0x03
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_IPV6_SETTING_IPV6_PREFIX_LENGTH      0x04
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_IPV6_SETTING_IPV6_AUTOCONFIG         0x05
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_IPV6_SETTING_IPV6_LINK_LOCAL_ADDRESS 0x06
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_IPV6_SETTING_IPV6_AUTO_DNS           0x07
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_IPV6_SETTING_IPV6_DNS_SERVER1        0x08
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_IPV6_SETTING_IPV6_DNS_SERVER2        0x09

#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_IPV6_SETTING_IPV6_ADDRESS_LEN            40
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_IPV6_SETTING_IPV6_GATEWAY_IP_ADDRESS_LEN 40
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_IPV6_SETTING_IPV6_LINK_LOCAL_ADDRESS_LEN 40
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_IPV6_SETTING_IPV6_DNS_SERVER1_LEN        40
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_IPV6_SETTING_IPV6_DNS_SERVER2_LEN        40

/* ipv6 snmp trap destination setting - 3 bytes
 * byte 1 - destination type
 * byte 2 - alert ack timeout
 * byte 3 - retries
 *
 * ipv6 snmp trap destination address - 1-40 bytes
 *
 * number of ipv6 snmp trap desitnations - 1 byte (read only)
 */
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_IPV6_SNMP_TRAP_DESTINATION_SETTING   0x01
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_IPV6_SNMP_TRAP_DESTINATION_ADDRESS   0x02
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_NUMBER_OF_IPV6_SNMP_TRAP_DESTINATION 0x03

#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_IPV6_SNMP_TRAP_DESTINATION_ADDRESS_LEN 40

#define IPMI_OEM_WISTRON_EXTENDED_CONFIG_READ_ALL_BYTES     0xFF

/* w/ IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_NIC_SELECTION */
#define IPMI_OEM_WISTRON_EXTENDED_CONFIG_NIC_MODE_SHARED    0x00
#define IPMI_OEM_WISTRON_EXTENDED_CONFIG_NIC_MODE_DEDICATED 0x01

/* w/ IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_NIC_SHARED_NIC_SELECTION */
/* 0h - recommended when nic selection is dedicated */
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_NIC_SHARED_NIC_SELECTION_RESERVED 0x00
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_NIC_SHARED_NIC_SELECTION_NIC_1    0x01
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_NIC_SHARED_NIC_SELECTION_NIC_2    0x02
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_NIC_SHARED_NIC_SELECTION_NIC_3    0x03
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_NIC_SHARED_NIC_SELECTION_NIC_4    0x04

/* w/ IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_SOL_TELNET_REDIRECT_FUNCTION_SELECTION */
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_SOL_TELNET_REDIRECT_FUNCTION_SELECTION_DISABLE       0x00
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_SOL_TELNET_REDIRECT_FUNCTION_SELECTION_SOL_ENABLED   0x01
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_SOL_TELNET_REDIRECT_FUNCTION_SELECTION_SMASH_ENABLED 0x02

/* w/ IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_SOL_SSH_REDIRECT_FUNCTION_SELECTION */
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_SOL_SSH_REDIRECT_FUNCTION_SELECTION_DISABLE       0x00
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_SOL_SSH_REDIRECT_FUNCTION_SELECTION_SOL_ENABLED   0x01
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_SOL_SSH_REDIRECT_FUNCTION_SELECTION_SMASH_ENABLED 0x02

/* w/ IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_SECURITY_SERVICE_DISABLED */
#define IPMI_OEM_WISTRON_EXTENDED_CONFIG_SECURITY_SERVICES_DISABLED_ENABLE_ALL                     0x00
#define IPMI_OEM_WISTRON_EXTENDED_CONFIG_SECURITY_SERVICES_DISABLED_BITMASK_ALL                    0x01
#define IPMI_OEM_WISTRON_EXTENDED_CONFIG_SECURITY_SERVICES_DISABLED_BITMASK_KVM_VIRTUAL_STORAGE    0x02
#define IPMI_OEM_WISTRON_EXTENDED_CONFIG_SECURITY_SERVICES_DISABLED_BITMASK_HTTP_HTTPS             0x04
#define IPMI_OEM_WISTRON_EXTENDED_CONFIG_SECURITY_SERVICES_DISABLED_BITMASK_SSH                    0x08
#define IPMI_OEM_WISTRON_EXTENDED_CONFIG_SECURITY_SERVICES_DISABLED_BITMASK_SNMP_V2C_AGENT         0x10
#define IPMI_OEM_WISTRON_EXTENDED_CONFIG_SECURITY_SERVICES_DISABLED_BITMASK_TELNET                 0x20

/* w/ IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_ACCOUNT_STATUS_ACCOUNT_STATUS */
#define IPMI_OEM_WISTRON_EXTENDED_CONFIG_ACCOUNT_STATUS_UNSPECIFIED 0x00
#define IPMI_OEM_WISTRON_EXTENDED_CONFIG_ACCOUNT_STATUS_ENABLED     0x01
#define IPMI_OEM_WISTRON_EXTENDED_CONFIG_ACCOUNT_STATUS_DISABLED    0x02
#define IPMI_OEM_WISTRON_EXTENDED_CONFIG_ACCOUNT_STATUS_LOCKOUT     0x03

/* w/ IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_DNS_DNS_BMC_HOST_NAME */
#define IPMI_OEM_WISTRON_EXTENDED_CONFIG_DNS_DNS_BMC_HOST_NAME_MAX 64

/* IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_DNS_DNS_DOMAIN_NAME */
#define IPMI_OEM_WISTRON_EXTENDED_CONFIG_DNS_DNS_DOMAIN_NAME_MAX   256

/* w/ IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_ENTITY */
#define IPMI_OEM_WISTRON_EXTENDED_CONFIG_FIRMWARE_INFORMATION_ENTITY_BMC         0
#define IPMI_OEM_WISTRON_EXTENDED_CONFIG_FIRMWARE_INFORMATION_ENTITY_SYSTEM_BIOS 1
#define IPMI_OEM_WISTRON_EXTENDED_CONFIG_FIRMWARE_INFORMATION_ENTITY_PDB         2
#define IPMI_OEM_WISTRON_EXTENDED_CONFIG_FIRMWARE_INFORMATION_ENTITY_FCB         3

/* w/ IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_USER_DEFAULT_SETTING */
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_USER_DEFAULT_SETTING_SET_DEFAULT     0x0
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_FIRMWARE_INFORMATION_USER_DEFAULT_SETTING_RESTORE_DEFAULT 0x1

/* w/ IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_FIRMWARE_UPDATE_REMOTE_UPDATE_ENABLE */
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_FIRMWARE_UPDATE_REMOTE_UPDATE_DISABLE 0x00
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_FIRMWARE_UPDATE_REMOTE_UPDATE_ENABLE  0x01

/* w/ IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_FIRMWARE_UPDATE_PROTOCOL */
#define IPMI_OEM_WISTRON_EXTENDED_CONFIG_FIRMWARE_UPDATE_PROTOCOL_BITMASK_TFTP  0x01
#define IPMI_OEM_WISTRON_EXTENDED_CONFIG_FIRMWARE_UPDATE_PROTOCOL_BITMASK_FTP   0x02
#define IPMI_OEM_WISTRON_EXTENDED_CONFIG_FIRMWARE_UPDATE_PROTOCOL_BITMASK_HTTP  0x04

/* w/ IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_FIRMWARE_UPDATE_DELAY_TIME */
#define IPMI_OEM_WISTRON_EXTENDED_CONFIG_FIRMWARE_UPDATE_DELAY_TIME_RANDOM 0xFF

/* w/ IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_POWER_MANAGEMENT_POWER_STAGGERING_AC_RECOVERY */
#define IPMI_OEM_WISTRON_EXTENDED_CONFIG_POWER_STAGGERING_AC_RECOVERY_IMMEDIATE    0x00
#define IPMI_OEM_WISTRON_EXTENDED_CONFIG_POWER_STAGGERING_AC_RECOVERY_AUTO         0x01
#define IPMI_OEM_WISTRON_EXTENDED_CONFIG_POWER_STAGGERING_AC_RECOVERY_USER_DEFINED 0x02

/* w/ IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_IPV6_SETTING_IPV6_ENABLE */
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_IPV6_SETTING_IPV6_ENABLE_FALSE 0
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_IPV6_SETTING_IPV6_ENABLE_TRUE  1

/* w/ #define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_IPV6_SETTING_IPV6_AUTOCONFIG */
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_IPV6_SETTING_IPV6_AUTOCONFIG_ENABLE_FALSE 0
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_IPV6_SETTING_IPV6_AUTOCONFIG_ENABLE_TRUE  1 

/* w/ #define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_IPV6_SETTING_IPV6_AUTO_DNS */
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_IPV6_SETTING_IPV6_AUTO_DNS_ENABLE_FALSE 0
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_IPV6_SETTING_IPV6_AUTO_DNS_ENABLE_TRUE  1 

/* w/ IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_IPV6_SNMP_TRAP_DESTINATION_SETTING */
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_IPV6_SNMP_TRAP_DESTINATION_SETTING_DESTINATION_TYPE_PET IPMI_DESTINATION_TYPE_PET_TRAP_DESTINATION
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_IPV6_SNMP_TRAP_DESTINATION_SETTING_DESTINATION_TYPE_OEM1 IPMI_DESTINATION_TYPE_OEM1
#define IPMI_OEM_WISTRON_EXTENDED_ATTRIBUTE_ID_IPV6_SNMP_TRAP_DESTINATION_SETTING_DESTINATION_TYPE_OEM2 IPMI_DESTINATION_TYPE_OEM2

/* w/ IPMI_CMD_OEM_WISTRON_RESET_TO_DEFAULTS */ 
#define IPMI_OEM_WISTRON_RESET_TO_DEFAULTS_RESTORE_FLAG_RESTORE_PARAMETERS_NOT_INCLUDED_BELOW 0x7
#define IPMI_OEM_WISTRON_RESET_TO_DEFAULTS_RESTORE_FLAG_REMAINING_PARAMETERS_STAY_WHAT_IT_IS  0x0
#define IPMI_OEM_WISTRON_RESET_TO_DEFAULTS_RESTORE_FLAG_SHIFT                                 5

#define IPMI_OEM_WISTRON_RESET_TO_DEFAULTS_PEF_BITMASK                  0x10
#define IPMI_OEM_WISTRON_RESET_TO_DEFAULTS_SERIAL_CONFIGURATION_BITMASK 0x08
#define IPMI_OEM_WISTRON_RESET_TO_DEFAULTS_SOL_CONFIGURATION_BITMASK    0x04
#define IPMI_OEM_WISTRON_RESET_TO_DEFAULTS_LAN_CONFIGURATION_BITMASK    0x02
#define IPMI_OEM_WISTRON_RESET_TO_DEFAULTS_USER_ACCOUNTS_BITMASK        0x01

#define IPMI_OEM_WISTRON_RESET_TO_DEFAULTS_RESTORE_ALL_SC_SETTINGS      0xFF

/* w/ IPMI_CMD_OEM_WISTRON_GET_RESTORE_STATUS */
#define IPMI_OEM_WISTRON_GET_RESTORE_STATUS_RESTORE_IN_PROGRESS 0x00
#define IPMI_OEM_WISTRON_GET_RESTORE_STATUS_RESTORE_COMPLETE    0x01

/* w/ IPMI_CMD_OEM_WISTRON_SET_CHASSIS_SERVICE_TAG and IPMI_CMD_OEM_WISTRON_GET_CHASSIS_SERVICE_TAG */
#define IPMI_OEM_WISTRON_SC_BMC_COMMUNICATION_PROTOCOL_VERSION 0x01

#define IPMI_OEM_WISTRON_CHASSIS_IDENTIFICATION_LED_CONTROLLED_BY_SC_BITMASK 0x01
#define IPMI_OEM_WISTRON_CHASSIS_IDENTIFICATION_LED_CONTROLLED_BY_SC_SHIFT   0

#define IPMI_OEM_WISTRON_CHASSIS_FAULT_LED_CONTROLLED_BY_SC_BITMASK 0x02
#define IPMI_OEM_WISTRON_CHASSIS_FAULT_LED_CONTROLLED_BY_SC_SHIFT   1

#define IPMI_OEM_WISTRON_CHASSIS_LED_OFF      0x00
#define IPMI_OEM_WISTRON_CHASSIS_LED_SOLID_ON 0x01
#define IPMI_OEM_WISTRON_CHASSIS_LED_BLINK_ON 0x02

/* w/ IPMI_CMD_OEM_WISTRON_GET_CHASSIS_POWER_READINGS */
#define IPMI_OEM_WISTRON_CHASSIS_TOTAL_POWER_CONSUMPTION_AVAILABLE_BITMASK 0x01
#define IPMI_OEM_WISTRON_CHASSIS_TOTAL_POWER_CONSUMPTION_AVAILABLE_SHIFT   0

#define IPMI_OEM_WISTRON_CHASSIS_COOLING_POWER_CONSUMPTION_AVAILABLE_BITMASK 0x02
#define IPMI_OEM_WISTRON_CHASSIS_COOLING_POWER_CONSUMPTION_AVAILABLE_SHIFT   1

/* w/ IPMI_CMD_OEM_WISTRON_SET_PASSWORD_POLICY
 */
#define IPMI_OEM_WISTRON_PASSWORD_POLICY_DISABLE 0x00
#define IPMI_OEM_WISTRON_PASSWORD_POLICY_ENABLE  0x01

/* w/ IPMI_CMD_OEM_WISTRON_WRITE_PROPRIETARY_STRING
 * and  IPMI_CMD_OEM_WISTRON_READ_PROPRIETARY_STRING
 */
#define IPMI_OEM_WISTRON_PROPRIETARY_STRING_MAX   80
#define IPMI_OEM_WISTRON_PROPRIETARY_STRING_BLOCK 16

#ifdef __cplusplus
}
#endif

#endif /* IPMI_OEM_SPEC_H */
