#! /bin/sh
# Copyright (C) 2002-2012 Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# Check gettext support.

required='gettext'
. ./defs || exit 1

cat >>configure.ac <<END
AM_GNU_GETTEXT
AM_GNU_GETTEXT_VERSION([0.14.3])
AC_OUTPUT
END

: >Makefile.am
mkdir po intl

# config.rpath is required by versions >= 0.14.3.  We try to verify
# this requirement, but only when we find we have a working and recent
# gettext installation.

# If aclocal fails here, it may be that gettext is too old to
# provide AM_GNU_GETTEXT_VERSION.
if $ACLOCAL; then

  # autopoint will fail if it's from an older version.
  # If gettext is too old to provide autopoint, this will
  # fail as well, so we're safe here.
  if autopoint -n; then
    AUTOMAKE_fails --add-missing
    grep 'required.*config.rpath' stderr
  fi
fi

: >config.rpath
sed '/AM_GNU_GETTEXT_VERSION/d' configure.ac >configure.int
mv -f configure.int configure.ac

$ACLOCAL

# po/ and intl/ are required.

AUTOMAKE_fails --add-missing
grep 'AM_GNU_GETTEXT.*SUBDIRS' stderr

echo 'SUBDIRS = po' >Makefile.am
AUTOMAKE_fails --add-missing
grep 'AM_GNU_GETTEXT.*intl' stderr

echo 'SUBDIRS = intl' >Makefile.am
AUTOMAKE_fails --add-missing
grep 'AM_GNU_GETTEXT.*po' stderr

# Ok.

echo 'SUBDIRS = po intl' >Makefile.am
$AUTOMAKE --add-missing

# Make sure distcheck runs './configure --with-included-gettext'.
grep 'with-included-gettext' Makefile.in

# 'SUBDIRS = po intl' isn't required if po/ doesn't exist.
# PR/381.

rmdir po
mkdir sub
echo 'SUBDIRS = sub' >Makefile.am
$AUTOMAKE

# Still, SUBDIRS must be defined.

: >Makefile.am
AUTOMAKE_fails --add-missing
grep 'AM_GNU_GETTEXT.*SUBDIRS' stderr
