/* -*- buffer-read-only: t -*- vi: set ro:
#line 459
   THIS FILE IS GENERATED AUTOMATICALLY.  PLEASE DO NOT EDIT.
#line 459
*/

#line 19 "env.opt"
/* -* c -*-
#line 19
   env.c
#line 19

#line 19
   This file is part of GNU Anubis.
#line 19
   Copyright (C) 2001, 2002, 2003, 2004, 2005, 2007 The Anubis Team.
#line 19

#line 19
   GNU Anubis is free software; you can redistribute it and/or modify
#line 19
   it under the terms of the GNU General Public License as published by
#line 19
   the Free Software Foundation; either version 3 of the License, or
#line 19
   (at your option) any later version.
#line 19

#line 19
   GNU Anubis is distributed in the hope that it will be useful,
#line 19
   but WITHOUT ANY WARRANTY; without even the implied warranty of
#line 19
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#line 19
   GNU General Public License for more details.
#line 19

#line 19
   You should have received a copy of the GNU General Public License
#line 19
   along with GNU Anubis.  If not, see <http://www.gnu.org/licenses/>.
#line 19
*/

#include "headers.h"
#include <grp.h>
#include <getopt.h>
#include "extern.h"
#include "rcfile.h"

#ifdef HAVE_PAM
pam_handle_t *pamh;
static struct pam_conv conv = {
  misc_conv,
  NULL
};
#endif /* HAVE_PAM */

static char *pidfile;

#line 37 "env.opt"

#line 37
static void print_help(void);
#line 37
static void print_usage(void);
#line 153 "env.opt"

#line 153
/* Option codes */
#line 153
enum {
#line 153
	_OPTION_INIT=255,
#line 153
	#line 83 "env.opt"

#line 83
	OPTION_FROM,
#line 115 "env.opt"

#line 115
	OPTION_ALTRC,
#line 122 "env.opt"

#line 122
	OPTION_NORC,
#line 135 "env.opt"

#line 135
	OPTION_SHOW_CONFIG_OPTIONS,
#line 141 "env.opt"

#line 141
	OPTION_RELAX_PERM_CHECK,
#line 147 "env.opt"

#line 147
	OPTION_PID_FILE,
#line 153 "env.opt"

#line 153
	OPTION_USAGE,
#line 153 "env.opt"

#line 153
	OPTION_VERSION,

#line 153 "env.opt"
	MAX_OPTION
#line 153
};
#line 153
static struct option long_options[] = {
#line 153
	#line 39 "env.opt"

#line 39
	{ "bind", required_argument, 0, 'b' },
#line 49 "env.opt"

#line 49
	{ "remote-mta", required_argument, 0, 'r' },
#line 56 "env.opt"

#line 56
	{ "local-mta", required_argument, 0, 'l' },
#line 69 "env.opt"

#line 69
	{ "mode", required_argument, 0, 'm' },
#line 77 "env.opt"

#line 77
	{ "foreground", no_argument, 0, 'f' },
#line 83 "env.opt"

#line 83
	{ "from", required_argument, 0, OPTION_FROM },
#line 89 "env.opt"

#line 89
	{ "stdio", no_argument, 0, 'i' },
#line 98 "env.opt"

#line 98
	{ "silent", no_argument, 0, 's' },
#line 103 "env.opt"

#line 103
	{ "verbose", no_argument, 0, 'v' },
#line 108 "env.opt"

#line 108
	{ "debug", no_argument, 0, 'D' },
#line 115 "env.opt"

#line 115
	{ "altrc", required_argument, 0, OPTION_ALTRC },
#line 122 "env.opt"

#line 122
	{ "norc", no_argument, 0, OPTION_NORC },
#line 128 "env.opt"

#line 128
	{ "check-config", optional_argument, 0, 'c' },
#line 135 "env.opt"

#line 135
	{ "show-config-options", no_argument, 0, OPTION_SHOW_CONFIG_OPTIONS },
#line 141 "env.opt"

#line 141
	{ "relax-perm-check", no_argument, 0, OPTION_RELAX_PERM_CHECK },
#line 147 "env.opt"

#line 147
	{ "pid-file", required_argument, 0, OPTION_PID_FILE },
#line 153 "env.opt"

#line 153
	{ "help", no_argument, 0, '?' },
#line 153 "env.opt"

#line 153
	{ "usage", no_argument, 0, OPTION_USAGE },
#line 153 "env.opt"

#line 153
	{ "version", no_argument, 0, OPTION_VERSION },

#line 153 "env.opt"
	{0, 0, 0, 0}
#line 153
};
#line 153
static struct opthelp {
#line 153
        const char *opt;
#line 153
        const char *arg;
#line 153
        int is_optional;
#line 153
        const char *descr;
#line 153
} opthelp[] = {
#line 153
	#line 39 "env.opt"

#line 39
	{ "-b, --bind", N_("[HOST:]PORT"), 0, N_("Specify the TCP port on which GNU Anubis listens for connections; the default HOST is INADDR_ANY, and default PORT is 24 (private mail system)") },
#line 49 "env.opt"

#line 49
	{ "-r, --remote-mta", N_("[HOST:]PORT"), 0, N_("Specify a remote SMTP host name or IP address; the default is 25") },
#line 56 "env.opt"

#line 56
	{ "-l, --local-mta", N_("FILE"), 0, N_("Execute a local SMTP server, which works on standard input and output (inetd-type program); this option excludes the `--remote-mta' option") },
#line 69 "env.opt"

#line 69
	{ "-m, --mode", N_("MODE"), 0, N_("Select operation mode; MODE is one of \"transparent\", \"auth\" or \"mda\"") },
#line 77 "env.opt"

#line 77
	{ "-f, --foreground", NULL, 0, N_("Foreground mode") },
#line 83 "env.opt"

#line 83
	{ "--from", N_("EMAIL"), 0, N_("Specify sender address (implies MDA mode)") },
#line 89 "env.opt"

#line 89
	{ "-i, --stdio", NULL, 0, N_("Use the SMTP protocol (OMP/Tunnel) as described in RFC 821 on standard input and output") },
#line 96 "env.opt"

#line 96
	{ NULL, NULL, 0, N_("Output options") },
#line 98 "env.opt"

#line 98
	{ "-s, --silent", NULL, 0, N_("Work silently") },
#line 103 "env.opt"

#line 103
	{ "-v, --verbose", NULL, 0, N_("Work noisily") },
#line 108 "env.opt"

#line 108
	{ "-D, --debug", NULL, 0, N_("Debug mode") },
#line 113 "env.opt"

#line 113
	{ NULL, NULL, 0, N_("Miscellaneous options") },
#line 115 "env.opt"

#line 115
	{ "--altrc", N_("FILE"), 0, N_("Specify alternate system configuration file") },
#line 122 "env.opt"

#line 122
	{ "--norc", NULL, 0, N_("Ignore system configuration file") },
#line 128 "env.opt"

#line 128
	{ "-c, --check-config", N_("DEBUG-LEVEL"), 1, N_("Run the configuration file syntax checker") },
#line 135 "env.opt"

#line 135
	{ "--show-config-options", NULL, 0, N_("Print a list of configuration options used to build GNU Anubis") },
#line 141 "env.opt"

#line 141
	{ "--relax-perm-check", NULL, 0, N_("Do not check user configuration file permissions") },
#line 147 "env.opt"

#line 147
	{ "--pid-file", N_("FILE"), 0, N_("Store the PID of the running daemon in FILE") },
#line 153 "env.opt"

#line 153
	{ NULL, NULL, 0, N_("Other options") },
#line 153 "env.opt"

#line 153
	{ "-?, --help", NULL, 0, N_("Give this help list") },
#line 153 "env.opt"

#line 153
	{ "--usage", NULL, 0, N_("Give a short usage message") },
#line 153 "env.opt"

#line 153
	{ "--version", NULL, 0, N_("Print program version") },

#line 153 "env.opt"
};
#line 37 "env.opt"

#line 37
static const char *program_version = PACKAGE_STRING;
#line 37
static char doc[] = N_("SMTP message submission daemon.");
#line 37
static char args_doc[] = N_("");
#line 37
const char *program_bug_address = "<" PACKAGE_BUGREPORT ">";
#line 37
		    
#line 37
#define DESCRCOLUMN 30
#line 37
#define RMARGIN 79
#line 37
#define GROUPCOLUMN 2
#line 37
#define USAGECOLUMN 13
#line 37
		    
#line 37
static void
#line 37
indent (size_t start, size_t col)
#line 37
{
#line 37
  for (; start < col; start++)
#line 37
    putchar (' ');
#line 37
}
#line 37
		    
#line 37
static void
#line 37
print_option_descr (const char *descr, size_t lmargin, size_t rmargin)
#line 37
{
#line 37
  while (*descr)
#line 37
    {
#line 37
      size_t s = 0;
#line 37
      size_t i;
#line 37
      size_t width = rmargin - lmargin;
#line 37

#line 37
      for (i = 0; ; i++)
#line 37
	{
#line 37
	  if (descr[i] == 0 || isspace (descr[i]))
#line 37
	    {
#line 37
	      if (i > width)
#line 37
		break;
#line 37
	      s = i;
#line 37
	      if (descr[i] == 0)
#line 37
		break;
#line 37
	    }
#line 37
	}
#line 37
      printf ("%*.*s\n", s, s, descr);
#line 37
      descr += s;
#line 37
      if (*descr)
#line 37
	{
#line 37
	  indent (0, lmargin);
#line 37
	  descr++;
#line 37
	}
#line 37
    }
#line 37
}
#line 37

#line 37
static void
#line 37
print_help(void)
#line 37
{
#line 37
  unsigned i;
#line 37
  
#line 37
  printf ("%s %s [%s]... %s\n", _("Usage:"), "anubis", _("OPTION"),
#line 37
	  gettext (args_doc)); 
#line 37
  if (doc && doc[0])
#line 37
    print_option_descr(gettext (doc), 0, RMARGIN);
#line 37
  putchar ('\n');
#line 37

#line 37
  for (i = 0; i < sizeof (opthelp) / sizeof (opthelp[0]); i++)
#line 37
    {
#line 37
      unsigned n;
#line 37
      if (opthelp[i].opt)
#line 37
	{
#line 37
	  n = printf ("  %s", opthelp[i].opt);
#line 37
	  if (opthelp[i].arg)
#line 37
	    {
#line 37
	      char *cb, *ce;
#line 37
	      if (strlen (opthelp[i].opt) == 2)
#line 37
		{
#line 37
		  if (!opthelp[i].is_optional)
#line 37
		    {
#line 37
		      putchar (' ');
#line 37
		      n++;
#line 37
		    }
#line 37
		}
#line 37
	      else
#line 37
		{
#line 37
		  putchar ('=');
#line 37
		  n++;
#line 37
		}
#line 37
	      if (opthelp[i].is_optional)
#line 37
		{
#line 37
		  cb = "[";
#line 37
		  ce = "]";
#line 37
		}
#line 37
	      else
#line 37
		cb = ce = "";
#line 37
	      n += printf ("%s%s%s", cb, gettext (opthelp[i].arg), ce);
#line 37
	    }
#line 37
	  if (n >= DESCRCOLUMN)
#line 37
	    {
#line 37
	      putchar ('\n');
#line 37
	      n = 0;
#line 37
	    }
#line 37
	  indent (n, DESCRCOLUMN);
#line 37
	  print_option_descr (gettext (opthelp[i].descr), DESCRCOLUMN, RMARGIN);
#line 37
	}
#line 37
      else
#line 37
	{
#line 37
	  putchar ('\n');
#line 37
	  indent (0, GROUPCOLUMN);
#line 37
	  print_option_descr (gettext (opthelp[i].descr),
#line 37
			      GROUPCOLUMN, RMARGIN);
#line 37
	  putchar ('\n');
#line 37
	}
#line 37
    }
#line 37
  
#line 37
  putchar ('\n');
#line 37
  print_option_descr (_("Mandatory or optional arguments to long options are also mandatory or optional for any corresponding short options."), 0, RMARGIN);
#line 37
  putchar ('\n');
#line 37
  printf (_("Report bugs to %s.\n"), program_bug_address);
#line 37
}
#line 37

#line 37
static void
#line 37
print_usage(void)
#line 37
{
#line 37
  unsigned i;
#line 37
  int f = 0;
#line 37
  unsigned n;
#line 37
  char buf[RMARGIN+1];
#line 37

#line 37
#define FLUSH                        do                                   {                              	  buf[n] = 0;              	  printf ("%s\n", buf);    	  n = USAGECOLUMN;         	  memset (buf, ' ', n);        }                                while (0)
#line 37
#define ADDC(c)   do { if (n == RMARGIN) FLUSH; buf[n++] = c; } while (0)
#line 37

#line 37
  n = snprintf (buf, sizeof buf, "%s %s ", _("Usage:"), "anubis");
#line 37

#line 37
  /* Print a list of short options without arguments. */
#line 37
  for (i = 0; i < sizeof (opthelp) / sizeof (opthelp[0]); i++)
#line 37
    {
#line 37
      if (opthelp[i].opt && opthelp[i].descr && opthelp[i].opt[1] != '-'
#line 37
	  && opthelp[i].arg == NULL)
#line 37
	{
#line 37
	  if (f == 0)
#line 37
	    {
#line 37
	      ADDC('[');
#line 37
	      ADDC('-');
#line 37
	      f = 1;
#line 37
	    }
#line 37
	  ADDC(opthelp[i].opt[1]);
#line 37
	}
#line 37
    }
#line 37
  if (f)
#line 37
    ADDC(']');
#line 37

#line 37
  /* Print a list of short options with arguments. */
#line 37
  for (i = 0; i < sizeof (opthelp) / sizeof (opthelp[0]); i++)
#line 37
    {
#line 37
      if (opthelp[i].opt && opthelp[i].descr && opthelp[i].opt[1] != '-'
#line 37
	  && opthelp[i].arg)
#line 37
	{
#line 37
	  size_t len = 5 
#line 37
	                + strlen (opthelp[i].arg)
#line 37
			   + (opthelp[i].is_optional ? 2 : 1);
#line 37
	  if (n + len > RMARGIN) FLUSH;
#line 37
	  buf[n++] = ' '; 
#line 37
	  buf[n++] = '['; 
#line 37
	  buf[n++] = '-';
#line 37
	  buf[n++] = opthelp[i].opt[1];
#line 37
	  if (opthelp[i].is_optional)
#line 37
	    {
#line 37
	      buf[n++] = '[';
#line 37
	      strcpy (&buf[n], opthelp[i].arg);
#line 37
	      n += strlen (opthelp[i].arg);
#line 37
	      buf[n++] = ']';
#line 37
	    }
#line 37
	  else
#line 37
	    {
#line 37
	      buf[n++] = ' ';
#line 37
	      strcpy (&buf[n], opthelp[i].arg);
#line 37
	      n += strlen (opthelp[i].arg);
#line 37
	    }
#line 37
	  buf[n++] = ']';
#line 37
	}
#line 37
    }
#line 37

#line 37
  /* Print a list of long options */
#line 37
  for (i = 0; i < sizeof (opthelp) / sizeof (opthelp[0]); i++)
#line 37
    {
#line 37
      if (opthelp[i].opt && opthelp[i].descr)
#line 37
	{
#line 37
	  size_t len;
#line 37
	  const char *longopt;
#line 37

#line 37
	  if (opthelp[i].opt[1] == '-')
#line 37
	    longopt = opthelp[i].opt;
#line 37
	  else if (opthelp[i].opt[2] == ',')
#line 37
	    longopt = opthelp[i].opt + 4;
#line 37
	  else
#line 37
	    continue;
#line 37

#line 37
	  len = 3 + strlen (longopt)
#line 37
	          + (opthelp[i].arg ? 1 + strlen (opthelp[i].arg)
#line 37
		      + (opthelp[i].is_optional ? 2 : 0) : 0);
#line 37
	  if (n + len > RMARGIN) FLUSH;
#line 37
	  buf[n++] = ' '; 
#line 37
	  buf[n++] = '['; 
#line 37
	  strcpy (&buf[n], longopt);
#line 37
	  n += strlen (longopt);
#line 37
	  if (opthelp[i].arg)
#line 37
	    {
#line 37
	      buf[n++] = '=';
#line 37
	      if (opthelp[i].is_optional)
#line 37
		{
#line 37
		  buf[n++] = '[';
#line 37
		  strcpy (&buf[n], opthelp[i].arg);
#line 37
		  n += strlen (opthelp[i].arg);
#line 37
		  buf[n++] = ']';
#line 37
		}
#line 37
	      else
#line 37
		{
#line 37
		  strcpy (&buf[n], opthelp[i].arg);
#line 37
		  n += strlen (opthelp[i].arg);
#line 37
		}
#line 37
	    }
#line 37
	  buf[n++] = ']';
#line 37
	}
#line 37
    }
#line 37
  FLUSH;
#line 37
  
#line 37
}
#line 37

#line 153 "env.opt"

#line 153


int x_argc;
char **x_argv;

void
get_options (int argc, char *argv[])
{
  
#line 161
 {
#line 161
  int c;
#line 161
  
#line 161
  while ((c = getopt_long(argc, argv, "b:r:l:m:fisvDc::?",
#line 161
                          long_options, NULL)) != EOF)
#line 161
    {
#line 161
      switch (c)
#line 161
        {
#line 161
	#line 43 "env.opt"
	 case 'b':
#line 43
          {
#line 43

	  parse_mtahost (optarg, &session.anubis, &session.anubis_port);
	  if (session.anubis && strlen (session.anubis) != 0)
	    topt |= T_NAMES;

#line 47
             break;
#line 47
          }
#line 52 "env.opt"
	 case 'r':
#line 52
          {
#line 52

	  parse_mtaport (optarg, &session.mta, &session.mta_port);

#line 54
             break;
#line 54
          }
#line 60 "env.opt"
	 case 'l':
#line 60
          {
#line 60

	    int rc;
	    int argc;
	    if ((rc = argcv_get (optarg, "", "#", &argc, &session.execargs)))
		anubis_error (EX_SOFTWARE, rc, _("argcv_get failed"));
	    session.execpath = strdup (session.execargs[0]);
	    topt |= T_LOCAL_MTA;

#line 67
             break;
#line 67
          }
#line 72 "env.opt"
	 case 'm':
#line 72
          {
#line 72

	  if (anubis_set_mode (optarg))
	    exit (1);

#line 75
             break;
#line 75
          }
#line 79 "env.opt"
	 case 'f':
#line 79
          {
#line 79

	  topt |= T_FOREGROUND_INIT;

#line 81
             break;
#line 81
          }
#line 85 "env.opt"
	 case OPTION_FROM:
#line 85
          {
#line 85

	  assign_string (&from_address, optarg);

#line 87
             break;
#line 87
          }
#line 92 "env.opt"
	 case 'i':
#line 92
          {
#line 92

	  topt |= T_STDINOUT;

#line 94
             break;
#line 94
          }
#line 99 "env.opt"
	 case 's':
#line 99
          {
#line 99

	  options.termlevel = SILENT;

#line 101
             break;
#line 101
          }
#line 104 "env.opt"
	 case 'v':
#line 104
          {
#line 104

	  options.termlevel = VERBOSE;

#line 106
             break;
#line 106
          }
#line 109 "env.opt"
	 case 'D':
#line 109
          {
#line 109

	  options.termlevel = DEBUG;

#line 111
             break;
#line 111
          }
#line 117 "env.opt"
	 case OPTION_ALTRC:
#line 117
          {
#line 117

	  options.altrc = optarg;
	  topt |= T_ALTRC;

#line 120
             break;
#line 120
          }
#line 124 "env.opt"
	 case OPTION_NORC:
#line 124
          {
#line 124

	  topt |= T_NORC;

#line 126
             break;
#line 126
          }
#line 130 "env.opt"
	 case 'c':
#line 130
          {
#line 130

	  rc_set_debug_level (optarg);
	  topt |= T_CHECK_CONFIG;

#line 133
             break;
#line 133
          }
#line 137 "env.opt"
	 case OPTION_SHOW_CONFIG_OPTIONS:
#line 137
          {
#line 137

	  print_config_options ();

#line 139
             break;
#line 139
          }
#line 143 "env.opt"
	 case OPTION_RELAX_PERM_CHECK:
#line 143
          {
#line 143

	  topt |= T_RELAX_PERM_CHECK;

#line 145
             break;
#line 145
          }
#line 149 "env.opt"
	 case OPTION_PID_FILE:
#line 149
          {
#line 149

	  pidfile = optarg;

#line 151
             break;
#line 151
          }
#line 153 "env.opt"
	 case '?':
#line 153
          {
#line 153

#line 153
		print_help ();
#line 153
                exit (0);
#line 153
	 
#line 153
             break;
#line 153
          }
#line 153 "env.opt"
	 case OPTION_USAGE:
#line 153
          {
#line 153

#line 153
		print_usage ();
#line 153
		exit (0);
#line 153
	 
#line 153
             break;
#line 153
          }
#line 153 "env.opt"
	 case OPTION_VERSION:
#line 153
          {
#line 153

#line 153
		/* Give version */
#line 153
		printf("%s\n", program_version);
#line 153
		exit (0);
#line 153
         
#line 153
             break;
#line 153
          }

#line 161 "env.opt"
        }
#line 161
    }
#line 161
  
#line 161
 }   
#line 161

  x_argc = argc - optind;
  x_argv = argv + optind;

  if (from_address)  /* Force MDA mode */
    anubis_mode = anubis_mda;

  if (anubis_mode == anubis_mda)
    {
      if (!(topt & T_LOCAL_MTA))
	anubis_error (EX_USAGE, 0, _("--mode=mda requires --local-mta"));
      if (x_argc == 0)
	anubis_error (EX_USAGE, 0, _("Missing recipient addresses"));
    }
}

#line 179
/*********************
#line 179
 Get a home directory
#line 179
**********************/

void
get_homedir (char *user, char *buf, int maxsize)
{
  struct passwd *pwd;
  memset (buf, 0, maxsize);

  if (user == 0)
    return;

  pwd = getpwnam (user);
  if (pwd)
    strncpy (buf, (char *) pwd->pw_dir, maxsize - 1);
  else
    {
      char *p = getenv ("HOME");
      if (p)
	strncpy (buf, p, maxsize - 1);
      else
	strncpy (buf, "", 1);
    }
  return;
}

#line 206
/*****************************
#line 206
 Get a real user name (login)
#line 206
******************************/

void
anubis_getlogin (char **buf)
{
  struct passwd *pwd;

  pwd = getpwuid (getuid ());
  assign_string (buf, pwd ? pwd->pw_name : getlogin ());
}

#line 219
/*******************
#line 219
 Check current RUID
#line 219
********************/

int
check_superuser (void)
{
  if (getuid () == 0)
    return 1;			/* a super-user */
  return 0;
}

#line 231
/*******************************************
#line 231
 Set USER's RGID, RUID, and home directory.
#line 231
********************************************/

#line 236
/* Change to the given uid/gid. Clear the supplementary group list.
#line 236
   On success returns 0.
#line 236
   On failure returns 1 (or exits, depending on topt settings. See
#line 236
   anubis_error) */
static int
change_privs (uid_t uid, gid_t gid)
{
  int rc = 0;
  gid_t emptygidset[1];

  /* Reset group permissions */
  emptygidset[0] = gid ? gid : getegid();
  if (geteuid() == 0 && setgroups(1, emptygidset))
    {
      anubis_error (0, errno,
		    _("setgroups(1, %lu) failed"),
		    (u_long) emptygidset[0]);
      rc = 1;
    }

  /* Switch to the user's gid. On some OSes the effective gid must
     be reset first */

#if defined(HAVE_SETEGID)
  if ((rc = setegid(gid)) < 0)
    anubis_error (0, errno, _("setegid(%lu) failed"), (u_long) gid);
#elif defined(HAVE_SETREGID)
  if ((rc = setregid(gid, gid)) < 0)
    anubis_error (0, errno, _("setregid(%lu,%lu) failed"),
		  (u_long) gid, (u_long) gid);
#elif defined(HAVE_SETRESGID)
  if ((rc = setresgid(gid, gid, gid)) < 0)
    anubis_error (0, errno, _("setresgid(%lu,%lu,%lu) failed"),
		  (u_long) gid,
		  (u_long) gid,
		  (u_long) gid);
#endif

  if (rc == 0 && gid != 0)
    {
      if ((rc = setgid(gid)) < 0 && getegid() != gid) 
	anubis_error (0, errno, _("setgid(%lu) failed"), (u_long) gid);
      if (rc == 0 && getegid() != gid)
	{
	  anubis_error (0, errno, _("cannot set effective gid to %lu"),
			(u_long) gid);
	  rc = 1;
	}
    }

  /* Now reset uid */
  if (rc == 0 && uid != 0)
    {
      uid_t euid;

      if (setuid(uid)
	  || geteuid() != uid
	  || (getuid() != uid
	      && (geteuid() == 0 || getuid() == 0)))
	{
			
#if defined(HAVE_SETREUID)
	  if (geteuid() != uid)
	    {
	      if (setreuid(uid, -1) < 0)
		{
		  anubis_error (0, errno, _("setreuid(%lu,-1) failed"),
				(u_long) uid);
		  rc = 1;
		}
	      if (setuid(uid) < 0)
		{
		  anubis_error (0, errno, _("second setuid(%lu) failed"),
				(u_long) uid);
		  rc = 1;
		}
	    }
	  else
#endif
	    {
	      anubis_error (0, errno, _("setuid(%lu) failed"), (u_long) uid);
	      rc = 1;
	    }
	}
	

      euid = geteuid();
      if (uid != 0 && setuid(0) == 0)
	{
	  anubis_error (0, 0, _("seteuid(0) succeeded when it should not"));
	  rc = 1;
	}
      else if (uid != euid && setuid(euid) == 0)
	{
	  anubis_error (0, 0, _("cannot drop non-root setuid privileges"));
	  rc = 1;
	}
    }
  return rc;
}

void
anubis_changeowner (const char *user)
{
#ifdef HAVE_PAM
  int pam_retval;
#endif
  struct passwd *pwd;

  if (user == NULL || check_superuser () == 0)
    return;

#ifdef HAVE_PAM
  pam_retval = pam_start ("anubis", user, &conv, &pamh);
  if (pam_retval == PAM_SUCCESS)
    pam_retval = pam_authenticate (pamh, 0);
  if (pam_retval == PAM_SUCCESS)
    pam_retval = pam_acct_mgmt (pamh, 0);
  if (pam_retval == PAM_SUCCESS)
    pam_retval = pam_open_session (pamh, 0);
  if (pam_retval == PAM_SUCCESS)
    info (VERBOSE, _("PAM: Session opened (restrictions applied)."));
  else
    {
      info (NORMAL, _("PAM: Not authenticated to use GNU Anubis."));
      quit (EXIT_FAILURE);
    }
#endif /* HAVE_PAM */

  pwd = getpwnam (user);
  if (pwd)
    {
      if (change_privs (pwd->pw_uid, pwd->pw_gid))
	quit (EXIT_FAILURE);
	
      chdir (pwd->pw_dir);
      info (VERBOSE, _("UID:%d (%s), GID:%d, EUID:%d, EGID:%d"),
	    (int) getuid (), pwd->pw_name, (int) getgid (),
	    (int) geteuid (), (int) getegid ());
    }
  return;
}

int
check_username (char *user)
{
  struct passwd *pwd;

  if (user == NULL)
    return 0;

  pwd = getpwnam (user);
  if (pwd == 0)
    {
      int i = 0;
      int digits = 0;
      int len = strlen (user);

      for (i = len - 1; i >= 0; i--)
	{
	  if (isdigit ((u_char) user[i]))
	    digits++;
	}
      if (digits == len)
	{
	  int uid = atoi (user);
	  pwd = getpwuid (uid);
	  if (pwd != 0)
	    strncpy (user, (char *) pwd->pw_name, 64);
	  else
	    {
	      info (NORMAL, _("Invalid user ID: %s"), user);
	      return 0;		/* FALSE */
	    }
	}
      else
	{
	  info (NORMAL, _("Invalid user name: %s"), user);
	  return 0;		/* FALSE */
	}
    }
  return 1;			/* TRUE */
}

#line 419
/*************************
#line 419
 Check a file permissions
#line 419
**************************/

int
check_filemode (char *path)
{
  struct stat st;

  if (path == 0)
    return 0;

  if (stat (path, &st) == -1)
    return 0;
  if ((st.st_mode & S_IRWXG) || (st.st_mode & S_IRWXO))
    {
      anubis_error (0, 0, _("Wrong permissions on %s. Set 0600."), path);
      return 0;			/* FALSE */
    }
  return 1;			/* TRUE */
}

#line 441
/*************************
#line 441
 Check does a file exist?
#line 441
**************************/

int
check_filename (char *path, time_t *timep)
{
  struct stat st;

  if (path == NULL)
    return 0;

  if (stat (path, &st) == -1)
    {
      anubis_error (0, errno, "%s", path);
      return 0;			/* FALSE */
    }
  if (!(st.st_mode & S_IFREG) || !(st.st_mode & S_IFLNK))
    {
      anubis_error (0, 0,
		    _("%s is not a regular file or a symbolic link."), path);
      return 0;			/* FALSE */
    }

  if (timep)
    {
      time_t mtime = *timep;
      *timep = st.st_mtime;
      return st.st_mtime > mtime;
    }
  return 1;			/* TRUE */
}

/* Select working mode */
int
anubis_set_mode (char *modename)
{
  if (strcmp (modename, "transparent") == 0)
    anubis_mode = anubis_transparent;
  else if (strcmp (modename, "auth") == 0)
    anubis_mode = anubis_authenticate;
  else if (strcmp (modename, "mda") == 0)
    anubis_mode = anubis_mda;
  else
    {
      mprintf (_("Unknown mode: %s"), modename);
      return 1;
    }
  return 0;
}

void
write_pid_file (void)
{
  FILE *fp;
  
  if (!pidfile)
    pidfile = "/var/run/" DEFAULT_PIDFILE;
  fp = fopen (pidfile, "w");
  if (!fp)
    anubis_error (0, errno, _("Cannot open pid file '%s'"), pidfile);
  else 
    {
      fprintf (fp, "%ld\n", (unsigned long) getpid ());
      fclose (fp);
    }
}
/* EOF */
