/* msort -- an alternative to qsort, with an identical interface.
   Copyright (C) 1992 Free Software Foundation, Inc.
   Written by Mike Haertel, September 1988.
   Modified by Per Bothner to use pointers.  1992.

This file is part of the GNU C Library.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

#include <stdlib.h>
#include <string.h>

typedef int (*compare_func)(void *, void*);
static void
msort_with_tmp (b, n, cmp, t)
     void **b;
     size_t n;
     compare_func cmp;
     void **t;
{
  void **tmp;
  void **b1, **b2;
  size_t n1, n2;

  if (n <= 2)
    {
      if (n == 2 && (*cmp) (b[0], b[1]) > 0)
	{
	  void *tmp = b[0]; b[0] = b[1]; b[1] = tmp;
	}
      return;
    }

  n1 = n / 2;
  n2 = n - n1;
  b1 = b;
  b2 = b + n1;

  msort_with_tmp (b1, n1, cmp, t);
  msort_with_tmp (b2, n2, cmp, t);

  tmp = t;

  while (n1 > 0 && n2 > 0)
    {
      if ((*cmp) (*b1, *b2) <= 0)
	{
	  *tmp++ = *b1++;
	  --n1;
	}
      else
	{
	  *tmp++ = *b2++;
	  --n2;
	}
    }
  for ( ; n1 > 0; n1--)
      *tmp++ = *b1++;
  for ( ; n2 > 0; n2--)
      *tmp++ = *b2++;
  for ( ; n > 0; n--)
      *b++ = *t++;
}

void
psort (b, n, cmp)
     void **b;
     size_t n;
     compare_func cmp;
{
  const size_t size = n * sizeof(void*);

  if (n < 256)
    /* The temporary array is small, so put it on the stack.  */
    msort_with_tmp (b, n, cmp, alloca (size));
  else
    {
      /* It's somewhat large, so malloc it.  */
      char *tmp = xmalloc (size);

      msort_with_tmp (b, n, cmp, tmp);
      free (tmp);
    }
}

#if 0
static int gsort (T *base_ptr, size_t total_elems, TComparator cmp)
{
  void **pointers, **temp;
  size_t i;
  i = sizeof(void*) > sizeof(size_t) ? sizeof(void*) : sizeof(size_t);
  i *= totals_elems;
#define MANY (total_elems > 200)
  if (MANY)
    {
      pointers = (void*)malloc(i);
      temp = (void*)malloc(i);
    }
  else
    {
      pointers = (void*)alloca(i);
      temp = (void*)alloca(i);
    }
  if (pointer == NULL || temp == NULL)
    {
      abort();
    }
  size_t *indexes = (size_t*)temp;
  for (i = 0; i < total_elems; i++)
    pointers[i] = &base_ptr[i];
  
  msort_with_tmp (pointers, total_elems, cmp, temp);

  /* convert to indexes */
  for (i = 0; i < total_elems; i++)
    indexes[i] = pointers[i] - (void*)base_ptr, 

  /* Now finally move the elements into their final places. */
  for (i = 0; i < total_elems; i++)
    {
      if (indexes[i] != i)
	{
	  /* Move the ending i'th element into place, after saving the
	     original i'th element */
	  T tmp = base_ptr[i]; /* T::T */
	  size_t j = i;
	  size_t next_j = indexes[j];
	  while (next_j != i)
	    {
	      base_ptr[j] = base_ptr[next_j]; /* T::operator= */
	      j = next_j;
	      next_j = indexes[j];
	      /* This is to mark j as no longer needing moving */
	      indexes[j] = j;
	    }
	  base_ptr[j] = tmp; /* T::operator= */
	  /* T::~T */
	}
    }

  if (MANY)
    {
      free (pointers);
      free (temp);
    }
}
#endif
