/*
 * Decompiled with CFR 0.152.
 */
package cryptix.test;

import cryptix.provider.key.RawKeyGenerator;
import cryptix.util.core.ArrayUtil;
import cryptix.util.core.Hex;
import java.security.Cipher;
import java.security.FeedbackCipher;
import java.security.Key;
import java.security.KeyGenerator;
import java.security.Mode;
import java.security.SecretKey;

public final class TestSquare {
    private static final byte[] key = new byte[16];
    private static RawKeyGenerator rkg;
    private static SecretKey aKey;

    private TestSquare() {
        try {
            rkg = (RawKeyGenerator)KeyGenerator.getInstance((String)"Square", (String)"Cryptix");
            aKey = rkg.generateKey(key);
            this.test1();
            this.test2();
            this.test3();
            this.test4();
            this.test5();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public static final void main(String[] stringArray) {
        System.out.println("\n*** Square:");
        try {
            new TestSquare();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private void test1() throws Exception {
        byte[] byArray = new byte[16];
        int n = 0;
        while (n < 16) {
            byArray[n] = (byte)n;
            ++n;
        }
        byte[] byArray2 = new byte[]{124, 52, -111, -39, 73, -108, -25, 15, 14, -62, -25, -91, -52, -75, -95, 79};
        System.out.println("\nTest vector (raw/ECB):\nEncrypting:");
        Cipher cipher = Cipher.getInstance((String)"Square", (String)"Cryptix");
        cipher.initEncrypt((Key)aKey);
        this.compareIt(cipher.crypt(byArray), byArray2);
        System.out.println("\nDecrypting:");
        cipher.initDecrypt((Key)aKey);
        this.compareIt(cipher.crypt(byArray2), byArray);
    }

    private void test2() throws Exception {
        byte[] byArray = new byte[32];
        int n = 0;
        while (n < 16) {
            byte by = (byte)n;
            byArray[n + 16] = by;
            byArray[n] = by;
            ++n;
        }
        byte[] byArray2 = new byte[]{124, 52, -111, -39, 73, -108, -25, 15, 14, -62, -25, -91, -52, -75, -95, 79, 124, 52, -111, -39, 73, -108, -25, 15, 14, -62, -25, -91, -52, -75, -95, 79};
        System.out.println("\nTest vector (ECB):\nEncrypting:");
        Cipher cipher = Cipher.getInstance((String)"Square/ECB", (String)"Cryptix");
        cipher.initEncrypt((Key)aKey);
        this.compareIt(cipher.crypt(byArray), byArray2);
        System.out.println("\nDecrypting:");
        cipher.initDecrypt((Key)aKey);
        this.compareIt(cipher.crypt(byArray2), byArray);
    }

    private void test3() throws Exception {
        byte[] byArray = new byte[32];
        int n = 0;
        while (n < 16) {
            byte by = (byte)n;
            byArray[n + 16] = by;
            byArray[n] = by;
            ++n;
        }
        byte[] byArray2 = new byte[]{124, 52, -111, -39, 73, -108, -25, 15, 14, -62, -25, -91, -52, -75, -95, 79, 65, -46, -15, -99, 126, -121, -115, -75, 108, 116, 70, -44, 36, -61, -83, -4};
        System.out.println("\nTest vector (CBC):\nEncrypting:");
        Mode mode = (Mode)Cipher.getInstance((String)"Square/CBC", (String)"Cryptix");
        FeedbackCipher feedbackCipher = (FeedbackCipher)mode;
        feedbackCipher.setInitializationVector(new byte[feedbackCipher.getInitializationVectorLength()]);
        mode.initEncrypt((Key)aKey);
        this.compareIt(mode.crypt(byArray), byArray2);
        System.out.println("\nDecrypting:");
        mode.initDecrypt((Key)aKey);
        this.compareIt(mode.crypt(byArray2), byArray);
    }

    private void test4() throws Exception {
        byte[] byArray = new byte[32];
        int n = 0;
        while (n < 16) {
            byte by = (byte)n;
            byArray[n + 16] = by;
            byArray[n] = by;
            ++n;
        }
        byte[] byArray2 = new byte[]{-1, 88, 109, -91, 108, -70, -59, 6, 74, 9, -92, 10, -18, -74, -82, -81, -43, -53, 83, -114, -22, 40, -105, 79, 124, 117, -25, -101, -53, 13, 77, 14};
        System.out.println("\nTest vector (CFB):\nEncrypting:");
        Mode mode = (Mode)Cipher.getInstance((String)"Square/CFB", (String)"Cryptix");
        ((FeedbackCipher)mode).setInitializationVector(new byte[16]);
        mode.initEncrypt((Key)aKey);
        this.compareIt(mode.crypt(byArray), byArray2);
        System.out.println("\nDecrypting:");
        mode.initDecrypt((Key)aKey);
        this.compareIt(mode.crypt(byArray2), byArray);
    }

    private void test5() throws Exception {
        byte[] byArray = new byte[32];
        int n = 0;
        while (n < 16) {
            byte by = (byte)n;
            byArray[n + 16] = by;
            byArray[n] = by;
            ++n;
        }
        byte[] byArray2 = new byte[]{-1, 88, 109, -91, 108, -70, -59, 6, 74, 9, -92, 10, -18, -74, -82, -81, 53, -56, 51, -45, 92, 41, 68, 55, 53, -46, 37, -68, -107, 40, -61, -56};
        System.out.println("\nTest vector (OFB):\nEncrypting:");
        Mode mode = (Mode)Cipher.getInstance((String)"Square/OFB", (String)"Cryptix");
        FeedbackCipher feedbackCipher = (FeedbackCipher)mode;
        feedbackCipher.setInitializationVector(new byte[feedbackCipher.getInitializationVectorLength()]);
        mode.initEncrypt((Key)aKey);
        this.compareIt(mode.crypt(byArray), byArray2);
        System.out.println("\nDecrypting:");
        mode.initDecrypt((Key)aKey);
        this.compareIt(mode.crypt(byArray2), byArray);
    }

    private void compareIt(byte[] byArray, byte[] byArray2) {
        System.out.println("  computed: " + Hex.dumpString((byte[])byArray));
        System.out.println(" certified: " + Hex.dumpString((byte[])byArray2));
        System.out.println(ArrayUtil.areEqual((byte[])byArray, (byte[])byArray2) ? " *** GOOD" : " *** FAILED");
    }

    static {
        int n = 0;
        while (n < 16) {
            TestSquare.key[n] = (byte)n;
            ++n;
        }
    }
}

