/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.md;

import cryptix.provider.md.BlockMessageDigest;
import cryptix.util.core.Debug;
import java.io.PrintWriter;
import java.security.MessageDigest;

public final class SHA1
extends BlockMessageDigest
implements Cloneable {
    private static final boolean DEBUG = true;
    private static final boolean DEBUG_SLOW = false;
    private static final int debuglevel = Debug.getLevel((String)"SHA-1");
    private static final PrintWriter err = Debug.getOutput();
    private static final int HASH_LENGTH = 20;
    private static final int DATA_LENGTH = 64;
    private int[] data;
    private int[] digest;
    private byte[] tmp;
    private int[] w;
    private static String[] texts = new String[]{"abc", "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq", ""};
    private static byte[][] hashs = new byte[][]{{-87, -103, 62, 54, 71, 6, -127, 106, -70, 62, 37, 113, 120, 80, -62, 108, -100, -48, -40, -99}, {-124, -104, 62, 68, 28, 59, -46, 110, -70, -82, 74, -95, -7, 81, 41, -27, -27, 70, 112, -15}, {-38, 57, -93, -18, 94, 107, 75, 13, 50, 85, -65, -17, -107, 96, 24, -112, -81, -40, 7, 9}};

    private static void debug(String string) {
        err.println("SHA-1: " + string);
    }

    protected int engineGetDigestLength() {
        return 20;
    }

    protected int engineGetDataLength() {
        return 64;
    }

    public SHA1() {
        super("SHA-1");
        this.java_init();
        ((MessageDigest)((Object)this)).reset();
    }

    private void java_init() {
        this.digest = new int[5];
        this.data = new int[16];
        this.tmp = new byte[64];
        this.w = new int[80];
    }

    protected void engineReset() {
        super.engineReset();
        this.java_reset();
    }

    private void java_reset() {
        this.digest[0] = 1732584193;
        this.digest[1] = -271733879;
        this.digest[2] = -1732584194;
        this.digest[3] = 271733878;
        this.digest[4] = -1009589776;
    }

    protected void engineTransform(byte[] byArray) {
        this.java_transform(byArray);
    }

    private void java_transform(byte[] byArray) {
        SHA1.byte2int(byArray, 0, this.data, 0, 16);
        this.transform(this.data);
    }

    protected byte[] engineDigest(byte[] byArray, int n) {
        byte[] byArray2 = this.java_digest(byArray, n);
        this.engineReset();
        return byArray2;
    }

    private byte[] java_digest(byte[] byArray, int n) {
        if (n != 0) {
            System.arraycopy(byArray, 0, this.tmp, 0, n);
        }
        this.tmp[n++] = -128;
        if (n > 56) {
            while (n < 64) {
                this.tmp[n++] = 0;
            }
            SHA1.byte2int(this.tmp, 0, this.data, 0, 16);
            this.transform(this.data);
            n = 0;
        }
        while (n < 56) {
            this.tmp[n++] = 0;
        }
        SHA1.byte2int(this.tmp, 0, this.data, 0, 14);
        long l = this.bitcount();
        this.data[14] = (int)(l >>> 32);
        this.data[15] = (int)l;
        this.transform(this.data);
        byte[] byArray2 = new byte[20];
        int n2 = 0;
        int n3 = 0;
        while (n3 < 5) {
            int n4 = this.digest[n3];
            byArray2[n2++] = (byte)(n4 >>> 24);
            byArray2[n2++] = (byte)(n4 >>> 16);
            byArray2[n2++] = (byte)(n4 >>> 8);
            byArray2[n2++] = (byte)n4;
            ++n3;
        }
        return byArray2;
    }

    private static int f1(int n, int n2, int n3) {
        return (n3 ^ n & (n2 ^ n3)) + 1518500249;
    }

    private static int f2(int n, int n2, int n3) {
        return (n ^ n2 ^ n3) + 1859775393;
    }

    private static int f3(int n, int n2, int n3) {
        return (n & n2 | n3 & (n | n2)) + -1894007588;
    }

    private static int f4(int n, int n2, int n3) {
        return (n ^ n2 ^ n3) + -899497514;
    }

    private void transform(int[] nArray) {
        int n = this.digest[0];
        int n2 = this.digest[1];
        int n3 = this.digest[2];
        int n4 = this.digest[3];
        int n5 = this.digest[4];
        if (debuglevel > 5) {
            SHA1.debug("A=" + n + " B=" + n2 + " C=" + n3 + " D=" + n4 + " E=" + n5);
        }
        int[] nArray2 = this.w;
        int n6 = 0;
        while (n6 < 16) {
            nArray2[n6] = nArray[n6];
            if (debuglevel > 8) {
                SHA1.debug("       " + n6 + "=" + nArray[n6]);
            }
            ++n6;
        }
        int n7 = 16;
        while (n7 < 80) {
            int n8;
            nArray2[n7] = n8 = nArray2[n7 - 16] ^ nArray2[n7 - 14] ^ nArray2[n7 - 8] ^ nArray2[n7 - 3];
            nArray2[n7] = n8 << 1 | n8 >>> -1;
            ++n7;
        }
        n5 += (n << 5 | n >>> -5) + SHA1.f1(n2, n3, n4) + nArray2[0];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA1.f1(n, n2, n3) + nArray2[1];
        n = n << 30 | n >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA1.f1(n5, n, n2) + nArray2[2];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA1.f1(n4, n5, n) + nArray2[3];
        n4 = n4 << 30 | n4 >>> -30;
        n += (n2 << 5 | n2 >>> -5) + SHA1.f1(n3, n4, n5) + nArray2[4];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n << 5 | n >>> -5) + SHA1.f1(n2, n3, n4) + nArray2[5];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA1.f1(n, n2, n3) + nArray2[6];
        n = n << 30 | n >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA1.f1(n5, n, n2) + nArray2[7];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA1.f1(n4, n5, n) + nArray2[8];
        n4 = n4 << 30 | n4 >>> -30;
        n += (n2 << 5 | n2 >>> -5) + SHA1.f1(n3, n4, n5) + nArray2[9];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n << 5 | n >>> -5) + SHA1.f1(n2, n3, n4) + nArray2[10];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA1.f1(n, n2, n3) + nArray2[11];
        n = n << 30 | n >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA1.f1(n5, n, n2) + nArray2[12];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA1.f1(n4, n5, n) + nArray2[13];
        n4 = n4 << 30 | n4 >>> -30;
        n += (n2 << 5 | n2 >>> -5) + SHA1.f1(n3, n4, n5) + nArray2[14];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n << 5 | n >>> -5) + SHA1.f1(n2, n3, n4) + nArray2[15];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA1.f1(n, n2, n3) + nArray2[16];
        n = n << 30 | n >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA1.f1(n5, n, n2) + nArray2[17];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA1.f1(n4, n5, n) + nArray2[18];
        n4 = n4 << 30 | n4 >>> -30;
        n += (n2 << 5 | n2 >>> -5) + SHA1.f1(n3, n4, n5) + nArray2[19];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n << 5 | n >>> -5) + SHA1.f2(n2, n3, n4) + nArray2[20];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA1.f2(n, n2, n3) + nArray2[21];
        n = n << 30 | n >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA1.f2(n5, n, n2) + nArray2[22];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA1.f2(n4, n5, n) + nArray2[23];
        n4 = n4 << 30 | n4 >>> -30;
        n += (n2 << 5 | n2 >>> -5) + SHA1.f2(n3, n4, n5) + nArray2[24];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n << 5 | n >>> -5) + SHA1.f2(n2, n3, n4) + nArray2[25];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA1.f2(n, n2, n3) + nArray2[26];
        n = n << 30 | n >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA1.f2(n5, n, n2) + nArray2[27];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA1.f2(n4, n5, n) + nArray2[28];
        n4 = n4 << 30 | n4 >>> -30;
        n += (n2 << 5 | n2 >>> -5) + SHA1.f2(n3, n4, n5) + nArray2[29];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n << 5 | n >>> -5) + SHA1.f2(n2, n3, n4) + nArray2[30];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA1.f2(n, n2, n3) + nArray2[31];
        n = n << 30 | n >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA1.f2(n5, n, n2) + nArray2[32];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA1.f2(n4, n5, n) + nArray2[33];
        n4 = n4 << 30 | n4 >>> -30;
        n += (n2 << 5 | n2 >>> -5) + SHA1.f2(n3, n4, n5) + nArray2[34];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n << 5 | n >>> -5) + SHA1.f2(n2, n3, n4) + nArray2[35];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA1.f2(n, n2, n3) + nArray2[36];
        n = n << 30 | n >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA1.f2(n5, n, n2) + nArray2[37];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA1.f2(n4, n5, n) + nArray2[38];
        n4 = n4 << 30 | n4 >>> -30;
        n += (n2 << 5 | n2 >>> -5) + SHA1.f2(n3, n4, n5) + nArray2[39];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n << 5 | n >>> -5) + SHA1.f3(n2, n3, n4) + nArray2[40];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA1.f3(n, n2, n3) + nArray2[41];
        n = n << 30 | n >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA1.f3(n5, n, n2) + nArray2[42];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA1.f3(n4, n5, n) + nArray2[43];
        n4 = n4 << 30 | n4 >>> -30;
        n += (n2 << 5 | n2 >>> -5) + SHA1.f3(n3, n4, n5) + nArray2[44];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n << 5 | n >>> -5) + SHA1.f3(n2, n3, n4) + nArray2[45];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA1.f3(n, n2, n3) + nArray2[46];
        n = n << 30 | n >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA1.f3(n5, n, n2) + nArray2[47];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA1.f3(n4, n5, n) + nArray2[48];
        n4 = n4 << 30 | n4 >>> -30;
        n += (n2 << 5 | n2 >>> -5) + SHA1.f3(n3, n4, n5) + nArray2[49];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n << 5 | n >>> -5) + SHA1.f3(n2, n3, n4) + nArray2[50];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA1.f3(n, n2, n3) + nArray2[51];
        n = n << 30 | n >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA1.f3(n5, n, n2) + nArray2[52];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA1.f3(n4, n5, n) + nArray2[53];
        n4 = n4 << 30 | n4 >>> -30;
        n += (n2 << 5 | n2 >>> -5) + SHA1.f3(n3, n4, n5) + nArray2[54];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n << 5 | n >>> -5) + SHA1.f3(n2, n3, n4) + nArray2[55];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA1.f3(n, n2, n3) + nArray2[56];
        n = n << 30 | n >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA1.f3(n5, n, n2) + nArray2[57];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA1.f3(n4, n5, n) + nArray2[58];
        n4 = n4 << 30 | n4 >>> -30;
        n += (n2 << 5 | n2 >>> -5) + SHA1.f3(n3, n4, n5) + nArray2[59];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n << 5 | n >>> -5) + SHA1.f4(n2, n3, n4) + nArray2[60];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA1.f4(n, n2, n3) + nArray2[61];
        n = n << 30 | n >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA1.f4(n5, n, n2) + nArray2[62];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA1.f4(n4, n5, n) + nArray2[63];
        n4 = n4 << 30 | n4 >>> -30;
        n += (n2 << 5 | n2 >>> -5) + SHA1.f4(n3, n4, n5) + nArray2[64];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n << 5 | n >>> -5) + SHA1.f4(n2, n3, n4) + nArray2[65];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA1.f4(n, n2, n3) + nArray2[66];
        n = n << 30 | n >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA1.f4(n5, n, n2) + nArray2[67];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA1.f4(n4, n5, n) + nArray2[68];
        n4 = n4 << 30 | n4 >>> -30;
        n += (n2 << 5 | n2 >>> -5) + SHA1.f4(n3, n4, n5) + nArray2[69];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n << 5 | n >>> -5) + SHA1.f4(n2, n3, n4) + nArray2[70];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA1.f4(n, n2, n3) + nArray2[71];
        n = n << 30 | n >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA1.f4(n5, n, n2) + nArray2[72];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA1.f4(n4, n5, n) + nArray2[73];
        n4 = n4 << 30 | n4 >>> -30;
        n += (n2 << 5 | n2 >>> -5) + SHA1.f4(n3, n4, n5) + nArray2[74];
        n3 = n3 << 30 | n3 >>> -30;
        n5 += (n << 5 | n >>> -5) + SHA1.f4(n2, n3, n4) + nArray2[75];
        n2 = n2 << 30 | n2 >>> -30;
        n4 += (n5 << 5 | n5 >>> -5) + SHA1.f4(n, n2, n3) + nArray2[76];
        n = n << 30 | n >>> -30;
        n3 += (n4 << 5 | n4 >>> -5) + SHA1.f4(n5, n, n2) + nArray2[77];
        n5 = n5 << 30 | n5 >>> -30;
        n2 += (n3 << 5 | n3 >>> -5) + SHA1.f4(n4, n5, n) + nArray2[78];
        n4 = n4 << 30 | n4 >>> -30;
        n += (n2 << 5 | n2 >>> -5) + SHA1.f4(n3, n4, n5) + nArray2[79];
        n3 = n3 << 30 | n3 >>> -30;
        this.digest[0] = this.digest[0] + n;
        this.digest[1] = this.digest[1] + n2;
        this.digest[2] = this.digest[2] + n3;
        this.digest[3] = this.digest[3] + n4;
        this.digest[4] = this.digest[4] + n5;
        if (debuglevel > 5) {
            SHA1.debug("d1=" + this.digest[0] + " d1=" + this.digest[1] + " d2=" + this.digest[2] + " d3=" + this.digest[3] + " d4=" + this.digest[4]);
        }
    }

    private static void byte2int(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        while (n3-- > 0) {
            nArray[n2++] = byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        }
    }

    public static final void main(String[] stringArray) {
        try {
            SHA1.self_test();
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(1);
            return;
        }
    }

    public static final void self_test() throws Exception {
        int n = 0;
        while (n < texts.length) {
            SHA1 sHA1 = new SHA1();
            byte[] byArray = texts[n].getBytes();
            int n2 = 0;
            while (n2 < texts[n].length()) {
                sHA1.engineUpdate(byArray[n2]);
                ++n2;
            }
            if (SHA1.notEquals(sHA1.engineDigest(), hashs[n])) {
                throw new Exception("hash #" + n + " failed");
            }
            ++n;
        }
    }

    private static final boolean notEquals(byte[] byArray, byte[] byArray2) {
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

