  len=instrbuf.s.len/sizeof(p_instr);
  instructions=(p_instr *)instrbuf.s.str;
  instrbuf.s.str=0;
  fifo_len=0;
  init_bytecode();

  for(eye=0;eye<len;)
  {
    INT32 current_line;
    struct pike_string *current_file;

#ifdef DEBUG
    if(a_flag>5) {
      fprintf(stderr,"#%d,%d:",eye,fifo_len);
      fprintf(stderr," %s(%d)",  get_token_name(opcode(0)),argument(0));
      fprintf(stderr," %s(%d)",  get_token_name(opcode(1)),argument(1));
      fprintf(stderr," %s(%d)",  get_token_name(opcode(2)),argument(2));
      fprintf(stderr," %s(%d)\n",get_token_name(opcode(3)),argument(3));
    }
#endif

    switch(opcode(0))
    {
    case F_BRANCH_WHEN_GT:
      /* BRANCH_WHEN_GT BRANCH LABEL ($1a) : BRANCH_WHEN_LE($2a) LABEL($1a) */
      if(F_BRANCH==opcode(1) && F_LABEL==opcode(2) && (argument(0))==argument(2))
      {
        struct pike_string *cf;
        INT32 cl=instr(0)->line;
        INT32 arg0=argument(1);
        INT32 arg2=argument(0);
        copy_shared_string(cf,instr(0)->file);
        pop_n_opcodes(3);
        insopt(F_BRANCH_WHEN_LE,arg0,cl,cf);
        insopt(F_LABEL,arg2,cl,cf);
        fifo_len+=2;
        free_string(cf);
        debug();
        fifo_len+=5;
        continue;
      }
      break;

    case F_RETURN_0:
      /* RETURN_0 !LABEL : RETURN_0 */
      if(F_LABEL!=opcode(1))
      {
        struct pike_string *cf;
        INT32 cl=instr(0)->line;
        copy_shared_string(cf,instr(0)->file);
        pop_n_opcodes(2);
        insopt2(F_RETURN_0,cl,cf);
        fifo_len+=1;
        free_string(cf);
        debug();
        fifo_len+=4;
        continue;
      }
      break;

    case F_ASSIGN_LOCAL:
      /* ASSIGN_LOCAL  POP_VALUE : ASSIGN_LOCAL_AND_POP($1a) */
      if(F_POP_VALUE==opcode(1))
      {
        struct pike_string *cf;
        INT32 cl=instr(0)->line;
        INT32 arg0=argument(0);
        copy_shared_string(cf,instr(0)->file);
        pop_n_opcodes(2);
        insopt(F_ASSIGN_LOCAL_AND_POP,arg0,cl,cf);
        fifo_len+=1;
        free_string(cf);
        debug();
        fifo_len+=4;
        continue;
      }
      break;

    case F_GE:
      switch(opcode(1))
      {
      case F_BRANCH_WHEN_ZERO:
        /* GE BRANCH_WHEN_ZERO: BRANCH_WHEN_LT ($2a) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=argument(1);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_BRANCH_WHEN_LT,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_BRANCH_WHEN_NON_ZERO:
        /* GE BRANCH_WHEN_NON_ZERO: BRANCH_WHEN_GE ($2a) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=argument(1);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_BRANCH_WHEN_GE,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_NOT:
        /* GE NOT: LT */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt2(F_LT,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      }
      break;

    case F_LE:
      switch(opcode(1))
      {
      case F_BRANCH_WHEN_ZERO:
        /* LE BRANCH_WHEN_ZERO: BRANCH_WHEN_GT ($2a) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=argument(1);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_BRANCH_WHEN_GT,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_BRANCH_WHEN_NON_ZERO:
        /* LE BRANCH_WHEN_NON_ZERO: BRANCH_WHEN_LE ($2a) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=argument(1);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_BRANCH_WHEN_LE,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_NOT:
        /* LE NOT: GT */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt2(F_GT,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      }
      break;

    case F_POP_VALUE:
      switch(opcode(1))
      {
      case F_POP_N_ELEMS:
        /* POP_VALUE POP_N_ELEMS : POP_N_ELEMS ($2a + 1) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=argument(1) + 1;
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_POP_N_ELEMS,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_POP_VALUE:
        /* POP_VALUE POP_VALUE : POP_N_ELEMS (2) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=2;
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_POP_N_ELEMS,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      }
      break;

    case F_GT:
      switch(opcode(1))
      {
      case F_BRANCH_WHEN_ZERO:
        /* GT BRANCH_WHEN_ZERO: BRANCH_WHEN_LE ($2a) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=argument(1);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_BRANCH_WHEN_LE,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_BRANCH_WHEN_NON_ZERO:
        /* GT BRANCH_WHEN_NON_ZERO: BRANCH_WHEN_GT ($2a) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=argument(1);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_BRANCH_WHEN_GT,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_NOT:
        /* GT NOT: LE */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt2(F_LE,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      }
      break;

    case F_LT:
      switch(opcode(1))
      {
      case F_BRANCH_WHEN_ZERO:
        /* LT BRANCH_WHEN_ZERO: BRANCH_WHEN_GE ($2a) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=argument(1);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_BRANCH_WHEN_GE,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_BRANCH_WHEN_NON_ZERO:
        /* LT BRANCH_WHEN_NON_ZERO: BRANCH_WHEN_LT ($2a) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=argument(1);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_BRANCH_WHEN_LT,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_NOT:
        /* LT NOT: GE */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt2(F_GE,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      }
      break;

    case F_NE:
      switch(opcode(1))
      {
      case F_BRANCH_WHEN_ZERO:
        /* NE BRANCH_WHEN_ZERO: BRANCH_WHEN_EQ ($2a) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=argument(1);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_BRANCH_WHEN_EQ,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_BRANCH_WHEN_NON_ZERO:
        /* NE BRANCH_WHEN_NON_ZERO: BRANCH_WHEN_NE ($2a) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=argument(1);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_BRANCH_WHEN_NE,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_NOT:
        /* NE NOT: EQ */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt2(F_EQ,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      }
      break;

    case F_NOT:
      switch(opcode(1))
      {
      case F_BRANCH_WHEN_ZERO:
        /* NOT BRANCH_WHEN_ZERO: BRANCH_WHEN_NON_ZERO($2a) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=argument(1);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_BRANCH_WHEN_NON_ZERO,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_BRANCH_WHEN_NON_ZERO:
        /* NOT BRANCH_WHEN_NON_ZERO: BRANCH_WHEN_ZERO($2a) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=argument(1);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_BRANCH_WHEN_ZERO,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      }
      break;

    case F_POST_INC:
      /* POST_INC POP_VALUE: INC_AND_POP */
      if(F_POP_VALUE==opcode(1))
      {
        struct pike_string *cf;
        INT32 cl=instr(0)->line;
        copy_shared_string(cf,instr(0)->file);
        pop_n_opcodes(2);
        insopt2(F_INC_AND_POP,cl,cf);
        fifo_len+=1;
        free_string(cf);
        debug();
        fifo_len+=4;
        continue;
      }
      break;

    case F_POP_N_ELEMS:
      switch(argument(0))
      {
      case 1:
        /* POP_N_ELEMS(1) : POP_VALUE */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(1);
          insopt2(F_POP_VALUE,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case 0:
        /* POP_N_ELEMS (0) :  */
        {
          pop_n_opcodes(1);
          fifo_len+=3;
          continue;
        }
        break;

      default:
        switch(opcode(1))
        {
        case F_POP_N_ELEMS:
          /* POP_N_ELEMS POP_N_ELEMS : POP_N_ELEMS ($1a + $2a) */
          {
            struct pike_string *cf;
            INT32 cl=instr(0)->line;
            INT32 arg0=argument(0) + argument(1);
            copy_shared_string(cf,instr(0)->file);
            pop_n_opcodes(2);
            insopt(F_POP_N_ELEMS,arg0,cl,cf);
            fifo_len+=1;
            free_string(cf);
            debug();
            fifo_len+=4;
            continue;
          }
          break;

        case F_POP_VALUE:
          /* POP_N_ELEMS POP_VALUE : POP_N_ELEMS ($1a + 1) */
          {
            struct pike_string *cf;
            INT32 cl=instr(0)->line;
            INT32 arg0=argument(0) + 1;
            copy_shared_string(cf,instr(0)->file);
            pop_n_opcodes(2);
            insopt(F_POP_N_ELEMS,arg0,cl,cf);
            fifo_len+=1;
            free_string(cf);
            debug();
            fifo_len+=4;
            continue;
          }
          break;

        }
      }
      break;

    case F_DEC:
      /* DEC POP_VALUE: DEC_AND_POP */
      if(F_POP_VALUE==opcode(1))
      {
        struct pike_string *cf;
        INT32 cl=instr(0)->line;
        copy_shared_string(cf,instr(0)->file);
        pop_n_opcodes(2);
        insopt2(F_DEC_AND_POP,cl,cf);
        fifo_len+=1;
        free_string(cf);
        debug();
        fifo_len+=4;
        continue;
      }
      break;

    case F_CLEAR_LOCAL:
      /* CLEAR_LOCAL NUMBER(0) ASSIGN_LOCAL_AND_POP ($1a) : CLEAR_LOCAL($1a) */
      if(F_NUMBER==opcode(1) && (0)==argument(1) && F_ASSIGN_LOCAL_AND_POP==opcode(2) && (argument(0))==argument(2))
      {
        struct pike_string *cf;
        INT32 cl=instr(0)->line;
        INT32 arg0=argument(0);
        copy_shared_string(cf,instr(0)->file);
        pop_n_opcodes(3);
        insopt(F_CLEAR_LOCAL,arg0,cl,cf);
        fifo_len+=1;
        free_string(cf);
        debug();
        fifo_len+=4;
        continue;
      }
      /* CLEAR_LOCAL NUMBER(0) ASSIGN_LOCAL_AND_POP ($1a+1) : CLEAR_2_LOCAL($1a) */
      if(F_NUMBER==opcode(1) && (0)==argument(1) && F_ASSIGN_LOCAL_AND_POP==opcode(2) && (argument(0)+1)==argument(2))
      {
        struct pike_string *cf;
        INT32 cl=instr(0)->line;
        INT32 arg0=argument(0);
        copy_shared_string(cf,instr(0)->file);
        pop_n_opcodes(3);
        insopt(F_CLEAR_2_LOCAL,arg0,cl,cf);
        fifo_len+=1;
        free_string(cf);
        debug();
        fifo_len+=4;
        continue;
      }
      break;

    case F_BRANCH_WHEN_LE:
      /* BRANCH_WHEN_LE BRANCH LABEL ($1a) : BRANCH_WHEN_GT($2a) LABEL($1a) */
      if(F_BRANCH==opcode(1) && F_LABEL==opcode(2) && (argument(0))==argument(2))
      {
        struct pike_string *cf;
        INT32 cl=instr(0)->line;
        INT32 arg0=argument(1);
        INT32 arg2=argument(0);
        copy_shared_string(cf,instr(0)->file);
        pop_n_opcodes(3);
        insopt(F_BRANCH_WHEN_GT,arg0,cl,cf);
        insopt(F_LABEL,arg2,cl,cf);
        fifo_len+=2;
        free_string(cf);
        debug();
        fifo_len+=5;
        continue;
      }
      break;

    case F_BRANCH_WHEN_GE:
      /* BRANCH_WHEN_GE BRANCH LABEL ($1a) : BRANCH_WHEN_LT($2a) LABEL($1a) */
      if(F_BRANCH==opcode(1) && F_LABEL==opcode(2) && (argument(0))==argument(2))
      {
        struct pike_string *cf;
        INT32 cl=instr(0)->line;
        INT32 arg0=argument(1);
        INT32 arg2=argument(0);
        copy_shared_string(cf,instr(0)->file);
        pop_n_opcodes(3);
        insopt(F_BRANCH_WHEN_LT,arg0,cl,cf);
        insopt(F_LABEL,arg2,cl,cf);
        fifo_len+=2;
        free_string(cf);
        debug();
        fifo_len+=5;
        continue;
      }
      break;

    case F_EQ:
      switch(opcode(1))
      {
      case F_LAND:
        /* EQ LAND: EQ_AND ($2a) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=argument(1);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_EQ_AND,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_LOR:
        /* EQ LOR: EQ_OR ($2a) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=argument(1);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_EQ_OR,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_BRANCH_WHEN_ZERO:
        /* EQ BRANCH_WHEN_ZERO: BRANCH_WHEN_NE ($2a) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=argument(1);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_BRANCH_WHEN_NE,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_BRANCH_WHEN_NON_ZERO:
        /* EQ BRANCH_WHEN_NON_ZERO: BRANCH_WHEN_EQ ($2a) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=argument(1);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_BRANCH_WHEN_EQ,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_CONST0:
        /* EQ CONST0: NOT */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt2(F_NOT,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_NOT:
        /* EQ NOT: NE */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt2(F_NE,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      }
      break;

    case F_BRANCH_WHEN_LT:
      /* BRANCH_WHEN_LT BRANCH LABEL ($1a) : BRANCH_WHEN_GE($2a) LABEL($1a) */
      if(F_BRANCH==opcode(1) && F_LABEL==opcode(2) && (argument(0))==argument(2))
      {
        struct pike_string *cf;
        INT32 cl=instr(0)->line;
        INT32 arg0=argument(1);
        INT32 arg2=argument(0);
        copy_shared_string(cf,instr(0)->file);
        pop_n_opcodes(3);
        insopt(F_BRANCH_WHEN_GE,arg0,cl,cf);
        insopt(F_LABEL,arg2,cl,cf);
        fifo_len+=2;
        free_string(cf);
        debug();
        fifo_len+=5;
        continue;
      }
      break;

    case F_BRANCH_WHEN_EQ:
      /* BRANCH_WHEN_EQ BRANCH LABEL ($1a) : BRANCH_WHEN_NE($2a) LABEL($1a) */
      if(F_BRANCH==opcode(1) && F_LABEL==opcode(2) && (argument(0))==argument(2))
      {
        struct pike_string *cf;
        INT32 cl=instr(0)->line;
        INT32 arg0=argument(1);
        INT32 arg2=argument(0);
        copy_shared_string(cf,instr(0)->file);
        pop_n_opcodes(3);
        insopt(F_BRANCH_WHEN_NE,arg0,cl,cf);
        insopt(F_LABEL,arg2,cl,cf);
        fifo_len+=2;
        free_string(cf);
        debug();
        fifo_len+=5;
        continue;
      }
      break;

    case F_NEG_NUMBER:
      switch(opcode(1))
      {
      case F_INDEX:
        /* NEG_NUMBER [$1a >= 0] INDEX: NEG_INT_INDEX ($1a) */
        if(argument(0) >= 0)
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=argument(0);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_NEG_INT_INDEX,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        /* NEG_NUMBER [$1a < 0] INDEX: POS_INT_INDEX (-$1a) */
        if(argument(0) < 0)
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=-argument(0);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_POS_INT_INDEX,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_NEGATE:
        /* NEG_NUMBER NEGATE : NUMBER ($1a) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=argument(0);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_NUMBER,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      }
      break;

    case F_DEC_LOCAL_AND_POP:
      /* DEC_LOCAL_AND_POP LOCAL ($1a) : DEC_LOCAL ($1a) */
      if(F_LOCAL==opcode(1) && (argument(0))==argument(1))
      {
        struct pike_string *cf;
        INT32 cl=instr(0)->line;
        INT32 arg0=argument(0);
        copy_shared_string(cf,instr(0)->file);
        pop_n_opcodes(2);
        insopt(F_DEC_LOCAL,arg0,cl,cf);
        fifo_len+=1;
        free_string(cf);
        debug();
        fifo_len+=4;
        continue;
      }
      break;

    case F_POST_INC_LOCAL:
      /* POST_INC_LOCAL POP_VALUE : INC_LOCAL_AND_POP ($1a) */
      if(F_POP_VALUE==opcode(1))
      {
        struct pike_string *cf;
        INT32 cl=instr(0)->line;
        INT32 arg0=argument(0);
        copy_shared_string(cf,instr(0)->file);
        pop_n_opcodes(2);
        insopt(F_INC_LOCAL_AND_POP,arg0,cl,cf);
        fifo_len+=1;
        free_string(cf);
        debug();
        fifo_len+=4;
        continue;
      }
      break;

    case F_NEGATE:
      switch(opcode(1))
      {
      case F_CONST1:
        /* NEGATE CONST1 SUBTRACT : COMPL */
        if(F_SUBTRACT==opcode(2))
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(3);
          insopt2(F_COMPL,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_NEGATE:
        /* NEGATE NEGATE : */
        {
          pop_n_opcodes(2);
          fifo_len+=3;
          continue;
        }
        break;

      case F_CONST_1:
        /* NEGATE CONST_1 ADD : COMPL */
        if(F_ADD==opcode(2))
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(3);
          insopt2(F_COMPL,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      }
      break;

    case F_INC:
      /* INC POP_VALUE: INC_AND_POP */
      if(F_POP_VALUE==opcode(1))
      {
        struct pike_string *cf;
        INT32 cl=instr(0)->line;
        copy_shared_string(cf,instr(0)->file);
        pop_n_opcodes(2);
        insopt2(F_INC_AND_POP,cl,cf);
        fifo_len+=1;
        free_string(cf);
        debug();
        fifo_len+=4;
        continue;
      }
      break;

    case F_BRANCH_WHEN_NE:
      /* BRANCH_WHEN_NE BRANCH LABEL ($1a) : BRANCH_WHEN_EQ($2a) LABEL($1a) */
      if(F_BRANCH==opcode(1) && F_LABEL==opcode(2) && (argument(0))==argument(2))
      {
        struct pike_string *cf;
        INT32 cl=instr(0)->line;
        INT32 arg0=argument(1);
        INT32 arg2=argument(0);
        copy_shared_string(cf,instr(0)->file);
        pop_n_opcodes(3);
        insopt(F_BRANCH_WHEN_EQ,arg0,cl,cf);
        insopt(F_LABEL,arg2,cl,cf);
        fifo_len+=2;
        free_string(cf);
        debug();
        fifo_len+=5;
        continue;
      }
      break;

    case F_BRANCH_WHEN_NON_ZERO:
      /* BRANCH_WHEN_NON_ZERO BRANCH LABEL ($1a): BRANCH_WHEN_ZERO($2a) LABEL($1a) */
      if(F_BRANCH==opcode(1) && F_LABEL==opcode(2) && (argument(0))==argument(2))
      {
        struct pike_string *cf;
        INT32 cl=instr(0)->line;
        INT32 arg0=argument(1);
        INT32 arg2=argument(0);
        copy_shared_string(cf,instr(0)->file);
        pop_n_opcodes(3);
        insopt(F_BRANCH_WHEN_ZERO,arg0,cl,cf);
        insopt(F_LABEL,arg2,cl,cf);
        fifo_len+=2;
        free_string(cf);
        debug();
        fifo_len+=5;
        continue;
      }
      break;

    case F_ASSIGN_GLOBAL_AND_POP:
      /* ASSIGN_GLOBAL_AND_POP GLOBAL ($1a) : ASSIGN_GLOBAL ($1a) */
      if(F_GLOBAL==opcode(1) && (argument(0))==argument(1))
      {
        struct pike_string *cf;
        INT32 cl=instr(0)->line;
        INT32 arg0=argument(0);
        copy_shared_string(cf,instr(0)->file);
        pop_n_opcodes(2);
        insopt(F_ASSIGN_GLOBAL,arg0,cl,cf);
        fifo_len+=1;
        free_string(cf);
        debug();
        fifo_len+=4;
        continue;
      }
      break;

    case F_ASSIGN_LOCAL_AND_POP:
      /* ASSIGN_LOCAL_AND_POP LOCAL ($1a) : ASSIGN_LOCAL ($1a) */
      if(F_LOCAL==opcode(1) && (argument(0))==argument(1))
      {
        struct pike_string *cf;
        INT32 cl=instr(0)->line;
        INT32 arg0=argument(0);
        copy_shared_string(cf,instr(0)->file);
        pop_n_opcodes(2);
        insopt(F_ASSIGN_LOCAL,arg0,cl,cf);
        fifo_len+=1;
        free_string(cf);
        debug();
        fifo_len+=4;
        continue;
      }
      /* ASSIGN_LOCAL_AND_POP LOCAL ($1a) RETURN : RETURN */
      if(F_LOCAL==opcode(1) && (argument(0))==argument(1) && F_RETURN==opcode(2))
      {
        struct pike_string *cf;
        INT32 cl=instr(0)->line;
        copy_shared_string(cf,instr(0)->file);
        pop_n_opcodes(3);
        insopt2(F_RETURN,cl,cf);
        fifo_len+=1;
        free_string(cf);
        debug();
        fifo_len+=4;
        continue;
      }
      break;

    case F_INC_LOCAL:
      /* INC_LOCAL POP_VALUE : INC_LOCAL_AND_POP ($1a) */
      if(F_POP_VALUE==opcode(1))
      {
        struct pike_string *cf;
        INT32 cl=instr(0)->line;
        INT32 arg0=argument(0);
        copy_shared_string(cf,instr(0)->file);
        pop_n_opcodes(2);
        insopt(F_INC_LOCAL_AND_POP,arg0,cl,cf);
        fifo_len+=1;
        free_string(cf);
        debug();
        fifo_len+=4;
        continue;
      }
      break;

    case F_DEC_LOCAL:
      /* DEC_LOCAL POP_VALUE : DEC_LOCAL_AND_POP ($1a) */
      if(F_POP_VALUE==opcode(1))
      {
        struct pike_string *cf;
        INT32 cl=instr(0)->line;
        INT32 arg0=argument(0);
        copy_shared_string(cf,instr(0)->file);
        pop_n_opcodes(2);
        insopt(F_DEC_LOCAL_AND_POP,arg0,cl,cf);
        fifo_len+=1;
        free_string(cf);
        debug();
        fifo_len+=4;
        continue;
      }
      break;

    case F_CONST1:
      switch(opcode(1))
      {
      case F_DIVIDE:
        /* CONST1 DIVIDE :  */
        {
          pop_n_opcodes(2);
          fifo_len+=3;
          continue;
        }
        break;

      case F_ADD:
        /* CONST1 ADD: ADD_INT (1) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=1;
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_ADD_INT,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_INDEX:
        /* CONST1 INDEX: POS_INT_INDEX (1) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=1;
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_POS_INT_INDEX,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_BRANCH_WHEN_NON_ZERO:
        /* CONST1 BRANCH_WHEN_NON_ZERO: BRANCH($2a) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=argument(1);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_BRANCH,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_BRANCH_WHEN_ZERO:
        /* CONST1 BRANCH_WHEN_ZERO: */
        {
          pop_n_opcodes(2);
          fifo_len+=3;
          continue;
        }
        break;

      case F_MULTIPLY:
        /* CONST1 MULTIPLY :  */
        {
          pop_n_opcodes(2);
          fifo_len+=3;
          continue;
        }
        break;

      case F_SUBTRACT:
        /* CONST1 SUBTRACT: ADD_NEG_INT (-1) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=-1;
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_ADD_NEG_INT,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_RETURN:
        /* CONST1 RETURN: RETURN_1 */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt2(F_RETURN_1,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_NEGATE:
        /* CONST1 NEGATE : CONST_1 */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt2(F_CONST_1,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      }
      break;

    case F_BRANCH_WHEN_ZERO:
      /* BRANCH_WHEN_ZERO BRANCH LABEL ($1a): BRANCH_WHEN_NON_ZERO($2a) LABEL($1a) */
      if(F_BRANCH==opcode(1) && F_LABEL==opcode(2) && (argument(0))==argument(2))
      {
        struct pike_string *cf;
        INT32 cl=instr(0)->line;
        INT32 arg0=argument(1);
        INT32 arg2=argument(0);
        copy_shared_string(cf,instr(0)->file);
        pop_n_opcodes(3);
        insopt(F_BRANCH_WHEN_NON_ZERO,arg0,cl,cf);
        insopt(F_LABEL,arg2,cl,cf);
        fifo_len+=2;
        free_string(cf);
        debug();
        fifo_len+=5;
        continue;
      }
      break;

    case F_GLOBAL_LVALUE:
      switch(opcode(1))
      {
      case F_DEC_AND_POP:
        /* GLOBAL_LVALUE DEC_AND_POP GLOBAL($1a): GLOBAL_LVALUE($1a) DEC */
        if(F_GLOBAL==opcode(2) && (argument(0))==argument(2))
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=argument(0);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(3);
          insopt(F_GLOBAL_LVALUE,arg0,cl,cf);
          insopt2(F_DEC,cl,cf);
          fifo_len+=2;
          free_string(cf);
          debug();
          fifo_len+=5;
          continue;
        }
        break;

      case F_INC_AND_POP:
        /* GLOBAL_LVALUE INC_AND_POP GLOBAL($1a): GLOBAL_LVALUE($1a) INC */
        if(F_GLOBAL==opcode(2) && (argument(0))==argument(2))
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=argument(0);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(3);
          insopt(F_GLOBAL_LVALUE,arg0,cl,cf);
          insopt2(F_INC,cl,cf);
          fifo_len+=2;
          free_string(cf);
          debug();
          fifo_len+=5;
          continue;
        }
        break;

      }
      break;

    case F_POST_DEC_LOCAL:
      /* POST_DEC_LOCAL POP_VALUE : DEC_LOCAL_AND_POP ($1a) */
      if(F_POP_VALUE==opcode(1))
      {
        struct pike_string *cf;
        INT32 cl=instr(0)->line;
        INT32 arg0=argument(0);
        copy_shared_string(cf,instr(0)->file);
        pop_n_opcodes(2);
        insopt(F_DEC_LOCAL_AND_POP,arg0,cl,cf);
        fifo_len+=1;
        free_string(cf);
        debug();
        fifo_len+=4;
        continue;
      }
      break;

    case F_COMPL:
      /* COMPL COMPL : */
      if(F_COMPL==opcode(1))
      {
        pop_n_opcodes(2);
        fifo_len+=3;
        continue;
      }
      break;

    case F_CONST_1:
      switch(opcode(1))
      {
      case F_DIVIDE:
        /* CONST_1 DIVIDE : NEGATE */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt2(F_NEGATE,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_ADD:
        /* CONST_1 ADD: ADD_NEG_INT (1) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=1;
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_ADD_NEG_INT,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_INDEX:
        /* CONST_1 INDEX: NEG_INT_INDEX (1) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=1;
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_NEG_INT_INDEX,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_MULTIPLY:
        /* CONST_1 MULTIPLY : NEGATE */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt2(F_NEGATE,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_SUBTRACT:
        /* CONST_1 SUBTRACT: ADD_INT (1) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=1;
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_ADD_INT,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_NEGATE:
        /* CONST_1 NEGATE : CONST1 */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt2(F_CONST1,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_XOR:
        /* CONST_1 XOR: COMPL */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt2(F_COMPL,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      }
      break;

    case F_CONST0:
      switch(opcode(1))
      {
      case F_ADD:
        /* CONST0 ADD: ADD_INT (0) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=0;
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_ADD_INT,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_INDEX:
        /* CONST0 INDEX: POS_INT_INDEX (0) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=0;
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_POS_INT_INDEX,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_BRANCH_WHEN_NON_ZERO:
        /* CONST0 BRANCH_WHEN_NON_ZERO:  */
        {
          pop_n_opcodes(2);
          fifo_len+=3;
          continue;
        }
        break;

      case F_BRANCH_WHEN_ZERO:
        /* CONST0 BRANCH_WHEN_ZERO: BRANCH($2a) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=argument(1);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_BRANCH,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_SUBTRACT:
        /* CONST0 SUBTRACT: */
        {
          pop_n_opcodes(2);
          fifo_len+=3;
          continue;
        }
        /* CONST0 SUBTRACT: ADD_INT (0) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=0;
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_ADD_INT,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_ASSIGN_LOCAL_AND_POP:
        /* CONST0 ASSIGN_LOCAL_AND_POP : CLEAR_LOCAL($2a) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=argument(1);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_CLEAR_LOCAL,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_RETURN:
        /* CONST0 RETURN: RETURN_0 */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt2(F_RETURN_0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_NEGATE:
        /* CONST0 NEGATE : CONST0 */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt2(F_CONST0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_XOR:
        /* CONST0 XOR: */
        {
          pop_n_opcodes(2);
          fifo_len+=3;
          continue;
        }
        break;

      }
      break;

    case F_MARK:
      switch(opcode(1))
      {
      case F_APPLY:
        /* MARK APPLY : MARK_APPLY($2a) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=argument(1);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_MARK_APPLY,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_MARK:
        /* MARK MARK: MARK2 */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt2(F_MARK2,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_LOCAL:
        /* MARK LOCAL [ $3o != F_SIZEOF && $3o != F_INDEX ]: MARK_AND_LOCAL ($2a) */
        if( opcode(2) != F_SIZEOF && opcode(2) != F_INDEX )
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=argument(1);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_MARK_AND_LOCAL,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      }
      break;

    case F_INC_LOCAL_AND_POP:
      /* INC_LOCAL_AND_POP LOCAL ($1a) : INC_LOCAL ($1a) */
      if(F_LOCAL==opcode(1) && (argument(0))==argument(1))
      {
        struct pike_string *cf;
        INT32 cl=instr(0)->line;
        INT32 arg0=argument(0);
        copy_shared_string(cf,instr(0)->file);
        pop_n_opcodes(2);
        insopt(F_INC_LOCAL,arg0,cl,cf);
        fifo_len+=1;
        free_string(cf);
        debug();
        fifo_len+=4;
        continue;
      }
      break;

    case F_APPLY:
      /* APPLY POP_VALUE : APPLY_AND_POP($1a) */
      if(F_POP_VALUE==opcode(1))
      {
        struct pike_string *cf;
        INT32 cl=instr(0)->line;
        INT32 arg0=argument(0);
        copy_shared_string(cf,instr(0)->file);
        pop_n_opcodes(2);
        insopt(F_APPLY_AND_POP,arg0,cl,cf);
        fifo_len+=1;
        free_string(cf);
        debug();
        fifo_len+=4;
        continue;
      }
      break;

    case F_NOP:
      /* NOP : */
      {
        pop_n_opcodes(1);
        fifo_len+=3;
        continue;
      }
      break;

    case F_LOCAL_LVALUE:
      switch(opcode(1))
      {
      case F_DEC_AND_POP:
        /* LOCAL_LVALUE DEC_AND_POP : DEC_LOCAL_AND_POP ($1a) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=argument(0);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_DEC_LOCAL_AND_POP,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_DEC:
        /* LOCAL_LVALUE DEC : DEC_LOCAL ($1a) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=argument(0);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_DEC_LOCAL,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_INC_AND_POP:
        /* LOCAL_LVALUE INC_AND_POP : INC_LOCAL_AND_POP ($1a) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=argument(0);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_INC_LOCAL_AND_POP,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_POST_DEC:
        /* LOCAL_LVALUE POST_DEC : POST_DEC_LOCAL ($1a) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=argument(0);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_POST_DEC_LOCAL,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_POST_INC:
        /* LOCAL_LVALUE POST_INC : POST_INC_LOCAL ($1a) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=argument(0);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_POST_INC_LOCAL,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_INC:
        /* LOCAL_LVALUE INC : INC_LOCAL ($1a) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=argument(0);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_INC_LOCAL,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      }
      break;

    case F_LTOSVAL:
      /* LTOSVAL ADD ASSIGN_AND_POP : ADD_TO_AND_POP */
      if(F_ADD==opcode(1) && F_ASSIGN_AND_POP==opcode(2))
      {
        struct pike_string *cf;
        INT32 cl=instr(0)->line;
        copy_shared_string(cf,instr(0)->file);
        pop_n_opcodes(3);
        insopt2(F_ADD_TO_AND_POP,cl,cf);
        fifo_len+=1;
        free_string(cf);
        debug();
        fifo_len+=4;
        continue;
      }
      break;

    case F_BRANCH:
      /* BRANCH !LABEL : BRANCH($1a) */
      if(F_LABEL!=opcode(1))
      {
        struct pike_string *cf;
        INT32 cl=instr(0)->line;
        INT32 arg0=argument(0);
        copy_shared_string(cf,instr(0)->file);
        pop_n_opcodes(2);
        insopt(F_BRANCH,arg0,cl,cf);
        fifo_len+=1;
        free_string(cf);
        debug();
        fifo_len+=4;
        continue;
      }
      /* BRANCH LABEL ($1a) : LABEL ($1a) */
      if(F_LABEL==opcode(1) && (argument(0))==argument(1))
      {
        struct pike_string *cf;
        INT32 cl=instr(0)->line;
        INT32 arg0=argument(0);
        copy_shared_string(cf,instr(0)->file);
        pop_n_opcodes(2);
        insopt(F_LABEL,arg0,cl,cf);
        fifo_len+=1;
        free_string(cf);
        debug();
        fifo_len+=4;
        continue;
      }
      break;

    case F_LTOSVAL2:
      /* LTOSVAL2 ADD ASSIGN_AND_POP : ADD_TO_AND_POP */
      if(F_ADD==opcode(1) && F_ASSIGN_AND_POP==opcode(2))
      {
        struct pike_string *cf;
        INT32 cl=instr(0)->line;
        copy_shared_string(cf,instr(0)->file);
        pop_n_opcodes(3);
        insopt2(F_ADD_TO_AND_POP,cl,cf);
        fifo_len+=1;
        free_string(cf);
        debug();
        fifo_len+=4;
        continue;
      }
      break;

    case F_LOCAL:
      switch(opcode(1))
      {
      case F_INDEX:
        /* LOCAL INDEX: LOCAL_INDEX ($1a) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=argument(0);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_LOCAL_INDEX,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_SIZEOF:
        /* LOCAL SIZEOF: SIZEOF_LOCAL ($1a) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=argument(0);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_SIZEOF_LOCAL,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_LOCAL:
        /* LOCAL LOCAL [$2a<256 && $3o != F_SIZEOF && $3o != F_INDEX ]: 2_LOCALS ($1a) BYTE ($2a) */
        if(argument(1)<256 && opcode(2) != F_SIZEOF && opcode(2) != F_INDEX )
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=argument(0);
          INT32 arg2=argument(1);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_2_LOCALS,arg0,cl,cf);
          insopt(F_BYTE,arg2,cl,cf);
          fifo_len+=2;
          free_string(cf);
          debug();
          fifo_len+=5;
          continue;
        }
        break;

      }
      break;

    case F_MARK_APPLY:
      /* MARK_APPLY POP_VALUE : MARK_APPLY_POP($1a) */
      if(F_POP_VALUE==opcode(1))
      {
        struct pike_string *cf;
        INT32 cl=instr(0)->line;
        INT32 arg0=argument(0);
        copy_shared_string(cf,instr(0)->file);
        pop_n_opcodes(2);
        insopt(F_MARK_APPLY_POP,arg0,cl,cf);
        fifo_len+=1;
        free_string(cf);
        debug();
        fifo_len+=4;
        continue;
      }
      break;

    case F_NUMBER:
      switch(opcode(1))
      {
      case F_ADD:
        /* NUMBER [$1a >= 0] ADD : ADD_INT ($1a) */
        if(argument(0) >= 0)
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=argument(0);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_ADD_INT,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        /* NUMBER [$1a < 0] ADD : ADD_NEG_INT (-$1a) */
        if(argument(0) < 0)
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=-argument(0);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_ADD_NEG_INT,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_INDEX:
        /* NUMBER [$1a < 0] INDEX: NEG_INT_INDEX (-$1a) */
        if(argument(0) < 0)
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=-argument(0);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_NEG_INT_INDEX,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        /* NUMBER [$1a >= 0] INDEX: POS_INT_INDEX ($1a) */
        if(argument(0) >= 0)
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=argument(0);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_POS_INT_INDEX,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_NEGATE:
        /* NUMBER NEGATE : NEG_NUMBER($1a) */
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=argument(0);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_NEG_NUMBER,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      case F_SUBTRACT:
        /* NUMBER [$1a >= 0] SUBTRACT : ADD_NEG_INT ($1a) */
        if(argument(0) >= 0)
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=argument(0);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_ADD_NEG_INT,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        /* NUMBER [$1a < 0] SUBTRACT : ADD_INT (-$1a) */
        if(argument(0) < 0)
        {
          struct pike_string *cf;
          INT32 cl=instr(0)->line;
          INT32 arg0=-argument(0);
          copy_shared_string(cf,instr(0)->file);
          pop_n_opcodes(2);
          insopt(F_ADD_INT,arg0,cl,cf);
          fifo_len+=1;
          free_string(cf);
          debug();
          fifo_len+=4;
          continue;
        }
        break;

      default:
        switch(argument(0))
        {
        case 0:
          /* NUMBER(0) : CONST0 */
          {
            struct pike_string *cf;
            INT32 cl=instr(0)->line;
            copy_shared_string(cf,instr(0)->file);
            pop_n_opcodes(1);
            insopt2(F_CONST0,cl,cf);
            fifo_len+=1;
            free_string(cf);
            debug();
            fifo_len+=4;
            continue;
          }
          break;

        case -1:
          /* NUMBER(-1) : CONST_1 */
          {
            struct pike_string *cf;
            INT32 cl=instr(0)->line;
            copy_shared_string(cf,instr(0)->file);
            pop_n_opcodes(1);
            insopt2(F_CONST_1,cl,cf);
            fifo_len+=1;
            free_string(cf);
            debug();
            fifo_len+=4;
            continue;
          }
          break;

        case 1:
          /* NUMBER(1) : CONST1 */
          {
            struct pike_string *cf;
            INT32 cl=instr(0)->line;
            copy_shared_string(cf,instr(0)->file);
            pop_n_opcodes(1);
            insopt2(F_CONST1,cl,cf);
            fifo_len+=1;
            free_string(cf);
            debug();
            fifo_len+=4;
            continue;
          }
          break;

        default:
          /* NUMBER (0x7fffffff) : BIGNUM */
          if((0x7fffffff)==argument(0))
          {
            struct pike_string *cf;
            INT32 cl=instr(0)->line;
            copy_shared_string(cf,instr(0)->file);
            pop_n_opcodes(1);
            insopt2(F_BIGNUM,cl,cf);
            fifo_len+=1;
            free_string(cf);
            debug();
            fifo_len+=4;
            continue;
          }
          /* NUMBER [$1a < 0] : NEG_NUMBER (-$1a) */
          if(argument(0) < 0)
          {
            struct pike_string *cf;
            INT32 cl=instr(0)->line;
            INT32 arg0=-argument(0);
            copy_shared_string(cf,instr(0)->file);
            pop_n_opcodes(1);
            insopt(F_NEG_NUMBER,arg0,cl,cf);
            fifo_len+=1;
            free_string(cf);
            debug();
            fifo_len+=4;
            continue;
          }
        }
      }
      break;

    case F_STRING:
      /* STRING INDEX: STRING_INDEX ($1a) */
      if(F_INDEX==opcode(1))
      {
        struct pike_string *cf;
        INT32 cl=instr(0)->line;
        INT32 arg0=argument(0);
        copy_shared_string(cf,instr(0)->file);
        pop_n_opcodes(2);
        insopt(F_STRING_INDEX,arg0,cl,cf);
        fifo_len+=1;
        free_string(cf);
        debug();
        fifo_len+=4;
        continue;
      }
      break;

    case F_RETURN:
      /* RETURN !LABEL : RETURN */
      if(F_LABEL!=opcode(1))
      {
        struct pike_string *cf;
        INT32 cl=instr(0)->line;
        copy_shared_string(cf,instr(0)->file);
        pop_n_opcodes(2);
        insopt2(F_RETURN,cl,cf);
        fifo_len+=1;
        free_string(cf);
        debug();
        fifo_len+=4;
        continue;
      }
      break;

    case F_POST_DEC:
      /* POST_DEC POP_VALUE: DEC_AND_POP */
      if(F_POP_VALUE==opcode(1))
      {
        struct pike_string *cf;
        INT32 cl=instr(0)->line;
        copy_shared_string(cf,instr(0)->file);
        pop_n_opcodes(2);
        insopt2(F_DEC_AND_POP,cl,cf);
        fifo_len+=1;
        free_string(cf);
        debug();
        fifo_len+=4;
        continue;
      }
      break;

    case F_ASSIGN_GLOBAL:
      /* ASSIGN_GLOBAL POP_VALUE : ASSIGN_GLOBAL_AND_POP($1a) */
      if(F_POP_VALUE==opcode(1))
      {
        struct pike_string *cf;
        INT32 cl=instr(0)->line;
        INT32 arg0=argument(0);
        copy_shared_string(cf,instr(0)->file);
        pop_n_opcodes(2);
        insopt(F_ASSIGN_GLOBAL_AND_POP,arg0,cl,cf);
        fifo_len+=1;
        free_string(cf);
        debug();
        fifo_len+=4;
        continue;
      }
      break;

    case F_CALL_LFUN:
      /* CALL_LFUN POP_VALUE : CALL_LFUN_AND_POP($1a) */
      if(F_POP_VALUE==opcode(1))
      {
        struct pike_string *cf;
        INT32 cl=instr(0)->line;
        INT32 arg0=argument(0);
        copy_shared_string(cf,instr(0)->file);
        pop_n_opcodes(2);
        insopt(F_CALL_LFUN_AND_POP,arg0,cl,cf);
        fifo_len+=1;
        free_string(cf);
        debug();
        fifo_len+=4;
        continue;
      }
      break;

    }
    advance();
  }
  for(eye=0;eye<len;eye++) free_string(instructions[eye].file);
  free((char *)instructions);
