#!/usr/local/bin/perl -- -*- C -*-

#
#  Nate's Cypherpunks remailer interface version 2.0
#
#  Written for Perl 4.0.36
#
#  (c)1994 Nate Sammons
#

## Here's the config variables that you may need to set.

# active = 0 for demo, 1 for active (clever, eh?)
$active = 0;

# firstmailer should be the address of your local remailer
$firstmailer = "nate@vis.colostate.edu";

# URL is the URL of *your* interface, for the "back" button.
$URL = "http://monet.vis.colostate.edu/~nate/mailer.html";

# sendmail is the process we dump the mail to
$sendmail = "/usr/lib/sendmail";


## You shouldn't need to edit anything after this
#####################################################################


$| = 1;
&ReadParse;

foreach $_ (sort keys %in) {
  if (/remailers/) { $rem = $in{$_}; }
  if (/message/) { $message = $in{$_}; }
  if (/subject/) { $subject = $in{$_}; }
  if (/to/) { $to = $in{$_}; }
  }

#
#  If no destination or no remailers are selected, then we pop out
#  an error message saying what's wrong.
#
if (!$to) {
  print "Content-Type: text/html\n\n";
  print "<title>ERROR: no destination!</title>\n";
  print "<h1>ERROR: no destination!</h1>";
  print "<b>No destination was specified. You need to go ";
  print "<a href=\"$URL\">back</a> and enter a destination in the ";
  print "\"To:\" text-box.<P>";
  exit 0;
  }
if (!$rem) {
  print "Content-Type: text/html\n\n";
  print "<title>ERROR: no remailers selected!</title>\n";
  print "<h1>ERROR: no remailers selected!</h1>";
  print "<b>No remailers were specified. You need to go ";
  print "<a href=\"$URL\">back</a> and select some remailers in the ";
  print "scrolling list.<P>";
  exit 0;
  }
$_ = $to;
if (!(/[^\s]+@[^\s]+/)) {
  print "Content-Type: text/html\n\n";
  print "<title>ERROR: Suspicious recipient</title>\n";
  print "<h1>ERROR: Suspicious recipient</h1>";
  print "<b>The recipient's email address was suspicious. You need to go ";
  print "<a href=\"$URL\">back</a> and enter something in the form ";
  print "<i>username@fully.qualified.machine.name</i><P>";
  exit 0;
  }

# split names of remailer into an array
@mailers = split(/\\0/, $rem);
undef $rem;


# tell everyone what language we're speaking
print "Content-Type: text/html\n\n";
print "<title>Remailer interface output</title>\n";
print "<h1>Remailer interface output</h1>";

if (!$active) { ## inactive remailer
  print "You selected the following remailers:<P><ol>\n";
  print "<li>$firstmailer\n";
  foreach $i (@mailers) {
    print "<li>$i\n";
    }
  print "</ol><P>\n";

  print "<b>The message would appear as follows:</b><P>\n";
  print "<hr>\n";
  print "<pre>To: $firstmailer\n<P>";
  print "Subject: $subject\n<P>";
  foreach $i (@mailers) {
    print "\n::\nRequest-Remailing-To: $i\n";
    }
  print "\n::\nRequest-Remailing-To: $to\n";
  print "\n\n$message\n\n<P>";
  print "</pre>\n";
  print "<hr>\n";

  }
  
else { ## active remailer
  print "Your message was sent through the following remailers:<P><ol>\n";
  print "<li>$firstmailer\n";
  foreach $i (@mailers) {
    print "<li>$i\n";
    }
  print "</ol><P>\n";
  print "It will be delivered to $to if all goes according to plan.<P>\n";
  
  open(SENDMAIL, "|$sendmail $firstmailer");
  print SENDMAIL "To: $firstmailer\nSubject: $subject\n\n";
  foreach $i (@mailers) {
    print SENDMAIL "\n::\nRequest-Remailing-To: $i\n";
    }
  print SENDMAIL "\n::\nRequest-Remailing-To: $to\n";
  print SENDMAIL "\n\n$message\n\n";

  close(SENDMAIL);
  }

exit 0;

## The rest is a *very* handy perl library for interpreting CGI and forms
## data.  Extremely handy.

# Perl Routines to Manipulate CGI input
# S.E.Brenner@bioc.cam.ac.uk
# $Header: /people/seb1005/http/cgi-bin/RCS/cgi-lib.pl,v 1.2 1994/01/10 15:05:40 seb1005 Exp $
#
# Copyright 1993 Steven E. Brenner  
# Unpublished work.
# Permission granted to use and modify this library so long as the
# copyright above is maintained, modifications are documented, and
# credit is given for any use of the library.

# ReadParse
# Reads in GET or POST data, converts it to unescaped text, and puts
# one key=value in each member of the list "@in"
# Also creates key/value pairs in %in, using '\0' to separate multiple
# selections

# If a variable-glob parameter (e.g., *cgi_input) is passed to ReadParse,
# information is stored there, rather than in $in, @in, and %in.

sub ReadParse {
  if (@_) {
    local (*in) = @_;
  }

  local ($i, $loc, $key, $val);

  # Read in text
  if ($ENV{'REQUEST_METHOD'} eq "GET") {
    $in = $ENV{'QUERY_STRING'};
  } elsif ($ENV{'REQUEST_METHOD'} eq "POST") {
    for ($i = 0; $i < $ENV{'CONTENT_LENGTH'}; $i++) {
      $in .= getc;
    }
  } 

  @in = split(/&/,$in);

  foreach $i (0 .. $#in) {
    # Convert plus's to spaces
    $in[$i] =~ s/\+/ /g;

    # Convert %XX from hex numbers to alphanumeric
    $in[$i] =~ s/%(..)/pack("c",hex($1))/ge;

    # Split into key and value.
    $loc = index($in[$i],"=");
    $key = substr($in[$i],0,$loc);
    $val = substr($in[$i],$loc+1);
    $in{$key} .= '\0' if (defined($in{$key})); # \0 is the multiple separator
    $in{$key} .= $val;
  }

  return 1; # just for fun
}

# PrintHeader
# Returns the magic line which tells WWW that we're an HTML document

sub PrintHeader {
  return "Content-type: text/html\n\n";
}

# PrintVariables
# Nicely formats variables in an associative array passed as a parameter
# And returns the HTML string.

sub PrintVariables {
  local (%in) = @_;
  local ($old, $out);
  $old = $*;  $* =1;
  $output .=  "<DL COMPACT>";
  foreach $key (sort keys(%in)) {
    ($out = $in{$key}) =~ s/\n/<BR>/g;
    $output .=  "<DT><B>$key</B><DD><i>$out</I><BR>";
  }
  $output .=  "</DL>";
  $* = $old;

  return $output;
}

# PrintVariablesShort
# Nicely formats variables in an associative array passed as a parameter
# Using one line per pair (unless value is multiline)
# And returns the HTML string.

sub PrintVariablesShort {
  local (%in) = @_;
  local ($old, $out);
  $old = $*;  $* =1;
  foreach $key (sort keys(%in)) {
    if (($out = $in{$key}) =~ s/\n/<BR>/g) {
      $output .= "<DL COMPACT><DT><B>$key</B> is <DD><i>$out</I></DL>";
    } else {
      $output .= "<B>$key</B> is <i>$out</I><BR>";
    }
  }
  $* = $old;

  return $output;
}

## 1; #return true
