/* newdir.C - update hidden directory for access control purposes.

This program is donated to the public domain by the author (Michael Paul 
Johnson). Use it at your own risk. This program comes with no warranty, 
expressed or implied. Since I have no control over how this program or 
the way it is used, I am not responsibile for its use or misuse, even if 
it causes some kind of damage. Please don't use this program unless you 
know what you are doing.

*/

#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#ifndef NO_UNISTD
#include <unistd.h>
#endif
#include <string.h>
#include "def.h"
#include "diamond2.h"

#define MAXLINE 514

/*
The following key MUST be the same in newdir.C and in newindex.C.
To syncronize a mirror site with an access control site, this key,
the times that newdir and newindex is run, and the system clocks
must be synchronized.
*/

byte diamond_key[20] = // Change this key to something else!
    {0xD9, 0x61, 0x2C, 0x51,
     0xE6, 0x4E, 0x63, 0x11,
     0xB7, 0x84, 0x88, 0xB4,
     0xE2, 0xE8, 0xBD, 0xB9,
     0x60, 0x58, 0x75, 0xC3};

byte input_block[8] =
    {0,0,0,0,0, 0x03, 0xD0, 0x7D};

byte output_block[8];

char fchars[] = 
  "23456789abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ-_.lIO01";

char dirname[10];


int main(int argc, char **argv)
    {
    char s[256];
    int i,j;
    time_t t;
    struct tm *gmt;

    // Initialize plain text block from coordinated universal time.

    t = time(NULL);
    gmt = gmtime(&t);  // Round down to nearest hour
    input_block[0] = gmt->tm_hour;
    input_block[1] = gmt->tm_mday;
    input_block[2] = gmt->tm_mon;
    input_block[4] = gmt->tm_year;

    // Encrypt the block & derive a directory name.

    set_diamond2_key(diamond_key,20,10,false,8); // 10-round Diamond Lite
    lite2_encrypt_block(input_block,output_block);
    diamond2_done();

    for (i = 0; i<8; i++)
        {
        dirname[i] = fchars[output_block[i] % 56];
        }
    dirname[8] = 0;
    // printf("New crypto directory name is %s\n", dirname);

    // Update the hidden directory name.

    system("mv crypto/* crypto/aAaAof"); // avoid error message on retry
    sprintf(s,"mv crypto/* crypto/%s", dirname);
    // puts(s);
    system(s);
    // printf("Crypto directory name updated to %s\n", dirname);

    return 0;
}
