/* Header file for remailer list */

/* Cheat for people who don't have F_LOCK in their include files
#ifndef F_ULOCK
#define F_ULOCK 0
#endif
#ifndef F_LOCK
#define F_LOCK 1
#endif

/* for the file format */
typedef struct stats {
   double latency; /* in seconds */
   double rel; /* reliability as a fraction */
   double tc;
   double reserved;
} stats;

typedef struct summ {
   char nickname[16];
   int last_ping; /* Time of last ping */
   int last_response; /* Time of last response */
   int last_error; /* Time last error message was sent */
   int last_update; /* Time of last recalculation of stuff */
   int flags; /* 1 = silent */
   int reserved;
   int off_pings; /* file offset in bytes */
   int num_pings; /* number of ping records */
   char hist[16];
   stats stats0; /* after first ping record */
   stats stats1; /* now */
} summ;

typedef struct ping {
   int ping_time;
   int response_time;
} ping;

/* The file format is as follows:
   int num_remailers;
   summ summaries[num_remailers];
   ping pings[*]; -- Pointed to by summ records
*/

int main (int, char **);
void init_state (void);
void done_state (void);
void touch_state (void);
void update_state (void);
int add_remailer (char *);
int toggle_remailer (char *);
int conflict (int, int);
int evict (int, int);
int allocate (int, int);
ping *get_pings (int);
ping *put_pings (int, ping *);
int get_msg (char *, int);
void do_pings (void);
int ping_time (int);
void ping_remailer (int);
void insert_ping (int, int);
void roll_ping (stats *, ping *);
void handle_mail (void);
char *handle_msg (char *, int);
int prefix (char *, char *);
int prefixi (char *, char *);
int lookup_remailer (char *);
int register_response (int, int);
void dump_msg (char *, int, int);
void report (int);
void report_all (void);
void debug_rolling (int);
void make_report (void);
void report_hist (int, char *);
