/*
 * main.c        1.1 4/30/95
 *
 *      (c) Copyright 1995 by Lance Cottrell. All right reserved.
 *      The author assumes no liability for damages resulting from the
 *      use of this software, even if the damage results from defects in
 *      this software. No warranty is expressed or implied.
 *
 *      This software is being distributed under the GNU Public Licence,
 *      see the file GNU.license for more details.
 *
 *                      - Lance Cottrell (loki@obscura.com) 4/23/95
 *
 */

#include <stdio.h>

#include <string.h>

#ifndef i386
#include <malloc.h>
#endif


#include "mixmaster.h"
#include "crypt.h"


char    mix_dir[80] = "/usr9/loki/Devel/Mix";
char    KEYFILE[256] = "mix.key";
char    HELPFILE[256]="mix.help";
char    REMAILERNAME[80] = "The Nately Remailer";
char    SHORTNAME[80] = "mix-foo";
char    REMAILERADDR[80] = "mixmaster@nately.ucsd.edu";
char    COMPLAINTS[80] =  "complaints@nately.ucsd.edu";
int     POOLSIZE = 0;
char    REMAILERLIST[80] = "type2.list";
char    IDLOG[80] = "packet.id.log";
char    STATS[80] = "stats.log";
char    SENDMAIL[80] = "/usr/lib/sendmail ";
char    ABILITIES[80] = "capabilities";
char    MAILtoNEWS[80] = "@news.demon.co.uk";
char	TYPE1[256] = ""; /* Default is no Type 1 support */


int init_mix()
{
        FILE    *fptr;
        char    line[256],junk[80],*foo, *getenv();
        FILE    *fp;
        byte    audio_block[1042],privseed[2048];
        int     i;


        strcpy(mix_dir,SPOOL);
        foo = getenv("MIXPATH"); /* environment variable replaces defined
value */
        if(foo) {
          strcpy(mix_dir,foo);
        }

        if((fptr = (FILE *)open_mix_file("mixmaster.conf","r"))==NULL) {
          return(-1);
        } else {
          while(fgets(line,255,fptr)!=NULL){
           if(line[0] != '#' && strlen(line) > 2) {
            if(strstr(line,"mix_dir")!=NULL) {
              sscanf(line,"%s %s",junk,mix_dir);
            }
            if(strncmp(line,"help",4)==0){
              sscanf(line,"%s %s",junk,HELPFILE);
            }
            if(strncmp(line,"key",3)==0){
              sscanf(line,"%s %s",junk,KEYFILE);
            }
            if(strncmp(line,"SHORTNAME",sizeof("SHORTNAME")-1)==0){
              sscanf(line,"%s %s",junk,SHORTNAME);
            }
            if(strncmp(line,"REMAILERADDR",sizeof("REMAILERADDR")-1)==0){
              sscanf(line,"%s %s",junk,REMAILERADDR);
            }
            if(strncmp(line,"REMAILERNAME",sizeof("REMAILERNAME")-1)==0){
              foo = line;
              while(*foo > ' ') foo++; /* scan to first space */
              while(*foo <=' ') foo++; /* scan to fist non whitespace */
              strcpy(REMAILERNAME,foo);
              if(REMAILERNAME[strlen(REMAILERNAME)-1]<=' ')
	         REMAILERNAME[strlen(REMAILERNAME)-1]=0;
            }
            if(strncmp(line,"TYPE1",sizeof("TYPE1")-1)==0){
              foo = line;
              while(*foo > ' ') foo++; /* scan to first space */
              while(*foo <=' ') foo++; /* scan to fist non whitespace */
              strcpy(TYPE1,foo);
              if(TYPE1[strlen(TYPE1)-1]<=' ')
	         TYPE1[strlen(TYPE1)-1]=0;
            }
            if(strncmp(line,"COMPLAINTS",sizeof("COMPLAINTS")-1)==0){
              sscanf(line,"%s %s",junk,COMPLAINTS);
            }
            if(strncmp(line,"POOLSIZE",sizeof("POOLSIZE")-1)==0){
              sscanf(line,"%s %d",junk,&POOLSIZE);
            }
            if(strncmp(line,"REMAILERLIST",sizeof("REMAILERLIST")-1)==0){
              sscanf(line,"%s %s",junk,REMAILERLIST);
            }
            if(strncmp(line,"IDLOG",sizeof("IDLOG")-1)==0){
              sscanf(line,"%s %s",junk,IDLOG);
            }
            if(strncmp(line,"STATS",sizeof("STATS")-1)==0){
              sscanf(line,"%s %s",junk,STATS);
            }
            if(strncmp(line,"ABILITIES",sizeof("ABILITIES")-1)==0){
              sscanf(line,"%s %s",junk,ABILITIES);
            }
            if(strncmp(line,"MAILtoNEWS",sizeof("MAILtoNEWS")-1)==0){
              sscanf(line,"%s %s",junk,MAILtoNEWS);
            }
            if(strncmp(line,"SENDMAIL",sizeof("SENDMAIL")-1)==0){
              foo = line;
              while(*foo > ' ') foo++; /* scan to first space */
              while(*foo <=' ') foo++; /* scan to fist non whitespace */
              strcpy(SENDMAIL,foo);
              if(SENDMAIL[strlen(SENDMAIL)-1]<=' ')
	         SENDMAIL[strlen(SENDMAIL)-1]=0;
              strcat(SENDMAIL," "); /* Need a trailing space */
            }
           } /* if not comment */
          }
          fclose(fptr);
        }
        init_our_random();
}



int dump_to_file(char   *filename)
/*
  dumps stdin to a file. Returns the name
  of the file in filename. Returns 0 on error, else > 0
*/
{
        int     fd,len,in;
        char    chunk[1025],name[80]="";
        FILE	*fptr;

        in = fileno(stdin);
        strcpy(name,"tmpM");
	if((fptr = tempfile(name))==NULL) return(0);
        fd = fileno(fptr);
        strcpy(filename,name);
        while((len = read(in,chunk,1024)) > 0) {
          write(fd,chunk,len);
        }
        fclose(fptr);
        if(len == 0) {
          return(1);
        } else {
          unlink(name);
        }
        return(0);
}

int file_to_out(char    *filename)
/*
  dumps a file to stdout. Returns the name
  Filename sent in variable filename. Returns 0 on error, else > 0
*/
{
        int     fd,len,out;
        char    chunk[1024],name[80]="";

        fd = open(filename,O_RDONLY);
        out = fileno(stdout);
        if(fd <= 0) return(0);
        while((len = read(fd,chunk,1024)) > 0) {
          write(out,chunk,len);
        }
        close(fd);
        if(len == 0) {
          return(1);
        }
        return(0);
}

void help_files(int type, char *tmpfile)
{
        char address[256], outfile[256]="", line[256];
        FILE *fp,*pp;

        get_from(tmpfile, address);
        if(strlen(address)<=1) return;

        switch(type) {
        case 100: strcpy(outfile,HELPFILE); break;
        case 101: stats(FL_STATS,address); return; /* send useage stats */
        case 200: strcpy(outfile,KEYFILE); break;
        case 201: strcpy(outfile,ABILITIES); break;
        }
        if(strlen(outfile)>1) {
          if((fp = open_mix_file(outfile,"r"))==NULL) return;
          strcpy(line,SENDMAIL);
          strcat(line,address);
          if((pp = popen(line,"w"))==NULL) return;
          while(fgets(line,255,fp)!=NULL) {
            fputs(line,pp);
          }
          fclose(fp);
          pclose(pp);
        }
}
int     kind_of_message(char *filename)
/*
  Returns -1 if error
  Returns 0 if not a remailer message
  Returns 1 if normal remailer message
  Returns 2 if a type 2 remailer
  Returns 100 this is a request for the help file
  Returns 101 this is a request for the remailer usage statistics
  Returns 200 request for the remailer's public key
  Returns 201 request for remailer configuration line (flags indicating
abilities)
*/
{
        FILE    *fptr,*block;
        char    line[256],buff[256],lowline[256];
        int     i,type=0;

        if((fptr = fopen(filename,"r"))==NULL) return(-1);
        fgets(line,255,fptr);
        while(line[0]!='\n' && line[0]!=':') {
          for (i = 0; i < 256; i++)
            lowline[i] = safe_tolower(line[i]);
          if(strstr(line,"Subject") != NULL) {
            if(strstr(lowline,"remailer-help")) type = 100;
            if(strstr(lowline,"help")) type = 100;
            if(strstr(lowline,"remailer-stats")) type = 101;
            if(strstr(lowline,"remailer-key")) type = 200;
            if(strstr(lowline,"remailer-conf")) type = 201;
          }
          if( strstr(lowline,"anon-to:")!=NULL ||
              strstr(lowline,"request-remailing-to:")!=NULL ||
              strstr(lowline,"remail-to:")!=NULL ||
              strstr(lowline,"anon-send-to:")!=NULL ||
              strstr(lowline,"send-to:")!=NULL) {
            type = 1;
          }
          if(type != 0) {
            fclose(fptr);
            return(type);
          }
          if(strstr(line,"From")) {
            if((block = open_mix_file("source.block","r"))!=NULL) {
              while(fgets(buff,255,block)!=NULL){
                buff[strlen(buff)-1] = 0;
                for (i = 0; i < 256; i++) /* convert blocked address to lower */
                  buff[i] = safe_tolower(buff[i]);
                if(strstr(lowline,buff)) { /*if buff is in from lowline */
                  fclose(block);
                  fclose(fptr);
                  return(-1); /* blocked address treated as an error */
                }
              }
              fclose(block);
            }
          }
          if(fgets(line,255,fptr)==NULL) break; /*scan for first blank line*/
        }
        while(line[0]=='\n' && fgets(line,255,fptr) != NULL); /*read in
next line till not blank again*/
        if(strcmp(line,"::\n")!=0) {  /* if first non blank is not :: then
not a remailer message */
          type=0;
        } else { /* It is a remailer */
          fgets(line,255,fptr);
          if(strstr(line,"Remailer-Type:")==NULL) { /* All Type 2 messages
start with this so if it is not...*/
            type =1;
          } else {
            type =2;
          }
        }
        fclose(fptr);
        return(type);
}

main(int argc, char *argv[])
{
        FILE    *fptr, *lockptr;
        char    line[256],tmpfile[80];
        int     i,error,type;
        int     rem=0, snd=0, lat=0, chain=0, gen=0;


        init_mix();
        

        for(i=1; i<argc;i++) {
          if(strchr(argv[i],'-')!=NULL) {
            if(strstr(argv[i],"-R")!=NULL) rem=1;
            if(strstr(argv[i],"-S")!=NULL) snd=1;
            if(strstr(argv[i],"-L")!=NULL) lat=1;
            if(strstr(argv[i],"-G")!=NULL) gen=1;
            if(strstr(argv[i],"-c")!=NULL) chain=1;
          }
        }

        if(!rem && !snd && !lat && !gen) chain = 1;


        if(chain) {
          chain_2(argc, argv);
          rem=snd=lat=0; /* chain kills all others */
        }
        if(rem) {
          error = dump_to_file(tmpfile);
          if(error==0) exit(0);
          type = kind_of_message(tmpfile);
          if(type == -1){
            unlink(tmpfile);
          }
          if(type == 0) {
            file_to_out(tmpfile);
            unlink(tmpfile);
          }
          if(type == 1) {
            if(strlen(TYPE1) > 1) { /* is there a type 1 handler defined */
               type_1(tmpfile);
               stats(FL_MESSAGE | FL_OLD,NULL);
            }
            unlink(tmpfile);
          }
          if(type == 2) {
            if(type_2(tmpfile)==0) {
              stats(FL_MESSAGE | FL_NEW, NULL); /* count one type 2 message */
            }
            unlink(tmpfile);
          }
          if(type >2) { 
            help_files(type,tmpfile);
            unlink(tmpfile);
          }
        }
        if(snd) {
          mix_lock("mail",&lockptr);
          i = process_pool();
          if(i<=0) printf("Error in sending mail from the pool!\n");
          packetID_housekeeping();
          process_partial();
          mix_unlock("mail",lockptr);
        }
        if(gen) {
           generate_keys();
           generate_DH();
        }
        if(lat) {
          mix_lock("latent",&lockptr);
          process_latent();
          mix_unlock("latent",lockptr);
        }
        close_our_random();

        return(0);
}

