
/* 
 * @(#)main.c	1.26 6/14/96
 */

#include <stdio.h>
#include <stdlib.h>
#include <dirent.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <sys/time.h>
#include <fcntl.h>
#include <string.h>
#include <ctype.h>

#include "def.h"
#include "buffers.h"
#include "message.h"
#include "md5.h"

FILE	*mail_fp;

extern	MESSAGE_LIST	messages;
#ifndef SPAMBOT
extern	PROC	procs[];
#endif
extern	BUFFER	stdout_messages;
extern	char	our_domain[];
extern	char	*deletefrom[];
extern	char	*spamsites[];
extern	char	*spampath[];
extern	char	*spamto[];
extern	char	*spamid[];
extern	char	*alwayspass[];
extern	char	*alwayspassto[];
extern	char	*neverbounce[];
extern	char	*spammailer[];
extern	char	*spamcontents[];
extern	char	*spamsubject[];
extern	char	*spamheader[];

typedef struct _md5_val {
	struct	_md5_val	*next, *prev;

	int	sz;
	byte	md5[16];
} md5_val;

#define MD5_CACHE	100

static	md5_val	md5_cache[MD5_CACHE];
static	md5_val	*md5_head = NULL, *md5_tail = NULL;
static	char	bounce_log[1024];

typedef struct {
	char **strings[256];
	char **s;
	int  n;
} string_data;

static	string_data	header_strings;
static	string_data	body_strings;
static	string_data	mailer_strings;
static	string_data	site_strings;
static	string_data	subject_strings;

/* The number of occurences of spam-like objects per k of message
   contents before we bounce it. */

#define SPAM_THRESHOLD	30
#define SPAM_FREQUENCY	6

/* Lower limit from spam_check for a spam message */

#define MAYBE_SPAM	3

/* The number of spam-like objects in a single message before we
   delete it. */

#define DELETE_THRESHOLD 10

/* Size limit for the largest bounce message and the largest message
   we normally accept. */

#define SIZE_LIMIT	100000

char	*our_userid;
char	home_dir[] = HOME;
char	www_home[] = WWWHOME;
char	user_name[] = USERNAME;
int	verbose = FALSE;

static	int	really_send = TRUE;

#ifdef OTHER_DOMAIN 
char	other_domain[] = OTHER_DOMAIN;
#endif
char	default_mail_file [] = MAIL_FILE;

#ifndef PGPTOOLS
static	char	pgp_exec [] = PGPEXEC;
#endif

static	char	*mail_args[] =

{
#ifdef __FreeBSD__
	"/usr/sbin/sendmail",
#else
	"/usr/lib/sendmail",
#endif
	"-t",
	NULL
};

static	char	*update_args[] =

{
	NULL,
	"-h",
	NULL
};

static	char	*uu_args [] = 

{
	"/usr/bin/uuencode",
	NULL,
	NULL,
	NULL,
};

static	char	indent[] = "\n> ";

static	char	footer[] = "\n--\nProcessed by Mark's Mailbot (http://www.unicorn.com/mailbot/)\n";

/* Prototypes */

static	int	count_strings (char *s, string_data *s2);

/* Code */

static	int	dehex (char c)

{
	if (c >= '0' && c <= '9')
		return (c - '0');
	return (c - 'A' + 10);
}

static	void	update_bounce_log (MESSAGE *m, int deleted)

{
	static	FILE	*fp = NULL;

	if (!fp) {
		fp = fopen (bounce_log, "at");
		if (!fp)
			return;
	}

	fprintf (fp, "%s mail",
		(deleted) ? "Deleted" : "Bounced");
	if (m->sender)
		fprintf (fp, " from '%s'", m->sender);
	if (m->to)
		fprintf (fp, " for '%s'", m->to);
	if (m->subject)
		fprintf (fp, ", subject '%s'", m->subject);
	if (m->header_date)
		fprintf (fp, ", dated '%s'", m->header_date);
	fputc ('\n', fp);
}

static	void	copy_file (char *s, FILE *f)

{
	FILE	*i;
	char	buff[1024];
	int	c;

	i = fopen (s, "rt");
	if (!i)
		return;

	while (!feof (i)) {
		c = fread (buff, 1, 1024, i);
		if (c > 0)
			fwrite (buff, 1, c, f);
	}

	fclose (i);
}

static	void	html_end (FILE *fp, char *dat)

{
	fprintf(fp, "</FONT></BODY><HR>\n");
	fprintf(fp, "<A HREF=%scontact.html>", www_home);
	fprintf(fp, "<IMG SRC=%simages/email1.gif ", www_home);
	fprintf(fp, "width=89 height=26 align=left alt=\"Contact Info\"></A>\n");
	fprintf(fp, "Created: %s<BR>\n", dat);
	fprintf(fp, "<ADDRESS>\n");
	fprintf(fp, "Author: <A HREF=%s>%s</A>\n", www_home, user_name);
	fprintf(fp, "</HTML>\n");
}

static	void	update_spam_list (MESSAGE *m, int val) 

{
#ifndef NO_WEB_LIST
	char	file[1024];
	char	temp[1024];
	char	dat[1024];
	char	addr[1024];
	int	sz = 0;
	time_t	now;
	char	*p, *q;
	BUFFER	*mc;
	FILE	*f;

	/* Minimum of 75% certainty to get onto the page */

	if (val < (DELETE_THRESHOLD/2))
		return;

	sprintf (dat, "%s/data/spam/spam.dat", home_dir);
	sprintf (temp, "%s/data/spam/spam.size", home_dir);
	sprintf (file, "%s/public_html/spam-caught.%d.file", home_dir, getpid ());

	f = fopen (dat, "at");
	if (f) {
		fprintf (f, "<LI><I>%s</I>, %d bytes",
			m->subject ? m->subject : "None", m->size +
				m->header->size);
		if (m->email) {
			fprintf (f, ", from '<A HREF=mailto:%s>%s</A>'",
				m->email, m->sender);
		}
		if (m->header_date) {
			fprintf (f, ", dated '%s'", m->header_date);
		}

		/* Look for email addresses */

		mc = message_contents (m);
		if (mc) {
			int	first = TRUE;
			q = (char *)mc->message;
			while (*q) {

				/* Avoid spaces, then skip any HREF or
				   mailto */

				while (*q && isspace (*q)) q++;
				while (*q == '(') q++;
				while  (!strncmp (q, "HREF", 4) ||
					!strncmp (q, "mailto", 6)) {
					while (*q && !isspace (*q)) q++;
					while (*q && isspace (*q)) q++;
					while (*q == '(') q++;
				}
					
				p = q;
				while (*p && !isspace(*p) && *p != '@') p++;
				if (*p == '@') {
					/* Could be an email address */
					p++;
					while (*p && !isspace (*p) && 
						*p != '.' && *p != '@') 
						p++;
					if (*p == '.') {
						while (*p && !isspace (*p) &&
							*p != '\n' &&
							*p != ')') 
							p++;
						strncpy (addr, q, (p - q) + 1);
						addr [(p - q) + 1] = 0;
						if (first) {
							fprintf (f, ", refers to ");
							first = FALSE;
						}
						else fprintf (f, ", ");
						fprintf (f, "<A HREF=mailto:%s>%s</A>", 
							addr, addr);
					}
				}
				while (*p && !isspace (*p)) p++;
				q = p;
			}
		}

		now = time (0);
		fprintf (f, ", %d%% certainty.\n", 
			50 + ((val * 50) / DELETE_THRESHOLD));
		fclose (f);
	}

	f = fopen (temp, "rt");
	if (f) {
		fscanf (f, "%d", &sz);
		fclose (f);
	}

	sz += (m->size + m->header->size);

	f = fopen (temp, "wt");
	if (f) {
		fprintf (f, "%d\n", sz);
		fclose (f);
	}

	f = fopen (file, "wt");

	if (!f)
		return;

	sprintf (temp, "%s/data/spam/spam.top", home_dir);
	copy_file (temp, f);
	copy_file (dat, f);

	fprintf (f, "</FONT></UL>Total Spam: %d bytes\n<P>\n", sz);
	html_end (f, ctime (&now));

	if (ferror (f)) {
		fclose (f);
		unlink (file);
		return;
	}

	fclose (f);
	sprintf (temp, "%s/public_html/spam-caught.html", home_dir);

	rename (file, temp);
	chmod (temp, 0644);
#endif
}

static	void	init_md5_cache (void)

{
	int	i, j;
	md5_val	*m;
	char	file_path[1024];
	FILE	*fp;

	sprintf (file_path, "%s/in/.md5_cache", home_dir);
	if (fp = fopen (file_path, "rt")) {
		for (i = 0; i < MD5_CACHE && !feof (fp); i++) {
			do {
				j = fgetc (fp);
			} while (j != EOF && j != 's');
			fscanf (fp, "%d", &md5_cache[i].sz);
			do {
				j = fgetc (fp);
			} while (j != EOF && j != '#');
			for (j = 0; j < 16; j++) {
				md5_cache[i].md5[j] = dehex (fgetc (fp)) << 4;
				md5_cache[i].md5[j] |= dehex (fgetc (fp));
			}
		}
		fclose (fp);
	}

	m = md5_cache;
	for (i = 0; i < MD5_CACHE; i++) {
		m->prev = (m - 1);
		m->next = (m + 1);
		m++;
	}
	md5_head = md5_cache;
	md5_tail = md5_cache + (MD5_CACHE-1);
	md5_head->prev = md5_tail->next = NULL;
}

static	md5_val	*search_md5 (MESSAGE *m)

{
	md5_val	*md;
	int	i;

	md = md5_head;
	while (md) {
		if (md->sz == m->size) {
			for (i = 0; i < 16; i++) {
				if (m->md5[i] != md->md5[i])
					break;
			}
			if (i == 16)
				return md;
		}
		md = md->next;
	}
	return NULL;
}

static	void	update_md5_cache (MESSAGE *m)

{
	md5_val	*md;

	md = search_md5 (m);
	if (!md) {
		/* Not there, so put at the head */
		md = md5_tail;
		md->sz = m->size;
		memcpy (md->md5, m->md5, 16);
	}

	/* Update the tail if neccesary */

	if (md == md5_tail) {
		md5_tail = md5_tail->prev;
	}

	/* And move it to the head */

	if (md != md5_head) {
		if (md->prev)
			md->prev->next = md->next;
		if (md->next)
			md->next->prev = md->prev;

		md->next = md5_head;
		md->prev = NULL;
		md5_head->prev = md;
		md5_head = md;
	}
}

static	void	close_md5_cache (void) 

{
	FILE	*fp;
	md5_val	*md;
	char	file_path[1024];
	int	i;

	sprintf (file_path, "%s/in/.md5_cache", home_dir);
	if (!(fp = fopen (file_path, "wt")))
		return;
	for (md = md5_head; md; md = md->next) {
		fprintf (fp, "s%d ", md->sz);
		fputc ('#', fp);
		for (i = 0; i < 16; i++) {
			fprintf (fp, "%02X", md->md5[i]);
		}
		fputc ('\n', fp);
	}
	fclose (fp);
}

static	char	*strcasestr (char *s1, char *s2)

{
	char	*p, *q, *r;
	char	c1, c2, c3;

	p = s1;

	/* To speed this up we check for the upper and lower case 
	   letter each time rather than calling tolower() each time
	   around the main loop. */

	c3 = tolower (*s2);
	c2 = toupper (*s2);

	while (*p) {

		if (*p == c2 || *p == c3) {
			q = p + 1;
			r = s2 + 1;

			while (*q && *r) {
				if (tolower (*r) != tolower (*q))
					break;

				r++;
				q++;
			}
			if (!*r)
				return p;
		}

		p++;
	}

	return NULL;
}

static	int	read_line (fp, l)

FILE	*fp;
char	*l;

{
	int	c;

	while ((c = getc(fp)) != EOF && c != '\n')
		*l++ = c;
	*l = 0;

	return (c == EOF);
}

static	void	reply_to (b, m, s, u, r)

BUFFER	*b;
MESSAGE	*m;
char	*s, *u, *r;

{
	char	line[1024];
	char	*to;

	to = m->email;
	if (m->reply_to)
		to = m->reply_to;

	sprintf (line, "From: %s@%s\n", u, our_domain);
	string_to_buffer (b, line);
	sprintf (line, "To: %s\n", to);
	string_to_buffer (b, line);
	sprintf (line, "Subject: %s\n", s);
	string_to_buffer (b, line);
	sprintf (line, "Reply-To: %s@%s\n\n", r, our_domain);
	string_to_buffer (b, line);
}

int	bounce_message (m, u, r, sub)

MESSAGE	*m;
char	*r, *u, *sub;

{
	BUFFER	*b, *mc;
	char	line[1024];
	char	*to, *s;
	int	i, l;
	int	status;

	if (!sub)
		sub = r;

	to = m->email;
	if (m->reply_to)
		to = m->reply_to;
	if (m->errors_to)
		to = m->errors_to;

	s = to;
	while (*s && *s != '@') s++;
	if (!*s) {
		/* Local address; junk it */

		update_md5_cache (m);
		return TRUE;
	}

	/* Check to see if this is an address we shouldn't bounce */

	for (i = 0; neverbounce[i]; i++) {
		if (strstr (to, neverbounce[i]))
			return TRUE;
	}

	b = new_buffer ();
	sprintf (line, "From: postmaster@%s\n", our_domain);
	string_to_buffer (b, line);
	sprintf (line, "To: %s\n", to);
	string_to_buffer (b, line);
	sprintf (line, "Reply-To: /dev/null@%s\n", our_domain);
	string_to_buffer (b, line);
	sprintf (line, "Subject: %s\n", sub);
	string_to_buffer (b, line);

	string_to_buffer (b, "\n\nMessage processing failed because:\n\n");
	string_to_buffer (b, r);
	sprintf (line, "\n\nSend mail to help@%s for helpfile.", our_domain);
	string_to_buffer (b, line);
	string_to_buffer (b, "\n\nOriginal message follows :\n\n");

	s = (char *)m->header->message;
	l = m->header->length;

	while (l) {
		i = 0;
		while (l && *s != '\n') {
			l--;
			line [i++] = *s++;
		}
		if (l) {
			l--;
			s++;
		}
		line[i] = 0;

		if (strncmp (line, "Received:", 9)) {
			string_to_buffer (b, indent);
			string_to_buffer (b, line);
		}
	}

	string_to_buffer (b, indent);

	mc = message_contents (m);
	l = mc->length;
	s = (char *)mc->message;

	/* Don't send huge bounce messages, and allow slack in case we
	   get a bounced bounce. */

	if (l > (SIZE_LIMIT - 10000))
		l = (SIZE_LIMIT - 10000);

	while (l) {
		string_to_buffer (b, indent);
		while (*s != '\n' && l) {
			add_to_buffer (b, s++, 1);
			l--;
		}
		if (l) {
			s++;
			l--;
		}
	}

	string_to_buffer (b, footer);

	if (really_send)
		status = run_program(mail_args[0],b->message,
				b->length,mail_args,NULL);
	else
		status = 0;

	free_buffer (b);

	if (!status)
		update_md5_cache (m);

	return !status;
}

/* Look for bad path */

static	int	check_path (m, u, s)

MESSAGE	*m;
char	*s, *u;

{
	char	fail[1024];

	if (strstr (s, "..")) {
		sprintf(fail, "Dodgy path %s", s);
		bounce_message (m, u, fail, NULL);

		return TRUE;
	}

	if (access (s, R_OK)) {
		sprintf (fail, "No such file %s", s);
		bounce_message (m, u, fail, NULL);

		return TRUE;
	}

	return FALSE;
}

int	send_html (m, u, s)

MESSAGE	*m;
char	*s, *u;

{
	BUFFER	*b;
	int	fd, status;
	char	subj[1024];
	char	local[1024];
	char	line[1024];
	char	filename[1024];
	char	uufile[1024];
	int	encoded = FALSE;
	int	l;

	if (!m->subject) {
		return bounce_message (m, u, "Must include file path in subject", NULL);
	}

	s = m->subject;

	/* Strip the prefix if they included it */

	if (!strncmp (s, www_home, strlen(www_home)))
		s += strlen(www_home);

	sprintf(local, "%s/public_html/%s", home_dir, s);

	if (check_path (m, u, local))
		return TRUE;

	/* Check for a .htaccess file */

	strcpy (line, local);
	l = strlen (line) - 1;
	while (l && line[l] != '/')
		l--;

	strcpy (filename, line + l + 1);

	sprintf(line + l, "/.htaccess");
	if (!access (line, F_OK)) {
		char	fail [1024];
		
		sprintf(fail, "Access denied to %s/%s", www_home,
			s);
		return bounce_message (m, u, fail, NULL);
	}

	/* Check suffix */

	l = strlen (filename) - 1;
	while (l && filename[l] != '.')
		l--;

	if (!strcmp (filename + l, ".gif") ||
		!strcmp (filename + l, ".jpg") ||
		!strcmp (filename + l, ".jpeg") ||
		!strcmp (filename + l, ".mpeg") ||
		!strcmp (filename + l, ".mpg")) {

		/* We need to uuencode this ! */

		uu_args[1] = local;
		uu_args[2] = filename;

		status = run_program(uu_args[0],local,
			0,uu_args,NULL);

		if (status)
			return FALSE;

		sprintf(uufile, "/tmp/uu.%d.%d", time(0), getpid());
		fd = open (uufile, O_WRONLY|O_CREAT, 0600);

		if (!fd)
			return FALSE;

		if (write (fd, stdout_messages.message, 
			stdout_messages.length) != stdout_messages.length) {
			close (fd);
			unlink (uufile);
			return FALSE;
		}
		close (fd);

		strcpy (local, uufile);
		encoded = TRUE;
	}

	/* Now copy the file */

	fd = open (local, O_RDONLY);
	if (fd < 0) {
		char	fail[1024];

		sprintf (fail, "No such file %s/%s", www_home, s);
		return bounce_message (m, u, fail, NULL);
	}

	b = new_buffer();
	sprintf(subj, "File %s/%s", www_home, s);
	reply_to (b, m, subj, u, u);

	do {
		l = read (fd, line, 1024);
		add_to_buffer (b, line, l);
	} while (l > 0);

	close (fd);

#ifndef SAFE
	if (encoded)
		unlink (uufile);
#endif

	/* Call Sendmail */

	string_to_buffer (b, footer);

	if (really_send)
		status = run_program(mail_args[0],b->message,
			b->length,mail_args,NULL);
	else
		status = 0;

	free_buffer (b);

	return !status;
}

/* Is it a character from A-z ? */

static	int	isrealalpha (c)

char	c;

{
	if (c < 'A' || c > 'z' || (c < 'A' && c > 'z'))
		return FALSE;
	return TRUE;
}

#ifndef SPAMBOT
/* Process an update on what I'm doing */

int	process_update (m, u, f)

MESSAGE	*m;
char	*f, *u;

{
	BUFFER	*decrypted, *sign, *indexfile;
	int	status;
	char	filename[1024];
	char	line[1024];
	char	l[1024];
	char	url[1024];
	char	*s;
	char	*sub, *dat;
	int	fd, i;
	FILE	*fp;
	static	char	latest[] = "\tLatest Info\n\t===========\n\n";
	static	char	date[] = "\nDate: ";
	static	char	subject[] = "\nSubject: ";
	static	int	count = 0;
	BUFFER	*b, *acc;
	char	datafile[1024];
	char	lockfile[1024];
	char	fail[4096];
	int	cnt = 250;

	if (!(m->flags & (MESS_SIGNED|MESS_ENCRYPTED))) {
		char	fail[1024];

		if (verbose)
			printf("Message not encrypted: bouncing!\n");
		sprintf(fail, "No such user : %s", m->to);
		return bounce_message (m, u, fail, NULL);
	}

	decrypted = new_buffer ();
	sign = new_buffer ();

	status = decrypt_message (message_contents(m), decrypted,
		sign, NULL, FL_ASCII, NULL);

	if (verbose)
		printf("Signature status: %d\n", status);
	if (status != SIG_GOOD) {
		if (verbose)
			printf("Bad signature, bouncing!\n");
		free_buffer (decrypted);
		sprintf(fail, "Bad PGP Signature!\nStatus: %d, errors: %s", 
			status,
			sign->message);
		free_buffer (sign);
		return bounce_message (m, u, fail, "Bad PGP Signature");
	}

	free_buffer (sign);
	sprintf(filename, "%s/data/latest.txt", home_dir);
	fd = open (filename, O_WRONLY|O_CREAT, 0600);

	if (fd < 0)  {
		if (verbose)
			printf("Failed to open %s\n", filename);
		free_buffer (decrypted);
		return FALSE;
	}

	write (fd, latest, strlen (latest));

	sub = m->subject;
	if (!sub)
		sub = "No Subject";
	dat = m->header_date;
	if (!dat)
		dat = "No Date";

	write (fd, subject, sizeof(subject));
	write (fd, sub, strlen (sub));

	write (fd, date, sizeof(date));
	write (fd, dat, strlen (dat));

	write (fd, "\n\n", 2);

	if (write (fd, decrypted->message, decrypted->length) !=
		decrypted->length) {
		if (verbose)
			printf("Failed to write message contents!\n");
		free_buffer (decrypted);
		close (fd);
		unlink (filename);
		return FALSE;
	}
	if (verbose)
		printf("Wrote message to latest file!\n");

	close (fd);

	i = 0;
	do {
		sprintf (url, "%s/%d.%d.%d.html", u,
			time (0), getpid(), 
			count++);
		sprintf (filename, "%s/public_html/%s", home_dir, url);
		fp = fopen (filename, "wt");
	} while (!fp && i++ < 100);

	if (!fp) {
		if (verbose)
			printf("Failed to create HTML file %s!\n", filename);
		free_buffer (decrypted);
		return FALSE;
	}

	if (strncasecmp(decrypted->message, "<HTML>", 6)) {
		int	italics = FALSE;
		int	new_para = TRUE;
		int	indented = FALSE;
	
		/* Ok, now we have an html file */

		fprintf(fp, "<HTML>\n<BODY BGCOLOR=#f0f0f0>");
		fprintf(fp, "<TITLE>%s</TITLE>\n", sub);
		fprintf(fp, "<CENTER><H1>%s</H1></CENTER>\n", sub);

		fprintf(fp, "<FONT SIZE=+1>\n");
		s = (char *)decrypted->message;
		i = decrypted->length;
		while (i && *s) {
			if (new_para && !italics && isrealalpha (*s)) {
				fprintf(fp, "<FONT SIZE=+2>%c</FONT>", *s);
				new_para = FALSE;
				goto next_char;
			}
			if (*s == '\n') {
				fputc (*s, fp);
				if (s[1] == '\n') {
					fprintf(fp, "\n<P>");
					s++;
					i--;
				}
				if (*s && s[1] == '-' && s[2] == '-') {
					fprintf (fp, "<UL>\n");
					s += 2;
					i -= 2;
					indented = TRUE;
				}
				else if (indented) {
					fprintf (fp, "</UL>\n");
					indented = FALSE;
				}
			}
			else if (*s == '*') {
				if (italics) 
					fprintf (fp, "</I>");
				else 
					fprintf (fp, "<I>");
				italics = !italics;
			}
			else if (*s == ';' || *s == '8') {
				if (s[1] == '-' && s[2] == ')') {
					fprintf(fp, "<IMG SRC=\"%s/images/smiley.gif\" width=11 height=11 alt=\"%c-)\">", www_home, *s);
					s += 2;
					i -= 2;
				}
				else
					fputc (*s, fp);
			}
			else
				fputc (*s, fp);

		next_char:
			s++;
			i--;
		} 

		html_end (fp, dat);
	}
	else {
		fwrite ((char *)decrypted->message, decrypted->length,
			1, fp);
	}
	fclose (fp);

	chmod (filename, 0644);
	if (verbose)
		printf("Created HTML file %s\n", filename);

	sprintf (datafile, "%s/data/%s/%s.dat", home_dir, u, u);
	sprintf (lockfile, "%s.lock", datafile);

	while ((fd = creat (lockfile, 0) < 0) && --cnt > 0)
		sleep (50000);

	if (cnt)
		close (fd);

	fp = fopen (datafile, "at");
	if (!fp) {
		if (verbose)
			printf("Failed to open datafile %s\n", datafile);
		unlink (filename);
		unlink (lockfile);
		return FALSE;
	}

	if (really_send) {
		fprintf (fp, "%s/%s\n", www_home, url);
		fprintf (fp, "%s (%s)\n", sub, dat);
	}

	fclose (fp);

	/* Now we need to create index.html */

	sprintf(datafile, "%s/public_html/update/index.html", home_dir);

	indexfile = new_buffer ();
	if (really_send)
		run_program(update_args[0], NULL, 0, update_args, indexfile);

	fp = fopen (datafile, "wt");
	if (!fp) {
		if (verbose)
			printf("Failed to open datafile %s\n", datafile);
		free_buffer (indexfile);
		unlink (filename);
		unlink (lockfile);
		return FALSE;
	}

	fwrite ((char *)indexfile->message, indexfile->length,
			1, fp);
	fclose (fp);
	free_buffer (indexfile);
	unlink (lockfile);

	b = new_buffer ();
	acc = new_buffer ();
	reply_to (acc, m, "Update accepted", u, u);

	string_to_buffer (acc, "Update `");
	string_to_buffer (acc, sub);
	string_to_buffer (acc, "\' accepted as ");
	string_to_buffer (acc, url);
	string_to_buffer (acc, ".\n\n");
	string_to_buffer (acc, "Sent to:\n");

	/* Now we have to send the message to all subscribers */

	/* First we find the mailing list file */

	if (*f != '/')
		sprintf (filename, "%s/%s", home_dir, f);
	else
		strcpy (filename, f);

	/* And lock it */

	sprintf (lockfile, "%s.lock", filename);
	while ((fd = creat (lockfile, 0)) < 0 && --cnt > 0)
		usleep (50000);

	if (cnt)
		close (fd);

	fp = fopen(filename, "rt");

	if (fp) {
		clear_buffer (b);
		while (!feof(fp)) {

			/* Read each address */

			if (!read_line (fp,l)) {

				/* Aargh, we're hard-coded */

				sprintf (line, "From: %s-list@%s\n", 
					u, our_domain);
				string_to_buffer (b, line);
				sprintf (line, "To: %s\n", l);
				string_to_buffer (b, line);
				string_to_buffer (acc, "\t");
				string_to_buffer (acc, l);
				string_to_buffer (acc, "\n");
				if (m->subject)
					sprintf (line, "Subject: %s\n", 
						m->subject);
				else
					strcpy (line, "Subject: No Subject\n");
				string_to_buffer (b, line);
				sprintf (line, "Reply-To: %s@%s\n", 
					our_userid,
					our_domain);
				string_to_buffer (b, line);

				add_to_buffer (b, decrypted->message,
					decrypted->length);

				sprintf (line, "\n\nTo unsubscribe, send mail to %s-list@unicorn.com with a\n", u);
				string_to_buffer (b, line);
				string_to_buffer (b, "subject of 'unsubscribe ");
				string_to_buffer (b, l);
				string_to_buffer (b, "' (no quotes).\n");
				string_to_buffer (b, "If ");
				string_to_buffer (b, l);
				string_to_buffer (b, " is a mailing list, then all recipients of\n");
				string_to_buffer (b, "that list will be unsubscribed from the update list.\n");

				string_to_buffer (b, footer);
				status = run_program(mail_args[0],b->message,
					b->length,mail_args,NULL);
				clear_buffer (b);
			}
		}
		fclose (fp);
	}

	unlink (lockfile);

	string_to_buffer (acc, footer);
	if (really_send)
		run_program(mail_args[0],acc->message, acc->length,
			mail_args,NULL);
	free_buffer (acc);

	free_buffer (decrypted);
	free_buffer (b);

	if (verbose)
		printf("Processed update!\n");
	return TRUE;
}

#define	RES_SUB		1
#define RES_UNSUB	2
#define RES_HELP	3
#define RES_WHO		4
#define RES_NONE	0

static	int	check_line (s)

char	*s;

{
	if (!strncasecmp (s, "sub", 3)) {
		return RES_SUB;
	}
	if (!strncasecmp (s, "unsub", 5)) {
		return RES_UNSUB;
	}
	if (!strncasecmp (s, "help", 4) ||
		!strncasecmp (s, "info", 4)) {
		return RES_HELP;
	}
	if (!strncasecmp (s, "who", 3))
		return RES_WHO;
	return RES_NONE;
}

static	void	list_dat_file (char *s, char *n)

{
	if (*s != '/')
		sprintf (n, "%s/%s/list.dat", home_dir, s);
	else
		sprintf (n, "%s/list.dat", s);
}

static	int	check_in_file (char *s, char *u)

{
	char	lockfile[1024];
	char	l[1024];
	int	fd;
	int	cnt = 250;
	FILE	*fp;

	if (!u)
		return FALSE;

	/* And lock it */

	sprintf (lockfile, "%s.lock", s);
	while ((fd = creat (lockfile, 0)) < 0 && --cnt > 0)
		usleep (50000);

	if (cnt)
		close (fd);

	/* Now we check to see if we're in here */

	if (!(fp = fopen (s, "rt"))) {
		unlink (lockfile);
		return -1;
	}

	while (!feof(fp)) {

		/* Read each address */

		if (!read_line (fp,l)) {
			if (!strcasecmp (l, u)) {
				fclose (fp);
				unlink (lockfile);
				return TRUE;
			}
		}
	}

	fclose (fp);
	unlink (lockfile);

	return FALSE;
}

static	int	check_subscriber (char *s, char *u)

{
	char	filename[1024];
	int	subscribed;

	if (!u)
		return FALSE;

	/* First we find the mailing list file */

	list_dat_file (s, filename);

	subscribed = check_in_file (filename, u);

	if (subscribed) 
		return TRUE;
	
	sprintf (filename, "%s/%s/alternate.dat", home_dir, s);
	return check_in_file (filename, u);
}

static	int	check_blocked (char *s, char *u)

{
	char	n[1024];

	if (*s != '/')
		sprintf (n, "%s/%s/block.dat", home_dir, s);
	else
		sprintf (n, "%s/block.dat", s);

	return check_in_file (n, u);
}

/* 
 * Needs: allow list for unsubscribes, confirmation for subscribes.
 */

int	process_mailing_list (m, u, s)

MESSAGE	*m;
char	*s, *u;

{
	char	**update_list;
	int	update_list_size;
	int	update_count = 0;
	char	filename[1024];
	char	lockfile[1024];
	char	newfile[1024];
	char	line[1024];
	int	cnt = 500;
	int	res;
	FILE	*fp;
	char	*p = NULL;
	char	*c;
	int	i;
	int	fd;

	/* process the message */

	res = RES_NONE;
	if (m->subject) {
		res = check_line (p = m->subject);
	}
	if (res == RES_NONE) {
		BUFFER	*mc;

		mc = message_contents (m);
		if (mc)
			res = check_line (p = (char *)mc->message);
	}

	/* Send help file if requested, or if there's no subject
	   and no body. */

	if (!p || res == RES_HELP) {
		sprintf(filename, "%s/%s/list.help", home_dir, s);
		return send_file (m, u, filename);
	}

	/* OK, find the address !*/

	while (!isspace(*p) && *p && *p != '\n')
		p++;

	if (*p)
		while (*p && isspace (*p) && *p != '\n')
			p++;
	
	if (!*p || *p == '\n')
		p = m->email;

	/* We don't understand the message here, so pass it through */

	if (!s || !p || res == RES_NONE) {
		return scan_and_save_message (m, u, default_mail_file);
	}

	/* Erase anything at the end of the address */

	c = p;
	while (*c && !isspace(*c))
		c++;
	*c = 0;

	/* Check whether they're blocked */

	if (res == RES_SUB) {
		int	block;

		block = check_blocked (s, p);

		/* Retry on error */

		if (block < 0)
			return FALSE;

		if (block) {
			update_bounce_log (m, FALSE);
			return bounce_message (m, u, 
				"You have been blocked from this list.",
				NULL);
		}
	}

	if (res == RES_WHO) {
		if (check_subscriber(s, p)) {
			list_dat_file (s, filename);
			return send_file (m, u, filename);
		}
		else {
			update_bounce_log (m, FALSE);
			return bounce_message (m, u, 
				"Only subscribers can retrieve the list of members.",
				NULL);
		}
	}

	/* Lock the data file */

	list_dat_file (s, filename);
	
	sprintf (lockfile, "%s.lock", filename);
	while ((fd = creat (lockfile, 0)) < 0 && --cnt > 0)
		usleep (50000);

	if (cnt)
		close (fd);

	update_list_size = 1024;
	if (!(update_list = 
		(char **)malloc (update_list_size * sizeof (char *)))) {
		unlink (lockfile);
		return FALSE;
	}

	fp = fopen (filename, "rt");
	if (!fp) {
		free (update_list);
		unlink (lockfile);
		return FALSE;
	}

	/* read the list */

	while (!feof(fp)) {
		read_line (fp, line);
		if (!feof(fp)) {
			update_list[update_count++] = strdup (line);
			if (update_count == update_list_size) {
				update_list_size += 1024;
				if (!(update_list = (char **)realloc (update_list,
					update_list_size * sizeof (char *)))) {
					unlink (lockfile);	
					return FALSE;
				}
			}
		}
	}

	fclose (fp);

	/* Are we already there? */

	for (i = 0; i < update_count; i++) {
		if (update_list[i] && !strcasecmp (update_list[i], p)) {
			free (update_list[i]);
			update_list[i] = NULL;
		}
	}

	sprintf (newfile, "%s.%d.new", filename, getpid());
	fp = fopen (newfile, "wt");
	if (!fp) {
		unlink (lockfile);
		return FALSE;
	}

	chmod (newfile, 0644);

	if (res == RES_SUB)
		fprintf (fp, "%s\n", p);
	for (i = 0; i < update_count; i++) {
		if (update_list[i]) {
			fprintf (fp, "%s\n", update_list[i]);
			free (update_list[i]);
		}
	}
	free (update_list);

	if (ferror (fp)) {
		fclose (fp);
		unlink (lockfile);
		unlink (newfile);
		return FALSE;
	}

	fclose (fp);

	rename (newfile, filename);
	unlink (lockfile);

	if (res == RES_SUB) {
		sprintf (newfile, "%s.sub", filename);
	}
	else
		sprintf (newfile, "%s.unsub", filename);

	/* Fake a reply-to: line so that we reply to the correct
	   person */

	if (m->reply_to)
		free (m->reply_to);

	m->reply_to = strdup (p);

	return send_file (m, u, newfile);
}

int	mailing_list (MESSAGE *m, char *u, char *s)

{
	int	status = TRUE;
	char	filename[1024];
	char	line[1024];
	char	email[1024];
	char	l[1024];
	int	i, fd;
	int	first = TRUE;
	FILE	*fp;
	static	int	count = 0;
	BUFFER	*b, *mb;
	char	datafile[1024];
	char	lockfile[1024];
	int	cnt = 250;
	int	subscribed;

	/* Now we have to send the message to all subscribers */

	subscribed = check_subscriber (s, m->email);
	if (subscribed < 0)
		return FALSE;

	if (!subscribed) {
		update_bounce_log (m, FALSE);
		return bounce_message (m, u, 
			"You are not subscribed to this list.",
			NULL);
	}

	sprintf (email, "%s@%s", u, our_domain);

	/* Check for loops */

	if (m->xloop && !strcasecmp (email, m->xloop)) {
		return save_message (m, u, u);
	}

	/* First we find the mailing list file */

	list_dat_file (s, filename);

	/* And lock it */

	sprintf (lockfile, "%s.lock", filename);
	while ((fd = creat (lockfile, 0)) < 0 && --cnt > 0)
		usleep (50000);

	if (cnt)
		close (fd);

	fp = fopen(filename, "rt");

	if (fp) {
		b = new_buffer ();
		sprintf (line, "From: %s\n", m->sender);
		string_to_buffer (b, line);
		sprintf (line, "To: %s-members@%s\n", u, our_domain);
		string_to_buffer (b, line);
		sprintf (line, "Errors-To: postmaster@%s\n", our_domain);
		string_to_buffer (b, line);
		sprintf (line, "Reply-To: %s@%s\n", u, our_domain);
		string_to_buffer (b, line);
		sprintf (line, "X-Loop: %s@%s\n", u, our_domain);
		string_to_buffer (b, line);
		string_to_buffer (b, "Bcc: ");

		while (!feof(fp)) {

			/* Read each address */

			if (!read_line (fp,l)) {
				if (first)
					first = FALSE;
				else
					string_to_buffer (b, ",");
				string_to_buffer (b, l);
			}
		}
		string_to_buffer (b, "\n");
		if (m->subject)
			sprintf (line, "Subject: %s\n", m->subject);
		else
			strcpy (line, "Subject: No Subject\n");
		string_to_buffer (b, line);
		if (m->message_id) {
			sprintf (line, "Message-Id: %s\n", m->message_id);
			string_to_buffer (b, line);
		}
		string_to_buffer (b, "\n");
		fclose (fp);

		mb = message_contents (m);
		add_to_buffer (b, mb->message, mb->length);

		sprintf (line, "\n------------------------------------------------------------\nTo unsubscribe, send mail to %s-request@%s with a\n", u, our_domain);
		string_to_buffer (b, line);
		string_to_buffer (b, "subject of 'unsubscribe' (no quotes).\n");

		status = !run_program(mail_args[0],b->message,
					b->length,mail_args,NULL);
	}

	unlink (lockfile);

	free_buffer (b);

	if (verbose)
		printf("Processed mailing list!\n");
	return status;
}

int	process_update_list (m, u, s)

MESSAGE	*m;
char	*s, *u;

{
	char	**update_list;
	int	update_list_size;
	int	update_count = 0;
	char	filename[1024];
	char	lockfile[1024];
	char	newfile[1024];
	char	line[1024];
	int	cnt = 500;
	int	res;
	FILE	*fp;
	char	*p = NULL;
	char	*c;
	int	i;
	int	fd;

	/* process the message */

	res = RES_NONE;
	if (m->subject) {
		res = check_line (p = m->subject);
	}
	if (res == RES_NONE) {
		BUFFER	*mc;

		mc = message_contents (m);
		if (mc)
			res = check_line (p = (char *)mc->message);
	}

	/* Send help file */

	if (res == RES_HELP) {
		sprintf(filename, "%s/data/list.help", home_dir);
		return send_file (m, u, filename);
	}

	/* OK, find the address !*/

	while (!isspace(*p) && *p)
		p++;

	if (*p)
		while (*p && isspace (*p))
			p++;
	
	if (!*p)
		p = m->email;

	/* We don't understand the message here, so pass it through */

	if (!s || !p || res == RES_NONE) {
		return scan_and_save_message (m, u, default_mail_file);
	}

	/* Erase anything at the end of the address */

	c = p;
	while (*c && !isspace(*c))
		c++;
	*c = 0;

	/* Check whether they're blocked */

	if (res == RES_SUB) {
		int	block;

		block = check_blocked (s, p);

		/* Retry on error */

		if (block < 0)
			return FALSE;

		if (block) {
			update_bounce_log (m, FALSE);
			return bounce_message (m, u, 
				"You have been blocked from this list.",
				NULL);
		}
	}

	/* Lock the data file */

	if (*s != '/')
		sprintf (filename, "%s/%s", home_dir, s);
	else
		strcpy (filename, s);
	
	sprintf (lockfile, "%s.lock", filename);
	while ((fd = creat (lockfile, 0)) < 0 && --cnt > 0)
		usleep (50000);

	if (cnt)
		close (fd);

	update_list_size = 1024;
	if (!(update_list = 
		(char **)malloc (update_list_size * sizeof (char *)))) {
		unlink (lockfile);
		return FALSE;
	}

	fp = fopen (filename, "rt");
	if (!fp) {
		free (update_list);
		unlink (lockfile);
		return FALSE;
	}

	/* read the list */

	while (!feof(fp)) {
		read_line (fp, line);
		if (!feof(fp)) {
			update_list[update_count++] = strdup (line);
			if (update_count == update_list_size) {
				update_list_size += 1024;
				if (!(update_list = (char **)realloc (update_list,
					update_list_size * sizeof (char *)))) {
					unlink (lockfile);	
					return FALSE;
				}
			}
		}
	}

	fclose (fp);

	/* Are we already there? */

	for (i = 0; i < update_count; i++) {
		if (update_list[i] && !strcasecmp (update_list[i], p)) {
			free (update_list[i]);
			update_list[i] = NULL;
		}
	}

	sprintf (newfile, "%s.%d.new", filename, getpid());
	fp = fopen (newfile, "wt");
	if (!fp) {
		unlink (lockfile);
		return FALSE;
	}

	chmod (newfile, 0644);

	if (res == RES_SUB)
		fprintf (fp, "%s\n", p);
	for (i = 0; i < update_count; i++) {
		if (update_list[i]) {
			fprintf (fp, "%s\n", update_list[i]);
			free (update_list[i]);
		}
	}
	free (update_list);

	if (ferror (fp)) {
		fclose (fp);
		unlink (lockfile);
		unlink (newfile);
		return FALSE;
	}

	fclose (fp);

	rename (newfile, filename);
	unlink (lockfile);

	if (res == RES_SUB) {
		sprintf (newfile, "%s.sub", filename);
	}
	else
		sprintf (newfile, "%s.unsub", filename);

	/* Fake a reply-to: line so that we reply to the correct
	   person */

	if (m->reply_to)
		free (m->reply_to);

	m->reply_to = strdup (p);

	return send_file (m, u, newfile);
}

int	process_www_update (m, u, s)

MESSAGE	*m;
char	*s, *u;

{
	BUFFER	*decrypted, *sign;
	int	status;
	char	filename[1024];
	char	local[1024];
	char	fail[4096];
	int	fd, i;
	FILE	*fp;
	BUFFER	*b;

	if (!m->subject) {
		return bounce_message (m, u, "Must include file path in subject", NULL);
	}

	if (!(m->flags & (MESS_SIGNED|MESS_ENCRYPTED))) {
		char	fail[1024];

		sprintf(fail, "No such user : %s", m->to);
		return bounce_message (m, u, fail, NULL);
	}

	decrypted = new_buffer ();
	sign = new_buffer ();

	status = decrypt_message (message_contents(m), decrypted,
		sign, NULL, FL_ASCII, NULL);

	if (status != SIG_GOOD) {
		free_buffer (decrypted);
		sprintf(fail, "Bad PGP Signature!\nStatus: %d, errors: %s", 
			status, sign->message);
		free_buffer (sign);
		return bounce_message (m, u, fail, "Bad PGP Signature");
	}

	free_buffer (sign);
	s = m->subject;

	/* Strip the prefix if they included it */

	if (!strncmp (s, www_home, strlen(www_home)))
		s += strlen(www_home);

	sprintf(local, "%s/public_html/%s", home_dir, s);

	if (strstr (local , "..")) {
		char	fail[1024];

		sprintf(fail, "Dodgy path %s", s);
		bounce_message (m, u, fail, NULL);

		free_buffer (decrypted);

		return TRUE;
	}

	/* We now have the data and the file */

	sprintf(filename, "%s.tmp", local);

	/* We need to check that all directories exist */

	fd = open (filename, O_WRONLY|O_CREAT, 0644);

	if (fd < 0) {
		char	fail[1024];

		free_buffer (decrypted);

		sprintf(fail, "Cannot open %s", filename);
		return bounce_message (m, u, fail, NULL);
	}

	if (!chmod (filename, 0644) ||
		write (fd, decrypted->message, decrypted->length) !=
		decrypted->length) {
		close (fd);
		free_buffer (decrypted);
		return FALSE;
	}

	close (fd);
	free_buffer (decrypted);

	/* Copy the file over */

	if (rename (filename, local) < 0) {
		unlink (filename);
		return FALSE;
	}

	/* Tell the sender that we accepted it */

	b = new_buffer ();
	reply_to (b, m, "WW update accepted", u, u);

	string_to_buffer (b, "WWW update to ");
	if (m->subject)
		string_to_buffer (b, m->subject);
	string_to_buffer (b, " accepted.\n");

	string_to_buffer (b, footer);
	if (really_send)
		run_program(mail_args[0],b->message, b->length,
			mail_args,NULL);

	free_buffer (b);
	return TRUE;
}

/* Send a file to the person who mailed us */

int	send_file (m, u, s)

MESSAGE	*m;
char	*s, *u;

{
	BUFFER	*b;
	int	fd, status;
	char	subj[1024];
	char	local[1024];
	char	line[1024];
	int	l;

	/* If it doesn't begin with a /, then it's a local file */

	if (*s != '/') {
		sprintf(local, "%s/%s", home_dir, s);
		s = local;
	}

	if (check_path (m, u, s))
		return TRUE;

	fd = open (s, O_RDONLY);
	if (fd < 0) {
		char	fail[1024];

		sprintf (fail, "No such file %s", s);
		return bounce_message (m, u, fail, NULL);
	}

	b = new_buffer();
	if (m->subject)
		sprintf (subj, "Re: %s", m->subject);
	else
		sprintf(subj, "File %s", s);

	reply_to (b, m, subj, u, u);

	do {
		l = read (fd, line, 1024);
		add_to_buffer (b, line, l);
	} while (l > 0);

	close (fd);

	/* Call Sendmail */

	string_to_buffer (b, footer);

	if (really_send)
		status = run_program(mail_args[0],b->message,
			b->length,mail_args,NULL);
	else
		status = 0;

	free_buffer (b);

	return !status;
}

/* Just junk the message */

int	junk_message (m, u, s)

MESSAGE	*m;
char	*s, *u;

{
	return TRUE;
}
#endif

static	char	mailbomb[] = "Thanks for mail-bombing my site. I may well inform your postmaster\nafter I finish sorting out this mess.\n\n";

int	respond_to_spam (MESSAGE *m, char *u, char *s)

{
	if (m->size > 250000) {
		BUFFER *b;
		char	bomb_path[1024];
		FILE	*fp;
		int	status;

		sprintf (bomb_path, "%s/mailbomb.dat", home_dir);
		fp = fopen (bomb_path, "at");
		if (fp) {
			fprintf (fp, "%s %s %d\n", m->email, m->header_date,
				m->size);
			fclose (fp);
		}

		b = new_buffer();
		reply_to (b, m, "Your Mail", "postmaster", "/dev/null");

		add_to_buffer (b, mailbomb, strlen (mailbomb));
		add_to_buffer (b, s, strlen (s));

		/* Call Sendmail */

		if (really_send)
			status = run_program(mail_args[0],b->message,
				b->length,mail_args,NULL);
		else
			status = 0;

		free_buffer (b);

		return !status;
	}
	return bounce_message (m, u, s, "Forged spam");
}

int	save_message (m, u, s)

MESSAGE	*m;
char	*s, *u;

{
	char	local[1024];

	/* If it doesn't begin with a /, then it's a local mail file */

	if (*s != '/') {
		sprintf(local, "%s/mail/%s", home_dir, s);
		s = local;
	}

	if (!really_send)
		return TRUE;

	if (!append_message_to_file (m, s))
		return TRUE;
	return FALSE;
}

int	save_for_remailing (MESSAGE *m, char *u, char *s)

{
	char	path[1024];
	char	path2[1024];
	struct	timeval	tp;
	static	int	cnt = 0;

	gettimeofday(&tp, NULL);

	sprintf (path, "%s/%s/tmp%d.%ld.%d.%ld.%d.%s", home_dir, s, getpid (),
		tp.tv_usec, cnt++, tp.tv_sec, m->size, m->email);
	sprintf (path2, "%s/%s/in%d.%ld.%d.%ld.%d.%s", home_dir, s, getpid (),
		tp.tv_usec, cnt++, tp.tv_sec, m->size, m->email);
	if (!save_message (m, u, path))
		return FALSE;

	/* Avoid race conditions by renaming after writing, and delete
	   the lock file which tells us that there are no messages
	   waiting. */

	rename (path, path2);
	sprintf (path, "%s/%s/none", home_dir, s);
	unlink (path);

	return TRUE;
}

static	int	spam_check (MESSAGE *m)

{
	int	i;
	BUFFER	*mc;
	char	*b = NULL;
	int	cnt = 0;
	int	sc, up = 0;
	int	ret = 0;

	/* Accept any PGP-signed email for now. Spammers are too lame
	   to sign! */

	if (m->flags & MESS_SIGNED)
		return 0;

	/* Always accept alwayspassto[], for bcc check */

	if (m->to) {
		for (i = 0; alwayspassto[i]; i++) {
			if (strcasestr (m->to, alwayspassto[i])) {
				if (verbose) {
					printf ("Passing %s as it's to %s\n",
						m->subject, m->to);
				}
				return 0;
			}
		}
	}
	if (m->cc) {
		for (i = 0; alwayspassto[i]; i++) {
			if (strcasestr (m->cc, alwayspassto[i])) {
				if (verbose) {
					printf ("Passing %s as it's to %s\n",
						m->subject, m->cc);
				}
				return 0;
			}
		}
	}

	/* Otherwise bounce bcc */

	if (m->flags & MESS_BCC) {
		if (verbose) {
			printf ("Bouncing %s from %s because of bcc:\n",
				m->subject, m->email);
		}
		ret++;
	}

	/* Check for received: line after subject */

	if (m->flags & MESS_DUBIOUS_REC) {
		if (verbose) {
			printf("Dubious received lines.\n");
		}
		ret += 3;
	}

	/* Probably spam if more than fifty recipients */

	if (m->recipient_count > 50) {
		if (verbose) {
			printf("Too many recipients.\n");
		}
		ret += 2;
	}

	/* Probably spam if there's an X-UIDL header */

	if (m->xuidl) {
		if (verbose) {
			printf("XUIDL in header.\n");
		}
		ret += 2;
	}

	/* Look for $ signs in subject */

	if (m->subject) {
		char	*p;
		int	wds;

		p = m->subject;
		cnt = 0;

		while (*p) {
			if (*p++ == '$')
				cnt++;
		}

		ret += (cnt / 2);

		/* Also look for magic words in the subject */

		wds = count_strings (m->subject, &subject_strings);

		ret += wds;

		/* If we found any magic words then look for ! as well */

		if (wds) {
			p = m->subject;
			cnt = 0;

			while (*p) {
				if (*p++ == '!')
					cnt++;
			}

			ret += cnt;
		}
	}

	/* Do the hard work */

	if (m->email) {
		int	num = TRUE;
		int	dot = FALSE;
		char	*p;

		/* Look for email address with purely numeric domain	
		   name; should be impossible for a real address */

		p = m->email;
		while (*p && *p != '@') {
			if (!isdigit (*p))
				num = FALSE;
			p++;
		}

		/* Could be a freaky but valid address so far */

		if (num)
			ret++;

		if (*p)
			p++;

		if (isdigit(*p)) {
			num = TRUE;
			while (*p && *p != '.') {
				if (!isdigit(*p))
					num = FALSE;
				p++;
			}

			if (*p == '.')
				dot = TRUE;

			/* This is almost certainly invalid */

			if (num)
				ret += 4;
		}
		else {
			while (*p && *p != '.') p++;
			if (*p)
				dot = TRUE;
		}

		/* Should always be a dot in a domain name! */

		if (!dot)
			ret += 2;

		/* We always pass these addresses */

		for (i = 0; alwayspass[i]; i++) {
			if (strcasestr (m->email, alwayspass[i])) {
				if (verbose) {
					printf("Always pass %s\n",
						m->email);
				}
				return 0;
			}
		}

		/* But these are assumed to be spam sites */

		for (i = 0; spamsites[i]; i++) {
			if (strcasestr (m->email, spamsites[i])) {
				if (verbose) {
					printf ("Spam site %s\n",
						m->email);
				}
				ret += 2;
			}
		}
	}

	if (m->to) {
		for (i = 0; alwayspassto[i]; i++) {
			if (strstr (m->to, alwayspassto[i]))
				return 0;
		}
		for (i = 0; spamto[i]; i++) {
			if (strstr (m->to, spamto[i])) {
				if (verbose) {
					printf("Spam to: %s\n",
						m->to);
				}
				ret += 2;
			}
		}
	}
	if (m->mailer) {
		for (i = 0; spammailer[i]; i++) {
			if (strstr (m->mailer, spammailer[i])) {
				if (verbose) {
					printf ("Spam mailer %s\n",
						m->mailer);
				}
				ret += 4;
			}
		}
	}
	if (m->message_id) {
		for (i = 0; spamid[i]; i++) {
			if (strstr (m->message_id, spamid[i])) {
				if (verbose) {
					printf ("Spam id %s\n",
						m->message_id);
				}
				ret++;
			}
		}
	}
	if (m->path) {
		for (i = 0; spampath[i]; i++) {
			if (strstr (m->path, spampath[i])) {
				if (verbose) {
					printf("Spam path %s\n",
						m->path);
				}
				ret++;
			}
		}
	}

	/* We also check the message contents */

	mc = message_contents (m);
	if (mc->length)
		b = (char *) mc->message;

	/* Look for spamsites as well as contents */

	if (b) {
		cnt = count_strings (b, &body_strings);
		cnt += 3 * count_strings (b, &mailer_strings);
		cnt += 5 * count_strings (b, &site_strings);

		/* Add one per forty upper case characters. */

		for (i = 0; b[i]; i++)
			if (isupper(b[i]))
				up++;

		/* Scale it by the message size */

		sc = ((mc->length + 512) / 1024);
		if (sc < 1)
			sc = 1;
		if (sc > 10)
			sc = 10;

		/* Update return value */

		ret += (cnt / SPAM_FREQUENCY);
	
		if (cnt >= SPAM_THRESHOLD || cnt >= (SPAM_FREQUENCY * sc)) {
			if (verbose) {
				printf("Message '%s' failed with spam-count %d\n",
					m->subject, cnt);
			}
			ret += 3;
		}
		else {
			if (verbose) {
				printf ("Message '%s' passed with spam-count %d\n", 
					m->subject, cnt);
			}
		}
	}

	if (verbose) {
		printf ("Returning %d for message '%s' from '%s'\n", ret,
			m->subject, m->sender);
	}

	/* Return the results */

	return ret;
}

static	int	scan_dupes (MESSAGE *m)

{
	if (search_md5 (m)) {
		if (verbose) {
			printf ("Ignoring duplicate message.\n");
		}
		return save_message (m, "postmaster", "dupe");
	}
	return FALSE;
}

static	char	spam_mess[] = "Your email message was bounced by Mark's spam-filter. This means that\nthe program thinks that it's unrequested junk-mail. If this message is\nnot junk-mail then please either sign it with PGP or resend it to my\nlow-priority mailbox at mark+notspam@unicorn.com. I will then read it as\nsoon as I have some spare time. Do not reply directly to this message or\nyour response will be lost in the ether.\n\nI am sorry if the program has bounced your mail by mistake, but I no\nlonger have time to deal with junk-mail by hand.\n";

static	char	too_big[] = "Your message is over the 100k limit for messages to this address. Please\nwrite for alternate arrangements for message delivery.\n\n";

int	spam_checked_mailing_list (MESSAGE *m, char *u, char *s)

{
	int	i, ok;

	if ((i = spam_check (m)) < (MAYBE_SPAM*2)) {
		ok = mailing_list (m, u, s);
	}
	else {
#ifndef BOUNCE_SPAM
		if (i < DELETE_THRESHOLD) {
			if (scan_dupes (m))
				return TRUE;
			ok = save_message (m, u, "list-spam");
		}
		else {
			if (verbose) {
				printf ("Deleting message '%s' as spam!\n",
					m->subject);
			}
			update_spam_list (m, i);
			update_bounce_log (m, TRUE);
			ok = TRUE;
		}
#else
		ok = bounce_message (m, u, spam_mess, m->subject ? 
			m->subject : "Spam Alert");
#endif
	}

	return ok;
}

int	scan_and_save_message (MESSAGE *m, char *u, char *s)

{
	int	i;
	int	ok;

	if (verbose) {
		printf("Scan_and_save_message %s, for %s to %s\n",
			m->subject, u, s);
	}

	/* These are probably bounces */

	if (m->email && (!strncasecmp (m->email, "MAILER-DAEMON", 13) ||
		!strncasecmp (m->email, "postmaster", 10))) {
		return save_message (m, "postmaster", "bounce");
	}

	/* Some things we just autodelete, as they're obviously
	   spam. */

	if (m->email) {
		for (i = 0; deletefrom[i]; i++) {
			if (strcasestr (m->email, deletefrom[i])) {
				update_spam_list (m, DELETE_THRESHOLD);
				update_bounce_log (m, TRUE);
				return TRUE;
			}
		}
	}

	/* And delete anything which has the magic words in the header */

	if (m->header && m->header->message) {
		if (count_strings (m->header->message, &header_strings)) {
			update_spam_list (m, DELETE_THRESHOLD);
			update_bounce_log (m, TRUE);
			return TRUE;
		}
	}

	/* Check for large messages */

	if (m->size > SIZE_LIMIT) {
		return bounce_message (m, u, too_big, m->subject ? 
			m->subject : "Message Too Large");
	}	

	if ((i = spam_check (m)) < MAYBE_SPAM) {
		if (scan_dupes (m))
			return TRUE;
		ok = save_message (m, u, s);
		if (ok)
			update_md5_cache (m);
	}
	else {
#ifndef BOUNCE_SPAM
		if (i < DELETE_THRESHOLD) {
			update_spam_list (m, i);
			if (scan_dupes (m))
				return TRUE;
			ok = save_message (m, u, "spam");
		}
		else {
			if (verbose) {
				printf ("Deleting message '%s' as spam!\n",
					m->subject);
			}
			update_spam_list (m, i);
			update_bounce_log (m, TRUE);
			ok = TRUE;
		}
#else
		ok = bounce_message (m, u, spam_mess, m->subject ? 
			m->subject : "Spam Alert");
#endif
	}

	if (ok)
		update_md5_cache (m);
	return ok;
}

#define MAX_SIZE 65535

#ifndef SPAMBOT
int	maybe_save_message (m, u, s)

MESSAGE	*m;
char	*s, *u;

{
	char	local[1024];
	struct	stat	st;
	BUFFER	*mc;

	/* If it doesn't begin with a /, then it's a local mail file */

	if (*s != '/') {
		sprintf(local, "%s/mail/%s", home_dir, s);
		s = local;
	}

	if (!stat (s, &st)) {
		mc = message_contents (m);
		if (st.st_size + mc->length > MAX_SIZE) {
			char	fail[1024];

			sprintf(fail, "Mail quota exceeded for user %s", u);
			update_bounce_log (m, FALSE);
			bounce_message (m, u, fail, NULL);
			return TRUE;
		}
	}

	return save_message (m, u, s);
}

int	process_message (m, uid, email)

MESSAGE	*m;
char	*uid;
char	*email;

{
	PROC	*p;
	char	fail [1024];

	/* Just in case */

	sprintf(fail, "No such user : %s", email);
	update_random ();

	/* Special case for bounces */

	if (m->email && !strncmp (m->email, "MAILER-DAEMON", 13)) {
		return save_message (m, "postmaster", "bounce");
	}

	p = procs;
	while (p->uid) {
		if (!strcasecmp (p->uid, uid)) {
			return (*p->proc) (m, uid, p->data);
		}
		p++;
	}
	update_bounce_log (m, FALSE);
	bounce_message (m, uid, fail, NULL);

	return TRUE;
}
#endif

static	int	count_uids (s)

char	*s;

{
	int	n;
	int	quoted = FALSE;

	if (!s)
		return 0;

	n = 0;
	while (*s) {
		while (*s == ' ' || *s == '\t')
			s++;
		if (*s)
			n++;
		while (*s && (*s != ',' || quoted)) {
			if (*s == '\"')
				quoted = !quoted;
			s++;
		}
		if (*s)
			s++;
	}

	return n;
}

static	char	**extract_uids (n, s)

char	**n;
char	*s;

{
	char	*e, *c;
	int	quoted = FALSE;

	if (!s)
		return (n);

	while (*s) {
		while (*s == ' ' || *s == '\t')
			s++;
		if (*s) {
			e = s;
			while (*e && (quoted || *e != ',')) {
				if (*e == '\"')
					quoted = !quoted;
				e++;
			}

			*n = malloc (e - s + 1);

			/* Abort if malloc fails */

			if (!*n) {
				exit (1);
			}

			/* Horrid hack to deal with different address
			   forms */
		
			c = s;
			while (c < e && *c && *c != '<') c++;
			if (*c == '<') {
				/* Damn, we have a <email> address */
				s = c + 1;
			}

			c = *n;

			while (s != e && *s != '>' && *s != ';')
				*c++ = *s++;

			s = e;
			if (*s)
				s++;
	
			*c = 0;
			n++;
		}
	}

	return n;
}

static	int	my_strcmp (const void *p1, const void *p2)

{
	char	**a, **b;

	a = (char **)p1;
	b = (char **)p2;

	if (!*a || !*b)
		return (*b - *a);
	return strcmp (*a, *b);
}

/* Since we may have tens or hundreds of messages to process, we save
   time by doing the slow setup operation only once. */

static	void	setup_strings (char **s, string_data *p)

{
	int	i, j;
	int	o = (-1);

	/* Count entries */

	for (i = 0; s[i]; i++);

	p->n = i;
	p->s = s;

	/* Zero the strings array */

	for (j = 0; j < 256; j++)
		p->strings[j] = NULL;

	/* Just in case */

	if (!i)
		return;

	/* Sort the input string */

	qsort (s, i, sizeof (char *), my_strcmp);

	/* Now set up the table */

	for (j = 0; j < i; j++) {
		if (s[j][0] != o) {
			p->strings[o = s[j][0]] = s + j;
		}
	}

}

/* Fast scan for strings. */

static	int	count_strings (char *s, string_data *s2)

{
	char	**p, *q, *r;
	int	n = 0;

	/* Just in case */

	if (!s2->n)
		return 0;

	/* Now do the main loop */

	while (*s) {
		if (s2->strings[*s]) {
			p = s2->strings[*s];
			while (*p && **p == *s) {
				q = s + 1;
				r = *p + 1;
				while (*q && *r == *q) {
					r++;
					q++;
				}
				if (!*r) {
					n++;
				}

				p++;
			}
		}
		s++;
	}
	return n;
}

static	char	**get_uids (m)

MESSAGE	*m;

{
	int	n, c;
	char	**uids;
	char	**nids;
	char	**new;

	n = count_uids (m->to) + count_uids (m->cc) +
		count_uids (m->apparently_to) + 
		count_uids (m->received_to);

	m->recipient_count = n;

	if (!n)
		return NULL;

	uids = (char **)malloc ((n + 1) * sizeof (char *));

	if (!uids) {
		exit (1);
	}


	nids = extract_uids (uids, m->to);
	nids = extract_uids (nids, m->cc);
	nids = extract_uids (nids, m->apparently_to);
	nids = extract_uids (nids, m->received_to);
	*nids = NULL;


	qsort (uids, n, sizeof (char *), my_strcmp);


	c = 0;
	nids = new = uids;

	/* Need to do unique stuff here */

	while (*nids) {
		if (!nids[1] || strcmp (*nids, nids[1])) {
			if (nids != new) {
				if (*new)
					free (*new);
				*new = *nids;
				*nids = 0;
			}
			new++;
		}
		nids++;
	}
	while (nids != new) {
		if (*new) 
			free (*new);
		*new++ = NULL;
	}

	return uids;
}

static	void	free_uids (u)

char	**u;

{
	char	**s;

	s = u;
	while (*s) {
		free (*s);
		s++;
	}

	free (u);
}

int	process_mail_file (s)

char	*s;

{
	MESSAGE	*m, *newm;
	char	uid[1024], domain[1024];
	char	fail[1024];
	char	lock_file[1024];
	int	i, j;
	int	ok = FALSE;
	char	**uids;
#ifdef SPAMBOT
	char	notspam[1024];

	sprintf (notspam, "%s+notspam", user_name);
#endif

	sprintf (lock_file, "%s.lock", s);
	read_mail_file (s);

	/* Always delete empty files. */

	if (!messages.number)
		return TRUE;

	/* Now process any messages we have. */

	m = messages.start;
	while (m) {
		char	*t;
		char	**u;
		char	*this_id;
		int	local = FALSE;
		int	bcc = TRUE;

		/* Just in case */

		uids = get_uids (m);

		/* Check for BCC: */

		if (m->to) {
			if (strcasestr (m->to, our_domain))
				bcc = FALSE;
#ifdef OTHER_DOMAIN
			if (strcasestr (m->to, other_domain))
				bcc = FALSE;
#endif
		}
		if (m->cc && bcc) {
			if (strcasestr (m->cc, our_domain))
				bcc = FALSE;
#ifdef OTHER_DOMAIN
			if (strcasestr (m->cc, other_domain))
				bcc = FALSE;
#endif
		}

		/* Is it a bcc? */

		if (bcc) {
			m->flags |= MESS_BCC;
			if (verbose) {
				printf ("Message %s from %s to %s, cc %s is bcc\n",
					m->subject, m->email, m->to, m->cc);
			}
		}
		else
			m->flags &= ~MESS_BCC;

		if (uids) {
			u = uids;

			while (t = *u) {

				while (*t && *t != '<')
					t++;
				if (*t) {
					char	*s;

					s = t + 1;
					while (*t && *t != '>')
						t++;

					if (*t)
						*t = 0;
					t = s;
				}
				else
					t = *u;

				this_id = t;

				i = j = 0;
				while (*t && *t != '@')
					uid[j++] = *t++;
				uid[j] = 0;

				j = 0;
				if (*t) {
					t++;
					while (*t)
						domain[j++] = *t++;
				}
				domain[j] = 0;


				/* For the spambot we save any messages
				   to the notspam address and scan any
				   others for evidence of spamness. We
				   must only save one copy! */

				if (!strcasecmp(domain, our_domain)
#ifdef SPAMBOT
					&& !strcasecmp (uid, notspam) && !local
#endif
					) {
					local = TRUE;
#ifndef SPAMBOT
					ok = process_message (m, uid, this_id);
#else
					ok = save_message (m, uid,
						default_mail_file);
#endif
				}
				u++;
			}


			/* If no local addresses, then save */

			if (!local)
				ok = scan_and_save_message (m, uid, 
					default_mail_file);

			free_uids (uids);
		}
		else
#ifndef SPAMBOT
			ok = save_message (m, "postmaster", default_mail_file);
#else
			ok = scan_and_save_message (m, uid, default_mail_file);
#endif

		m = m->next;
	}

	/* For safety we unlink the messages first in case we've got
	   any malloc problems */

#ifndef SAFE
	if (ok && really_send)
		unlink (s);
#endif

	/* Free them off */

	m = messages.start;
	while (m) {
		newm = m->next;
		free_message (m);
		m = newm;
	}

	messages.start = messages.end = NULL;
	messages.number = 0;

	return ok;
}


int	process_outgoing_mail (s)

char	*s;

{
	MESSAGE	*m, *newm;
	int	ok = TRUE;
	BUFFER	*b, *mc;

	read_mail_file (s);

	b = new_buffer();

	m = messages.start;
	while (m) {

		/* Should remove Status: lines here! */

		add_to_buffer (b, m->header->message, m->header->length);

		mc = message_contents (m);
		add_to_buffer (b, mc->message, mc->length);

		if (really_send && run_program(mail_args[0],b->message, 
			b->length,mail_args,NULL)) {
			ok = FALSE;
			break;
		}
		else if (verbose) {
			printf("Sent mail to %s", m->to);
			if (m->subject) 
				printf(", subject \"%s\"", m->subject);
			printf("\n");
		}
		save_message (m, our_userid, "sent-mail");
		clear_buffer (b);
		m = m->next;
	}

	/* Free them off */

	m = messages.start;
	while (m) {
		newm = m->next;
		free_message (m);
		m = newm;
	}

	messages.start = messages.end = NULL;
	messages.number = 0;

	return ok;
}

main(argc, argv)

int	argc;
char	*argv[];

{
	char	mail_dir[1024];
	char	mail_file[1024];
	char	new_file[1024];
	char	update_file[1024];
	char	env[1024];
	DIR	*dir;
	struct	dirent	*next;
	int	ok;
	int	arg = 1;

	/* Set the umask for security */

	umask (077);

	our_userid = cuserid (0);
	sprintf (mail_dir, "%s/in", home_dir);
	sprintf (bounce_log, "%s/bounce_log", mail_dir);

	if (!(dir = opendir (mail_dir))) {
		exit (1);
	}

	/* Set path for list_updates.cgi */

	sprintf(update_file, "%s/public_html/CGI/list_updates.cgi", home_dir);
	update_args[0] = update_file;

	sprintf(env, "PGPPATH=%s/pgp", home_dir);
	putenv (env);

	init_pgplib();
	init_md5_cache ();

	setup_strings (spamheader, &header_strings);
	setup_strings (spamcontents, &body_strings);
	setup_strings (spammailer, &mailer_strings);
	setup_strings (spamsites, &site_strings);
	setup_strings (spamsubject, &site_strings);

	while (argv[arg] && *argv[arg] == '-') {
		int	j = 1;

		while (argv[arg][j]) {	
			switch (argv[arg][j++]) {

				case 'v':
				verbose = TRUE;
				printf ("Verbose enabled.\n");
				break;

				case 'f':
				really_send = FALSE;
				printf ("Test but don't process.\n");
				break;

			}
		}
		arg++;
		argc--;
	}

	if (argc <= 1) {
		do {
			next = readdir (dir);
			if (next) {
				if (!strncmp ("in", next->d_name, 2)) {
					sprintf(mail_file, "%s/%s", mail_dir,
						next->d_name);
					ok = process_mail_file (mail_file);
#ifdef SAFE
					if (ok) {
						next->d_name[0] = 'd';
						sprintf(new_file, "%s/%s", mail_dir,
							next->d_name);
						rename (mail_file, new_file);
					}
#endif
				}
			}
		} while (next);

		closedir (dir);
	}
	else {
		process_outgoing_mail (argv[arg]);
	} 

	if (really_send)
		close_md5_cache ();
	close_pgplib();
}

#ifndef PGPTOOLS
char	*pgp_path()

{
	static	char	pgp_path[MAXPATHLEN];
	static	int	first = TRUE;

	if (first) {
	}

	if (!access (pgp_exec, X_OK))
		return pgp_exec;
	else
		return NULL;

}
#endif
