/*
 *	@(#)defs.c	1.9 6/11/96
 */

#include "def.h"

char	our_domain[] = OUR_DOMAIN;

#ifndef SPAMBOT
extern	int	save_message ();
extern	int	scan_and_save_message ();
extern	int	send_file ();
extern	int	junk_message ();
extern	int	maybe_save_message ();
extern	int	send_html ();
extern	int	process_update ();
extern	int	process_www_update ();
extern	int	process_update_list ();
extern	int	respond_to_spam ();
extern	int	save_for_remailing ();
extern	int	process_mailing_list ();
extern	int	mailing_list ();
extern	int	spam_checked_mailing_list ();

PROC procs[] =
{
	{ "mark", scan_and_save_message, MAIL_FILE },
	{ "www", scan_and_save_message, "www" },
	{ "postmaster", maybe_save_message, "postmaster" },
	{ "bot", send_file, "data/bot.txt" },
	{ "latest", send_file, "data/latest.txt" },
	{ "update-list", process_update_list, "data/update/update.lst" },
	{ "update-list-owner", maybe_save_message, "postmaster" },
	{ "pgp-keys", send_file, "data/keys.asc" },
	{ "help", send_file, "data/bot.txt" },
	{ "null", junk_message, 0 },
	{ "/dev/null", junk_message, 0 },
	{ "nobody", junk_message, 0 },
	{ "html", send_html, 0 },
	{ "update", process_update, "data/update/update.lst" },
	{ "wwwupdate", process_www_update, 0 },
	{ "list-request", process_mailing_list, "data/list" },
	{ "list", spam_checked_mailing_list, "data/list" },
	{ "list-owner", scan_and_save_message, "list-owner" },
	{ "list-members", scan_and_save_message, "list" },
	{ 0, 0, 0 },
};
#endif

/* Always accept mail from these people */

char	*alwayspass[] = {
	"mark@unicorn.com",
	0,
};

/* Always accept mail to these addresses */

char	*alwayspassto[] = {
	"technomads@ucsd.edu",
	0,
};

/* Never bounce mail from these addresses, for any reason */

char	*neverbounce[] = {
	"technomads@ucsd.edu",
	0,
};

/* Automatically delete mail from these addresses */

char	*deletefrom[] = {
	"@onestopshop.net",
	"@powerpromo.com",
	"nancynet.com",
	"ctynet.com",
	"@greenharvest.com",
	"t-1net.com",
	"@worldwidepromo.com",
	"@scans.com",
	"@savetrees.com",
	"@leavesofgreen.com",
	"@cyberpromo.com",
	"@rsa-corp.com",
	"@quantcom.com",
	"@answerme.com",
	"@newsdelivers.com",
	"@profitz.com",
	"iemmc.org",
	"knight@woody.lopernet.net",
	"@usa1-inc.com",
	"@1stworldwidemedia.com",
	0,
};

/* Mail which passed through one of these sites may be spam */

char	*spampath[] = {
	"outgoing.com",
	"thehitman.com",
	"onlinebiz.net",
	"lotsmorehits.com",
	"mail-response.com",
	"t-1net.com",
	"hitsrus.com",
	"worldwidepromo.com",
	"crushnet.com",
	"digital-market.com",
	"dynamarket@vapor.net",
	"flash.net",
	"bulk-e-mail.com",
	"iemmc.org",
	"bnoc.net",
	"cybermirror",
	"tricreations.com",
	"cableol.net",
	"savetrees.com",
	"cyberpromo.com",
	"owlsnest.com",
	"answerme.com",
	"errols.com",
	"CLOAKED",
	"---",
	"nrer.com",
	"readme.readme",
	"lunarlink.com",
	"nevwest.com",
	"netclub-usa.com",
	"cyberpot.net",
	"kcii.com",
	"jeanjacket.com",
	"spamford.com",
	"earthlink.net",
	"usa.net",
	"idci.com",
	"webcruiser.com",
	"digitalnation.co.uk",
	"marathon4",
	"nevwest.com",
	"mailermachine.com",
	"newsdelivers.com",
	"mailmachine.com",
	0,
};

/* Mail which contains one of these in the header may be spam */

char	*spamheader[] = {
	"Direct Email",
	"www.thehitman.com",
	"http://www.iemmc.org",
	"CLOAKED",
	"cyberpromo.com",
	"Email Blaster",
	"EmailBlaster",
	"FreeRelay",
	"Cyber Promotions",
	"206.85.20",
	"206.85.24",
	0,
};

/* Mail from one of these sites may be spam */

char	*spamsites[] = {
	"did-it@",
	"targ-it.com",
	"friend@",
	"onlinenow.net",
	"1stworldwidemedia.com",
	"mailermachine.com",
	"newsdelivers.com",
	"windansea1.com",
	"pointcast.net",
	"amazon.com",
	"marketit.com",
	"joinusnow.com",
	"amv-inc.com",
	"usa1-inc.com",
	"playmates.com",
	"@savetrees.com",
	"@cyberpromo.com",
	"news@iname.com",
	"@lvsweeties.com",
	"@ibabuyer.com",
	"@key-west.com",
	"@mail.inupiak.com",
	"@owlsnest.com",
	"@cartridge.com",
	"lopernet.com",
	"lopernet.net",
	"@gll.com",
	"@quantcom.com",
	"@aii.net",
	"@answerme.com",
	"inneraction.com",
	"@webcruiser.com",
	"Make@MoreMoneyNow",
	"therightway@thenerve.com",
	"beavertree.com",
	"imiak.com",
	"seductress.com",
	"pcic@genesisnetwork.net",
	"@netwest.com",
	"LSOFT.COM",
	"@wwcollectibles.com",
	"stirnnet.com",
	"mvisibility.com",
	"btinternet.com",
	"mailmachine.com",
	"inconnu.com",
	"inconnu@",
	"earthlink.net",
	"remove@",
	"nevwest.com",
	"Forsale@compuserve.com",
	"readme.com",
	0,
};

/* Mail sent with this mailer may be spam */

char	*spammailer[] =

{
	"NetMailer",
	"Extractor",
	"Floodgate",
	0,
};

/* Mail with one of these in the message ID may be spam */

char	*spamid[] = {
	"0000000000",
	"savetrees.com",
	"busamail.com",
	"mailermachine.com",
	"newsdelivers.com",
	0,
};

/* Mail sent to one of these addresses may be spam */

char	*spamto[] = {
	"friend@",
	"rjwarren@clubelite.com",
	"autosavr@albany.net",
	"you@compuserve.com",
	"email@errols.com",
	"you@domain.com",
	"@express.com",
	"zzzdoe1.com",
	"inanaround.net",
	"qlink2info.com",
	"@public.com",
	"@yourinfo.com",
	"you@out1.ibm.net",
	"users@everywhere.com",
	0,
};

/* Mail containing these words may be spam. Note: THIS IS CASE SENSITIVE! */

char	*spamcontents[] = {
	"MUST READ",
	"NEW=YORK",
	"WOODSIDE",
	"One Time Announcement",
	"affordable",
	"unsub@newsdelivers.com",
	"http://www.iemmc.org",
	"remove@",
	"'remove'",
	"SUBMITKING",
	"promoting",
	"network marketing",
	"WHO",
	"WHAT",
	"WHERE",
	"Online Sales",
	"DOUBLED",
	"Sale",
	"under 18",
	"Comission",
	"team sale",
	"FREE",
	"TODAY",
	"Hottest",
	"BUCKS",
	"GUARANTEE",
	"LOT",
	"ORDER",
	"erious enquiries",
	"erious inquiries",
	"opportunity",
	"HOME BUSINESS",
	"NO OVERHEAD",
	"NO HASSLES",
	"PERSONAL SELLING",
	"financial security",
	"exciting",
	"benefits",
	"fact-packed",
	"(800)",
	"(801)",
	"(900)",
	"(888)",
	"Marketing",
	"marketing",
	"special offer",
	"dynamic",
	"purchase",
	"CALL",
	"credit card",
	"Wealth",
	"\"remove\"",
	"\"Remove\"",
	"DO NOT HIT REPLY",
	"DO NOT REPLY",
	"one time mailing",
	"@answerme.com",
	"00.00",
	"0,000",
	"NEW",
	"MLM",
	"Direct Marketing",
	"Direct Mail",
	"RUTHLESS",
	"GREEDY",
	"Messages An Hour",
	"EXTRACT",
	"COMMISSION",
	"MUST SEE",
	"PROVEN",
	"casino.com",
	"MAILBOX",
	"MULTI LEVEL",
	"Satisfaction",
	"special invitation",
	"ONE-TIME MESSAGE",
	"Credit",
	"Financial",
	"Referral",
	"BUSINESS OPPORTUNITY",
	"Rewards",
	"Money Order",
	"Visa",
	"Mastercard",
	"MasterCard",
	"$$",
	"prices",
	"PAYMENT",
	"investing",
	"product",
	"Entrepeneur",
	"Bonus",
	"INCOME",
	"EXCLUSIVE",
	"TOP NAME",
	"NO OBLIGATION",
	"sales!",
	"MONEY BACK",
	"MONEY MAKER",
	"SHOW",
	"Big Bucks",
	"thousand dollars",
	"Multilevel Marketing",
	"wealth building",
	"home based business",
	"rich quick",
	"franchise",
	"NO RISK",
	"earning",
	"1-800-",
	"1-801-",
	"1-800-322-6169",
	"1-900-",
	"1-888-",
	"REPLY NOW",
	"NO COST",
	"check",
	"money order",
	"Friend",
	"ADS",
	"PULL",
	"Make Money",
	"Money Making",
	"FORCE",
	"100% legal",
	"100% LEGAL",
	"LIMITED TIME",
	"NO LIMIT",
	"SECRET",
	"EXPLOSIVE",
	"KILLER",
	"REPORT",
	"WEALTH",
	"Everything You Wanted to Know",
	"CASH",
	"EVERYONE",
	"VERY",
	"No Fee",
	"SERVICE",
	"DEALER",
	"GREAT",
	"MAKE MONEY",
	"report",
	"LEGITIMATE",
	"LEGAL",
	"MONEY MAKING",
	"EMAIL BLASTER",
	"EmailBlaster",
	"affordably",
	"Overcome",
	"Free ",
	"Free!",
	"Unleash",
	"Super ",
	"Achieve",
	"nd much more",
	"sex",
	"SEX",
	"SPECIAL",
	"Invest",
	"INTRODUCTORY",
	"HURRY",
	"MILLION",
	"BONUS",
	"TOLL FREE",
	"PRICE",
	"REMOVE",
	"profile",
	"COST",
	"DISCOUNT",
	"HEALTH FOOD",
	"RICH",
	"CLICK HERE",
	"Click here",
	"Click Here",
	"<FONT",
	"Copyright",
	"ABSOLUTELY",
	"SAMPLE",
	"OBLIGATION",
	"@answerme.com",
	"make money",
	"lying",
	"scam",
	"ORDER",
	"Making Money",
	"discount",
	"Dear friend",
	"Dear Friend",
	"Greetings friend,"
	"Free Money",
	"FOR REAL",
	"scam ",
	"rip off",
	"investing",
	"reply card",
	"no cost",
	"Profit",
	"Reply now",
	"rip-off",
	"90 days",
	"offer",
	"Delete",
	"REMOVAL",
	"chain letter",
	"NOT",
	"POWERFUL",
	"CHECK",
	"DEALERSHIP",
	"DON'T DELAY",
	"EXPENSES",
	"TAXES",
	"PERSONAL",
	"YOU",
	"AMERICAN EXPRESS",
	"PREVIEW",
	"FREQUENT FLYER",
	"Important",
	"VISA",
	"\"Reply\"",
	"MASTERCARD",
	"BEGINNING",
	"BILLING",
	"CREDIT CARD",
	"SAME DAY",
	"respond",
	"motivated",
	"mailings",
	"money",
	"M O N E Y",
	"O R D E R S",
	"F R E E",
	"AFFORDABLE",
	"-OR-",
	"INSTANT ACCESS",
	"Web Browser",
	"Windows 95",
	"MASS MAILING",
	"HUGE",
	"Bulk Email",
	"bulk email",
	"YOU EARN",
	"CAPTURE",
	"PRIORITY",
	"Qualifi",
	"Authoriz",
	"NETWORK-MARKETING",
	"ROYALTIES",
	"PROPRIETARY",
	"CONSULTANT",
	"Advertising",
	"MINIMAL",
	"SUCCESS",
	"TREMENDOUS",
	"Adult",
	"Password",
	"SPAM",
	"targeted mail",
	"targeted direct",
	"NEWS RELEASE",
	"income opportunity",

	/* Remove this line if people regularly send you HTML mail */

	"<HTML>",
	"\"remove\"",
	"ID#",
	"GIIC",
	"HOT",
	"INFO",
	"ONE",
	"SIGN UP",
	"Revolutionary",
	"Long Distance",
	"Rates",
	"Superb",
	"off peak",
	"rebate",
	"AMAZING",
	"DOWNLINE",
	"OPPORTUNITY",
	"Retails",
	"per day",
	"http://spamnet.com",
	"Scanned",
	"precious photographs",
	"18 years of age",
	"do not reply",
	"APHRODISIAC",
	"A Month",
	"A Day",
	"FINANCES",
	"SALES",
	"HEALTH",
	"and many more",
	"Seminar",
	"NetTV",
	0,
};

/* Mail whose subject contains these words may be spam */

char	*spamsubject[] = {
	"CHECK THIS",
	"18+",
	"NetTV",
	"A Month",
	"LOAN",
	"Money Making",
	"HOT",
	"Hot",
	"FREE",
	"TOP",
	"Homeowner",
	"HOMEOWNER",
	"PROFIT",
	"P R O F I T",
	"CASH",
	"VENDING",
	"MONEY",
	"MAKING",
	"SECRET",
	"OPPORTUNITY",
	"Adult",
	"Free ",
	"Free!",
	"For You",
	"Attention",
	"Noticed",
	"0,000",
	"Report",
	"Selling",
	"Credit Card",
	"FEES",
	"INVESTIGAT",
	"LIFETIME",
	"GUARANTEED",
	"Guaranteed",
	"REAL",
	"MLM",
	"Selling",
	"Cheapest",
	"REAL",
	"Downline",
	"DOWNLINE",
	"Long Distance",
	"Per Minute",
	"Perfect",
	"Cents",
	"/min",
	0,
};


