/* @(#)list_updates.c	1.12 6/5/96 */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <sys/stat.h>

static	char	home_dir[]=HOME;
static	char	www_home[]=WWWHOME;
static	char	user_name[]=USERNAME;

char	*bos = "updates";
char	*cbos = "Updates";
char	*back = www_home;
char	data_file[1024];
time_t	mt;

typedef struct {
	char	*desc;
	char	*url;
} UPDATE;

int	id;
int	num_entries;
int	deleted = 0;

static	int	read_line (fp, l)

FILE	*fp;
char	*l;

{
	int	c;

	while ((c = getc(fp)) != EOF && c != '\n')
		*l++ = c;
	*l = 0;

	return (c == EOF);
}

end_html (fp, s)

FILE	*fp;
char	*s;

{
	fprintf(fp, "<HR>\n");
	fprintf(fp, "<A HREF=%s/contact.html>", www_home);
	fprintf(fp, "<IMG SRC=%s/images/email1.gif ", www_home);
	fprintf(fp, "width=89 height=26 align=left alt=\"Contact Info\"></A>\n");
	fprintf(fp, "Last Update: %s<BR>", ctime(&mt));
	fprintf(fp, "<ADDRESS><A HREF=%s>%s</A>", www_home, user_name);
	fprintf(fp, "</ADDRESS></HTML>\n");
}

file_error()

{
	printf("<TITLE>Listing Failed</TITLE>\n");
	printf("<H1>Listing Failed</H1>\n");
	printf("The listing failed, due to a ");
	printf("problem accessing the database. Please try again ");
	printf("later.<P>\n");
	end_html (stdout, back);

	exit (0);
}

static	read_from_file ()

{
	FILE	*fp;
	char	line [1024];
	char	lock_file [1024];
	char	new_file [1024];
	char	filename[1024];
	int	cnt = 500;
	int	updates = 0;
	UPDATE	*list;
	int	list_size;
	int	i, fd;
	extern	char	*strdup();
	struct	stat	st;

	list_size = 1024;
	if (!(list = (UPDATE *)malloc (list_size * sizeof (UPDATE))))
		file_error ();

	/* Lock the file for exclusive access */

	sprintf (lock_file, "%s.lock", data_file);
	while ((fd = creat (lock_file, 0)) < 0 && --cnt > 0)
		usleep (50000);

	if (fd > 0)
		close (fd);

	if (stat (data_file, &st) < 0)
		file_error();

	mt = st.st_mtime;

	/* Read from file */

	fp = fopen (data_file, "rt");
	if (!fp)
		file_error ();

	while (!feof (fp)) {
		read_line (fp, line);
		if (!feof (fp)) {
			if (!(list[updates].url = strdup (line)))
				file_error();
			read_line (fp, line);
			if (!(list[updates].desc = strdup (line)))
				file_error();
			updates++;
			if (updates == list_size)  {
				list_size += 1024;
				if (!(list = (UPDATE *)realloc (list, 
					list_size * sizeof (UPDATE))))
					file_error ();
			}
		}
	}

	/* Ok, we read it! */

	fclose (fp);
	unlink (lock_file);

	sprintf(filename, "%s/data/update/start.dat", home_dir);
	fp = fopen (filename, "rt");
	if (fp) {
		do {
			i = fread (line, 1, 1024, fp);
			if (i > 0)
				fwrite (line, 1, i, stdout);
		} while (i > 0);
		fclose (fp);
	}

	printf ("<UL>\n");
	if (!updates) {
		printf ("<FONT SIZE=+1>\n");
		printf("<I>Hmm, looks like I haven't been anywhere recently!</I>\n");
		printf ("</FONT>\n");
	}
	else {
		printf("<TABLE>\n");
		for (i = (updates - 1); i >= 0; i--) {
			printf("<TR><TD><CENTER>");
			if (i == (updates - 1)) {
				printf("<IMG SRC=%s/images/hot1.gif>", www_home);
			}
			else if (!i) {
				printf("<IMG SRC=%s/images/bl_menu.gif>", www_home);
			}
			else {
				printf("<IMG SRC=%s/images/gr_menu.gif>", www_home);
			}
			printf ("</CENTER></TD><TD>");
			printf ("<FONT SIZE=+1>\n");
			printf ("<A HREF=%s>", list[i].url);
			printf ("%s</FONT></A></TD></TR>\n", list[i].desc);
		}
		printf("</TABLE>\n");
	}
	printf ("</UL>\n");

	sprintf(filename, "%s/data/update/itinerary.dat", home_dir);
	fp = fopen (filename, "rt");
	if (fp) {
		do {
			i = fread (line, 1, 1024, fp);
			if (i > 0)
				fwrite (line, 1, i, stdout);
		} while (i > 0);
	}

	sprintf(filename, "%s/data/update/end.dat", home_dir);
	fp = fopen (filename, "rt");
	if (fp) {
		do {
			i = fread (line, 1, 1024, fp);
			if (i > 0)
				fwrite (line, 1, i, stdout);
		} while (i > 0);
		fclose (fp);
	}

	printf("<HR>\n");
	printf("<I>Processed by <A HREF=http://www.c2.org/~mark/mailbot/>Mark's Mailbot</A>, &copy; <A HREF=http://www.c2.org/~mark/>Mark Grant</A> 1995-1996</I>\n");
	end_html (stdout, back);
}

main (argc, argv)

int	argc;
char	*argv[];

{
	sprintf(data_file, "%s/data/update/update.dat", home_dir);
	srandom (time(0) + getpid());

	printf("Content-type: text/html%c%c",10,10);
	read_from_file ();
	exit (0);
}
