/* active.c
reads the list of active groups
by eric hollander hh@xcf.berkeley.edu
part of my news-by-mail package
*/

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>

#include <strings.h>

#include "lines.h"
#include "nntpcodes.h"


main(int argc, char *argv[]) {
	int len, index, lindex;
	int soc;	/* the socket */
	char buf[BUFSIZ];
	char *line;

	soc = open_soc(nntp_server());

	if ((line = getline(soc)) == 0) {
		fprintf(stderr, "server not responding.\n");
		exit(1);
	}

	if(strncmp(line, WELCOME, 3) != 0) {
		fprintf(stderr, "server %s refused connection.\n",
			nntp_server());
		exit(1);
	}

	write(soc, "list\n", 5);
	line = getline(soc);
	if(strncmp(line, NEWSGROUPS, 3) != 0) {
		fprintf(stderr, "error getting list\n");
		send_quit(soc);
		exit(1);
		}
	line = getline(soc);
	while (strcmp(line, ".\n") != 0) {
		printf("%s", line);
		line = getline(soc);
		}
	send_quit(soc);
}
