#!/weblab/software/bin/perl -w

#  This is version 1.1 of Crowds
# 
#  The authors of this software are Mike Reiter and Avi Rubin
#               Copyright (c) 1997 by AT&T.
#  Permission to use, copy, and modify this software without fee
#  is hereby granted, provided that this entire notice is included in
#  all copies of any software which is or includes a copy or
#  modification of this software and in all copies of the supporting
#  documentation for such software.
# 
#  SOME PARTS OF CROWDS MAY BE RESTRICTED UNDER UNITED STATES EXPORT
#  REGULATIONS.
# 
# 
#  THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR IMPLIED
#  WARRANTY.  IN PARTICULAR, NEITHER THE AUTHORS NOR AT&T MAKE ANY
#  REPRESENTATION OR WARRANTY OF ANY KIND CONCERNING THE MERCHANTABILITY
#  OF THIS SOFTWARE OR ITS FITNESS FOR ANY PARTICULAR PURPOSE.

# This package is used to manage administrative options at the
# blender. The -h flag pretty much explains everything.

require 5.004;

use strict;
use Socket;
use Carp;
use BlockCipher;

sub logmsg;

my $param = shift || do_exit("Use -h flag for help\n");
my $username;
my $keyword;
my %Accounts;

if ($param eq "-a") {
    $username = shift || do_exit("Usage: admin -a username\n");
    add_user($username);
    exit;
}

if ($param eq "-r") {
    $username = shift || do_exit("Usage: admin -r username\n");
    remove_user($username);
    exit;
}

if ($param eq "-l") {
    list_users();
    exit;
}

if ($param eq "-p") {
    change_admin_passphrase();
    exit;
}

if ($param eq "-h") {
    print "The following options are available:\n";
    print "  -a username        Add a user\n";
    print "  -r username        Remove a user\n";
    print "  -l                 List users\n";
    print "  -p                 Change admin password\n";
    print "  -h                 Print this message\n";
    exit;
}

print "Available options: -a -r -l -p -h  Please try again.\n";
exit;


sub add_user {
    my ($new_name) = @_;
    my $admin_cipher = read_passphrase();
    my %accounts=();
    my $entry;
    my $enc_entry;
    my $passphrase1;
    my $passphrase2;


    #read in accounts and decrypt them
    dbmopen %Accounts, "accounts", 0666 or die "dbmopen: $!\n";

    $keyword = $Accounts{KEYWORD};
    $keyword = $admin_cipher->cbc_decrypt($keyword);  # read in the keyword
    if ($keyword ne "KEYWORD") {
	print "Incorrect admin passphrase.\n";
	exit;
    }
 
    if ( $Accounts{$new_name} ) {
       print "User $new_name already exists. Changing passphrase.\n";
    }
    dbmclose %Accounts;

    $passphrase1 = 1;
    $passphrase2 = 2;
    while ($passphrase1 ne $passphrase2) {

       print "Enter passphrase for $new_name: ";
       system "stty -echo";
       chop($passphrase1 = <STDIN>);
       print "\n";
       print "Enter passphrase again for confirmation: ";
       chop($passphrase2 = <STDIN>);
       print "\n";
       system "stty echo";
       
       if  ($passphrase1 ne $passphrase2) {
	   print "Passphrase mismatch, try again.\n";
       }
    }

    dbmopen %Accounts, "accounts", 0666 or die "dbmopen: $!\n";
    $Accounts{$new_name} = $admin_cipher->cbc_encrypt($passphrase1);
    dbmclose %Accounts;

    print "User $new_name has been added.\n";
}


sub remove_user {
    my ($new_name) = @_;
    my $admin_cipher = read_passphrase();
    my %accounts=();
    my $entry;
    my $enc_entry;
    my $passphrase1;
    my $passphrase2;


    #read in accounts and decrypt them
    dbmopen %Accounts, "accounts", 0666 or die "dbmopen: $!\n";

    $keyword = $Accounts{KEYWORD};
    $keyword = $admin_cipher->cbc_decrypt($keyword);  # read in the keyword
    if ($keyword ne "KEYWORD") {
        print "Incorrect admin passphrase.\n";
        exit;
    }

    # See if this user exists
    if (!defined($Accounts{$new_name}) ) {
	print "No user $new_name.\n";
        exit;
    }

    delete $Accounts{$new_name};
    dbmclose %Accounts;

    print "User $new_name has been removed.\n";
}

sub change_admin_passphrase {
    my ($new_name) = @_;
    my $admin_cipher = read_passphrase();
    my %accounts=();
    my $entry;
    my $enc_entry;
    my $passphrase1;
    my $passphrase2;
    my $new_cipher;
    my $my_key;
    my $my_block_cipher;
    my $name;
    my $pw;


    #read in accounts and decrypt them
    dbmopen %Accounts, "accounts", 0666 or die "dbmopen: $!\n";

    $keyword = $Accounts{KEYWORD};
    $keyword = $admin_cipher->cbc_decrypt($keyword);  # read in the keyword
    if ($keyword ne "KEYWORD") {
        print "Incorrect admin passphrase.\n";
        exit;
    }
    dbmclose %Accounts;

    
    $passphrase1 = 1;
    $passphrase2 = 2;
    while ($passphrase1 ne $passphrase2) {

       print "Enter new admin passphrase: ";
       system "stty -echo";
       chop($passphrase1 = <STDIN>);
       print "\n";
       print "Enter passphrase again for confirmation: ";
       chop($passphrase2 = <STDIN>);
       print "\n";
       system "stty echo";

       if  ($passphrase1 ne $passphrase2) {
           print "Passphrase mismatch, try again.\n";
       }
    }

    
    $my_key = pack("a8", $passphrase1);
    $new_cipher = BlockCipher::new($my_key);

    dbmopen %Accounts, "accounts", 0666 or die "dbmopen: $!\n";
    while (($name,$pw) = each %Accounts) {
       $Accounts{$name} = $new_cipher->cbc_encrypt($pw);
    }
    $Accounts{KEYWORD} = $new_cipher->cbc_encrypt("KEYWORD");
    dbmclose %Accounts;

    print "Admin passphrase changed.\n";
}



sub list_users {
    my $admin_cipher = read_passphrase();
    my %accounts=();
    my $entry;
    my $enc_entry;
    my $name;
    my $pw;

    #read in accounts and decrypt them
    dbmopen %Accounts, "accounts", 0666 or die "dbmopen: $!\n";

    $keyword = $Accounts{KEYWORD};
    $keyword = $admin_cipher->cbc_decrypt($keyword);  # read in the keyword
    if ($keyword ne "KEYWORD") {
        print "Incorrect admin passphrase.\n";
        exit;
    }
  
    while (($name,$pw) = each %Accounts) {
       if ($name ne "KEYWORD") {
          print "$name\n";
       }
    }
    dbmclose %Accounts;

}



sub read_passphrase {
    my $passphrase;
    my $my_key;
    my $my_cipher;

    system "stty -echo";
    print "Enter admin passphrase: ";
    chop($passphrase = <STDIN>);
    print "\n";
    system "stty echo";
    #--- TODO: What if passphrase is more than 8 chars?
    $my_key = pack("a8", $passphrase);
    $my_cipher = BlockCipher::new($my_key);

    #TODO - verify that cipher is correct

    return $my_cipher;

}

    
sub logmsg { print "$0 $$: @_ at ", scalar localtime, "\n" }

sub do_exit {
my ($string) = @_;
   print $string;
   exit;

}
