#  This is version 1.1 of Crowds
# 
#  The authors of this software are Mike Reiter and Avi Rubin
#               Copyright (c) 1997 by AT&T.
#  Permission to use, copy, and modify this software without fee is
#  hereby granted, provided that this entire notice is included in all
#  copies of any software which is or includes a copy or modification
#  of this software and in all copies of the supporting documentation
#  for such software.
# 
#  SOME PARTS OF CROWDS MAY BE RESTRICTED UNDER UNITED STATES EXPORT
#  REGULATIONS.
# 
#  THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR
#  IMPLIED WARRANTY.  IN PARTICULAR, NEITHER THE AUTHORS NOR AT&T MAKE
#  ANY REPRESENTATION OR WARRANTY OF ANY KIND CONCERNING THE
#  MERCHANTABILITY OF THIS SOFTWARE OR ITS FITNESS FOR ANY PARTICULAR
#  PURPOSE.

# This package contains routines to use with Adam Young's DES
# implementation in Perl. It porvides a simple API to those routines.

package BlockCipher;

use des;

sub new {
    my ($passphrase) = @_;
    my $key = "00000000";

    while ($passphrase =~ s/(.{1,8})//so) {
	$key ^= $1;
    }

    my @ks = des::des_set_key($key);
    return bless \@ks, 'BlockCipher';
}


sub cbc_encrypt {
    my ($ks, $ptext) = @_;
    my $ctr;
    my @ctext;

    my $pad = 8 - (length($ptext) % 8);
    $ptext .= ' 'x($pad-1) . $pad;

    $ctext[0] = pack("H*", "1234567812345678");  #need a random ivec?
    $ctr = 1;
    $ptext =~ s/(.{0,8})//so;
    while (length($1)) {
	$ctext[$ctr] = des::des_ecb_encrypt($ks, 1, $ctext[$ctr-1]^$1);
	$ctr++;
	$ptext =~ s/(.{0,8})//so;
    }

    shift @ctext;

    my $ctext = join('',unpack("H*", join('', @ctext)));
    return $ctext;
}


sub cbc_decrypt {
    my ($ks, $ctext) = @_;
    my (@ptext, $ptext, $ctr, $temp);

    $ctext = pack("H*", $ctext);
    if (length($ctext) % 8 != 0) { 
	return "";
    }

    $temp = pack("H*", "1234567812345678");  #need a random ivec?
    $ctr = 1;
    $ctext =~ s/(.{0,8})//so;
    while (length($1)) {
	$ptext[$ctr] = $temp^des::des_ecb_encrypt($ks,0,$1);
	$ctr++;
	$temp = $1;
	$ctext =~ s/(.{0,8})//so;
    }

    shift @ptext;
    $ptext = join('',@ptext);

    if ($ptext =~ /([1-8])$/) {
        return substr($ptext, 0, -$1);
    }
    else {
        return "";
    }
}

1;
