/*-------------------------*/
/* compression - decompression */
#include <stdio.h>
#include <zlib.h>

#define BSIZ 4096
int pgpcomp(FILE * inf, FILE * outf, int compr)
{
  z_stream pgpz;
  int ch;
  unsigned char ibuf[BSIZ], obuf[BSIZ];

  pgpz.zalloc = (alloc_func) 0;
  pgpz.zfree = (free_func) 0;
  pgpz.opaque = (voidpf) 0;
  if (compr) {
    fputc(0xa3, outf);
    fputc(1, outf);
    deflateInit2(&pgpz, Z_DEFAULT_COMPRESSION, Z_DEFLATED, -13, 8, 0);
  } else {
    if (fgetc(inf) != 0xa3 || fgetc(inf) != 1)
      return -1;
    inflateInit2(&pgpz, -13);   /* for pgp */
  }
  do {
    pgpz.next_in = ibuf;
    pgpz.avail_in = ch = fread(ibuf, 1, BSIZ, inf);
    while (pgpz.avail_in) {
      pgpz.next_out = obuf, pgpz.avail_out = BSIZ;
      compr ? deflate(&pgpz, 0) : inflate(&pgpz, 0);
      fwrite(obuf, 1, BSIZ - pgpz.avail_out, outf);
    }
  } while (ch == BSIZ);
  do {                          /* finish any further output */
    pgpz.next_out = obuf, pgpz.avail_out = BSIZ;
    ch = compr ? deflate(&pgpz, Z_FINISH) : inflate(&pgpz, Z_FINISH);
    fwrite(obuf, 1, BSIZ - pgpz.avail_out, outf);
  } while (ch == Z_OK);
  return (ch == Z_STREAM_END);
}
