#
# Makefile.PL for egd, the entropy gathering daemon
#
# $Id: Makefile.PL,v 1.6 1999/03/16 08:20:14 warner Exp $
#

use ExtUtils::MakeMaker;

# This module is meant to function both by itself and as a part of GnuPG.

# By itself, just build with the usual 'perl Makefile.PL; make; make test;
#  sudo make install' sequence. This will install the daemon in your standard
#  perl script directory, frequently /usr/local/bin . As a daemon process that
#  may be run by the sysadmin at startup instead of by normal users, you might
#  want it in /usr/local/sbin instead. Set INSTALLBIN as an argument (see
#  below) to accomplish this.

# As a part of GPG, this Makefile.PL is run at configure time if EGD is needed
# for this system, probably because it doesn't have /dev/random, which
# generally means anything other than Linux. The top-level configure script
# should call us with two args:
#   FULLPERL=/path/to/perl   # this is the perl5 found by configure, and must
#                              be the same one as used to run this Makefile.PL
#   INSTALLBIN=/usr/local/sbin  # this is configure's $sbindir. 'egd' goes here

# We must test for the presence of the SHA module and arrange to build/install
# a local copy if it isn't already there.


# test for SHA
eval "use SHA;"; $SHA = $@ eq "";

if ($SHA) {
    print " SHA module found.. no need to install our own.\n";
} else {
    print " SHA module not found. We will install our own.\n";
    # this means running SHA/Makefile.PL now, and adding code to the Makefile
    # to arrange for it to be built at build time, tested at test time,
    # and installed at install time. Really that means we should recurse when
    # calling WriteMakefile(), since by default it would do all those things
    # anyway.
}

sub MY::subdirs {
    package MY; # so that "SUPER" works right
    my $inherited = shift->SUPER::subdirs(@_);
    #print "SHA is $main::SHA, subdirs is $inherited\n";
    if ($main::SHA) {
	# don't need to build SHA, so leave subdirs:: target empty
	return "";
    } else {
	# need to build it.
	return $inherited;
    }
}

# this is to turn the automake-style 'check' target into a MakeMaker-style
# 'test' target.
sub MY::postamble {
    "check :: test\n";
}

WriteMakefile(
	      NAME => "egd",
	      VERSION => "0.5",
	      EXE_FILES => [qw(egd.pl)],
# recent MakeMakers will fix up the shbang line in EXE_FILES. This will
# result in /usr/local/sbin/egd.pl being installed with whatever #! line is
# appropriate for this system.
	      NORECURS => $SHA, # if SHA is present, don't recurse (skip SHA/)
	      # otherwise the SHA-1.2 directory is configured
	      PM => {}, # disable installation of egd.pl in library directory
	      'dist' => { COMPRESS => 'gzip', SUFFIX => 'gz' },
);
