/*
 * subst.h -- Header for repair substitutions
 *
 * Copyright (C) 1997 Pretty Good Privacy, Inc.
 *
 * Written by Colin Plumb
 *
 * $Id: subst.h,v 1.1 1997/07/07 21:26:40 colin Exp $
 *
 * NOTE: Other weights are hiding in the TabFilter function.
 * Remember to keep them all on the same scale.
 */

/* Do not back up more than this many characters */
#define MAX_BACK_CHARS 160

/*
 * Do not back up more than this many points.
 * The work attempted is *exponential* in this value, so don't raise it
 * too high unless you have both memory and patience to spare.
 */
#define MAX_BACK_COST  50

/*
 * There is a hack in the code to find a single substitution that will fix a
 * line, even if it's not in the tables.  It gets added to the tables "on
 * probation", and if it leads to a successful correction of the entire
 * page, is "learned" for future use.  (This is not remembered across
 * runs of the program, though.  Edit the tables in the source to fix it.)
 */
/* Cost of the a newly created substitution, "on probation" */
#define DYNAMIC_COST_GUESSED 20
/* Cost after it has been verified as useful. */
#define DYNAMIC_COST_LEARNED 10

/*
 * This negative-cost bonus for passing the end of a line with the right
 * CRC makes the search engine reluctant to backtrack past a correct CRC,
 * greatly improving efficiency.  It's rather a hack, though.  Think of
 * this in terms of "how many errors should be considered in the current
 * line before considering the possibility of errors in the previous line?"
 */
#define COST_LINE -30

/* Type describing filter functions used in substitutions */
struct ParseNode;
struct Heap;
struct Substitution;
#include "heap.h"
typedef HeapCost FilterFunc(struct ParseNode *parent, char const *limit,
	struct Substitution const *subst);
FilterFunc TabFilter;	/* The one filter func that we use */

/* The external substitution format */
typedef struct RawSubst {
	char const *input;
	char const *output;
	HeapCost cost;
	FilterFunc *filter;
} RawSubst;

/* The substitutions to make */
extern struct RawSubst const substSingles[];
extern struct RawSubst const substMultiples[];
