/*  MPGP.C  compiles under Microsoft C ver 6.0  */
/*  ver 1.0  last modified 9/14/95 */

#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <stdlib.h>
#include <process.h>
#include <io.h>
#include <errno.h>
#include <time.h>


#define NORM_FILE 0x00     // DOS attribute for normal files
#define ALL_FILES 0x1e     // DOS attribute for all files (hidden,dir,etc.)

void  main(int  argc,char  * *argv);
void  banner(void);
void  help(void);
void  do_option(char  *s);
void  do_file(char  *fullname);
int   exist(char  *fname,int attr);
void  fetch_password(void);
void  lead_zero(char  *s,unsigned int  cnt);
void  cleanup(void);
void  no_exec(void);


struct options {
       int encrypt;
       int decrypt;
       int randomize;
       int keep;
       int something;   // set to one if at least one file is processed
       int ret;         // max error return from pgp.exe
       int locked;      // set to 1 when no more options acceptable
       char zparm[4];
       char pass1[260];
       char pass2[260];
       int pass_fetched;   // set to 1 when password gotten;
       };

struct options o; // o.encrypt o.decrypt  o.randomize,etc. are global


// must link with setargv.obj to process wildcards


void main(int argc, char *argv[])
{
   extern struct options o;
   int i;

   atexit(cleanup);
   banner();
   if (argc<2) {
      help();
      exit(1);
   }
   o.zparm[0]=' ';
   o.zparm[1]='-';
   o.zparm[2]='z';
   o.zparm[3]='"';

   srand( (unsigned)time(NULL));    // seed random number generator

   for(i=1;i<argc;i++) {
      if ( (*argv[i] == '/') || (*argv[i] == '-'))
         do_option(argv[i]);
      else
         do_file(argv[i]);
   }
   if ( (o.encrypt==0) && (o.decrypt==0) ) {
      help();
      exit(1);
   }
   if (!o.something) {
      printf("Nothing to Do!\n");
      exit(1);
   }
   exit(0);

}  // end of main()


void banner()
{
   printf("\nMPGP  ver 1.0 (9/14/95)   by Mark T. Anderson <mta@clark.net>\n\n");

}  // end of banner()



void help()
{
      printf("Usage: MPGP -option(s)  file1 [file2..] (Wildcards accepted)\n");
      printf("options: \n");
      printf("         -e Encrypt file(s)\n");
      printf("         -r Randomize names of encrypted files, keeping .PGP extension\n");
      printf("         -d Decrypt files(s)\n");
      printf("         -k Keep file(s) after processing (default is to delete)\n");
      printf("\n");

}  // end of help()


void do_option(char *s)
{
   extern struct options o;
   size_t i;
   if (o.locked)
      return;

   strupr(s);

   for (i=1;i<strlen(s);i++) {

      if ( s[i] == 'D') {
         o.decrypt=1;
         o.encrypt=0;
         o.randomize=0;   // disallow randomize && decrypt
      }

      else if ( s[i] == 'K') {
         o.keep=1;
      }

      else if ( s[i] == 'R') {
         o.decrypt=0;     // disallow randomize && decrpyt
         o.randomize=1;
      }

      else if ( s[i] == 'E') {
         o.decrypt=0;
         o.encrypt=1;
      }
   } // end of for()

}  // end of do_option()



void do_file (char *fullname)
{
   extern struct options o;

   char drive[_MAX_DRIVE], dir[_MAX_DIR];
   char fname[_MAX_FNAME], ext[_MAX_EXT];
   char rname[_MAX_FNAME];
   char pathold[_MAX_PATH];
   char pathnew[_MAX_PATH];
   char buff[35];
   int ret;

   o.locked = 1;  // disallow further options on command line

      _splitpath( fullname, drive, dir, fname, ext );

      if (o.encrypt) {
         if (stricmp(".PGP",ext) == 0)
            return;

         if (exist(fullname,NORM_FILE)) {
            fetch_password();  // aborts if invalid password
            o.something=1;
            if (o.keep)
               ret=spawnlp(P_WAIT,"pgp.exe","mpgp","-c",o.zparm,fullname,NULL);
            else
               ret=spawnlp(P_WAIT,"pgp.exe","mpgp","-c",o.zparm,"-w",fullname,NULL);

            if (ret== -1)
               no_exec();      // no_exec() exits to DOS
            o.ret=max(o.ret,ret);
            if (ret) {
               printf("Error encrypting %s   PGP returned %i\n",fullname,ret);
               return;
            }


            if (o.randomize) {

again:         itoa((rand() &0x00ff),buff,16);
               lead_zero(buff,2);
               strcpy(rname,buff);

               itoa((rand() &0x00ff),buff,16);
               lead_zero(buff,2);
               strcat(rname,buff);

               itoa((rand() &0x00ff),buff,16);
               lead_zero(buff,2);
               strcat(rname,buff);

               itoa((rand() &0x00ff),buff,16);
               lead_zero(buff,2);
               strcat(rname,buff);

               strupr(rname);
               _makepath(pathold,drive,dir,fname,".PGP");
               _makepath(pathnew,drive,dir,rname,".PGP");
               if (exist(pathnew,ALL_FILES)) {
                  srand( (unsigned)time(NULL));  // seed random number generator
                  goto again;                    // real C programmers are not 
                                                 // afraid to use goto

               }

               printf("renaming %s to %s\n\n\n",pathold,pathnew);
               rename(pathold,pathnew);

            }  // end of if (o.randomize)
         } // end of if (exist)
      }  // end of if (o.encrypt)

      else if (o.decrypt) {
         if (stricmp(".PGP",ext) != 0)
            return;
         if (exist(fullname,NORM_FILE)) {
            fetch_password();  // aborts if invalid password
            o.something=1;
            ret=spawnlp(P_WAIT,"pgp.exe","mpgp",o.zparm,"-p",fullname,NULL);

            if (ret == -1)
               no_exec();
            o.ret=max(o.ret,ret);
            if (ret) {
               printf("Error Decrypting %s PGP returned %i\n",fullname,ret);
               return;
            }
            if (!o.keep) {
               printf("Deleting %s\n\n\n",fullname);
               unlink(fullname);
            }  // end of if (!o.keep)

         }  // end of if (exist(fullname))

      }  // end of else if (o.decrypt)



}  //end of do_file()


int exist(char *fname,int attr)   // returns true if file exists, false if not
{

   _asm{
      mov ah,4eh   ; search for first match
      mov cx,attr  ;either 0 or 1eh .. norm files or all files
      mov dx,fname
      int 21h
      jc no_file
   }
   return 1;
no_file:
   return 0;

}  // end of exist()



void fetch_password()
{
   extern struct options o;
   char *pc;
   int i;

   if (o.pass_fetched)
      return;

   if (o.decrypt) {
      printf("\nEnter Passphrase: ");

      pc=o.pass1;
      for (i=0;i<257;i++) {
         if ( ((int)*pc=getch()) != 0x0d )
            pc++;
         else {
            *pc=0;
            break;
         }
      }
      *pc=0;

      printf("\n\n");

      if (o.pass1[0]==0) {
         printf("\nEmpty passphrase... Aborting\n\n");
         exit(1);
      }

      if (strchr(o.pass1,0x22) != NULL) {

         printf("\nIllegal character in passphrase... Aborting\n\n");
         exit (1);
      }
      strcat(o.pass1,"\x22");
      o.pass_fetched=1;
      return;
   }  // end of if (o.decrypt)

   if (o.encrypt)  {
      printf("\nEnter   Passphrase: ");

      pc=o.pass1;
      for (i=0;i<257;i++) {
         if ( ((int)*pc=getch()) != 0x0d )
            pc++;
         else {
            *pc=0;
            break;
         }
         *pc=0;
      }

      printf("\nReenter Passphrase: ");

      pc=o.pass2;
      for (i=0;i<257;i++)
      if (((int)*pc = getch()) != 0x0d )
         pc++;
      else {
         *pc=0;
         break;
      }
      *pc=0;

      printf("\n\n");

      if (strcmp(o.pass1,o.pass2) == 0) {

         if (o.pass1[0]==0) {
            printf("\nEmpty passphrase... Aborting\n\n");
            exit (1);
         }

         pc=o.pass2;
         for (i=0;i< sizeof o.pass2;i++)
            *(pc++)=0;


         if (strchr(o.pass1,0x22) != NULL) {

            printf("\nIllegal character in passphrase... Aborting\n\n");
            exit (1);
         }

         strcat(o.pass1,"\x22");
         o.pass_fetched=1;
         return;
      }
      else {
         printf("\nPassphrases did not match.. Aborting...\n");
         exit (1);
      }

   }  // end of if(o.encrypt)

}  // end of fetch_password()



void lead_zero(char *s,unsigned int cnt)
{
   char tmp[40];

   while (strlen(s) <cnt) {
      strcpy(tmp,s);
      strcpy(s,"0");
      strcat(s,tmp);
   }

}  // end of lead_zero()



void cleanup(void)
{
   int i;
   char *pc;
   char tmp[512];
   pc = (char *) &o;
   for (i=0;i<sizeof(o);i++)
      *(pc++)=0;
   for (i=0;i< sizeof(tmp);i++)
      tmp[i]=0;

}  // end of cleanup()


void no_exec(void) {

   switch (errno) {

      case ENOENT:
         printf("PGP.EXE not found.. Aborting\n");
         exit(errno);
         break;
      case ENOEXEC:
         printf("PGP.EXE not executable.. Aborting\n");
         exit(errno);
         break;
      case ENOMEM:
         printf("Not enough memory to run PGP.EXE.. Aborting\n");
         exit(errno);
         break;
      default:
         printf("Undefined error executing PGP.EXE.. errno %i Aborting\n",errno);
         exit(errno);
         break;
   } //end of switch(errno)

}  // end of no_exec();



// end of MPGP.C

