
class Mode {

/**
 * Cipher we are running in a mode
 */
BlockTransformation cipher;
/**
 * Block size of cipher
 */
int S;
/**
 * Feedback register, holds ciphertext
 */
byte reg[];
/**
 * XOR buffer, holds encrypted ciphertext
 */
byte buffer[];


/**
 * Initialize a new object for encrypting in a mode.
 * @param cipher underlying cipher to run
 * @param IV initial vector
 */
public Mode(BlockTransformation cipher, byte IV[], int IVoff)
{
    this.cipher = cipher;
    S = cipher.blockSize();
    reg = new byte[2*S];
    buffer = new byte [S];
    System.arraycopy(IV, IVoff, reg, 0, S);
}


} // Mode


public class Feedback extends Mode {

/**
 * Feedback byte size
 */
int FBS;

/**
 * Feedback byte counter
 */
int counter;


public Feedback (BlockTransformation cipher, byte IV[], int IVoff, int fbs)
{
    super(cipher, IV, IVoff);
    FBS = (fbs!=0) ? fbs : S;
    cipher.processBlock(reg, 0, buffer, 0);
}

public void doFeedback()
{
    if (FBS!=0) {
	for (int i=0; i<(S-FBS); i++)
	    reg[i] = reg[FBS+i];
    }
    System.arraycopy(buffer, 0, reg, S-FBS, FBS);
    cipher.processBlock(reg, 0, buffer, 0);
    counter = 0;
}


} // FeedBack


