public class CFBEncryption extends Feedback {

public CFBEncryption (BlockTransformation cipher, byte IV[], int IVoff)
{
    this(cipher, IV, IVoff, 0);
}

public CFBEncryption (BlockTransformation cipher, byte IV[], int IVoff,
                      int feedBackSize)
{
    super(cipher, IV, IVoff, feedBackSize);
}

public byte processByte(byte input)
{
    if (counter==FBS)
        doFeedback();
    buffer[counter] ^= input;
    return buffer[counter++];
}

public void processBytes(byte input[])
{
    processBytes(input, 0, input.length);
}

public void processBytes(byte input[], int off, int len)
{
    for (int i=0; i<len; ++i) {
        if (counter==FBS)
            doFeedback();
        buffer[counter] ^= input[i+off];
        input[i+off] = buffer[counter++];
    }
}


public void sync()
{
    if (counter!=0)
    {
        for (int i=0; i<counter; i++)
            buffer[S-counter+i] = buffer[i];
        System.arraycopy(reg, counter, buffer, 0, S-counter);
        doFeedback();
    }
}


} // CFBEncryption


