/* argvfactory.c - Creating argv vectors
 *      Copyright (C) 1999 Michael Roth <mroth@nessie.de>
 *
 * This file is part of pgpgpg.
 *
 * pgpgpg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * pgpgpg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */



#include "includes.h"
#include "argvfactory.h"




void argv_factory_init(ArgvFactory *af)
{
    assert(af != NULL);
    af->size = 64;
    af->used = 0;
    af->argv = (char **)malloc(af->size * sizeof(char *));
    assert(af->argv != NULL);
    *af->argv = NULL;
}



void argv_factory_release(ArgvFactory *af)
{
    assert(af != NULL);
    assert(af->argv != NULL);
    assert(af->used+1 <= af->size);
    assert(af->argv[af->used] == NULL);
    
    free(af->argv);
}


void argv_factory_add(ArgvFactory *af, char *arg)
{
    assert(af != NULL);
    assert(af->argv != NULL);
    assert(af->used+1 <= af->size);
    assert(af->argv[af->used] == NULL);
    assert(arg != NULL);
    
    if (af->used + 1 == af->size)
    {
        af->size *= 2;
        af->argv = realloc(af->argv, af->size * sizeof(char *));
        assert(af->argv != NULL);
    }
    
    af->argv[af->used++] = strdup(arg);
    af->argv[af->used] = NULL;
}



