/* pggtest.h - common functions and macros for tests
 *      Copyright (C) 1999 Michael Roth <mroth@gnupg.org>
 *
 * This file is part of PGG (Privacy Guard Glue).
 *
 * PGG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PGG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#ifndef PGG_INCLUDE_PGGTEST_H_19990623
#define PGG_INCLUDE_PGGTEST_H_19990623


#include <includes.h>
#include <pgg.h>


PggErrenv	errenv;


#define expect_success() ((void)({			\
	if (pgg_errenv_is_set(errenv))			\
		exit(1);				\
	}))

#define expect_failure() ((void)({			\
	if (!pgg_errenv_is_set(errenv))			\
		exit(1);				\
	else						\
		pgg_errenv_reset(errenv);		\
	}))


#define expect_error(error, suberr) ((void)({		\
	if (pgg_errenv_get_error(errenv)		\
	    != PGG_ERROR_##error ||			\
	    pgg_errenv_get_suberr(errenv)		\
	    != PGG_SUBERR_##suberr)			\
		exit(1);				\
	else						\
		pgg_errenv_reset(errenv);		\
	}))


#define INIT_STD_TEST(type, typeprefix)			\
	type typeprefix;				\
	pgg_errenv_reset(errenv);			\
	typeprefix = pgg_##typeprefix##_new(errenv);	\
	expect_success();


#define STD_REFCOUNT_TEST(type, name)			\
	int main() {					\
	type clone;					\
	INIT_STD_TEST(type, name)			\
	pgg_##name##_addref(name, errenv);		\
	expect_success();				\
	clone = pgg_##name##_clone(name, errenv);	\
	expect_success();				\
	pgg_##name##_release(name, errenv);		\
	pgg_##name##_release(name, errenv);		\
	expect_success();				\
	pgg_##name##_release(name, errenv);		\
	expect_failure();				\
	pgg_##name##_addref(clone, errenv);		\
	pgg_##name##_release(clone, errenv);		\
	pgg_##name##_release(clone, errenv);		\
	expect_success();				\
	pgg_##name##_release(clone, errenv);		\
	expect_failure();				\
	return 0; }
	

#endif



