/* input-2.test.c - garbage tests for PggInput
 *      Copyright (C) 1999 Michael Roth <mroth@gnupg.org>
 *
 * This file is part of PGG (Privacy Guard Glue).
 *
 * PGG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PGG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#include <pggtest.h>


#define check()		expect_error(OBJECT, MAGIC)


int main()
{
    PggInput		garbage = (PggInput) "This is garbage";
    
    pgg_errenv_reset(errenv);
    
    pgg_input_clone(garbage, errenv);
    check();
    
    pgg_input_addref(garbage, errenv);
    check();
    
    pgg_input_release(garbage, errenv);
    check();
    
    pgg_input_set_filename(garbage, NULL, errenv);
    check();
    
    pgg_input_set_buffer(garbage, NULL, errenv);
    check();
    
    pgg_input_set_fd(garbage, -1, errenv);
    check();
    
    pgg_input_set_rawdata(garbage, NULL, 0, errenv);
    check();
    
    pgg_input_open(garbage, errenv);
    check();
    
    pgg_input_read(garbage, NULL, 0, errenv);
    check();
    
    pgg_input_close(garbage, errenv);
    check();
    
    return 0;
}


