/* config-2.test.c - garbage tests for PggConfig
 *      Copyright (C) 1999 Michael Roth <mroth@gnupg.org>
 *
 * This file is part of PGG (Privacy Guard Glue).
 *
 * PGG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PGG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#include <pggtest.h>


#define check()	expect_error(OBJECT, MAGIC)


int main()
{
    PggConfig		garbage = (PggConfig) "This is simple garbage.";
    
    pgg_errenv_reset(errenv);
    
    pgg_config_clone(garbage, errenv);
    check();
    
    pgg_config_addref(garbage, errenv);
    check();
    
    pgg_config_release(garbage, errenv);
    check();
    
    pgg_config_get_gpgpath(garbage, errenv);
    check();
    
    pgg_config_set_gpgpath(garbage, NULL, errenv);
    check();
    
    pgg_config_search_gpg(garbage, NULL, errenv);
    check();
    
    pgg_config_set_configfile(garbage, NULL, errenv);
    check();
    
    pgg_config_get_configfile(garbage, errenv);
    check();
    
    pgg_config_set_public_keyring(garbage, NULL, errenv);
    check();
    
    pgg_config_get_public_keyring(garbage, errenv);
    check();
    
    pgg_config_set_secret_keyring(garbage, NULL, errenv);
    check();
    
    pgg_config_get_secret_keyring(garbage, errenv);
    check();
    
    pgg_config_set_trustdb(garbage, NULL, errenv);
    check();
    
    pgg_config_get_trustdb(garbage, errenv);
    check();
    
    pgg_config_setup_exe(garbage, NULL, errenv);
    check();
    
    return 0;
}


