/* buffer-2.test.c - basic reference counting test for PggBuffer
 *      Copyright (C) 1999 Michael Roth <mroth@gnupg.org>
 *
 * This file is part of PGG (Privacy Guard Glue).
 *
 * PGG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PGG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#include <pggtest.h>


#define check()		expect_error(OBJECT, MAGIC)


int main()
{
    PggBuffer		garbage = (PggBuffer) "This is garbage";
    
    pgg_errenv_reset(errenv);
    
    pgg_buffer_clone(garbage, errenv);
    check();
    
    pgg_buffer_addref(garbage, errenv);
    check();
    
    pgg_buffer_release(garbage, errenv);
    check();
    
    pgg_buffer_reclaim(garbage, errenv);
    check();
    
    pgg_buffer_append(garbage, NULL, 0, errenv);
    check();
    
    pgg_buffer_insert(garbage, 0, NULL, 0, errenv);
    check();
    
    pgg_buffer_delete(garbage, 0, 0, errenv);
    check();
    
    pgg_buffer_clear(garbage, errenv);
    check();
    
    pgg_buffer_set_size(garbage, 0, errenv);
    check();
    
    pgg_buffer_set_wipeout(garbage, 0, errenv);
    check();
    
    pgg_buffer_set_maxsize(garbage, 0, errenv);
    check();
    
    pgg_buffer_ensure_capacity(garbage, 0, errenv);
    check();
    
    pgg_buffer_get_maxsize(garbage, errenv);
    check();
    
    pgg_buffer_get_capacity(garbage, errenv);
    check();
    
    pgg_buffer_get_size(garbage, errenv);
    check();
    
    pgg_buffer_get_data(garbage, errenv);
    check();
    
    pgg_buffer_detach_data(garbage, errenv);
    check();
    
    pgg_buffer_atach_data(garbage, NULL, 0, errenv);
    check();
    
    return 0;
}



