/* pggdebug.h - macros used for debugging
 *      Copyright (C) 1999 Michael Roth <mroth@gnupg.org>
 *
 * This file is part of PGG (Privacy Guard Glue).
 *
 * PGG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PGG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#ifndef PGG_INCLUDE_PGGDEBUG_H_19990608123710
#define PGG_INCLUDE_PGGDEBUG_H_19990608123710


#ifndef NDEBUG
#define PGG_DEBUG(args)				((void)({pgg_debug_log_header(__FUNCTION__, __FILE__, __LINE__); \
							pgg_debug_log_body args; \
							pgg_debug_log_footer();}))
#else
#define PGG_DEBUG(args)				((void)0)
#endif


#define PGG_RETURN_ERR(err, suberr)		((void)({PGG_DEBUG(("error: %s suberr: %s", #err, #suberr)); pgg_errenv_set(errenv, PGG_ERROR_##err, PGG_SUBERR_##suberr); return;}))
#define PGG_RETURN_ERR_ARG(err, suberr, arg)	((void)({PGG_DEBUG(("error: %s suberr: %s", #err, #suberr)); pgg_errenv_set(errenv, PGG_ERROR_##err, PGG_SUBERR_##suberr); return (arg);}))


#define PGG_ASSERT(condition, err, suberr)	\
						((void)({if (!(condition)) {PGG_DEBUG(("assertion failed: %s", #condition)); PGG_RETURN_ERR(err, suberr);} }))

#define PGG_ASSERT_ARG(condition, err, suberr, arg) \
						((void)({if (!(condition)) {PGG_DEBUG(("assertion failed: %s", #condition)); PGG_RETURN_ERR_ARG(err, suberr, arg);} }))

#define PGG_ASSERT_OBJECT(type, objptr)		((void)({PGG_ASSERT(objptr, OBJECT, NULLOBJ); \
							 PGG_ASSERT(objptr->magic == type##MAGIC, OBJECT, MAGIC); \
							 PGG_ASSERT(objptr->refcounter > 0, OBJECT, REFCOUNT);}))

#define PGG_ASSERT_OBJECT_ARG(type, objptr, arg) \
						((void)({PGG_ASSERT_ARG(objptr, OBJECT, NULLOBJ, arg); \
							 PGG_ASSERT_ARG(objptr->magic == type##MAGIC, OBJECT, MAGIC, arg); \
							 PGG_ASSERT_ARG(objptr->refcounter > 0, OBJECT, REFCOUNT, arg);}))

#define PGG_CHECK_SKIP()			((void)({if (errenv && errenv->error != PGG_ERROR_SUCCESS) return;}))

#define PGG_CHECK_SKIP_ARG(arg)			((void)({if (errenv && errenv->error != PGG_ERROR_SUCCESS) return (arg);}))

#define PGG_STD_ASSERT(type, objptr)		((void)({PGG_CHECK_SKIP(); PGG_ASSERT_OBJECT(type, objptr);}))

#define PGG_STD_ASSERT_ARG(type, objptr, arg)	((void)({PGG_CHECK_SKIP_ARG(arg); PGG_ASSERT_OBJECT_ARG(type, objptr, arg);}))


extern void pgg_debug_log_header(const char *func, const char *file, int line);
extern void pgg_debug_log_body(const char *fmt, ...);
extern void pgg_debug_log_footer();

#endif


