#include <stdlib.h>
#include <rand.h>
#include "libopgp.h"

#define BSZ 8
/*------------------------------------*/
void PGP_cenc(FILE * inf, FILE * outf, void *cfbdat)
{
  UCHAR dbuf[4300], *bp;
  int j, k;

  fputc(0xc9, outf);            /* conventional encryption packet */
  bp = &dbuf[1];                /* special PGP iv header */
  dbuf[0] = 0xec;
  RAND_bytes(bp, BSZ);
  bp[BSZ] = bp[BSZ - 2], bp[BSZ + 1] = bp[BSZ - 1];
  PGP_cblk(bp, BSZ + 2, cfbdat);
  PGP_cres(&bp[2], cfbdat);     /* PGP special restart */
  bp += BSZ + 2;
  j = BSZ + 2;
  for (;;) {                    /* packetize and encrypt */
    if (0 > (k = fread(bp, 1, 4096 - j, inf)))
      exit(-2);
    PGP_cblk(bp, k, cfbdat);
    j += k;
    if (j != 4096)
      break;
    fwrite(dbuf, 1, 4097, outf);
    j = 0;
    bp = &dbuf[1];
  }
  if (j > 192) {
    fputc(0xc0 | ((j - 192) >> 8), outf);
    dbuf[0] = j - 192;
  } else
    dbuf[0] = j;
  fwrite(dbuf, 1, j + 1, outf);
  free(cfbdat);
}
