#include <stdio.h>
#include <string.h>

#include <bn.h>

typedef unsigned long long keyid_t;
#define ANY_KEY 0ULL
#define NEXT_KEY 0xffffffffffffffffULL

#define UCHAR unsigned char

/* armor */
extern unsigned long PGP_crc24t[256];
int PGP_armor(FILE *, FILE *, char *, char *);
int PGP_dearmor(FILE *, FILE *);

/* top decrypt/encrypt */
void PGP_encry(FILE *, FILE *, int e, int c, keyid_t k[], int ca, char *pp[]);
int PGP_decry(FILE * inf, FILE * outf, UCHAR * keybuf);
/* public key encrypt/decrypt */
int PGP_pkenc(keyid_t, UCHAR *, UCHAR *, int);
int PGP_pkdec(UCHAR *, UCHAR *);
/* symmetric encrypt/decrypt */
void PGP_cenc(FILE * inf, FILE * outf, void *);
int PGP_cdec(FILE * inf, FILE * outf, void *x[], int);

/* (de)compression */
int PGP_unzip(FILE * inf, FILE * outf);
int PGP_zip(FILE * inf, FILE * outf, int v2flg);

/* top literal and signature */
int PGP_delcs(FILE * inf, FILE * outf, int *, UCHAR *);
int PGP_elsgm(FILE *, FILE *, char *n, int s, int t, int h, keyid_t, char *pp);
/* signature */
int PGP_sigmk(void *, void *, char *, keyid_t, int, int, int, UCHAR *);
int PGP_sigck(UCHAR * sigp, void *hctx);

/* keyring/keypacket suport */
extern FILE *PGP_ringf;
extern UCHAR PGP_keypfx[3];
BIGNUM *PGP_mpiBN(UCHAR ** buf);
keyid_t PGP_gkid(UCHAR *, int);
FILE *PGP_kring(char *file);
int PGP_gtkey(void **, UCHAR *, keyid_t *);
int PGP_wrkey(UCHAR * buf, void *key, int sec, int pri, int alg, UCHAR * pp,
              char *uid);

/* passphrase to cfbsym context */
int PGP_gts2k(UCHAR ** bp, UCHAR * hashpass, void **);
int PGP_wrs2k(UCHAR *, const UCHAR *, UCHAR, void **);
void PGP_khash(int, int, int, int, UCHAR *, UCHAR *);

/* hashing */
extern unsigned int PGP_hlen[];
extern unsigned int PGP_hpfxlen[];
extern UCHAR PGP_hpfx[][64];
void *PGP_hini(int ha);
void PGP_hblk(void *ctx, UCHAR *, unsigned int);
void PGP_hfin(UCHAR * buf, void *ctx);

/* symcfb support */
int PGP_cksz(const int cipher);
void *PGP_cini(UCHAR * key, const UCHAR * iv0, int cip, int enc);
void PGP_cblk(UCHAR * buf, int len, void *);
void PGP_cres(const UCHAR *, void *);

/* packet support */
unsigned int PGP_nxpkt(int *neof, FILE * inf);
void *PGP_gtpkt(FILE *, UCHAR ctb, int *gazouta);
void PGP_xctb(FILE * inf, FILE * outf);
