#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "libopgp.h"

int PGP_gtblk(UCHAR * buf, int get, int *len, int *eneof, FILE * inf)
{
  unsigned int neof = *eneof, ll = *len;

  while (get) {
    if (get < ll) {
      ll -= get;
      if (get != fread(buf, 1, get, inf))
        exit(-2);
      break;
    }
    get -= ll;
    if (ll != fread(buf, 1, ll, inf))
      exit(-2);
    buf += ll;
    ll = 0;
    if (!neof)
      return -1;
    ll = PGP_nxpkt(&neof, inf);
  }
  *len = ll;
  *eneof = neof;
  return 0;
}

#define RBSIZ 10000
/* doesn't do nested signatures */
int PGP_delcs(FILE * inf, FILE * outf, int *sigret, UCHAR * sugfile)
{
  UCHAR dbuf[RBSIZ], *sigbuf = NULL, *bp, xch = 0;
  unsigned int halg, i, k, ll = 0, neof = 0;
  void *hctx = NULL;

  /* skip2ctb5 (and checksig) */
  *sigret = 0;
  halg = 0;
  /* skip to literal */
  while (!feof(inf) && xch != 0xcb && (xch & 0xfc) != 0xac) {
    xch = fgetc(inf);
    if ((xch & 0xfc) == 0x88) {
      sigbuf = PGP_gtpkt(inf, xch, NULL);
      halg = sigbuf[16];        /* grab algorithm */
    } else if (xch != 0xcb && (xch & 0xfc) != 0xac) {
      if (!(bp = PGP_gtpkt(inf, xch, NULL)))
        return -3;
      if (xch == 0xc4)          /* one pass sig header */
        halg = bp[2];           /* grab algorithm */
      free(bp);
    }
  }
  if (xch != 0xcb && (xch & 0xfc) != 0xac)
    return -1;

  /* literal - get first length and bypass header */
  if (xch == 0xcb)
    ll = PGP_nxpkt(&neof, inf);
  else {
    i = 1 << (xch & 3);         /* length of length */
    for (k = 0, ll = 0; k < i; k++)
      ll = (ll << 8) + fgetc(inf);
  }
  if (PGP_gtblk(dbuf, 2, &ll, &neof, inf))
    return -5;
  xch = dbuf[1];                /* len of suggested fname */
  if (PGP_gtblk(sugfile ? sugfile : dbuf, xch, &ll, &neof, inf))
    return -5;
  if (sugfile)
    sugfile[xch] = 0;
  if (PGP_gtblk(dbuf, 4, &ll, &neof, inf))
    return -5;

  *sigret = halg;
  /* pass through and optionally hash */
  if (halg)
    hctx = PGP_hini(halg);

  while (ll) {
    if (0 >= (k = fread(dbuf, 1, ll > RBSIZ ? RBSIZ : ll, inf)))
      exit(-2);
    ll -= k;
    fwrite(dbuf, 1, k, outf);
    if (halg)
      PGP_hblk(hctx, dbuf, k);
    if (!ll && neof)
      ll = PGP_nxpkt(&neof, inf);
  }

  if (!halg)
    return 0;
  if (!sigbuf) {
    i = fgetc(inf);
    if ((i & 0xfc) != 0x88 && i != 0xc2)
      return -1;
    sigbuf = PGP_gtpkt(inf, i, NULL);
  }
  k = PGP_sigck(sigbuf, hctx);
  free(sigbuf);
  return k;
}
