#include <stdio.h>
#include <string.h>
#include "libopgp.h"

unsigned char PGP_dmtab[84] =
{0xff, 0xff, 0xff, 0x3e, 0xff, 0x41, 0xff, 0x3f, 0x34, 0x35, 0x36, 0x37,
 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0xff, 0xff, 0xff, 0x40, 0xff, 0xff,
 0xff, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a,
 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16,
 0x17, 0x18, 0x19, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1a, 0x1b, 0x1c,
 0x1d, 0x1e, 0x1f, 0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28,
 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31, 0x32, 0x33, 0xff};

/*-------------------------*/
/* called by dearmor, with NULL ofd to get crc */
static unsigned char dabuf[256], *dabp;
long PGP_unb64(FILE * ifd, FILE * ofd)
{
  unsigned char obuf[800], *c = obuf;
  int i = 3, ocnt = 0, j;
  unsigned long t, ccrc = 0xB704CE;

  dabuf[0] = 0;
  while (i == 3) {
    for (i = 0; i < 4; i++) {
      while (!(j = *dabp++) || j > 124 || j < 40
             || (c[i] = PGP_dmtab[j - 40]) > 65)
        if (!j && !fgets(dabp = dabuf, 255, ifd))
          return -1;
      if (c[i] < 64)
        continue;
      if (ofd)
        break;
      i--;
    }
    t = (c[0] << 18) | (c[1] << 12) | (c[2] << 6) | c[3];
    if (!ofd)
      return t;
    c[0] = t >> 16, c[1] = t >> 8, c[2] = t;
    i -= (i > 1);
    c += i, ocnt += i;
    if (i != 3 || ocnt > 768) {
      for (t = 0; t < ocnt; t++)
        ccrc = ccrc << 8 ^ PGP_crc24t[0xff & ((ccrc >> 16) ^ obuf[t])];
      fwrite(obuf, 1, ocnt, ofd);
      c = obuf, ocnt = 0;
    }
  }
  return ccrc & 0xffffff;
}

/*-------------------------*/
/* dearmor - should also return cert type and headers... */
int PGP_dearmor(FILE * ifd, FILE * ofd)
{
  while (!feof(ifd)) {
    fgets(dabuf, 255, ifd);
    if (strncmp(dabuf, "-----BEGIN PGP ", 15) ||
        !strncmp(dabuf, "-----BEGIN PGP SIGNED MESSAGE-----", 34))
      continue;                 /* skip to message */
    while (dabuf[0] != '\n' && dabuf[0] != '\r')
      fgets(dabuf, 255, ifd);
    dabp = dabuf;
    if (PGP_unb64(ifd, ofd) != PGP_unb64(ifd, NULL))
      return -1;
    /* scan past -----END ? */
  }
  return 0;
}
