#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include "libopgp.h"
#include <rsa.h>
#include <dh.h>
#include <dsa.h>

/*------------------------------------*/
int main(int argc, char *argv[])
{
  unsigned char buf[4096], uid[1024], match[256], *bp, t, keybuf[4096];
  unsigned long i, j, ll, dhflg = 0, dsaflg = 0, gotkey = 0, kblen = 0;
  int gaz;
  DSA *dsakey = DSA_new();
  DH *dhkey = DH_new();
  keyid_t dsakid = 0, dhkid = 0;
  FILE *outf = stdout;
  extern char *optarg;
#ifndef NO_RSA
  RSA *rsakey = RSA_new();
#endif

  match[0] = 0;
  while ((i = getopt(argc, argv, "o:m:r:esuxyz")) != -1) {
    if (i == 'm')
      strncpy(match, optarg, 256);
    else if (i == 'e')
      dhflg = 1;
    else if (i == 'x')
      dhflg = 2;
    else if (i == 'y')
      dhflg = 3;
    else if (i == 'z')
      dhflg = 4;
    else if (i == 'u')
      dhflg = 5, gotkey = 1;
    else if (i == 's')
      dsaflg = 1;
    else if (i == 'r')
      PGP_ringf = fopen(optarg, "rb");
    else if (i == 'o') {
      outf = fopen(optarg, "wb");
      if (outf == NULL)
        exit(-1);
    } else {
      fprintf(stderr, "usage: lookup5 [-r ring] [-m \"User ID\"] [-e] [-s]\n"
        "-m provides a user string to match, will return all with substring\n"
              "unless used with -e or -s (which returns the first matching)\n"
              "-e for encryption key only, -s for sign key only\n"
              "-x extracts the key, -u uid, -y for revoke -z sign data\n");
      exit(-1);
    }
  }

  if (!PGP_ringf && (bp = getenv("PGPPATH"))) {  /* if no PGP_ringf, try PGPPATH */
    strncpy(buf, bp, 2000);
    strcat(buf, "/pubring.pkr");
    PGP_ringf = fopen(buf, "rb");
  }
  if (!PGP_ringf && (bp = getenv("HOME"))) {  /* no, try default from HOME */
    strncpy(buf, bp, 2000);
    strcat(buf, "/.pgp/pubring.pkr");
    PGP_ringf = fopen(buf, "rb");
  }
  if (!PGP_ringf)
    return -3;                  /* no keyring */

  for (;;) {
    t = fgetc(PGP_ringf);
    if (!(bp = PGP_gtpkt(PGP_ringf, t, &gaz)))
      break;
    gaz = gaz > 4095 ? 4095 : gaz;
    memcpy(buf, bp, gaz + 1);
    buf[gaz] = 0;
    free(bp);

    bp = buf;
    t = (t & 0x7c) >> 2;
    if (t == 2)                 /* sig */
      continue;
    else if (t == 12) {         /* validity */
      continue;
    } else if (t == 13) {       /* uid - should match */
      strcpy(uid, buf);

      if (strlen(match) && !strstr(uid, match)) {
        if (dhflg != 5)
          gotkey = 0;
        continue;
      }
      if (gotkey && dhflg > 1) {
        fwrite(keybuf, 1, kblen, outf);
        if (dhflg == 2)
          return 0;
        if (dhflg != 4)
          fputc(0xb4, outf),
            fputc(gaz, outf);
        fwrite(buf, 1, gaz, outf);
        return 0;
      }
      continue;
    } else if (t == 5 || t == 6 || t == 7 || t == 14) {  /* sec or pub key */
      j = *bp++;                /* vers */
      /* timestamp */
      ll = *bp++ << 24, ll += *bp++ << 16, ll += *bp++ << 8, ll += *bp++;
      if (j != 4)
        bp += 2;                /* old valid days */

      switch (*bp++) {
      case 17:
        dsakey->p = PGP_mpiBN(&bp);
        dsakey->q = PGP_mpiBN(&bp);  /* correct length */
        dsakey->g = PGP_mpiBN(&bp);
        dsakey->pub_key = PGP_mpiBN(&bp);
        dsakid = PGP_gkid(buf, bp - buf);


        if (dsaflg && dhflg >= 2) {
          gotkey++;
          if (dhflg == 5)
            continue;
          keybuf[0] = 0x99, keybuf[1] = (bp - buf) >> 8, keybuf[2] = bp - buf;
          memcpy(&keybuf[3], buf, bp - buf);
          kblen = bp + 3 - buf;
          continue;
        }
        break;
      case 16:
      case 20:
        dhkey->p = PGP_mpiBN(&bp);
        dhkey->g = PGP_mpiBN(&bp);
        dhkey->pub_key = PGP_mpiBN(&bp);
        dhkid = PGP_gkid(buf, bp - buf);

        if (strlen(match) && !strstr(uid, match))
          continue;

        if (dhflg >= 2) {
          gotkey++;
          if (dhflg == 5)
            continue;
          keybuf[0] = 0x99, keybuf[1] = (bp - buf) >> 8, keybuf[2] = bp - buf;
          memcpy(&keybuf[3], buf, bp - buf);
          kblen = bp + 3 - buf;

          fwrite(keybuf, 1, kblen, outf);

          if (dhflg == 3 || dhflg == 5)
            fputc(0xb4, outf),
              fputc(j, outf);
          if (dhflg > 2)
            fwrite(buf, 1, j, outf);
          if (dhflg == 2)
            return 0;
          continue;
        }
        if (!dsaflg && !dhflg) {
          fprintf(outf, "%016qX %016qX %s\n", dsakid, dhkid, uid);
          continue;
        } else if (dsaflg)
          fprintf(outf, "%016qX\n", dsakid);
        else if (dhflg == 1)
          fprintf(outf, "%016qX\n", dhkid);

        break;
#ifndef NO_RSA
      case 1:
      case 2:
      case 3:
        rsakey->n = PGP_mpiBN(&bp);
        rsakey->e = PGP_mpiBN(&bp);
        dsakid = PGP_gkid(buf, bp - buf);
        j = 64;
        dhkid = 0;
        while (j)
          dhkid = (dhkid << 1) + BN_is_bit_set(rsakey->n, --j);

        if (dhflg >= 2) {
          gotkey++;
          if (dhflg == 5)
            continue;
          keybuf[0] = 0x99, keybuf[1] = (bp - buf) >> 8, keybuf[2] = bp - buf;
          memcpy(&keybuf[3], buf, bp - buf);
          kblen = bp + 3 - buf;
          continue;
        }
        if (!dsaflg && !dhflg) {
          fprintf(outf, "%016qX %016qX %s\n", dsakid, dhkid, uid);
          continue;
        } else if (dsaflg)
          fprintf(outf, "%016qX\n", dsakid);
        else if (dhflg == 1)
          fprintf(outf, "%016qX\n", dhkid);

        break;
#endif
      }
      continue;
    }
    /* 1-pke 8-cmprs 9-cke 11-raw */
    else
      break;                    /* chunk that shouldn't be here */
  }
  return -4;                    /* not found */
}
